/*
 * Decompiled with CFR 0.152.
 */
package s3games.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import s3games.Controller;
import s3games.player.Player;

public class ControllerWindow
extends JFrame {
    Controller controller = null;
    Player.playerType[] playerTypes;
    String[] playerStrategies;
    String[][] strategyHeuristics;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JComboBox jComboBox3;
    private JComboBox jComboBox4;
    private JComboBox jComboBox5;
    private JComboBox jComboBox6;
    private JComboBox jComboBox7;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;

    public ControllerWindow() {
        this.initComponents();
    }

    public ControllerWindow(Controller c) {
        this.initComponents();
        this.controller = c;
        this.jComboBox5.setModel(new DefaultComboBoxModel<String>(c.getGameNames()));
        this.setItems();
    }

    public void gameFinished(int winner, int[] playerScores) {
        String info = "<html>";
        info = info + "Winner player: " + winner + " <br> Scores: <br>";
        for (int p = 0; p < playerScores.length; ++p) {
            info = info + "Player " + (p + 1) + ": " + playerScores[p] + "<br>";
        }
        info = info + "</html>";
        this.jLabel2.setText(info);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jTextField1 = new JTextField();
        this.jLabel6 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jComboBox5 = new JComboBox();
        this.jLabel9 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel10 = new JLabel();
        this.jComboBox6 = new JComboBox();
        this.jLabel11 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jTextField5 = new JTextField();
        this.jLabel14 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jComboBox4 = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jComboBox3 = new JComboBox();
        this.jComboBox7 = new JComboBox();
        this.jTextField4 = new JTextField();
        this.jLabel15 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButton3 = new JButton();
        this.jTextField6 = new JTextField();
        this.jLabel16 = new JLabel();
        this.jLabel3.setText("jLabel3");
        this.setDefaultCloseOperation(3);
        this.setTitle("Settings");
        this.setResizable(false);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jButton1.setText("PLAY");
        this.jButton1.setToolTipText("");
        this.jButton1.setPreferredSize(new Dimension(65, 31));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerWindow.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("LEARN");
        this.jButton2.setToolTipText("");
        this.jButton2.setActionCommand("LEARN! ");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerWindow.this.jButton2ActionPerformed(evt);
            }
        });
        this.jTextField1.setText("statistic.txt");
        this.jTextField1.setMaximumSize(new Dimension(134, 20));
        this.jTextField1.setPreferredSize(new Dimension(134, 20));
        this.jLabel6.setText("Save game statistic to:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Simulated game", "Real world game"}));
        this.jComboBox5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerWindow.this.jComboBox5ActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Select a game:");
        this.jTextField2.setText("StrategyXY.txt");
        this.jTextField2.setMaximumSize(new Dimension(133, 20));
        this.jTextField2.setPreferredSize(new Dimension(133, 20));
        this.jLabel10.setText("OR");
        this.jLabel11.setText("Save to:");
        this.jTextField3.setText("3");
        this.jLabel12.setFont(new Font("Tahoma", 0, 9));
        this.jLabel12.setText("Number of runs:");
        this.jLabel13.setFont(new Font("Tahoma", 0, 9));
        this.jLabel13.setText("Learn strategy type:");
        this.jTextField5.setText("1");
        this.jLabel14.setFont(new Font("Tahoma", 0, 9));
        this.jLabel14.setText("Number of runs:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabel10)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11, -2, 123, -2).addComponent(this.jLabel9).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton2, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField3, -2, 23, -2).addComponent(this.jLabel12))).addComponent(this.jLabel13).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextField1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBox5, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox1, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox6, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE)).addComponent(this.jTextField2, -2, 133, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14).addComponent(this.jTextField5, -2, 23, -2)))))).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox1, -2, -1, -2).addGap(26, 26, 26).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, -1, -2).addGap(58, 58, 58).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton1, -2, 31, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField5, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.jLabel10).addGap(10, 10, 10).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox6, -2, -1, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel1Layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.jButton2, -2, 31, -2)).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel12, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField3, -2, -1, -2))).addGap(12, 12, 12).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBackground(new Color(229, 237, 255));
        this.jComboBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerWindow.this.jComboBox4ActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Strategy for computer:");
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"Computer player", "Human player"}));
        this.jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerWindow.this.jComboBox2ActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Player number:");
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"1"}));
        this.jComboBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerWindow.this.jComboBox3ActionPerformed(evt);
            }
        });
        this.jComboBox7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerWindow.this.jComboBox7ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox7, -2, 139, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel8, GroupLayout.Alignment.LEADING).addComponent(this.jComboBox2, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox4, GroupLayout.Alignment.LEADING, -2, 139, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, 40, -2)))).addContainerGap(44, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(29, 29, 29).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7, -2, 20, -2).addComponent(this.jComboBox3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox7, -2, -1, -2).addGap(36, 36, 36)));
        this.jTextField4.setEditable(false);
        this.jTextField4.setText("100000");
        this.jTextField4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerWindow.this.jTextField4ActionPerformed(evt);
            }
        });
        this.jLabel15.setForeground(new Color(153, 153, 153));
        this.jLabel15.setText("Number of expanded nodes:");
        this.jLabel15.setToolTipText("");
        this.jPanel3.setBackground(new Color(255, 238, 216));
        this.jLabel5.setText("0");
        this.jLabel2.setText("no game played yet");
        this.jLabel1.setText("Previous game result:");
        this.jLabel4.setText("Num of games to run:");
        this.jLabel4.setToolTipText("");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(19, 19, 19).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, 24, -2)).addComponent(this.jLabel2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton3.setLabel("Control Robot");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerWindow.this.jButton3ActionPerformed(evt);
            }
        });
        this.jTextField6.setText("15000");
        this.jLabel16.setText("Running Time");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel16).addGap(55, 55, 55).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField6, GroupLayout.Alignment.TRAILING).addComponent(this.jTextField4, GroupLayout.Alignment.TRAILING))).addComponent(this.jButton3).addComponent(this.jLabel15)).addGap(34, 34, 34)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(1, 1, 1).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField4, -2, -1, -2).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField6, -2, -1, -2).addComponent(this.jLabel16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jComboBox5ActionPerformed(ActionEvent evt) {
        this.setItems();
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        int selectedPlayer = this.jComboBox3.getSelectedIndex();
        if (this.jComboBox2.getSelectedIndex() == 0) {
            this.jComboBox4.setEnabled(true);
            this.jComboBox4.setSelectedItem(this.playerStrategies[selectedPlayer]);
            this.jComboBox7.setEnabled(true);
            this.playerTypes[selectedPlayer] = Player.playerType.COMPUTER;
        } else {
            this.jComboBox4.setEnabled(false);
            this.jComboBox7.setEnabled(false);
            this.playerTypes[selectedPlayer] = Player.playerType.HUMAN;
        }
    }

    private void jComboBox3ActionPerformed(ActionEvent evt) {
        int selectedPlayer = this.jComboBox3.getSelectedIndex();
        if (this.playerTypes[selectedPlayer] == Player.playerType.COMPUTER) {
            this.jComboBox2.setSelectedIndex(0);
            this.jComboBox4.setSelectedItem(this.playerStrategies[selectedPlayer]);
        } else {
            this.jComboBox2.setSelectedIndex(1);
        }
    }

    private int getSelectedIndexStrategyForPlayer(String strategy) {
        String[] strategies = this.controller.getStrategiesForGame((String)this.jComboBox5.getSelectedItem());
        for (int i = 0; i < strategies.length; ++i) {
            if (!strategies[i].equals(strategy)) continue;
            return i;
        }
        return 0;
    }

    public String getStatisticFileName() {
        return this.jTextField1.getText();
    }

    public void setNumberOfRunsToGo(int n) {
        this.jLabel5.setText(n + "");
    }

    private String[] getSelectedHeuristics() {
        int numOfPlayers = this.playerTypes.length;
        String[] selectedHeuristics = new String[numOfPlayers];
        for (int i = 0; i < numOfPlayers; ++i) {
            selectedHeuristics[i] = this.strategyHeuristics[i][this.getSelectedIndexStrategyForPlayer(this.playerStrategies[i])];
        }
        return selectedHeuristics;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.controller.play((String)this.jComboBox5.getSelectedItem(), this.jComboBox1.getSelectedIndex() == 0 ? Player.boardType.SIMULATED : Player.boardType.REALWORLD, this.playerTypes, this.playerStrategies, this.getSelectedHeuristics(), Integer.parseInt(this.jTextField5.getText()));
    }

    private void jComboBox4ActionPerformed(ActionEvent evt) {
        String strategy;
        int selectedPlayer = this.jComboBox3.getSelectedIndex();
        this.playerStrategies[selectedPlayer] = strategy = (String)this.jComboBox4.getSelectedItem();
        String heuristic = this.strategyHeuristics[selectedPlayer][this.jComboBox4.getSelectedIndex()];
        this.jComboBox7.setSelectedItem(heuristic);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.controller.learn((String)this.jComboBox5.getSelectedItem(), this.jComboBox1.getSelectedIndex() == 0 ? Player.boardType.SIMULATED : Player.boardType.REALWORLD, this.playerTypes, this.playerStrategies, this.getSelectedHeuristics(), (String)this.jComboBox6.getSelectedItem(), this.jTextField2.getText(), Integer.parseInt(this.jTextField3.getText()));
    }

    private void jComboBox7ActionPerformed(ActionEvent evt) {
        int selectedPlayer = this.jComboBox3.getSelectedIndex();
        int selectedStrategy = this.jComboBox4.getSelectedIndex();
        this.strategyHeuristics[selectedPlayer][selectedStrategy] = (String)this.jComboBox7.getSelectedItem();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.controller.controlRobot();
    }

    private void jTextField4ActionPerformed(ActionEvent evt) {
    }

    public int getNumberOfNodesToExpand() {
        try {
            return Integer.parseInt(this.jTextField4.getText());
        }
        catch (NumberFormatException e) {
            System.out.println("Bad number format entered");
            return 100;
        }
    }

    public int getRunningTime() {
        try {
            return Integer.parseInt(this.jTextField6.getText());
        }
        catch (NumberFormatException e) {
            System.out.println("Bad number format entered");
            return 5000;
        }
    }

    private void setItems() {
        String gameName = (String)this.jComboBox5.getSelectedItem();
        this.jComboBox4.setModel(new DefaultComboBoxModel<String>(this.controller.getStrategiesForGame(gameName)));
        this.jComboBox6.setModel(new DefaultComboBoxModel<String>(this.controller.getLearnableStrategyTypesForGame(gameName)));
        this.jComboBox7.setModel(new DefaultComboBoxModel<String>(this.controller.getHeuristicsForGame(gameName)));
        int numOfPlayers = this.controller.getNumberOfPlayersForGame(gameName);
        String[] players = new String[numOfPlayers];
        for (int i = 1; i <= numOfPlayers; ++i) {
            players[i - 1] = Integer.toString(i);
        }
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(players));
        this.playerTypes = new Player.playerType[numOfPlayers];
        this.playerStrategies = new String[numOfPlayers];
        this.strategyHeuristics = new String[numOfPlayers][];
        Player.playerType pt = this.jComboBox2.getSelectedIndex() == 0 ? Player.playerType.COMPUTER : Player.playerType.HUMAN;
        String ps = (String)this.jComboBox4.getSelectedItem();
        String sh = (String)this.jComboBox7.getSelectedItem();
        for (int i = 0; i < numOfPlayers; ++i) {
            this.playerTypes[i] = pt;
            this.playerStrategies[i] = ps;
            this.strategyHeuristics[i] = new String[this.jComboBox4.getItemCount()];
            for (int j = 0; j < this.strategyHeuristics[i].length; ++j) {
                this.strategyHeuristics[i][j] = sh;
            }
        }
    }
}

