/*
 * Decompiled with CFR 0.152.
 */
package s3games.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import s3games.engine.Game;
import s3games.engine.GameSpecification;
import s3games.engine.GameState;
import s3games.engine.Location;
import s3games.engine.Move;
import s3games.gui.BoardCanvas;
import s3games.util.Switch;

public class GameWindow
extends JFrame {
    Game game;
    BoardCanvas boardCanvas;
    boolean repaint;
    ArrayList<String> outputTexts;
    String winner;
    int offsetX;
    boolean isSelectedElement;
    String selectedElementName;
    public Move lastMove;
    public final Object lastMoveReady;
    public boolean waitingForMove;
    public ArrayList<Move> allowedMoves;
    private Switch gameRuns;
    private Canvas canvas1;

    public GameWindow(Switch gameSwitch) {
        this.gameRuns = gameSwitch;
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                GameWindow.this.gameRuns.off();
                Object object = GameWindow.this.lastMoveReady;
                synchronized (object) {
                    GameWindow.this.lastMoveReady.notify();
                }
            }
        });
        this.boardCanvas = (BoardCanvas)this.canvas1;
        this.lastMoveReady = new Object();
        this.waitingForMove = false;
        this.outputTexts = null;
        this.repaint = true;
        this.isSelectedElement = false;
        this.winner = "";
    }

    public void showException(Exception e) {
        e.printStackTrace();
        JOptionPane.showMessageDialog(this, e.getMessage(), "Ops, we got a little problem", 0);
    }

    private void initComponents() {
        this.canvas1 = new BoardCanvas();
        this.setDefaultCloseOperation(2);
        this.setTitle("Board");
        this.setBounds(new Rectangle(0, 0, 0, 0));
        this.setPreferredSize(new Dimension(600, 600));
        this.setResizable(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GameWindow.this.formKeyPressed(evt);
            }
        });
        this.canvas1.setBackground(new Color(255, 255, 255));
        this.canvas1.setPreferredSize(new Dimension(600, 600));
        this.canvas1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GameWindow.this.canvas1MousePressed(evt);
            }
        });
        this.canvas1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GameWindow.this.canvas1KeyPressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.canvas1, -1, 634, Short.MAX_VALUE).addGap(152, 152, 152)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.canvas1, -1, 620, Short.MAX_VALUE));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canvas1MousePressed(MouseEvent evt) {
        block9: {
            if (!this.waitingForMove) break block9;
            GameSpecification gs = this.boardCanvas.gameSpec;
            GameState egs = this.boardCanvas.gState;
            Map<String, String> elements = egs.elementLocations;
            int x = evt.getX();
            int y = evt.getY();
            if (!this.isSelectedElement) {
                for (Map.Entry<String, String> entry : elements.entrySet()) {
                    String elementLoc = entry.getValue();
                    Location loc = gs.locations.get(elementLoc);
                    if (!gs.locationTypes.get((Object)loc.type).shape.isInside(x, y, loc.point) || !this.isElementAllowed(entry.getKey())) continue;
                    this.isSelectedElement = true;
                    this.selectedElementName = entry.getKey();
                    this.boardCanvas.setSelectedElement(this.selectedElementName);
                    return;
                }
            } else {
                String elementLoc = egs.elementLocations.get(this.selectedElementName);
                Location loc1 = gs.locations.get(elementLoc);
                if (gs.locationTypes.get((Object)loc1.type).shape.isInside(x, y, loc1.point)) {
                    this.isSelectedElement = false;
                    this.boardCanvas.setSelectedElement(null);
                } else {
                    for (Map.Entry<String, Location> entry : gs.locations.entrySet()) {
                        Location loc = entry.getValue();
                        if (!gs.locationTypes.get((Object)loc.type).shape.isInside(x, y, loc.point) || !this.isMoveAllowed(this.selectedElementName, entry.getKey())) continue;
                        this.isSelectedElement = false;
                        this.boardCanvas.setSelectedElement(null);
                        String fromLoc = egs.elementLocations.get(this.selectedElementName);
                        this.lastMove = new Move(fromLoc, entry.getKey(), this.selectedElementName, gs);
                        Object object = this.lastMoveReady;
                        synchronized (object) {
                            this.lastMoveReady.notify();
                            this.waitingForMove = false;
                        }
                        return;
                    }
                }
            }
        }
    }

    private boolean isElementAllowed(String element) {
        for (Move move : this.allowedMoves) {
            if (!element.equals(move.element)) continue;
            return true;
        }
        return false;
    }

    private boolean isMoveAllowed(String element, String toLocation) {
        for (Move move : this.allowedMoves) {
            if (!element.equals(move.element) || !toLocation.equals(move.to)) continue;
            return true;
        }
        return false;
    }

    private void formKeyPressed(KeyEvent evt) {
        if (Character.toLowerCase(evt.getKeyChar()) == 'r') {
            this.repaint = !this.repaint;
            this.repaint();
        }
    }

    private void canvas1KeyPressed(KeyEvent evt) {
        this.formKeyPressed(evt);
    }

    public void setGame(Game g, Switch gameRuns) {
        this.game = g;
        this.winner = "";
        this.isSelectedElement = false;
        GameSpecification gs = this.game.gameSpecification;
        try {
            BufferedImage bgImage = ImageIO.read(new File(gs.boardBackgroundFileName));
            this.setSize(((Image)bgImage).getWidth(this) + 132, ((Image)bgImage).getHeight(this) + 30);
            this.offsetX = ((Image)bgImage).getWidth(this) + 12;
            this.boardCanvas.setSize(new Dimension(((Image)bgImage).getWidth(this), ((Image)bgImage).getHeight(this)));
        }
        catch (IOException ex) {
            Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.boardCanvas.setGame(gs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(GameState egs) {
        int currentPlayer = egs.currentPlayer;
        GameWindow gameWindow = this;
        synchronized (gameWindow) {
            this.outputTexts = new ArrayList();
            this.outputTexts.add("Player on move:");
            this.outputTexts.add("  " + this.boardCanvas.gameSpec.playerNames[currentPlayer - 1]);
            this.outputTexts.add("Scores: ");
            for (int i = 0; i < this.boardCanvas.gameSpec.playerNames.length; ++i) {
                String name = this.boardCanvas.gameSpec.playerNames[i];
                int score = egs.playerScores[i];
                this.outputTexts.add(i + 1 + " " + name + ": " + score);
            }
            if (egs.winner >= 0) {
                this.winner = egs.winner != 0 ? this.boardCanvas.gameSpec.playerNames[egs.winner - 1] + " wins!" : "Draw!";
            }
        }
        this.repaint();
        if (this.repaint) {
            this.boardCanvas.setState(egs);
            this.boardCanvas.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        g.clearRect(this.offsetX - 12, 0, this.getWidth(), this.getHeight());
        GameWindow gameWindow = this;
        synchronized (gameWindow) {
            if (this.outputTexts != null) {
                int x = 70;
                for (String s : this.outputTexts) {
                    g.drawString(s, this.offsetX, x += 17);
                }
            }
            Font font = new Font("Arial", 0, 10);
            g.setFont(font);
            g.drawString("Canvas redrawing: " + (this.repaint ? "ON" : "OFF"), this.offsetX, this.getHeight() - 30);
            g.drawString("-press key R to change", this.offsetX + 2, this.getHeight() - 19);
            if (!this.winner.equals("")) {
                g.setFont(new Font("Arial", 1, 12));
                g.drawString(this.winner, this.offsetX, 55);
            }
        }
    }
}

