/*
 * Decompiled with CFR 0.152.
 */
package s3games.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import s3games.robot.Robot;

public class RobotControlWindow
extends JFrame
implements Runnable {
    final Robot robot;
    private final char[] keys = new char[]{'q', 'a', 'w', 's', 'e', 'd', 'r', 'f', 't', 'g'};
    private char key;
    private boolean terminate;
    double[] position;

    public void respondToKey() {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.key != this.keys[i]) continue;
            int degreeIndex = i / 2;
            int direction = (i % 2 << 1) - 1;
            int n = degreeIndex;
            this.position[n] = this.position[n] + (double)direction;
            this.repaint();
            try {
                this.robot.goToDirect(this.position);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setPosition(double[] pos) {
        this.position = pos;
    }

    public RobotControlWindow(Robot robotReference) {
        this.robot = robotReference;
        this.terminate = false;
        this.setTitle("Direct Robot Control");
        this.position = new double[5];
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RobotControlWindow.this.key = evt.getKeyChar();
                if (RobotControlWindow.this.key == 'Q') {
                    RobotControlWindow.this.terminate = true;
                }
            }
        });
        this.setVisible(true);
        this.setSize(400, 200);
        this.key = (char)32;
        new Thread(this).start();
    }

    @Override
    public void run() {
        while (!this.terminate) {
            if (this.key == ' ') continue;
            this.respondToKey();
            this.key = (char)32;
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {}
        }
        this.dispose();
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.magenta);
        StringBuilder s = new StringBuilder();
        if (this.position != null) {
            for (int i = 0; i < 5; ++i) {
                s.append(' ').append(this.position[i]);
            }
        }
        g.drawString("Angles: " + s.toString(), 10, 80);
    }
}

