/*
 * Decompiled with CFR 0.152.
 */
package s3games.io;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileReader;
import s3games.engine.Element;
import s3games.engine.ElementType;
import s3games.engine.GameRule;
import s3games.engine.GameScoring;
import s3games.engine.GameSpecification;
import s3games.engine.Location;
import s3games.engine.LocationType;
import s3games.engine.expr.Expr;
import s3games.engine.expr.Expression;
import s3games.gui.Circular;
import s3games.gui.ImageWithHotSpot;
import s3games.gui.Rectangular;
import s3games.io.Config;
import s3games.io.GameLogger;
import s3games.robot.CameraObjectType;
import s3games.robot.RobotLocation;
import s3games.util.IndexedName;
import s3games.util.NameWithArgs;

public class GameSpecificationParser {
    private Config config;
    private GameLogger logger;
    private GameSpecification specs;
    private boolean inExpression;
    private Expression expression;
    private CameraObjectType cot;
    private ElementType et;
    private int state;
    private String imageName;
    private LocationType locationType;
    private Location location;
    private Element el;
    private GameScoring scoring;
    private Expr situation;
    private GameRule rule;

    private sections getSection(String sectionName) throws Exception {
        if ((sectionName = sectionName.toUpperCase()).equals("BOARD")) {
            return sections.BOARD;
        }
        if (sectionName.equals("REALBOARD ELEMENT TYPES")) {
            return sections.REALBOARD_ELEMENT_TYPES;
        }
        if (sectionName.equals("ELEMENT TYPES")) {
            return sections.ELEMENT_TYPES;
        }
        if (sectionName.equals("LOCATION TYPES")) {
            return sections.LOCATION_TYPES;
        }
        if (sectionName.equals("LOCATIONS")) {
            return sections.LOCATIONS;
        }
        if (sectionName.equals("PLAYER NAMES")) {
            return sections.PLAYER_NAMES;
        }
        if (sectionName.equals("MOVABLE ELEMENTS")) {
            return sections.MOVABLE_ELEMENTS;
        }
        if (sectionName.equals("EXPRESSIONS")) {
            return sections.EXPRESSIONS;
        }
        if (sectionName.equals("SCORINGS")) {
            return sections.SCORINGS;
        }
        if (sectionName.equals("END OF GAME")) {
            return sections.END_OF_GAME;
        }
        if (sectionName.equals("GAME RULES")) {
            return sections.GAME_RULES;
        }
        this.logger.error("unrecognized section name '" + sectionName + "'");
        throw new Exception("unrecognized section name");
    }

    public GameSpecificationParser(Config config, GameLogger logger) {
        this.config = config;
        this.logger = logger;
    }

    private void addExpressionLine(String ln) throws Exception {
        if (!this.inExpression) {
            NameWithArgs exprHeader = new NameWithArgs(ln);
            this.expression = new Expression(exprHeader.args);
            this.specs.expressions.put(exprHeader.baseName, this.expression);
            this.inExpression = true;
        } else if (ln.toUpperCase().equals("END")) {
            this.inExpression = false;
        } else {
            this.expression.addLine(ln);
        }
    }

    private void boardSetting(String var, String val) {
        if (var.equals("image")) {
            this.specs.boardBackgroundFileName = this.config.imagePath + "/" + val;
        }
    }

    private void realElementTypeSetting(String var, String val) {
        if ((var = var.toLowerCase()).equals("name")) {
            this.cot = new CameraObjectType(val);
            this.specs.cameraObjectTypes.add(this.cot);
        } else if (var.equals("state")) {
            this.cot.elState = Integer.parseInt(val);
        } else if (var.equals("huemin")) {
            this.cot.hueMin = Double.parseDouble(val);
        } else if (var.equals("huemax")) {
            this.cot.hueMax = Double.parseDouble(val);
        } else if (var.equals("saturationmin")) {
            this.cot.satMin = Double.parseDouble(val);
        } else if (var.equals("saturationmax")) {
            this.cot.satMax = Double.parseDouble(val);
        } else if (var.equals("valuemin")) {
            this.cot.valueMin = Double.parseDouble(val);
        } else if (var.equals("valuemax")) {
            this.cot.valueMax = Double.parseDouble(val);
        } else if (var.equals("sizemin")) {
            this.cot.sizeMin = Integer.parseInt(val);
        } else if (var.equals("sizemax")) {
            this.cot.sizeMax = Integer.parseInt(val);
        }
    }

    private void elementTypeSetting(String var, String val) throws Exception {
        if ((var = var.toLowerCase()).equals("name")) {
            this.et = new ElementType(val);
            this.specs.elementTypes.put(val, this.et);
        } else if (var.equals("states")) {
            this.et.numStates = Integer.parseInt(val);
            this.et.images = new ImageWithHotSpot[this.et.numStates];
            this.state = 0;
        } else if (var.equals("image")) {
            this.imageName = val;
        } else if (var.equals("point")) {
            String[] hotspot = val.split(",");
            try {
                this.et.images[this.state] = new ImageWithHotSpot(this.config.imagePath + "/" + this.imageName, Integer.parseInt(hotspot[0]), Integer.parseInt(hotspot[1]));
            }
            catch (Exception e) {
                this.logger.error("could not load image from file '" + this.imageName + "': " + e);
                throw e;
            }
            if (this.state == 0) {
                ImageWithHotSpot defaultImageForAllStates = this.et.images[0];
                for (int st = 1; st < this.et.numStates; ++st) {
                    this.et.images[st] = defaultImageForAllStates;
                }
            }
            ++this.state;
        }
    }

    private void locationTypeSetting(String var, String val) {
        if ((var = var.toLowerCase()).equals("name")) {
            this.locationType = new LocationType(val);
        }
        if (var.equals("relevant")) {
            this.locationType.relevant = val.toLowerCase().equals("yes");
        } else if (var.equals("image")) {
            this.imageName = val;
        } else if (var.equals("shape")) {
            IndexedName shapeName = new IndexedName(val);
            if (shapeName.baseName.equals("circle")) {
                this.locationType.shape = new Circular(shapeName.index[0]);
            } else if (shapeName.baseName.equals("rectangular")) {
                this.locationType.shape = new Rectangular(shapeName.index[0], shapeName.index[1]);
            }
        } else if (var.equals("point")) {
            String[] hotspot = val.split(",");
            try {
                ImageWithHotSpot img;
                this.locationType.image = img = new ImageWithHotSpot(this.config.imagePath + "/" + this.imageName, Integer.parseInt(hotspot[0].trim()), Integer.parseInt(hotspot[1].trim()));
                this.specs.locationTypes.put(this.locationType.name, this.locationType);
            }
            catch (Exception e) {
                this.logger.error("could not load image from file '" + this.imageName + "': " + e);
            }
        }
    }

    private void locationSetting(String var, String val) throws Exception {
        if ((var = var.toLowerCase()).equals("name")) {
            this.location = new Location(val);
            this.specs.locations.put(val, this.location);
        } else if (var.equals("type")) {
            this.location.type = val;
            LocationType locType = this.specs.locationTypes.get(val);
            if (locType == null) {
                throw new Exception("Unknown location type " + val);
            }
            this.location.relevant = locType.relevant;
        } else if (var.equals("point")) {
            String[] coord = val.split(",");
            this.location.point = new Point(Integer.parseInt(coord[0].trim()), Integer.parseInt(coord[1].trim()));
        } else if (var.equals("camera")) {
            String[] coord = val.split(",");
            this.location.camera = new Point(Integer.parseInt(coord[0].trim()), Integer.parseInt(coord[1].trim()));
        } else if (var.equals("robot")) {
            try {
                this.location.robot = new RobotLocation(val);
            }
            catch (Exception e) {
                this.logger.error(e.toString());
                throw e;
            }
        }
    }

    private void playerNameSetting(String var, String val) {
        if (var.toLowerCase().equals("score")) {
            this.specs.initialPlayerScore = Integer.parseInt(val);
        } else {
            int n = Integer.parseInt(var) - 1;
            int max = Math.max(n, this.specs.playerNames.length + 1);
            String[] newNames = new String[max];
            for (int i = 0; i < this.specs.playerNames.length; ++i) {
                newNames[i] = this.specs.playerNames[i];
            }
            newNames[n] = val;
            this.specs.playerNames = newNames;
        }
    }

    private void movableElementSetting(String var, String val) throws Exception {
        if ((var = var.toLowerCase()).equals("name")) {
            this.el = new Element(val);
            this.specs.elements.put(val, this.el);
        } else if (var.equals("type")) {
            this.el.type = val;
        } else if (var.equals("player")) {
            this.el.initialOwner = Integer.parseInt(val);
        } else if (var.equals("location")) {
            this.el.initialLocation = val;
        } else if (var.equals("state")) {
            this.el.initialState = Integer.parseInt(val);
        } else if (var.equals("zindex")) {
            this.el.initialZindex = Integer.parseInt(val);
        }
    }

    private void scoringsSetting(String var, String val) throws Exception {
        if ((var = var.toLowerCase()).equals("situation")) {
            this.scoring = new GameScoring(Expr.parseExpr(val));
            this.specs.scorings.add(this.scoring);
        } else if (var.equals("player")) {
            this.scoring.players.add(Expr.parseExpr(val));
        } else if (var.equals("score")) {
            this.scoring.amounts.add(Expr.parseExpr(val));
        }
    }

    private void endOfGameSetting(String var, String val) throws Exception {
        if ((var = var.toLowerCase()).equals("situation")) {
            this.situation = Expr.parseExpr(val);
        } else if (var.equals("winner")) {
            this.specs.terminationConditions.put(this.situation, Expr.parseExpr(val));
        }
    }

    private String stringify(String str) {
        return "\"" + str + "\"";
    }

    private void rulesSetting(String var, String val) throws Exception {
        if ((var = var.toLowerCase()).equals("name")) {
            this.rule = new GameRule(val);
            this.specs.rules.put(val, this.rule);
        } else if (var.equals("element")) {
            this.rule.element = Expr.parseExpr(this.stringify(val));
        } else if (var.equals("state")) {
            this.rule.state = Expr.parseExpr(val);
        } else if (var.equals("player")) {
            this.rule.currentPlayer = Expr.parseExpr(val);
        } else if (var.equals("from")) {
            this.rule.from = Expr.parseExpr(this.stringify(val));
        } else if (var.equals("to")) {
            this.rule.to = Expr.parseExpr(this.stringify(val));
        } else if (var.equals("condition")) {
            this.rule.condition = Expr.parseExpr(val);
        } else if (var.equals("awardplayer")) {
            this.rule.scorePlayer.add(Expr.parseExpr(val));
        } else if (var.equals("withscore")) {
            this.rule.scoreAmount.add(Expr.parseExpr(val));
        } else if (var.equals("followup")) {
            this.rule.action = Expr.parseExpr(val);
        }
    }

    private void storeSetting(sections section, String var, String val) throws Exception {
        switch (section) {
            case BOARD: {
                this.boardSetting(var, val);
                break;
            }
            case REALBOARD_ELEMENT_TYPES: {
                this.realElementTypeSetting(var, val);
                break;
            }
            case ELEMENT_TYPES: {
                this.elementTypeSetting(var, val);
                break;
            }
            case LOCATION_TYPES: {
                this.locationTypeSetting(var, val);
                break;
            }
            case LOCATIONS: {
                this.locationSetting(var, val);
                break;
            }
            case PLAYER_NAMES: {
                this.playerNameSetting(var, val);
                break;
            }
            case MOVABLE_ELEMENTS: {
                this.movableElementSetting(var, val);
                break;
            }
            case SCORINGS: {
                this.scoringsSetting(var, val);
                break;
            }
            case END_OF_GAME: {
                this.endOfGameSetting(var, val);
                break;
            }
            case GAME_RULES: {
                this.rulesSetting(var, val);
            }
        }
    }

    private void checkRules() throws Exception {
        for (GameRule r : this.specs.rules.values()) {
            if (r.scoreAmount.size() == r.scorePlayer.size()) continue;
            throw new Exception("'player=N' and 'score=X' in game rule " + r.name + " specification is not paired");
        }
    }

    public boolean load(String gameName, GameSpecification specs) throws Exception {
        this.specs = specs;
        specs.playerNames = new String[0];
        String fileName = this.config.gamesFolder + "/" + gameName;
        this.inExpression = false;
        try {
            BufferedReader r = new BufferedReader(new FileReader(fileName));
            sections section = sections.BOARD;
            while (r.ready()) {
                String ln = r.readLine().trim();
                if (ln.length() < 2 || ln.charAt(0) == '/' && ln.charAt(1) == '/') continue;
                if (ln.charAt(0) == '[') {
                    section = this.getSection(ln.substring(1, ln.length() - 1));
                    continue;
                }
                if (section == sections.EXPRESSIONS) {
                    this.addExpressionLine(ln);
                    continue;
                }
                String[] setting = ln.split("=", 2);
                if (setting.length != 2) {
                    this.logger.error("urecognized line in game specification: '" + ln + "'");
                }
                this.storeSetting(section, setting[0], setting[1]);
            }
            r.close();
            this.checkRules();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("could not load game specification from file " + fileName);
            throw e;
        }
        return true;
    }

    private static enum sections {
        BOARD,
        REALBOARD_ELEMENT_TYPES,
        ELEMENT_TYPES,
        LOCATION_TYPES,
        LOCATIONS,
        PLAYER_NAMES,
        MOVABLE_ELEMENTS,
        EXPRESSIONS,
        SCORINGS,
        END_OF_GAME,
        GAME_RULES;

    }
}

