/*
 * Decompiled with CFR 0.152.
 */
package s3games.player;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import s3games.engine.GameState;
import s3games.engine.Move;
import s3games.player.Player;

public abstract class AbstractMonteCarloPlayer
extends Player {
    @Override
    public Move move(GameState state, ArrayList<Move> allowedMoves) throws Exception {
        this.startMove();
        ArrayList<Move> moves = new ArrayList<Move>(state.possibleMoves());
        if (moves.size() == 1) {
            return allowedMoves.get(0);
        }
        GameState[] gss = new GameState[moves.size()];
        for (int i = 0; i < moves.size(); ++i) {
            this.initializeScore(i);
            gss[i] = state.getCopy();
            gss[i].performMove(moves.get(i));
        }
        this.performTrials(gss);
        double bestRatio = Double.NEGATIVE_INFINITY;
        Move bestMove = null;
        for (int i = 0; i < moves.size(); ++i) {
            double score = this.calculateScore(i);
            if (!(score > bestRatio)) continue;
            bestRatio = score;
            bestMove = moves.get(i);
        }
        return bestMove;
    }

    protected abstract void addScore(GameState var1, int var2);

    protected abstract double calculateScore(int var1);

    protected abstract void initializeScore(int var1);

    protected abstract void initializeRatio();

    protected abstract void updateRatio(GameState var1, Set<Move> var2);

    private void performTrials(GameState[] ogs) throws Exception {
        Random random = new Random();
        while (this.ratioTimeLeft() > 0.0) {
            int firstMove = random.nextInt(ogs.length);
            GameState gs = ogs[firstMove].getCopy();
            this.initializeRatio();
            HashSet<GameState> visited = new HashSet<GameState>();
            visited.add(gs);
            int nodes = 1;
            while ((long)nodes < this.maxNodes && this.ratioTimeLeft() > 0.0 && gs.winner == -1) {
                HashSet<Move> moves = gs.possibleMoves();
                Iterator it = moves.iterator();
                while (it.hasNext()) {
                    Move m = (Move)it.next();
                    GameState gs2 = gs.getCopy();
                    gs2.performMove(m);
                    if (!visited.contains(gs2)) continue;
                    it.remove();
                }
                if (moves.isEmpty()) break;
                this.updateRatio(gs, moves);
                int i = random.nextInt(moves.size());
                it = moves.iterator();
                while (i-- > 0) {
                    it.next();
                }
                gs.performMove((Move)it.next());
                ++nodes;
                visited.add(gs);
            }
            this.addScore(gs, firstMove);
        }
    }
}

