/*
 * Decompiled with CFR 0.152.
 */
package s3games.player;

import java.util.ArrayList;
import java.util.Date;
import s3games.engine.GameState;
import s3games.engine.Move;

public abstract class Player {
    protected int number;
    protected long maxNodes;
    private long startTime;
    private long maxTime;

    public abstract Move move(GameState var1, ArrayList<Move> var2) throws Exception;

    public void otherMoved(Move move, GameState newState) {
    }

    public void startMove() {
        this.startTime = new Date().getTime();
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public long timeUsed() {
        long res = new Date().getTime() - this.startTime;
        return res;
    }

    public double ratioTimeLeft() {
        double res = 1.0 - (double)this.timeUsed() / (double)this.maxTime;
        return res;
    }

    public boolean isComputer() {
        return true;
    }

    public void setPlayerNumber(int pn) {
        this.number = pn;
    }

    public void setMaximumNumberOfNodes(long maxNodes) {
        this.maxNodes = maxNodes;
    }

    public static enum boardType {
        REALWORLD,
        SIMULATED;

    }

    public static enum playerType {
        HUMAN,
        COMPUTER;

    }
}

