/*
 * Decompiled with CFR 0.152.
 */
package s3games.robot;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import s3games.engine.GameSpecification;
import s3games.engine.Location;
import s3games.engine.Move;
import s3games.gui.RobotControlWindow;
import s3games.gui.RobotWindow;
import s3games.robot.RobotCmd;
import s3games.robot.RobotSerialPort;

public class Robot
implements Runnable {
    private String port;
    RobotSerialPort link;
    GameSpecification specs;
    RobotWindow win;
    Move requestedMove;
    final Object waitForMovePerformed = new Object();
    private double[] currentLocation;
    private boolean showingLocations;
    private boolean paused;

    public Robot(String serialPort, GameSpecification specs) throws Exception {
        this.port = serialPort;
        this.specs = specs;
        this.win = new RobotWindow(this);
        this.open();
    }

    private void open() throws Exception {
        int ch;
        this.win.addMessage("Opening robot...");
        this.link = new RobotSerialPort(this.port);
        this.link.open();
        this.link.print(new RobotCmd(RobotCmd.Command.version).getCommand());
        StringBuilder sb = new StringBuilder();
        do {
            ch = this.link.read();
            sb.append((char)ch);
        } while (ch != 13);
        this.win.addMessage("Robot Firmware version: " + sb.toString());
        this.win.addMessage("You can move the robot away from the camera frame and click [Init] twice.");
    }

    public void close() {
        this.link.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveRobot(Move move) throws Exception {
        this.requestedMove = move;
        this.win.addMessage("A new move " + move + " has been requested, click [Perform move] to perform it.");
        Object object = this.waitForMovePerformed;
        synchronized (object) {
            this.waitForMovePerformed.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMove() throws Exception {
        this.goTo(this.requestedMove.from, true);
        this.goTo(this.requestedMove.to, false);
        this.goHome();
        Object object = this.waitForMovePerformed;
        synchronized (object) {
            this.waitForMovePerformed.notify();
        }
    }

    private boolean moveCompleted() throws Exception {
        this.link.print(new RobotCmd(RobotCmd.Command.query).getCommand());
        int stillMoving = this.link.read();
        if (stillMoving == RobotCmd.responseIdle()) {
            return true;
        }
        if (stillMoving == RobotCmd.responseBusy()) {
            return false;
        }
        throw new Exception("Query from robot expected + or . but " + stillMoving + " was received.");
    }

    private void goTo(String locationName, boolean grab) throws Exception {
        double[] angles = this.specs.locations.get((Object)locationName).robot.angles;
        double[] place1 = Arrays.copyOfRange(angles, 0, 5);
        double[] place2 = Arrays.copyOfRange(angles, 5, 10);
        this.goTo(place1);
        Thread.sleep(700L);
        this.currentLocation = place2;
        this.goTo(place2);
        Thread.sleep(700L);
        if (grab) {
            this.grab();
        } else {
            this.put();
        }
        if (this.paused) {
            return;
        }
        Thread.sleep(700L);
        this.goTo(place1);
        Thread.sleep(700L);
    }

    public void doTest() {
        System.out.print("enter angles (5 doubles, init, or home, grab, put): ");
        try {
            double[] angles = new double[5];
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String[] ln = in.readLine().split(" ");
            if (ln.length == 0) {
                return;
            }
            if (ln[0].equals("init")) {
                System.out.println("Moving to initial position");
                this.initArm();
            } else if (ln[0].equals("home")) {
                System.out.println("Moving to home position");
                this.goHome();
            } else if (ln[0].equals("grab")) {
                System.out.println("Grabbing");
                this.grab();
            } else if (ln[0].equals("put")) {
                System.out.println("Putting");
                this.put();
            } else if (ln.length < 5) {
                System.out.println("Did anybody say 5 doubles?");
            } else {
                for (int i = 0; i < 5; ++i) {
                    angles[i] = Double.parseDouble(ln[i]);
                }
                System.out.println("Moving the robot, watch out!");
                Thread.sleep(1000L);
                this.goTo(angles);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void allLocationsDemo() {
        if (!this.showingLocations) {
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        this.showingLocations = true;
        try {
            for (Location loc : this.specs.locations.values()) {
                if (!loc.relevant) {
                    this.win.addMessage("skipped irrelevant location " + loc.name.fullName);
                    continue;
                }
                this.win.addMessage("goTo(" + loc.name.fullName + ") = " + loc.robot.toString());
                this.goTo(loc.name.fullName, false);
                Thread.sleep(5000L);
                while (this.paused) {
                    Thread.sleep(1000L);
                }
            }
        }
        catch (Exception e) {
            this.win.addMessage("Problem moving to location: " + e.getMessage());
        }
        this.showingLocations = false;
    }

    public void pause() {
        boolean bl = this.paused = !this.paused;
        if (this.paused) {
            this.win.addMessage("Paused. Prese [Pause] again to continue.");
        }
    }

    public void control() {
        if (!this.paused) {
            this.pause();
        }
        this.win.addMessage("Control the robot using keys q,a,w,s,e,d,r,f,t,g, quit the window with 'Q'.");
        RobotControlWindow rcw = new RobotControlWindow(this);
        rcw.setPosition(this.currentLocation);
    }

    public void goTo(double[] angles) throws Exception {
        while (!this.moveCompleted()) {
            Thread.sleep(500L);
        }
        this.link.print(new RobotCmd(RobotCmd.Command.position, angles).getCommand());
    }

    public void goToDirect(double[] angles) throws Exception {
        this.link.print(new RobotCmd(RobotCmd.Command.position, angles).getCommand());
    }

    public void grab() throws Exception {
        while (!this.moveCompleted()) {
            Thread.sleep(500L);
        }
        this.link.print(new RobotCmd(RobotCmd.Command.grab).getCommand());
    }

    public void put() throws Exception {
        while (!this.moveCompleted()) {
            Thread.sleep(500L);
        }
        this.link.print(new RobotCmd(RobotCmd.Command.put).getCommand());
    }

    public void initArm() {
        try {
            this.link.print(new RobotCmd(RobotCmd.Command.init).getCommand());
        }
        catch (Exception e) {
            this.win.addMessage("Could not init robot arm: " + e.getMessage());
        }
    }

    public void goHome() throws Exception {
        while (!this.moveCompleted()) {
            Thread.sleep(500L);
        }
        this.link.print(new RobotCmd(RobotCmd.Command.home).getCommand());
    }
}

