/*
 * Decompiled with CFR 0.152.
 */
package s3games.robot;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class RobotSerialPort {
    private String port;
    private InputStream in;
    private OutputStream out;

    public RobotSerialPort(String portName) {
        this.port = portName;
    }

    public void open() throws Exception {
        Enumeration e = CommPortIdentifier.getPortIdentifiers();
        while (e.hasMoreElements()) {
            System.out.println("e: " + e.nextElement());
        }
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(this.port);
        if (portIdentifier.isCurrentlyOwned()) {
            throw new Exception("RobotSerialPort: " + this.port + " is currently in use");
        }
        CommPort commPort = portIdentifier.open(this.getClass().getName(), 2000);
        if (commPort instanceof SerialPort) {
            SerialPort serialPort = (SerialPort)commPort;
            serialPort.setSerialPortParams(115200, 8, 1, 0);
            this.in = serialPort.getInputStream();
            this.out = serialPort.getOutputStream();
            if (this.in == null) {
                throw new Exception("RobotSerialPort: cannot obtain input stream");
            }
            if (this.out == null) {
                throw new Exception("RobotSerialPort: cannot obtain output stream");
            }
        } else {
            throw new Exception("RobotSerialPort: " + this.port + " is not a serial port.");
        }
    }

    public void close() {
        try {
            this.in.close();
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void print(String s) throws IOException {
        this.out.write(s.getBytes());
        this.out.write(13);
        this.out.flush();
    }

    int read() throws IOException {
        int ch = -1;
        while (ch == -1 || ch == 255) {
            ch = this.in.read();
        }
        return ch;
    }
}

