/*
 * Decompiled with CFR 0.152.
 */
package s3games.util;

import java.util.ArrayList;
import s3games.util.SwitchListener;

public class Switch {
    private boolean state = false;
    private int value;
    private ArrayList<SwitchListener> listeners = new ArrayList();

    public void addSwitchListener(SwitchListener l) {
        this.listeners.add(l);
    }

    private void notifyListeners() {
        for (SwitchListener l : this.listeners) {
            l.switchChanged(this.state);
        }
    }

    public void on() {
        if (this.state) {
            return;
        }
        this.state = true;
        this.notifyListeners();
    }

    public void off() {
        if (!this.state) {
            return;
        }
        this.state = false;
        this.notifyListeners();
    }

    public boolean isOn() {
        return this.state;
    }

    public boolean isOff() {
        return !this.state;
    }

    public void setValue(int newValue) {
        this.value = newValue;
    }

    public int getValue() {
        return this.value;
    }
}

