#include "structures.h"
#include "DKA.h"
#include <math.h>
#include <queue>
#include <stack>
#include <cstdlib>
#ifndef NKA_H
#define NKA_H

class NKA
{
    public:
        NKA(int nstates, int nabeceda);
        virtual ~NKA();
        void add_prechod(int state, int pismeno, bool * next_states);
        void accept_states(int astates, int * stavy);
        DKA * convert2DKA();
        DKA * convert2minDKA();
        int generateNextNKA();
        void generateNextNKA(double prp, double pra);
        void generateNextNKA(double prp, double prp0, double pra);
        void generateNextNKA(int ohr_d, double pra);
        bool is_minimal(DKA * dka);
        bool have_cycle();
        void vypis();
    protected:
    private:
        int nstates;
        int nabeceda;
        prechod_pre_ned_stav * prechodova_funkcia;
};

#endif // NKA_H
