import java.util.ArrayList;

public class BruteForce2 {

	ArrayList<int[]> quadratic1_Boolean = new ArrayList<int[]>();
	ArrayList<int[]> quadratic2_Boolean = new ArrayList<int[]>();
	ArrayList<ArrayList<Pair>> quadratic1 = new ArrayList<ArrayList<Pair>>();
	ArrayList<ArrayList<Pair>> quadratic2 = new ArrayList<ArrayList<Pair>>();
	
	int numbers = 0;
	
	void quadratic_Init() {

		for (int i = 0; i < 12; i++) {
			for (int j = 0; j < 12; j++) {
				ArrayList<Pair> tmp_Pair = new ArrayList<Pair>();
				int[] boolean_q1 = new int[144];

				for (int k = 0; k < 12; k++) {
					boolean_q1[12 * k + i] = 1;
					boolean_q1[12 * k + j] = 1;
					Pair pair = new Pair();
					pair.pos1 = 12 * k + i;
					pair.pos2 = 12 * k + j;
					tmp_Pair.add(pair);
				}

				quadratic1_Boolean.add(boolean_q1);
				quadratic1.add(tmp_Pair);
			}
		}

		for (int i = 0; i < 12; i++) {
			for (int j = 0; j < 12; j++) {

				ArrayList<Pair> tmp_Pair = new ArrayList<Pair>();
				int[] boolean_q2 = new int[144];

				for (int k = 0; k < 12; k++) {
					boolean_q2[12 * i + k] = 1;
					boolean_q2[12 * j + k] = 1;
					Pair pair = new Pair();
					pair.pos1 = 12 * i + k;
					pair.pos2 = 12 * j + k;
					tmp_Pair.add(pair);
				}

				quadratic2_Boolean.add(boolean_q2);
				quadratic2.add(tmp_Pair);
			}
		}
	}

	boolean test_linearResolve(byte[] solution, int[][] linear_Equation, int[] vector) {

		for (int j = 0; j < linear_Equation.length; j++) {

			ArrayList<Integer> indexes = new ArrayList<Integer>();
			for (int k = 0; k < 144; k++) {
				if (linear_Equation[j][k] != 0) {
					indexes.add(k);
				}
			}

			boolean test = true;
			for (int k = 0; k < indexes.size(); k++) {
				if (solution[indexes.get(k)] == 2) {
					test = false;
				}
			}

			if (test) {
				int sucet = 0;
				for (int k = 0; k < indexes.size(); k++) {
					sucet += solution[indexes.get(k)] * linear_Equation[j][indexes.get(k)];
				}
				if (sucet != vector[j]) {
					return false;
				}
			}
		}

		return true;
	}

	boolean test_quadraticResolve(byte[] solution, int[][] matrixQ1, int[][] matrixQ2) {
		boolean ok = true;
		for (int j = 0; j < quadratic1_Boolean.size(); j++) {
			ArrayList<Integer> indexes = new ArrayList<Integer>();
			for (int k = 0; k < 144; k++) {
				if (quadratic1_Boolean.get(j)[k] == 1) {
					indexes.add(k);
				}
			}

			boolean test = true;
			for (int k = 0; k < indexes.size(); k++) {
				if (solution[indexes.get(k)] == 2) {
					test = false;
				}
			}

			if (test == true) {
				int sucet = 0;
				for (int k = 0; k < quadratic1.get(j).size(); k++) {
					sucet += solution[quadratic1.get(j).get(k).pos1] * solution[quadratic1.get(j).get(k).pos2];
				}
				if (sucet != matrixQ1[j / 12][j % 12]) {
					return false;
				}
			}
		}

		boolean ok2 = true;
		for (int j = 0; j < quadratic2_Boolean.size(); j++) {

			ArrayList<Integer> indexes = new ArrayList<Integer>();
			for (int k = 0; k < 144; k++) {
				if (quadratic2_Boolean.get(j)[k] == 1) {
					indexes.add(k);
				}
			}

			boolean test = true;
			for (int k = 0; k < indexes.size(); k++) {
				if (solution[indexes.get(k)] == 2) {
					test = false;
				}
			}

			if (test) {
				int sucet = 0;
				for (int k = 0; k < quadratic2.get(j).size(); k++) {
					sucet += solution[quadratic2.get(j).get(k).pos1] * solution[quadratic2.get(j).get(k).pos2];
				}
				if (sucet != matrixQ2[j / 12][j % 12]) {
					return false;
				}
			}
		}

		return true;
	}

	static ArrayList<byte[]> generuj() {
		ArrayList<byte[]> line_solution = new ArrayList<byte[]>();
		for (int i = 0; i < (1 << 12); i++) {

			byte[] tmp_solution = new byte[12];
			int pocet_jednotiek = 0;
			for (int j = 0; j < 12; j++) {
				if (((i >> j) & 1) == 1) {
					pocet_jednotiek++;
					tmp_solution[j] = 1;
				}
			}

			if (pocet_jednotiek == 6)
				line_solution.add(tmp_solution);
		}
		return line_solution;
	}

	void rekurzia(int pocet, byte[] tmp_solution, int[][] linear, int[] vector, int[][] matrix_Q1, int[][] matrix_Q2, int[][] matrix_A1, int[][] matrix_A2, ArrayList<byte[]> gen) {
		
		if ((test_linearResolve(tmp_solution, linear, vector)) && (test_quadraticResolve(tmp_solution, matrix_Q1, matrix_Q2))) {
			
			if (pocet == 144) {	
				int[][] matica = new int[25][25];

				for(int j=1;j<13;j++) matica[0][j] = 1;
				for(int j=1;j<13;j++) matica[j][0] = 1;

				for(int j=1; j<13; j++){
					for(int k=1; k<13; k++){
						
						matica[j][k]= matrix_A1[j-1][k-1];
					}
				}

				for(int j=13; j<25; j++){
					for(int k=13; k<25; k++){
						matica[j][k]= matrix_A2[j-13][k-13];
					}
				}

				for(int j=13; j<25; j++){
					for(int k=1; k<13; k++){
						matica[j][k]= tmp_solution[(j-13)*12 + (k-1)];
					}
				}

				for(int j=1; j<13; j++){
					for(int k=13; k<25; k++){
						matica[j][k]= tmp_solution[(k-13)*12 + (j-1)];
					}
				}
				
				StringBuilder mat = new StringBuilder();
				// VYPIS MATICE:
				for(int j=0;j<25;j++){
					for(int k=0;k<25;k++){
						mat.append(matica[j][k]);
//						System.out.print(matica[j][k]);
					}
					mat.append("\n");
//					System.out.println();
				}
				mat.append("------------------------------------------");
				numbers++;
				System.out.println(mat.toString());
			}
			else{
				for(int i=0; i< gen.size(); i++){
					byte[] solution = tmp_solution.clone();
					for (int k = 144 - (pocet+12); k < 144 - (pocet); k++){
						solution[k] = gen.get(i)[k - (144 - (pocet+12))];
					}
			
					int finalpocet = pocet +12;
					rekurzia(finalpocet, solution, linear, vector, matrix_Q1, matrix_Q2, matrix_A1, matrix_A2, gen);
					
				}
				
			}
		}
	}

	public static void main(String[] args) throws Exception {
//		long start = System.currentTimeMillis();
		
		final Multiplication multiplication = new Multiplication();
		multiplication.getSolution();
		Graphs graphs = new Graphs();
		graphs.read();
		System.out.println("Size of matrices Q1 : " + graphs.matrices_Q1.size());
		System.out.println("Size of matrices Q2 : " + graphs.matrices_Q2.size());
		System.out.println("Size of matrices Linear Equations : " + graphs.linear_equation.size());

		System.out.println("ALL READY!");

		final BruteForce2 bruteForce2 = new BruteForce2();

//		byte[] tmp_solution = new byte[144];
		bruteForce2.quadratic_Init();
		final ArrayList<byte[]> gen = generuj();
		System.out.println("Pocet generuj je: " + gen.size());
		
//		interval.add();
		int it = 11762;
//		int it = Integer.parseInt(args[0]);
		
//		interval.add(9691);
//		interval.add(10228);
//		interval.add(11762);
//		interval.add(280);
		
			
			System.out.println("STARTING WITH "+ it);
			final int[][] linear = graphs.linear_equation.get(it);
			final int[] vector = graphs.vector.get(it);
			final int[][] matrix_Q1 = graphs.matrices_Q1.get(it);
			final int[][] matrix_Q2 = graphs.matrices_Q2.get(it);
			final int[][] matrix_A1 = multiplication.a1_matrices_fixed.get(it);
			final int[][] matrix_A2 = multiplication.a2_matrices.get(it);
			
			//NEW CODE
//			int zac = 0;
//			final int threadsCount = 5;
//			final int inc = gen.size() / threadsCount;
//			final int genSize = gen.size();
//			Thread[] threads = new Thread[threadsCount];
//			for (int i = 0; i < threadsCount; i++) {
//				final int finalZac = zac;
//				threads[i] = new Thread(new Runnable() {
//					@Override
//					public void run() {
//						for (int ii = finalZac; ii < threadsCount - 1 ? ii < (finalZac + inc) : (ii<genSize); ii++) {
//							byte[] tmp_solution = new byte[144];
//							for (int k = 0; k < 132; k++)
//								tmp_solution[k] = 2;
//							for (int k = 132; k < 144; k++)
//								tmp_solution[k] = gen.get(ii)[k - 132];
//							
//							bruteForce2.rekurzia(12, tmp_solution, linear, vector, matrix_Q1, matrix_Q2, matrix_A1, matrix_A2, gen);
//							System.out.println("VYPIS: "+ ii+ " from "+ (finalZac+inc));
//						}
//					}
//				});
//				threads[i].start();
//				zac += inc;
//			}
//			for (int i = 0; i < threadsCount; i++) {
//				threads[i].join();
//			}
//			
//			//END CODE
			
			for (int i = 253; i < gen.size(); i++) {
				byte[] tmp_solution = new byte[144];
				for (int k = 0; k < 132; k++)
					tmp_solution[k] = 2;
				for (int k = 132; k < 144; k++)
					tmp_solution[k] = gen.get(i)[k - 132];
				
				bruteForce2.rekurzia(12, tmp_solution, linear, vector, matrix_Q1, matrix_Q2, multiplication.a1_matrices_fixed.get(it), multiplication.a2_matrices.get(it), gen);
				System.out.println("VYPIS: "+ i + " from "+ gen.size());

			}
		
		System.out.println("Numbers of graph: " + bruteForce2.numbers);
	}
}
