import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;

public class Graphs {

	public ArrayList<int[][]> linear_equation = new ArrayList<int[][]>();
	public ArrayList<int[]> vector = new ArrayList<int[]>();
	public ArrayList<int[][]> matrices_Q1 = new ArrayList<int[][]>();
	public ArrayList<int[][]> matrices_Q2 = new ArrayList<int[][]>();

	StringBuilder writeToFile(int[][] matrix, char ch, Boolean visible) {

		StringBuilder outputLine = new StringBuilder();

		outputLine.append(ch + " := [");
		for (int i = 0; i < matrix.length; i++) {
			outputLine.append("[");
			for (int j = 0; j < matrix[i].length; j++) {
				outputLine.append(matrix[i][j]);
				if (j != matrix[i].length - 1)
					outputLine.append(",");
			}
			outputLine.append("]");
			if (i != matrix.length - 1)
				outputLine.append(",");
		}
		outputLine.append("];");
		if (!visible)
			outputLine.append("; ");
		else
			outputLine.append(" ");
		return outputLine;
	}
	
	void special_read() throws Exception{
		
		BufferedReader in3 = new BufferedReader(new FileReader("out_special.txt"));

		String line;
	
		StringBuilder str_line = new StringBuilder();
		Boolean test = false;

		while ((line = in3.readLine()) != null) {

			if (!line.contains("*")) {
				str_line.append(line.trim());
			} else {
				str_line.append(line.substring(0, line.indexOf("*") ).trim());
				String tmp_s = line.substring(line.indexOf("*"), line.length());
				line = str_line.toString();
				str_line = new StringBuilder();
				str_line.append(tmp_s.trim());
				test = true;
			}

			if (test == true) {
				int[][] tmp_matrix = new int[144][144];
				int[] tmp_vector = new int[144];
				int number_line = 0;
				String[] sp = line.split("\\],");
				for (int k = 0; k < sp.length; k++) {
					sp[k] = sp[k].replaceAll("\\[", "");
					sp[k] = sp[k].replaceAll("\\]", "");
					sp[k] = sp[k].replaceAll("\\*", "");
					String[] tmp = sp[k].split(",");
					int max = 1;
					for (int i = 0; i < 145; i++) {

						if (tmp[i].contains("/")) {
							String[] tmp2 = tmp[i].split("/");
							if (Integer.parseInt(tmp2[1].trim()) > max)
								max = Integer.parseInt(tmp2[1].trim());
						}
					}

					for (int i = 0; i < 145; i++) {
						if (tmp[i].contains("/")) {
							String[] tmp2 = tmp[i].split("/");
							if (i != 144)
								tmp_matrix[number_line][i] = Integer.parseInt(tmp2[0].trim()) * max / Integer.parseInt(tmp2[1].trim());
							else
								tmp_vector[number_line] = Integer.parseInt(tmp2[0].trim()) * max / Integer.parseInt(tmp2[1].trim());
						} else {
							if (i != 144)
								tmp_matrix[number_line][i] = Integer.parseInt(tmp[i].trim()) * max;
							else
								tmp_vector[number_line] = Integer.parseInt(tmp[i].trim()) * max;
						}
					}
					number_line++;
				}
				linear_equation.add(tmp_matrix);
				vector.add(tmp_vector);
				test = false;

			}

		}

		in3.close();
		System.out.println("Done!");
		
	}
	
	void special_prepare() throws Exception{
		Multiplication multiplication = new Multiplication();
	
		ArrayList<int[][]> solution = new ArrayList<int[][]>();
		solution.add(multiplication.getSpecialSolution());

		ArrayList<int[][]> a1_matrices = new ArrayList<int[][]>();
		a1_matrices.add(multiplication.getSpecialA1());
		
		ArrayList<int[][]> a2_matrices = new ArrayList<int[][]>();
		a2_matrices.add(multiplication.getSpecialA2());

		int[][] all_one_matrix = new int[12][12];
		for (int i = 0; i < 12; i++) {
			for (int j = 0; j < 12; j++) {
				all_one_matrix[i][j] = 1;
			}
		}

		for (int i = 0; i < solution.size(); i++) {

			int[][] tmp_LinearEquation = new int[144][145];
			for (int j = 0; j < 144; j++) {
				for (int k = 0; k < 145; k++) {
					if (k != 144)
						tmp_LinearEquation[j][k] = solution.get(i)[j][k];
					else
						tmp_LinearEquation[j][k] = 6;
				}
			}
			System.out.println(writeToFile(tmp_LinearEquation, 'A', false) + "TriangulizedMat(A);" + "Print(\"*\");" + "\n");

			System.out.println(writeToFile(all_one_matrix, 'J', false) + " ");
			System.out.println(writeToFile(a1_matrices.get(i), 'A', false) + " ");
			System.out.println("5*J - A^2 - A + 6*IdentityMat(12,1); " + "\n");

			System.out.println(writeToFile(all_one_matrix, 'J', false) + " ");
			System.out.println(writeToFile(a2_matrices.get(i), 'C', false) + " ");
			System.out.println("6*J - C^2 - C + 6*IdentityMat(12,1); " + "\n");

		}
		System.out.println("Done!");
	}
	
	void read() throws Exception {
		BufferedReader in1 = new BufferedReader(new FileReader("q1.txt"));
		BufferedReader in2 = new BufferedReader(new FileReader("q2.txt"));
		BufferedReader in3 = new BufferedReader(new FileReader("tr.txt"));

		String line;
		while ((line = in1.readLine()) != null) {
			line = line.replaceAll("\\[", "");
			line = line.replaceAll("\\]", "");
			String[] tmp = line.split(",");
			int[][] tmp_matrix = new int[12][12];
			for (int i = 0; i < tmp.length; i++) {
				tmp_matrix[i % 12][i / 12] = Integer.parseInt(tmp[i].trim());
			}
			matrices_Q1.add(tmp_matrix);
		}

		while ((line = in2.readLine()) != null) {
			line = line.replaceAll("\\[", "");
			line = line.replaceAll("\\]", "");
			String[] tmp = line.split(",");
			int[][] tmp_matrix = new int[12][12];
			for (int i = 0; i < tmp.length; i++) {
				tmp_matrix[i % 12][i / 12] = Integer.parseInt(tmp[i].trim());
			}
			matrices_Q2.add(tmp_matrix);
		}

		StringBuilder str_line = new StringBuilder();
		Boolean test = false;

		while ((line = in3.readLine()) != null) {

			if (!line.contains("*")) {
				str_line.append(line.trim());
			} else {
				str_line.append(line.substring(0, line.indexOf("*") ).trim());
				String tmp_s = line.substring(line.indexOf("*"), line.length());
				line = str_line.toString();
				str_line = new StringBuilder();
				str_line.append(tmp_s.trim());
				test = true;
			}

			if (test == true) {
				int[][] tmp_matrix = new int[144][144];
				int[] tmp_vector = new int[144];
				int number_line = 0;
				String[] sp = line.split("\\],");
				for (int k = 0; k < sp.length; k++) {
					sp[k] = sp[k].replaceAll("\\[", "");
					sp[k] = sp[k].replaceAll("\\]", "");
					sp[k] = sp[k].replaceAll("\\*", "");
					String[] tmp = sp[k].split(",");
					int max = 1;
					for (int i = 0; i < 145; i++) {

						if (tmp[i].contains("/")) {
							String[] tmp2 = tmp[i].split("/");
							if (Integer.parseInt(tmp2[1].trim()) > max)
								max = Integer.parseInt(tmp2[1].trim());
						}
					}

					for (int i = 0; i < 145; i++) {
						if (tmp[i].contains("/")) {
							String[] tmp2 = tmp[i].split("/");
							if (i != 144)
								tmp_matrix[number_line][i] = Integer.parseInt(tmp2[0].trim()) * max / Integer.parseInt(tmp2[1].trim());
							else
								tmp_vector[number_line] = Integer.parseInt(tmp2[0].trim()) * max / Integer.parseInt(tmp2[1].trim());
						} else {
							if (i != 144)
								tmp_matrix[number_line][i] = Integer.parseInt(tmp[i].trim()) * max;
							else
								tmp_vector[number_line] = Integer.parseInt(tmp[i].trim()) * max;
						}
					}
					number_line++;
				}
				linear_equation.add(tmp_matrix);
				vector.add(tmp_vector);
				test = false;

			}

		}

		in1.close();
		in2.close();
		in3.close();
		System.out.println("Done!");
	}

	void prepare() throws Exception {
		Multiplication multiplication = new Multiplication();
		multiplication.getSolution();

		PrintStream out1 = new PrintStream(new FileOutputStream("triangulized.txt"));
		PrintStream out2 = new PrintStream(new FileOutputStream("quadratic1.txt"));
		PrintStream out3 = new PrintStream(new FileOutputStream("quadratic2.txt"));

		ArrayList<int[][]> solution = multiplication.solution_matrices_linear;
		ArrayList<int[][]> a1_matrices = multiplication.a1_matrices_fixed;
		ArrayList<int[][]> a2_matrices = multiplication.a2_matrices;

		int[][] all_one_matrix = new int[12][12];
		for (int i = 0; i < 12; i++) {
			for (int j = 0; j < 12; j++) {
				all_one_matrix[i][j] = 1;
			}
		}

		System.out.println("Solution size: " + solution.size());
		for (int i = 0; i < solution.size(); i++) {

			int[][] tmp_LinearEquation = new int[144][145];
			for (int j = 0; j < 144; j++) {
				for (int k = 0; k < 145; k++) {
					if (k != 144)
						tmp_LinearEquation[j][k] = solution.get(i)[j][k];
					else
						tmp_LinearEquation[j][k] = 6;
				}
			}
			out1.append(writeToFile(tmp_LinearEquation, 'A', false) + "TriangulizedMat(A);" + "Print(\"*\");" + "\n");

			out2.append(writeToFile(all_one_matrix, 'J', false) + " ");
			out2.append(writeToFile(a1_matrices.get(i), 'A', false) + " ");
			out2.append("5*J - A^2 - A + 6*IdentityMat(12,1); " + "\n");

			out3.append(writeToFile(all_one_matrix, 'J', false) + " ");
			out3.append(writeToFile(a2_matrices.get(i), 'C', false) + " ");
			out3.append("6*J - C^2 - C + 6*IdentityMat(12,1); " + "\n");

		}

		out1.close();
		out2.close();
		out3.close();
		System.out.println("Done!");
	}

	public static void main(String[] args) throws Exception {
		
		Multiplication multiplication = new Multiplication();
		multiplication.getSolution();
		Graphs graphs = new Graphs();
		// graphs.prepare();
		graphs.read();
		System.out.println("Size of matrices Q1 : " + graphs.matrices_Q1.size());
		System.out.println("Size of matrices Q2 : " + graphs.matrices_Q2.size());
		System.out.println("Size of matrices Linear Equations : " + graphs.linear_equation.size());
		
		System.out.println("ALL READY!");
	}

}
