import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class ParseASCFormat {

	private ArrayList<int[][]> matrixGraphs = new ArrayList<int[][]>();
	
	ArrayList<int[][]> getMatrixGraphs(){
		return matrixGraphs;
	}
	
	void setMatrixGraphs(ArrayList<int[][]> newMatrixGraphs){
		matrixGraphs = newMatrixGraphs;
	}
	
	void ParseASC(String filename) throws Exception {
		BufferedReader in = new BufferedReader(new FileReader(filename));
		String line;
		Boolean isGraph = false;
		while((line=in.readLine())!=null){
			// System.out.println(line);   // debug
			if (line.startsWith("Graph")) {
				isGraph = true;
				in.readLine(); // skip line
				continue;
			}
			
			if (isGraph){
				int[][] matrix = new int[12][12];
				String[] tmp = new String[2];
				
				while(!line.startsWith("Taillenweite")){
					//System.out.println(line); //debug
					tmp= line.split(":");
					int i = Integer.parseInt(tmp[0].trim());
					String[] adj = new String[tmp[1].trim().split(" ").length];
					adj = tmp[1].trim().split(" ");
					for(int j=0; j<adj.length;j++){
						int k = Integer.parseInt(adj[j]);
						matrix[i-1][k-1]=1;
					}
					line = in.readLine();
				}
				isGraph = false;
				
				/*	debug print 
				System.out.println("Print adj. matrix");
				for(int i=0;i<12;i++){
					for(int j=0;j<12;j++){
						System.out.print(matrix[i][j] + " ");
					}
					System.out.println();
				}
				*/
				matrixGraphs.add(matrix);
			}
		}
		in.close();
	}
	
	ArrayList<String> FormatToGap() throws Exception{
		
		ArrayList<String> result = new ArrayList<String>();
		
		for(int i=0;i<this.matrixGraphs.size();i++){
			StringBuilder outputString = new StringBuilder();
			outputString.append("CharacteristicPolynomial([");
			
			for(int j=0;j<12;j++){ 
				outputString.append("[");
				for(int k=0; k<10; k++){
					outputString.append(matrixGraphs.get(i)[j-1][k-1]);
					outputString.append(",");
				}
				outputString.deleteCharAt(outputString.length()-1);
				outputString.append("],");
			}
			outputString.deleteCharAt(outputString.length()-1);
			outputString.append("]);\n");
			//System.out.println(outputString); //debug
			result.add(outputString.toString());
		}
		
		return result;
	}
	
	public static void main(String[] args) throws Exception {
		long start = System.currentTimeMillis();
		
		ParseASCFormat parseASCFormat = new ParseASCFormat();
		parseASCFormat.ParseASC("12_6_3.asc");
		System.out.println(parseASCFormat.matrixGraphs.size());
		long end = System.currentTimeMillis();
		System.out.println("Execution time was " + (end - start) + " ms.");
		
	}
}