package bridge;

import java.util.ArrayList;


public class DefaultBridge implements Bridge {

    private ArrayList<Road> roads = new ArrayList<Road>(); 
    private ArrayList<BridgeListener> listeners = new ArrayList<BridgeListener>();
    
        public DefaultBridge () {
    }

    public synchronized void createRoad (RoadData d) {
        Road r = new Road(this, d);
        roads.add(r);
        fireRoadCreated(r);
    }
    
    synchronized void roadDestroyed(Road r) {
        boolean b = roads.remove(r);
        fireRoadDestroyed(r);
    }
    
    public void addBridgeListener(BridgeListener l) {
        listeners.add(l);
    }
    
    public void removeBridgeListener(BridgeListener l) {
        listeners.remove(l);
    }
    
    private void fireRoadCreated(Road r) {
        BridgeEvent e = new BridgeEvent(this,r);
        for (BridgeListener l : listeners) {
            l.roadCreated(e);
        }
    }
    
    private void fireRoadDestroyed(Road r) {
        BridgeEvent e = new BridgeEvent(this,r);
        for (BridgeListener l : listeners) {
            l.roadDestroyed(e);
        }
    }
    
}

