package bridge;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class OneWayTransferer implements Runnable {

    private static int BUFFER_SIZE = 2048;
    private volatile boolean close = false;
    private Road road;
    private InputStream is;
    private OutputStream os;
    private Thread copyThread;
    private volatile long transfAmount = 0;

    public OneWayTransferer(Road r, InputStream is, OutputStream os) {
        road = r;
        this.is = is;
        this.os = os;
        copyThread = new Thread(this, "OneWayTransferer - copy thread");
        copyThread.start();
    }

    public void run() {
        byte[] buf = new byte[BUFFER_SIZE];
        int n;
        try {
            while ((n = is.read(buf)) != -1) {
                
            //    System.out.println(new String(buf,0,n));
                
                os.write(buf, 0, n);
                transfAmount += n;
                if (close) {
                    break;
                }
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        } finally {
            try {
                os.close();

            } catch (IOException ex) {
                ex.printStackTrace();
            }

            try {
                is.close();
            } catch (IOException ex) {
                ex.printStackTrace();
            }

            road.tranfererClosed(this);
        }

    }

    public void close() {
        close = true;
        copyThread.interrupt();
    }

    public long getTransfAmount() {
        return transfAmount;
    }
}

