package bridge;

import java.io.IOException;

public class Road {

    private OneWayTransferer[] oneWayTransferers = new OneWayTransferer[2];
    private RoadData roadData;
    private DefaultBridge bridge;
    private RoadDescriptor roadDescriptor;

    public Road(DefaultBridge bridge, RoadData d) {
        this.bridge = bridge;
        this.roadData = d;
        oneWayTransferers[0] = new OneWayTransferer(this, d.getIs1(), d.getOs2());
        oneWayTransferers[1] = new OneWayTransferer(this, d.getIs2(), d.getOs1());

        roadDescriptor = new RoadDescriptor() {

            public String getIP1() {
                return roadData.getSocket1().getInetAddress().getHostAddress();
            }

            public String getIP2() {
                return roadData.getSocket2().getInetAddress().getHostAddress();
            }

            public long getTranseferedAmout() {
                return oneWayTransferers[0].getTransfAmount() + oneWayTransferers[1].getTransfAmount();
            }
        };
    }

    public DefaultBridge getDefaultBridge() {
        return bridge;
    }

    public void setDefaultBridge(DefaultBridge val) {
        this.bridge = val;
    }

    OneWayTransferer[] getOneWayTransferer() {
        return oneWayTransferers;
    }

    synchronized void tranfererClosed(OneWayTransferer t) {
        try {
            if (t != oneWayTransferers[0]) {
                oneWayTransferers[0].close();
            }

            if (t != oneWayTransferers[1]) {
                oneWayTransferers[1].close();
            }

            try {
                getRoadData().getOs1().close();
            } catch (IOException ex) {
            }
            try {
                getRoadData().getIs1().close();
            } catch (IOException ex) {
            }

            try {
                getRoadData().getSocket1().close();
            } catch (IOException ex) {
            }

            try {
                getRoadData().getOs2().close();
            } catch (IOException ex) {
            }
            try {
                getRoadData().getIs2().close();
            } catch (IOException ex) {
            }

            try {
                getRoadData().getSocket2().close();
            } catch (IOException ex) {
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            bridge.roadDestroyed(this);
        }

    }

    public RoadData getRoadData() {
        return roadData;
    }

    public RoadDescriptor getRoadDescriptor() {
        return roadDescriptor;
    }
}

