package bridge;

import java.util.ArrayList;
import java.util.List;

public class RoutMatcher {

    protected Bridge bridge;
    private ArrayList<ConnectionInvitation> conInvitations = new ArrayList<ConnectionInvitation>();
    private ArrayList<ConnectionAnswer> conAnswers = new ArrayList<ConnectionAnswer>();
    private List<RoutMatcherListener> listeners = new ArrayList<RoutMatcherListener>();

    public RoutMatcher(Bridge b) {
        this.bridge = b;
    }

    public synchronized void addConnectionInvitation(ConnectionInvitation in) {
        ConnectionAnswer ans = null;
        for (ConnectionAnswer ca : getConAnswers()) {
            if (ca.getMyID().equals(in.getForeignID()) && ca.getConnectionType() == in.getConnectionType()) {
                ans = ca;
                break;
            }
        }
        if (ans != null) {
            getConAnswers().remove(ans);
            bridge.createRoad(new RoadData(in.getSocket(), in.getInputStream(), in.getOutputStream(),
                    ans.getSocket(), ans.getInputStream(), ans.getOutputStream()));
        } else {
            getConInvitations().add(in);
        }
        fireConnectionInvitationAdded(ans, in);
    }

    public synchronized void addConnectionAnswer(ConnectionAnswer ans) {
        ConnectionInvitation in = null;
        for (ConnectionInvitation cin : getConInvitations()) {
            if (ans.getMyID().equals(cin.getForeignID()) && ans.getConnectionType() == cin.getConnectionType()) {
                in = cin;
                break;
            }
        }
        if (in != null) {
            getConInvitations().remove(in);
            bridge.createRoad(new RoadData(in.getSocket(), in.getInputStream(), in.getOutputStream(),
                    ans.getSocket(), ans.getInputStream(), ans.getOutputStream()));
        } else {
            getConAnswers().add(ans);
        }
        fireConnectionAnswerAdded(ans, in);
    }

    public ArrayList<ConnectionInvitation> getConInvitations() {
        return conInvitations;
    }

    public ArrayList<ConnectionAnswer> getConAnswers() {
        return conAnswers;
    }

    private void fireConnectionAnswerAdded(ConnectionAnswer ca, ConnectionInvitation ci) {
        RoutMatcherEvent evt = new RoutMatcherEvent(this, ca, ci);
        for (RoutMatcherListener l : listeners) {
            l.ConnectionAnswerAdded(evt);
        }
    }

    private void fireConnectionInvitationAdded(ConnectionAnswer ca, ConnectionInvitation ci) {
        RoutMatcherEvent evt = new RoutMatcherEvent(this, ca, ci);
        for (RoutMatcherListener l : listeners) {
            l.ConnectionInvitationAdded(evt);
        }
    }
    
    public void addRoutMatcherListener(RoutMatcherListener l) { 
        listeners.add(l);
    }
    
    public void removeRoutMatcherListener(RoutMatcherListener l) {
        listeners.remove(l);
    }
}

