/*
 * ClientsTableModel.java
 *
 * Created on 24 May 2007, 00:08
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package client.gui;

import client.net.commun.NormalClient;
import client.net.commun.OutgoingConnectionListener;
import java.util.ArrayList;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author A
 */
public class ClientsTableModel extends AbstractTableModel implements OutgoingConnectionListener {
    private static final String[] colNames = new String[]{"Name","Description","Connections state","Passive"};
    private ArrayList<NormalClient> data = new ArrayList<NormalClient>();
    
    /** Creates a new instance of ClientsTableModel */
    public ClientsTableModel() {
    }
    
    public Object getValueAt(int rowIndex, int columnIndex) {
        NormalClient nc = data.get(rowIndex);
        switch (columnIndex) {
            case 0 : return nc.getName();
            case 1 : return nc.getDescription();
            case 2 : return nc.getState();
            case 3 : return nc.isPassive();
            default : return null;
        }
    }
    
    public int getRowCount() {
        return data.size();
    }
    
    public int getColumnCount() {
        return colNames.length;
    }
    
    public String getColumnName(int column) {
        return colNames[column];
    }
    
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 3 ? Boolean.class : String.class;
    }
    
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
    
    public NormalClient getNormalClient(int index) {
        return data.get(index);
    }
    
    public void clientStateChanged(NormalClient nc) {
        fireTableDataChanged();
    }
    
    public void connectedToClient(NormalClient nc) {
        data.add(nc);
        fireTableDataChanged();
    }
    
    public void disconnectedFrom(NormalClient nc) {
        data.remove(nc);
        fireTableDataChanged();
    }
    
}
