/*
 * FileSendTableModel.java
 *
 * Created on 04 August 2007, 20:07
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package client.gui;

import common.Toolkit;
import client.net.transfer.FileReceiver;
import client.net.transfer.FileSender;
import client.net.transfer.FileSendingStateListener;
import client.net.transfer.RecieveInetrruptionEvent;
import client.net.transfer.SendInterruptEvent;
import client.net.transfer.ClientFileDescriptor;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author A
 */
public class FileSendTableModel extends AbstractTableModel implements FileSendingStateListener {
    public static final int REFRESH_PERIOD = 700;
    
    private ArrayList<FileSender> senders = new ArrayList<FileSender>();
    private String[] columNames =  new String[]{"File name","Size","Sended","State"};
    private Timer timer;
    /** Creates a new instance of FileSendTableModel */
    public FileSendTableModel() {
        timer = new Timer();
        timer.schedule(new TimerTask() {
            public void run() {
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        fireTableRowsUpdated(0,getRowCount()-1);
                    }
                });
            }
        },0,REFRESH_PERIOD);
    }
    
    public Object getValueAt(int rowIndex, int columnIndex) {
        FileSender fs = senders.get(rowIndex);
        
        switch (columnIndex) {
            case 0 : return fs.getFileName();
            case 1 : return Toolkit.formatSize(fs.getFileSize());
            case 2 : {  
                String res =(long)( ((long)fs.getProgress()) * 100 / (long)fs.getFileSize() ) + " %";
            return res;
            }
            case 3 : {
                switch (fs.getState()) {
                    case FileSender.SENDING : return "Sending";
                    case FileSender.INTERRUPTED : return "Interruted";
                    case FileSender.CANNOT_START : return "Cannot start upload";
                    case FileSender.SEND_COMPLETED : return "Completed";
                    case FileSender.PAUSED : return "Paused";
                }
            }
        }
        return null;
    }
    
    public int getRowCount() {
        return senders.size();
    }
    
    public int getColumnCount() {
        return columNames.length;
    }
    
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }
    
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
    
    
    public String getColumnName(int column) {
        return columNames[column];
    }
    
    public void sendingInterrupted(SendInterruptEvent evt) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                fireTableDataChanged();
            }
        });
    }
    
    public synchronized void sendingStarted(final FileSender s) {
        
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                senders.add(s);
                fireTableDataChanged();
            }
        });
    }
    
    public void sendingCompleted(FileSender s) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                fireTableDataChanged();
            }
        });
    }
    
    public void clear() {
        for (int i = senders.size()-1; i >= 0; i--) {
            int state = senders.get(i).getState();
            if (state == FileSender.SEND_COMPLETED || state == FileSender.INTERRUPTED)
                senders.remove(i);
        }
        fireTableDataChanged();
    }
    
    public FileSender getFileSender(int row) {
        return senders.get(row);
    }
}
