/*
 * MainFrame.java
 *
 * Created on 23 February 2007, 13:33
 */
package client.gui;

import client.MainClass;
import client.OptionalValueProvider;
import client.net.commun.HumpClient;
import client.net.commun.NormalClient;
import common.StaticValues;
import client.net.commun.PossibleClientDescriptor;
import client.net.commun.ServerClient;
import client.net.lan.LANClientDescriptor;
import client.net.transfer.FileReceiver;
import client.net.transfer.FileSender;
import client.net.transfer.ClientFileDescriptor;
import common.Toolkit;
import exceptions.MyException;
import exceptions.MyRuntimeException;
import exceptions.StandardExceptionMessageProvider;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SplashScreen;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;

/**
 *
 * @author  A
 */
public class MainFrame extends javax.swing.JFrame {

    public static final boolean TRAY_FLAG = false;
    public static boolean DEBUG = true;
    public static final boolean EMBEDDED_DB = true;
    private MainClass mainClass;
    private ServerTPConnectionDialog stpConnectionDialog;
    private UserManagerDialog userManagerDialog;
    private ConnectionDialog connectionDialog;
    private OptionsDialog optionsDialog;
    private IncomingConnectionsTableModel incomConTableModel;
    private ClientsTableModel clientsTableModel;
    private ShareDialog shareDialog;
    private DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
    private DefaultTreeModel availableFTreeModel = new DefaultTreeModel(null);
    private DownloadTableModel downloadTableModel = new DownloadTableModel();
    private FileSendTableModel uploadTableModel = new FileSendTableModel();
    private ServersTableModel serversTableModel = new ServersTableModel();
    private LANClientListModel lanClientsListModel = new LANClientListModel();
    private DefaultListModel serversClientsListModel = new DefaultListModel();
    private AboutDialog aboutDialog = new AboutDialog(this,true);
    public static ImageIcon icon;
    private TrayIcon trayIcon;
    private SystemTray systemTray;
    private Desktop desktop = null;

    /** Creates new form MainFrame */
    public MainFrame() {

        try {
            icon = new ImageIcon("images" + File.separator + "turtle.gif");
            mainClass = new MainClass();
            userManagerDialog = new UserManagerDialog(this, true, mainClass.getSharingManager());
            connectionDialog = new ConnectionDialog(this, true, mainClass.getClientManager());
            optionsDialog = new OptionsDialog(this, true);
            stpConnectionDialog = new ServerTPConnectionDialog(this, true, mainClass.getClientManager());

            incomConTableModel = new IncomingConnectionsTableModel();
            mainClass.getClientManager().addClientListener(incomConTableModel);
            clientsTableModel = new ClientsTableModel();

            mainClass.getClientManager().addOutgoingConnectionListener(clientsTableModel);
            mainClass.getClientManager().addServerConnectionListener(serversTableModel);
            mainClass.getTransferManager().addFileRecievingStateListener(downloadTableModel);
            mainClass.getTransferManager().addFileSendingStateListener(uploadTableModel);

            if (mainClass.getLanManager().isFunctional()) {
                mainClass.getLanManager().addLANClientListener(lanClientsListModel);
            }

            initComponents();
            initMyComponents();


            removeSplashScreen();

        } catch (Exception ex) {
            ex.printStackTrace();
            showErrorDialog(ex);
            System.exit(0);
        }


    }

    private void initMyComponents() {
        if (SystemTray.isSupported() && TRAY_FLAG) {
            trayIcon = new TrayIcon(icon.getImage());
            systemTray = SystemTray.getSystemTray();
            PopupMenu popM = new PopupMenu("Turtle");

            trayIcon.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.setVisible(true);
                }
            });

            MenuItem trayExMI = new MenuItem("Exit");
            trayExMI.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e) {
                    System.exit(1);
                }
            });

            MenuItem trayShowMI = new MenuItem("Show");
            trayShowMI.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.setVisible(true);
                }
            });

            popM.add(trayShowMI);
            popM.addSeparator();
            popM.add(trayExMI);

            trayIcon.setPopupMenu(popM);
            try {
                systemTray.add(trayIcon);
            } catch (AWTException ex) {
                ex.printStackTrace();
                setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            }

        } else {
            setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        }

        if (Desktop.isDesktopSupported()) {
            desktop = Desktop.getDesktop();
        } else {
            openFileButton.setEnabled(false);
            exploreFileB.setEnabled(false);
        }

        treeSelectionModel.setSelectionMode(DefaultTreeSelectionModel.SINGLE_TREE_SELECTION);
        treeSelectionModel.addTreeSelectionListener(new TreeSelectionListener() {

            public void valueChanged(TreeSelectionEvent e) {
                CommonTreeNode tn = (CommonTreeNode) availableFilesTree.getLastSelectedPathComponent();
                if (tn == null) {
                    fileNameLabel.setText("");
                    fileSizeLabel.setText("");
                    fileAccessLabel.setText("");
                    return;
                }

                ClientFileDescriptor cfd = (ClientFileDescriptor) tn.getAbstractFileDescriptor();

                if (cfd.isDirectory()) {
                    fileNameLabel.setText(cfd.getFileName());
                    fileSizeLabel.setText("N/A");
                    if (cfd.getPublicAccessiblity() == StaticValues.DOWNLOADABLE_FILE) {
                        fileAccessLabel.setText("Downloadable");
                    } else {
                        fileAccessLabel.setText("Visible");
                    }

                } else {
                    String fname = cfd.getFileName() + (cfd.getExtension().length() > 0 ? "." + cfd.getExtension() : "");
                    fileNameLabel.setText(fname);
                    fileSizeLabel.setText(Toolkit.formatSize(cfd.getSize()));
                    if (cfd.getPublicAccessiblity() == StaticValues.DOWNLOADABLE_FILE) {
                        fileAccessLabel.setText("Downloadable");
                    } else {
                        fileAccessLabel.setText("Visible");
                    }

                }

                if (!cfd.isDirectory() && cfd.getPublicAccessiblity() == StaticValues.DOWNLOADABLE_FILE) {
                    downloadButton.setEnabled(true);
                } else {
                    downloadButton.setEnabled(false);
                }

            }
        });


        shareDialog = new ShareDialog(this, true, mainClass.getSharingManager());

        clientsTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        clientsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    int index = ((ListSelectionModel) e.getSource()).getMinSelectionIndex();
                    if (index == -1) {
                        availableFTreeModel.setRoot(null);
                        clientNameLabel.setText("");
                        isPassiveLabel.setText("");
                        descripionLabel.setText("");
                        hostLabel.setText("");
                        disconnectButton.setEnabled(false);
                    } else {
                        disconnectButton.setEnabled(true);
                        NormalClient nc = clientsTableModel.getNormalClient(index);
                        ArrayList<ClientFileDescriptor> cfd = nc.getSharedFiles();
                        if (cfd != null) {
                            availableFTreeModel.setRoot(new CommonTreeNode(cfd));
                        }

                        clientNameLabel.setText(nc.getName());
                        isPassiveLabel.setText(nc.isPassive() ? "true" : "false");
                        descripionLabel.setText(nc.getDescription());
                        hostLabel.setText(nc.getIPAdress());

                    }
                }
            }
        });

        incomConnTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        incomConnTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    int index = ((ListSelectionModel) e.getSource()).getMinSelectionIndex();
                    if (index == -1) {
                        incClientHostLabel.setText("");
                        incClientIsPassLabel.setText("");
                        incClientNameLabel.setText("");
                        incClintDescLabel.setText("");
                    } else {
                        HumpClient nc = incomConTableModel.getHumpClient(index);
                        incClientHostLabel.setText(nc.getIPAdress());
                        incClientIsPassLabel.setText(Boolean.toString(nc.isPassive()));
                        incClientNameLabel.setText(nc.getName());
                        incClintDescLabel.setText(nc.getDescription());
                    }
                }
            }
        });


        serversTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        serversTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    int row = serversTable.getSelectedRow();
                    serversClientsListModel.removeAllElements();
                    if (row != -1) {
                        ServerClient sc = serversTableModel.getServerClient(row);
                        ArrayList<PossibleClientDescriptor> possClients = sc.getPossibleClients();
                        for (PossibleClientDescriptor p : possClients) {
                            serversClientsListModel.addElement(p);
                        }
                    }
                }
            }
        });

        clientOnServerList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        clientOnServerList.getSelectionModel().addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    int index = clientOnServerList.getSelectedIndex();
                    if (index != -1) {
                        PossibleClientDescriptor d = (PossibleClientDescriptor) serversClientsListModel.getElementAt(index);
                        scConPortLabel.setText("" + d.getConnectionPort());
                        scDescLabel.setText(d.getDescription());
                        scNameLabel.setText(d.getName());
                        scPassiveLabel.setText("" + d.isPassive());
                        scSharesLabel.setText("" + d.getShareAmount() + " Bytes");
                    } else {
                        scConPortLabel.setText("");
                        scDescLabel.setText("");
                        scNameLabel.setText("");
                        scPassiveLabel.setText("");
                        scSharesLabel.setText("");
                    }
                }
            }
        });

        mainClass.getSharingManager().addGroupRegisterListener(userManagerDialog);
        mainClass.getSharingManager().addRegisteredUserListener(userManagerDialog);
        mainClass.getSharingManager().addGroupRegisterListener(shareDialog);
        lanClientsRefreshB.setEnabled(mainClass.getLanManager().isFunctional());
    }

    private void removeSplashScreen() {
        SplashScreen sc = SplashScreen.getSplashScreen();
        if (sc != null) {
            sc.close();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainTabbedPane = new javax.swing.JTabbedPane();
        clientsPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        clientsTable = new javax.swing.JTable();
        jScrollPane2 = new javax.swing.JScrollPane();
        availableFilesTree = new javax.swing.JTree();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        fileNameLabel = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        fileSizeLabel = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        fileAccessLabel = new javax.swing.JLabel();
        downloadButton = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        clientNameLabel = new javax.swing.JLabel();
        isPassiveLabel = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        descripionLabel = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        hostLabel = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        disconnectButton = new javax.swing.JButton();
        clearClientsB = new javax.swing.JButton();
        jPanel8 = new javax.swing.JPanel();
        jScrollPane6 = new javax.swing.JScrollPane();
        serversTable = new javax.swing.JTable();
        jScrollPane7 = new javax.swing.JScrollPane();
        clientOnServerList = new javax.swing.JList();
        jPanel9 = new javax.swing.JPanel();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        jLabel17 = new javax.swing.JLabel();
        scNameLabel = new javax.swing.JLabel();
        scDescLabel = new javax.swing.JLabel();
        scPassiveLabel = new javax.swing.JLabel();
        scConPortLabel = new javax.swing.JLabel();
        scSharesLabel = new javax.swing.JLabel();
        possibleClientConnectB = new javax.swing.JButton();
        servConnectButton = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        transfSplitpane = new javax.swing.JSplitPane();
        jPanel6 = new javax.swing.JPanel();
        jScrollPane4 = new javax.swing.JScrollPane();
        dowloadTable = new javax.swing.JTable();
        downloadClearButton = new javax.swing.JButton();
        jToolBar1 = new javax.swing.JToolBar();
        openFileButton = new javax.swing.JButton();
        exploreFileB = new javax.swing.JButton();
        jSeparator2 = new javax.swing.JSeparator();
        continueTarnsfButton = new javax.swing.JButton();
        transfPauseButton = new javax.swing.JButton();
        jPanel7 = new javax.swing.JPanel();
        jScrollPane5 = new javax.swing.JScrollPane();
        uploadsTable = new javax.swing.JTable();
        uploadClearButton = new javax.swing.JButton();
        jToolBar2 = new javax.swing.JToolBar();
        contUploadButton = new javax.swing.JButton();
        pauseUploadButton = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        incomConnTable = new javax.swing.JTable();
        jPanel5 = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        incClientNameLabel = new javax.swing.JLabel();
        incClintDescLabel = new javax.swing.JLabel();
        incClientIsPassLabel = new javax.swing.JLabel();
        incClientHostLabel = new javax.swing.JLabel();
        jPanel10 = new javax.swing.JPanel();
        jPanel11 = new javax.swing.JPanel();
        jScrollPane8 = new javax.swing.JScrollPane();
        lanClientList = new javax.swing.JList();
        lanClientsRefreshB = new javax.swing.JButton();
        jPanel12 = new javax.swing.JPanel();
        lanClientConnectButton = new javax.swing.JButton();
        jLabel18 = new javax.swing.JLabel();
        jLabel19 = new javax.swing.JLabel();
        jLabel20 = new javax.swing.JLabel();
        jLabel21 = new javax.swing.JLabel();
        lanCNameLabel = new javax.swing.JLabel();
        lanCDescLabel = new javax.swing.JLabel();
        lanCIPAddLabel = new javax.swing.JLabel();
        lanCConPort = new javax.swing.JLabel();
        jPanel13 = new javax.swing.JPanel();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        userManagerMI = new javax.swing.JMenuItem();
        connectMI = new javax.swing.JMenuItem();
        optionsMI = new javax.swing.JMenuItem();
        shareMI = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenu2 = new javax.swing.JMenu();
        jMenuItem2 = new javax.swing.JMenuItem();

        setTitle("Turtle - Client");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        setIconImage(icon.getImage());

        mainTabbedPane.setName(""); // NOI18N

        clientsTable.setModel(clientsTableModel);
        jScrollPane1.setViewportView(clientsTable);

        availableFilesTree.setBorder(javax.swing.BorderFactory.createTitledBorder("Shared files"));
        availableFilesTree.setCellRenderer(new CommonTreeCellRenderer(false));
        availableFilesTree.setModel(availableFTreeModel);
        availableFilesTree.setRootVisible(false);
        availableFilesTree.setSelectionModel(treeSelectionModel);
        jScrollPane2.setViewportView(availableFilesTree);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("File/Folder"));

        jLabel1.setText("Name");

        jLabel3.setText("Size");

        jLabel5.setText("Access");

        downloadButton.setText("Download");
        downloadButton.setEnabled(false);
        downloadButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                downloadButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3)
                    .addComponent(jLabel5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(fileNameLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 242, Short.MAX_VALUE)
                    .addComponent(fileSizeLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 242, Short.MAX_VALUE)
                    .addComponent(fileAccessLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 242, Short.MAX_VALUE)))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(downloadButton))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(fileNameLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(fileSizeLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(fileAccessLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE)
                .addComponent(downloadButton))
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Client"));

        jLabel2.setText("Client name");

        jLabel4.setText("Is passive");

        jLabel8.setText("Description");

        jLabel10.setText("Host");

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2)
                    .addComponent(jLabel4)
                    .addComponent(jLabel8)
                    .addComponent(jLabel10))
                .addGap(22, 22, 22)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(clientNameLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 215, Short.MAX_VALUE)
                    .addComponent(isPassiveLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 215, Short.MAX_VALUE)
                    .addComponent(descripionLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 215, Short.MAX_VALUE)
                    .addComponent(hostLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 215, Short.MAX_VALUE)))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(clientNameLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(isPassiveLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel8)
                    .addComponent(descripionLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel10)
                    .addComponent(hostLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jButton1.setText("Connect...");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        disconnectButton.setText("Disconnect");
        disconnectButton.setToolTipText("Disconnect from selected user");
        disconnectButton.setEnabled(false);
        disconnectButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                disconnectButtonActionPerformed(evt);
            }
        });

        clearClientsB.setText("Clear");
        clearClientsB.setToolTipText("Removes all clients in disconnected state");
        clearClientsB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearClientsBActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout clientsPanelLayout = new javax.swing.GroupLayout(clientsPanel);
        clientsPanel.setLayout(clientsPanelLayout);
        clientsPanelLayout.setHorizontalGroup(
            clientsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, clientsPanelLayout.createSequentialGroup()
                .addGroup(clientsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 581, Short.MAX_VALUE)
                    .addGroup(clientsPanelLayout.createSequentialGroup()
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 266, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(clientsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, clientsPanelLayout.createSequentialGroup()
                                .addComponent(clearClientsB)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 76, Short.MAX_VALUE)
                                .addComponent(disconnectButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButton1))
                            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addContainerGap())
        );
        clientsPanelLayout.setVerticalGroup(
            clientsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(clientsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 159, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(clientsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 282, Short.MAX_VALUE)
                    .addGroup(clientsPanelLayout.createSequentialGroup()
                        .addGroup(clientsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jButton1)
                            .addComponent(disconnectButton)
                            .addComponent(clearClientsB))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );

        mainTabbedPane.addTab("Clients", clientsPanel);

        serversTable.setModel(serversTableModel);
        jScrollPane6.setViewportView(serversTable);

        clientOnServerList.setModel(serversClientsListModel);
        jScrollPane7.setViewportView(clientOnServerList);

        jPanel9.setBorder(javax.swing.BorderFactory.createTitledBorder("Client on server"));

        jLabel12.setText("Name");

        jLabel13.setText("Description");

        jLabel14.setText("Passive");

        jLabel16.setText("Connetion port");

        jLabel17.setText("Shares");

        possibleClientConnectB.setText("Connect to client...");
        possibleClientConnectB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                possibleClientConnectBActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel9Layout = new javax.swing.GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel9Layout.createSequentialGroup()
                        .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel12)
                            .addComponent(jLabel13)
                            .addComponent(jLabel14)
                            .addComponent(jLabel16)
                            .addComponent(jLabel17))
                        .addGap(30, 30, 30)
                        .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(scNameLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 158, Short.MAX_VALUE)
                            .addComponent(scDescLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 158, Short.MAX_VALUE)
                            .addComponent(scPassiveLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 158, Short.MAX_VALUE)
                            .addComponent(scConPortLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 158, Short.MAX_VALUE)
                            .addComponent(scSharesLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 158, Short.MAX_VALUE))
                        .addContainerGap())
                    .addComponent(possibleClientConnectB, javax.swing.GroupLayout.Alignment.TRAILING)))
        );
        jPanel9Layout.setVerticalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel12)
                    .addComponent(scNameLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel13)
                    .addComponent(scDescLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel14)
                    .addComponent(scPassiveLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel16)
                    .addComponent(scConPortLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel17)
                    .addComponent(scSharesLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 97, Short.MAX_VALUE)
                .addComponent(possibleClientConnectB))
        );

        servConnectButton.setText("Connect...");
        servConnectButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                servConnectButtonActionPerformed(evt);
            }
        });

        jButton3.setText("Disconnect");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel8Layout = new javax.swing.GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel8Layout.createSequentialGroup()
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane6, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 581, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel8Layout.createSequentialGroup()
                        .addComponent(jScrollPane7, javax.swing.GroupLayout.PREFERRED_SIZE, 279, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(jPanel8Layout.createSequentialGroup()
                                .addComponent(jButton3)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(servConnectButton))
                            .addComponent(jPanel9, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel8Layout.setVerticalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane6, javax.swing.GroupLayout.PREFERRED_SIZE, 157, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanel8Layout.createSequentialGroup()
                        .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(servConnectButton)
                            .addComponent(jButton3))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel9, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(jScrollPane7, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE))
                .addContainerGap())
        );

        mainTabbedPane.addTab("Servers", jPanel8);

        transfSplitpane.setDividerLocation(260);
        transfSplitpane.setDividerSize(6);
        transfSplitpane.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jPanel6.setBorder(javax.swing.BorderFactory.createTitledBorder("Downloads"));

        dowloadTable.setModel(downloadTableModel);
        jScrollPane4.setViewportView(dowloadTable);

        downloadClearButton.setText("Clear");
        downloadClearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                downloadClearButtonActionPerformed(evt);
            }
        });

        jToolBar1.setFloatable(false);

        openFileButton.setText("Open");
        openFileButton.setToolTipText("Open");
        openFileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openFileButtonActionPerformed(evt);
            }
        });
        jToolBar1.add(openFileButton);

        exploreFileB.setText("Explore");
        exploreFileB.setToolTipText("Explore");
        exploreFileB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exploreFileBActionPerformed(evt);
            }
        });
        jToolBar1.add(exploreFileB);

        jSeparator2.setOrientation(javax.swing.SwingConstants.VERTICAL);
        jToolBar1.add(jSeparator2);

        continueTarnsfButton.setText("Continue");
        continueTarnsfButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                continueTarnsfButtonActionPerformed(evt);
            }
        });
        jToolBar1.add(continueTarnsfButton);

        transfPauseButton.setText("Pause");
        transfPauseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                transfPauseButtonActionPerformed(evt);
            }
        });
        jToolBar1.add(transfPauseButton);

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane4, javax.swing.GroupLayout.DEFAULT_SIZE, 553, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 316, Short.MAX_VALUE)
                .addComponent(downloadClearButton))
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane4, javax.swing.GroupLayout.DEFAULT_SIZE, 187, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(downloadClearButton)
                    .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        transfSplitpane.setTopComponent(jPanel6);

        jPanel7.setBorder(javax.swing.BorderFactory.createTitledBorder("Uploads"));

        uploadsTable.setModel(uploadTableModel);
        jScrollPane5.setViewportView(uploadsTable);

        uploadClearButton.setText("Clear");
        uploadClearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                uploadClearButtonActionPerformed(evt);
            }
        });

        jToolBar2.setFloatable(false);

        contUploadButton.setText("Continue");
        contUploadButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                contUploadButtonActionPerformed(evt);
            }
        });
        jToolBar2.add(contUploadButton);

        pauseUploadButton.setText("Pause");
        pauseUploadButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pauseUploadButtonActionPerformed(evt);
            }
        });
        jToolBar2.add(pauseUploadButton);

        javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup()
                .addComponent(jToolBar2, javax.swing.GroupLayout.PREFERRED_SIZE, 158, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 338, Short.MAX_VALUE)
                .addComponent(uploadClearButton))
            .addComponent(jScrollPane5, javax.swing.GroupLayout.DEFAULT_SIZE, 553, Short.MAX_VALUE)
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup()
                .addComponent(jScrollPane5, javax.swing.GroupLayout.DEFAULT_SIZE, 119, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(uploadClearButton)
                    .addComponent(jToolBar2, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        transfSplitpane.setRightComponent(jPanel7);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(transfSplitpane, javax.swing.GroupLayout.DEFAULT_SIZE, 571, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(transfSplitpane, javax.swing.GroupLayout.DEFAULT_SIZE, 447, Short.MAX_VALUE)
                .addContainerGap())
        );

        mainTabbedPane.addTab("Transfers", jPanel2);

        incomConnTable.setModel(incomConTableModel);
        jScrollPane3.setViewportView(incomConnTable);

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder("Client properties"));

        jLabel6.setText("Client name");

        jLabel7.setText("Description");

        jLabel9.setText("Is passive");

        jLabel11.setText("Host");

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel6, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel7)
                    .addComponent(jLabel9)
                    .addComponent(jLabel11))
                .addGap(25, 25, 25)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(incClientHostLabel)
                    .addComponent(incClientIsPassLabel)
                    .addComponent(incClintDescLabel)
                    .addComponent(incClientNameLabel))
                .addContainerGap(446, Short.MAX_VALUE))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(incClientNameLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel7)
                    .addComponent(incClintDescLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel9)
                    .addComponent(incClientIsPassLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel11)
                    .addComponent(incClientHostLabel))
                .addContainerGap(30, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 571, Short.MAX_VALUE)
                    .addComponent(jPanel5, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 307, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        mainTabbedPane.addTab("Incoming connections", jPanel3);

        jPanel11.setBorder(javax.swing.BorderFactory.createTitledBorder("LAN Clients"));

        lanClientList.setModel(lanClientsListModel);
        lanClientList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        lanClientList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                lanClientListValueChanged(evt);
            }
        });
        jScrollPane8.setViewportView(lanClientList);

        lanClientsRefreshB.setText("Refresh list");
        lanClientsRefreshB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lanClientsRefreshBActionPerformed(evt);
            }
        });

        jPanel12.setBorder(javax.swing.BorderFactory.createTitledBorder("Client details"));

        lanClientConnectButton.setText("Connect");
        lanClientConnectButton.setEnabled(false);
        lanClientConnectButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lanClientConnectButtonActionPerformed(evt);
            }
        });

        jLabel18.setText("Name");

        jLabel19.setText("Description");

        jLabel20.setText("IP Address");

        jLabel21.setText("Connection port");

        javax.swing.GroupLayout jPanel12Layout = new javax.swing.GroupLayout(jPanel12);
        jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(
            jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel12Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lanClientConnectButton, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanel12Layout.createSequentialGroup()
                        .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel21, javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel20, javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel19, javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel18, javax.swing.GroupLayout.Alignment.LEADING))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 113, Short.MAX_VALUE)
                        .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lanCNameLabel)
                            .addComponent(lanCDescLabel)
                            .addComponent(lanCConPort)
                            .addComponent(lanCIPAddLabel))
                        .addGap(104, 104, 104))))
        );
        jPanel12Layout.setVerticalGroup(
            jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel12Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel18)
                    .addComponent(lanCNameLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel19)
                    .addComponent(lanCDescLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel20)
                    .addComponent(lanCIPAddLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel21)
                    .addComponent(lanCConPort))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 72, Short.MAX_VALUE)
                .addComponent(lanClientConnectButton))
        );

        javax.swing.GroupLayout jPanel11Layout = new javax.swing.GroupLayout(jPanel11);
        jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(
            jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel11Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel11Layout.createSequentialGroup()
                        .addComponent(jScrollPane8, javax.swing.GroupLayout.PREFERRED_SIZE, 209, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel12, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(lanClientsRefreshB))
                .addContainerGap())
        );
        jPanel11Layout.setVerticalGroup(
            jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel11Layout.createSequentialGroup()
                .addGroup(jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel12, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jScrollPane8, javax.swing.GroupLayout.DEFAULT_SIZE, 210, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lanClientsRefreshB))
        );

        jPanel13.setBorder(javax.swing.BorderFactory.createTitledBorder("Friends"));

        javax.swing.GroupLayout jPanel13Layout = new javax.swing.GroupLayout(jPanel13);
        jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(
            jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 555, Short.MAX_VALUE)
        );
        jPanel13Layout.setVerticalGroup(
            jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 142, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout jPanel10Layout = new javax.swing.GroupLayout(jPanel10);
        jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(
            jPanel10Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel10Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel10Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel13, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel11, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel10Layout.setVerticalGroup(
            jPanel10Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel10Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel11, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel13, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        mainTabbedPane.addTab("Possible Clients", jPanel10);

        jMenu1.setText("Menu");

        userManagerMI.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_U, java.awt.event.InputEvent.ALT_MASK));
        userManagerMI.setText("User Manager");
        userManagerMI.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                userManagerMIActionPerformed(evt);
            }
        });
        jMenu1.add(userManagerMI);

        connectMI.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.ALT_MASK));
        connectMI.setText("Connection Manager");
        connectMI.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                connectMIActionPerformed(evt);
            }
        });
        jMenu1.add(connectMI);

        optionsMI.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.ALT_MASK));
        optionsMI.setText("Options...");
        optionsMI.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                optionsMIActionPerformed(evt);
            }
        });
        jMenu1.add(optionsMI);

        shareMI.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.ALT_MASK));
        shareMI.setText("Share...");
        shareMI.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                shareMIActionPerformed(evt);
            }
        });
        jMenu1.add(shareMI);
        jMenu1.add(jSeparator1);

        jMenuItem1.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_X, java.awt.event.InputEvent.ALT_MASK));
        jMenuItem1.setText("Exit");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });
        jMenu1.add(jMenuItem1);

        jMenuBar1.add(jMenu1);

        jMenu2.setText("Help");

        jMenuItem2.setText("About");
        jMenuItem2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem2ActionPerformed(evt);
            }
        });
        jMenu2.add(jMenuItem2);

        jMenuBar1.add(jMenu2);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(mainTabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 596, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(mainTabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 497, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void lanClientConnectButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lanClientConnectButtonActionPerformed
        int index = lanClientList.getSelectedIndex();
        if (index != -1) {
            connectionDialog.setVisible(lanClientsListModel.getDescriptorAt(index));

        } else {
            connectionDialog.setVisible(true);
        }
    }//GEN-LAST:event_lanClientConnectButtonActionPerformed

    private void lanClientListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_lanClientListValueChanged
        if (evt.getValueIsAdjusting() == false) {
            int index = lanClientList.getSelectedIndex();
            if (index != -1) {
                LANClientDescriptor ldesc = lanClientsListModel.getDescriptorAt(index);
                lanCNameLabel.setText(ldesc.getName());
                lanCDescLabel.setText(ldesc.getDescription());
                lanCIPAddLabel.setText(ldesc.getHost().getHostAddress());
                lanCConPort.setText("" + ldesc.getPort());
                lanClientConnectButton.setEnabled(true);
            } else {
                lanCNameLabel.setText("");
                lanCDescLabel.setText("");
                lanCIPAddLabel.setText("");
                lanCConPort.setText("");
                lanClientConnectButton.setEnabled(false);
            }
        }
    }//GEN-LAST:event_lanClientListValueChanged

    private void pauseUploadButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pauseUploadButtonActionPerformed
        int selRow = uploadsTable.getSelectedRow();
        if (selRow != -1) {
            FileSender fr = uploadTableModel.getFileSender(selRow);
            fr.pause();
        }
    }//GEN-LAST:event_pauseUploadButtonActionPerformed

    private void contUploadButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_contUploadButtonActionPerformed
        int selRow = uploadsTable.getSelectedRow();
        if (selRow != -1) {
            FileSender fr = uploadTableModel.getFileSender(selRow);
            fr.continuE();
        }
    }//GEN-LAST:event_contUploadButtonActionPerformed

    private void continueTarnsfButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_continueTarnsfButtonActionPerformed
        if (dowloadTable.getSelectedRow() != -1) {
            FileReceiver fc = downloadTableModel.getFileReciever(dowloadTable.getSelectedRow());
            fc.continuE();
        }
    }//GEN-LAST:event_continueTarnsfButtonActionPerformed

    private void transfPauseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_transfPauseButtonActionPerformed
        if (dowloadTable.getSelectedRow() != -1) {
            FileReceiver fc = downloadTableModel.getFileReciever(dowloadTable.getSelectedRow());
            fc.pause();
        }
    }//GEN-LAST:event_transfPauseButtonActionPerformed

    private void lanClientsRefreshBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lanClientsRefreshBActionPerformed
        try {
            mainClass.getLanManager().refreshLANClientList();
        } catch (IOException ex) {
            ex.printStackTrace();
            showErrorDialog(ex);
        } catch (Exception ex) {
            ex.printStackTrace();
            showErrorDialog(ex);
        }
    }//GEN-LAST:event_lanClientsRefreshBActionPerformed

    private void exploreFileBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exploreFileBActionPerformed
        try {
            if (desktop != null) {
                if (dowloadTable.getSelectedRow() != -1) {
                    File f = downloadTableModel.getFileReciever(dowloadTable.getSelectedRow()).getFile().getParentFile();
                    if (f.exists()) {
                        desktop.open(f);
                    }
                } else {
                    desktop.open(new File(OptionalValueProvider.getDownloadDir()));
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.toString(), "Internal Error! : " + ex.getMessage(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_exploreFileBActionPerformed

    private void openFileButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openFileButtonActionPerformed
        try {
            if (desktop != null && dowloadTable.getSelectedRow() != -1) {
                File f = downloadTableModel.getFileReciever(dowloadTable.getSelectedRow()).getFile();
                if (f.exists()) {
                    desktop.open(f);
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.toString(), "Internal Error! : " + ex.getMessage(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_openFileButtonActionPerformed

    private void servConnectButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_servConnectButtonActionPerformed
        int index = clientOnServerList.getSelectedIndex();

        if (index != -1) {
            PossibleClientDescriptor d = (PossibleClientDescriptor) serversClientsListModel.getElementAt(index);
            connectionDialog.setVisible(d);
        } else {
            connectionDialog.setVisible(true);
        }
    }//GEN-LAST:event_servConnectButtonActionPerformed

    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
        System.exit(1);
    }//GEN-LAST:event_jMenuItem1ActionPerformed

    private void disconnectButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_disconnectButtonActionPerformed
        int row = clientsTable.getSelectedRow();
        NormalClient nc = clientsTableModel.getNormalClient(row);
        mainClass.getClientManager().disconnectNonServerClient(nc);
    }//GEN-LAST:event_disconnectButtonActionPerformed

    private void uploadClearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_uploadClearButtonActionPerformed
        uploadTableModel.clear();
        mainClass.getTransferManager().clearSenders();
    }//GEN-LAST:event_uploadClearButtonActionPerformed

    private void downloadClearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_downloadClearButtonActionPerformed
        downloadTableModel.clear();
        mainClass.getTransferManager().clearReciever();
    }//GEN-LAST:event_downloadClearButtonActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        connectionDialog.setVisible(true);
    }//GEN-LAST:event_jButton1ActionPerformed

    private void downloadButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_downloadButtonActionPerformed
        CommonTreeNode tn = (CommonTreeNode) availableFilesTree.getLastSelectedPathComponent();
        ClientFileDescriptor cfd = (ClientFileDescriptor) tn.getAbstractFileDescriptor();
        try {
            mainClass.getTransferManager().downloadFile(cfd);

        } catch (IOException ex) {
            ex.printStackTrace();
            showErrorDialog(ex);
        } catch (Exception ex) {
            showErrorDialog(ex);
        }
        
    }//GEN-LAST:event_downloadButtonActionPerformed

    private void shareMIActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_shareMIActionPerformed
        shareDialog.setVisible(true);
    }//GEN-LAST:event_shareMIActionPerformed

    private void optionsMIActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_optionsMIActionPerformed
        optionsDialog.setVisible(true);
    }//GEN-LAST:event_optionsMIActionPerformed

    private void connectMIActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_connectMIActionPerformed
        connectionDialog.setVisible(true);
    }//GEN-LAST:event_connectMIActionPerformed

    private void userManagerMIActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_userManagerMIActionPerformed
        userManagerDialog.setVisible(true);
    }//GEN-LAST:event_userManagerMIActionPerformed

    private void possibleClientConnectBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_possibleClientConnectBActionPerformed
        try {
            int index = clientOnServerList.getSelectedIndex();

            if (index != -1) {
                PossibleClientDescriptor d = (PossibleClientDescriptor) serversClientsListModel.getElementAt(index);
                if (d.isPassive()) {
                    stpConnectionDialog.setVisible(d);
                    if (stpConnectionDialog.isConnectionApproved()) {
                        mainTabbedPane.setSelectedIndex(0);
                    }
                } else {
                    connectionDialog.setVisible(d);
                }
            } else {
                connectionDialog.setVisible(true);
            }
        } catch (Exception e) {
            showErrorDialog(e);
        }
}//GEN-LAST:event_possibleClientConnectBActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        try {
            int index = serversTable.getSelectedRow();
            if (index != -1) {
                ServerClient sc = serversTableModel.getServerClient(index);
                sc.disconnect();
            }
        } catch (Exception e) {
            showErrorDialog(e);
        }
    }//GEN-LAST:event_jButton3ActionPerformed

    private void clearClientsBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearClientsBActionPerformed
        mainClass.getClientManager().clearNormalClients();
    }//GEN-LAST:event_clearClientsBActionPerformed

private void jMenuItem2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem2ActionPerformed
    aboutDialog.setVisible(true);
}//GEN-LAST:event_jMenuItem2ActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
            e.printStackTrace();
        }

        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }

    private void showErrorDialog(Exception e) {
        showErrorDialog(this, e, null);
    }

    public static void showErrorDialog(Component parent, Exception e) {
        showErrorDialog(parent, e, null);
    }

    public static void showErrorDialog(Component parent, Exception e, String msg) {

        if (e instanceof StandardExceptionMessageProvider && msg == null && e.getMessage() == null) {
            StandardExceptionMessageProvider sep = (StandardExceptionMessageProvider) e;
            String message = sep.getStandardMessage() == null ? e.toString() : sep.getStandardMessage();
            JOptionPane.showMessageDialog(parent, message, "Error", JOptionPane.ERROR_MESSAGE);

            return;
        }


        if (DEBUG) {
            StackTraceElement[] elems = e.getStackTrace();
            for (int i = 0; i < elems.length; i++) {
                msg += "\n" + elems[i].getMethodName();
            }
        }

        if (e.getMessage() == null) {
            JOptionPane.showMessageDialog(parent, e.toString(), "Error", JOptionPane.ERROR_MESSAGE);
        } else {
            JOptionPane.showMessageDialog(parent, e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
        }

    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTree availableFilesTree;
    private javax.swing.JButton clearClientsB;
    private javax.swing.JLabel clientNameLabel;
    private javax.swing.JList clientOnServerList;
    private javax.swing.JPanel clientsPanel;
    private javax.swing.JTable clientsTable;
    private javax.swing.JMenuItem connectMI;
    private javax.swing.JButton contUploadButton;
    private javax.swing.JButton continueTarnsfButton;
    private javax.swing.JLabel descripionLabel;
    private javax.swing.JButton disconnectButton;
    private javax.swing.JTable dowloadTable;
    private javax.swing.JButton downloadButton;
    private javax.swing.JButton downloadClearButton;
    private javax.swing.JButton exploreFileB;
    private javax.swing.JLabel fileAccessLabel;
    private javax.swing.JLabel fileNameLabel;
    private javax.swing.JLabel fileSizeLabel;
    private javax.swing.JLabel hostLabel;
    private javax.swing.JLabel incClientHostLabel;
    private javax.swing.JLabel incClientIsPassLabel;
    private javax.swing.JLabel incClientNameLabel;
    private javax.swing.JLabel incClintDescLabel;
    private javax.swing.JTable incomConnTable;
    private javax.swing.JLabel isPassiveLabel;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel13;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JScrollPane jScrollPane6;
    private javax.swing.JScrollPane jScrollPane7;
    private javax.swing.JScrollPane jScrollPane8;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JToolBar jToolBar2;
    private javax.swing.JLabel lanCConPort;
    private javax.swing.JLabel lanCDescLabel;
    private javax.swing.JLabel lanCIPAddLabel;
    private javax.swing.JLabel lanCNameLabel;
    private javax.swing.JButton lanClientConnectButton;
    private javax.swing.JList lanClientList;
    private javax.swing.JButton lanClientsRefreshB;
    private javax.swing.JTabbedPane mainTabbedPane;
    private javax.swing.JButton openFileButton;
    private javax.swing.JMenuItem optionsMI;
    private javax.swing.JButton pauseUploadButton;
    private javax.swing.JButton possibleClientConnectB;
    private javax.swing.JLabel scConPortLabel;
    private javax.swing.JLabel scDescLabel;
    private javax.swing.JLabel scNameLabel;
    private javax.swing.JLabel scPassiveLabel;
    private javax.swing.JLabel scSharesLabel;
    private javax.swing.JButton servConnectButton;
    private javax.swing.JTable serversTable;
    private javax.swing.JMenuItem shareMI;
    private javax.swing.JButton transfPauseButton;
    private javax.swing.JSplitPane transfSplitpane;
    private javax.swing.JButton uploadClearButton;
    private javax.swing.JTable uploadsTable;
    private javax.swing.JMenuItem userManagerMI;
    // End of variables declaration//GEN-END:variables
}
