/*
 * ServerTPConnectionDialog.java
 *
 * Created on December 30, 2007, 3:33 PM
 */
package client.gui;

import client.OptionalValueProvider;
import client.Profile;
import client.net.commun.ClientManager;
import client.net.commun.PossibleClientDescriptor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author  Ati
 */
public class ServerTPConnectionDialog extends javax.swing.JDialog {

    private ClientManager clientManager;
    private PossibleClientDescriptor pcd;
    private boolean connectionApproved = false;

    /** Creates new form ServerTPConnectionDialog */
    public ServerTPConnectionDialog(java.awt.Frame parent, boolean modal, ClientManager mngr) {
        super(parent, modal);
        this.clientManager = mngr;
        initComponents();

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        connectButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        clientName = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        withSUP = new javax.swing.JRadioButton();
        withoutRB = new javax.swing.JRadioButton();
        withRB = new javax.swing.JRadioButton();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        nameTF = new javax.swing.JTextField();
        passwordPF = new javax.swing.JPasswordField();

        setTitle("Connecto Passive Client");

        connectButton.setText("Connect");
        connectButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                connectButtonActionPerformed(evt);
            }
        });

        jLabel1.setText("Client name:");

        clientName.setText("jLabel2");

        jLabel2.setText("Connect as:");

        buttonGroup1.add(withSUP);
        withSUP.setSelected(true);
        withSUP.setText("With standard username and password");

        buttonGroup1.add(withoutRB);
        withoutRB.setText("Without username and password");

        buttonGroup1.add(withRB);
        withRB.setText("With:");
        withRB.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                withRBStateChanged(evt);
            }
        });

        jLabel3.setText("username");

        jLabel4.setText("password");

        nameTF.setEnabled(false);

        passwordPF.setEnabled(false);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(clientName))
                    .addComponent(jLabel2)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(withoutRB)
                            .addComponent(withSUP)
                            .addComponent(withRB)
                            .addGroup(layout.createSequentialGroup()
                                .addGap(21, 21, 21)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jLabel4)
                                        .addGap(18, 18, 18)
                                        .addComponent(passwordPF, javax.swing.GroupLayout.DEFAULT_SIZE, 100, Short.MAX_VALUE))
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jLabel3)
                                        .addGap(18, 18, 18)
                                        .addComponent(nameTF, javax.swing.GroupLayout.DEFAULT_SIZE, 99, Short.MAX_VALUE)))
                                .addGap(288, 288, 288))))
                    .addComponent(connectButton, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(clientName))
                .addGap(18, 18, 18)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(withSUP)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(withoutRB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(withRB)
                .addGap(8, 8, 8)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(nameTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(12, 12, 12)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(passwordPF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(17, 17, 17)
                .addComponent(connectButton)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    public void setVisible(PossibleClientDescriptor pc) {
        clientName.setText(pc.getName());
        pcd = pc;
        connectionApproved = false;
        setVisible(true);
    }

    private void connectButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_connectButtonActionPerformed
        try {
            Profile p;
            if (withRB.isSelected()) {
                p = new Profile(nameTF.getText(), new String(passwordPF.getPassword()));
            } else if (withoutRB.isSelected()) {
                p = new Profile("", "");
            } else {
                p = OptionalValueProvider.getProfile();
            }
            clientManager.connectToPossibleClient(pcd, p);
            connectionApproved = true;
            setVisible(false);
            
        } catch (IOException ex) {
            MainFrame.showErrorDialog(this, ex);
            Logger.getLogger(ServerTPConnectionDialog.class.getName()).log(Level.SEVERE, null, ex);
        }

}//GEN-LAST:event_connectButtonActionPerformed

    private void withRBStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_withRBStateChanged
        if (withRB.isSelected()) {
            nameTF.setEnabled(true);
            passwordPF.setEnabled(true);
        } else {
            nameTF.setEnabled(false);
            passwordPF.setEnabled(false);
        }
    }//GEN-LAST:event_withRBStateChanged

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                ServerTPConnectionDialog dialog = new ServerTPConnectionDialog(new javax.swing.JFrame(), true, null);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JLabel clientName;
    private javax.swing.JButton connectButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField nameTF;
    private javax.swing.JPasswordField passwordPF;
    private javax.swing.JRadioButton withRB;
    private javax.swing.JRadioButton withSUP;
    private javax.swing.JRadioButton withoutRB;
    // End of variables declaration//GEN-END:variables

    public boolean isConnectionApproved() {
        return connectionApproved;
    }
}
