/*
 * ShareDialog.java
 *
 * Created on 25 July 2007, 15:41
 */
package client.gui;

import client.GroupRegisterListener;
import client.OwnFileDescriptor;
import client.ShareManager;
import common.StaticValues;
import common.AbstractFileDescriptor;
import exceptions.SharingNonExistingFileException;
import java.awt.event.ItemEvent;
import java.io.File;
import java.sql.SQLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/**
 *
 * @author  A
 */
public class ShareDialog extends javax.swing.JDialog implements GroupRegisterListener{

    private static final String Not_Available = "Not Available";
    private static final String Visible = "Visible";
    private static final String Downloadable = "Downloadable";
    private JFileChooser fileChooser = new JFileChooser();
    private ShareSelectionOptionPanel ssoPanel;
    private ShareManager shareManager;
    private boolean userChanging = true;
    private DefaultTreeModel fileShareTreeModel;

    /** Creates new form ShareDialog */
    public ShareDialog(java.awt.Frame parent, boolean modal, ShareManager sm) {
        super(parent, modal);
        this.shareManager = sm;
        //TODO: remove comment
        fileShareTreeModel = new DefaultTreeModel(null);
        fileShareTreeModel = new DefaultTreeModel(new CommonTreeNode(sm.getRootFiles()));

        initComponents();

        ssoPanel = new ShareSelectionOptionPanel(sm, fileChooser);

        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        fileChooser.addPropertyChangeListener(ssoPanel);
        fileChooser.setAccessory(ssoPanel);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jScrollPane1 = new javax.swing.JScrollPane();
        fileShareTree = new javax.swing.JTree();
        shareButton = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        removeButton = new javax.swing.JButton();
        pubAccessComboBox = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        groupsComboBox = new javax.swing.JComboBox();
        makeItRootButton = new javax.swing.JButton();
        removeAsRootButton = new javax.swing.JButton();
        recoursiveluCB = new javax.swing.JCheckBox();
        jLabel3 = new javax.swing.JLabel();
        groupAccessCB = new javax.swing.JComboBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Share");
        fileShareTree.setCellRenderer(new CommonTreeCellRenderer(true));
        fileShareTree.setModel(fileShareTreeModel);
        fileShareTree.setRootVisible(false);
        fileShareTree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
            public void valueChanged(javax.swing.event.TreeSelectionEvent evt) {
                fileShareTreeValueChanged(evt);
            }
        });

        jScrollPane1.setViewportView(fileShareTree);

        shareButton.setText("Share");
        shareButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                shareButtonActionPerformed(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        removeButton.setText("Remove");
        removeButton.setEnabled(false);
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeButtonActionPerformed(evt);
            }
        });

        pubAccessComboBox.setModel(new DefaultComboBoxModel(new String[]{Not_Available,Visible,Downloadable}));
        pubAccessComboBox.setEnabled(false);
        pubAccessComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                pubAccessComboBoxItemStateChanged(evt);
            }
        });

        jLabel1.setText("Public Access");

        jLabel2.setText("Group");

        groupsComboBox.setModel(new DefaultComboBoxModel(shareManager.getGroups().toArray()));
        groupsComboBox.setEnabled(false);
        groupsComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                groupsComboBoxItemStateChanged(evt);
            }
        });

        makeItRootButton.setText("Make It Root");
        makeItRootButton.setEnabled(false);
        makeItRootButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                makeItRootButtonActionPerformed(evt);
            }
        });

        removeAsRootButton.setText("Remove As Root");
        removeAsRootButton.setEnabled(false);
        removeAsRootButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeAsRootButtonActionPerformed(evt);
            }
        });

        recoursiveluCB.setText("Recoursively");
        recoursiveluCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        recoursiveluCB.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jLabel3.setText("Group Access");

        groupAccessCB.setModel(new DefaultComboBoxModel(new String[]{Not_Available,Visible,Downloadable}));
        groupAccessCB.setEnabled(false);
        groupAccessCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                groupAccessCBItemStateChanged(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(removeButton)
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addComponent(makeItRootButton, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(removeAsRootButton, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(14, 14, 14)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(recoursiveluCB)
                            .addComponent(groupAccessCB, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(pubAccessComboBox, 0, 110, Short.MAX_VALUE)
                            .addComponent(groupsComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addComponent(jLabel3))
                .addContainerGap(36, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(removeButton)
                .addGap(37, 37, 37)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(pubAccessComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(groupAccessCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(groupsComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(recoursiveluCB)
                .addGap(100, 100, 100)
                .addComponent(makeItRootButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(removeAsRootButton)
                .addContainerGap(115, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(shareButton))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(shareButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 436, Short.MAX_VALUE))
                .addContainerGap())
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void groupAccessCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_groupAccessCBItemStateChanged
        if (evt.getStateChange() == ItemEvent.SELECTED) {
            if (!userChanging) {
                return;
            }
            TreePath[] paths = fileShareTree.getSelectionPaths();
            for (TreePath tp : paths) {
                CommonTreeNode treeNode = (CommonTreeNode) tp.getLastPathComponent();
                OwnFileDescriptor ofd = (OwnFileDescriptor) treeNode.getAbstractFileDescriptor();
                try {

                    if (recoursiveluCB.isSelected()) {
                        recGroupAccessChange(treeNode, (short) (groupAccessCB.getSelectedIndex() + 1));
                    } else if (ofd.isDirectory()) {
                        shareManager.setDirGroupAccess(ofd.getFile_id(), (short) (groupAccessCB.getSelectedIndex() + 1));
                    } else {
                        shareManager.setFileGroupAccess(ofd.getFile_id(), (short) (groupAccessCB.getSelectedIndex() + 1));
                    }

                    ofd.setGroupAccessibility((short) (groupAccessCB.getSelectedIndex() + 1));

                    fileShareTreeModel.nodeChanged(treeNode);
                } catch (SQLException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE);
                }
            }
        }
    }//GEN-LAST:event_groupAccessCBItemStateChanged

    private void recGroupChange(CommonTreeNode tn, String group) {
        OwnFileDescriptor ofd = (OwnFileDescriptor) tn.getAbstractFileDescriptor();
        try {
            if (ofd.isDirectory()) {
                shareManager.setDirGroup(ofd.getFile_id(), group);
            } else {
                shareManager.setFileGroup(ofd.getFile_id(), group);
            }
            ofd.setGroup(group);
            fileShareTreeModel.nodeChanged(tn);
        } catch (SQLException ex) {
            ex.printStackTrace();
        }

        if (ofd.isDirectory()) {
            int num = tn.getChildCount();
            for (int i = 0; i < num; i++) {
                recGroupChange((CommonTreeNode) tn.getChildAt(i), group);
            }

        }
    }

    private void groupsComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_groupsComboBoxItemStateChanged
        if (evt.getStateChange() == ItemEvent.SELECTED) {
            if (!userChanging) {
                return;
            }
            TreePath[] paths = fileShareTree.getSelectionPaths();
            for (TreePath tp : paths) {
                CommonTreeNode treeNode = (CommonTreeNode) tp.getLastPathComponent();

                OwnFileDescriptor ofd = (OwnFileDescriptor) treeNode.getAbstractFileDescriptor();
                try {
                    if (recoursiveluCB.isSelected()) {
                        recGroupChange(treeNode, (String) groupsComboBox.getSelectedItem());
                    } else if (ofd.isDirectory()) {
                        shareManager.setDirGroup(ofd.getFile_id(), (String) groupsComboBox.getSelectedItem());
                    } else {
                        shareManager.setFileGroup(ofd.getFile_id(), (String) groupsComboBox.getSelectedItem());
                    }
                    ofd.setGroup((String) groupsComboBox.getSelectedItem());
                    fileShareTreeModel.nodeChanged(treeNode);

                } catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }//GEN-LAST:event_groupsComboBoxItemStateChanged

    private void recPubAccessChange(CommonTreeNode tn, short accMode) {
        OwnFileDescriptor ofd = (OwnFileDescriptor) tn.getAbstractFileDescriptor();
        try {
            if (ofd.isDirectory()) {
                shareManager.setDirPublicAccess(ofd.getFile_id(), accMode);
            } else {
                shareManager.setFilePublicAccess(ofd.getFile_id(), accMode);
            }
            ofd.setPublicAccessibility(accMode);
            fileShareTreeModel.nodeChanged(tn);
        } catch (SQLException ex) {
            ex.printStackTrace();
        }

        if (ofd.isDirectory()) {
            int num = tn.getChildCount();
            for (int i = 0; i < num; i++) {
                recPubAccessChange((CommonTreeNode) tn.getChildAt(i), accMode);
            }

        }
    }

    private void recGroupAccessChange(CommonTreeNode tn, short accMode) {
        OwnFileDescriptor ofd = (OwnFileDescriptor) tn.getAbstractFileDescriptor();
        try {
            if (ofd.isDirectory()) {
                shareManager.setDirGroupAccess(ofd.getFile_id(), accMode);
            } else {
                shareManager.setFileGroupAccess(ofd.getFile_id(), accMode);
            }
            ofd.setGroupAccessibility(accMode);
            fileShareTreeModel.nodeChanged(tn);
        } catch (SQLException ex) {
            ex.printStackTrace();
        }

        if (ofd.isDirectory()) {
            int num = tn.getChildCount();
            for (int i = 0; i < num; i++) {
                recGroupAccessChange((CommonTreeNode) tn.getChildAt(i), accMode);
            }

        }
    }

    private void pubAccessComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_pubAccessComboBoxItemStateChanged
        if (evt.getStateChange() == ItemEvent.SELECTED) {
            if (!userChanging) {
                return;
            }
            TreePath[] paths = fileShareTree.getSelectionPaths();
            for (TreePath tp : paths) {
                CommonTreeNode treeNode = (CommonTreeNode) tp.getLastPathComponent();

                OwnFileDescriptor ofd = (OwnFileDescriptor) treeNode.getAbstractFileDescriptor();
                try {
                    if (recoursiveluCB.isSelected()) {
                        recPubAccessChange(treeNode, (short) (pubAccessComboBox.getSelectedIndex() + 1));
                    } else if (ofd.isDirectory()) {
                        shareManager.setDirPublicAccess(ofd.getFile_id(), (short) (pubAccessComboBox.getSelectedIndex() + 1));
                    } else {
                        shareManager.setFilePublicAccess(ofd.getFile_id(), (short) (pubAccessComboBox.getSelectedIndex() + 1));
                    }
                    ofd.setPublicAccessibility((short) (pubAccessComboBox.getSelectedIndex() + 1));
                    fileShareTreeModel.nodeChanged(treeNode);

                } catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }//GEN-LAST:event_pubAccessComboBoxItemStateChanged

    private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
        if (fileShareTree.getSelectionPaths().length <= 1) {
            CommonTreeNode treeNode = (CommonTreeNode) fileShareTree.getLastSelectedPathComponent();
            OwnFileDescriptor ofd = (OwnFileDescriptor) treeNode.getAbstractFileDescriptor();

            try {
                if (ofd.isDirectory()) {
                    shareManager.unShareDir(ofd.getFile_id());
                } else {
                    shareManager.unShareFile(ofd.getFile_id());
                }

                fileShareTreeModel.setRoot(new CommonTreeNode(shareManager.getRootFiles()));
                fileShareTreeModel.nodeStructureChanged((TreeNode) fileShareTreeModel.getRoot());
            } catch (SQLException ex) {
                ex.printStackTrace();
            }
        } else {
            for (TreePath tp : fileShareTree.getSelectionPaths()) {
                CommonTreeNode treeNode = (CommonTreeNode) tp.getLastPathComponent();
                OwnFileDescriptor ofd = (OwnFileDescriptor) treeNode.getAbstractFileDescriptor();
                try {

                    shareManager.unShareFile(ofd.getFile_id());
                } catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            fileShareTreeModel.setRoot(new CommonTreeNode(shareManager.getRootFiles()));
            fileShareTreeModel.nodeStructureChanged((TreeNode) fileShareTreeModel.getRoot());

        }
    }//GEN-LAST:event_removeButtonActionPerformed

    private void removeAsRootButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeAsRootButtonActionPerformed
        try {
            CommonTreeNode treeNode = (CommonTreeNode) fileShareTree.getLastSelectedPathComponent();
            OwnFileDescriptor ofd = (OwnFileDescriptor) treeNode.getAbstractFileDescriptor();

            shareManager.removeFromRoots(ofd);

            fileShareTreeModel.setRoot(new CommonTreeNode(shareManager.getRootFiles()));

        } catch (SQLException ex) {
            ex.printStackTrace();
        }
        
    }//GEN-LAST:event_removeAsRootButtonActionPerformed

    private void makeItRootButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_makeItRootButtonActionPerformed
        try {
            CommonTreeNode treeNode = (CommonTreeNode) fileShareTree.getLastSelectedPathComponent();
            OwnFileDescriptor ofd = (OwnFileDescriptor) treeNode.getAbstractFileDescriptor();

            shareManager.addToRootFiles(ofd);

            CommonTreeNode rootNode = (CommonTreeNode) fileShareTree.getModel().getRoot();
            rootNode.addChildNode(new CommonTreeNode(ofd, rootNode));
            ((CommonTreeNode) treeNode.getParent()).removeChildNode(treeNode);

            ((DefaultTreeModel) fileShareTree.getModel()).nodeStructureChanged(rootNode);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }//GEN-LAST:event_makeItRootButtonActionPerformed

    private void fileShareTreeValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_fileShareTreeValueChanged

        if (fileShareTree.getSelectionPaths() != null && fileShareTree.getSelectionPaths().length <= 1) {

            CommonTreeNode treeNode = (CommonTreeNode) fileShareTree.getLastSelectedPathComponent();

            if (treeNode != null) {
                OwnFileDescriptor ofd = (OwnFileDescriptor) treeNode.getAbstractFileDescriptor();
                removeButton.setEnabled(true);
                groupsComboBox.setEnabled(true);
                userChanging = false;
                groupsComboBox.setSelectedItem(ofd.getGroup());
                userChanging = true;
                pubAccessComboBox.setEnabled(true);
                groupAccessCB.setEnabled(true);

                userChanging = false;

                switch (ofd.getPublicAccessiblity()) {
                    case StaticValues.DOWNLOADABLE_FILE:
                        pubAccessComboBox.setSelectedIndex(2);
                        break;
                    case StaticValues.VISIBLE_FILE:
                        pubAccessComboBox.setSelectedIndex(1);
                        break;
                    case StaticValues.NOT_ACCESSIBLE_FILE:
                        pubAccessComboBox.setSelectedIndex(0);
                        break;
                }

                switch (ofd.getGroupAccessibility()) {
                    case StaticValues.DOWNLOADABLE_FILE:
                        groupAccessCB.setSelectedIndex(2);
                        break;
                    case StaticValues.VISIBLE_FILE:
                        groupAccessCB.setSelectedIndex(1);
                        break;
                    case StaticValues.NOT_ACCESSIBLE_FILE:
                        groupAccessCB.setSelectedIndex(0);
                        break;
                }

                userChanging = true;

                pubAccessComboBox.repaint();
                groupAccessCB.repaint();

                int fid = ofd.getFile_id();

                if (shareManager.isRoot(fid, ofd.isDirectory())) {
                    makeItRootButton.setEnabled(false);
                    if (hasRootParent(ofd) && treeNode.getParent().getParent() == null) {
                        removeAsRootButton.setEnabled(true);
                    } else {
                        removeAsRootButton.setEnabled(false);
                    }
                } else {
                    makeItRootButton.setEnabled(true);
                    removeAsRootButton.setEnabled(false);
                }


            } else {
                makeItRootButton.setEnabled(false);
                removeAsRootButton.setEnabled(false);
                removeButton.setEnabled(false);
                groupsComboBox.setEnabled(false);
                pubAccessComboBox.setEnabled(false);
                groupAccessCB.setEnabled(false);
            }
        } else {
            makeItRootButton.setEnabled(false);
            removeAsRootButton.setEnabled(false);
            groupsComboBox.setEnabled(true);
            pubAccessComboBox.setEnabled(true);
            groupAccessCB.setEnabled(true);

            if (fileShareTree.getSelectionPaths() != null) {
                boolean remEnab = true;
                for (TreePath tp : fileShareTree.getSelectionPaths()) {
                    AbstractFileDescriptor afd = ((CommonTreeNode) tp.getLastPathComponent()).getAbstractFileDescriptor();
                    if (afd.isDirectory()) {
                        remEnab = false;
                        break;
                    }
                }
                removeButton.setEnabled(remEnab);
            } else {
                removeButton.setEnabled(false);
            }

        }
    }//GEN-LAST:event_fileShareTreeValueChanged

    private void shareButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_shareButtonActionPerformed
        int res = fileChooser.showDialog(this, "Share");
        if (res == JFileChooser.APPROVE_OPTION) {
            File[] files = fileChooser.getSelectedFiles();
            String group = ssoPanel.getSelectedGroup();
            short pubAccess = ssoPanel.getPublicAccess();
            short groupAccess = ssoPanel.getGroupAccess();
            for (File f : files) {
                try {
                    if (f.isDirectory()) {
                        if (ssoPanel.getShareDirAsRoot()) {
                            shareManager.shareFileAsRoot(f, group, pubAccess, groupAccess);
                        } else {
                            shareManager.shareFile(f, group, pubAccess, groupAccess);
                        }
                    } else {
                        int pol = ssoPanel.getFileSharePolicy();
                        if (pol == ShareSelectionOptionPanel.SHARE_WITH_PARENT_AS_ROOT) {
                            shareManager.shareFileWithParentAsRoot(f, group, pubAccess, groupAccess);
                        } else if (pol == ShareSelectionOptionPanel.PARENT_SHARED_SHARE_AS_SUBFILE) {
                            shareManager.shareFile(f, group, pubAccess, groupAccess);
                        } else {
                            shareManager.shareFileAsRoot(f, group, pubAccess, groupAccess);
                        }
                    }
                } catch (SQLException ex) {
                    ex.printStackTrace();
                } catch (SharingNonExistingFileException ex) {
                    ex.printStackTrace();
                }
            }

            if (files.length > 0) {
                fileShareTreeModel.setRoot(new CommonTreeNode(shareManager.getRootFiles()));
            }
        }
    }//GEN-LAST:event_shareButtonActionPerformed

    private boolean hasRootParent(OwnFileDescriptor owd) {
        OwnFileDescriptor parent = (OwnFileDescriptor) owd.getParent();
        while (parent != null) {
            if (parent.isDirectory()) {
                if (shareManager.isRootDir(parent.getFile_id())) {
                    return true;
                }
            } else {
                if (shareManager.isRootFile(parent.getFile_id())) {
                    return true;
                }
            }
            parent = (OwnFileDescriptor) parent.getParent();
        }
        return false;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTree fileShareTree;
    private javax.swing.JComboBox groupAccessCB;
    private javax.swing.JComboBox groupsComboBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton makeItRootButton;
    private javax.swing.JComboBox pubAccessComboBox;
    private javax.swing.JCheckBox recoursiveluCB;
    private javax.swing.JButton removeAsRootButton;
    private javax.swing.JButton removeButton;
    private javax.swing.JButton shareButton;
    // End of variables declaration//GEN-END:variables

    public void groupRegistered(String groupname) {
        groupsComboBox.addItem(groupname);
    }

    public void groupUnRegistered(String groupname) {
        groupsComboBox.removeItem(groupname);
    }
}
