/*
 * NewJDialog.java
 *
 * Created on 21 March 2007, 00:55
 */

package client.gui;

import client.GroupRegisterListener;
import client.RegisteredUserListener;
import client.ShareManager;
import exceptions.GroupUsedInFilesException;
import exceptions.UserNotRegisteredException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.crypto.Cipher;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

/**
 *
 * @author  A
 */
public class UserManagerDialog extends javax.swing.JDialog implements GroupRegisterListener,RegisteredUserListener {
    private ShareManager sharingManager;
    private MessageDigest md = null;
    private UsersComboBoxModel removeUsersComboBM;
    private DefaultListModel otherGroupsModel = new DefaultListModel();
    private DefaultListModel inGroupsModel = new DefaultListModel();
    
    /** Creates new form NewJDialog */
    public UserManagerDialog(java.awt.Frame parent, boolean modal,ShareManager sm) {
        super(parent, modal);
        this.sharingManager = sm;
        try {
            removeUsersComboBM = new UsersComboBoxModel(sm);
            sm.addRegisteredUserListener(removeUsersComboBM);
            md = MessageDigest.getInstance("SHA-1");
            
            initComponents();
            
            for (String group : sharingManager.getGroups()) {
                groupRemoveComboBox.addItem(group);
            }
            
            for (String user : sharingManager.getUsers()) {
                changeUserPsswdCombo.addItem(user);
                userAssocGroupCombo.addItem(user);
            }
            
        } catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        } catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this,"Database error: " + ex.getMessage(),"Error!",JOptionPane.ERROR_MESSAGE);
        }
        
        inGroupsList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        otherGroupsList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
        determCompnentModes();
    }
    
    
    private void determCompnentModes() {
        AddUserButton.setEnabled(canAddUser());
        addGroupButton.setEnabled(canAddGroup());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel2 = new javax.swing.JLabel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel4 = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        remUserComboB = new javax.swing.JComboBox();
        jLabel10 = new javax.swing.JLabel();
        removeUserButton = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        addUserNameTF = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        addUserPasswdTF = new javax.swing.JPasswordField();
        AddUserButton = new javax.swing.JButton();
        jLabel9 = new javax.swing.JLabel();
        addUserConfirmTF = new javax.swing.JPasswordField();
        jPanel2 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        addGroupNameTF = new javax.swing.JTextField();
        addGroupButton = new javax.swing.JButton();
        jPanel9 = new javax.swing.JPanel();
        jLabel15 = new javax.swing.JLabel();
        groupRemoveComboBox = new javax.swing.JComboBox();
        removeGroupButton = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        jPanel8 = new javax.swing.JPanel();
        jLabel11 = new javax.swing.JLabel();
        changeUserPsswdCombo = new javax.swing.JComboBox();
        chPasswordField1 = new javax.swing.JPasswordField();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        chPasswordField2 = new javax.swing.JPasswordField();
        changePasswdButton = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        userAssocGroupCombo = new javax.swing.JComboBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        inGroupsList = new javax.swing.JList();
        jScrollPane2 = new javax.swing.JScrollPane();
        otherGroupsList = new javax.swing.JList();
        addUserToGroupButton = new javax.swing.JButton();
        removeUserFromGroupButton = new javax.swing.JButton();
        jLabel16 = new javax.swing.JLabel();
        jLabel17 = new javax.swing.JLabel();

        jLabel2.setText("jLabel2");

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("User Manager");

        jPanel7.setBorder(javax.swing.BorderFactory.createTitledBorder("Remove User"));

        remUserComboB.setModel(removeUsersComboBM);

        jLabel10.setText("User");

        removeUserButton.setText("Delete");
        removeUserButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeUserButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup()
                        .addComponent(remUserComboB, 0, 209, Short.MAX_VALUE)
                        .addGap(228, 228, 228)
                        .addComponent(removeUserButton))
                    .addComponent(jLabel10))
                .addContainerGap())
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addComponent(jLabel10)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addGap(11, 11, 11)
                        .addComponent(removeUserButton))
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(remUserComboB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(16, Short.MAX_VALUE))
        );

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Add User"));

        jLabel1.setText("Username");

        addUserNameTF.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                addUserNameTFKeyReleased(evt);
            }
        });

        jLabel3.setText("Password");

        addUserPasswdTF.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                addUserPasswdTFKeyReleased(evt);
            }
        });

        AddUserButton.setText("Add user");
        AddUserButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AddUserButtonActionPerformed(evt);
            }
        });

        jLabel9.setText("Confirm");

        addUserConfirmTF.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                addUserConfirmTFKeyReleased(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(addUserNameTF, javax.swing.GroupLayout.DEFAULT_SIZE, 205, Short.MAX_VALUE)
                                .addGap(24, 24, 24))
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(jLabel1)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel3)
                            .addComponent(addUserConfirmTF, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 271, Short.MAX_VALUE)
                            .addComponent(addUserPasswdTF, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 271, Short.MAX_VALUE)
                            .addComponent(jLabel9)))
                    .addComponent(AddUserButton))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE, false)
                    .addComponent(addUserPasswdTF, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(addUserNameTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(27, 27, 27)
                .addComponent(jLabel9, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(addUserConfirmTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(AddUserButton))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Add Group"));

        jLabel4.setText("Group Name");

        addGroupNameTF.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                addGroupNameTFKeyTyped(evt);
            }
        });

        addGroupButton.setText("Add Group");
        addGroupButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addGroupButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(addGroupButton)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(addGroupNameTF, javax.swing.GroupLayout.DEFAULT_SIZE, 171, Short.MAX_VALUE)
                            .addComponent(jLabel4))))
                .addGap(339, 339, 339))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jLabel4)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(addGroupNameTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 24, Short.MAX_VALUE)
                .addComponent(addGroupButton))
        );

        jPanel9.setBorder(javax.swing.BorderFactory.createTitledBorder("Remove Group"));

        jLabel15.setText("Group");

        removeGroupButton.setText("Delete");
        removeGroupButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeGroupButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel9Layout = new javax.swing.GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel9Layout.createSequentialGroup()
                        .addComponent(groupRemoveComboBox, 0, 209, Short.MAX_VALUE)
                        .addGap(228, 228, 228)
                        .addComponent(removeGroupButton))
                    .addComponent(jLabel15))
                .addContainerGap())
        );
        jPanel9Layout.setVerticalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addComponent(jLabel15)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(groupRemoveComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(removeGroupButton))
                .addContainerGap(20, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel9, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel7, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel7, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel9, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(11, 11, 11))
        );

        jTabbedPane1.addTab("Add/Remove", jPanel4);

        jPanel8.setBorder(javax.swing.BorderFactory.createTitledBorder("Change users password"));

        jLabel11.setText("Registered user");

        chPasswordField1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                chPasswordField1KeyReleased(evt);
            }
        });

        jLabel12.setText("New password");

        jLabel13.setText("Confirm");

        chPasswordField2.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                chPasswordField2KeyReleased(evt);
            }
        });

        changePasswdButton.setText("Change");
        changePasswdButton.setEnabled(false);
        changePasswdButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                changePasswdButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel8Layout = new javax.swing.GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel8Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel11)
                            .addComponent(changeUserPsswdCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 148, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(124, 124, 124)
                        .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(chPasswordField2)
                            .addComponent(jLabel13)
                            .addComponent(jLabel12)
                            .addComponent(chPasswordField1, javax.swing.GroupLayout.PREFERRED_SIZE, 129, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(changePasswdButton))
                .addContainerGap(109, Short.MAX_VALUE))
        );
        jPanel8Layout.setVerticalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel11)
                    .addComponent(jLabel12))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(changeUserPsswdCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(chPasswordField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(17, 17, 17)
                .addComponent(jLabel13)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chPasswordField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 87, Short.MAX_VALUE)
                .addComponent(changePasswdButton))
        );

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(251, 251, 251))
        );

        jTabbedPane1.addTab("Change...", jPanel6);

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Users and Groups"));

        jLabel6.setText("User");

        userAssocGroupCombo.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                userAssocGroupComboItemStateChanged(evt);
            }
        });

        inGroupsList.setModel(inGroupsModel);
        jScrollPane1.setViewportView(inGroupsList);

        otherGroupsList.setModel(otherGroupsModel);
        jScrollPane2.setViewportView(otherGroupsList);

        addUserToGroupButton.setText("< add");
        addUserToGroupButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addUserToGroupButtonActionPerformed(evt);
            }
        });

        removeUserFromGroupButton.setText("remove >");
        removeUserFromGroupButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeUserFromGroupButtonActionPerformed(evt);
            }
        });

        jLabel16.setText("User in Groups");

        jLabel17.setText("Other Groups");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(userAssocGroupCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 205, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel3Layout.createSequentialGroup()
                                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 171, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(16, 16, 16)
                                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(addUserToGroupButton, javax.swing.GroupLayout.DEFAULT_SIZE, 92, Short.MAX_VALUE)
                                    .addComponent(removeUserFromGroupButton, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 92, Short.MAX_VALUE)))
                            .addComponent(jLabel16))
                        .addGap(25, 25, 25)
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel17)
                            .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 196, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel6)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(userAssocGroupCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(49, 49, 49)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel16)
                    .addComponent(jLabel17))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                        .addComponent(addUserToGroupButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 195, Short.MAX_VALUE)
                        .addComponent(removeUserFromGroupButton))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 241, Short.MAX_VALUE)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 241, Short.MAX_VALUE))
                .addContainerGap(97, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        jTabbedPane1.addTab("Users and Groups", jPanel5);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 561, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 538, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    
    private void removeUserFromGroupButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeUserFromGroupButtonActionPerformed
        String group = (String) inGroupsList.getSelectedValue();
        if (group != null) {
            try {
                sharingManager.removeUserFromGroup((String) userAssocGroupCombo.getSelectedItem(), group);
                otherGroupsModel.addElement(group);
                inGroupsModel.removeElement(group);
            } catch (SQLException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this,"Can't remove user from group : " + ex.getMessage(),"Error!",JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_removeUserFromGroupButtonActionPerformed
    
    private void addUserToGroupButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addUserToGroupButtonActionPerformed
        String group = (String) otherGroupsList.getSelectedValue();
        if (group != null) {
            try {
                sharingManager.associateUserWithGroup((String) userAssocGroupCombo.getSelectedItem(), group);
                otherGroupsModel.removeElement(group);
                inGroupsModel.addElement(group);
            } catch (SQLException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this,"Can't add user into group : " + ex.getMessage(),"Error!",JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_addUserToGroupButtonActionPerformed
    
    private void userAssocGroupComboItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_userAssocGroupComboItemStateChanged
        if (evt.getStateChange() == evt.SELECTED) {
            try {
                if (userAssocGroupCombo.getSelectedIndex() == -1) {
                    otherGroupsModel.removeAllElements();
                    inGroupsModel.removeAllElements();
                    return;
                }
                
                String user = (String)userAssocGroupCombo.getSelectedItem();
                ArrayList<String> inGroups =  sharingManager.getGroupsForUser(user);
                ArrayList<String> otherGroups = sharingManager.getGroups();
                
                for (String g : inGroups)
                    otherGroups.remove(g);
                
                otherGroupsModel.removeAllElements();
                inGroupsModel.removeAllElements();
                
                for (String g: inGroups)
                    inGroupsModel.addElement(g);
                
                for (String g : otherGroups)
                    otherGroupsModel.addElement(g);
                
            } catch (UserNotRegisteredException ex) {
                ex.printStackTrace();
            } catch (SQLException ex) {
                JOptionPane.showMessageDialog(this,"Database error : " + ex.getMessage(),"Error!",JOptionPane.ERROR_MESSAGE);
            }
            
        }
    }//GEN-LAST:event_userAssocGroupComboItemStateChanged
    
    private void changePasswdButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_changePasswdButtonActionPerformed
        String passwd = new String(md.digest(new String(chPasswordField1.getPassword()).getBytes()));
        try {
            sharingManager.setUserPassword((String)changeUserPsswdCombo.getSelectedItem(),passwd);
        } catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this,"Can't change password : " + ex.getMessage(),"Error!",JOptionPane.ERROR_MESSAGE);
        }
        System.out.println(passwd);
    }//GEN-LAST:event_changePasswdButtonActionPerformed
    
    private void chPasswordField1KeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_chPasswordField1KeyReleased
        changePasswdButton.setEnabled(canChangeUserPassword());
    }//GEN-LAST:event_chPasswordField1KeyReleased
    
    private void chPasswordField2KeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_chPasswordField2KeyReleased
        changePasswdButton.setEnabled(canChangeUserPassword());
    }//GEN-LAST:event_chPasswordField2KeyReleased
            
    private void removeGroupButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeGroupButtonActionPerformed
        try {
            sharingManager.removeGroup((String)groupRemoveComboBox.getSelectedItem());
        } catch (GroupUsedInFilesException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this,"Can't remove group : group used in shared files","Error!",JOptionPane.ERROR_MESSAGE);
        } catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this,"Can't remove group : " + ex.getMessage(),"Error!",JOptionPane.ERROR_MESSAGE);
        }
        
    }//GEN-LAST:event_removeGroupButtonActionPerformed
    
    private void removeUserButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeUserButtonActionPerformed
        try {
            sharingManager.removeUser((String)remUserComboB.getSelectedItem());
        } catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this,"Can't remove user : " + ex.getMessage(),"Error!",JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_removeUserButtonActionPerformed
    
    private void addGroupButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addGroupButtonActionPerformed
        try {
            sharingManager.addGroup(addGroupNameTF.getText());
            addGroupNameTF.setText("");
            JOptionPane.showMessageDialog(this,"Group added!");
        } catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this,"Can't add group : " + ex.getMessage(),"Error!",JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_addGroupButtonActionPerformed
    
    
    private void addGroupNameTFKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_addGroupNameTFKeyTyped
        addGroupButton.setEnabled(canAddGroup());
    }//GEN-LAST:event_addGroupNameTFKeyTyped
    
    private void addUserConfirmTFKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_addUserConfirmTFKeyReleased
        AddUserButton.setEnabled(canAddUser());
    }//GEN-LAST:event_addUserConfirmTFKeyReleased
    
    private void addUserPasswdTFKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_addUserPasswdTFKeyReleased
        AddUserButton.setEnabled(canAddUser());
    }//GEN-LAST:event_addUserPasswdTFKeyReleased
    
    private void addUserNameTFKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_addUserNameTFKeyReleased
        AddUserButton.setEnabled(canAddUser());
    }//GEN-LAST:event_addUserNameTFKeyReleased
    
    private boolean canAddUser() {
        return addUserNameTF.getText().length()>0 && Arrays.equals(addUserPasswdTF.getPassword(),addUserConfirmTF.getPassword()) &&
                addUserPasswdTF.getPassword().length > 0;
    }
    
    private boolean canAddGroup() {
        return addGroupNameTF.getText().length() > 0;
    }
    
    private boolean canChangeUserPassword() {
        if (changeUserPsswdCombo.getSelectedIndex() != -1) {
            
            String pw1 = new String(chPasswordField1.getPassword());
            if (pw1.length() < 1) return false;
            String pw2 = new String(chPasswordField2.getPassword());
            if (pw1.equals(pw2)) return true;
            else return false;
            
        } else {
            return false;
        }
    }
    
    private void AddUserButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AddUserButtonActionPerformed
        try {
            String hashPasswd = new String(md.digest(new String(addUserPasswdTF.getPassword()).getBytes()));
            sharingManager.addUser(addUserNameTF.getText(),hashPasswd);
            addUserNameTF.setText("");
            addUserPasswdTF.setText("");
            addUserConfirmTF.setText("");
            JOptionPane.showMessageDialog(this,"User added!");
        } catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this,"Can't add user : " + ex.getMessage(),"Error!",JOptionPane.ERROR_MESSAGE);
        }
        
    }//GEN-LAST:event_AddUserButtonActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new UserManagerDialog(new javax.swing.JFrame(), true,null).setVisible(true);
            }
        });
    }
    
    public void groupUnRegistered(final String groupname) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                groupRemoveComboBox.removeItem(groupname);
                if (userAssocGroupCombo.getSelectedIndex() != -1) {
                    otherGroupsModel.removeElement(groupname);
                }
            }
        });
    }
    
    public void groupRegistered(final String groupname) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                groupRemoveComboBox.addItem(groupname);
                if (userAssocGroupCombo.getSelectedIndex() != -1) {
                    otherGroupsModel.addElement(groupname);
                }
            }
        });
    }
    
    public void userUnRegistered(String userName) {
        changeUserPsswdCombo.removeItem(userName);
        userAssocGroupCombo.removeItem(userName);
        try {
            if (sharingManager.getUsers().size() == 0) {
                inGroupsModel.removeAllElements();
                otherGroupsModel.removeAllElements();
            }
        } catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
    
    public void userRegistered(String userName) {
        changeUserPsswdCombo.addItem(userName);
        userAssocGroupCombo.addItem(userName);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton AddUserButton;
    private javax.swing.JButton addGroupButton;
    private javax.swing.JTextField addGroupNameTF;
    private javax.swing.JPasswordField addUserConfirmTF;
    private javax.swing.JTextField addUserNameTF;
    private javax.swing.JPasswordField addUserPasswdTF;
    private javax.swing.JButton addUserToGroupButton;
    private javax.swing.JPasswordField chPasswordField1;
    private javax.swing.JPasswordField chPasswordField2;
    private javax.swing.JButton changePasswdButton;
    private javax.swing.JComboBox changeUserPsswdCombo;
    private javax.swing.JComboBox groupRemoveComboBox;
    private javax.swing.JList inGroupsList;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JList otherGroupsList;
    private javax.swing.JComboBox remUserComboB;
    private javax.swing.JButton removeGroupButton;
    private javax.swing.JButton removeUserButton;
    private javax.swing.JButton removeUserFromGroupButton;
    private javax.swing.JComboBox userAssocGroupCombo;
    // End of variables declaration//GEN-END:variables
    
}
