/*
 * UsersComboBoxModel.java
 *
 * Created on 26 March 2007, 23:39
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package client.gui;

import client.RegisteredUserListener;
import client.ShareManager;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;

/**
 *
 * @author A
 */
public class UsersComboBoxModel extends DefaultComboBoxModel implements RegisteredUserListener {
    private ShareManager sharingManager;
    /** Creates a new instance of UsersComboBoxModel */
    public UsersComboBoxModel(String[] users,ShareManager sm) {
        super(users);
        this.sharingManager = sm;
    }
    
    public UsersComboBoxModel(ShareManager sm) throws SQLException {
        this.sharingManager = sm;
        refresh();
    }
    
    
    public void refresh() throws SQLException {
        removeAllElements();
        ArrayList<String> users = sharingManager.getUsers();
        for (String u : users)
            addElement(u);
    }
    
    public void userUnRegistered(String userName) {
        try {
            refresh();
        } catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
    
    public void userRegistered(String userName) {
        try {
            refresh();
        } catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}
