package client.net;

import client.*;
import common.commun.AbstractConnectionWaiter;
import common.commun.NoHandlerForConnectionTypeException;
import common.commun.TrafficHandler;
import exceptions.ClientConnectionWaiterInitException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

public class ClientConnectionWaiter extends AbstractConnectionWaiter implements Runnable {
    
    private Thread waitingThread;
    
    private SSLServerSocket waitingSocket;
    
    public ClientConnectionWaiter(TrafficHandler th,int port) throws ClientConnectionWaiterInitException {
        super(th);
        try {
            
            KeyStore ks;
            ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(MainClass.SCRIPTS_DIR + File.separator + "keystr.jks"), "turtlepassword".toCharArray());
            KeyManagerFactory km = KeyManagerFactory.getInstance("SunX509","SunJSSE");
            km.init(ks,"turtlestandard".toCharArray());
            SSLContext sslc = SSLContext.getInstance("SSL");
            sslc.init(km.getKeyManagers(),null,null);
            SSLServerSocketFactory sslfactory = sslc.getServerSocketFactory();
            waitingSocket = (SSLServerSocket)sslfactory.createServerSocket(port);
            
            
            waitingThread = new Thread(this,"Connection waiter thread");
            waitingThread.start();
        } catch (Exception ex) {
            ex.printStackTrace();
            throw new ClientConnectionWaiterInitException(ex);
        }
    }
    
 
    
    public void run() {
        while (true) {
            try {
                SSLSocket s = (SSLSocket) waitingSocket.accept();
                trafficHandler.processConnection(s);
            } catch (NoHandlerForConnectionTypeException ex) {
                ex.printStackTrace();
            } catch (SocketTimeoutException ex) {
                ex.printStackTrace();
            } catch (IOException ex) {
                ex.printStackTrace();
                break;
            }
        }
    }
    
 
    
}
