/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package client.net;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;

/**
 * @author Ati
 */
public class ConnectionMediator {

    private OutputStream outputStream;
    private InputStream inputStream;
    private Socket socket;
    private String ip;
    private int port;
    private String[] initialMsgs;
    private ConnectionProvider conProv;

    public ConnectionMediator(ConnectionProvider con, String ip, int port, String[] initialMsgs) throws IOException {
        this.initialMsgs = initialMsgs;
        conProv = con;

        socket = conProv.connectTo(ip, port);
        outputStream = socket.getOutputStream();
        inputStream = socket.getInputStream();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream));

        for (String msg : initialMsgs) {
            sendMessage(bw, msg);
        }
    }


    public OutputStream getOutputStream() {
        return outputStream;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public Socket getSocket() {
        return socket;
    }

    private static void sendMessage(BufferedWriter bw, String msg) throws IOException {
        bw.write(msg, 0, msg.length());
        bw.newLine();
        bw.flush();
    }

    public static void sendMessages(BufferedWriter bw, String[] msgs) throws IOException {
        for (String msg : msgs) {
            sendMessage(bw, msg);
        }
    }

    public static void sendMessages(OutputStream os, String[] msgs) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        for (String msg : msgs) {
            sendMessage(bw, msg);
        }
    }
}
