/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package client.net;

import client.MainClass;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

/**
 *
 * @author Ati
 */
public class SSLConnector implements ConnectionProvider {

    private SocketFactory socketFactory;

    public SSLConnector() throws FileNotFoundException,IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, CertificateException, KeyManagementException {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(MainClass.SCRIPTS_DIR + File.separator + "truststr.jks"), "turtlepassword".toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            SSLContext sslc = SSLContext.getInstance("SSL");
            sslc.init(null, tmf.getTrustManagers(), null);
            socketFactory = sslc.getSocketFactory();
    }

    public synchronized Socket connectTo(String host, int port) throws IOException {
        return socketFactory.createSocket(host, port);
    }
}
