/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package client.net.commun;

import client.net.*;
import client.net.commun.ClientAdapter;
import client.net.commun.ClientManager;
import client.InfoProvider;
import client.OptionalValueProvider;
import client.OwnFileDescriptor;
import common.StaticValues;
import common.XmlSpecChConv;
import common.commun.StaticProtocolStrings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 *
 * @author Ati
 */
public class HumpClient extends AbstractNormalClient {
    
    private static Logger logger = Logger.getLogger(HumpClient.class.getName());
    private static final int FILE_SHARE_MSG = 102;
    private static final int HUMP_INTRODUCTION_MSG = 101;
    private static final int ATP_CONNECTION_MSG = 103;
    
    public static final String INITIALIZED_STATE = "Initialized";
    private ArrayList<String> groups = new ArrayList<String>();
    private boolean isRegistered;
    private InfoProvider infoProvider;
    private MessageDigest messageDiggest;
    private String serverID;
    private ClientAdapter fileInfoPurAdapter;
 

    public HumpClient(ClientManager cm, Socket s, InputStream is, InfoProvider inf) throws IOException {
        this(cm, s, s.getOutputStream(), is, inf, false);
    }

    private HumpClient(ClientManager cm, Socket s, OutputStream os, InputStream is, InfoProvider inf, boolean passive) throws IOException {
        super(cm, s, is, os, passive,false);
        try {
            this.infoProvider = inf;
            state = INITIALIZING_STATE;
//          
            
            sendMessage(HUMP_INTRODUCTION_MSG);
         //   sendMessage(FILE_SHARE_MSG);
            messageDiggest = MessageDigest.getInstance("SHA-1");
            clientManager.fireClientConnected(this);
            
            messageWaiterThread.start();
        } catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
    }

    private void clientInitialized() {
        sendMessage(FILE_SHARE_MSG);
    }
    
    private String getSharedFilesXML() {

        ArrayList<OwnFileDescriptor> rootFiles = infoProvider.getRootFiles();
        StringBuilder rootIds = new StringBuilder();
        for (OwnFileDescriptor owd : rootFiles) {
            rootIds.append(owd.getFile_id() + ",");
        }
        if (rootIds.length() > 0) {
            rootIds.deleteCharAt(rootIds.length() - 1);
        }

        StringBuilder res = new StringBuilder(500);
        res.append("<message  type = \"sharedfiles\">");

        res.append("<files>");
        filterFilesToXML(res, infoProvider.getTopLevelFiles());
        res.append("</files>");
        res.append("</message>");
        return res.toString();
    }

    @Override
    protected String getMessage(int type) {
        switch (type) {
            case HUMP_INTRODUCTION_MSG: {
                return "<msg type = \"humpintroduction\">" +
                        "<client type = \"norm\"/>" +
                        "<name>" + XmlSpecChConv.convert(OptionalValueProvider.getName()) + "</name>" +
                        "<desc>" + XmlSpecChConv.convert(OptionalValueProvider.getDescription()) + "</desc>" +
                        "<ispassive>" + OptionalValueProvider.isPassive() + "</ispassive>" +
                        "<id>" + XmlSpecChConv.convert(OptionalValueProvider.getClientID()) + "</id>" +
                        "</msg>";
            }
            case FILE_SHARE_MSG:
                return getSharedFilesXML();
            case ATP_CONNECTION_MSG: {
                return "<msg type = \"" + StaticProtocolStrings.ACTTOPASS_CON_TYPE + "\">" +
                        "<id>" + XmlSpecChConv.convert(OptionalValueProvider.getClientID()) + "</id>" +
                        "<comport>" + OptionalValueProvider.getCommunicationListeningPort() + "</comport>" +
                        "<serverid>" + XmlSpecChConv.convert(serverID) + "</serverid>" +
                        "</msg>";
            }
            default:
                return super.getMessage(type);
        }

    }

    private void filterFilesToXML(StringBuilder res, List<OwnFileDescriptor> files) {
        for (OwnFileDescriptor owd : files) {
            short pubaccess;
            if (groups.contains(owd.getGroup())) {
                pubaccess = (short) Math.max(owd.getGroupAccessibility(), owd.getPublicAccessiblity());
            } else {
                pubaccess = owd.getPublicAccessiblity();
            }

            if (pubaccess != StaticValues.NOT_ACCESSIBLE_FILE) {
                if (owd.isDirectory()) {
                    res.append("<file type = \"dir\">");
                    res.append("<name>" + XmlSpecChConv.convert(owd.getFileName()) + "</name>");
                    res.append("<id>" + owd.getFile_id() + "</id>");
                    res.append("<access>" + pubaccess + "</access>");
                    res.append("<isroot>" + owd.isRoot() + "</isroot>");
                    res.append("<subfiles>");

                    if (owd.getFiles() != null) {
                        filterFilesToXML(res, owd.getFiles());
                    }

                    res.append("</subfiles>");
                    res.append("</file>");
                } else {
                    res.append("<file type = \"file\">");
                    res.append("<name>" + XmlSpecChConv.convert(owd.getFileName()) + "</name>");
                    res.append("<ext>" + XmlSpecChConv.convert(owd.getExtension()) + "</ext>");
                    res.append("<access>" + pubaccess + "</access>");
                    res.append("<size>" + owd.getSize() + "</size>");
                    res.append("<id>" + owd.getFile_id() + "</id>");
                    res.append("<isroot>" + owd.isRoot() + "</isroot>");
                    res.append("</file>");
                }
            }
        }
    }

    public boolean isRegistered() {
        return isRegistered;
    }

    private synchronized void processMessage(String msg) {
        Document doc;
        try {
            InputSource isource = new InputSource(new StringReader(msg));
            doc = docBuilder.parse(isource);
            Element root = doc.getDocumentElement();
            String type = root.getAttribute("type");

            if (type.equals("introduction")) {
                NodeList nl = root.getElementsByTagName("name");
                name = nl.item(0).getTextContent();

                //  System.out.println(name);

                nl = root.getElementsByTagName("password");
                String password = nl.item(0).getTextContent();
                String hashPasswd = "";
                if (password != null && password.length() > 0) {
                    hashPasswd = new String(messageDiggest.digest(password.getBytes()));
                }

                nl = root.getElementsByTagName("description");
                description = nl.item(0).getTextContent();

                nl = root.getElementsByTagName("ispassive");
                passive = Boolean.parseBoolean(nl.item(0).getTextContent());

//                nl = root.getElementsByTagName("transfport");
//                transfPort = Integer.parseInt(nl.item(0).getTextContent());

                nl = root.getElementsByTagName("id");
                id = nl.item(0).getTextContent();

                groups = infoProvider.getGroups(name, hashPasswd);
                isRegistered = infoProvider.isRegistered(name);
                state = INITIALIZED_STATE;
                clientManager.fireClientStateChanged(this);
                clientInitialized();
            } else if (type.equals(StaticProtocolStrings.TOACTO_FROM_PASS_TRANS_SERVER_REQ)) {
                int port = Integer.parseInt(root.getElementsByTagName("comport").item(0).getTextContent());
                String tosend = "<msg type = \"" + StaticProtocolStrings.TOACT_FROM_PASSIVE_TRANS_REPLY +
                        "\" ><id>" + OptionalValueProvider.getClientID() + "</id>" +
                        "</msg>";
                clientManager.getPendingConnectionController().createPendingConnection(socket.getInetAddress().getHostAddress(),
                        port, tosend);
            } else {
                System.out.println("HumpClient - unkonwmsg");
            }

        } catch (IOException ex) {
            clientManager.clientDisconnected(this);
            ex.printStackTrace();
        } catch (SAXException ex) {
            ex.printStackTrace();
        }
    }

    public void run() {
        try {
            while (true) {
                String msg = messageReciever.readMessage();
                if (msg == null) {
                    clientManager.fireClientDisconnected(this);
                    return;
                }

                processMessage(msg);
            }

        } catch (IOException ex) {
        //    ex.printStackTrace();
            logger.log(Level.SEVERE, "Hump client disconnected");
            clientManager.fireClientDisconnected(this);

        }
    }
}
