package client.net.commun;

import client.*;
import client.net.transfer.ClientFileDescriptor;
import common.XmlSpecChConv;
import common.commun.StaticProtocolStrings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NormalClient extends AbstractNormalClient implements Runnable, NormalClientDescriptor {

    public static final String FILES_INFO_PROVIDED_STATE = "File info provided";
    private static final int INTRODUCTION_MESSAGE = 0;
    private static final int ATP_TRANSFER_REQUEST = 1;
    private ArrayList<ClientFileDescriptor> sharedFiles = null;
    private Profile profile;
    /** if connected to a passive client throug a server, this is the reference for server */
    private ServerClient conHlpServer = null;
    private int comPort = -1;

    /**Constructor for ATP connection */
    public NormalClient(ClientManager cm, Socket s, OutputStream os,
            InputStream is, Profile p, ServerClient c, int comport) throws IOException {
        this(cm, s, os, is, p, true, c, comport);
    }

    public NormalClient(ClientManager cm, Socket s, OutputStream os, InputStream is, Profile p) throws IOException {
        this(cm, s, os, is, p, false, null, -1);

    }

    private NormalClient(ClientManager cm, Socket s, OutputStream os, InputStream is,
            Profile p, boolean passive, ServerClient c, int comport) throws IOException {
        super(cm, s, is, os, passive, true);
        this.profile = p;
        this.conHlpServer = c;
        this.comPort = comport;
        sendMessage(INTRODUCTION_MESSAGE);
        clientManager.fireConnectedToClient(this);

    }

    private synchronized void processMessage(String msg) {
        Document doc;
        try {
            InputSource isource = new InputSource(new StringReader(msg));
            doc = docBuilder.parse(isource);
            Element root = doc.getDocumentElement();
            String type = root.getAttribute("type");

            if (type.equals("sharedfiles")) {

                NodeList nl = root.getElementsByTagName("files");
                sharedFiles = new ArrayList<ClientFileDescriptor>();
                initFileDescriptors(nl.item(0).getChildNodes(), null);
                state = FILES_INFO_PROVIDED_STATE;
            } else if (type.equals("humpintroduction")) {
                NodeList nl = root.getElementsByTagName("name");
                name = nl.item(0).getTextContent();

                nl = root.getElementsByTagName("desc");
                description = nl.item(0).getTextContent();

                nl = root.getElementsByTagName("ispassive");
                passive = Boolean.parseBoolean(nl.item(0).getTextContent());

                nl = root.getElementsByTagName("id");
                id = nl.item(0).getTextContent();

                //   transfPort = Integer.parseInt(root.getElementsByTagName("transfport").item(0).getTextContent());
                state = CONNECTED_STATE;
                clientManager.fireOutClientStateChanged(this);
            } else {
                System.out.println("Normal client - unknown message");
            }

        } catch (IOException ex) {
            clientManager.disconnectedFrom(this);
            ex.printStackTrace();
        } catch (SAXException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected String getMessage(int type) {
        switch (type) {
            case INTRODUCTION_MESSAGE: {
                return "<msg type = \"introduction\">" +
                        "<name>" + XmlSpecChConv.convert(profile.getName()) + "</name>" +
                        "<password>" + XmlSpecChConv.convert(profile.getPassword()) + "</password>" +
                        "<ispassive>" + OptionalValueProvider.isPassive() + "</ispassive>" +
                        "<description>" + XmlSpecChConv.convert(profile.getDescription()) + "</description>" +
                        "<id>" + XmlSpecChConv.convert(OptionalValueProvider.getClientID()) + "</id>" +
                        "<request>" +
                        "<fileshare/>" +
                        "</request>" +
                        "</msg>";
            }
            case ATP_TRANSFER_REQUEST: {
                return "<msg type = \"" + StaticProtocolStrings.TOACTO_FROM_PASS_TRANS_SERVER_REQ + "\" >" +
                        "<ip>" + socket.getLocalAddress().getHostAddress() + "</ip>" +
                        "<comport>" + OptionalValueProvider.getCommunicationListeningPort() + "</comport>" +
                        "</msg>";

            }
            default:
                return super.getMessage(type);
        }
    }

    /**inits the file descripstors, sets the shredFiles variable */
    private ArrayList<ClientFileDescriptor> initFileDescriptors(NodeList nl, ClientFileDescriptor parent) {
        ArrayList<ClientFileDescriptor> res = new ArrayList<ClientFileDescriptor>(nl.getLength());
        for (int i = 0; i < nl.getLength(); i++) {
            Node n = nl.item(i);
            String type = n.getAttributes().getNamedItem("type").getTextContent();
            if (type.equals("file")) {
                NodeList chnodes = n.getChildNodes();
                String filename = chnodes.item(0).getTextContent();
                String ext = chnodes.item(1).getTextContent();
                short access = Short.parseShort(chnodes.item(2).getTextContent());
                long size = Long.parseLong(chnodes.item(3).getTextContent());
                int fid = Integer.parseInt(chnodes.item(4).getTextContent());
                boolean isRoot = Boolean.parseBoolean(chnodes.item(5).getTextContent());

                ClientFileDescriptor cfd = new ClientFileDescriptor(filename, ext, size, parent, this, access, fid, isRoot);
                res.add(cfd);

                if (isRoot) {
                    sharedFiles.add(cfd);
                }
            } else {
                NodeList chnodes = n.getChildNodes();
                String dirname = chnodes.item(0).getTextContent();
                short access = Short.parseShort(chnodes.item(1).getTextContent());
                int fid = Integer.parseInt(chnodes.item(2).getTextContent());
                boolean isRoot = Boolean.parseBoolean(chnodes.item(3).getTextContent());
                NodeList subFileNodes = chnodes.item(4).getChildNodes();
                ClientFileDescriptor cfd = new ClientFileDescriptor(dirname, parent, this, access, fid, null, isRoot);
                cfd.setFiles(initFileDescriptors(subFileNodes, cfd));
                res.add(cfd);
                if (isRoot) {
                    sharedFiles.add(cfd);
                }
            }
        }

        return res;
    }

    public void requestATPConnectionForTransfer() {
        sendMessage(ATP_TRANSFER_REQUEST);
    }

    public void run() {
        try {
            while (true) {
                String msg = messageReciever.readMessage();
                if (msg == null) {
                    //  System.out.println("NULL message from client - disconnecting");
                    return;
                }
                processMessage(msg);

            }
        } catch (IOException ex) {
            state = DISCONNECTED_STATE;
            clientManager.fireOutClientStateChanged(this);
        //    ex.printStackTrace();
        }
    }

    public ArrayList<ClientFileDescriptor> getSharedFiles() {
        return sharedFiles;
    }

    public Profile getProfileConnectedWith() {
        return profile;
    }

    public void disconnect() {
        clientManager.fireDisconnectedFrom(this);
        disconnectSocket();
        state = DISCONNECTED_STATE;
    }

    public ServerClient getConAssistantServer() {
        return conHlpServer;
    }

    @Override
    public int getCommunicationPort() {
        if (comPort == -1) {
            return super.getCommunicationPort();
        } else {
            return comPort;
        }
    }
}
