package client.net.commun;

import client.net.*;
import client.*;
import client.net.transfer.BridgeTransferHandler;
import client.net.transfer.ClientFileDescriptor;
import common.XmlSpecChConv;
import common.commun.StaticProtocolStrings;
import java.io.IOException;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServerClient extends AbstractClient implements Runnable {

    public static final int CONNECTED_STATE = 1;
    public static final int DISCONNECTED_STATE = 2;
    private static final int INTRODUCTION_MSG = 1;
//    public static final int REQ_SERVER_TO_ASK_PASSIVE_MSG = 2;
    /**type of message with witch we ask server to forward connection request to passive client*/
    private ArrayList<PossibleClientDescriptor> possibleClients = new ArrayList<PossibleClientDescriptor>();
    private InfoProvider infoProvider;
    private DocumentBuilder docBuilder;
    private String id;
    private int clientCount;
    private int state;
    private BridgeTransferHandler bridgeTransferHandler = null;

    public ServerClient(Socket s, ClientManager cm, InfoProvider infoProvider) throws IOException {
        super(cm, s, s.getInputStream(), s.getOutputStream());
        try {
            this.infoProvider = infoProvider;
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            messageWaiterThread = new Thread(this);
            messageWaiterThread.start();
            clientManager.fireConnectedToServer(this);
            sendMessage(INTRODUCTION_MSG);
            state = CONNECTED_STATE;
        } catch (Exception ex) {
            ex.printStackTrace();
            try {
                s.close();
            } catch (IOException e) {
            }
        }
    }

    private void processMessage(String msg) {
        Document doc;
        try {
            InputSource isource = new InputSource(new StringReader(msg));
            doc = docBuilder.parse(isource);
            Element root = doc.getDocumentElement();
            String type = root.getAttribute("type");

            if (type.equals("serverintroduction")) {
                name = root.getElementsByTagName("name").item(0).getTextContent();
                clientCount = Integer.parseInt(root.getElementsByTagName("clientnum").item(0).getTextContent());
                id = root.getElementsByTagName("id").item(0).getTextContent();
                clientManager.fireServerStateChanged(this);
            } else if (type.equals("clientsinfo")) {
                NodeList nl = root.getElementsByTagName("client");
                for (int i = 0; i < nl.getLength(); i++) {
                    Node node = nl.item(i);
                    NodeList childs = node.getChildNodes();

                    String nm = childs.item(0).getTextContent();
                    String desc = childs.item(1).getTextContent();
                    boolean pas = Boolean.parseBoolean(childs.item(2).getTextContent());
                    int cp = Integer.parseInt(childs.item(3).getTextContent());
                    long samount = Long.parseLong(childs.item(4).getTextContent());
                    String pcid = childs.item(5).getTextContent();
                    String ip = childs.item(6).getTextContent();
                    possibleClients.add(new PossibleClientDescriptor(this, nm, desc, pas, cp, ip, samount, pcid));
                }
            } else if (type.equals(StaticProtocolStrings.TOACTO_FROM_PASS_SERVER_REQ)) {
                String ip = root.getElementsByTagName("ip").item(0).getTextContent();
                int port = Integer.parseInt(root.getElementsByTagName("port").item(0).getTextContent());
                clientManager.connectAsATPReply(ip, port, id);
            } else if (type.equals(StaticProtocolStrings.SERV_TO_REQUESTED_TO_BRIDGE)) {
                PendingConnectionController pcc = clientManager.getPendingConnectionController();

                String host = root.getElementsByTagName("ip").item(0).getTextContent();
                int port = Integer.parseInt(root.getElementsByTagName("port").item(0).getTextContent());
                String remID = root.getElementsByTagName("id").item(0).getTextContent();

                String tosend = "<con type = \"" + StaticProtocolStrings.TO_BRIDGE_CONN_TYPE + "\">" +
                        "<pur>" + StaticProtocolStrings.BRIDGE_CON_PURPOSE_COMM + "</pur>" +
                        "<role>" + StaticProtocolStrings.BRIDGE_CON_ROLE_ANS + "</role>" +
                        "<id>" + XmlSpecChConv.convert(remID) + "</id>" +
                        "</con>";
                pcc.createPendingConnection(host, port, tosend);

            } else if (type.equals(StaticProtocolStrings.SERV_TO_REQUESTER_TO_BRIDGE)) {
                String host = root.getElementsByTagName("ip").item(0).getTextContent();
                int port = Integer.parseInt(root.getElementsByTagName("port").item(0).getTextContent());
                String remID = root.getElementsByTagName("id").item(0).getTextContent();

                clientManager.handleComConnectionToBride(host, port, remID, this);

            } else if (type.equals(StaticProtocolStrings.SERV_TO_REQUESTED_TO_BRIDGE_TRANS)) {
                PendingConnectionController pcc = clientManager.getPendingConnectionController();

                String host = root.getElementsByTagName("ip").item(0).getTextContent();
                int port = Integer.parseInt(root.getElementsByTagName("port").item(0).getTextContent());
                String remID = root.getElementsByTagName("id").item(0).getTextContent();

                String tosend = "<con type = \"" + StaticProtocolStrings.TO_BRIDGE_CONN_TYPE + "\">" +
                        "<pur>" + StaticProtocolStrings.BRIDGE_CON_PURPOSE_TRANS + "</pur>" +
                        "<role>" + StaticProtocolStrings.BRIDGE_CON_ROLE_ANS + "</role>" +
                        "<id>" + XmlSpecChConv.convert(remID) + "</id>" +
                        "</con>";
                pcc.createPendingConnection(host, port, tosend);

            } else if (type.equals(StaticProtocolStrings.SERV_TO_REQUESTER_TO_BRIDGE_TRANS)) {
                String host = root.getElementsByTagName("ip").item(0).getTextContent();
                int port = Integer.parseInt(root.getElementsByTagName("port").item(0).getTextContent());
                String remID = root.getElementsByTagName("id").item(0).getTextContent();

                bridgeTransferHandler.handleTransferAcrossBridge(host, port, remID, this);
            } else if (type.equals(StaticProtocolStrings.CLIENT_CONNECTED)) {

                String namec = root.getElementsByTagName("name").item(0).getTextContent();
                String desc = root.getElementsByTagName("desc").item(0).getTextContent();
                boolean passive = Boolean.parseBoolean(root.getElementsByTagName("ispassive").item(0).getTextContent());
                int conport = Integer.parseInt(root.getElementsByTagName("conport").item(0).getTextContent());
                long shaream = Long.parseLong(root.getElementsByTagName("shareamount").item(0).getTextContent());
                String idc = root.getElementsByTagName("id").item(0).getTextContent();
                String ip = root.getElementsByTagName("ip").item(0).getTextContent();
                PossibleClientDescriptor pcd = new PossibleClientDescriptor(this, namec, desc, passive, conport, ip, shaream, idc);
                possibleClients.add(pcd);
                clientManager.fireClientConnectedToServer(this, pcd);
            } else if (type.equals(StaticProtocolStrings.CLIENT_DISCONNECTED)) {
                PossibleClientDescriptor torem = null;
                String idd = root.getElementsByTagName("id").item(0).getTextContent();
                for (PossibleClientDescriptor pcd : possibleClients) {
                    if (pcd.getId().equals(idd)) {
                        torem = pcd;
                    }
                }

                if (torem != null) {
                    possibleClients.remove(torem);
                    clientManager.fireClientDisconnectedFromServer(this, torem);
                }

            } else {
                System.out.println("unknown msg type: " + type);
            }

        } catch (SAXException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected String getMessage(int type) {
        StringBuilder res = new StringBuilder();
        if (type == INTRODUCTION_MSG) {
            res.append("<connection type = \"" + StaticProtocolStrings.CONNECT_TO_SERVER + "\">");

            res.append("<name>" +
                    XmlSpecChConv.convert(OptionalValueProvider.getName()) + "</name>");
            res.append("<description>" + XmlSpecChConv.convert(OptionalValueProvider.getDescription()) + "</description>");
            res.append("<ispassive>" + OptionalValueProvider.isPassive() + "</ispassive>");

            res.append("<shareamount>" + infoProvider.getShareAmount() + "</shareamount>");
//            res.append("<transfport>" +OptionalValueProvider.
//                    getFileTransferListeningPort() + "</transfport>");
            res.append("<conport>" + OptionalValueProvider.getCommunicationListeningPort() + "</conport>");
            res.append("<id>" + XmlSpecChConv.convert(OptionalValueProvider.getClientID()) + "</id>");
            res.append("</connection>");
        }

        return res.toString();
    }

    void sendPassiveConnectionRequest(PossibleClientDescriptor pcd) {
        String msg = "<msg type = \"" + StaticProtocolStrings.REQ_SERVER_TO_ASK_PASSIVE_CON_TYPE + "\">" +
                "<id>" + XmlSpecChConv.convert(pcd.getId()) + "</id>" +
                "</msg>";
        sendMessage(msg);
    }

    /** Sends same message as sendPassiveConnectionRequest, than the server controls
     * the clients accessible state to.
     * @param pcd
     */
    void sendPtPConnectionRequest(PossibleClientDescriptor pcd) {
        String msg = "<msg type = \"" + StaticProtocolStrings.REQ_SERVER_TO_ASK_PASSIVE_CON_TYPE + "\">" +
                "<id>" + XmlSpecChConv.convert(pcd.getId()) + "</id>" +
                "</msg>";
        sendMessage(msg);
    }

    public void requestPtPTransfer(ClientFileDescriptor cfd) {
        if (bridgeTransferHandler == null) {
            throw new NullPointerException("BridgeTransferHandler of the server client is null.");
        }

        String msg = "<msg type = \"" + StaticProtocolStrings.REQ_SERVER_TO_ASK_PASSIVE_TRANS_TYPE + "\">" +
                "<id>" + XmlSpecChConv.convert(cfd.getNormalClientDescriptor().getID()) + "</id>" +
                "</msg>";
        sendMessage(msg);
    }

    public void run() {
        try {
            while (true) {
                String msg = messageReciever.readMessage();
                processMessage(msg);
            }
        } catch (IOException ex) {
            ex.printStackTrace();

            try {
                messageSender.close();
            } catch (IOException e) {
            }

            try {
                messageReciever.close();
            } catch (IOException e) {
            }


            try {
                socket.close();
            } catch (IOException e) {
            // e.printStackTrace();
            }
            state = DISCONNECTED_STATE;
            clientManager.fireDisconnectedFromServer(this);
        }
    }

    public void disconnect() {
        clientManager.fireDisconnectedFromServer(this);
        disconnectSocket();
    }

    public ArrayList<PossibleClientDescriptor> getPossibleClients() {
        return possibleClients;
    }

    public int getClientCount() {
        if (possibleClients.isEmpty()) {
            return clientCount;
        } else {
            return possibleClients.size();
    
        }
    }

    public String getID() {
        return id;
    }

    public int getState() {
        return state;
    }

    public PossibleClientDescriptor getPosClientDescriptor(String id) {
        for (PossibleClientDescriptor pcd : possibleClients) {
            if (pcd.getId().equals(id)) {
                return pcd;
            }
        }
        return null;
    }

    public void setBridgeTransferHandler(BridgeTransferHandler bridgeTransferHandler) {
        this.bridgeTransferHandler = bridgeTransferHandler;
    }
}
