/*
 * LANManager.java
 *
 * Created on 06 October 2007, 16:38
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package client.net.lan;

import client.OptionalValueProvider;
import common.XmlSpecChConv;
import java.io.IOException;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 *
 * @author A
 */
public class LANManager implements Runnable {

    public static final String MULTICAST_GROUP = "231.0.0.1";
    private static final String INFO_REQ_TYPE_STRING = "laninforequest";
    private static final String INFO_REPLY_TYPE_STRING = "laninfo";
    private static final String LAN_INFO_REQ = "<msg type = \"" + INFO_REQ_TYPE_STRING + "\"/>";
    private ArrayList<LANClientsListener> lanClientListeners = new ArrayList<LANClientsListener>();
    private ArrayList<LANClientDescriptor> lanClientDescriptors = new ArrayList<LANClientDescriptor>();
    private MulticastSocket multiCastSocket;
    private InetAddress multicastAddress;
    private DocumentBuilder docBuilder;
    private Thread packetWaiter;
    private InetAddress myLocalAddress = InetAddress.getLocalHost();
    private boolean functional;

    /** Creates a new instance of LANManager */
    public LANManager(int port) throws IOException, ParserConfigurationException {
        try {
            multiCastSocket = new MulticastSocket(port);
            multicastAddress = InetAddress.getByName(MULTICAST_GROUP);
            multiCastSocket.joinGroup(multicastAddress);
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            packetWaiter = new Thread(this);
            packetWaiter.start();
            functional = true;
        } catch (SocketException ex) {
            ex.printStackTrace();
            functional = false;
        }
    }

    public synchronized void refreshLANClientList() throws IOException {
        refreshLANClientList(OptionalValueProvider.getBroadcastPort());
    }

    private synchronized void refreshLANClientList(int port) throws IOException {
        lanClientDescriptors.clear();
        sendRequest(port);
        fireListRefresh();
    }

    private synchronized void sendRequest(int port) throws IOException {
        byte[] buf = LAN_INFO_REQ.getBytes();
        DatagramPacket p = new DatagramPacket(buf, buf.length, multicastAddress, port);
        multiCastSocket.send(p);
    }

    private synchronized void sendReply(InetAddress a, int port) {
        try {
            String repmsg = "<msg type = \"" + INFO_REPLY_TYPE_STRING + "\"> +" +
                    "<name>" + XmlSpecChConv.convert(OptionalValueProvider.getName()) + "</name>" +
                    "<desc>" + XmlSpecChConv.convert(OptionalValueProvider.getDescription()) + "</desc>" +
                    "<conport>" + OptionalValueProvider.getCommunicationListeningPort() + "</conport>" +
                    "</msg>";
            byte[] buf = repmsg.getBytes();
            DatagramPacket p = new DatagramPacket(buf, buf.length, a, port);
            multiCastSocket.send(p);
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public synchronized ArrayList<LANClientDescriptor> getLANClientDescriptors() {
        return (ArrayList<LANClientDescriptor>) lanClientDescriptors.clone();
    }

    /** adds a LANClientDescriptor and fires the client found event */
    private synchronized void addLANClientdescriptor(LANClientDescriptor d) {
        lanClientDescriptors.add(d);
        fireClientFound(d);
    }

    private synchronized void processPacket(DatagramPacket p) {
        String msg = new String(p.getData(), 0, p.getLength());
        try {
            Document doc = docBuilder.parse(new InputSource(new StringReader(msg)));
            Element root = doc.getDocumentElement();
            String type = root.getAttribute("type");
            if (type.equals(INFO_REQ_TYPE_STRING)) {
//                if (!p.getAddress().equals(myLocalAddress)) {
                sendReply(p.getAddress(), p.getPort());
//                }
            } else if (type.equals(INFO_REPLY_TYPE_STRING)) {
                String name = root.getElementsByTagName("name").item(0).getTextContent();
                String desc = root.getElementsByTagName("desc").item(0).getTextContent();
                int port = Integer.parseInt(root.getElementsByTagName("conport").item(0).getTextContent());
                LANClientDescriptor lcd = new LANClientDescriptor(p.getAddress(), port, name, desc);
                addLANClientdescriptor(lcd);
            } else {
                System.out.println("unknown msg");
            }

        } catch (SAXException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void run() {
        try {
            while (true) {
                byte[] buf = new byte[1500];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                multiCastSocket.receive(packet);
                processPacket(packet);
            }
        } catch (IOException ex) {
            ex.printStackTrace();
            functional = false;
        }
    }

    public synchronized void addLANClientListener(LANClientsListener l) {
        lanClientListeners.add(l);
    }

    public synchronized void removeLANClientListener(LANClientsListener l) {
        lanClientListeners.remove(l);
    }

    private synchronized void fireClientFound(LANClientDescriptor d) {
        for (LANClientsListener l : lanClientListeners) {
            l.possibleLANClientFound(d);
        }
    }

    private synchronized void fireListRefresh() {
        for (LANClientsListener l : lanClientListeners) {
            l.listRefresh();
        }
    }

    public boolean isFunctional() {
        return functional;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        multiCastSocket.leaveGroup(multicastAddress);
        multiCastSocket.close();
    }
    
    
}
