package client.net.transfer;

import client.*;
import common.commun.StaticProtocolStrings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FileSender extends FileTransferer implements Runnable {

    private static int BUFFER_SIZE = 8192;
    public static final int SENDING = 0;
    public static final int SEND_COMPLETED = 1;
    public static final int INTERRUPTED = 2;
    public static final int CANNOT_START = 3;
    public static final int PAUSED = 4;
    private InfoProvider infoProvider;
    private Socket socket;
    private TransferManager transferManager;
    private OutputStream os;
    private Thread sender;
    private File toSend;
    private int file_id;
    private volatile long progress = 0;
    private volatile int state = 0;
    private volatile boolean paused = false;

    public FileSender(Socket s, OutputStream os, InputStream is, Document doc, Profile profile, InfoProvider infoProvider, TransferManager transferManager) {
        super(is, os);
        this.infoProvider = infoProvider;
        this.socket = s;
        this.transferManager = transferManager;
        this.os = os;

        Element elem = doc.getDocumentElement();
        Node node = elem.getElementsByTagName("files").item(0);
        int id = Integer.parseInt(node.getChildNodes().item(0).getAttributes().getNamedItem("id").getTextContent());
        file_id = id;
        boolean send = infoProvider.canDownload(profile, id);

        if (send) {
            String path = infoProvider.getFilePath(id);
            toSend = new File(path);
        }
        
        if (send && toSend.exists()) {
            sendMessage(getSendingMsg(file_id));
            sender = new Thread(this, "FileSender Thread - file id: " + id);
            sender.start();
            state = SENDING;
            transferManager.fireFileSendingStarted(this);

        } else {
            state = CANNOT_START;
            String reason;
            if (!send) {
                reason = StaticProtocolStrings.TRASF_RESTRICT_REASON_ACCESS;
            } else if (!toSend.exists()) {
                reason = StaticProtocolStrings.TRASF_RESTRICT_REASON_FNOTEXIST;
            } else {
                reason = StaticProtocolStrings.TRASF_RESTRICT_REASON_UNKNOWN;
            }
            sendMessage(getSendRestrictMessage(reason, file_id));
        }
    }

    public void pause() {
        paused = true;
    }

    public void continuE() {
        if (state == PAUSED) {
            paused = false;
            sender.interrupt();
            state = SENDING;
        }
    }

    public void resume() {

    }

    private String getSendRestrictMessage(String reason, int id) {
        return "<msg type = \"" + StaticProtocolStrings.TRANSF_RESTRICT +
                "\"><id>" + id + "</id><reason>" + reason + "</reason></msg>";
    }

    private String getSendingMsg(int file_id) {
        StringBuilder res = new StringBuilder(45);
        res.append("<msg type = \"sending\">");
        res.append("<id>" + file_id + "</id>");
        res.append("</msg>");
        return res.toString();
    }

    public void run() {
        try {
            FileInputStream inStream = new FileInputStream(toSend);
            BufferedInputStream bis = new BufferedInputStream(inStream);

            BufferedOutputStream outs = new BufferedOutputStream(os);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));


            byte[] buf = new byte[BUFFER_SIZE];

            int aval, count;

            while ((count = bis.read(buf, 0, buf.length)) != -1) {
                outs.write(buf, 0, count);
                progress += count;

                while (paused) {
                    outs.flush();
                    state = PAUSED;
                    try {
                        Thread.sleep(1000000);
                    } catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }


            outs.flush();
            inStream.close();
            outs.close();
            state = SEND_COMPLETED;
            transferManager.fireFileSendingCompleted(this);
        } catch (IOException ex) {
            state = INTERRUPTED;
            transferManager.fireFileSendingInetrrupted(new SendInterruptEvent(ex, this));
            ex.printStackTrace();
        }
    }

    public long getProgress() {
        return progress;
    }

    public long getFileSize() {
        return toSend.length();
    }

    public String getFileName() {
        return toSend.getName();
    }

    public int getState() {
        return state;
    }

    @Override
    protected String getMessage(int type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
