/*
 * TransferConnectionWaiter.java
 *
 * Created on 20 March 2007, 16:24
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package client.net.transfer;

import client.*;
import exceptions.ClientConnectionWaiterInitException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

/**
 *
 * @author A
 */
public class TransferConnectionWaiter extends Thread {
    public static int CLIENT_WAITING_PORT = 5255;
    
    private TransferManager transferManager;
    
    private volatile SSLServerSocket waitingSocket;
    private Thread waitingThread;
    
    public TransferConnectionWaiter(TransferManager tm,int port) throws ClientConnectionWaiterInitException {
        transferManager = tm;
        try {
            KeyStore ks;
            ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(MainClass.SCRIPTS_DIR + File.separator + "keystr.jks"), "turtlepassword".toCharArray());
            KeyManagerFactory km = KeyManagerFactory.getInstance("SunX509","SunJSSE");
            km.init(ks,"turtlestandard".toCharArray());
            SSLContext sslc = SSLContext.getInstance("SSL");
            sslc.init(km.getKeyManagers(),null,null);
            SSLServerSocketFactory sslfactory = sslc.getServerSocketFactory();
           
            waitingSocket = (SSLServerSocket)sslfactory.createServerSocket(port);
            
            waitingThread = new Thread(this);
            waitingThread.start();
        } catch (Exception ex) {
            ex.printStackTrace();
            throw new ClientConnectionWaiterInitException(ex);
        }
    }
    
    @Override
    public void run() {
      try {  
        while (true) {
            Socket s = waitingSocket.accept();
           // transferManager.connected(s);
        }
      } catch (IOException ex) {
          ex.printStackTrace();
      }
    }
    
    public TransferManager getTransferManager() {
        return transferManager;
    }
    
    public void setTransferManager(TransferManager transferManager) {
        this.transferManager = transferManager;
    }
    
}
