package common;

import java.util.List;

public abstract class AbstractFileDescriptor {
    private String fileName;
    
    private String extension;
    
    private boolean isDir;
    
    private long size;
    
    protected short public_accessiblity;
    
    protected int file_id;
    
    public AbstractFileDescriptor(String fileName, String extension, boolean isDir, long size,short accessibility,int id) {
        this.fileName = fileName;
        this.extension = extension;
        this.isDir = isDir;
        this.size = size;
        this.public_accessiblity = accessibility;
        this.file_id = id;
    }
    
    public String getFileName() {
        return fileName;
    }
    
    
    public String getExtension() {
        return extension;
    }
    
    public boolean isDirectory() {
        return isDir;
    }
    
    public void setIsDirectory(boolean val) {
        this.isDir = val;
    }
    
    public long getSize() {
        return size;
    }
    
    public int getFile_id() {
        return file_id;
    }
    
    public abstract List<? extends AbstractFileDescriptor> getFiles();
    
    public abstract AbstractFileDescriptor getParent();
    
    public abstract boolean isRoot();
    
    public short getPublicAccessiblity() {
        return public_accessiblity;
    }
    
}
