/*
 * SizeFormatter.java
 *
 * Created on 07 October 2007, 14:59
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package common;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;

/**
 *
 * @author A
 */
public class Toolkit {
    
    private static String myOuterIP = null;
    private static String myLocalIP = null;
  
    
    /** returns the local IP address, or null if cannot be determinated */
    
    public static String getLocalIP() {
        if (myLocalIP != null) return myLocalIP;
        try {
            myLocalIP = InetAddress.getLocalHost().getHostAddress();
            return myLocalIP;
        } catch (UnknownHostException ex) {
            ex.printStackTrace();
            return null;
        }
    }
    
    /**
     *Returns the outer IP address, or null if cannot be determinated.
     */
    public static String getOuterIP() {
        if (myOuterIP != null) return myOuterIP;
        try {
            URL ipServer = new URL("http://www.whatismyip.org/");
            
            InputStreamReader is = new InputStreamReader(ipServer.openStream());
            int buf;
            StringBuilder outerIp = new StringBuilder(20);
            
            while ((buf = is.read()) != -1) {
                outerIp.append((char)buf);
            }
            is.close();
            myOuterIP = outerIp.toString().trim();
            return myOuterIP;
            
        } catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
    
    public static boolean isMyIPPublic() throws IOException  {
        InetAddress localIP = InetAddress.getLocalHost();
        URL ipServer = new URL("http://www.whatismyip.org/");
        
        InputStreamReader is = new InputStreamReader(ipServer.openStream());
        int buf;
        StringBuilder outerIp = new StringBuilder(20);
        
        while ((buf = is.read()) != -1) {
            outerIp.append((char)buf);
        }
        is.close();
        return outerIp.toString().trim().equals(localIP.getHostAddress().trim());
    }
    
//    public static boolean testPort(int port) {
//        String outerIP = getOuterIP();
//        if (outerIP != null) {
//        Socket s = null;
//            try {
//                SocketFactory.getDefault().createSocket(InetAddress.getByName(outerIP),port);
//
//            } catch (UnknownHostException ex) {
//                ex.printStackTrace();
//            } catch (IOException ex) {
//                ex.printStackTrace();
//            }
//
//        return false;
//        }
//
//    }
    
    public static String formatSize(long bytes) {
        NumberFormat f = NumberFormat.getInstance();
        if (bytes > 1024) {
            if (bytes > 1024*1024) {
                return f.format((double)bytes / (1024 * 1024)) + " MB";
            } else {
                return f.format((double)bytes / 1024) + " KB";
            }
        } else {
            return bytes + " B";
        }
    }
    
    public static void executeSQLFromFile(String filename,Connection con) throws IOException, SQLException {
        StringBuffer sqlString = new StringBuffer(150);
        File file = new File(filename);
        FileReader fr;
        Statement statement = con.createStatement();
        
        fr = new FileReader(file);
        int buf;
        
        while ((buf = fr.read()) != -1) {
            switch (buf) {
                case ';' :  statement.executeUpdate(sqlString.toString());
                sqlString = new StringBuffer(150);
                break;
                default : sqlString.append((char)buf);
            }
        }
    }
    
}
