package common.commun;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Socket;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TrafficHandler {

    private HashMap<String, ConnectionHandler> handlers = new HashMap<String, ConnectionHandler>();
    private DocumentBuilder docBuilder;

    public TrafficHandler() throws ParserConfigurationException {
        docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    /** Connection messages are very short so the transfer of them can be made on same thread.*/
    public synchronized void processConnection(Socket s) throws NoHandlerForConnectionTypeException {
        try {
            InputStream is = s.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String connectionMsg = br.readLine();

            Document doc = docBuilder.parse(new InputSource(new StringReader(connectionMsg)));
            Element root = doc.getDocumentElement();
            String type = root.getAttribute("type");

            ConnectionHandler handler = handlers.get(type);
            if (handler != null) {
                handler.processConnection(new ConnectionData(doc, s.getOutputStream(), is, s));
            } else {
                throw new NoHandlerForConnectionTypeException(type);
            }
        } catch (SAXException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    
    public synchronized void processConnection(Socket s, OutputStream os, InputStream is, String msg) throws NoHandlerForConnectionTypeException {
        try {
            Document doc = docBuilder.parse(new InputSource(new StringReader(msg)));
            Element root = doc.getDocumentElement();
            String type = root.getAttribute("type");

            ConnectionHandler handler = handlers.get(type);
            if (handler != null) {
                handler.processConnection(new ConnectionData(doc, os, is, s));
            } else {
                throw new NoHandlerForConnectionTypeException(type);
            }
        } catch (SAXException ex) {
            ex.printStackTrace();
            Logger.getLogger(TrafficHandler.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(TrafficHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void registerConnectionHandler(ConnectionHandler h) {
        String[] types = h.getTypesToHandle();
        for (String s : types) {
            handlers.put(s, h);
        }
    }
}

