/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package server.gui;

import bridge.BridgeEvent;
import bridge.BridgeListener;
import bridge.RoadDescriptor;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author Ati
 */
public class BridgeTableModel extends AbstractTableModel implements BridgeListener {
    private ArrayList<RoadDescriptor> data = new ArrayList<RoadDescriptor>();
    private String[] colNames = new String[]{"IP Address 1","IP Address 2","Transfer amount"};
    
    public int getRowCount() {
        return data.size();
    }

    @Override
    public String getColumnName(int column) {
        return colNames[column];
    }

    
    public int getColumnCount() {
        return colNames.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        RoadDescriptor rd = data.get(rowIndex);
        switch (columnIndex) {
            case 0 : return rd.getIP1();
            case 1 : return rd.getIP2();
            case 2 : return rd.getTranseferedAmout();
        }
        return null;
    }
    
    public void roadCreated(BridgeEvent evt) {
        data.add(evt.getRoadDescriptor());
        fireTableDataChanged();
    }

    public void roadDestroyed(BridgeEvent evt) {
        data.remove(evt.getRoadDescriptor());
        fireTableDataChanged();
    }

}
