#define MAX 51
#define K 4
#define BITSETMAX 150
#define MIN(X,Y) ((X) < (Y) ? (X) : (Y))

#include <cstdlib>
#include <iostream>
#include <vector>
#include <bitset>
#include <set>
#include <iostream>
#include <fstream>
#include <string>
#include <time.h>
#include <math.h>

using namespace std;

struct ltstr
{
  bool operator()(const bitset<BITSETMAX> &s1, const bitset<BITSETMAX> &s2) const
  {
    return ( s1.to_string<char,char_traits<char>,allocator<char> >().compare(s2.to_string<char,char_traits<char>,allocator<char> >()) < 0);
  }
};    

    long vertex_count;
    unsigned long long circuit_count;
	unsigned long long edge_count;        
	string graph_count;
	int edges[MAX][K];
    set< bitset<BITSETMAX>, ltstr > circuit;
    vector <unsigned long long> circuit_for_edge[BITSETMAX];
    vector <bitset<BITSETMAX> > list_all_circuits;
    ifstream input;
    ofstream output, output2;
    
    int visited[MAX];  
    int vmin[MAX];      
    unsigned long long navstivenych;
    int articulation;
    bool to_file = false;
    
    
    int before[MAX];
    int c_vertex[MAX];
    int d_vertex[MAX];     
    int after[MAX];





void export_to_graph_viz(bitset<BITSETMAX> c, bitset<BITSETMAX> d, unsigned long long edge_without_semi){

         output2 << "graph G {" << endl;
         for (int i = 1;i <= vertex_count; i++){
             for (int ii = 1;ii <= (K-1); ii++){
              if (i <= edges[i][ii]){
                     output2 << "   " << i << " -- " << edges[i][ii];                  
                     if (c[(i-1)*(K-1)+ii] == true){
                       output2 << " [style=\"setlinewidth(4)\", ";
                       if ( ((i-1)*(K-1)+ii)==edge_without_semi){
                          output2 << "color =red ] ";
                       }else output2 << "color =blue ] ";      
                     }
                     output2 << ";"<< endl;
                     
                     if ( (d[(i-1)*(K-1)+ii] == true)&&( ((i-1)*(K-1)+ii)!=edge_without_semi) ){
                       output2 << "   " << i << " -- " << edges[i][ii];                    
                       output2 << " [style=\"setlinewidth(4)\", " << "color =yellow ]; " << endl;
              
                     }
                     
              }
              
            }
         }
         output2 << "}" << endl;     
}







void export_to_graph_viz(bitset<BITSETMAX> c, unsigned long long edge_without_semi){
     if (!to_file){
         cout << "---------------------------" <<endl;
         cout << "graph G {" << endl;
         for (int i = 1;i <= vertex_count; i++){
           for (int ii = 1;ii <= (K-1); ii++){
              if (i <= edges[i][ii]){
                     cout << "   " << i << " -- " << edges[i][ii]  ;                  
                     if (c[(i-1)*(K-1)+ii] == true){
                       cout << " [style=\"setlinewidth(4)\", ";
                       if ( ((i-1)*(K-1)+ii)==edge_without_semi){
                          cout << "color =red ] ";
                       }else cout << "color =blue ] ";      
                     }
                     cout << "; "<< endl;
              }
              
           }   
         }
         cout << "}" << endl;
         cout << "---------------------------" <<endl; 
     }else{
         output << "---------------------------" <<endl;
         output << "graph G {" << endl;
         for (int i = 1;i <= vertex_count; i++){
             for (int ii = 1;ii <= (K-1); ii++){
              if (i <= edges[i][ii]){
                     output << "   " << i << " -- " << edges[i][ii]  ;                  
                     if (c[(i-1)*(K-1)+ii] == true){
                       output << " [style=\"setlinewidth(4)\", ";
                       if ( ((i-1)*(K-1)+ii)==edge_without_semi){
                          output << "color =red ] ";
                       }else output << "color =blue ] ";      
                     }
                  //   output <<" ; "<< endl;
              }
              
            }
         }
         output << "}" << endl;
         output << "---------------------------" <<endl;   
     }
}


void print_graph(){
     if (!to_file){
         cout << "---------------------------" <<endl;
         for (int i = 1;i <= vertex_count; i++){
              cout << i << ": " << edges[i][1] << " " << edges[i][2] << " " << edges[i][3] << endl;              
         }
         cout << "---------------------------" <<endl; 
     }else{
         output << "---------------------------" <<endl;
         for (int i = 1;i <= vertex_count; i++){
              output << i << ": " << edges[i][1] << " " << edges[i][2] << " " << edges[i][3] << endl;              
         }
         output << "---------------------------" <<endl;   
     }
}
    
int add_edge(int x, int y){

    if ( (x > vertex_count)||(y > vertex_count) ) return 1;               //vertex out of range
    if ( (edges[x][0] >= (K-1))  ) return 2;   //vertex out of range
    //cout << "add : " << edges[x][0] << endl;
    edges[x][++edges[x][0]] = y;
    //cout << "add : " << edges[x][edges[x][0]] << endl;    
    edge_count++;
    return 0;
}

int open_file(string name){
     if (name.compare("")!=0){
			 char meno[100];
			 strcpy(meno,name.c_str());
			 //cout << meno << "rr"<< endl;
            input.open(meno);
            if (!input) {
               cout << "Unable to open" << endl;
			   return 1; //error no file name      
            }            
         }else{
            return 1; //error no file name      
         }    
            return 0;     
}

int close_file(void){
            input.close();         
			return 0;
};

int load_graph_genreg(void){
    string s ="",s2="";
    int x,y,i,j;
    bool debug = false;
    
    debug = false;
    
    for (i = 1; i <= vertex_count;i++) edges[i][0] = 0;
    
    do{
        getline(input,s);    
        if (debug) cout << s << endl;
    }while( (s.find("Graph",0) == string::npos)&&(input.good()));
    if (input.fail()){
      if (debug)  cout<<"uz nie je dalsi graph"<<endl;
      return 1;
    }
    if (s.find(" ",0) != string::npos) graph_count = s.substr(s.find(" ",0)+1);   
    if (debug) cout << s << endl;
    
    if (!getline(input,s)){cout <<  "bad2" << endl; return 2;} //no another graph
    if (debug) cout << s << endl;
    for (j=0; j < vertex_count; j++){
        input >> x;
        getline(input,s,':');
        if (debug) cout << x << ": ";
        for (i = 1; i < K; i++){
            input >> y;
            add_edge(x,y);
            if (debug) cout << y << " ";
        } 
        if (debug) cout << endl;
    }
    if (debug) cout << "Lala" << endl;    
    do{
        getline(input,s);
        if (debug) cout << s << endl;            
     }while( (s.find("Ordnung",0) == string::npos)&&(input.good()));
     getline(input,s);
    return 0;    
}

int load_graph_snark(void){
    string s ="",s2="";
    int x,y,i,j;
    bool debug = false;
    
    debug = false;
    
    for (i = 1; i <= vertex_count;i++) edges[i][0] = 0;
    graph_count = "";
    input >> graph_count;
    if (input.fail()){
      if (debug)  cout<<"uz nie je dalsi graph"<<endl;
      return 1;
    }
    
    for (j=1; j < K; j++){
        for (i = 1; i <= vertex_count; i++){
            input >> x;
            add_edge(i,x);
 //           cout << x << " ";
        } 
 //       cout << endl;
    }
 //cout << "Lala" << endl;    
    
//    print_graph();
    return 0;    
}



bool connected(const bitset<BITSETMAX> &x){
    vector<int> stack;  
    bool visited[vertex_count + 1];  
    unsigned long long navstivenych;
    int i, actual;
    
    for (i = 1; i<= vertex_count;i++){ 
        visited[i] = false;
    }
    if (x.none()){
//       cout << "kruznica x je prazdna" << endl; 
       return false;              
    }
    navstivenych = 1;
    i = 1;
    while (!x[i]){
          i++;      
    }    
    actual = ( i / (K-1) )+1;
    navstivenych = 1;
    visited[actual] = true;
    
    stack.push_back(actual);
   // cout << "Prechod grafom: " << endl;
    while (!stack.empty()){
        actual = stack.back();
    //    cout << actual<< " ";
        stack.pop_back();
        for (int j = 1; j < K; j++){
            if ( (x[(actual-1) * (K-1) + j] )&&(!visited[ edges[actual][j]]) ){
                stack.push_back(edges[actual][j]);
                visited[edges[actual][j]] = true;
                navstivenych++;            
            }
        }
    }         
    if (x.count() == (navstivenych*2)) return true;             
    else{
//         cout << "X nie je suvisla kruznica " << x.to_string<char,char_traits<char>,allocator<char> >() << endl;
         return false;
    }
}

int generete_circuits(void){
    vector<int> stack;
    int actual,i, j;
    unsigned long long   base_circuit_count ;
    bool visited[vertex_count + 1];
    bitset<BITSETMAX> cesta[vertex_count+1];
    set< bitset<BITSETMAX>, ltstr > base;
    bitset<BITSETMAX> bv;
    bool debug = false;
    
    for (i = 1; i<= vertex_count;i++){ 
        visited[i] = false;
    }
    cesta[1].reset();
    
    visited[1] = true;
    stack.push_back(1);
   // cout << "Prechod grafom: " <<endl;
    while (!stack.empty()){
        actual = stack.back();
   //     cout << actual<< " ";
        stack.pop_back();
        for (int j = 1; j < K; j++){
            if (!visited[edges[actual][j]]){
                stack.push_back(edges[actual][j]);
                visited[edges[actual][j]] = true;
                cesta[edges[actual][j]] = cesta[actual];
                cesta[edges[actual][j]][(actual-1)*3+j] = true;              // add edge
                //cout << "--" << edges[actual][j] << "  " << (actual-1)*3+j << endl;
                for (int k = 1 ; k < K; k++)                                 // add invert edge
                  if (actual == edges[ edges[actual][j] ][k]) {
                    cesta[edges[actual][j]][(edges[actual][j]-1)*3+k] = true;                
                 //   cout << "++" << edges[actual][j] << " " << (edges[actual][j]-1)*3+k << endl;
                  }
                
            }else if (  (actual <= edges[actual][j]) && (cesta[actual][(actual-1)*3+j] == false) ){                                                           // you find circuit, add it to set
                  bv.reset();
                  bv[(actual-1)*3+j] = true;              // add edge
                for (int k = 1 ; k < K; k++){                                // add invert edge
                  if (actual == edges[ edges[actual][j] ][k]){ 
                      bv[(edges[actual][j]-1)*3+k] = true;   
    /*                  cout << "kruznica: "<< actual <<" "<< edges[actual][j]<< " " << endl;
                      cout << "  cesta1: "  << cesta[actual].to_string<char,char_traits<char>,allocator<char> >() << endl;
                      cout << "  cesta2: "  << cesta[edges[actual][j]].to_string<char,char_traits<char>,allocator<char> >() << endl;                  
                      cout << "  hrana : "  << bv.to_string<char,char_traits<char>,allocator<char> >() << endl;
    */
                      bv = bv^cesta[actual]^cesta[edges[actual][j]];
                      base.insert(bv);
                      //cout << bv.to_string<char,char_traits<char>,allocator<char> >() << endl;
                  }
                }
            }
        }
    }
    
   set< bitset<BITSETMAX>, ltstr > ::iterator it;
    
   if (debug){
      cout << endl <<  "myset contains:" << endl;
    
      for ( it=base.begin() ; it != base.end(); it++ ){
         cout << " " << (*it).to_string<char,char_traits<char>,allocator<char> >() << endl;
      }
   }
    
  unsigned long long podmnozin = 1;
  if (base.size() > 63) cout << "!!!!!!!!!! Err. vela podmnozin !!!!!!";
  podmnozin <<= base.size();
  if (debug) cout << base.size() << "roznych podmnozim: "<< podmnozin << endl;
  for ( unsigned long long i = 1; i < podmnozin; i++){
      bitset<BITSETMAX> iter (i);
      bitset<BITSETMAX> x;
      x.reset();
      j=0;
//      cout << "== " << i << " " << iter.to_string<char,char_traits<char>,allocator<char> >() << endl;
      for ( it=base.begin() ; it != base.end(); it++ ){
          
          if (base.size() > j) {
//             cout << "* " << j << " " << !!iter[j] << endl;                              
             if (!!iter[j] == true){ 
                x = x ^ (*it);
//                cout <<"    " << (*it).to_string<char,char_traits<char>,allocator<char> >() << endl;
             }
          }
          j++;
 //         cout << j-1 << " ";
      }

                                       //  !!! okontroluj ci x je suvisle!!!!

      if (connected(x)){
            circuit.insert(x);             // nahadzeme to do setu, tym odstranime duplicitne kruznice
      }
      
      
  }
  if (debug) cout << " vygenerovane" << endl;
  int velkost_vectora = 0;
  for ( it=circuit.begin() ; it != circuit.end(); it++ ){           // zo setu to prehodime do vectora, kvoli vytvaraniu
                                                                    // odkazov v circuit_for_edge a rychlejsi pristup      
      list_all_circuits.push_back((*it));
      velkost_vectora =  list_all_circuits.size();
      if ( ((velkost_vectora % 50) == 0 ) &&(debug)) cout << velkost_vectora << endl;
      for (j = 1; j < (*it).size(); j++){
           if ((*it)[j] == true) circuit_for_edge[j].push_back(velkost_vectora-1);   //vlozime odkaz na danu kruznicu                
      }            
  }
/*
  cout << endl <<  "Circuits:" << endl;
  vector <bitset<BITSETMAX> >::iterator it2;
  for ( it2=list_all_circuits.begin() ; it2 != list_all_circuits.end(); it2++ )
    cout << " " << (*it2).to_string<char,char_traits<char>,allocator<char> >() << endl;
*/    
}


bool is_semiextension_2(const bitset<BITSETMAX> &v){
     int i,j,actual;
     vector<int> stack;  
     bool visited[vertex_count + 1];  
     bool ear_end[vertex_count + 1];     
     bool sim_dif[vertex_count + 1];     
     unsigned long long navstivenych;
     
     
//     cout << "lala"<<endl;
    
     for(i = 1; i < vertex_count;i++){
       if (c_vertex[i] > d_vertex[i]){
//          cout << i << " - " ;
  
    
            for (j = 1; j<= vertex_count;j++){ 
                visited[j] = false;
                ear_end[j] = false;
                sim_dif[j] = false;                
            }
                        
            stack.push_back(i);
            visited[i]=true;
            ear_end[i]=true;            
          //  cout << "Prechod grafom: " << endl;
            while (!stack.empty()){                                             // najdi vsetky i-usi nazvyme mnoz konc vrch A
                actual = stack.back();
            //    cout << actual<< " ";
                stack.pop_back();
                for (int j = 1; j < K; j++){
                    if (!visited[ edges[actual][j]]){
                     if ( (c_vertex[ edges[actual][j] ] == 1) || ( d_vertex[edges[actual][j]] == 1) ){
                        ear_end[edges[actual][j] ] = true;
                        visited[edges[actual][j]] = true;                        
                     }else{
                        stack.push_back(edges[actual][j]);
                        visited[edges[actual][j]] = true;
                     }
                    }
                }
            }
            
          //  cout << endl;
            
            stack.push_back(i);
            visited[i]=true;
            sim_dif[i]=true;
           // cout << "Prechod grafom: " << endl;
            while (!stack.empty()){                                             // urob prehladavanie do hlbky v sim dif.  B
                actual = stack.back();
            //    cout << actual<< " ";
                stack.pop_back();
                for (int j = 1; j < K; j++){
                    if ( (!visited[ edges[actual][j]])&&(v[(actual-1) * (K-1) + j] ) ){
                        stack.push_back(edges[actual][j]);
                        visited[edges[actual][j]] = true;
                        sim_dif[edges[actual][j]] = true;
                    }
                }
            }

            for (i=j; j <= vertex_count; j++){
                if ( (ear_end[j]) && (!sim_dif[j]) ){                        
                   return false;     
                }
            }

                
       }
     }     
     
     return true;
}


bool is_semiextension( const bitset<BITSETMAX> &C, const bitset<BITSETMAX> &D, bool detail = false){
     bitset<BITSETMAX> v;
     int i;
     bool rozne = false;
     
     
     for (i=1;i <= vertex_count; i++){                                            //inizializacia
         before[i] = 0;    
         after[i] = 0;
         c_vertex[i] = 0;
         d_vertex[i] = 0;         
     }
     
// cout << " Before: ";

     for (int i =1; i <= edge_count; i++){
         if (D[i] > C[i]) rozne = true;                                           //zistijeme, ci existuje hrana v D, ktora nepatri C
         if ((C[i])||(D[i])){
              before[ ( (i-1) / (K-1) )+1 ] = 1;
//              cout << ( (i-1) / (K-1) )+1 << " ";
              before[ edges[( (i-1) / (K-1) )+1][ (i-1)%(K-1)+1 ] ] = 1;          
//              cout << edges[( (i-1) / (K-1) )+1][ (i-1)%(K-1)+1 ] << " ";
         }     
         if (C[i] == true){
              c_vertex[ ( (i-1) / (K-1) )+1 ] = 1;
//              cout << ( (i-1) / (K-1) )+1 << " ";
              c_vertex[ edges[( (i-1) / (K-1) )+1][ (i-1)%(K-1)+1 ] ] = 1; 
//              cout << edges[( (i-1) / (K-1) )+1][ (i-1)%(K-1)+1 ] << " ";
         }     
         if (D[i] == true){
              d_vertex[ ( (i-1) / (K-1) )+1 ] = 1;
              d_vertex[ edges[( (i-1) / (K-1) )+1][ (i-1)%(K-1)+1 ] ] = 1;
         } 
             
     }
     if (!rozne){ return false;}                                                   //D nemoze byt semiex,kvoli,tomu,ze neobsahuje hranu,ktora nepatri do C

//     cout << endl;
     rozne = false;
     for ( i = 1; i <= vertex_count; i++ ){
//         cout << i <<"- ";
         if ( d_vertex[i] < c_vertex[i] ){ rozne = true; break;}                 // C obsahuje vchol i ale D ho neobsahuje
     }

     if (!rozne){
//          cout << "rovnake" << endl;          
          return true;                                                           // lebo neexisuje vrchol V v C, taky,ze V nepatri do D
     }
     
     v = C ^ D;                                                                  //zisti ci je "v" suvisle vzhladom na vrcholy C a D
     for (int i =1; i <= edge_count; i++){
         if (v[i]){
              after[ ( (i-1) / (K-1) )+1 ] = 1;
              after[ edges[( (i-1) / (K-1) )+1][ (i-1)%(K-1)+1 ] ] = 1;          
         }         
     }
//     cout << C.to_string<char,char_traits<char>,allocator<char> >() << endl;
//     cout << D.to_string<char,char_traits<char>,allocator<char> >() << endl;

     rozne = false;
     for ( i = 1; i <= vertex_count; i++ ){
//         cout << i <<"- ";
         if ( before[i] != after[i] ){ rozne = true; break;}
     }
     if ( (rozne == false)&&(connected(v)) )                                     // ak C u D  a C sim.dif D su na tych istych vrcholoch    
          return true;     
     else {      
          if (detail){                                                                // skontroluj detailne                           
             return is_semiextension_2(v);
          }else{ 
             return false;
          }
     }
}

bool check_semiextensions(void){
unsigned long long i,j;
      vector <bitset<BITSETMAX> >::iterator it;
      vector <unsigned long long>::iterator it2;      
      vector <unsigned long long>::iterator it3;   
      bool found_semi;
      char buff[256];
      long counter = 0;
             
//cout << "checkujem" << list_all_circuits.size()<<endl;
  for ( it=list_all_circuits.begin() ; it < list_all_circuits.end(); it++ ){     //vyberieme kruznicu C
      for (j = 1; j < (*it).size(); j++){
           


        if ( ((*it)[j] == true) &&( ( ( (j-1) / (K-1) )+1 ) <=   edges[( (j-1) / (K-1) )+1][ (j-1)%(K-1)+1 ] ) ){                                                       // vyberieme hranu
          found_semi = false; 
         //  cout << "+++++++++ Hladam semiex pre hranu : " << j << " v " << circuit_for_edge[j].size()<< endl;
          for ( it2=circuit_for_edge[j].begin() ; (it2 < circuit_for_edge[j].end())&&(!found_semi); it2++ ){    //vyberieme kruznicu D
              found_semi = is_semiextension((*it), list_all_circuits[(*it2)],true);      //zistime,ci D je semiextensions C                            }
        //      cout << "found_semi"<<endl;
          }
    /*      if (!found_semi){
            int ii = 0;
            for ( it3=circuit_for_edge[j].begin() ; (it3 < circuit_for_edge[j].end())&&(!found_semi); it3++ ){    //vyberieme kruznicu D
              ii++;
                found_semi = is_semiextension((*it), list_all_circuits[(*it3)],true);      //zistime,ci D je semiextensions C                  
            }               
          }              
      */    if (!found_semi){                               
            if (!to_file){
             cout <<  "!!!!!!!!!!!Pre kruznicu A a hranu e  NEEXISTUJE semiextensions" << endl;
             cout << " Hrana: " << j <<endl;
             cout << " C: " << (*it).to_string<char,char_traits<char>,allocator<char> >() << endl;
            }else{
             output <<  "!!!!!!!!!!!Pre kruznicu A a hranu e  NEEXISTUJE semiextensions" << endl;
             output << " Hrana: " << j <<endl;
             output << " C: " << (*it).to_string<char,char_traits<char>,allocator<char> >() << endl;     
            }
             cout << "Kruznic prechadzajucich hranou " << j << " je: " << circuit_for_edge[j].size() << endl;
             print_graph();
             export_to_graph_viz((*it),j);
             
/*
             for ( it2=circuit_for_edge[j].begin() ; (it2 < circuit_for_edge[j].end()); it2++ ){    //vyberieme kruznicu D
                 counter++;
                 snprintf(buff,256,"graph_picture\\kruznica%ld.dot", counter);
                 output2.open(buff);
                 export_to_graph_viz((*it),list_all_circuits[(*it2)],j);
                 output2.close();
             }
 */         
             return false;
             
          }
        }
      } 
  }
//  cout << list_all_circuits[1] << endl;
   if (!to_file)  cout << "Domnienka pre graf c. "<< graph_count <<" plati. " <<endl;
   else output << "Domnienka pre graf c. "<< graph_count <<" plati. " <<endl;
    return true;    
}

int visit(int x, int parent){
    int min,children;
    bool is_arti;
    navstivenych++;
    visited[x] = navstivenych;
    vmin[x] = navstivenych;   
    min = navstivenych; 
    is_arti = false;
    children = 0;
//    cout << x << " ";
    for (int j = 1; j < K; j++){
        if (visited[ edges[x][j]] == 0){
           children++;
           if ( (children > 1) && (x == parent) ){ is_arti = true; cout << "koren" << endl;}    //koren
           visit( edges[x][j], x );   
           vmin[x] = MIN( vmin[x], vmin[edges[x][j]] );
          // cout << endl << x<< " " << edges[x][j] << " vmin: " << vmin[edges[x][j]] << " order:  " <<  visited[x];
           if ( (vmin[edges[x][j]] >= visited[x])&&(x != parent)) is_arti = true;             //ci je koren artik sa riesi trosku inak vid hore
        }else{
           if (edges[x][j] != parent)
              vmin[x] = MIN(vmin[x],visited[edges[x][j]]);              
        }
        if (is_arti){
           if (articulation == 0){ 
             if (!to_file) cout << "Graf "<< graph_count<<" ma  artikulaciu :" << x << endl;
             else output << "Graf "<< graph_count<<" ma  artikulaciu :" << x << endl;             
           }
           articulation = x;
        }
    }
    return 0;
}
bool two_connected(){
          
    vector<int> stack;  
    
    int i, actual;
    
    for (i = 1; i<= vertex_count;i++){ 
        visited[i] = 0;
        vmin[i] = 0;
    }
    navstivenych = 0;
    articulation = 0;
    visit(1,1);    
    if (articulation == 0) return true;
    else return false;
}

int main(int argc, char *argv[])
{
    unsigned long long counter;
    unsigned long long ok, nok,n2connected;
    unsigned long long start,end;
    unsigned long long parts_number,  number_of_graphs, part_begin, part_end;
    int part_number_of_file;
    char buff[256];

    start = clock();
    parts_number = 1;
    number_of_graphs = 28400;
    vertex_count = 20;
//    open_file("20_3_3.asc");
    open_file("./vstupy/s20_c4.c");
    if (argc == 2){
       part_number_of_file = atoi(argv[1]);
       if (part_number_of_file ==0) part_number_of_file = 1;
       if (part_number_of_file > parts_number) part_number_of_file = 1;
    }else{
       part_number_of_file = 1;   
    }

    part_begin = (part_number_of_file - 1)*(number_of_graphs / parts_number);
    if (part_number_of_file < parts_number) part_end = (part_number_of_file)*(number_of_graphs / parts_number);    
    else part_end = number_of_graphs + 10;
   cout << "Subor " << part_number_of_file << ". / " << parts_number << endl;
    snprintf(buff,256,"%ldpart%d.txt", vertex_count, part_number_of_file);
 //   cout << buff << endl;
    if (to_file) output.open(buff);
    
    edge_count = 0;
    //graph_count = 0;
    circuit.clear();
    for (int i =0; i < BITSETMAX; i++) circuit_for_edge[i].clear();
    list_all_circuits.clear();
    counter=0;
    ok = 0;
    nok = 0;
    n2connected = 0;
    while (load_graph_snark()== 0){
          counter++;
      //  cout << "Graph "<< graph_count  << endl;
        //  print_graph();
          if ((counter > part_begin)&&(counter <= part_end)){
              if (two_connected()){
               //cout << "ide generovanie kruznic: " << endl;
                  generete_circuits();                         
                 // cout << "------------------------------Kontrola------------" << endl;
                  if (check_semiextensions()) ok++;
                  else nok++;
              }else { n2connected++;}
          }
          edge_count = 0;
          circuit.clear();
          for (int i =0; i < BITSETMAX; i++) circuit_for_edge[i].clear();
          list_all_circuits.clear();

    }
    
    
    close_file();
    end = clock();
    if (!to_file){
        cout << endl << "----------------------Zhodnotenie-------------------" << endl;
        cout << "!!! Pocet grafov pre ktore tvrdenie NEPLATI:  " << nok << endl << endl;
        cout << "Pocet grafov pre ktore tvrdenie plati:  " << ok + n2connected << endl;
        cout << "Pocet grafov, ktore nie su dvojsuvisle: " << n2connected << endl;    
        cout << "Pocet vsetkych grafov: " << counter << endl;
        cout << "Pocet vrcholov jedneho grafu: " << vertex_count << endl;
        cout << "Cas:  ";
        cout << ((end - start)) / CLOCKS_PER_SEC / 3600 << " hod.   "; 
        cout << (((end - start)) / CLOCKS_PER_SEC / 60)%60 << " min.   ";
        cout << fmod( (double)(end - start) / CLOCKS_PER_SEC, 60 ) << " s." << endl; 
    }else{
        output << endl << "----------------------Zhodnotenie-------------------" << endl;
        output << "!!! Pocet grafov pre ktore tvrdenie NEPLATI:  " << nok << endl << endl;
        output << "Pocet grafov pre ktore tvrdenie plati:  " << ok + n2connected << endl;
        output << "Pocet grafov, ktore nie su dvojsuvisle: " << n2connected << endl;    
        output << "Pocet vsetkych grafov: " << counter << endl;
        output << "Pocet vrcholov jedneho grafu: " << vertex_count << endl;
        output << "Cas:  ";
        output << ((end - start)) / CLOCKS_PER_SEC / 3600 << " hod.   "; 
        output << (((end - start)) / CLOCKS_PER_SEC / 60)%60 << " min.   ";
        output << fmod( (double)(end - start) / CLOCKS_PER_SEC, 60 ) << " s." << endl;    
    }
    if (to_file) output.close();
    if (!to_file) system("PAUSE");
    return EXIT_SUCCESS;
}
