#!/bin/sh
echo "APT::Install-Recommends \"false\";" >> /etc/apt/apt.conf
apt-get -y install selinux-policy-default
apt-get -y install openssh-server 

#setup integrity checks
#beware, aide on debian has lotads of wrapper scripts.
apt-get -y install aide
aide --init
cp /var/lib/aide/aide.db.new /var/lib/aide/aide.db

#setup automatic security updates
cp /tmp/postinst/security_sources.list /etc/apt/security_sources.list

#cron apt will attempt dist-update every 4 o'clock
apt-get -y install cron-apt

#we force it to use only security sources
  echo OPTIONS="-o quiet=1 -o Dir::Etc::SourceList=/etc/apt/security_sources.list -o Dir::Etc::SourceParts=\"/dev/null\"" >> /etc/cron-apt/config

#setup firewall
  cp /tmp/postinst/firewall /etc/init.d/firewall
  chmod 700 /etc/init.d/firewall
  update-rc.d firewall defaults

#setup syslog
echo "*.* @@syslog.infrastructure.local" >> /etc/rsyslog.conf

#setup bind in chroot
apt-get -y install bind9


#setup a jail environment
mkdir -p /var/lib/named/etc
mkdir /var/lib/named/dev
mkdir -p /var/lib/named/var/cache/bind
mkdir -p /var/lib/named/var/run/bind/run
mv /etc/bind /var/lib/named/etc
ln -s /var/lib/named/etc/bind /etc/bind
mknod /var/lib/named/dev/null c 1 3
mknod /var/lib/named/dev/random c 1 8
chmod 666 /var/lib/named/dev/*
chown -R bind:bind /var/lib/named/var/*
chown -R bind:bind /var/lib/named/etc/bind

#set a jail option
sed -e s/"-u bind"/"\-u bind \-t \/var\/lib\/named"/g /etc/default/bind9 > /tmp/bind9
mv /tmp/bind9 /etc/default/bind9 

mkdir /etc/bind/zones
mv /tmp/postinst/infrastructure.local /etc/bind/zones/
mv /tmp/postinst/reverse.infrastructure.local /etc/bind/zones/
mv /tmp/postinst/named.conf.local /etc/bind/
mv /tmp/postinst/named.conf.options /etc/bind/
