import numpy as np
import pickle
from matplotlib import pyplot as plt

highest, board_sums = [], []
with open('scores.pkl', 'rb') as f:
            highest, board_sums = pickle.load(f)
            smoothness = 2000
            print("games:", len(board_sums))
            smooth_sums = []
            s = np.sum(board_sums[:smoothness])
            smooth_sums.append(s / smoothness)
            for i in range(smoothness, len(board_sums)):
                s -= board_sums[i-smoothness]
                s += board_sums[i]
                smooth_sums.append( s / smoothness)

            plt.plot(smooth_sums)
            plt.savefig("smooth_graph.png")
            plt.show()
