"""(original) source: https://github.com/mckeown12/2048-DQN-in-python/blob/master/py2048.py """
import numpy as np

class GameBoard:

    def __init__(self, height=4, width=4):
        self.height = height
        self.width = width
        self.board = np.zeros(shape=(height, width), dtype='int8')
        self.left = 0
        self.up = 1
        self.right = 2
        self.down = 3
        self.done = False
        self.got2048 = False
        self.score = 0
        self.logscore = 0
        self.last_reward = 0
        self.last_merged = 0
        self.newTile()
        self.newTile()

    def empties(self):
        "count the number of empty tiles on the board"
        empties = []
        for x in range(self.height):
            for y in range(self.width):
                if self.board[x][y] == 0:
                    empties.append((x, y))
        return empties

    def newTile(self):
        "spawn a new tile if there is an empty place"
        emptySpots = self.empties()

        if len(emptySpots) == 0:
            self.done = True
            return
        randomSpot = emptySpots[np.random.choice(len(emptySpots), 1)[0]]
        self.board[randomSpot[0]][randomSpot[1]] = 1
        # there is a 10% chance that the new tile will be a 4 instead of a 2.
        if np.random.choice(10, 1) == 1:
            self.board[randomSpot[0]][randomSpot[1]] = 2

    def step(self, action):
        "perform one step of the game - slide all tiles in chosen direction and spawn a new tile"
        tempBoard = self.board
        tempBoard = np.rot90(tempBoard, action)
        tempBoard = self.leftSlide(tempBoard)
        self.board = np.rot90(tempBoard, -action)
        self.newTile()
        return self.board, 1 if self.got2048 else (self.last_merged-1)/8, self.done

    def leftSlide(self, board):
        "perform a left slide, merge pairs of tiles of equal values"
        height = len(board)
        width = len(board[0])
        newboard = []
        self.last_reward = 0
        self.last_merged = 0
        for y in range(height):
            newrow = []
            prev = 0
            for x in board[y]:
                if x == prev and x != 0:
                    newrow = newrow[:-1]
                    newrow.append(x+1)
                    self.last_reward += x+1
                    self.score += 2**int(x+1)
                    self.logscore += int(x+1)
                    if x+1 == 11:
                        self.done = True
                        self.got2048 = True
                    self.last_merged += 1
                    prev = 0
                elif x != 0:
                    newrow.append(x)
                    prev = x
                else:
                    continue
            newrow.extend([0 for i in range(width-len(newrow))])
            newboard.append(newrow)
        return np.array(newboard)

    def reset(self):
        self.board = np.zeros(shape=(self.height, self.width))
        self.left = 0
        self.up = 1
        self.right = 2
        self.down = 3
        self.done = False
        self.got2048 = False
        self.score = 0
        self.logscore = 0
        self.last_merged = 0
        self.newTile()
        self.newTile()

    def exponentiate(self):
        board = 2**self.board
        for i in range(self.height):
            for j in range(self.width):
                if board[i][j] == 1:
                    board[i][j] = 0
        return board
