#include <impl/basic/include.hpp>

#include <io.hpp>

#include <fstream>
#include <iostream>

using namespace ba_graph;


void incorrectParameters() {
    std::cerr << "Incorrect command line parameters, use 'pregraphs <discardHalfEdges> <inputFile> <outputFile>'\nAvailable formats are ....\n";// TODO only supports g6 -> s6; doplnit oldBA a chybajuce konverzie
    exit(1);
}

bool toS6(Graph &G, std::ostream *out, Factory &) {
    write_sparse6_stream(G, *out);
    return true;
}

int main(int argc, char **argv) {
    if (argc < 3)
        incorrectParameters();

    std::string discardHalfEdges = argv[1];
    char* inputFileName = argv[2];
    std::string outputFileName = argv[3];

    std::ofstream out(outputFileName);
    if (!out)
        throw std::runtime_error("cannot open output file");
    FILE * inputFile;
    inputFile = fopen(inputFileName , "r");
    if (inputFile == NULL)
        throw std::runtime_error("cannot open input file");
    auto graphs = read_pregraphs_from_file(inputFile);
    write_sparse6_file(outputFileName, graphs.begin(), graphs.end());

    return 0;
}
