from construct import (
    Struct,
    Byte,
    Int16ub,
    Int64ub,
    Enum,
    Bytes,
    Int24ub,
    this,
    GreedyBytes,
    GreedyRange,
    Terminated,
)

MerkleTreeHeader = Struct(
    "Version" / Byte,
    "MerkleLeafType" / Byte,
    "Timestamp" / Int64ub,
    "LogEntryType" / Enum(Int16ub, X509LogEntryType=0, PrecertLogEntryType=1),
    "Entry" / GreedyBytes,
)

CertEntry = Struct("Length" / Int24ub, "CertData" / Bytes(this.Length))

CertChain = Struct(
    "ChainLength" / Int24ub,
    "Chain" / GreedyRange(CertEntry),
)

PreCertEntry = Struct(
    "LeafCert" / CertEntry, "Chain" / GreedyRange(CertEntry), Terminated
)


class CertData:
    type = ""
    log_timestamp = 0
    ct_index = 0
    all_domains = []
    cert_dump = ""
    serial_number = 0
    not_before = 0
    not_after = 0
