
bin/app.elf:     file format elf32-littlearm


Disassembly of section .text:

c0d00000 <main>:
	}
	END_TRY_L(exit);
}

__attribute__((section(".boot"))) int main(void)
{
c0d00000:	b5b0      	push	{r4, r5, r7, lr}
c0d00002:	b08c      	sub	sp, #48	; 0x30
	// exit critical section
	__asm volatile("cpsie i");
c0d00004:	b662      	cpsie	i
c0d00006:	4c18      	ldr	r4, [pc, #96]	; (c0d00068 <main+0x68>)
c0d00008:	2170      	movs	r1, #112	; 0x70

	for (;;) {
		UX_INIT();
c0d0000a:	4620      	mov	r0, r4
c0d0000c:	f008 fa7e 	bl	c0d0850c <__aeabi_memclr>
c0d00010:	f008 f824 	bl	c0d0805c <ux_stack_push>
		os_boot();
c0d00014:	f002 f8b9 	bl	c0d0218a <os_boot>
c0d00018:	466d      	mov	r5, sp
		BEGIN_TRY {
			TRY {
c0d0001a:	4628      	mov	r0, r5
c0d0001c:	f008 fac0 	bl	c0d085a0 <setjmp>
c0d00020:	85a8      	strh	r0, [r5, #44]	; 0x2c
c0d00022:	b285      	uxth	r5, r0
c0d00024:	4668      	mov	r0, sp
c0d00026:	2d00      	cmp	r5, #0
c0d00028:	d00b      	beq.n	c0d00042 <main+0x42>
c0d0002a:	2100      	movs	r1, #0
c0d0002c:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d0002e:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d00030:	f005 fafa 	bl	c0d05628 <try_context_set>
c0d00034:	2d05      	cmp	r5, #5
c0d00036:	d0e7      	beq.n	c0d00008 <main+0x8>
			FINALLY {
			}
		}
		END_TRY;
	}
	app_exit();
c0d00038:	f002 f882 	bl	c0d02140 <app_exit>
c0d0003c:	2000      	movs	r0, #0
	return 0;
c0d0003e:	b00c      	add	sp, #48	; 0x30
c0d00040:	bdb0      	pop	{r4, r5, r7, pc}
			TRY {
c0d00042:	f005 faf1 	bl	c0d05628 <try_context_set>
c0d00046:	900a      	str	r0, [sp, #40]	; 0x28
				io_seproxyhal_init();
c0d00048:	f002 f9b8 	bl	c0d023bc <io_seproxyhal_init>
c0d0004c:	2000      	movs	r0, #0
				USB_power(0);
c0d0004e:	f007 fde5 	bl	c0d07c1c <USB_power>
c0d00052:	2001      	movs	r0, #1
				USB_power(1);
c0d00054:	f007 fde2 	bl	c0d07c1c <USB_power>
				ui_idle();
c0d00058:	f001 ff2c 	bl	c0d01eb4 <ui_idle>
				io_state = IO_EXPECT_IO;
c0d0005c:	4803      	ldr	r0, [pc, #12]	; (c0d0006c <main+0x6c>)
c0d0005e:	212a      	movs	r1, #42	; 0x2a
c0d00060:	7001      	strb	r1, [r0, #0]
				fio_main();
c0d00062:	f001 ff39 	bl	c0d01ed8 <fio_main>
c0d00066:	46c0      	nop			; (mov r8, r8)
c0d00068:	20000968 	.word	0x20000968
c0d0006c:	20000204 	.word	0x20000204

c0d00070 <assert>:
        const char* msgStr
        #ifdef RESET_ON_CRASH
        MARK_UNUSED
        #endif
)
{
c0d00070:	b580      	push	{r7, lr}
	if (cond) return; // everything holds
c0d00072:	2800      	cmp	r0, #0
c0d00074:	d000      	beq.n	c0d00078 <assert+0x8>
		#else
#			error "RESET_ON_CRASH should be enabled in non-devel mode!"
		#endif // DEVEL
	}
	#endif
}
c0d00076:	bd80      	pop	{r7, pc}
	io_seproxyhal_se_reset();
c0d00078:	f002 fa8a 	bl	c0d02590 <io_seproxyhal_se_reset>
}
c0d0007c:	bd80      	pop	{r7, pc}
	...

c0d00080 <bip44_parseFromWire>:

size_t bip44_parseFromWire(
        bip44_path_t* pathSpec,
        const uint8_t *dataBuffer, size_t dataSize
)
{
c0d00080:	b570      	push	{r4, r5, r6, lr}
	// Ensure we have length
	VALIDATE(dataSize >= 1, ERR_INVALID_DATA);
c0d00082:	2a00      	cmp	r2, #0
c0d00084:	d01d      	beq.n	c0d000c2 <bip44_parseFromWire+0x42>

	// Cast length to size_t
	size_t length = dataBuffer[0];
c0d00086:	780c      	ldrb	r4, [r1, #0]

	// Ensure length is valid
	VALIDATE(length <= ARRAY_LEN(pathSpec->path), ERR_INVALID_DATA);
c0d00088:	2c0b      	cmp	r4, #11
c0d0008a:	d220      	bcs.n	c0d000ce <bip44_parseFromWire+0x4e>
	VALIDATE(length * 4 + 1 <= dataSize, ERR_INVALID_DATA);
c0d0008c:	00a3      	lsls	r3, r4, #2
c0d0008e:	1c5d      	adds	r5, r3, #1
c0d00090:	4295      	cmp	r5, r2
c0d00092:	d822      	bhi.n	c0d000da <bip44_parseFromWire+0x5a>

	pathSpec->length = length;
c0d00094:	6284      	str	r4, [r0, #40]	; 0x28

	size_t offset = 1;
	for (size_t i = 0; i < length; i++) {
c0d00096:	2c00      	cmp	r4, #0
c0d00098:	d011      	beq.n	c0d000be <bip44_parseFromWire+0x3e>
c0d0009a:	2200      	movs	r2, #0
}


inline uint8_t u1be_read(const uint8_t* inBuffer)
{
	return inBuffer[0];
c0d0009c:	188c      	adds	r4, r1, r2
{
	STATIC_ASSERT(sizeof(uint32_t) == sizeof(unsigned), "bad unsigned size");

	// bitwise OR promotes unsigned types smaller than int to unsigned
	return (uint16_t) (
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d0009e:	7865      	ldrb	r5, [r4, #1]
	       );
}

inline uint32_t u4be_read(const uint8_t* inBuffer)
{
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d000a0:	062d      	lsls	r5, r5, #24
	return inBuffer[0];
c0d000a2:	78a6      	ldrb	r6, [r4, #2]
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d000a4:	0436      	lsls	r6, r6, #16
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d000a6:	1975      	adds	r5, r6, r5
	return inBuffer[0];
c0d000a8:	7926      	ldrb	r6, [r4, #4]
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d000aa:	19ad      	adds	r5, r5, r6
	return inBuffer[0];
c0d000ac:	78e4      	ldrb	r4, [r4, #3]
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d000ae:	0224      	lsls	r4, r4, #8
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d000b0:	192c      	adds	r4, r5, r4
		pathSpec->path[i] = u4be_read(dataBuffer + offset);
c0d000b2:	5084      	str	r4, [r0, r2]
	for (size_t i = 0; i < length; i++) {
c0d000b4:	1d12      	adds	r2, r2, #4
c0d000b6:	4293      	cmp	r3, r2
c0d000b8:	d1f0      	bne.n	c0d0009c <bip44_parseFromWire+0x1c>
		offset += 4;
	}
	return offset;
c0d000ba:	1c50      	adds	r0, r2, #1
c0d000bc:	bd70      	pop	{r4, r5, r6, pc}
c0d000be:	2001      	movs	r0, #1
c0d000c0:	bd70      	pop	{r4, r5, r6, pc}
	VALIDATE(dataSize >= 1, ERR_INVALID_DATA);
c0d000c2:	480c      	ldr	r0, [pc, #48]	; (c0d000f4 <bip44_parseFromWire+0x74>)
c0d000c4:	4478      	add	r0, pc
c0d000c6:	490c      	ldr	r1, [pc, #48]	; (c0d000f8 <bip44_parseFromWire+0x78>)
c0d000c8:	4479      	add	r1, pc
c0d000ca:	220d      	movs	r2, #13
c0d000cc:	e00a      	b.n	c0d000e4 <bip44_parseFromWire+0x64>
	VALIDATE(length <= ARRAY_LEN(pathSpec->path), ERR_INVALID_DATA);
c0d000ce:	480b      	ldr	r0, [pc, #44]	; (c0d000fc <bip44_parseFromWire+0x7c>)
c0d000d0:	4478      	add	r0, pc
c0d000d2:	490b      	ldr	r1, [pc, #44]	; (c0d00100 <bip44_parseFromWire+0x80>)
c0d000d4:	4479      	add	r1, pc
c0d000d6:	2213      	movs	r2, #19
c0d000d8:	e004      	b.n	c0d000e4 <bip44_parseFromWire+0x64>
	VALIDATE(length * 4 + 1 <= dataSize, ERR_INVALID_DATA);
c0d000da:	480a      	ldr	r0, [pc, #40]	; (c0d00104 <bip44_parseFromWire+0x84>)
c0d000dc:	4478      	add	r0, pc
c0d000de:	490a      	ldr	r1, [pc, #40]	; (c0d00108 <bip44_parseFromWire+0x88>)
c0d000e0:	4479      	add	r1, pc
c0d000e2:	2214      	movs	r2, #20
c0d000e4:	f002 fdae 	bl	c0d02c44 <mcu_usb_printf>
c0d000e8:	4801      	ldr	r0, [pc, #4]	; (c0d000f0 <bip44_parseFromWire+0x70>)
c0d000ea:	f002 f853 	bl	c0d02194 <os_longjmp>
c0d000ee:	46c0      	nop			; (mov r8, r8)
c0d000f0:	00006e07 	.word	0x00006e07
c0d000f4:	0000853a 	.word	0x0000853a
c0d000f8:	00008552 	.word	0x00008552
c0d000fc:	0000852e 	.word	0x0000852e
c0d00100:	00008546 	.word	0x00008546
c0d00104:	00008522 	.word	0x00008522
c0d00108:	0000853a 	.word	0x0000853a

c0d0010c <bip44_hasValidFIOPrefix>:
	return value & (~HARDENED_BIP32);
}

// FIO: /44'/235'
bool bip44_hasValidFIOPrefix(const bip44_path_t* pathSpec)
{
c0d0010c:	b510      	push	{r4, lr}
c0d0010e:	4601      	mov	r1, r0
#define CHECK(cond) if (!(cond)) return false
	CHECK(pathSpec->length > BIP44_I_COIN_TYPE);
c0d00110:	6a82      	ldr	r2, [r0, #40]	; 0x28
c0d00112:	2000      	movs	r0, #0
c0d00114:	2a02      	cmp	r2, #2
c0d00116:	d311      	bcc.n	c0d0013c <bip44_hasValidFIOPrefix+0x30>
	CHECK(pathSpec->path[BIP44_I_PURPOSE] == (PURPOSE_FIO | HARDENED_BIP32));
c0d00118:	680b      	ldr	r3, [r1, #0]
c0d0011a:	2201      	movs	r2, #1
c0d0011c:	07d2      	lsls	r2, r2, #31
c0d0011e:	4614      	mov	r4, r2
c0d00120:	342c      	adds	r4, #44	; 0x2c
c0d00122:	42a3      	cmp	r3, r4
c0d00124:	d10a      	bne.n	c0d0013c <bip44_hasValidFIOPrefix+0x30>
	CHECK(pathSpec->path[BIP44_I_COIN_TYPE] == (COIN_TYPE_FIO | HARDENED_BIP32));
c0d00126:	4613      	mov	r3, r2
c0d00128:	33eb      	adds	r3, #235	; 0xeb
c0d0012a:	684c      	ldr	r4, [r1, #4]
c0d0012c:	429c      	cmp	r4, r3
c0d0012e:	d105      	bne.n	c0d0013c <bip44_hasValidFIOPrefix+0x30>
	CHECK(pathSpec->path[BIP44_I_ACCOUNT] == (0 | HARDENED_BIP32));
c0d00130:	688b      	ldr	r3, [r1, #8]
c0d00132:	4293      	cmp	r3, r2
c0d00134:	d102      	bne.n	c0d0013c <bip44_hasValidFIOPrefix+0x30>
	CHECK(pathSpec->path[BIP44_I_CHAIN] == (0));
c0d00136:	68c9      	ldr	r1, [r1, #12]
c0d00138:	4248      	negs	r0, r1
c0d0013a:	4148      	adcs	r0, r1
	return true;
#undef CHECK
}
c0d0013c:	bd10      	pop	{r4, pc}

c0d0013e <bip44_containsAddress>:

// Address

bool bip44_containsAddress(const bip44_path_t* pathSpec)
{
	return pathSpec->length > BIP44_I_ADDRESS;
c0d0013e:	6a80      	ldr	r0, [r0, #40]	; 0x28
c0d00140:	2804      	cmp	r0, #4
c0d00142:	d801      	bhi.n	c0d00148 <bip44_containsAddress+0xa>
c0d00144:	2000      	movs	r0, #0
c0d00146:	4770      	bx	lr
c0d00148:	2001      	movs	r0, #1
c0d0014a:	4770      	bx	lr

c0d0014c <bip44_hasReasonableAddress>:
	ASSERT(pathSpec->length > BIP44_I_ADDRESS);
	return pathSpec->path[BIP44_I_ADDRESS];
}

bool bip44_hasReasonableAddress(const bip44_path_t* pathSpec)
{
c0d0014c:	b5b0      	push	{r4, r5, r7, lr}
c0d0014e:	4605      	mov	r5, r0
	return pathSpec->length > BIP44_I_ADDRESS;
c0d00150:	6a80      	ldr	r0, [r0, #40]	; 0x28
	if (!bip44_containsAddress(pathSpec)) return false;
c0d00152:	2805      	cmp	r0, #5
c0d00154:	d309      	bcc.n	c0d0016a <bip44_hasReasonableAddress+0x1e>
c0d00156:	2401      	movs	r4, #1
	ASSERT(pathSpec->length > BIP44_I_ADDRESS);
c0d00158:	4906      	ldr	r1, [pc, #24]	; (c0d00174 <bip44_hasReasonableAddress+0x28>)
c0d0015a:	4479      	add	r1, pc
c0d0015c:	4620      	mov	r0, r4
c0d0015e:	f7ff ff87 	bl	c0d00070 <assert>
	return pathSpec->path[BIP44_I_ADDRESS];
c0d00162:	6928      	ldr	r0, [r5, #16]
c0d00164:	4902      	ldr	r1, [pc, #8]	; (c0d00170 <bip44_hasReasonableAddress+0x24>)
	const uint32_t address = bip44_getAddressValue(pathSpec);
	return (address <= MAX_REASONABLE_ADDRESS);
c0d00166:	4288      	cmp	r0, r1
c0d00168:	d300      	bcc.n	c0d0016c <bip44_hasReasonableAddress+0x20>
c0d0016a:	2400      	movs	r4, #0
}
c0d0016c:	4620      	mov	r0, r4
c0d0016e:	bdb0      	pop	{r4, r5, r7, pc}
c0d00170:	000003e9 	.word	0x000003e9
c0d00174:	000084db 	.word	0x000084db

c0d00178 <bip44_containsMoreThanAddress>:

// Further
bool bip44_containsMoreThanAddress(const bip44_path_t* pathSpec)
{
	return (pathSpec->length > BIP44_I_ADDRESS + 1);
c0d00178:	6a80      	ldr	r0, [r0, #40]	; 0x28
c0d0017a:	2805      	cmp	r0, #5
c0d0017c:	d801      	bhi.n	c0d00182 <bip44_containsMoreThanAddress+0xa>
c0d0017e:	2000      	movs	r0, #0
c0d00180:	4770      	bx	lr
c0d00182:	2001      	movs	r0, #1
c0d00184:	4770      	bx	lr
	...

c0d00188 <bip44_printToStr>:
}

// returns the length of the resulting string
size_t bip44_printToStr(const bip44_path_t* pathSpec, char* out, size_t outSize)
{
c0d00188:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0018a:	b087      	sub	sp, #28
c0d0018c:	4616      	mov	r6, r2
c0d0018e:	460c      	mov	r4, r1
c0d00190:	9003      	str	r0, [sp, #12]
	ASSERT(outSize < BUFFER_SIZE_PARANOIA);
c0d00192:	0a91      	lsrs	r1, r2, #10
c0d00194:	4248      	negs	r0, r1
c0d00196:	4148      	adcs	r0, r1
c0d00198:	4946      	ldr	r1, [pc, #280]	; (c0d002b4 <bip44_printToStr+0x12c>)
c0d0019a:	4479      	add	r1, pc
c0d0019c:	f7ff ff68 	bl	c0d00070 <assert>
	// We have to have space for terminating null
	ASSERT(outSize > 0);
c0d001a0:	1e71      	subs	r1, r6, #1
c0d001a2:	4630      	mov	r0, r6
c0d001a4:	4188      	sbcs	r0, r1
c0d001a6:	4944      	ldr	r1, [pc, #272]	; (c0d002b8 <bip44_printToStr+0x130>)
c0d001a8:	4479      	add	r1, pc
c0d001aa:	f7ff ff61 	bl	c0d00070 <assert>
		/* usually, outSize >= 1 + BIP44_MAX_PATH_STRING_LENGTH */ \
		ASSERT(res + 1 <= availableSize); \
		ptr += res; \
	}

	WRITE("m");
c0d001ae:	43f0      	mvns	r0, r6
c0d001b0:	0fc0      	lsrs	r0, r0, #31
c0d001b2:	4d42      	ldr	r5, [pc, #264]	; (c0d002bc <bip44_printToStr+0x134>)
c0d001b4:	447d      	add	r5, pc
c0d001b6:	4629      	mov	r1, r5
c0d001b8:	f7ff ff5a 	bl	c0d00070 <assert>
c0d001bc:	4a40      	ldr	r2, [pc, #256]	; (c0d002c0 <bip44_printToStr+0x138>)
c0d001be:	447a      	add	r2, pc
c0d001c0:	4620      	mov	r0, r4
c0d001c2:	4631      	mov	r1, r6
c0d001c4:	f002 fec0 	bl	c0d02f48 <snprintf>
c0d001c8:	9401      	str	r4, [sp, #4]
c0d001ca:	4620      	mov	r0, r4
c0d001cc:	f008 fa0c 	bl	c0d085e8 <strlen>
c0d001d0:	4604      	mov	r4, r0
c0d001d2:	1c40      	adds	r0, r0, #1
c0d001d4:	2701      	movs	r7, #1
c0d001d6:	2100      	movs	r1, #0
c0d001d8:	42b0      	cmp	r0, r6
c0d001da:	4638      	mov	r0, r7
c0d001dc:	d900      	bls.n	c0d001e0 <bip44_printToStr+0x58>
c0d001de:	4608      	mov	r0, r1
c0d001e0:	9106      	str	r1, [sp, #24]
c0d001e2:	4629      	mov	r1, r5
c0d001e4:	f7ff ff44 	bl	c0d00070 <assert>
c0d001e8:	9903      	ldr	r1, [sp, #12]

	ASSERT(pathSpec->length < ARRAY_LEN(pathSpec->path));
c0d001ea:	6a88      	ldr	r0, [r1, #40]	; 0x28
c0d001ec:	280a      	cmp	r0, #10
c0d001ee:	460d      	mov	r5, r1
c0d001f0:	d300      	bcc.n	c0d001f4 <bip44_printToStr+0x6c>
c0d001f2:	9f06      	ldr	r7, [sp, #24]
c0d001f4:	4933      	ldr	r1, [pc, #204]	; (c0d002c4 <bip44_printToStr+0x13c>)
c0d001f6:	4479      	add	r1, pc
c0d001f8:	4638      	mov	r0, r7
c0d001fa:	f7ff ff39 	bl	c0d00070 <assert>
c0d001fe:	9801      	ldr	r0, [sp, #4]
	char* end = (out + outSize);
c0d00200:	1981      	adds	r1, r0, r6
	WRITE("m");
c0d00202:	9106      	str	r1, [sp, #24]
c0d00204:	1906      	adds	r6, r0, r4

	for (size_t i = 0; i < pathSpec->length; i++) {
c0d00206:	6aa8      	ldr	r0, [r5, #40]	; 0x28
c0d00208:	2800      	cmp	r0, #0
c0d0020a:	d03c      	beq.n	c0d00286 <bip44_printToStr+0xfe>
c0d0020c:	2400      	movs	r4, #0
c0d0020e:	462f      	mov	r7, r5
c0d00210:	9402      	str	r4, [sp, #8]
c0d00212:	9806      	ldr	r0, [sp, #24]
c0d00214:	4286      	cmp	r6, r0
c0d00216:	d901      	bls.n	c0d0021c <bip44_printToStr+0x94>
c0d00218:	9802      	ldr	r0, [sp, #8]
c0d0021a:	e000      	b.n	c0d0021e <bip44_printToStr+0x96>
c0d0021c:	2001      	movs	r0, #1
		const uint32_t value = pathSpec->path[i];
c0d0021e:	683d      	ldr	r5, [r7, #0]

		if ((value & HARDENED_BIP32) == HARDENED_BIP32) {
c0d00220:	2d00      	cmp	r5, #0
c0d00222:	d40a      	bmi.n	c0d0023a <bip44_printToStr+0xb2>
			WRITE("/%d'", (int) (value & ~HARDENED_BIP32));
		} else {
			WRITE("/%d", (int) value);
c0d00224:	492c      	ldr	r1, [pc, #176]	; (c0d002d8 <bip44_printToStr+0x150>)
c0d00226:	4479      	add	r1, pc
c0d00228:	9105      	str	r1, [sp, #20]
c0d0022a:	f7ff ff21 	bl	c0d00070 <assert>
c0d0022e:	9806      	ldr	r0, [sp, #24]
c0d00230:	1b81      	subs	r1, r0, r6
c0d00232:	9104      	str	r1, [sp, #16]
c0d00234:	4a29      	ldr	r2, [pc, #164]	; (c0d002dc <bip44_printToStr+0x154>)
c0d00236:	447a      	add	r2, pc
c0d00238:	e00c      	b.n	c0d00254 <bip44_printToStr+0xcc>
			WRITE("/%d'", (int) (value & ~HARDENED_BIP32));
c0d0023a:	4925      	ldr	r1, [pc, #148]	; (c0d002d0 <bip44_printToStr+0x148>)
c0d0023c:	4479      	add	r1, pc
c0d0023e:	9105      	str	r1, [sp, #20]
c0d00240:	f7ff ff16 	bl	c0d00070 <assert>
c0d00244:	9806      	ldr	r0, [sp, #24]
c0d00246:	1b81      	subs	r1, r0, r6
c0d00248:	9104      	str	r1, [sp, #16]
c0d0024a:	2001      	movs	r0, #1
c0d0024c:	07c0      	lsls	r0, r0, #31
c0d0024e:	4385      	bics	r5, r0
c0d00250:	4a20      	ldr	r2, [pc, #128]	; (c0d002d4 <bip44_printToStr+0x14c>)
c0d00252:	447a      	add	r2, pc
c0d00254:	4630      	mov	r0, r6
c0d00256:	462b      	mov	r3, r5
c0d00258:	f002 fe76 	bl	c0d02f48 <snprintf>
c0d0025c:	4630      	mov	r0, r6
c0d0025e:	f008 f9c3 	bl	c0d085e8 <strlen>
c0d00262:	9904      	ldr	r1, [sp, #16]
c0d00264:	4605      	mov	r5, r0
c0d00266:	1c40      	adds	r0, r0, #1
c0d00268:	4288      	cmp	r0, r1
c0d0026a:	d901      	bls.n	c0d00270 <bip44_printToStr+0xe8>
c0d0026c:	2000      	movs	r0, #0
c0d0026e:	e000      	b.n	c0d00272 <bip44_printToStr+0xea>
c0d00270:	2001      	movs	r0, #1
c0d00272:	9905      	ldr	r1, [sp, #20]
c0d00274:	f7ff fefc 	bl	c0d00070 <assert>
c0d00278:	1976      	adds	r6, r6, r5
	for (size_t i = 0; i < pathSpec->length; i++) {
c0d0027a:	1d3f      	adds	r7, r7, #4
c0d0027c:	1c64      	adds	r4, r4, #1
c0d0027e:	9803      	ldr	r0, [sp, #12]
c0d00280:	6a80      	ldr	r0, [r0, #40]	; 0x28
c0d00282:	4284      	cmp	r4, r0
c0d00284:	d3c5      	bcc.n	c0d00212 <bip44_printToStr+0x8a>
c0d00286:	2401      	movs	r4, #1
c0d00288:	2500      	movs	r5, #0
		}
	}
#undef WRITE
	ASSERT(ptr < end);
c0d0028a:	9806      	ldr	r0, [sp, #24]
c0d0028c:	4286      	cmp	r6, r0
c0d0028e:	4620      	mov	r0, r4
c0d00290:	d300      	bcc.n	c0d00294 <bip44_printToStr+0x10c>
c0d00292:	4628      	mov	r0, r5
c0d00294:	490c      	ldr	r1, [pc, #48]	; (c0d002c8 <bip44_printToStr+0x140>)
c0d00296:	4479      	add	r1, pc
c0d00298:	f7ff feea 	bl	c0d00070 <assert>
c0d0029c:	9f01      	ldr	r7, [sp, #4]
	ASSERT(ptr >= out);
c0d0029e:	42be      	cmp	r6, r7
c0d002a0:	d200      	bcs.n	c0d002a4 <bip44_printToStr+0x11c>
c0d002a2:	462c      	mov	r4, r5
c0d002a4:	4909      	ldr	r1, [pc, #36]	; (c0d002cc <bip44_printToStr+0x144>)
c0d002a6:	4479      	add	r1, pc
c0d002a8:	4620      	mov	r0, r4
c0d002aa:	f7ff fee1 	bl	c0d00070 <assert>

	return ptr - out;
c0d002ae:	1bf0      	subs	r0, r6, r7
c0d002b0:	b007      	add	sp, #28
c0d002b2:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d002b4:	000084aa 	.word	0x000084aa
c0d002b8:	000084ab 	.word	0x000084ab
c0d002bc:	000084ae 	.word	0x000084ae
c0d002c0:	000084b4 	.word	0x000084b4
c0d002c4:	0000847e 	.word	0x0000847e
c0d002c8:	00008417 	.word	0x00008417
c0d002cc:	00008417 	.word	0x00008417
c0d002d0:	00008448 	.word	0x00008448
c0d002d4:	00008442 	.word	0x00008442
c0d002d8:	00008473 	.word	0x00008473
c0d002dc:	00008473 	.word	0x00008473

c0d002e0 <bip44_PRINTF>:
}

#ifdef DEVEL
void bip44_PRINTF(const bip44_path_t* pathSpec)
{
c0d002e0:	b510      	push	{r4, lr}
c0d002e2:	b0a0      	sub	sp, #128	; 0x80
c0d002e4:	ac01      	add	r4, sp, #4
c0d002e6:	227a      	movs	r2, #122	; 0x7a
	char tmp[1 + BIP44_MAX_PATH_STRING_LENGTH];
	SIZEOF(*pathSpec);
	bip44_printToStr(pathSpec, tmp, SIZEOF(tmp));
c0d002e8:	4621      	mov	r1, r4
c0d002ea:	f7ff ff4d 	bl	c0d00188 <bip44_printToStr>
	PRINTF("%s", tmp);
c0d002ee:	4803      	ldr	r0, [pc, #12]	; (c0d002fc <bip44_PRINTF+0x1c>)
c0d002f0:	4478      	add	r0, pc
c0d002f2:	4621      	mov	r1, r4
c0d002f4:	f002 fca6 	bl	c0d02c44 <mcu_usb_printf>
};
c0d002f8:	b020      	add	sp, #128	; 0x80
c0d002fa:	bd10      	pop	{r4, pc}
c0d002fc:	000083dd 	.word	0x000083dd

c0d00300 <testcase_printToStr>:
	pathSpec->length = pathLength;
	memmove(pathSpec->path, pathArray, pathLength * 4);
}

void testcase_printToStr(const uint32_t* path, uint32_t pathLen, size_t outputSize, const char* expected)
{
c0d00300:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d00302:	b0ab      	sub	sp, #172	; 0xac
c0d00304:	461c      	mov	r4, r3
c0d00306:	4615      	mov	r5, r2
c0d00308:	460e      	mov	r6, r1
c0d0030a:	4607      	mov	r7, r0
	PRINTF("testcase_bip44_printToStr %s\n", expected);
c0d0030c:	4819      	ldr	r0, [pc, #100]	; (c0d00374 <testcase_printToStr+0x74>)
c0d0030e:	4478      	add	r0, pc
c0d00310:	4619      	mov	r1, r3
c0d00312:	f002 fc97 	bl	c0d02c44 <mcu_usb_printf>
	pathSpec->length = pathLength;
c0d00316:	962a      	str	r6, [sp, #168]	; 0xa8
	memmove(pathSpec->path, pathArray, pathLength * 4);
c0d00318:	00b2      	lsls	r2, r6, #2
c0d0031a:	ae20      	add	r6, sp, #128	; 0x80
c0d0031c:	4630      	mov	r0, r6
c0d0031e:	4639      	mov	r1, r7
c0d00320:	f008 f8f9 	bl	c0d08516 <__aeabi_memcpy>

	bip44_path_t pathSpec;
	pathSpec_init(&pathSpec, path, pathLen);

	char result[1 + BIP44_MAX_PATH_STRING_LENGTH];
	ASSERT(outputSize <= SIZEOF(result));
c0d00324:	2d7b      	cmp	r5, #123	; 0x7b
c0d00326:	d301      	bcc.n	c0d0032c <testcase_printToStr+0x2c>
c0d00328:	2000      	movs	r0, #0
c0d0032a:	e000      	b.n	c0d0032e <testcase_printToStr+0x2e>
c0d0032c:	2001      	movs	r0, #1
c0d0032e:	4912      	ldr	r1, [pc, #72]	; (c0d00378 <testcase_printToStr+0x78>)
c0d00330:	4479      	add	r1, pc
c0d00332:	f7ff fe9d 	bl	c0d00070 <assert>
c0d00336:	af01      	add	r7, sp, #4

	size_t resultLen = bip44_printToStr(&pathSpec, result, outputSize);
c0d00338:	4630      	mov	r0, r6
c0d0033a:	4639      	mov	r1, r7
c0d0033c:	462a      	mov	r2, r5
c0d0033e:	f7ff ff23 	bl	c0d00188 <bip44_printToStr>
c0d00342:	4605      	mov	r5, r0

	size_t expectedSize = strlen(expected) + 1;
c0d00344:	4620      	mov	r0, r4
c0d00346:	f008 f94f 	bl	c0d085e8 <strlen>
c0d0034a:	4606      	mov	r6, r0
	EXPECT_EQ(resultLen + 1, expectedSize);
c0d0034c:	1a29      	subs	r1, r5, r0
c0d0034e:	4248      	negs	r0, r1
c0d00350:	4148      	adcs	r0, r1
c0d00352:	490a      	ldr	r1, [pc, #40]	; (c0d0037c <testcase_printToStr+0x7c>)
c0d00354:	4479      	add	r1, pc
c0d00356:	f7ff fe8b 	bl	c0d00070 <assert>
	size_t expectedSize = strlen(expected) + 1;
c0d0035a:	1c72      	adds	r2, r6, #1
	EXPECT_EQ_BYTES(result, expected, expectedSize);
c0d0035c:	4638      	mov	r0, r7
c0d0035e:	4621      	mov	r1, r4
c0d00360:	f008 f8ec 	bl	c0d0853c <memcmp>
c0d00364:	4241      	negs	r1, r0
c0d00366:	4148      	adcs	r0, r1
c0d00368:	4905      	ldr	r1, [pc, #20]	; (c0d00380 <testcase_printToStr+0x80>)
c0d0036a:	4479      	add	r1, pc
c0d0036c:	f7ff fe80 	bl	c0d00070 <assert>
}
c0d00370:	b02b      	add	sp, #172	; 0xac
c0d00372:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d00374:	000083c2 	.word	0x000083c2
c0d00378:	000083be 	.word	0x000083be
c0d0037c:	000083ae 	.word	0x000083ae
c0d00380:	000083ac 	.word	0x000083ac

c0d00384 <run_bip44_test>:

void run_bip44_test()
{
c0d00384:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d00386:	b089      	sub	sp, #36	; 0x24
	{ \
		uint32_t path[] = { UNWRAP path_ }; \
		testcase_printToStr(path, ARRAY_LEN(path), outputSize_, expected_); \
	}

	TESTCASE(
c0d00388:	4f21      	ldr	r7, [pc, #132]	; (c0d00410 <run_bip44_test+0x8c>)
c0d0038a:	447f      	add	r7, pc
c0d0038c:	a802      	add	r0, sp, #8
c0d0038e:	4639      	mov	r1, r7
c0d00390:	4602      	mov	r2, r0
c0d00392:	c938      	ldmia	r1!, {r3, r4, r5}
c0d00394:	c238      	stmia	r2!, {r3, r4, r5}
c0d00396:	c978      	ldmia	r1!, {r3, r4, r5, r6}
c0d00398:	c278      	stmia	r2!, {r3, r4, r5, r6}
c0d0039a:	2107      	movs	r1, #7
c0d0039c:	9100      	str	r1, [sp, #0]
c0d0039e:	2279      	movs	r2, #121	; 0x79
c0d003a0:	9201      	str	r2, [sp, #4]
c0d003a2:	4e1c      	ldr	r6, [pc, #112]	; (c0d00414 <run_bip44_test+0x90>)
c0d003a4:	447e      	add	r6, pc
c0d003a6:	4633      	mov	r3, r6
c0d003a8:	f7ff ffaa 	bl	c0d00300 <testcase_printToStr>
c0d003ac:	a802      	add	r0, sp, #8
	        (1, 2, 3, 4, 5, 6, 7), BIP44_MAX_PATH_STRING_LENGTH,
	        "m/1/2/3/4/5/6/7"
	);
	TESTCASE(
c0d003ae:	4601      	mov	r1, r0
c0d003b0:	cf1c      	ldmia	r7!, {r2, r3, r4}
c0d003b2:	c11c      	stmia	r1!, {r2, r3, r4}
c0d003b4:	cf3c      	ldmia	r7!, {r2, r3, r4, r5}
c0d003b6:	c13c      	stmia	r1!, {r2, r3, r4, r5}
c0d003b8:	2210      	movs	r2, #16
c0d003ba:	9900      	ldr	r1, [sp, #0]
c0d003bc:	4633      	mov	r3, r6
c0d003be:	f7ff ff9f 	bl	c0d00300 <testcase_printToStr>
c0d003c2:	a802      	add	r0, sp, #8
c0d003c4:	2100      	movs	r1, #0
c0d003c6:	2502      	movs	r5, #2
	        (1, 2, 3, 4, 5, 6, 7), 16,
	        "m/1/2/3/4/5/6/7"
	);
	TESTCASE(
c0d003c8:	4b13      	ldr	r3, [pc, #76]	; (c0d00418 <run_bip44_test+0x94>)
c0d003ca:	447b      	add	r3, pc
c0d003cc:	462a      	mov	r2, r5
c0d003ce:	f7ff ff97 	bl	c0d00300 <testcase_printToStr>
	        (), 2,
	        "m"
	);
	TESTCASE(
c0d003d2:	4912      	ldr	r1, [pc, #72]	; (c0d0041c <run_bip44_test+0x98>)
c0d003d4:	4479      	add	r1, pc
c0d003d6:	a802      	add	r0, sp, #8
c0d003d8:	4602      	mov	r2, r0
c0d003da:	c918      	ldmia	r1!, {r3, r4}
c0d003dc:	c218      	stmia	r2!, {r3, r4}
c0d003de:	c958      	ldmia	r1!, {r3, r4, r6}
c0d003e0:	c258      	stmia	r2!, {r3, r4, r6}
c0d003e2:	2105      	movs	r1, #5
c0d003e4:	4b0e      	ldr	r3, [pc, #56]	; (c0d00420 <run_bip44_test+0x9c>)
c0d003e6:	447b      	add	r3, pc
c0d003e8:	9a01      	ldr	r2, [sp, #4]
c0d003ea:	f7ff ff89 	bl	c0d00300 <testcase_printToStr>
c0d003ee:	4806      	ldr	r0, [pc, #24]	; (c0d00408 <run_bip44_test+0x84>)
	        (HD + 44, HD + 1815, HD + 0, 1, 55), BIP44_MAX_PATH_STRING_LENGTH,
	        "m/44'/1815'/0'/1/55"
	);
	TESTCASE(
c0d003f0:	9003      	str	r0, [sp, #12]
c0d003f2:	4806      	ldr	r0, [pc, #24]	; (c0d0040c <run_bip44_test+0x88>)
c0d003f4:	9002      	str	r0, [sp, #8]
c0d003f6:	a802      	add	r0, sp, #8
c0d003f8:	2264      	movs	r2, #100	; 0x64
c0d003fa:	4b0a      	ldr	r3, [pc, #40]	; (c0d00424 <run_bip44_test+0xa0>)
c0d003fc:	447b      	add	r3, pc
c0d003fe:	4629      	mov	r1, r5
c0d00400:	f7ff ff7e 	bl	c0d00300 <testcase_printToStr>
	        (HD + 44, HD + 1815), 100,
	        "m/44'/1815'"
	);
#undef TESTCASE
}
c0d00404:	b009      	add	sp, #36	; 0x24
c0d00406:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d00408:	80000717 	.word	0x80000717
c0d0040c:	8000002c 	.word	0x8000002c
c0d00410:	000083d2 	.word	0x000083d2
c0d00414:	00008386 	.word	0x00008386
c0d00418:	000082a8 	.word	0x000082a8
c0d0041c:	000083a4 	.word	0x000083a4
c0d00420:	00008354 	.word	0x00008354
c0d00424:	00008352 	.word	0x00008352

c0d00428 <cx_crc16_update>:
CX_TRAMPOLINE _NR_cx_blake2b_get_output_size               cx_blake2b_get_output_size
CX_TRAMPOLINE _NR_cx_blake2b_init2_no_throw                cx_blake2b_init2_no_throw
CX_TRAMPOLINE _NR_cx_blake2b_init_no_throw                 cx_blake2b_init_no_throw
CX_TRAMPOLINE _NR_cx_blake2b_update                        cx_blake2b_update
CX_TRAMPOLINE _NR_cx_crc16                                 cx_crc16
CX_TRAMPOLINE _NR_cx_crc16_update                          cx_crc16_update
c0d00428:	b403      	push	{r0, r1}
c0d0042a:	4801      	ldr	r0, [pc, #4]	; (c0d00430 <cx_crc16_update+0x8>)
c0d0042c:	e041      	b.n	c0d004b2 <cx_trampoline_helper>
c0d0042e:	0000      	.short	0x0000
c0d00430:	0000000c 	.word	0x0000000c

c0d00434 <cx_ecdsa_sign_no_throw>:
CX_TRAMPOLINE _NR_cx_des_enc_block                         cx_des_enc_block
CX_TRAMPOLINE _NR_cx_des_init_key_no_throw                 cx_des_init_key_no_throw
CX_TRAMPOLINE _NR_cx_des_iv_no_throw                       cx_des_iv_no_throw
CX_TRAMPOLINE _NR_cx_des_no_throw                          cx_des_no_throw
CX_TRAMPOLINE _NR_cx_ecdh_no_throw                         cx_ecdh_no_throw
CX_TRAMPOLINE _NR_cx_ecdsa_sign_no_throw                   cx_ecdsa_sign_no_throw
c0d00434:	b403      	push	{r0, r1}
c0d00436:	4801      	ldr	r0, [pc, #4]	; (c0d0043c <cx_ecdsa_sign_no_throw+0x8>)
c0d00438:	e03b      	b.n	c0d004b2 <cx_trampoline_helper>
c0d0043a:	0000      	.short	0x0000
c0d0043c:	00000015 	.word	0x00000015

c0d00440 <cx_ecfp_generate_pair_no_throw>:
CX_TRAMPOLINE _NR_cx_ecdsa_verify_no_throw                 cx_ecdsa_verify_no_throw
CX_TRAMPOLINE _NR_cx_ecfp_add_point_no_throw               cx_ecfp_add_point_no_throw
CX_TRAMPOLINE _NR_cx_ecfp_decode_sig_der                   cx_ecfp_decode_sig_der
CX_TRAMPOLINE _NR_cx_ecfp_encode_sig_der                   cx_ecfp_encode_sig_der
CX_TRAMPOLINE _NR_cx_ecfp_generate_pair2_no_throw          cx_ecfp_generate_pair2_no_throw
CX_TRAMPOLINE _NR_cx_ecfp_generate_pair_no_throw           cx_ecfp_generate_pair_no_throw
c0d00440:	b403      	push	{r0, r1}
c0d00442:	4801      	ldr	r0, [pc, #4]	; (c0d00448 <cx_ecfp_generate_pair_no_throw+0x8>)
c0d00444:	e035      	b.n	c0d004b2 <cx_trampoline_helper>
c0d00446:	0000      	.short	0x0000
c0d00448:	0000001b 	.word	0x0000001b

c0d0044c <cx_ecfp_init_private_key_no_throw>:
CX_TRAMPOLINE _NR_cx_ecfp_init_private_key_no_throw        cx_ecfp_init_private_key_no_throw
c0d0044c:	b403      	push	{r0, r1}
c0d0044e:	4801      	ldr	r0, [pc, #4]	; (c0d00454 <cx_ecfp_init_private_key_no_throw+0x8>)
c0d00450:	e02f      	b.n	c0d004b2 <cx_trampoline_helper>
c0d00452:	0000      	.short	0x0000
c0d00454:	0000001c 	.word	0x0000001c

c0d00458 <cx_ecfp_init_public_key_no_throw>:
CX_TRAMPOLINE _NR_cx_ecfp_init_public_key_no_throw         cx_ecfp_init_public_key_no_throw
c0d00458:	b403      	push	{r0, r1}
c0d0045a:	4801      	ldr	r0, [pc, #4]	; (c0d00460 <cx_ecfp_init_public_key_no_throw+0x8>)
c0d0045c:	e029      	b.n	c0d004b2 <cx_trampoline_helper>
c0d0045e:	0000      	.short	0x0000
c0d00460:	0000001d 	.word	0x0000001d

c0d00464 <cx_hash_get_size>:
CX_TRAMPOLINE _NR_cx_groestl_get_output_size               cx_groestl_get_output_size
CX_TRAMPOLINE _NR_cx_groestl_init_no_throw                 cx_groestl_init_no_throw
CX_TRAMPOLINE _NR_cx_groestl_update                        cx_groestl_update
CX_TRAMPOLINE _NR_cx_hash_final                            cx_hash_final
CX_TRAMPOLINE _NR_cx_hash_get_info                         cx_hash_get_info
CX_TRAMPOLINE _NR_cx_hash_get_size                         cx_hash_get_size
c0d00464:	b403      	push	{r0, r1}
c0d00466:	4801      	ldr	r0, [pc, #4]	; (c0d0046c <cx_hash_get_size+0x8>)
c0d00468:	e023      	b.n	c0d004b2 <cx_trampoline_helper>
c0d0046a:	0000      	.short	0x0000
c0d0046c:	0000002f 	.word	0x0000002f

c0d00470 <cx_hash_no_throw>:
CX_TRAMPOLINE _NR_cx_hash_init                             cx_hash_init
CX_TRAMPOLINE _NR_cx_hash_init_ex                          cx_hash_init_ex
CX_TRAMPOLINE _NR_cx_hash_no_throw                         cx_hash_no_throw
c0d00470:	b403      	push	{r0, r1}
c0d00472:	4801      	ldr	r0, [pc, #4]	; (c0d00478 <cx_hash_no_throw+0x8>)
c0d00474:	e01d      	b.n	c0d004b2 <cx_trampoline_helper>
c0d00476:	0000      	.short	0x0000
c0d00478:	00000032 	.word	0x00000032

c0d0047c <cx_hmac_no_throw>:
CX_TRAMPOLINE _NR_cx_hash_update                           cx_hash_update
CX_TRAMPOLINE _NR_cx_hkdf_expand                           cx_hkdf_expand
CX_TRAMPOLINE _NR_cx_hkdf_extract                          cx_hkdf_extract
CX_TRAMPOLINE _NR_cx_hmac_final                            cx_hmac_final
CX_TRAMPOLINE _NR_cx_hmac_init                             cx_hmac_init
CX_TRAMPOLINE _NR_cx_hmac_no_throw                         cx_hmac_no_throw
c0d0047c:	b403      	push	{r0, r1}
c0d0047e:	4801      	ldr	r0, [pc, #4]	; (c0d00484 <cx_hmac_no_throw+0x8>)
c0d00480:	e017      	b.n	c0d004b2 <cx_trampoline_helper>
c0d00482:	0000      	.short	0x0000
c0d00484:	0000003a 	.word	0x0000003a

c0d00488 <cx_hmac_sha256_init_no_throw>:
CX_TRAMPOLINE _NR_cx_hmac_ripemd160_init_no_throw          cx_hmac_ripemd160_init_no_throw
CX_TRAMPOLINE _NR_cx_hmac_sha224_init                      cx_hmac_sha224_init
CX_TRAMPOLINE _NR_cx_hmac_sha256                           cx_hmac_sha256
CX_TRAMPOLINE _NR_cx_hmac_sha256_init_no_throw             cx_hmac_sha256_init_no_throw
c0d00488:	b403      	push	{r0, r1}
c0d0048a:	4801      	ldr	r0, [pc, #4]	; (c0d00490 <cx_hmac_sha256_init_no_throw+0x8>)
c0d0048c:	e011      	b.n	c0d004b2 <cx_trampoline_helper>
c0d0048e:	0000      	.short	0x0000
c0d00490:	0000003e 	.word	0x0000003e

c0d00494 <cx_rng_no_throw>:
CX_TRAMPOLINE _NR_cx_pbkdf2_hmac                           cx_pbkdf2_hmac
CX_TRAMPOLINE _NR_cx_pbkdf2_no_throw                       cx_pbkdf2_no_throw
CX_TRAMPOLINE _NR_cx_ripemd160_final                       cx_ripemd160_final
CX_TRAMPOLINE _NR_cx_ripemd160_init_no_throw               cx_ripemd160_init_no_throw
CX_TRAMPOLINE _NR_cx_ripemd160_update                      cx_ripemd160_update
CX_TRAMPOLINE _NR_cx_rng_no_throw                          cx_rng_no_throw
c0d00494:	b403      	push	{r0, r1}
c0d00496:	4801      	ldr	r0, [pc, #4]	; (c0d0049c <cx_rng_no_throw+0x8>)
c0d00498:	e00b      	b.n	c0d004b2 <cx_trampoline_helper>
c0d0049a:	0000      	.short	0x0000
c0d0049c:	00000058 	.word	0x00000058

c0d004a0 <cx_sha256_init_no_throw>:
CX_TRAMPOLINE _NR_cx_rng_rfc6979_init                      cx_rng_rfc6979_init
CX_TRAMPOLINE _NR_cx_rng_rfc6979_next                      cx_rng_rfc6979_next
CX_TRAMPOLINE _NR_cx_rng_u32_range_func                    cx_rng_u32_range_func
CX_TRAMPOLINE _NR_cx_sha224_init_no_throw                  cx_sha224_init_no_throw
CX_TRAMPOLINE _NR_cx_sha256_final                          cx_sha256_final
CX_TRAMPOLINE _NR_cx_sha256_init_no_throw                  cx_sha256_init_no_throw
c0d004a0:	b403      	push	{r0, r1}
c0d004a2:	4801      	ldr	r0, [pc, #4]	; (c0d004a8 <cx_sha256_init_no_throw+0x8>)
c0d004a4:	e005      	b.n	c0d004b2 <cx_trampoline_helper>
c0d004a6:	0000      	.short	0x0000
c0d004a8:	0000005f 	.word	0x0000005f

c0d004ac <cx_swap_uint64>:
CX_TRAMPOLINE _NR_cx_shake128_init_no_throw                cx_shake128_init_no_throw
CX_TRAMPOLINE _NR_cx_shake256_init_no_throw                cx_shake256_init_no_throw
CX_TRAMPOLINE _NR_cx_swap_buffer32                         cx_swap_buffer32
CX_TRAMPOLINE _NR_cx_swap_buffer64                         cx_swap_buffer64
CX_TRAMPOLINE _NR_cx_swap_uint32                           cx_swap_uint32
CX_TRAMPOLINE _NR_cx_swap_uint64                           cx_swap_uint64
c0d004ac:	b403      	push	{r0, r1}
c0d004ae:	4802      	ldr	r0, [pc, #8]	; (c0d004b8 <cx_trampoline_helper+0x6>)
c0d004b0:	e7ff      	b.n	c0d004b2 <cx_trampoline_helper>

c0d004b2 <cx_trampoline_helper>:

.thumb_func
cx_trampoline_helper:
  ldr  r1, =_cx_trampoline
c0d004b2:	4902      	ldr	r1, [pc, #8]	; (c0d004bc <cx_trampoline_helper+0xa>)
  bx   r1
c0d004b4:	4708      	bx	r1
c0d004b6:	0000      	.short	0x0000
CX_TRAMPOLINE _NR_cx_swap_uint64                           cx_swap_uint64
c0d004b8:	0000006f 	.word	0x0000006f
  ldr  r1, =_cx_trampoline
c0d004bc:	00120001 	.word	0x00120001

c0d004c0 <run_read_test>:

#include "endian.h"
#include "testUtils.h"

void run_read_test()
{
c0d004c0:	b510      	push	{r4, lr}
c0d004c2:	2401      	movs	r4, #1
	const uint8_t* buffer = (uint8_t* )"\x47\x11\x22\x33\x44\x55\x66\x77\x88\x47";


	EXPECT_EQ(u1be_read(buffer), 0x47);
c0d004c4:	491e      	ldr	r1, [pc, #120]	; (c0d00540 <run_read_test+0x80>)
c0d004c6:	4479      	add	r1, pc
c0d004c8:	4620      	mov	r0, r4
c0d004ca:	f7ff fdd1 	bl	c0d00070 <assert>
	EXPECT_EQ(u1be_read(buffer + 1), 0x11);
c0d004ce:	491d      	ldr	r1, [pc, #116]	; (c0d00544 <run_read_test+0x84>)
c0d004d0:	4479      	add	r1, pc
c0d004d2:	4620      	mov	r0, r4
c0d004d4:	f7ff fdcc 	bl	c0d00070 <assert>
	EXPECT_EQ(u1be_read(buffer + 2), 0x22);
c0d004d8:	491b      	ldr	r1, [pc, #108]	; (c0d00548 <run_read_test+0x88>)
c0d004da:	4479      	add	r1, pc
c0d004dc:	4620      	mov	r0, r4
c0d004de:	f7ff fdc7 	bl	c0d00070 <assert>

	EXPECT_EQ(u2be_read(buffer), 0x4711);
c0d004e2:	491a      	ldr	r1, [pc, #104]	; (c0d0054c <run_read_test+0x8c>)
c0d004e4:	4479      	add	r1, pc
c0d004e6:	4620      	mov	r0, r4
c0d004e8:	f7ff fdc2 	bl	c0d00070 <assert>
	EXPECT_EQ(u2be_read(buffer + 1), 0x1122);
c0d004ec:	4918      	ldr	r1, [pc, #96]	; (c0d00550 <run_read_test+0x90>)
c0d004ee:	4479      	add	r1, pc
c0d004f0:	4620      	mov	r0, r4
c0d004f2:	f7ff fdbd 	bl	c0d00070 <assert>
	EXPECT_EQ(u2be_read(buffer + 2), 0x2233);
c0d004f6:	4917      	ldr	r1, [pc, #92]	; (c0d00554 <run_read_test+0x94>)
c0d004f8:	4479      	add	r1, pc
c0d004fa:	4620      	mov	r0, r4
c0d004fc:	f7ff fdb8 	bl	c0d00070 <assert>

	EXPECT_EQ(u4be_read(buffer), 0x47112233);
c0d00500:	4915      	ldr	r1, [pc, #84]	; (c0d00558 <run_read_test+0x98>)
c0d00502:	4479      	add	r1, pc
c0d00504:	4620      	mov	r0, r4
c0d00506:	f7ff fdb3 	bl	c0d00070 <assert>
	EXPECT_EQ(u4be_read(buffer + 1), 0x11223344);
c0d0050a:	4914      	ldr	r1, [pc, #80]	; (c0d0055c <run_read_test+0x9c>)
c0d0050c:	4479      	add	r1, pc
c0d0050e:	4620      	mov	r0, r4
c0d00510:	f7ff fdae 	bl	c0d00070 <assert>
	EXPECT_EQ(u4be_read(buffer + 2), 0x22334455);
c0d00514:	4912      	ldr	r1, [pc, #72]	; (c0d00560 <run_read_test+0xa0>)
c0d00516:	4479      	add	r1, pc
c0d00518:	4620      	mov	r0, r4
c0d0051a:	f7ff fda9 	bl	c0d00070 <assert>

	EXPECT_EQ(u8be_read(buffer), 0x4711223344556677);
c0d0051e:	4911      	ldr	r1, [pc, #68]	; (c0d00564 <run_read_test+0xa4>)
c0d00520:	4479      	add	r1, pc
c0d00522:	4620      	mov	r0, r4
c0d00524:	f7ff fda4 	bl	c0d00070 <assert>
	EXPECT_EQ(u8be_read(buffer + 1), 0x1122334455667788);
c0d00528:	490f      	ldr	r1, [pc, #60]	; (c0d00568 <run_read_test+0xa8>)
c0d0052a:	4479      	add	r1, pc
c0d0052c:	4620      	mov	r0, r4
c0d0052e:	f7ff fd9f 	bl	c0d00070 <assert>
	EXPECT_EQ(u8be_read(buffer + 2), 0x2233445566778847);
c0d00532:	490e      	ldr	r1, [pc, #56]	; (c0d0056c <run_read_test+0xac>)
c0d00534:	4479      	add	r1, pc
c0d00536:	4620      	mov	r0, r4
c0d00538:	f7ff fd9a 	bl	c0d00070 <assert>
}
c0d0053c:	bd10      	pop	{r4, pc}
c0d0053e:	46c0      	nop			; (mov r8, r8)
c0d00540:	000082c6 	.word	0x000082c6
c0d00544:	000082d1 	.word	0x000082d1
c0d00548:	000082dc 	.word	0x000082dc
c0d0054c:	000082e7 	.word	0x000082e7
c0d00550:	000082f2 	.word	0x000082f2
c0d00554:	000082fd 	.word	0x000082fd
c0d00558:	00008308 	.word	0x00008308
c0d0055c:	00008313 	.word	0x00008313
c0d00560:	0000831e 	.word	0x0000831e
c0d00564:	00008329 	.word	0x00008329
c0d00568:	00008334 	.word	0x00008334
c0d0056c:	0000833f 	.word	0x0000833f

c0d00570 <run_read_write_test>:

void run_read_write_test()
{
c0d00570:	b510      	push	{r4, lr}
c0d00572:	2401      	movs	r4, #1
		0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
		0x77 // postfix
	};

	u1be_write(buffer + 1, 0x74);
	EXPECT_EQ(u1be_read(buffer), 0x44);
c0d00574:	491e      	ldr	r1, [pc, #120]	; (c0d005f0 <run_read_write_test+0x80>)
c0d00576:	4479      	add	r1, pc
c0d00578:	4620      	mov	r0, r4
c0d0057a:	f7ff fd79 	bl	c0d00070 <assert>
	EXPECT_EQ(u1be_read(buffer + 1), 0x74);
c0d0057e:	491d      	ldr	r1, [pc, #116]	; (c0d005f4 <run_read_write_test+0x84>)
c0d00580:	4479      	add	r1, pc
c0d00582:	4620      	mov	r0, r4
c0d00584:	f7ff fd74 	bl	c0d00070 <assert>
	EXPECT_EQ(u1be_read(buffer + 2), 0x47);
c0d00588:	491b      	ldr	r1, [pc, #108]	; (c0d005f8 <run_read_write_test+0x88>)
c0d0058a:	4479      	add	r1, pc
c0d0058c:	4620      	mov	r0, r4
c0d0058e:	f7ff fd6f 	bl	c0d00070 <assert>


	u2be_write(buffer + 1, 0x2345);
	EXPECT_EQ(u1be_read(buffer), 0x44);
c0d00592:	491a      	ldr	r1, [pc, #104]	; (c0d005fc <run_read_write_test+0x8c>)
c0d00594:	4479      	add	r1, pc
c0d00596:	4620      	mov	r0, r4
c0d00598:	f7ff fd6a 	bl	c0d00070 <assert>
	EXPECT_EQ(u2be_read(buffer + 1), 0x2345);
c0d0059c:	4918      	ldr	r1, [pc, #96]	; (c0d00600 <run_read_write_test+0x90>)
c0d0059e:	4479      	add	r1, pc
c0d005a0:	4620      	mov	r0, r4
c0d005a2:	f7ff fd65 	bl	c0d00070 <assert>
	EXPECT_EQ(u1be_read(buffer + 3), 0x47);
c0d005a6:	4917      	ldr	r1, [pc, #92]	; (c0d00604 <run_read_write_test+0x94>)
c0d005a8:	4479      	add	r1, pc
c0d005aa:	4620      	mov	r0, r4
c0d005ac:	f7ff fd60 	bl	c0d00070 <assert>

	u4be_write(buffer + 1, 0x32547698);
	EXPECT_EQ(u1be_read(buffer), 0x44);
c0d005b0:	4915      	ldr	r1, [pc, #84]	; (c0d00608 <run_read_write_test+0x98>)
c0d005b2:	4479      	add	r1, pc
c0d005b4:	4620      	mov	r0, r4
c0d005b6:	f7ff fd5b 	bl	c0d00070 <assert>
	EXPECT_EQ(u4be_read(buffer + 1), 0x32547698);
c0d005ba:	4914      	ldr	r1, [pc, #80]	; (c0d0060c <run_read_write_test+0x9c>)
c0d005bc:	4479      	add	r1, pc
c0d005be:	4620      	mov	r0, r4
c0d005c0:	f7ff fd56 	bl	c0d00070 <assert>
	EXPECT_EQ(u1be_read(buffer + 5), 0x47);
c0d005c4:	4912      	ldr	r1, [pc, #72]	; (c0d00610 <run_read_write_test+0xa0>)
c0d005c6:	4479      	add	r1, pc
c0d005c8:	4620      	mov	r0, r4
c0d005ca:	f7ff fd51 	bl	c0d00070 <assert>

	u8be_write(buffer + 1, 0xa0b1c2d300112233);
	EXPECT_EQ(u1be_read(buffer), 0x44);
c0d005ce:	4911      	ldr	r1, [pc, #68]	; (c0d00614 <run_read_write_test+0xa4>)
c0d005d0:	4479      	add	r1, pc
c0d005d2:	4620      	mov	r0, r4
c0d005d4:	f7ff fd4c 	bl	c0d00070 <assert>
	EXPECT_EQ(u8be_read(buffer + 1), 0xa0b1c2d300112233);
c0d005d8:	490f      	ldr	r1, [pc, #60]	; (c0d00618 <run_read_write_test+0xa8>)
c0d005da:	4479      	add	r1, pc
c0d005dc:	4620      	mov	r0, r4
c0d005de:	f7ff fd47 	bl	c0d00070 <assert>
	EXPECT_EQ(u1be_read(buffer + 9), 0x77);
c0d005e2:	490e      	ldr	r1, [pc, #56]	; (c0d0061c <run_read_write_test+0xac>)
c0d005e4:	4479      	add	r1, pc
c0d005e6:	4620      	mov	r0, r4
c0d005e8:	f7ff fd42 	bl	c0d00070 <assert>
}
c0d005ec:	bd10      	pop	{r4, pc}
c0d005ee:	46c0      	nop			; (mov r8, r8)
c0d005f0:	00008312 	.word	0x00008312
c0d005f4:	0000831d 	.word	0x0000831d
c0d005f8:	00008328 	.word	0x00008328
c0d005fc:	00008333 	.word	0x00008333
c0d00600:	0000833e 	.word	0x0000833e
c0d00604:	00008349 	.word	0x00008349
c0d00608:	00008354 	.word	0x00008354
c0d0060c:	0000835f 	.word	0x0000835f
c0d00610:	0000836a 	.word	0x0000836a
c0d00614:	00008375 	.word	0x00008375
c0d00618:	00008380 	.word	0x00008380
c0d0061c:	0000838b 	.word	0x0000838b

c0d00620 <run_endian_test>:

void run_endian_test()
{
c0d00620:	b580      	push	{r7, lr}
	PRINTF("run_endian_test\n");
c0d00622:	4804      	ldr	r0, [pc, #16]	; (c0d00634 <run_endian_test+0x14>)
c0d00624:	4478      	add	r0, pc
c0d00626:	f002 fb0d 	bl	c0d02c44 <mcu_usb_printf>

	run_read_test();
c0d0062a:	f7ff ff49 	bl	c0d004c0 <run_read_test>
	run_read_write_test();
c0d0062e:	f7ff ff9f 	bl	c0d00570 <run_read_write_test>
}
c0d00632:	bd80      	pop	{r7, pc}
c0d00634:	00008360 	.word	0x00008360

c0d00638 <check_canonical>:

/**
 * EOS way to check if a signature is canonical :/
*/
unsigned char check_canonical(uint8_t *rs)
{
c0d00638:	4601      	mov	r1, r0
c0d0063a:	4602      	mov	r2, r0
c0d0063c:	3220      	adds	r2, #32
	return !(rs[0] & 0x80)
c0d0063e:	7800      	ldrb	r0, [r0, #0]
c0d00640:	b243      	sxtb	r3, r0
c0d00642:	2000      	movs	r0, #0
	       && !(rs[0] == 0 && !(rs[1] & 0x80))
c0d00644:	2b00      	cmp	r3, #0
c0d00646:	d40c      	bmi.n	c0d00662 <check_canonical+0x2a>
c0d00648:	d007      	beq.n	c0d0065a <check_canonical+0x22>
	       && !(rs[32] & 0x80)
c0d0064a:	7811      	ldrb	r1, [r2, #0]
c0d0064c:	b249      	sxtb	r1, r1
	       && !(rs[32] == 0 && !(rs[33] & 0x80));
c0d0064e:	2900      	cmp	r1, #0
c0d00650:	d407      	bmi.n	c0d00662 <check_canonical+0x2a>
c0d00652:	2900      	cmp	r1, #0
c0d00654:	d006      	beq.n	c0d00664 <check_canonical+0x2c>
c0d00656:	2001      	movs	r0, #1
	return !(rs[0] & 0x80)
c0d00658:	4770      	bx	lr
c0d0065a:	2301      	movs	r3, #1
	       && !(rs[0] == 0 && !(rs[1] & 0x80))
c0d0065c:	56c9      	ldrsb	r1, [r1, r3]
	       && !(rs[32] & 0x80)
c0d0065e:	2900      	cmp	r1, #0
c0d00660:	d4f3      	bmi.n	c0d0064a <check_canonical+0x12>
	return !(rs[0] & 0x80)
c0d00662:	4770      	bx	lr
	       && !(rs[32] == 0 && !(rs[33] & 0x80));
c0d00664:	7850      	ldrb	r0, [r2, #1]
c0d00666:	09c0      	lsrs	r0, r0, #7
	return !(rs[0] & 0x80)
c0d00668:	4770      	bx	lr

c0d0066a <ecdsa_der_to_sig>:
}

int ecdsa_der_to_sig(const uint8_t *der, uint8_t *sig)
{
c0d0066a:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0066c:	b083      	sub	sp, #12
c0d0066e:	460b      	mov	r3, r1
c0d00670:	4605      	mov	r5, r0
	int length;
	int offset = 2;
	int delta = 0;
	if (der[offset + 2] == 0) {
c0d00672:	7901      	ldrb	r1, [r0, #4]
c0d00674:	2900      	cmp	r1, #0
c0d00676:	d001      	beq.n	c0d0067c <ecdsa_der_to_sig+0x12>
c0d00678:	2704      	movs	r7, #4
c0d0067a:	e000      	b.n	c0d0067e <ecdsa_der_to_sig+0x14>
c0d0067c:	2705      	movs	r7, #5
c0d0067e:	2000      	movs	r0, #0
c0d00680:	2900      	cmp	r1, #0
c0d00682:	d001      	beq.n	c0d00688 <ecdsa_der_to_sig+0x1e>
c0d00684:	4602      	mov	r2, r0
c0d00686:	e000      	b.n	c0d0068a <ecdsa_der_to_sig+0x20>
c0d00688:	43c2      	mvns	r2, r0
c0d0068a:	78ec      	ldrb	r4, [r5, #3]
c0d0068c:	2900      	cmp	r1, #0
c0d0068e:	d001      	beq.n	c0d00694 <ecdsa_der_to_sig+0x2a>
c0d00690:	4626      	mov	r6, r4
c0d00692:	e000      	b.n	c0d00696 <ecdsa_der_to_sig+0x2c>
c0d00694:	1e66      	subs	r6, r4, #1
		offset += 3;
	} else {
		length = der[offset + 1];
		offset += 2;
	}
	if ((length < 0) || (length > 32)) {
c0d00696:	2e20      	cmp	r6, #32
c0d00698:	d84f      	bhi.n	c0d0073a <ecdsa_der_to_sig+0xd0>
		return 0;
	}
	while ((length + delta) < 32) {
c0d0069a:	2e20      	cmp	r6, #32
c0d0069c:	9302      	str	r3, [sp, #8]
c0d0069e:	d101      	bne.n	c0d006a4 <ecdsa_der_to_sig+0x3a>
c0d006a0:	2000      	movs	r0, #0
c0d006a2:	e011      	b.n	c0d006c8 <ecdsa_der_to_sig+0x5e>
c0d006a4:	2900      	cmp	r1, #0
c0d006a6:	9201      	str	r2, [sp, #4]
c0d006a8:	d001      	beq.n	c0d006ae <ecdsa_der_to_sig+0x44>
c0d006aa:	2020      	movs	r0, #32
c0d006ac:	e000      	b.n	c0d006b0 <ecdsa_der_to_sig+0x46>
c0d006ae:	2021      	movs	r0, #33	; 0x21
c0d006b0:	1b01      	subs	r1, r0, r4
		sig[delta++] = 0;
c0d006b2:	4618      	mov	r0, r3
c0d006b4:	f007 ff2a 	bl	c0d0850c <__aeabi_memclr>
c0d006b8:	9b02      	ldr	r3, [sp, #8]
	while ((length + delta) < 32) {
c0d006ba:	9801      	ldr	r0, [sp, #4]
c0d006bc:	1901      	adds	r1, r0, r4
c0d006be:	2000      	movs	r0, #0
		sig[delta++] = 0;
c0d006c0:	1c40      	adds	r0, r0, #1
	while ((length + delta) < 32) {
c0d006c2:	180a      	adds	r2, r1, r0
c0d006c4:	2a20      	cmp	r2, #32
c0d006c6:	d3fb      	bcc.n	c0d006c0 <ecdsa_der_to_sig+0x56>
	}
	memcpy(sig + delta, der + offset, length);
c0d006c8:	1818      	adds	r0, r3, r0
c0d006ca:	19e9      	adds	r1, r5, r7
c0d006cc:	4632      	mov	r2, r6
c0d006ce:	f007 ff22 	bl	c0d08516 <__aeabi_memcpy>

	delta = 0;
	offset += length;
c0d006d2:	19f0      	adds	r0, r6, r7
	if (der[offset + 2] == 0) {
c0d006d4:	1c87      	adds	r7, r0, #2
c0d006d6:	5de9      	ldrb	r1, [r5, r7]
c0d006d8:	2900      	cmp	r1, #0
c0d006da:	d100      	bne.n	c0d006de <ecdsa_der_to_sig+0x74>
c0d006dc:	1cc7      	adds	r7, r0, #3
c0d006de:	1940      	adds	r0, r0, r5
c0d006e0:	7846      	ldrb	r6, [r0, #1]
c0d006e2:	2900      	cmp	r1, #0
c0d006e4:	9b02      	ldr	r3, [sp, #8]
c0d006e6:	d001      	beq.n	c0d006ec <ecdsa_der_to_sig+0x82>
c0d006e8:	4634      	mov	r4, r6
c0d006ea:	e000      	b.n	c0d006ee <ecdsa_der_to_sig+0x84>
c0d006ec:	1e74      	subs	r4, r6, #1
c0d006ee:	2000      	movs	r0, #0
c0d006f0:	2900      	cmp	r1, #0
c0d006f2:	d001      	beq.n	c0d006f8 <ecdsa_der_to_sig+0x8e>
c0d006f4:	4602      	mov	r2, r0
c0d006f6:	e000      	b.n	c0d006fa <ecdsa_der_to_sig+0x90>
c0d006f8:	43c2      	mvns	r2, r0
		offset += 3;
	} else {
		length = der[offset + 1];
		offset += 2;
	}
	if ((length < 0) || (length > 32)) {
c0d006fa:	2c20      	cmp	r4, #32
c0d006fc:	d81d      	bhi.n	c0d0073a <ecdsa_der_to_sig+0xd0>
		return 0;
	}
	while ((length + delta) < 32) {
c0d006fe:	2c20      	cmp	r4, #32
c0d00700:	d101      	bne.n	c0d00706 <ecdsa_der_to_sig+0x9c>
c0d00702:	2000      	movs	r0, #0
c0d00704:	e012      	b.n	c0d0072c <ecdsa_der_to_sig+0xc2>
c0d00706:	2900      	cmp	r1, #0
c0d00708:	9201      	str	r2, [sp, #4]
c0d0070a:	d001      	beq.n	c0d00710 <ecdsa_der_to_sig+0xa6>
c0d0070c:	2020      	movs	r0, #32
c0d0070e:	e000      	b.n	c0d00712 <ecdsa_der_to_sig+0xa8>
c0d00710:	2021      	movs	r0, #33	; 0x21
c0d00712:	1b81      	subs	r1, r0, r6
c0d00714:	4618      	mov	r0, r3
c0d00716:	3020      	adds	r0, #32
		sig[32 + delta++] = 0;
c0d00718:	f007 fef8 	bl	c0d0850c <__aeabi_memclr>
c0d0071c:	9b02      	ldr	r3, [sp, #8]
	while ((length + delta) < 32) {
c0d0071e:	9801      	ldr	r0, [sp, #4]
c0d00720:	1981      	adds	r1, r0, r6
c0d00722:	2000      	movs	r0, #0
		sig[32 + delta++] = 0;
c0d00724:	1c40      	adds	r0, r0, #1
	while ((length + delta) < 32) {
c0d00726:	180a      	adds	r2, r1, r0
c0d00728:	2a20      	cmp	r2, #32
c0d0072a:	d3fb      	bcc.n	c0d00724 <ecdsa_der_to_sig+0xba>
	}
	memcpy(sig + 32 + delta, der + offset, length);
c0d0072c:	19e9      	adds	r1, r5, r7
c0d0072e:	1818      	adds	r0, r3, r0
c0d00730:	3020      	adds	r0, #32
c0d00732:	4622      	mov	r2, r4
c0d00734:	f007 feef 	bl	c0d08516 <__aeabi_memcpy>
c0d00738:	2001      	movs	r0, #1

	return 1;
}
c0d0073a:	b003      	add	sp, #12
c0d0073c:	bdf0      	pop	{r4, r5, r6, r7, pc}

c0d0073e <rng_rfc6979>:
void rng_rfc6979(unsigned char *rnd,
                 unsigned char *h1,
                 unsigned char *x, unsigned int x_len,
                 const unsigned char *q, unsigned int q_len,
                 unsigned char *V, unsigned char *K)
{
c0d0073e:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d00740:	b0c7      	sub	sp, #284	; 0x11c
c0d00742:	9309      	str	r3, [sp, #36]	; 0x24
c0d00744:	4614      	mov	r4, r2
c0d00746:	9105      	str	r1, [sp, #20]
c0d00748:	9003      	str	r0, [sp, #12]
c0d0074a:	a80c      	add	r0, sp, #48	; 0x30
c0d0074c:	3080      	adds	r0, #128	; 0x80
c0d0074e:	900b      	str	r0, [sp, #44]	; 0x2c
c0d00750:	2720      	movs	r7, #32
c0d00752:	9e4f      	ldr	r6, [sp, #316]	; 0x13c
c0d00754:	9d4e      	ldr	r5, [sp, #312]	; 0x138
c0d00756:	984d      	ldr	r0, [sp, #308]	; 0x134
c0d00758:	9004      	str	r0, [sp, #16]
c0d0075a:	984c      	ldr	r0, [sp, #304]	; 0x130
c0d0075c:	9002      	str	r0, [sp, #8]
c0d0075e:	960a      	str	r6, [sp, #40]	; 0x28
c0d00760:	9508      	str	r5, [sp, #32]
c0d00762:	1c78      	adds	r0, r7, #1
c0d00764:	9007      	str	r0, [sp, #28]
c0d00766:	9706      	str	r7, [sp, #24]
	//a. h1 as input

	//loop for a candidate
	found = 0;
	while (!found) {
		if (x) {
c0d00768:	2c00      	cmp	r4, #0
c0d0076a:	d100      	bne.n	c0d0076e <rng_rfc6979+0x30>
c0d0076c:	e0b2      	b.n	c0d008d4 <rng_rfc6979+0x196>
c0d0076e:	2201      	movs	r2, #1
			//b.  Set:          V = 0x01 0x01 0x01 ... 0x01
			memset(V, 0x01, h_len);
c0d00770:	4628      	mov	r0, r5
c0d00772:	4639      	mov	r1, r7
c0d00774:	f007 fed7 	bl	c0d08526 <__aeabi_memset>
			//c. Set: K = 0x00 0x00 0x00 ... 0x00
			memset(K, 0x00, h_len);
c0d00778:	4630      	mov	r0, r6
c0d0077a:	4639      	mov	r1, r7
c0d0077c:	f007 fec6 	bl	c0d0850c <__aeabi_memclr>
c0d00780:	2000      	movs	r0, #0
			//d.  Set: K = HMAC_K(V || 0x00 || int2octets(x) || bits2octets(h1))
			V[h_len] = 0;
c0d00782:	55e8      	strb	r0, [r5, r7]
c0d00784:	a80c      	add	r0, sp, #48	; 0x30
c0d00786:	462f      	mov	r7, r5
c0d00788:	2520      	movs	r5, #32
 */
cx_err_t cx_hmac_sha256_init_no_throw(cx_hmac_sha256_t *hmac, const uint8_t *key, size_t key_len);

static inline int cx_hmac_sha256_init ( cx_hmac_sha256_t * hmac, const unsigned char * key, unsigned int key_len )
{
  CX_THROW(cx_hmac_sha256_init_no_throw(hmac, key, key_len));
c0d0078a:	4631      	mov	r1, r6
c0d0078c:	462a      	mov	r2, r5
c0d0078e:	f7ff fe7b 	bl	c0d00488 <cx_hmac_sha256_init_no_throw>
c0d00792:	2800      	cmp	r0, #0
c0d00794:	d000      	beq.n	c0d00798 <rng_rfc6979+0x5a>
c0d00796:	e113      	b.n	c0d009c0 <rng_rfc6979+0x282>
 */
cx_err_t cx_hmac_no_throw(cx_hmac_t *hmac, uint32_t mode, const uint8_t *in, size_t len, uint8_t *mac, size_t mac_len);

static inline int cx_hmac ( cx_hmac_t * hmac, int mode, const unsigned char * in, unsigned int len, unsigned char * mac, unsigned int mac_len )
{
  CX_THROW(cx_hmac_no_throw(hmac, mode, in, len, mac, mac_len));
c0d00798:	9600      	str	r6, [sp, #0]
c0d0079a:	9501      	str	r5, [sp, #4]
c0d0079c:	a80c      	add	r0, sp, #48	; 0x30
c0d0079e:	2100      	movs	r1, #0
c0d007a0:	463a      	mov	r2, r7
c0d007a2:	9b07      	ldr	r3, [sp, #28]
c0d007a4:	f7ff fe6a 	bl	c0d0047c <cx_hmac_no_throw>
c0d007a8:	2800      	cmp	r0, #0
c0d007aa:	d000      	beq.n	c0d007ae <rng_rfc6979+0x70>
c0d007ac:	e108      	b.n	c0d009c0 <rng_rfc6979+0x282>

  switch (hmac->hash_ctx.info->md_type) {
c0d007ae:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d007b0:	6800      	ldr	r0, [r0, #0]
c0d007b2:	7800      	ldrb	r0, [r0, #0]
c0d007b4:	1e40      	subs	r0, r0, #1
c0d007b6:	2805      	cmp	r0, #5
c0d007b8:	9f06      	ldr	r7, [sp, #24]
c0d007ba:	d300      	bcc.n	c0d007be <rng_rfc6979+0x80>
c0d007bc:	e102      	b.n	c0d009c4 <rng_rfc6979+0x286>
  CX_THROW(cx_hmac_no_throw(hmac, mode, in, len, mac, mac_len));
c0d007be:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d007c0:	9000      	str	r0, [sp, #0]
c0d007c2:	9501      	str	r5, [sp, #4]
c0d007c4:	a80c      	add	r0, sp, #48	; 0x30
c0d007c6:	2100      	movs	r1, #0
c0d007c8:	4622      	mov	r2, r4
c0d007ca:	9b09      	ldr	r3, [sp, #36]	; 0x24
c0d007cc:	f7ff fe56 	bl	c0d0047c <cx_hmac_no_throw>
c0d007d0:	2800      	cmp	r0, #0
c0d007d2:	d000      	beq.n	c0d007d6 <rng_rfc6979+0x98>
c0d007d4:	e0f4      	b.n	c0d009c0 <rng_rfc6979+0x282>
  switch (hmac->hash_ctx.info->md_type) {
c0d007d6:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d007d8:	6800      	ldr	r0, [r0, #0]
c0d007da:	7800      	ldrb	r0, [r0, #0]
c0d007dc:	1e40      	subs	r0, r0, #1
c0d007de:	2805      	cmp	r0, #5
c0d007e0:	d300      	bcc.n	c0d007e4 <rng_rfc6979+0xa6>
c0d007e2:	e0ef      	b.n	c0d009c4 <rng_rfc6979+0x286>
  CX_THROW(cx_hmac_no_throw(hmac, mode, in, len, mac, mac_len));
c0d007e4:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d007e6:	9000      	str	r0, [sp, #0]
c0d007e8:	9501      	str	r5, [sp, #4]
c0d007ea:	a80c      	add	r0, sp, #48	; 0x30
c0d007ec:	2101      	movs	r1, #1
c0d007ee:	9a05      	ldr	r2, [sp, #20]
c0d007f0:	463b      	mov	r3, r7
c0d007f2:	f7ff fe43 	bl	c0d0047c <cx_hmac_no_throw>
c0d007f6:	2800      	cmp	r0, #0
c0d007f8:	d000      	beq.n	c0d007fc <rng_rfc6979+0xbe>
c0d007fa:	e0e1      	b.n	c0d009c0 <rng_rfc6979+0x282>
  switch (hmac->hash_ctx.info->md_type) {
c0d007fc:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d007fe:	6800      	ldr	r0, [r0, #0]
c0d00800:	7800      	ldrb	r0, [r0, #0]
c0d00802:	1e40      	subs	r0, r0, #1
c0d00804:	2805      	cmp	r0, #5
c0d00806:	9d08      	ldr	r5, [sp, #32]
c0d00808:	d300      	bcc.n	c0d0080c <rng_rfc6979+0xce>
c0d0080a:	e0db      	b.n	c0d009c4 <rng_rfc6979+0x286>
c0d0080c:	a80c      	add	r0, sp, #48	; 0x30
c0d0080e:	2620      	movs	r6, #32
  CX_THROW(cx_hmac_sha256_init_no_throw(hmac, key, key_len));
c0d00810:	990a      	ldr	r1, [sp, #40]	; 0x28
c0d00812:	4632      	mov	r2, r6
c0d00814:	f7ff fe38 	bl	c0d00488 <cx_hmac_sha256_init_no_throw>
c0d00818:	2800      	cmp	r0, #0
c0d0081a:	d000      	beq.n	c0d0081e <rng_rfc6979+0xe0>
c0d0081c:	e0d0      	b.n	c0d009c0 <rng_rfc6979+0x282>
  CX_THROW(cx_hmac_no_throw(hmac, mode, in, len, mac, mac_len));
c0d0081e:	9500      	str	r5, [sp, #0]
c0d00820:	9601      	str	r6, [sp, #4]
c0d00822:	a80c      	add	r0, sp, #48	; 0x30
c0d00824:	2601      	movs	r6, #1
c0d00826:	4631      	mov	r1, r6
c0d00828:	462a      	mov	r2, r5
c0d0082a:	463b      	mov	r3, r7
c0d0082c:	f7ff fe26 	bl	c0d0047c <cx_hmac_no_throw>
c0d00830:	2800      	cmp	r0, #0
c0d00832:	d000      	beq.n	c0d00836 <rng_rfc6979+0xf8>
c0d00834:	e0c4      	b.n	c0d009c0 <rng_rfc6979+0x282>
  switch (hmac->hash_ctx.info->md_type) {
c0d00836:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d00838:	6800      	ldr	r0, [r0, #0]
c0d0083a:	7800      	ldrb	r0, [r0, #0]
c0d0083c:	1e40      	subs	r0, r0, #1
c0d0083e:	2805      	cmp	r0, #5
c0d00840:	d300      	bcc.n	c0d00844 <rng_rfc6979+0x106>
c0d00842:	e0bf      	b.n	c0d009c4 <rng_rfc6979+0x286>
			cx_hmac((cx_hmac_t *)&hmac, CX_LAST, h1, h_len, K, 32);
			//e.  Set: V = HMAC_K(V)
			cx_hmac_sha256_init(&hmac, K, 32);
			cx_hmac((cx_hmac_t *)&hmac, CX_LAST, V, h_len, V, 32);
			//f.  Set:  K = HMAC_K(V || 0x01 || int2octets(x) || bits2octets(h1))
			V[h_len] = 1;
c0d00844:	55ee      	strb	r6, [r5, r7]
c0d00846:	a80c      	add	r0, sp, #48	; 0x30
c0d00848:	2620      	movs	r6, #32
c0d0084a:	462f      	mov	r7, r5
c0d0084c:	9d0a      	ldr	r5, [sp, #40]	; 0x28
  CX_THROW(cx_hmac_sha256_init_no_throw(hmac, key, key_len));
c0d0084e:	4629      	mov	r1, r5
c0d00850:	4632      	mov	r2, r6
c0d00852:	f7ff fe19 	bl	c0d00488 <cx_hmac_sha256_init_no_throw>
c0d00856:	2800      	cmp	r0, #0
c0d00858:	d000      	beq.n	c0d0085c <rng_rfc6979+0x11e>
c0d0085a:	e0b1      	b.n	c0d009c0 <rng_rfc6979+0x282>
  CX_THROW(cx_hmac_no_throw(hmac, mode, in, len, mac, mac_len));
c0d0085c:	9500      	str	r5, [sp, #0]
c0d0085e:	9601      	str	r6, [sp, #4]
c0d00860:	a80c      	add	r0, sp, #48	; 0x30
c0d00862:	2100      	movs	r1, #0
c0d00864:	463a      	mov	r2, r7
c0d00866:	9b07      	ldr	r3, [sp, #28]
c0d00868:	f7ff fe08 	bl	c0d0047c <cx_hmac_no_throw>
c0d0086c:	2800      	cmp	r0, #0
c0d0086e:	d000      	beq.n	c0d00872 <rng_rfc6979+0x134>
c0d00870:	e0a6      	b.n	c0d009c0 <rng_rfc6979+0x282>
c0d00872:	463d      	mov	r5, r7
  switch (hmac->hash_ctx.info->md_type) {
c0d00874:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d00876:	6800      	ldr	r0, [r0, #0]
c0d00878:	7800      	ldrb	r0, [r0, #0]
c0d0087a:	1e40      	subs	r0, r0, #1
c0d0087c:	2805      	cmp	r0, #5
c0d0087e:	9f06      	ldr	r7, [sp, #24]
c0d00880:	d300      	bcc.n	c0d00884 <rng_rfc6979+0x146>
c0d00882:	e09f      	b.n	c0d009c4 <rng_rfc6979+0x286>
  CX_THROW(cx_hmac_no_throw(hmac, mode, in, len, mac, mac_len));
c0d00884:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d00886:	9000      	str	r0, [sp, #0]
c0d00888:	9601      	str	r6, [sp, #4]
c0d0088a:	a80c      	add	r0, sp, #48	; 0x30
c0d0088c:	2100      	movs	r1, #0
c0d0088e:	4622      	mov	r2, r4
c0d00890:	9b09      	ldr	r3, [sp, #36]	; 0x24
c0d00892:	f7ff fdf3 	bl	c0d0047c <cx_hmac_no_throw>
c0d00896:	2800      	cmp	r0, #0
c0d00898:	d000      	beq.n	c0d0089c <rng_rfc6979+0x15e>
c0d0089a:	e091      	b.n	c0d009c0 <rng_rfc6979+0x282>
  switch (hmac->hash_ctx.info->md_type) {
c0d0089c:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d0089e:	6800      	ldr	r0, [r0, #0]
c0d008a0:	7800      	ldrb	r0, [r0, #0]
c0d008a2:	1e40      	subs	r0, r0, #1
c0d008a4:	2805      	cmp	r0, #5
c0d008a6:	d300      	bcc.n	c0d008aa <rng_rfc6979+0x16c>
c0d008a8:	e08c      	b.n	c0d009c4 <rng_rfc6979+0x286>
  CX_THROW(cx_hmac_no_throw(hmac, mode, in, len, mac, mac_len));
c0d008aa:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d008ac:	9000      	str	r0, [sp, #0]
c0d008ae:	9601      	str	r6, [sp, #4]
c0d008b0:	a80c      	add	r0, sp, #48	; 0x30
c0d008b2:	2101      	movs	r1, #1
c0d008b4:	9a05      	ldr	r2, [sp, #20]
c0d008b6:	463b      	mov	r3, r7
c0d008b8:	f7ff fde0 	bl	c0d0047c <cx_hmac_no_throw>
c0d008bc:	2800      	cmp	r0, #0
c0d008be:	d17f      	bne.n	c0d009c0 <rng_rfc6979+0x282>
  switch (hmac->hash_ctx.info->md_type) {
c0d008c0:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d008c2:	6800      	ldr	r0, [r0, #0]
c0d008c4:	7800      	ldrb	r0, [r0, #0]
c0d008c6:	1e40      	subs	r0, r0, #1
c0d008c8:	2805      	cmp	r0, #5
c0d008ca:	d27b      	bcs.n	c0d009c4 <rng_rfc6979+0x286>
c0d008cc:	a80c      	add	r0, sp, #48	; 0x30
c0d008ce:	2420      	movs	r4, #32
c0d008d0:	9e0a      	ldr	r6, [sp, #40]	; 0x28
c0d008d2:	e01b      	b.n	c0d0090c <rng_rfc6979+0x1ce>
c0d008d4:	2000      	movs	r0, #0
			cx_hmac((cx_hmac_t *)&hmac, CX_LAST, V, h_len, V, 32);
			// initial setup only once
			x = NULL;
		} else {
			// h.3  K = HMAC_K(V || 0x00)
			V[h_len] = 0;
c0d008d6:	55e8      	strb	r0, [r5, r7]
c0d008d8:	a80c      	add	r0, sp, #48	; 0x30
c0d008da:	2420      	movs	r4, #32
  CX_THROW(cx_hmac_sha256_init_no_throw(hmac, key, key_len));
c0d008dc:	4631      	mov	r1, r6
c0d008de:	4622      	mov	r2, r4
c0d008e0:	f7ff fdd2 	bl	c0d00488 <cx_hmac_sha256_init_no_throw>
c0d008e4:	2800      	cmp	r0, #0
c0d008e6:	d16b      	bne.n	c0d009c0 <rng_rfc6979+0x282>
  CX_THROW(cx_hmac_no_throw(hmac, mode, in, len, mac, mac_len));
c0d008e8:	9600      	str	r6, [sp, #0]
c0d008ea:	9401      	str	r4, [sp, #4]
c0d008ec:	a80c      	add	r0, sp, #48	; 0x30
c0d008ee:	2101      	movs	r1, #1
c0d008f0:	462a      	mov	r2, r5
c0d008f2:	9b07      	ldr	r3, [sp, #28]
c0d008f4:	f7ff fdc2 	bl	c0d0047c <cx_hmac_no_throw>
c0d008f8:	2800      	cmp	r0, #0
c0d008fa:	d161      	bne.n	c0d009c0 <rng_rfc6979+0x282>
  switch (hmac->hash_ctx.info->md_type) {
c0d008fc:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d008fe:	6800      	ldr	r0, [r0, #0]
c0d00900:	7800      	ldrb	r0, [r0, #0]
c0d00902:	1e40      	subs	r0, r0, #1
c0d00904:	2805      	cmp	r0, #5
c0d00906:	d25d      	bcs.n	c0d009c4 <rng_rfc6979+0x286>
c0d00908:	a80c      	add	r0, sp, #48	; 0x30
c0d0090a:	2420      	movs	r4, #32
c0d0090c:	4631      	mov	r1, r6
c0d0090e:	4622      	mov	r2, r4
c0d00910:	f7ff fdba 	bl	c0d00488 <cx_hmac_sha256_init_no_throw>
c0d00914:	2800      	cmp	r0, #0
c0d00916:	d153      	bne.n	c0d009c0 <rng_rfc6979+0x282>
c0d00918:	9500      	str	r5, [sp, #0]
c0d0091a:	9401      	str	r4, [sp, #4]
c0d0091c:	a80c      	add	r0, sp, #48	; 0x30
c0d0091e:	2101      	movs	r1, #1
c0d00920:	462a      	mov	r2, r5
c0d00922:	463b      	mov	r3, r7
c0d00924:	f7ff fdaa 	bl	c0d0047c <cx_hmac_no_throw>
c0d00928:	2800      	cmp	r0, #0
c0d0092a:	d149      	bne.n	c0d009c0 <rng_rfc6979+0x282>
c0d0092c:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d0092e:	6800      	ldr	r0, [r0, #0]
c0d00930:	7800      	ldrb	r0, [r0, #0]
c0d00932:	1e40      	subs	r0, r0, #1
c0d00934:	2805      	cmp	r0, #5
c0d00936:	d245      	bcs.n	c0d009c4 <rng_rfc6979+0x286>
c0d00938:	2400      	movs	r4, #0
		 *     T = T || V
		 * is replace by
		 *     V = HMAC_K(V)
		 */
		x_len = q_len;
		while (x_len) {
c0d0093a:	9804      	ldr	r0, [sp, #16]
c0d0093c:	2800      	cmp	r0, #0
c0d0093e:	9409      	str	r4, [sp, #36]	; 0x24
c0d00940:	d100      	bne.n	c0d00944 <rng_rfc6979+0x206>
c0d00942:	e711      	b.n	c0d00768 <rng_rfc6979+0x2a>
c0d00944:	463d      	mov	r5, r7
c0d00946:	9e04      	ldr	r6, [sp, #16]
c0d00948:	a80c      	add	r0, sp, #48	; 0x30
c0d0094a:	2420      	movs	r4, #32
  CX_THROW(cx_hmac_sha256_init_no_throw(hmac, key, key_len));
c0d0094c:	990a      	ldr	r1, [sp, #40]	; 0x28
c0d0094e:	4622      	mov	r2, r4
c0d00950:	f7ff fd9a 	bl	c0d00488 <cx_hmac_sha256_init_no_throw>
			if (x_len < h_len) {
c0d00954:	42ae      	cmp	r6, r5
c0d00956:	4637      	mov	r7, r6
c0d00958:	d300      	bcc.n	c0d0095c <rng_rfc6979+0x21e>
c0d0095a:	462f      	mov	r7, r5
c0d0095c:	2800      	cmp	r0, #0
c0d0095e:	d12f      	bne.n	c0d009c0 <rng_rfc6979+0x282>
c0d00960:	9d08      	ldr	r5, [sp, #32]
  CX_THROW(cx_hmac_no_throw(hmac, mode, in, len, mac, mac_len));
c0d00962:	9500      	str	r5, [sp, #0]
c0d00964:	9401      	str	r4, [sp, #4]
c0d00966:	a80c      	add	r0, sp, #48	; 0x30
c0d00968:	2101      	movs	r1, #1
c0d0096a:	462a      	mov	r2, r5
c0d0096c:	463b      	mov	r3, r7
c0d0096e:	f7ff fd85 	bl	c0d0047c <cx_hmac_no_throw>
c0d00972:	2800      	cmp	r0, #0
c0d00974:	d124      	bne.n	c0d009c0 <rng_rfc6979+0x282>
  switch (hmac->hash_ctx.info->md_type) {
c0d00976:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d00978:	6800      	ldr	r0, [r0, #0]
c0d0097a:	7800      	ldrb	r0, [r0, #0]
c0d0097c:	1e40      	subs	r0, r0, #1
c0d0097e:	2805      	cmp	r0, #5
c0d00980:	d220      	bcs.n	c0d009c4 <rng_rfc6979+0x286>
				h_len = x_len;
			}
			cx_hmac_sha256_init(&hmac, K, 32);
			cx_hmac((cx_hmac_t *)&hmac, CX_LAST, V, h_len, V, 32);
			memcpy(rnd, V, h_len);
c0d00982:	9803      	ldr	r0, [sp, #12]
c0d00984:	4629      	mov	r1, r5
c0d00986:	463a      	mov	r2, r7
c0d00988:	f007 fdc5 	bl	c0d08516 <__aeabi_memcpy>
			x_len -= h_len;
c0d0098c:	1bf6      	subs	r6, r6, r7
c0d0098e:	463d      	mov	r5, r7
		while (x_len) {
c0d00990:	d1da      	bne.n	c0d00948 <rng_rfc6979+0x20a>
c0d00992:	2400      	movs	r4, #0
c0d00994:	9a04      	ldr	r2, [sp, #16]
		}

		// h.3 Check T is < n
		for (i = 0; i < q_len; i++) {
c0d00996:	2a00      	cmp	r2, #0
c0d00998:	9409      	str	r4, [sp, #36]	; 0x24
c0d0099a:	9d08      	ldr	r5, [sp, #32]
c0d0099c:	4628      	mov	r0, r5
c0d0099e:	9902      	ldr	r1, [sp, #8]
c0d009a0:	9e0a      	ldr	r6, [sp, #40]	; 0x28
c0d009a2:	d100      	bne.n	c0d009a6 <rng_rfc6979+0x268>
c0d009a4:	e6dd      	b.n	c0d00762 <rng_rfc6979+0x24>
			if (V[i] < q[i]) {
c0d009a6:	780b      	ldrb	r3, [r1, #0]
c0d009a8:	7804      	ldrb	r4, [r0, #0]
c0d009aa:	429c      	cmp	r4, r3
c0d009ac:	d306      	bcc.n	c0d009bc <rng_rfc6979+0x27e>
		for (i = 0; i < q_len; i++) {
c0d009ae:	1c40      	adds	r0, r0, #1
c0d009b0:	1c49      	adds	r1, r1, #1
c0d009b2:	1e52      	subs	r2, r2, #1
c0d009b4:	d1f7      	bne.n	c0d009a6 <rng_rfc6979+0x268>
c0d009b6:	2400      	movs	r4, #0
c0d009b8:	9409      	str	r4, [sp, #36]	; 0x24
c0d009ba:	e6d2      	b.n	c0d00762 <rng_rfc6979+0x24>
				found = 1;
				break;
			}
		}
	}
}
c0d009bc:	b047      	add	sp, #284	; 0x11c
c0d009be:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d009c0:	f001 fbe8 	bl	c0d02194 <os_longjmp>
c0d009c4:	2077      	movs	r0, #119	; 0x77
c0d009c6:	43c0      	mvns	r0, r0
c0d009c8:	f001 fbe4 	bl	c0d02194 <os_longjmp>

c0d009cc <getPublicKey_handleAPDU>:
        uint8_t p2,
        uint8_t* wireDataBuffer,
        size_t wireDataSize,
        bool isNewCall
)
{
c0d009cc:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d009ce:	b083      	sub	sp, #12
c0d009d0:	4604      	mov	r4, r0
c0d009d2:	9808      	ldr	r0, [sp, #32]
	VALIDATE(isNewCall, ERR_INVALID_STATE);
c0d009d4:	2800      	cmp	r0, #0
c0d009d6:	d076      	beq.n	c0d00ac6 <getPublicKey_handleAPDU+0xfa>
	VALIDATE(p1 == P1_SHOW_PUBKEY || p1 == P1_DO_NOT_SHOW_PUBKEY, ERR_INVALID_REQUEST_PARAMETERS);
c0d009d8:	1e60      	subs	r0, r4, #1
c0d009da:	2802      	cmp	r0, #2
c0d009dc:	d27e      	bcs.n	c0d00adc <getPublicKey_handleAPDU+0x110>
c0d009de:	9202      	str	r2, [sp, #8]
	VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d009e0:	2900      	cmp	r1, #0
c0d009e2:	d000      	beq.n	c0d009e6 <getPublicKey_handleAPDU+0x1a>
c0d009e4:	e080      	b.n	c0d00ae8 <getPublicKey_handleAPDU+0x11c>
c0d009e6:	461d      	mov	r5, r3

	explicit_bzero(ctx, SIZEOF(*ctx));
c0d009e8:	4f4d      	ldr	r7, [pc, #308]	; (c0d00b20 <getPublicKey_handleAPDU+0x154>)
c0d009ea:	2184      	movs	r1, #132	; 0x84
c0d009ec:	4638      	mov	r0, r7
c0d009ee:	f007 fda1 	bl	c0d08534 <explicit_bzero>
c0d009f2:	2680      	movs	r6, #128	; 0x80
c0d009f4:	2000      	movs	r0, #0
c0d009f6:	9001      	str	r0, [sp, #4]
	ctx->stage = GET_KEY_STAGE_INIT;
	ctx->ui_step = UI_STEP_NONE;
c0d009f8:	51b8      	str	r0, [r7, r6]
c0d009fa:	2014      	movs	r0, #20
	ctx->stage = GET_KEY_STAGE_INIT;
c0d009fc:	7038      	strb	r0, [r7, #0]

	CHECK_STAGE(GET_KEY_STAGE_INIT);
	ASSERT(wireDataSize < BUFFER_SIZE_PARANOIA);
c0d009fe:	0aa9      	lsrs	r1, r5, #10
c0d00a00:	4248      	negs	r0, r1
c0d00a02:	4148      	adcs	r0, r1
c0d00a04:	494c      	ldr	r1, [pc, #304]	; (c0d00b38 <getPublicKey_handleAPDU+0x16c>)
c0d00a06:	4479      	add	r1, pc
c0d00a08:	f7ff fb32 	bl	c0d00070 <assert>

	{
		ctx->show_or_not = p1;
c0d00a0c:	707c      	strb	r4, [r7, #1]

		// parse
		TRACE_BUFFER(wireDataBuffer, wireDataSize);
c0d00a0e:	484b      	ldr	r0, [pc, #300]	; (c0d00b3c <getPublicKey_handleAPDU+0x170>)
c0d00a10:	4478      	add	r0, pc
c0d00a12:	494b      	ldr	r1, [pc, #300]	; (c0d00b40 <getPublicKey_handleAPDU+0x174>)
c0d00a14:	4479      	add	r1, pc
c0d00a16:	2295      	movs	r2, #149	; 0x95
c0d00a18:	f002 f914 	bl	c0d02c44 <mcu_usb_printf>
c0d00a1c:	4849      	ldr	r0, [pc, #292]	; (c0d00b44 <getPublicKey_handleAPDU+0x178>)
c0d00a1e:	4478      	add	r0, pc
c0d00a20:	4629      	mov	r1, r5
c0d00a22:	9c02      	ldr	r4, [sp, #8]
c0d00a24:	4622      	mov	r2, r4
c0d00a26:	f002 f90d 	bl	c0d02c44 <mcu_usb_printf>
c0d00a2a:	4847      	ldr	r0, [pc, #284]	; (c0d00b48 <getPublicKey_handleAPDU+0x17c>)
c0d00a2c:	4478      	add	r0, pc
c0d00a2e:	f002 f909 	bl	c0d02c44 <mcu_usb_printf>

		size_t parsedSize = bip44_parseFromWire(&ctx->pathSpec, wireDataBuffer, wireDataSize);
c0d00a32:	1d3f      	adds	r7, r7, #4
c0d00a34:	4638      	mov	r0, r7
c0d00a36:	4621      	mov	r1, r4
c0d00a38:	462a      	mov	r2, r5
c0d00a3a:	f7ff fb21 	bl	c0d00080 <bip44_parseFromWire>
		VALIDATE(parsedSize == wireDataSize, ERR_INVALID_DATA);
c0d00a3e:	42a8      	cmp	r0, r5
c0d00a40:	d15c      	bne.n	c0d00afc <getPublicKey_handleAPDU+0x130>
c0d00a42:	9602      	str	r6, [sp, #8]
c0d00a44:	4c36      	ldr	r4, [pc, #216]	; (c0d00b20 <getPublicKey_handleAPDU+0x154>)
	ASSERT(ctx->ui_step == UI_STEP_NONE); // make sure no ui state machine is running
c0d00a46:	59a1      	ldr	r1, [r4, r6]
c0d00a48:	4248      	negs	r0, r1
c0d00a4a:	4148      	adcs	r0, r1
c0d00a4c:	493f      	ldr	r1, [pc, #252]	; (c0d00b4c <getPublicKey_handleAPDU+0x180>)
c0d00a4e:	4479      	add	r1, pc
c0d00a50:	f7ff fb0e 	bl	c0d00070 <assert>
c0d00a54:	267c      	movs	r6, #124	; 0x7c
	ctx->responseReadyMagic = 0;
c0d00a56:	9801      	ldr	r0, [sp, #4]
c0d00a58:	53a0      	strh	r0, [r4, r6]
	security_policy_t policy = policyForGetPublicKey(&ctx->pathSpec, ctx->show_or_not);
c0d00a5a:	7861      	ldrb	r1, [r4, #1]
c0d00a5c:	4638      	mov	r0, r7
c0d00a5e:	f002 fcdb 	bl	c0d03418 <policyForGetPublicKey>
c0d00a62:	4605      	mov	r5, r0
	TRACE("Policy: %d", (int) policy);
c0d00a64:	483a      	ldr	r0, [pc, #232]	; (c0d00b50 <getPublicKey_handleAPDU+0x184>)
c0d00a66:	4478      	add	r0, pc
c0d00a68:	493a      	ldr	r1, [pc, #232]	; (c0d00b54 <getPublicKey_handleAPDU+0x188>)
c0d00a6a:	4479      	add	r1, pc
c0d00a6c:	2263      	movs	r2, #99	; 0x63
c0d00a6e:	f002 f8e9 	bl	c0d02c44 <mcu_usb_printf>
c0d00a72:	4839      	ldr	r0, [pc, #228]	; (c0d00b58 <getPublicKey_handleAPDU+0x18c>)
c0d00a74:	4478      	add	r0, pc
c0d00a76:	4629      	mov	r1, r5
c0d00a78:	f002 f8e4 	bl	c0d02c44 <mcu_usb_printf>
c0d00a7c:	4837      	ldr	r0, [pc, #220]	; (c0d00b5c <getPublicKey_handleAPDU+0x190>)
c0d00a7e:	4478      	add	r0, pc
c0d00a80:	f002 f8e0 	bl	c0d02c44 <mcu_usb_printf>

security_policy_t policyDerivePrivateKey(const bip44_path_t* pathSpec);

static inline void ENSURE_NOT_DENIED(security_policy_t policy)
{
	if (policy == POLICY_DENY) {
c0d00a84:	2d01      	cmp	r5, #1
c0d00a86:	d044      	beq.n	c0d00b12 <getPublicKey_handleAPDU+0x146>
		derivePublicKey(
c0d00a88:	4621      	mov	r1, r4
c0d00a8a:	3130      	adds	r1, #48	; 0x30
c0d00a8c:	4638      	mov	r0, r7
c0d00a8e:	f000 ff5d 	bl	c0d0194c <derivePublicKey>
c0d00a92:	4824      	ldr	r0, [pc, #144]	; (c0d00b24 <getPublicKey_handleAPDU+0x158>)
		ctx->responseReadyMagic = RESPONSE_READY_MAGIC;
c0d00a94:	53a0      	strh	r0, [r4, r6]
	switch (policy) {
c0d00a96:	2d02      	cmp	r5, #2
c0d00a98:	d008      	beq.n	c0d00aac <getPublicKey_handleAPDU+0xe0>
c0d00a9a:	2d03      	cmp	r5, #3
c0d00a9c:	9902      	ldr	r1, [sp, #8]
c0d00a9e:	d003      	beq.n	c0d00aa8 <getPublicKey_handleAPDU+0xdc>
c0d00aa0:	2d04      	cmp	r5, #4
c0d00aa2:	d107      	bne.n	c0d00ab4 <getPublicKey_handleAPDU+0xe8>
c0d00aa4:	20c8      	movs	r0, #200	; 0xc8
c0d00aa6:	e003      	b.n	c0d00ab0 <getPublicKey_handleAPDU+0xe4>
c0d00aa8:	20ca      	movs	r0, #202	; 0xca
c0d00aaa:	e001      	b.n	c0d00ab0 <getPublicKey_handleAPDU+0xe4>
c0d00aac:	20cc      	movs	r0, #204	; 0xcc
		CASE(POLICY_ALLOW_WITHOUT_PROMPT,   GET_KEY_UI_STEP_RESPOND);
c0d00aae:	9902      	ldr	r1, [sp, #8]
c0d00ab0:	5060      	str	r0, [r4, r1]
c0d00ab2:	e004      	b.n	c0d00abe <getPublicKey_handleAPDU+0xf2>
c0d00ab4:	2000      	movs	r0, #0
		ASSERT(false);
c0d00ab6:	492a      	ldr	r1, [pc, #168]	; (c0d00b60 <getPublicKey_handleAPDU+0x194>)
c0d00ab8:	4479      	add	r1, pc
c0d00aba:	f7ff fad9 	bl	c0d00070 <assert>
	getPublicKey_ui_runStep();
c0d00abe:	f000 f859 	bl	c0d00b74 <getPublicKey_ui_runStep>
	}

	runGetPublicKeyUIFlow();
}
c0d00ac2:	b003      	add	sp, #12
c0d00ac4:	bdf0      	pop	{r4, r5, r6, r7, pc}
	VALIDATE(isNewCall, ERR_INVALID_STATE);
c0d00ac6:	4827      	ldr	r0, [pc, #156]	; (c0d00b64 <getPublicKey_handleAPDU+0x198>)
c0d00ac8:	4478      	add	r0, pc
c0d00aca:	4927      	ldr	r1, [pc, #156]	; (c0d00b68 <getPublicKey_handleAPDU+0x19c>)
c0d00acc:	4479      	add	r1, pc
c0d00ace:	2286      	movs	r2, #134	; 0x86
c0d00ad0:	f002 f8b8 	bl	c0d02c44 <mcu_usb_printf>
c0d00ad4:	4811      	ldr	r0, [pc, #68]	; (c0d00b1c <getPublicKey_handleAPDU+0x150>)
c0d00ad6:	1c40      	adds	r0, r0, #1
c0d00ad8:	f001 fb5c 	bl	c0d02194 <os_longjmp>
	VALIDATE(p1 == P1_SHOW_PUBKEY || p1 == P1_DO_NOT_SHOW_PUBKEY, ERR_INVALID_REQUEST_PARAMETERS);
c0d00adc:	4812      	ldr	r0, [pc, #72]	; (c0d00b28 <getPublicKey_handleAPDU+0x15c>)
c0d00ade:	4478      	add	r0, pc
c0d00ae0:	4912      	ldr	r1, [pc, #72]	; (c0d00b2c <getPublicKey_handleAPDU+0x160>)
c0d00ae2:	4479      	add	r1, pc
c0d00ae4:	2287      	movs	r2, #135	; 0x87
c0d00ae6:	e004      	b.n	c0d00af2 <getPublicKey_handleAPDU+0x126>
	VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d00ae8:	4811      	ldr	r0, [pc, #68]	; (c0d00b30 <getPublicKey_handleAPDU+0x164>)
c0d00aea:	4478      	add	r0, pc
c0d00aec:	4911      	ldr	r1, [pc, #68]	; (c0d00b34 <getPublicKey_handleAPDU+0x168>)
c0d00aee:	4479      	add	r1, pc
c0d00af0:	2288      	movs	r2, #136	; 0x88
c0d00af2:	f002 f8a7 	bl	c0d02c44 <mcu_usb_printf>
c0d00af6:	4809      	ldr	r0, [pc, #36]	; (c0d00b1c <getPublicKey_handleAPDU+0x150>)
c0d00af8:	f001 fb4c 	bl	c0d02194 <os_longjmp>
		VALIDATE(parsedSize == wireDataSize, ERR_INVALID_DATA);
c0d00afc:	481b      	ldr	r0, [pc, #108]	; (c0d00b6c <getPublicKey_handleAPDU+0x1a0>)
c0d00afe:	4478      	add	r0, pc
c0d00b00:	491b      	ldr	r1, [pc, #108]	; (c0d00b70 <getPublicKey_handleAPDU+0x1a4>)
c0d00b02:	4479      	add	r1, pc
c0d00b04:	2298      	movs	r2, #152	; 0x98
c0d00b06:	f002 f89d 	bl	c0d02c44 <mcu_usb_printf>
c0d00b0a:	4804      	ldr	r0, [pc, #16]	; (c0d00b1c <getPublicKey_handleAPDU+0x150>)
c0d00b0c:	1c80      	adds	r0, r0, #2
c0d00b0e:	f001 fb41 	bl	c0d02194 <os_longjmp>
c0d00b12:	4802      	ldr	r0, [pc, #8]	; (c0d00b1c <getPublicKey_handleAPDU+0x150>)
		THROW(ERR_REJECTED_BY_POLICY);
c0d00b14:	300b      	adds	r0, #11
c0d00b16:	f001 fb3d 	bl	c0d02194 <os_longjmp>
c0d00b1a:	46c0      	nop			; (mov r8, r8)
c0d00b1c:	00006e05 	.word	0x00006e05
c0d00b20:	20000490 	.word	0x20000490
c0d00b24:	00005ba0 	.word	0x00005ba0
c0d00b28:	00007b20 	.word	0x00007b20
c0d00b2c:	00007eb3 	.word	0x00007eb3
c0d00b30:	00007b14 	.word	0x00007b14
c0d00b34:	00007ea7 	.word	0x00007ea7
c0d00b38:	00007fa2 	.word	0x00007fa2
c0d00b3c:	00007faf 	.word	0x00007faf
c0d00b40:	00007fb4 	.word	0x00007fb4
c0d00b44:	00007fc2 	.word	0x00007fc2
c0d00b48:	00008afa 	.word	0x00008afa
c0d00b4c:	00007f97 	.word	0x00007f97
c0d00b50:	00007f59 	.word	0x00007f59
c0d00b54:	00007f91 	.word	0x00007f91
c0d00b58:	00007f9d 	.word	0x00007f9d
c0d00b5c:	00008aa8 	.word	0x00008aa8
c0d00b60:	00007f64 	.word	0x00007f64
c0d00b64:	00007b36 	.word	0x00007b36
c0d00b68:	00007ec9 	.word	0x00007ec9
c0d00b6c:	00007b00 	.word	0x00007b00
c0d00b70:	00007e93 	.word	0x00007e93

c0d00b74 <getPublicKey_ui_runStep>:
{
c0d00b74:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d00b76:	b081      	sub	sp, #4
	TRACE("UI step %d", ctx->ui_step);
c0d00b78:	484c      	ldr	r0, [pc, #304]	; (c0d00cac <getPublicKey_ui_runStep+0x138>)
c0d00b7a:	4478      	add	r0, pc
c0d00b7c:	494c      	ldr	r1, [pc, #304]	; (c0d00cb0 <getPublicKey_ui_runStep+0x13c>)
c0d00b7e:	4479      	add	r1, pc
c0d00b80:	2232      	movs	r2, #50	; 0x32
c0d00b82:	f002 f85f 	bl	c0d02c44 <mcu_usb_printf>
c0d00b86:	2680      	movs	r6, #128	; 0x80
c0d00b88:	4f46      	ldr	r7, [pc, #280]	; (c0d00ca4 <getPublicKey_ui_runStep+0x130>)
c0d00b8a:	59b9      	ldr	r1, [r7, r6]
c0d00b8c:	4849      	ldr	r0, [pc, #292]	; (c0d00cb4 <getPublicKey_ui_runStep+0x140>)
c0d00b8e:	4478      	add	r0, pc
c0d00b90:	f002 f858 	bl	c0d02c44 <mcu_usb_printf>
c0d00b94:	4848      	ldr	r0, [pc, #288]	; (c0d00cb8 <getPublicKey_ui_runStep+0x144>)
c0d00b96:	4478      	add	r0, pc
c0d00b98:	f002 f854 	bl	c0d02c44 <mcu_usb_printf>
	UI_STEP_BEGIN(ctx->ui_step, this_fn);
c0d00b9c:	59b8      	ldr	r0, [r7, r6]
c0d00b9e:	28c9      	cmp	r0, #201	; 0xc9
c0d00ba0:	dd42      	ble.n	c0d00c28 <getPublicKey_ui_runStep+0xb4>
c0d00ba2:	28ca      	cmp	r0, #202	; 0xca
c0d00ba4:	d04d      	beq.n	c0d00c42 <getPublicKey_ui_runStep+0xce>
c0d00ba6:	28cb      	cmp	r0, #203	; 0xcb
c0d00ba8:	d056      	beq.n	c0d00c58 <getPublicKey_ui_runStep+0xe4>
c0d00baa:	28cc      	cmp	r0, #204	; 0xcc
c0d00bac:	d16a      	bne.n	c0d00c84 <getPublicKey_ui_runStep+0x110>
c0d00bae:	247c      	movs	r4, #124	; 0x7c
		ASSERT(ctx->responseReadyMagic == RESPONSE_READY_MAGIC);
c0d00bb0:	5b38      	ldrh	r0, [r7, r4]
c0d00bb2:	493d      	ldr	r1, [pc, #244]	; (c0d00ca8 <getPublicKey_ui_runStep+0x134>)
c0d00bb4:	1841      	adds	r1, r0, r1
c0d00bb6:	4248      	negs	r0, r1
c0d00bb8:	4148      	adcs	r0, r1
c0d00bba:	494c      	ldr	r1, [pc, #304]	; (c0d00cec <getPublicKey_ui_runStep+0x178>)
c0d00bbc:	4479      	add	r1, pc
c0d00bbe:	f7ff fa57 	bl	c0d00070 <assert>
c0d00bc2:	2009      	movs	r0, #9
c0d00bc4:	0300      	lsls	r0, r0, #12
		io_send_buf(SUCCESS, ctx->pubKey.W, SIZEOF(ctx->pubKey.W));
c0d00bc6:	4639      	mov	r1, r7
c0d00bc8:	3138      	adds	r1, #56	; 0x38
c0d00bca:	2241      	movs	r2, #65	; 0x41
c0d00bcc:	f000 fadc 	bl	c0d01188 <io_send_buf>
c0d00bd0:	2000      	movs	r0, #0
c0d00bd2:	9000      	str	r0, [sp, #0]
		ctx->responseReadyMagic = 0; // just for safety
c0d00bd4:	5338      	strh	r0, [r7, r4]
		ui_displayBusy(); // needs to happen after I/O
c0d00bd6:	f005 febd 	bl	c0d06954 <ui_displayBusy>
		TRACE("Export done.");
c0d00bda:	4c45      	ldr	r4, [pc, #276]	; (c0d00cf0 <getPublicKey_ui_runStep+0x17c>)
c0d00bdc:	447c      	add	r4, pc
c0d00bde:	4945      	ldr	r1, [pc, #276]	; (c0d00cf4 <getPublicKey_ui_runStep+0x180>)
c0d00be0:	4479      	add	r1, pc
c0d00be2:	2253      	movs	r2, #83	; 0x53
c0d00be4:	4620      	mov	r0, r4
c0d00be6:	f002 f82d 	bl	c0d02c44 <mcu_usb_printf>
c0d00bea:	4843      	ldr	r0, [pc, #268]	; (c0d00cf8 <getPublicKey_ui_runStep+0x184>)
c0d00bec:	4478      	add	r0, pc
c0d00bee:	f002 f829 	bl	c0d02c44 <mcu_usb_printf>
c0d00bf2:	4d42      	ldr	r5, [pc, #264]	; (c0d00cfc <getPublicKey_ui_runStep+0x188>)
c0d00bf4:	447d      	add	r5, pc
c0d00bf6:	4628      	mov	r0, r5
c0d00bf8:	f002 f824 	bl	c0d02c44 <mcu_usb_printf>
	TRACE("Advancing from stage: %d", ctx->stage);
c0d00bfc:	4940      	ldr	r1, [pc, #256]	; (c0d00d00 <getPublicKey_ui_runStep+0x18c>)
c0d00bfe:	4479      	add	r1, pc
c0d00c00:	2217      	movs	r2, #23
c0d00c02:	4620      	mov	r0, r4
c0d00c04:	f002 f81e 	bl	c0d02c44 <mcu_usb_printf>
c0d00c08:	7839      	ldrb	r1, [r7, #0]
c0d00c0a:	483e      	ldr	r0, [pc, #248]	; (c0d00d04 <getPublicKey_ui_runStep+0x190>)
c0d00c0c:	4478      	add	r0, pc
c0d00c0e:	f002 f819 	bl	c0d02c44 <mcu_usb_printf>
c0d00c12:	4628      	mov	r0, r5
c0d00c14:	f002 f816 	bl	c0d02c44 <mcu_usb_printf>
	switch (ctx->stage) {
c0d00c18:	7838      	ldrb	r0, [r7, #0]
c0d00c1a:	2814      	cmp	r0, #20
c0d00c1c:	d139      	bne.n	c0d00c92 <getPublicKey_ui_runStep+0x11e>
		ctx->stage = GET_KEY_STAGE_NONE;
c0d00c1e:	9800      	ldr	r0, [sp, #0]
c0d00c20:	7038      	strb	r0, [r7, #0]
		ui_idle(); // we are done with this key export
c0d00c22:	f001 f947 	bl	c0d01eb4 <ui_idle>
c0d00c26:	e039      	b.n	c0d00c9c <getPublicKey_ui_runStep+0x128>
	UI_STEP_BEGIN(ctx->ui_step, this_fn);
c0d00c28:	28c8      	cmp	r0, #200	; 0xc8
c0d00c2a:	d021      	beq.n	c0d00c70 <getPublicKey_ui_runStep+0xfc>
c0d00c2c:	28c9      	cmp	r0, #201	; 0xc9
c0d00c2e:	d129      	bne.n	c0d00c84 <getPublicKey_ui_runStep+0x110>
		ui_displayPathScreen("Export public key", &ctx->pathSpec, this_fn);
c0d00c30:	1d39      	adds	r1, r7, #4
c0d00c32:	4822      	ldr	r0, [pc, #136]	; (c0d00cbc <getPublicKey_ui_runStep+0x148>)
c0d00c34:	4478      	add	r0, pc
c0d00c36:	4a22      	ldr	r2, [pc, #136]	; (c0d00cc0 <getPublicKey_ui_runStep+0x14c>)
c0d00c38:	447a      	add	r2, pc
c0d00c3a:	f006 f85b 	bl	c0d06cf4 <ui_displayPathScreen>
c0d00c3e:	20ca      	movs	r0, #202	; 0xca
c0d00c40:	e02d      	b.n	c0d00c9e <getPublicKey_ui_runStep+0x12a>
		ui_displayHexBufferScreen("Public key", ctx->pubKey.W, SIZEOF(ctx->pubKey.W), this_fn);
c0d00c42:	4639      	mov	r1, r7
c0d00c44:	3138      	adds	r1, #56	; 0x38
c0d00c46:	4823      	ldr	r0, [pc, #140]	; (c0d00cd4 <getPublicKey_ui_runStep+0x160>)
c0d00c48:	4478      	add	r0, pc
c0d00c4a:	2241      	movs	r2, #65	; 0x41
c0d00c4c:	4b22      	ldr	r3, [pc, #136]	; (c0d00cd8 <getPublicKey_ui_runStep+0x164>)
c0d00c4e:	447b      	add	r3, pc
c0d00c50:	f006 f88a 	bl	c0d06d68 <ui_displayHexBufferScreen>
c0d00c54:	20cb      	movs	r0, #203	; 0xcb
c0d00c56:	e022      	b.n	c0d00c9e <getPublicKey_ui_runStep+0x12a>
		ui_displayPrompt(
c0d00c58:	4820      	ldr	r0, [pc, #128]	; (c0d00cdc <getPublicKey_ui_runStep+0x168>)
c0d00c5a:	4478      	add	r0, pc
c0d00c5c:	4920      	ldr	r1, [pc, #128]	; (c0d00ce0 <getPublicKey_ui_runStep+0x16c>)
c0d00c5e:	4479      	add	r1, pc
c0d00c60:	4a20      	ldr	r2, [pc, #128]	; (c0d00ce4 <getPublicKey_ui_runStep+0x170>)
c0d00c62:	447a      	add	r2, pc
c0d00c64:	4b20      	ldr	r3, [pc, #128]	; (c0d00ce8 <getPublicKey_ui_runStep+0x174>)
c0d00c66:	447b      	add	r3, pc
c0d00c68:	f005 fbb4 	bl	c0d063d4 <ui_displayPrompt>
c0d00c6c:	20cc      	movs	r0, #204	; 0xcc
c0d00c6e:	e016      	b.n	c0d00c9e <getPublicKey_ui_runStep+0x12a>
		ui_displayPaginatedText(
c0d00c70:	4815      	ldr	r0, [pc, #84]	; (c0d00cc8 <getPublicKey_ui_runStep+0x154>)
c0d00c72:	4478      	add	r0, pc
c0d00c74:	4915      	ldr	r1, [pc, #84]	; (c0d00ccc <getPublicKey_ui_runStep+0x158>)
c0d00c76:	4479      	add	r1, pc
c0d00c78:	4a15      	ldr	r2, [pc, #84]	; (c0d00cd0 <getPublicKey_ui_runStep+0x15c>)
c0d00c7a:	447a      	add	r2, pc
c0d00c7c:	f005 fc66 	bl	c0d0654c <ui_displayPaginatedText>
c0d00c80:	20c9      	movs	r0, #201	; 0xc9
c0d00c82:	e00c      	b.n	c0d00c9e <getPublicKey_ui_runStep+0x12a>
c0d00c84:	2000      	movs	r0, #0
	UI_STEP_BEGIN(ctx->ui_step, this_fn);
c0d00c86:	490f      	ldr	r1, [pc, #60]	; (c0d00cc4 <getPublicKey_ui_runStep+0x150>)
c0d00c88:	4479      	add	r1, pc
c0d00c8a:	f7ff f9f1 	bl	c0d00070 <assert>
c0d00c8e:	20c8      	movs	r0, #200	; 0xc8
c0d00c90:	e005      	b.n	c0d00c9e <getPublicKey_ui_runStep+0x12a>
c0d00c92:	2000      	movs	r0, #0
		ASSERT(false);
c0d00c94:	491c      	ldr	r1, [pc, #112]	; (c0d00d08 <getPublicKey_ui_runStep+0x194>)
c0d00c96:	4479      	add	r1, pc
c0d00c98:	f7ff f9ea 	bl	c0d00070 <assert>
c0d00c9c:	20cd      	movs	r0, #205	; 0xcd
c0d00c9e:	51b8      	str	r0, [r7, r6]
}
c0d00ca0:	b001      	add	sp, #4
c0d00ca2:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d00ca4:	20000490 	.word	0x20000490
c0d00ca8:	ffffa460 	.word	0xffffa460
c0d00cac:	00007e45 	.word	0x00007e45
c0d00cb0:	00007eb5 	.word	0x00007eb5
c0d00cb4:	00007ebd 	.word	0x00007ebd
c0d00cb8:	00008990 	.word	0x00008990
c0d00cbc:	00007e5a 	.word	0x00007e5a
c0d00cc0:	ffffff39 	.word	0xffffff39
c0d00cc4:	00007dce 	.word	0x00007dce
c0d00cc8:	00007dfa 	.word	0x00007dfa
c0d00ccc:	00007e06 	.word	0x00007e06
c0d00cd0:	fffffef7 	.word	0xfffffef7
c0d00cd4:	00007e58 	.word	0x00007e58
c0d00cd8:	ffffff23 	.word	0xffffff23
c0d00cdc:	00007e51 	.word	0x00007e51
c0d00ce0:	00007e5c 	.word	0x00007e5c
c0d00ce4:	ffffff0f 	.word	0xffffff0f
c0d00ce8:	00005aaf 	.word	0x00005aaf
c0d00cec:	00007f0a 	.word	0x00007f0a
c0d00cf0:	00007de3 	.word	0x00007de3
c0d00cf4:	00007e53 	.word	0x00007e53
c0d00cf8:	00007ef0 	.word	0x00007ef0
c0d00cfc:	00008932 	.word	0x00008932
c0d00d00:	00007eeb 	.word	0x00007eeb
c0d00d04:	00007eea 	.word	0x00007eea
c0d00d08:	00007e79 	.word	0x00007e79

c0d00d0c <getSerial_handleAPDU>:
        uint8_t p2,
        uint8_t *wireDataBuffer MARK_UNUSED,
        size_t wireDataSize,
        bool isNewCall MARK_UNUSED
)
{
c0d00d0c:	b5b0      	push	{r4, r5, r7, lr}
c0d00d0e:	b082      	sub	sp, #8
	VALIDATE(p1 == 0, ERR_INVALID_REQUEST_PARAMETERS);
c0d00d10:	2800      	cmp	r0, #0
c0d00d12:	d129      	bne.n	c0d00d68 <getSerial_handleAPDU+0x5c>
	VALIDATE(p2 == 0, ERR_INVALID_REQUEST_PARAMETERS);
c0d00d14:	2900      	cmp	r1, #0
c0d00d16:	d12d      	bne.n	c0d00d74 <getSerial_handleAPDU+0x68>
	VALIDATE(wireDataSize == 0, ERR_INVALID_REQUEST_PARAMETERS);
c0d00d18:	2b00      	cmp	r3, #0
c0d00d1a:	d131      	bne.n	c0d00d80 <getSerial_handleAPDU+0x74>

	STATIC_ASSERT(sizeof(uint8_t) == sizeof(unsigned char), "bad unsigned char size");
	STATIC_ASSERT(sizeof(size_t) >= sizeof(unsigned int), "bad unsigned int size");

	TRACE();
c0d00d1c:	4824      	ldr	r0, [pc, #144]	; (c0d00db0 <getSerial_handleAPDU+0xa4>)
c0d00d1e:	4478      	add	r0, pc
c0d00d20:	4924      	ldr	r1, [pc, #144]	; (c0d00db4 <getSerial_handleAPDU+0xa8>)
c0d00d22:	4479      	add	r1, pc
c0d00d24:	2216      	movs	r2, #22
c0d00d26:	f001 ff8d 	bl	c0d02c44 <mcu_usb_printf>
c0d00d2a:	4823      	ldr	r0, [pc, #140]	; (c0d00db8 <getSerial_handleAPDU+0xac>)
c0d00d2c:	4478      	add	r0, pc
c0d00d2e:	f001 ff89 	bl	c0d02c44 <mcu_usb_printf>
c0d00d32:	4822      	ldr	r0, [pc, #136]	; (c0d00dbc <getSerial_handleAPDU+0xb0>)
c0d00d34:	4478      	add	r0, pc
c0d00d36:	f001 ff85 	bl	c0d02c44 <mcu_usb_printf>
c0d00d3a:	466c      	mov	r4, sp
c0d00d3c:	2507      	movs	r5, #7

	const size_t SERIAL_LENGTH = 7; // if too short, exception 2 is thrown by os_serial
	uint8_t response[SERIAL_LENGTH];
	size_t len = os_serial(response, SERIAL_LENGTH);
c0d00d3e:	4620      	mov	r0, r4
c0d00d40:	4629      	mov	r1, r5
c0d00d42:	f004 fc19 	bl	c0d05578 <os_serial>
	ASSERT(len == SERIAL_LENGTH);
c0d00d46:	1fc1      	subs	r1, r0, #7
c0d00d48:	4248      	negs	r0, r1
c0d00d4a:	4148      	adcs	r0, r1
c0d00d4c:	491c      	ldr	r1, [pc, #112]	; (c0d00dc0 <getSerial_handleAPDU+0xb4>)
c0d00d4e:	4479      	add	r1, pc
c0d00d50:	f7ff f98e 	bl	c0d00070 <assert>
c0d00d54:	2009      	movs	r0, #9
c0d00d56:	0300      	lsls	r0, r0, #12

	io_send_buf(SUCCESS, response, SERIAL_LENGTH);
c0d00d58:	4621      	mov	r1, r4
c0d00d5a:	462a      	mov	r2, r5
c0d00d5c:	f000 fa14 	bl	c0d01188 <io_send_buf>
	ui_idle();
c0d00d60:	f001 f8a8 	bl	c0d01eb4 <ui_idle>
}
c0d00d64:	b002      	add	sp, #8
c0d00d66:	bdb0      	pop	{r4, r5, r7, pc}
	VALIDATE(p1 == 0, ERR_INVALID_REQUEST_PARAMETERS);
c0d00d68:	480b      	ldr	r0, [pc, #44]	; (c0d00d98 <getSerial_handleAPDU+0x8c>)
c0d00d6a:	4478      	add	r0, pc
c0d00d6c:	490b      	ldr	r1, [pc, #44]	; (c0d00d9c <getSerial_handleAPDU+0x90>)
c0d00d6e:	4479      	add	r1, pc
c0d00d70:	220f      	movs	r2, #15
c0d00d72:	e00a      	b.n	c0d00d8a <getSerial_handleAPDU+0x7e>
	VALIDATE(p2 == 0, ERR_INVALID_REQUEST_PARAMETERS);
c0d00d74:	480a      	ldr	r0, [pc, #40]	; (c0d00da0 <getSerial_handleAPDU+0x94>)
c0d00d76:	4478      	add	r0, pc
c0d00d78:	490a      	ldr	r1, [pc, #40]	; (c0d00da4 <getSerial_handleAPDU+0x98>)
c0d00d7a:	4479      	add	r1, pc
c0d00d7c:	2210      	movs	r2, #16
c0d00d7e:	e004      	b.n	c0d00d8a <getSerial_handleAPDU+0x7e>
	VALIDATE(wireDataSize == 0, ERR_INVALID_REQUEST_PARAMETERS);
c0d00d80:	4809      	ldr	r0, [pc, #36]	; (c0d00da8 <getSerial_handleAPDU+0x9c>)
c0d00d82:	4478      	add	r0, pc
c0d00d84:	4909      	ldr	r1, [pc, #36]	; (c0d00dac <getSerial_handleAPDU+0xa0>)
c0d00d86:	4479      	add	r1, pc
c0d00d88:	2211      	movs	r2, #17
c0d00d8a:	f001 ff5b 	bl	c0d02c44 <mcu_usb_printf>
c0d00d8e:	4801      	ldr	r0, [pc, #4]	; (c0d00d94 <getSerial_handleAPDU+0x88>)
c0d00d90:	f001 fa00 	bl	c0d02194 <os_longjmp>
c0d00d94:	00006e05 	.word	0x00006e05
c0d00d98:	00007894 	.word	0x00007894
c0d00d9c:	00007db7 	.word	0x00007db7
c0d00da0:	00007888 	.word	0x00007888
c0d00da4:	00007dab 	.word	0x00007dab
c0d00da8:	0000787c 	.word	0x0000787c
c0d00dac:	00007d9f 	.word	0x00007d9f
c0d00db0:	00007ca1 	.word	0x00007ca1
c0d00db4:	00007e13 	.word	0x00007e13
c0d00db8:	000087fb 	.word	0x000087fb
c0d00dbc:	000087f2 	.word	0x000087f2
c0d00dc0:	00007dfc 	.word	0x00007dfc

c0d00dc4 <getVersion_handleAPDU>:
        uint8_t p2,
        uint8_t *wireDataBuffer MARK_UNUSED,
        size_t wireDataSize,
        bool isNewCall MARK_UNUSED
)
{
c0d00dc4:	b580      	push	{r7, lr}
c0d00dc6:	b082      	sub	sp, #8
	STATIC_ASSERT(MINOR_VERSION >= 0 && MINOR_VERSION <= 9,
	              "MINOR version must be between 0 and 9!");
	STATIC_ASSERT(PATCH_VERSION >= 0 && PATCH_VERSION <= 9,
	              "PATCH version must be between 0 and 9!");

	VALIDATE(p1 == P1_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d00dc8:	2800      	cmp	r0, #0
c0d00dca:	d10f      	bne.n	c0d00dec <getVersion_handleAPDU+0x28>
	VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d00dcc:	2900      	cmp	r1, #0
c0d00dce:	d113      	bne.n	c0d00df8 <getVersion_handleAPDU+0x34>
	VALIDATE(wireDataSize == 0, ERR_INVALID_DATA);
c0d00dd0:	2b00      	cmp	r3, #0
c0d00dd2:	d11b      	bne.n	c0d00e0c <getVersion_handleAPDU+0x48>
c0d00dd4:	4814      	ldr	r0, [pc, #80]	; (c0d00e28 <getVersion_handleAPDU+0x64>)
	struct {
		uint8_t major;
		uint8_t minor;
		uint8_t patch;
		uint8_t flags;
	} response = {
c0d00dd6:	9001      	str	r0, [sp, #4]
c0d00dd8:	2009      	movs	r0, #9
c0d00dda:	0300      	lsls	r0, r0, #12
c0d00ddc:	a901      	add	r1, sp, #4
c0d00dde:	2204      	movs	r2, #4

	#ifdef DEVEL
	response.flags |= FLAG_DEVEL;
	#endif // DEVEL

	io_send_buf(SUCCESS, (uint8_t *) &response, sizeof(response));
c0d00de0:	f000 f9d2 	bl	c0d01188 <io_send_buf>
	ui_idle();
c0d00de4:	f001 f866 	bl	c0d01eb4 <ui_idle>
}
c0d00de8:	b002      	add	sp, #8
c0d00dea:	bd80      	pop	{r7, pc}
	VALIDATE(p1 == P1_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d00dec:	480f      	ldr	r0, [pc, #60]	; (c0d00e2c <getVersion_handleAPDU+0x68>)
c0d00dee:	4478      	add	r0, pc
c0d00df0:	490f      	ldr	r1, [pc, #60]	; (c0d00e30 <getVersion_handleAPDU+0x6c>)
c0d00df2:	4479      	add	r1, pc
c0d00df4:	221e      	movs	r2, #30
c0d00df6:	e004      	b.n	c0d00e02 <getVersion_handleAPDU+0x3e>
	VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d00df8:	480e      	ldr	r0, [pc, #56]	; (c0d00e34 <getVersion_handleAPDU+0x70>)
c0d00dfa:	4478      	add	r0, pc
c0d00dfc:	490e      	ldr	r1, [pc, #56]	; (c0d00e38 <getVersion_handleAPDU+0x74>)
c0d00dfe:	4479      	add	r1, pc
c0d00e00:	221f      	movs	r2, #31
c0d00e02:	f001 ff1f 	bl	c0d02c44 <mcu_usb_printf>
c0d00e06:	4807      	ldr	r0, [pc, #28]	; (c0d00e24 <getVersion_handleAPDU+0x60>)
c0d00e08:	f001 f9c4 	bl	c0d02194 <os_longjmp>
	VALIDATE(wireDataSize == 0, ERR_INVALID_DATA);
c0d00e0c:	480b      	ldr	r0, [pc, #44]	; (c0d00e3c <getVersion_handleAPDU+0x78>)
c0d00e0e:	4478      	add	r0, pc
c0d00e10:	490b      	ldr	r1, [pc, #44]	; (c0d00e40 <getVersion_handleAPDU+0x7c>)
c0d00e12:	4479      	add	r1, pc
c0d00e14:	2220      	movs	r2, #32
c0d00e16:	f001 ff15 	bl	c0d02c44 <mcu_usb_printf>
c0d00e1a:	4802      	ldr	r0, [pc, #8]	; (c0d00e24 <getVersion_handleAPDU+0x60>)
c0d00e1c:	1c80      	adds	r0, r0, #2
c0d00e1e:	f001 f9b9 	bl	c0d02194 <os_longjmp>
c0d00e22:	46c0      	nop			; (mov r8, r8)
c0d00e24:	00006e05 	.word	0x00006e05
c0d00e28:	01010000 	.word	0x01010000
c0d00e2c:	00007810 	.word	0x00007810
c0d00e30:	00007d6b 	.word	0x00007d6b
c0d00e34:	00007804 	.word	0x00007804
c0d00e38:	00007d5f 	.word	0x00007d5f
c0d00e3c:	000077f0 	.word	0x000077f0
c0d00e40:	00007d4b 	.word	0x00007d4b

c0d00e44 <lookupHandler>:
// The APDU protocol uses a single-byte instruction code (INS) to specify
// which command should be executed. We'll use this code to dispatch on a
// table of function pointers.
handler_fn_t* lookupHandler(uint8_t ins)
{
	switch (ins) {
c0d00e44:	280f      	cmp	r0, #15
c0d00e46:	dd08      	ble.n	c0d00e5a <lookupHandler+0x16>
c0d00e48:	2810      	cmp	r0, #16
c0d00e4a:	d00d      	beq.n	c0d00e68 <lookupHandler+0x24>
c0d00e4c:	2820      	cmp	r0, #32
c0d00e4e:	d00e      	beq.n	c0d00e6e <lookupHandler+0x2a>
c0d00e50:	28f0      	cmp	r0, #240	; 0xf0
c0d00e52:	d112      	bne.n	c0d00e7a <lookupHandler+0x36>
c0d00e54:	480b      	ldr	r0, [pc, #44]	; (c0d00e84 <lookupHandler+0x40>)
c0d00e56:	4478      	add	r0, pc
		#endif // DEVEL
#	undef   CASE
	default:
		return NULL;
	}
}
c0d00e58:	4770      	bx	lr
	switch (ins) {
c0d00e5a:	2800      	cmp	r0, #0
c0d00e5c:	d00a      	beq.n	c0d00e74 <lookupHandler+0x30>
c0d00e5e:	2801      	cmp	r0, #1
c0d00e60:	d10b      	bne.n	c0d00e7a <lookupHandler+0x36>
c0d00e62:	4809      	ldr	r0, [pc, #36]	; (c0d00e88 <lookupHandler+0x44>)
c0d00e64:	4478      	add	r0, pc
}
c0d00e66:	4770      	bx	lr
c0d00e68:	4808      	ldr	r0, [pc, #32]	; (c0d00e8c <lookupHandler+0x48>)
c0d00e6a:	4478      	add	r0, pc
c0d00e6c:	4770      	bx	lr
c0d00e6e:	4808      	ldr	r0, [pc, #32]	; (c0d00e90 <lookupHandler+0x4c>)
c0d00e70:	4478      	add	r0, pc
c0d00e72:	4770      	bx	lr
c0d00e74:	4802      	ldr	r0, [pc, #8]	; (c0d00e80 <lookupHandler+0x3c>)
c0d00e76:	4478      	add	r0, pc
c0d00e78:	4770      	bx	lr
c0d00e7a:	2000      	movs	r0, #0
c0d00e7c:	4770      	bx	lr
c0d00e7e:	46c0      	nop			; (mov r8, r8)
c0d00e80:	ffffff4b 	.word	0xffffff4b
c0d00e84:	000024fb 	.word	0x000024fb
c0d00e88:	fffffea5 	.word	0xfffffea5
c0d00e8c:	fffffb5f 	.word	0xfffffb5f
c0d00e90:	00004335 	.word	0x00004335

c0d00e94 <hex_parseNibble>:
#include "common.h"
#include "testUtils.h"

uint8_t hex_parseNibble(const char c)
{
c0d00e94:	b580      	push	{r7, lr}
	if (c >= '0' && c <= '9') return c - '0';
c0d00e96:	4601      	mov	r1, r0
c0d00e98:	3930      	subs	r1, #48	; 0x30
c0d00e9a:	b2ca      	uxtb	r2, r1
c0d00e9c:	2a0a      	cmp	r2, #10
c0d00e9e:	d30d      	bcc.n	c0d00ebc <hex_parseNibble+0x28>
	if (c >= 'a' && c <= 'f') return c - 'a' + 10;
c0d00ea0:	4601      	mov	r1, r0
c0d00ea2:	3961      	subs	r1, #97	; 0x61
c0d00ea4:	b2c9      	uxtb	r1, r1
c0d00ea6:	2905      	cmp	r1, #5
c0d00ea8:	d801      	bhi.n	c0d00eae <hex_parseNibble+0x1a>
c0d00eaa:	3857      	subs	r0, #87	; 0x57
c0d00eac:	e005      	b.n	c0d00eba <hex_parseNibble+0x26>
	if (c >= 'A' && c <= 'F') return c - 'A' + 10;
c0d00eae:	4601      	mov	r1, r0
c0d00eb0:	3941      	subs	r1, #65	; 0x41
c0d00eb2:	b2c9      	uxtb	r1, r1
c0d00eb4:	2905      	cmp	r1, #5
c0d00eb6:	d803      	bhi.n	c0d00ec0 <hex_parseNibble+0x2c>
c0d00eb8:	3837      	subs	r0, #55	; 0x37
c0d00eba:	4601      	mov	r1, r0
	THROW(ERR_UNEXPECTED_TOKEN);
}
c0d00ebc:	b2c8      	uxtb	r0, r1
c0d00ebe:	bd80      	pop	{r7, pc}
c0d00ec0:	4801      	ldr	r0, [pc, #4]	; (c0d00ec8 <hex_parseNibble+0x34>)
	THROW(ERR_UNEXPECTED_TOKEN);
c0d00ec2:	f001 f967 	bl	c0d02194 <os_longjmp>
c0d00ec6:	46c0      	nop			; (mov r8, r8)
c0d00ec8:	00004720 	.word	0x00004720

c0d00ecc <decode_hex>:
	return (uint8_t) ((first << 4) + second);
}


size_t decode_hex(const char* inStr, uint8_t* outBuffer, size_t outMaxSize)
{
c0d00ecc:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d00ece:	b081      	sub	sp, #4
c0d00ed0:	4617      	mov	r7, r2
c0d00ed2:	460c      	mov	r4, r1
c0d00ed4:	4605      	mov	r5, r0
	size_t len = strlen(inStr);
c0d00ed6:	f007 fb87 	bl	c0d085e8 <strlen>
c0d00eda:	4606      	mov	r6, r0
	if (len % 2) THROW(ERR_UNEXPECTED_TOKEN);
c0d00edc:	07c0      	lsls	r0, r0, #31
c0d00ede:	d117      	bne.n	c0d00f10 <decode_hex+0x44>

	size_t outLen = len / 2;
c0d00ee0:	0870      	lsrs	r0, r6, #1
c0d00ee2:	9000      	str	r0, [sp, #0]
	if (outLen > outMaxSize) {
c0d00ee4:	4287      	cmp	r7, r0
c0d00ee6:	d317      	bcc.n	c0d00f18 <decode_hex+0x4c>
		THROW(ERR_DATA_TOO_LARGE);
	}

	while (len >= 2) {
c0d00ee8:	2e02      	cmp	r6, #2
c0d00eea:	d30e      	bcc.n	c0d00f0a <decode_hex+0x3e>
	uint8_t first = hex_parseNibble(buffer[0]);
c0d00eec:	7828      	ldrb	r0, [r5, #0]
c0d00eee:	f7ff ffd1 	bl	c0d00e94 <hex_parseNibble>
c0d00ef2:	4607      	mov	r7, r0
	uint8_t second = hex_parseNibble(buffer[1]);
c0d00ef4:	7868      	ldrb	r0, [r5, #1]
c0d00ef6:	f7ff ffcd 	bl	c0d00e94 <hex_parseNibble>
	return (uint8_t) ((first << 4) + second);
c0d00efa:	0139      	lsls	r1, r7, #4
c0d00efc:	1840      	adds	r0, r0, r1
		*outBuffer = hex_parseNibblePair(inStr);
c0d00efe:	7020      	strb	r0, [r4, #0]
	while (len >= 2) {
c0d00f00:	1cad      	adds	r5, r5, #2
		len -= 2;
		inStr += 2;
		outBuffer += 1;
c0d00f02:	1c64      	adds	r4, r4, #1
		len -= 2;
c0d00f04:	1eb6      	subs	r6, r6, #2
	while (len >= 2) {
c0d00f06:	2e01      	cmp	r6, #1
c0d00f08:	d8f0      	bhi.n	c0d00eec <decode_hex+0x20>
	}
	return outLen;
c0d00f0a:	9800      	ldr	r0, [sp, #0]
c0d00f0c:	b001      	add	sp, #4
c0d00f0e:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d00f10:	4803      	ldr	r0, [pc, #12]	; (c0d00f20 <decode_hex+0x54>)
	if (len % 2) THROW(ERR_UNEXPECTED_TOKEN);
c0d00f12:	300f      	adds	r0, #15
c0d00f14:	f001 f93e 	bl	c0d02194 <os_longjmp>
c0d00f18:	4801      	ldr	r0, [pc, #4]	; (c0d00f20 <decode_hex+0x54>)
		THROW(ERR_DATA_TOO_LARGE);
c0d00f1a:	f001 f93b 	bl	c0d02194 <os_longjmp>
c0d00f1e:	46c0      	nop			; (mov r8, r8)
c0d00f20:	00004711 	.word	0x00004711

c0d00f24 <encode_hex>:

static const char HEX_ALPHABET[] = "0123456789abcdef";

// returns the length of the string written to out
size_t encode_hex(const uint8_t* bytes, size_t bytesLength, char* out, size_t outMaxSize)
{
c0d00f24:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d00f26:	b081      	sub	sp, #4
c0d00f28:	461c      	mov	r4, r3
c0d00f2a:	9200      	str	r2, [sp, #0]
c0d00f2c:	460d      	mov	r5, r1
c0d00f2e:	4606      	mov	r6, r0
	ASSERT(bytesLength < BUFFER_SIZE_PARANOIA);
c0d00f30:	0a89      	lsrs	r1, r1, #10
c0d00f32:	4248      	negs	r0, r1
c0d00f34:	4148      	adcs	r0, r1
c0d00f36:	4919      	ldr	r1, [pc, #100]	; (c0d00f9c <encode_hex+0x78>)
c0d00f38:	4479      	add	r1, pc
c0d00f3a:	f7ff f899 	bl	c0d00070 <assert>
	ASSERT(outMaxSize < BUFFER_SIZE_PARANOIA);
c0d00f3e:	0aa1      	lsrs	r1, r4, #10
c0d00f40:	4248      	negs	r0, r1
c0d00f42:	4148      	adcs	r0, r1
c0d00f44:	4916      	ldr	r1, [pc, #88]	; (c0d00fa0 <encode_hex+0x7c>)
c0d00f46:	4479      	add	r1, pc
c0d00f48:	f7ff f892 	bl	c0d00070 <assert>
	ASSERT(outMaxSize >= 2 * bytesLength + 1);
c0d00f4c:	006f      	lsls	r7, r5, #1
c0d00f4e:	1c78      	adds	r0, r7, #1
c0d00f50:	42a0      	cmp	r0, r4
c0d00f52:	d901      	bls.n	c0d00f58 <encode_hex+0x34>
c0d00f54:	2000      	movs	r0, #0
c0d00f56:	e000      	b.n	c0d00f5a <encode_hex+0x36>
c0d00f58:	2001      	movs	r0, #1
c0d00f5a:	4912      	ldr	r1, [pc, #72]	; (c0d00fa4 <encode_hex+0x80>)
c0d00f5c:	4479      	add	r1, pc
c0d00f5e:	f7ff f887 	bl	c0d00070 <assert>

	size_t i = 0;
	for (; i < bytesLength; i++) {
c0d00f62:	2d00      	cmp	r5, #0
c0d00f64:	9c00      	ldr	r4, [sp, #0]
c0d00f66:	d00f      	beq.n	c0d00f88 <encode_hex+0x64>
c0d00f68:	480f      	ldr	r0, [pc, #60]	; (c0d00fa8 <encode_hex+0x84>)
c0d00f6a:	4478      	add	r0, pc
c0d00f6c:	4621      	mov	r1, r4
		out[2 * i]     = HEX_ALPHABET[bytes[i] >> 4];
c0d00f6e:	7832      	ldrb	r2, [r6, #0]
c0d00f70:	0912      	lsrs	r2, r2, #4
c0d00f72:	5c82      	ldrb	r2, [r0, r2]
c0d00f74:	700a      	strb	r2, [r1, #0]
		out[2 * i + 1] = HEX_ALPHABET[bytes[i] & 0x0F];
c0d00f76:	7832      	ldrb	r2, [r6, #0]
c0d00f78:	230f      	movs	r3, #15
c0d00f7a:	4013      	ands	r3, r2
c0d00f7c:	5cc2      	ldrb	r2, [r0, r3]
c0d00f7e:	704a      	strb	r2, [r1, #1]
	for (; i < bytesLength; i++) {
c0d00f80:	1c89      	adds	r1, r1, #2
c0d00f82:	1c76      	adds	r6, r6, #1
c0d00f84:	1e6d      	subs	r5, r5, #1
c0d00f86:	d1f2      	bne.n	c0d00f6e <encode_hex+0x4a>
c0d00f88:	2001      	movs	r0, #1
	}
	ASSERT(i == bytesLength);
c0d00f8a:	4908      	ldr	r1, [pc, #32]	; (c0d00fac <encode_hex+0x88>)
c0d00f8c:	4479      	add	r1, pc
c0d00f8e:	f7ff f86f 	bl	c0d00070 <assert>
c0d00f92:	2000      	movs	r0, #0
	out[2 * i] = '\0';
c0d00f94:	55e0      	strb	r0, [r4, r7]

	return 2 * bytesLength;
c0d00f96:	4638      	mov	r0, r7
c0d00f98:	b001      	add	sp, #4
c0d00f9a:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d00f9c:	00007ca8 	.word	0x00007ca8
c0d00fa0:	00007cac 	.word	0x00007cac
c0d00fa4:	00007ca8 	.word	0x00007ca8
c0d00fa8:	00007cac 	.word	0x00007cac
c0d00fac:	00007c9b 	.word	0x00007c9b

c0d00fb0 <test_hex_nibble_parsing>:
}


void test_hex_nibble_parsing()
{
c0d00fb0:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d00fb2:	b0bf      	sub	sp, #252	; 0xfc
c0d00fb4:	ac13      	add	r4, sp, #76	; 0x4c
	struct {
		char nibble;
		int value;
	} testVectors[] = {
c0d00fb6:	4933      	ldr	r1, [pc, #204]	; (c0d01084 <test_hex_nibble_parsing+0xd4>)
c0d00fb8:	4479      	add	r1, pc
c0d00fba:	22b0      	movs	r2, #176	; 0xb0
c0d00fbc:	4620      	mov	r0, r4
c0d00fbe:	f007 faaa 	bl	c0d08516 <__aeabi_memcpy>
		{'C', 12},
		{'D', 13},
		{'E', 14},
		{'F', 15},
	};
	PRINTF("test_hex_nibble\n");
c0d00fc2:	4831      	ldr	r0, [pc, #196]	; (c0d01088 <test_hex_nibble_parsing+0xd8>)
c0d00fc4:	4478      	add	r0, pc
c0d00fc6:	f001 fe3d 	bl	c0d02c44 <mcu_usb_printf>

	ITERATE(it, testVectors) {
c0d00fca:	4626      	mov	r6, r4
c0d00fcc:	36b0      	adds	r6, #176	; 0xb0
c0d00fce:	4d2f      	ldr	r5, [pc, #188]	; (c0d0108c <test_hex_nibble_parsing+0xdc>)
c0d00fd0:	447d      	add	r5, pc
		EXPECT_EQ(hex_parseNibble(it->nibble), it->value);
c0d00fd2:	7820      	ldrb	r0, [r4, #0]
c0d00fd4:	f7ff ff5e 	bl	c0d00e94 <hex_parseNibble>
c0d00fd8:	6861      	ldr	r1, [r4, #4]
c0d00fda:	1a09      	subs	r1, r1, r0
c0d00fdc:	4248      	negs	r0, r1
c0d00fde:	4148      	adcs	r0, r1
c0d00fe0:	4629      	mov	r1, r5
c0d00fe2:	f7ff f845 	bl	c0d00070 <assert>
	ITERATE(it, testVectors) {
c0d00fe6:	3408      	adds	r4, #8
c0d00fe8:	42b4      	cmp	r4, r6
c0d00fea:	d3f2      	bcc.n	c0d00fd2 <test_hex_nibble_parsing+0x22>
	}

	struct {
		char nibble;
	} invalidVectors[] = {
c0d00fec:	4828      	ldr	r0, [pc, #160]	; (c0d01090 <test_hex_nibble_parsing+0xe0>)
c0d00fee:	4478      	add	r0, pc
c0d00ff0:	ad0d      	add	r5, sp, #52	; 0x34
c0d00ff2:	4629      	mov	r1, r5
c0d00ff4:	c80c      	ldmia	r0!, {r2, r3}
c0d00ff6:	c10c      	stmia	r1!, {r2, r3}
c0d00ff8:	c81c      	ldmia	r0!, {r2, r3, r4}
c0d00ffa:	c11c      	stmia	r1!, {r2, r3, r4}
c0d00ffc:	8800      	ldrh	r0, [r0, #0]
c0d00ffe:	8008      	strh	r0, [r1, #0]
		{'g'}, {'h'},
		{'z'}, {'{'},
		{127}, {128u},
		{255u},
	};
	PRINTF("test_hex_nibble invalid\n");
c0d01000:	4824      	ldr	r0, [pc, #144]	; (c0d01094 <test_hex_nibble_parsing+0xe4>)
c0d01002:	4478      	add	r0, pc
c0d01004:	f001 fe1e 	bl	c0d02c44 <mcu_usb_printf>
	ITERATE(it, invalidVectors) {
c0d01008:	462e      	mov	r6, r5
c0d0100a:	3616      	adds	r6, #22
c0d0100c:	4f1c      	ldr	r7, [pc, #112]	; (c0d01080 <test_hex_nibble_parsing+0xd0>)
c0d0100e:	ac01      	add	r4, sp, #4
		EXPECT_THROWS(hex_parseNibble(it->nibble), ERR_UNEXPECTED_TOKEN);
c0d01010:	4620      	mov	r0, r4
c0d01012:	f007 fac5 	bl	c0d085a0 <setjmp>
c0d01016:	85a0      	strh	r0, [r4, #44]	; 0x2c
c0d01018:	b280      	uxth	r0, r0
c0d0101a:	42b8      	cmp	r0, r7
c0d0101c:	d00a      	beq.n	c0d01034 <test_hex_nibble_parsing+0x84>
c0d0101e:	2800      	cmp	r0, #0
c0d01020:	d110      	bne.n	c0d01044 <test_hex_nibble_parsing+0x94>
c0d01022:	a801      	add	r0, sp, #4
c0d01024:	f004 fb00 	bl	c0d05628 <try_context_set>
c0d01028:	900b      	str	r0, [sp, #44]	; 0x2c
c0d0102a:	7828      	ldrb	r0, [r5, #0]
c0d0102c:	f7ff ff32 	bl	c0d00e94 <hex_parseNibble>
c0d01030:	2400      	movs	r4, #0
c0d01032:	e00d      	b.n	c0d01050 <test_hex_nibble_parsing+0xa0>
c0d01034:	a801      	add	r0, sp, #4
c0d01036:	2100      	movs	r1, #0
c0d01038:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d0103a:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d0103c:	f004 faf4 	bl	c0d05628 <try_context_set>
c0d01040:	2401      	movs	r4, #1
c0d01042:	e005      	b.n	c0d01050 <test_hex_nibble_parsing+0xa0>
c0d01044:	a801      	add	r0, sp, #4
c0d01046:	2400      	movs	r4, #0
c0d01048:	8584      	strh	r4, [r0, #44]	; 0x2c
c0d0104a:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d0104c:	f004 faec 	bl	c0d05628 <try_context_set>
c0d01050:	f004 fade 	bl	c0d05610 <try_context_get>
c0d01054:	a901      	add	r1, sp, #4
c0d01056:	4288      	cmp	r0, r1
c0d01058:	d102      	bne.n	c0d01060 <test_hex_nibble_parsing+0xb0>
c0d0105a:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d0105c:	f004 fae4 	bl	c0d05628 <try_context_set>
c0d01060:	490d      	ldr	r1, [pc, #52]	; (c0d01098 <test_hex_nibble_parsing+0xe8>)
c0d01062:	4479      	add	r1, pc
c0d01064:	4620      	mov	r0, r4
c0d01066:	f7ff f803 	bl	c0d00070 <assert>
c0d0106a:	a801      	add	r0, sp, #4
c0d0106c:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d0106e:	2800      	cmp	r0, #0
c0d01070:	d104      	bne.n	c0d0107c <test_hex_nibble_parsing+0xcc>
	ITERATE(it, invalidVectors) {
c0d01072:	1c6d      	adds	r5, r5, #1
c0d01074:	42b5      	cmp	r5, r6
c0d01076:	d3ca      	bcc.n	c0d0100e <test_hex_nibble_parsing+0x5e>
	}
}
c0d01078:	b03f      	add	sp, #252	; 0xfc
c0d0107a:	bdf0      	pop	{r4, r5, r6, r7, pc}
		EXPECT_THROWS(hex_parseNibble(it->nibble), ERR_UNEXPECTED_TOKEN);
c0d0107c:	f001 f88a 	bl	c0d02194 <os_longjmp>
c0d01080:	00004720 	.word	0x00004720
c0d01084:	00007d0c 	.word	0x00007d0c
c0d01088:	00007c75 	.word	0x00007c75
c0d0108c:	00007c7a 	.word	0x00007c7a
c0d01090:	00007d86 	.word	0x00007d86
c0d01094:	00007c5a 	.word	0x00007c5a
c0d01098:	00007c13 	.word	0x00007c13

c0d0109c <test_hex_parsing>:

void test_hex_parsing()
{
c0d0109c:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0109e:	b091      	sub	sp, #68	; 0x44
	struct {
		char* hex;
		uint8_t raw;
	} testVectors[] = {
c0d010a0:	4817      	ldr	r0, [pc, #92]	; (c0d01100 <test_hex_parsing+0x64>)
c0d010a2:	4478      	add	r0, pc
c0d010a4:	af01      	add	r7, sp, #4
c0d010a6:	4639      	mov	r1, r7
c0d010a8:	c83c      	ldmia	r0!, {r2, r3, r4, r5}
c0d010aa:	c13c      	stmia	r1!, {r2, r3, r4, r5}
c0d010ac:	c83c      	ldmia	r0!, {r2, r3, r4, r5}
c0d010ae:	c13c      	stmia	r1!, {r2, r3, r4, r5}
c0d010b0:	c83c      	ldmia	r0!, {r2, r3, r4, r5}
c0d010b2:	c13c      	stmia	r1!, {r2, r3, r4, r5}
c0d010b4:	c83c      	ldmia	r0!, {r2, r3, r4, r5}
c0d010b6:	c13c      	stmia	r1!, {r2, r3, r4, r5}
		{"4d", 0x4d},
		{"5f", 0x5f},
		{"98", 0x98},
	};

	PRINTF("test_hex_parsing\n");
c0d010b8:	4812      	ldr	r0, [pc, #72]	; (c0d01104 <test_hex_parsing+0x68>)
c0d010ba:	4478      	add	r0, pc
c0d010bc:	f001 fdc2 	bl	c0d02c44 <mcu_usb_printf>
	ITERATE(it, testVectors) {
c0d010c0:	463c      	mov	r4, r7
c0d010c2:	3440      	adds	r4, #64	; 0x40
c0d010c4:	4810      	ldr	r0, [pc, #64]	; (c0d01108 <test_hex_parsing+0x6c>)
c0d010c6:	4478      	add	r0, pc
c0d010c8:	9000      	str	r0, [sp, #0]
		EXPECT_EQ(hex_parseNibblePair(PTR_PIC(it->hex)), it->raw);
c0d010ca:	6838      	ldr	r0, [r7, #0]
c0d010cc:	f002 f92c 	bl	c0d03328 <pic>
c0d010d0:	4605      	mov	r5, r0
	uint8_t first = hex_parseNibble(buffer[0]);
c0d010d2:	7800      	ldrb	r0, [r0, #0]
c0d010d4:	f7ff fede 	bl	c0d00e94 <hex_parseNibble>
c0d010d8:	4606      	mov	r6, r0
	uint8_t second = hex_parseNibble(buffer[1]);
c0d010da:	7868      	ldrb	r0, [r5, #1]
c0d010dc:	f7ff feda 	bl	c0d00e94 <hex_parseNibble>
	return (uint8_t) ((first << 4) + second);
c0d010e0:	0131      	lsls	r1, r6, #4
c0d010e2:	1840      	adds	r0, r0, r1
c0d010e4:	b2c0      	uxtb	r0, r0
		EXPECT_EQ(hex_parseNibblePair(PTR_PIC(it->hex)), it->raw);
c0d010e6:	7939      	ldrb	r1, [r7, #4]
c0d010e8:	1a41      	subs	r1, r0, r1
c0d010ea:	4248      	negs	r0, r1
c0d010ec:	4148      	adcs	r0, r1
c0d010ee:	9900      	ldr	r1, [sp, #0]
c0d010f0:	f7fe ffbe 	bl	c0d00070 <assert>
	ITERATE(it, testVectors) {
c0d010f4:	3708      	adds	r7, #8
c0d010f6:	42a7      	cmp	r7, r4
c0d010f8:	d3e7      	bcc.n	c0d010ca <test_hex_parsing+0x2e>
	}
}
c0d010fa:	b011      	add	sp, #68	; 0x44
c0d010fc:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d010fe:	46c0      	nop			; (mov r8, r8)
c0d01100:	00007cea 	.word	0x00007cea
c0d01104:	00007be3 	.word	0x00007be3
c0d01108:	00007be9 	.word	0x00007be9

c0d0110c <run_hex_test>:

#ifdef DEVEL
void run_hex_test()
{
c0d0110c:	b580      	push	{r7, lr}
	test_hex_nibble_parsing();
c0d0110e:	f7ff ff4f 	bl	c0d00fb0 <test_hex_nibble_parsing>
	test_hex_parsing();
c0d01112:	f7ff ffc3 	bl	c0d0109c <test_hex_parsing>
}
c0d01116:	bd80      	pop	{r7, pc}

c0d01118 <nanos_clear_timer>:
#if defined(TARGET_NANOS)
static timeout_callback_fn_t* timeout_cb;

void nanos_clear_timer()
{
	timeout_cb = NULL;
c0d01118:	4801      	ldr	r0, [pc, #4]	; (c0d01120 <nanos_clear_timer+0x8>)
c0d0111a:	2100      	movs	r1, #0
c0d0111c:	6001      	str	r1, [r0, #0]
}
c0d0111e:	4770      	bx	lr
c0d01120:	20000200 	.word	0x20000200

c0d01124 <_io_send_G_io_apdu_buffer>:
// io_exchange_with_code is a helper function for sending response APDUs from
// button handlers. Note that the IO_RETURN_AFTER_TX flag is set. 'tx' is the
// conventional name for the size of the response APDU, i.e. the write-offset
// within G_io_apdu_buffer.
void _io_send_G_io_apdu_buffer(uint16_t code, uint16_t tx)
{
c0d01124:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d01126:	b081      	sub	sp, #4
c0d01128:	460c      	mov	r4, r1
c0d0112a:	4605      	mov	r5, r0
c0d0112c:	27ff      	movs	r7, #255	; 0xff
c0d0112e:	3750      	adds	r7, #80	; 0x50
	ASSERT(tx < sizeof(G_io_apdu_buffer));
c0d01130:	1cb8      	adds	r0, r7, #2
c0d01132:	2601      	movs	r6, #1
c0d01134:	2100      	movs	r1, #0
c0d01136:	4284      	cmp	r4, r0
c0d01138:	4630      	mov	r0, r6
c0d0113a:	d300      	bcc.n	c0d0113e <_io_send_G_io_apdu_buffer+0x1a>
c0d0113c:	4608      	mov	r0, r1
c0d0113e:	9100      	str	r1, [sp, #0]
c0d01140:	490f      	ldr	r1, [pc, #60]	; (c0d01180 <_io_send_G_io_apdu_buffer+0x5c>)
c0d01142:	4479      	add	r1, pc
c0d01144:	f7fe ff94 	bl	c0d00070 <assert>
	ASSERT(tx + 2u < sizeof(G_io_apdu_buffer));
c0d01148:	42bc      	cmp	r4, r7
c0d0114a:	d300      	bcc.n	c0d0114e <_io_send_G_io_apdu_buffer+0x2a>
c0d0114c:	9e00      	ldr	r6, [sp, #0]
c0d0114e:	490d      	ldr	r1, [pc, #52]	; (c0d01184 <_io_send_G_io_apdu_buffer+0x60>)
c0d01150:	4479      	add	r1, pc
c0d01152:	4630      	mov	r0, r6
c0d01154:	f7fe ff8c 	bl	c0d00070 <assert>
	CHECK_RESPONSE_SIZE(tx);
	G_io_apdu_buffer[tx++] = code >> 8;
c0d01158:	1c60      	adds	r0, r4, #1
	G_io_apdu_buffer[tx++] = code & 0xFF;
c0d0115a:	b280      	uxth	r0, r0
	G_io_apdu_buffer[tx++] = code >> 8;
c0d0115c:	4906      	ldr	r1, [pc, #24]	; (c0d01178 <_io_send_G_io_apdu_buffer+0x54>)
	G_io_apdu_buffer[tx++] = code & 0xFF;
c0d0115e:	540d      	strb	r5, [r1, r0]
	G_io_apdu_buffer[tx++] = code >> 8;
c0d01160:	0a28      	lsrs	r0, r5, #8
c0d01162:	5508      	strb	r0, [r1, r4]
	G_io_apdu_buffer[tx++] = code & 0xFF;
c0d01164:	1ca0      	adds	r0, r4, #2
	io_exchange(CHANNEL_APDU | IO_RETURN_AFTER_TX, tx);
c0d01166:	b281      	uxth	r1, r0
c0d01168:	2020      	movs	r0, #32
c0d0116a:	f001 fa3d 	bl	c0d025e8 <io_exchange>

	// From now on we can receive new APDU
	io_state = IO_EXPECT_IO;
c0d0116e:	4803      	ldr	r0, [pc, #12]	; (c0d0117c <_io_send_G_io_apdu_buffer+0x58>)
c0d01170:	212a      	movs	r1, #42	; 0x2a
c0d01172:	7001      	strb	r1, [r0, #0]
}
c0d01174:	b001      	add	sp, #4
c0d01176:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d01178:	20000285 	.word	0x20000285
c0d0117c:	20000204 	.word	0x20000204
c0d01180:	00007ca2 	.word	0x00007ca2
c0d01184:	00007ca0 	.word	0x00007ca0

c0d01188 <io_send_buf>:

void io_send_buf(uint16_t code, uint8_t* buffer, size_t bufferSize)
{
c0d01188:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0118a:	b083      	sub	sp, #12
c0d0118c:	4614      	mov	r4, r2
c0d0118e:	9101      	str	r1, [sp, #4]
c0d01190:	9002      	str	r0, [sp, #8]
c0d01192:	25ff      	movs	r5, #255	; 0xff
c0d01194:	3552      	adds	r5, #82	; 0x52
c0d01196:	2701      	movs	r7, #1
c0d01198:	2600      	movs	r6, #0
	ASSERT(tx < sizeof(G_io_apdu_buffer));
c0d0119a:	42aa      	cmp	r2, r5
c0d0119c:	4638      	mov	r0, r7
c0d0119e:	d300      	bcc.n	c0d011a2 <io_send_buf+0x1a>
c0d011a0:	4630      	mov	r0, r6
c0d011a2:	490d      	ldr	r1, [pc, #52]	; (c0d011d8 <io_send_buf+0x50>)
c0d011a4:	4479      	add	r1, pc
c0d011a6:	f7fe ff63 	bl	c0d00070 <assert>
	ASSERT(tx + 2u < sizeof(G_io_apdu_buffer));
c0d011aa:	1ca0      	adds	r0, r4, #2
c0d011ac:	42a8      	cmp	r0, r5
c0d011ae:	d300      	bcc.n	c0d011b2 <io_send_buf+0x2a>
c0d011b0:	4637      	mov	r7, r6
c0d011b2:	490a      	ldr	r1, [pc, #40]	; (c0d011dc <io_send_buf+0x54>)
c0d011b4:	4479      	add	r1, pc
c0d011b6:	4638      	mov	r0, r7
c0d011b8:	f7fe ff5a 	bl	c0d00070 <assert>
	CHECK_RESPONSE_SIZE(bufferSize);

	memmove(G_io_apdu_buffer, buffer, bufferSize);
c0d011bc:	4805      	ldr	r0, [pc, #20]	; (c0d011d4 <io_send_buf+0x4c>)
c0d011be:	9901      	ldr	r1, [sp, #4]
c0d011c0:	4622      	mov	r2, r4
c0d011c2:	f007 f9ac 	bl	c0d0851e <__aeabi_memmove>
	_io_send_G_io_apdu_buffer(code, bufferSize);
c0d011c6:	b2a1      	uxth	r1, r4
c0d011c8:	9802      	ldr	r0, [sp, #8]
c0d011ca:	f7ff ffab 	bl	c0d01124 <_io_send_G_io_apdu_buffer>
}
c0d011ce:	b003      	add	sp, #12
c0d011d0:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d011d2:	46c0      	nop			; (mov r8, r8)
c0d011d4:	20000285 	.word	0x20000285
c0d011d8:	00007c40 	.word	0x00007c40
c0d011dc:	00007c3c 	.word	0x00007c3c

c0d011e0 <io_seproxyhal_display>:

// Everything below this point is Ledger magic.

// override point, but nothing more to do
void io_seproxyhal_display(const bagl_element_t *element)
{
c0d011e0:	b580      	push	{r7, lr}
	io_seproxyhal_display_default((bagl_element_t *)element);
c0d011e2:	f001 f95f 	bl	c0d024a4 <io_seproxyhal_display_default>
}
c0d011e6:	bd80      	pop	{r7, pc}

c0d011e8 <io_event>:

unsigned char G_io_seproxyhal_spi_buffer[IO_SEPROXYHAL_BUFFER_SIZE_B];

unsigned char io_event(unsigned char channel MARK_UNUSED)
{
c0d011e8:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d011ea:	b081      	sub	sp, #4
	// can't have more than one tag in the reply, not supported yet.
	switch (G_io_seproxyhal_spi_buffer[0]) {
c0d011ec:	4eec      	ldr	r6, [pc, #944]	; (c0d015a0 <io_event+0x3b8>)
c0d011ee:	7830      	ldrb	r0, [r6, #0]
c0d011f0:	280c      	cmp	r0, #12
c0d011f2:	dd62      	ble.n	c0d012ba <io_event+0xd2>
c0d011f4:	280d      	cmp	r0, #13
c0d011f6:	d06c      	beq.n	c0d012d2 <io_event+0xea>
c0d011f8:	280e      	cmp	r0, #14
c0d011fa:	d100      	bne.n	c0d011fe <io_event+0x16>
c0d011fc:	e0b3      	b.n	c0d01366 <io_event+0x17e>
c0d011fe:	2815      	cmp	r0, #21
c0d01200:	d000      	beq.n	c0d01204 <io_event+0x1c>
c0d01202:	e15d      	b.n	c0d014c0 <io_event+0x2d8>
	case SEPROXYHAL_TAG_BUTTON_PUSH_EVENT:
		UX_BUTTON_PUSH_EVENT(G_io_seproxyhal_spi_buffer);
		break;

	case SEPROXYHAL_TAG_STATUS_EVENT:
		if (G_io_apdu_media == IO_APDU_MEDIA_USB_HID &&
c0d01204:	48e7      	ldr	r0, [pc, #924]	; (c0d015a4 <io_event+0x3bc>)
c0d01206:	7980      	ldrb	r0, [r0, #6]
c0d01208:	2801      	cmp	r0, #1
c0d0120a:	d103      	bne.n	c0d01214 <io_event+0x2c>
static inline uint16_t U2BE(const uint8_t *buf, size_t off) {
  return (buf[off] << 8) | buf[off + 1];
}
static inline uint32_t U4BE(const uint8_t *buf, size_t off) {
  return (((uint32_t)buf[off]) << 24) | (buf[off + 1] << 16) |
         (buf[off + 2] << 8) | buf[off + 3];
c0d0120c:	79b0      	ldrb	r0, [r6, #6]
c0d0120e:	0700      	lsls	r0, r0, #28
c0d01210:	d400      	bmi.n	c0d01214 <io_event+0x2c>
c0d01212:	e2fe      	b.n	c0d01812 <io_event+0x62a>
c0d01214:	2064      	movs	r0, #100	; 0x64
		    !(U4BE(G_io_seproxyhal_spi_buffer, 3) &
		      SEPROXYHAL_TAG_STATUS_EVENT_FLAG_USB_POWERED)) {
			THROW(EXCEPTION_IO_RESET);
		}
		UX_DEFAULT_EVENT();
c0d01216:	4dfd      	ldr	r5, [pc, #1012]	; (c0d0160c <io_event+0x424>)
c0d01218:	2101      	movs	r1, #1
c0d0121a:	5429      	strb	r1, [r5, r0]
c0d0121c:	462c      	mov	r4, r5
c0d0121e:	3464      	adds	r4, #100	; 0x64
c0d01220:	2600      	movs	r6, #0
c0d01222:	6066      	str	r6, [r4, #4]
c0d01224:	4620      	mov	r0, r4
c0d01226:	f004 f98d 	bl	c0d05544 <os_ux>
c0d0122a:	2004      	movs	r0, #4
c0d0122c:	f004 fa0a 	bl	c0d05644 <os_sched_last_status>
c0d01230:	6060      	str	r0, [r4, #4]
c0d01232:	2869      	cmp	r0, #105	; 0x69
c0d01234:	d000      	beq.n	c0d01238 <io_event+0x50>
c0d01236:	e1b7      	b.n	c0d015a8 <io_event+0x3c0>
c0d01238:	f001 f8de 	bl	c0d023f8 <io_seproxyhal_init_ux>
c0d0123c:	f001 f8de 	bl	c0d023fc <io_seproxyhal_init_button>
c0d01240:	84ee      	strh	r6, [r5, #38]	; 0x26
c0d01242:	2004      	movs	r0, #4
c0d01244:	f004 f9fe 	bl	c0d05644 <os_sched_last_status>
c0d01248:	66a8      	str	r0, [r5, #104]	; 0x68
c0d0124a:	2800      	cmp	r0, #0
c0d0124c:	d100      	bne.n	c0d01250 <io_event+0x68>
c0d0124e:	e289      	b.n	c0d01764 <io_event+0x57c>
c0d01250:	2897      	cmp	r0, #151	; 0x97
c0d01252:	d100      	bne.n	c0d01256 <io_event+0x6e>
c0d01254:	e286      	b.n	c0d01764 <io_event+0x57c>
c0d01256:	6aa8      	ldr	r0, [r5, #40]	; 0x28
c0d01258:	2800      	cmp	r0, #0
c0d0125a:	d100      	bne.n	c0d0125e <io_event+0x76>
c0d0125c:	e282      	b.n	c0d01764 <io_event+0x57c>
c0d0125e:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d01260:	212c      	movs	r1, #44	; 0x2c
c0d01262:	5c69      	ldrb	r1, [r5, r1]
c0d01264:	b280      	uxth	r0, r0
c0d01266:	4288      	cmp	r0, r1
c0d01268:	d300      	bcc.n	c0d0126c <io_event+0x84>
c0d0126a:	e27b      	b.n	c0d01764 <io_event+0x57c>
c0d0126c:	f004 f9b6 	bl	c0d055dc <io_seph_is_status_sent>
c0d01270:	2800      	cmp	r0, #0
c0d01272:	d000      	beq.n	c0d01276 <io_event+0x8e>
c0d01274:	e276      	b.n	c0d01764 <io_event+0x57c>
c0d01276:	f004 f92d 	bl	c0d054d4 <os_perso_isonboarded>
c0d0127a:	28aa      	cmp	r0, #170	; 0xaa
c0d0127c:	d104      	bne.n	c0d01288 <io_event+0xa0>
c0d0127e:	f004 f953 	bl	c0d05528 <os_global_pin_is_validated>
c0d01282:	28aa      	cmp	r0, #170	; 0xaa
c0d01284:	d000      	beq.n	c0d01288 <io_event+0xa0>
c0d01286:	e26d      	b.n	c0d01764 <io_event+0x57c>
c0d01288:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d0128a:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d0128c:	0150      	lsls	r0, r2, #5
c0d0128e:	1808      	adds	r0, r1, r0
c0d01290:	6b2b      	ldr	r3, [r5, #48]	; 0x30
c0d01292:	2b00      	cmp	r3, #0
c0d01294:	d004      	beq.n	c0d012a0 <io_event+0xb8>
c0d01296:	4798      	blx	r3
c0d01298:	2800      	cmp	r0, #0
c0d0129a:	d007      	beq.n	c0d012ac <io_event+0xc4>
c0d0129c:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d0129e:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d012a0:	2801      	cmp	r0, #1
c0d012a2:	d101      	bne.n	c0d012a8 <io_event+0xc0>
c0d012a4:	0150      	lsls	r0, r2, #5
c0d012a6:	1808      	adds	r0, r1, r0
	io_seproxyhal_display_default((bagl_element_t *)element);
c0d012a8:	f001 f8fc 	bl	c0d024a4 <io_seproxyhal_display_default>
		UX_DEFAULT_EVENT();
c0d012ac:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d012ae:	1c40      	adds	r0, r0, #1
c0d012b0:	84e8      	strh	r0, [r5, #38]	; 0x26
c0d012b2:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d012b4:	2900      	cmp	r1, #0
c0d012b6:	d1d3      	bne.n	c0d01260 <io_event+0x78>
c0d012b8:	e254      	b.n	c0d01764 <io_event+0x57c>
	switch (G_io_seproxyhal_spi_buffer[0]) {
c0d012ba:	2805      	cmp	r0, #5
c0d012bc:	d100      	bne.n	c0d012c0 <io_event+0xd8>
c0d012be:	e0a6      	b.n	c0d0140e <io_event+0x226>
c0d012c0:	280c      	cmp	r0, #12
c0d012c2:	d000      	beq.n	c0d012c6 <io_event+0xde>
c0d012c4:	e0fc      	b.n	c0d014c0 <io_event+0x2d8>
c0d012c6:	2000      	movs	r0, #0
		ASSERT(false);
c0d012c8:	49d1      	ldr	r1, [pc, #836]	; (c0d01610 <io_event+0x428>)
c0d012ca:	4479      	add	r1, pc
c0d012cc:	f7fe fed0 	bl	c0d00070 <assert>
c0d012d0:	e248      	b.n	c0d01764 <io_event+0x57c>
c0d012d2:	2064      	movs	r0, #100	; 0x64
		break;

	case SEPROXYHAL_TAG_DISPLAY_PROCESSED_EVENT:
		UX_DISPLAYED_EVENT({});
c0d012d4:	4dcd      	ldr	r5, [pc, #820]	; (c0d0160c <io_event+0x424>)
c0d012d6:	2101      	movs	r1, #1
c0d012d8:	5429      	strb	r1, [r5, r0]
c0d012da:	462c      	mov	r4, r5
c0d012dc:	3464      	adds	r4, #100	; 0x64
c0d012de:	2600      	movs	r6, #0
c0d012e0:	6066      	str	r6, [r4, #4]
c0d012e2:	4620      	mov	r0, r4
c0d012e4:	f004 f92e 	bl	c0d05544 <os_ux>
c0d012e8:	2004      	movs	r0, #4
c0d012ea:	f004 f9ab 	bl	c0d05644 <os_sched_last_status>
c0d012ee:	6060      	str	r0, [r4, #4]
c0d012f0:	2800      	cmp	r0, #0
c0d012f2:	d100      	bne.n	c0d012f6 <io_event+0x10e>
c0d012f4:	e236      	b.n	c0d01764 <io_event+0x57c>
c0d012f6:	2869      	cmp	r0, #105	; 0x69
c0d012f8:	d100      	bne.n	c0d012fc <io_event+0x114>
c0d012fa:	e1bd      	b.n	c0d01678 <io_event+0x490>
c0d012fc:	2897      	cmp	r0, #151	; 0x97
c0d012fe:	d100      	bne.n	c0d01302 <io_event+0x11a>
c0d01300:	e230      	b.n	c0d01764 <io_event+0x57c>
c0d01302:	6aa8      	ldr	r0, [r5, #40]	; 0x28
c0d01304:	2800      	cmp	r0, #0
c0d01306:	d100      	bne.n	c0d0130a <io_event+0x122>
c0d01308:	e225      	b.n	c0d01756 <io_event+0x56e>
c0d0130a:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d0130c:	212c      	movs	r1, #44	; 0x2c
c0d0130e:	5c69      	ldrb	r1, [r5, r1]
c0d01310:	b280      	uxth	r0, r0
c0d01312:	4288      	cmp	r0, r1
c0d01314:	d300      	bcc.n	c0d01318 <io_event+0x130>
c0d01316:	e21e      	b.n	c0d01756 <io_event+0x56e>
c0d01318:	f004 f960 	bl	c0d055dc <io_seph_is_status_sent>
c0d0131c:	2800      	cmp	r0, #0
c0d0131e:	d000      	beq.n	c0d01322 <io_event+0x13a>
c0d01320:	e219      	b.n	c0d01756 <io_event+0x56e>
c0d01322:	f004 f8d7 	bl	c0d054d4 <os_perso_isonboarded>
c0d01326:	28aa      	cmp	r0, #170	; 0xaa
c0d01328:	d104      	bne.n	c0d01334 <io_event+0x14c>
c0d0132a:	f004 f8fd 	bl	c0d05528 <os_global_pin_is_validated>
c0d0132e:	28aa      	cmp	r0, #170	; 0xaa
c0d01330:	d000      	beq.n	c0d01334 <io_event+0x14c>
c0d01332:	e210      	b.n	c0d01756 <io_event+0x56e>
c0d01334:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d01336:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d01338:	0150      	lsls	r0, r2, #5
c0d0133a:	1808      	adds	r0, r1, r0
c0d0133c:	6b2b      	ldr	r3, [r5, #48]	; 0x30
c0d0133e:	2b00      	cmp	r3, #0
c0d01340:	d004      	beq.n	c0d0134c <io_event+0x164>
c0d01342:	4798      	blx	r3
c0d01344:	2800      	cmp	r0, #0
c0d01346:	d007      	beq.n	c0d01358 <io_event+0x170>
c0d01348:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d0134a:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d0134c:	2801      	cmp	r0, #1
c0d0134e:	d101      	bne.n	c0d01354 <io_event+0x16c>
c0d01350:	0150      	lsls	r0, r2, #5
c0d01352:	1808      	adds	r0, r1, r0
	io_seproxyhal_display_default((bagl_element_t *)element);
c0d01354:	f001 f8a6 	bl	c0d024a4 <io_seproxyhal_display_default>
		UX_DISPLAYED_EVENT({});
c0d01358:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d0135a:	1c40      	adds	r0, r0, #1
c0d0135c:	84e8      	strh	r0, [r5, #38]	; 0x26
c0d0135e:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d01360:	2900      	cmp	r1, #0
c0d01362:	d1d3      	bne.n	c0d0130c <io_event+0x124>
c0d01364:	e1f7      	b.n	c0d01756 <io_event+0x56e>
c0d01366:	2064      	movs	r0, #100	; 0x64
		break;

	case SEPROXYHAL_TAG_TICKER_EVENT:
		UX_TICKER_EVENT(G_io_seproxyhal_spi_buffer, {
c0d01368:	4ea8      	ldr	r6, [pc, #672]	; (c0d0160c <io_event+0x424>)
c0d0136a:	2101      	movs	r1, #1
c0d0136c:	5431      	strb	r1, [r6, r0]
c0d0136e:	4635      	mov	r5, r6
c0d01370:	3564      	adds	r5, #100	; 0x64
c0d01372:	2700      	movs	r7, #0
c0d01374:	606f      	str	r7, [r5, #4]
c0d01376:	4628      	mov	r0, r5
c0d01378:	f004 f8e4 	bl	c0d05544 <os_ux>
c0d0137c:	2004      	movs	r0, #4
c0d0137e:	f004 f961 	bl	c0d05644 <os_sched_last_status>
c0d01382:	6068      	str	r0, [r5, #4]
c0d01384:	2869      	cmp	r0, #105	; 0x69
c0d01386:	d000      	beq.n	c0d0138a <io_event+0x1a2>
c0d01388:	e0ed      	b.n	c0d01566 <io_event+0x37e>
c0d0138a:	f001 f835 	bl	c0d023f8 <io_seproxyhal_init_ux>
c0d0138e:	f001 f835 	bl	c0d023fc <io_seproxyhal_init_button>
c0d01392:	2000      	movs	r0, #0
c0d01394:	84f0      	strh	r0, [r6, #38]	; 0x26
c0d01396:	2004      	movs	r0, #4
c0d01398:	f004 f954 	bl	c0d05644 <os_sched_last_status>
c0d0139c:	66b0      	str	r0, [r6, #104]	; 0x68
c0d0139e:	2800      	cmp	r0, #0
c0d013a0:	d100      	bne.n	c0d013a4 <io_event+0x1bc>
c0d013a2:	e1df      	b.n	c0d01764 <io_event+0x57c>
c0d013a4:	2897      	cmp	r0, #151	; 0x97
c0d013a6:	d100      	bne.n	c0d013aa <io_event+0x1c2>
c0d013a8:	e1dc      	b.n	c0d01764 <io_event+0x57c>
c0d013aa:	6ab0      	ldr	r0, [r6, #40]	; 0x28
c0d013ac:	2800      	cmp	r0, #0
c0d013ae:	d100      	bne.n	c0d013b2 <io_event+0x1ca>
c0d013b0:	e1d8      	b.n	c0d01764 <io_event+0x57c>
c0d013b2:	8cf0      	ldrh	r0, [r6, #38]	; 0x26
c0d013b4:	212c      	movs	r1, #44	; 0x2c
c0d013b6:	5c71      	ldrb	r1, [r6, r1]
c0d013b8:	b280      	uxth	r0, r0
c0d013ba:	4288      	cmp	r0, r1
c0d013bc:	d300      	bcc.n	c0d013c0 <io_event+0x1d8>
c0d013be:	e1d1      	b.n	c0d01764 <io_event+0x57c>
c0d013c0:	f004 f90c 	bl	c0d055dc <io_seph_is_status_sent>
c0d013c4:	2800      	cmp	r0, #0
c0d013c6:	d000      	beq.n	c0d013ca <io_event+0x1e2>
c0d013c8:	e1cc      	b.n	c0d01764 <io_event+0x57c>
c0d013ca:	f004 f883 	bl	c0d054d4 <os_perso_isonboarded>
c0d013ce:	28aa      	cmp	r0, #170	; 0xaa
c0d013d0:	d104      	bne.n	c0d013dc <io_event+0x1f4>
c0d013d2:	f004 f8a9 	bl	c0d05528 <os_global_pin_is_validated>
c0d013d6:	28aa      	cmp	r0, #170	; 0xaa
c0d013d8:	d000      	beq.n	c0d013dc <io_event+0x1f4>
c0d013da:	e1c3      	b.n	c0d01764 <io_event+0x57c>
c0d013dc:	6ab1      	ldr	r1, [r6, #40]	; 0x28
c0d013de:	8cf2      	ldrh	r2, [r6, #38]	; 0x26
c0d013e0:	0150      	lsls	r0, r2, #5
c0d013e2:	1808      	adds	r0, r1, r0
c0d013e4:	6b33      	ldr	r3, [r6, #48]	; 0x30
c0d013e6:	2b00      	cmp	r3, #0
c0d013e8:	d004      	beq.n	c0d013f4 <io_event+0x20c>
c0d013ea:	4798      	blx	r3
c0d013ec:	2800      	cmp	r0, #0
c0d013ee:	d007      	beq.n	c0d01400 <io_event+0x218>
c0d013f0:	8cf2      	ldrh	r2, [r6, #38]	; 0x26
c0d013f2:	6ab1      	ldr	r1, [r6, #40]	; 0x28
c0d013f4:	2801      	cmp	r0, #1
c0d013f6:	d101      	bne.n	c0d013fc <io_event+0x214>
c0d013f8:	0150      	lsls	r0, r2, #5
c0d013fa:	1808      	adds	r0, r1, r0
	io_seproxyhal_display_default((bagl_element_t *)element);
c0d013fc:	f001 f852 	bl	c0d024a4 <io_seproxyhal_display_default>
		UX_TICKER_EVENT(G_io_seproxyhal_spi_buffer, {
c0d01400:	8cf0      	ldrh	r0, [r6, #38]	; 0x26
c0d01402:	1c40      	adds	r0, r0, #1
c0d01404:	84f0      	strh	r0, [r6, #38]	; 0x26
c0d01406:	6ab1      	ldr	r1, [r6, #40]	; 0x28
c0d01408:	2900      	cmp	r1, #0
c0d0140a:	d1d3      	bne.n	c0d013b4 <io_event+0x1cc>
c0d0140c:	e1aa      	b.n	c0d01764 <io_event+0x57c>
c0d0140e:	2064      	movs	r0, #100	; 0x64
		UX_BUTTON_PUSH_EVENT(G_io_seproxyhal_spi_buffer);
c0d01410:	4d7e      	ldr	r5, [pc, #504]	; (c0d0160c <io_event+0x424>)
c0d01412:	2101      	movs	r1, #1
c0d01414:	5429      	strb	r1, [r5, r0]
c0d01416:	462c      	mov	r4, r5
c0d01418:	3464      	adds	r4, #100	; 0x64
c0d0141a:	2700      	movs	r7, #0
c0d0141c:	6067      	str	r7, [r4, #4]
c0d0141e:	4620      	mov	r0, r4
c0d01420:	f004 f890 	bl	c0d05544 <os_ux>
c0d01424:	2004      	movs	r0, #4
c0d01426:	f004 f90d 	bl	c0d05644 <os_sched_last_status>
c0d0142a:	6060      	str	r0, [r4, #4]
c0d0142c:	2800      	cmp	r0, #0
c0d0142e:	d100      	bne.n	c0d01432 <io_event+0x24a>
c0d01430:	e198      	b.n	c0d01764 <io_event+0x57c>
c0d01432:	2897      	cmp	r0, #151	; 0x97
c0d01434:	d100      	bne.n	c0d01438 <io_event+0x250>
c0d01436:	e195      	b.n	c0d01764 <io_event+0x57c>
c0d01438:	2869      	cmp	r0, #105	; 0x69
c0d0143a:	d000      	beq.n	c0d0143e <io_event+0x256>
c0d0143c:	e157      	b.n	c0d016ee <io_event+0x506>
c0d0143e:	f000 ffdb 	bl	c0d023f8 <io_seproxyhal_init_ux>
c0d01442:	f000 ffdb 	bl	c0d023fc <io_seproxyhal_init_button>
c0d01446:	84ef      	strh	r7, [r5, #38]	; 0x26
c0d01448:	2004      	movs	r0, #4
c0d0144a:	f004 f8fb 	bl	c0d05644 <os_sched_last_status>
c0d0144e:	66a8      	str	r0, [r5, #104]	; 0x68
c0d01450:	2800      	cmp	r0, #0
c0d01452:	d100      	bne.n	c0d01456 <io_event+0x26e>
c0d01454:	e186      	b.n	c0d01764 <io_event+0x57c>
c0d01456:	2897      	cmp	r0, #151	; 0x97
c0d01458:	d100      	bne.n	c0d0145c <io_event+0x274>
c0d0145a:	e183      	b.n	c0d01764 <io_event+0x57c>
c0d0145c:	6aa8      	ldr	r0, [r5, #40]	; 0x28
c0d0145e:	2800      	cmp	r0, #0
c0d01460:	d100      	bne.n	c0d01464 <io_event+0x27c>
c0d01462:	e17f      	b.n	c0d01764 <io_event+0x57c>
c0d01464:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d01466:	212c      	movs	r1, #44	; 0x2c
c0d01468:	5c69      	ldrb	r1, [r5, r1]
c0d0146a:	b280      	uxth	r0, r0
c0d0146c:	4288      	cmp	r0, r1
c0d0146e:	d300      	bcc.n	c0d01472 <io_event+0x28a>
c0d01470:	e178      	b.n	c0d01764 <io_event+0x57c>
c0d01472:	f004 f8b3 	bl	c0d055dc <io_seph_is_status_sent>
c0d01476:	2800      	cmp	r0, #0
c0d01478:	d000      	beq.n	c0d0147c <io_event+0x294>
c0d0147a:	e173      	b.n	c0d01764 <io_event+0x57c>
c0d0147c:	f004 f82a 	bl	c0d054d4 <os_perso_isonboarded>
c0d01480:	28aa      	cmp	r0, #170	; 0xaa
c0d01482:	d104      	bne.n	c0d0148e <io_event+0x2a6>
c0d01484:	f004 f850 	bl	c0d05528 <os_global_pin_is_validated>
c0d01488:	28aa      	cmp	r0, #170	; 0xaa
c0d0148a:	d000      	beq.n	c0d0148e <io_event+0x2a6>
c0d0148c:	e16a      	b.n	c0d01764 <io_event+0x57c>
c0d0148e:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d01490:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d01492:	0150      	lsls	r0, r2, #5
c0d01494:	1808      	adds	r0, r1, r0
c0d01496:	6b2b      	ldr	r3, [r5, #48]	; 0x30
c0d01498:	2b00      	cmp	r3, #0
c0d0149a:	d004      	beq.n	c0d014a6 <io_event+0x2be>
c0d0149c:	4798      	blx	r3
c0d0149e:	2800      	cmp	r0, #0
c0d014a0:	d007      	beq.n	c0d014b2 <io_event+0x2ca>
c0d014a2:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d014a4:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d014a6:	2801      	cmp	r0, #1
c0d014a8:	d101      	bne.n	c0d014ae <io_event+0x2c6>
c0d014aa:	0150      	lsls	r0, r2, #5
c0d014ac:	1808      	adds	r0, r1, r0
	io_seproxyhal_display_default((bagl_element_t *)element);
c0d014ae:	f000 fff9 	bl	c0d024a4 <io_seproxyhal_display_default>
		UX_BUTTON_PUSH_EVENT(G_io_seproxyhal_spi_buffer);
c0d014b2:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d014b4:	1c40      	adds	r0, r0, #1
c0d014b6:	84e8      	strh	r0, [r5, #38]	; 0x26
c0d014b8:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d014ba:	2900      	cmp	r1, #0
c0d014bc:	d1d3      	bne.n	c0d01466 <io_event+0x27e>
c0d014be:	e151      	b.n	c0d01764 <io_event+0x57c>
c0d014c0:	2064      	movs	r0, #100	; 0x64
			HANDLE_UX_TICKER_EVENT(UX_ALLOWED);
		});
		break;

	default:
		UX_DEFAULT_EVENT();
c0d014c2:	4dd5      	ldr	r5, [pc, #852]	; (c0d01818 <io_event+0x630>)
c0d014c4:	2101      	movs	r1, #1
c0d014c6:	5429      	strb	r1, [r5, r0]
c0d014c8:	462c      	mov	r4, r5
c0d014ca:	3464      	adds	r4, #100	; 0x64
c0d014cc:	2600      	movs	r6, #0
c0d014ce:	6066      	str	r6, [r4, #4]
c0d014d0:	4620      	mov	r0, r4
c0d014d2:	f004 f837 	bl	c0d05544 <os_ux>
c0d014d6:	2004      	movs	r0, #4
c0d014d8:	f004 f8b4 	bl	c0d05644 <os_sched_last_status>
c0d014dc:	6060      	str	r0, [r4, #4]
c0d014de:	2869      	cmp	r0, #105	; 0x69
c0d014e0:	d000      	beq.n	c0d014e4 <io_event+0x2fc>
c0d014e2:	e097      	b.n	c0d01614 <io_event+0x42c>
c0d014e4:	f000 ff88 	bl	c0d023f8 <io_seproxyhal_init_ux>
c0d014e8:	f000 ff88 	bl	c0d023fc <io_seproxyhal_init_button>
c0d014ec:	84ee      	strh	r6, [r5, #38]	; 0x26
c0d014ee:	2004      	movs	r0, #4
c0d014f0:	f004 f8a8 	bl	c0d05644 <os_sched_last_status>
c0d014f4:	66a8      	str	r0, [r5, #104]	; 0x68
c0d014f6:	2800      	cmp	r0, #0
c0d014f8:	d100      	bne.n	c0d014fc <io_event+0x314>
c0d014fa:	e133      	b.n	c0d01764 <io_event+0x57c>
c0d014fc:	2897      	cmp	r0, #151	; 0x97
c0d014fe:	d100      	bne.n	c0d01502 <io_event+0x31a>
c0d01500:	e130      	b.n	c0d01764 <io_event+0x57c>
c0d01502:	6aa8      	ldr	r0, [r5, #40]	; 0x28
c0d01504:	2800      	cmp	r0, #0
c0d01506:	d100      	bne.n	c0d0150a <io_event+0x322>
c0d01508:	e12c      	b.n	c0d01764 <io_event+0x57c>
c0d0150a:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d0150c:	212c      	movs	r1, #44	; 0x2c
c0d0150e:	5c69      	ldrb	r1, [r5, r1]
c0d01510:	b280      	uxth	r0, r0
c0d01512:	4288      	cmp	r0, r1
c0d01514:	d300      	bcc.n	c0d01518 <io_event+0x330>
c0d01516:	e125      	b.n	c0d01764 <io_event+0x57c>
c0d01518:	f004 f860 	bl	c0d055dc <io_seph_is_status_sent>
c0d0151c:	2800      	cmp	r0, #0
c0d0151e:	d000      	beq.n	c0d01522 <io_event+0x33a>
c0d01520:	e120      	b.n	c0d01764 <io_event+0x57c>
c0d01522:	f003 ffd7 	bl	c0d054d4 <os_perso_isonboarded>
c0d01526:	28aa      	cmp	r0, #170	; 0xaa
c0d01528:	d104      	bne.n	c0d01534 <io_event+0x34c>
c0d0152a:	f003 fffd 	bl	c0d05528 <os_global_pin_is_validated>
c0d0152e:	28aa      	cmp	r0, #170	; 0xaa
c0d01530:	d000      	beq.n	c0d01534 <io_event+0x34c>
c0d01532:	e117      	b.n	c0d01764 <io_event+0x57c>
c0d01534:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d01536:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d01538:	0150      	lsls	r0, r2, #5
c0d0153a:	1808      	adds	r0, r1, r0
c0d0153c:	6b2b      	ldr	r3, [r5, #48]	; 0x30
c0d0153e:	2b00      	cmp	r3, #0
c0d01540:	d004      	beq.n	c0d0154c <io_event+0x364>
c0d01542:	4798      	blx	r3
c0d01544:	2800      	cmp	r0, #0
c0d01546:	d007      	beq.n	c0d01558 <io_event+0x370>
c0d01548:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d0154a:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d0154c:	2801      	cmp	r0, #1
c0d0154e:	d101      	bne.n	c0d01554 <io_event+0x36c>
c0d01550:	0150      	lsls	r0, r2, #5
c0d01552:	1808      	adds	r0, r1, r0
	io_seproxyhal_display_default((bagl_element_t *)element);
c0d01554:	f000 ffa6 	bl	c0d024a4 <io_seproxyhal_display_default>
		UX_DEFAULT_EVENT();
c0d01558:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d0155a:	1c40      	adds	r0, r0, #1
c0d0155c:	84e8      	strh	r0, [r5, #38]	; 0x26
c0d0155e:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d01560:	2900      	cmp	r1, #0
c0d01562:	d1d3      	bne.n	c0d0150c <io_event+0x324>
c0d01564:	e0fe      	b.n	c0d01764 <io_event+0x57c>
c0d01566:	4604      	mov	r4, r0
		UX_TICKER_EVENT(G_io_seproxyhal_spi_buffer, {
c0d01568:	1e40      	subs	r0, r0, #1
c0d0156a:	4622      	mov	r2, r4
c0d0156c:	4182      	sbcs	r2, r0
c0d0156e:	4625      	mov	r5, r4
c0d01570:	3d97      	subs	r5, #151	; 0x97
c0d01572:	1e68      	subs	r0, r5, #1
c0d01574:	4185      	sbcs	r5, r0
c0d01576:	6bf0      	ldr	r0, [r6, #60]	; 0x3c
c0d01578:	2800      	cmp	r0, #0
c0d0157a:	d100      	bne.n	c0d0157e <io_event+0x396>
c0d0157c:	e114      	b.n	c0d017a8 <io_event+0x5c0>
c0d0157e:	4601      	mov	r1, r0
c0d01580:	3964      	subs	r1, #100	; 0x64
c0d01582:	d200      	bcs.n	c0d01586 <io_event+0x39e>
c0d01584:	4639      	mov	r1, r7
c0d01586:	63f1      	str	r1, [r6, #60]	; 0x3c
c0d01588:	2864      	cmp	r0, #100	; 0x64
c0d0158a:	d900      	bls.n	c0d0158e <io_event+0x3a6>
c0d0158c:	e10c      	b.n	c0d017a8 <io_event+0x5c0>
c0d0158e:	6bb1      	ldr	r1, [r6, #56]	; 0x38
c0d01590:	2900      	cmp	r1, #0
c0d01592:	d100      	bne.n	c0d01596 <io_event+0x3ae>
c0d01594:	e0ef      	b.n	c0d01776 <io_event+0x58e>
c0d01596:	6c30      	ldr	r0, [r6, #64]	; 0x40
c0d01598:	63f0      	str	r0, [r6, #60]	; 0x3c
c0d0159a:	2000      	movs	r0, #0
c0d0159c:	4788      	blx	r1
c0d0159e:	e103      	b.n	c0d017a8 <io_event+0x5c0>
c0d015a0:	20000205 	.word	0x20000205
c0d015a4:	200003d8 	.word	0x200003d8
		UX_DEFAULT_EVENT();
c0d015a8:	6aa8      	ldr	r0, [r5, #40]	; 0x28
c0d015aa:	2800      	cmp	r0, #0
c0d015ac:	d100      	bne.n	c0d015b0 <io_event+0x3c8>
c0d015ae:	e0d2      	b.n	c0d01756 <io_event+0x56e>
c0d015b0:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d015b2:	212c      	movs	r1, #44	; 0x2c
c0d015b4:	5c69      	ldrb	r1, [r5, r1]
c0d015b6:	b280      	uxth	r0, r0
c0d015b8:	4288      	cmp	r0, r1
c0d015ba:	d300      	bcc.n	c0d015be <io_event+0x3d6>
c0d015bc:	e0cb      	b.n	c0d01756 <io_event+0x56e>
c0d015be:	f004 f80d 	bl	c0d055dc <io_seph_is_status_sent>
c0d015c2:	2800      	cmp	r0, #0
c0d015c4:	d000      	beq.n	c0d015c8 <io_event+0x3e0>
c0d015c6:	e0c6      	b.n	c0d01756 <io_event+0x56e>
c0d015c8:	f003 ff84 	bl	c0d054d4 <os_perso_isonboarded>
c0d015cc:	28aa      	cmp	r0, #170	; 0xaa
c0d015ce:	d104      	bne.n	c0d015da <io_event+0x3f2>
c0d015d0:	f003 ffaa 	bl	c0d05528 <os_global_pin_is_validated>
c0d015d4:	28aa      	cmp	r0, #170	; 0xaa
c0d015d6:	d000      	beq.n	c0d015da <io_event+0x3f2>
c0d015d8:	e0bd      	b.n	c0d01756 <io_event+0x56e>
c0d015da:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d015dc:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d015de:	0150      	lsls	r0, r2, #5
c0d015e0:	1808      	adds	r0, r1, r0
c0d015e2:	6b2b      	ldr	r3, [r5, #48]	; 0x30
c0d015e4:	2b00      	cmp	r3, #0
c0d015e6:	d004      	beq.n	c0d015f2 <io_event+0x40a>
c0d015e8:	4798      	blx	r3
c0d015ea:	2800      	cmp	r0, #0
c0d015ec:	d007      	beq.n	c0d015fe <io_event+0x416>
c0d015ee:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d015f0:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d015f2:	2801      	cmp	r0, #1
c0d015f4:	d101      	bne.n	c0d015fa <io_event+0x412>
c0d015f6:	0150      	lsls	r0, r2, #5
c0d015f8:	1808      	adds	r0, r1, r0
	io_seproxyhal_display_default((bagl_element_t *)element);
c0d015fa:	f000 ff53 	bl	c0d024a4 <io_seproxyhal_display_default>
		UX_DEFAULT_EVENT();
c0d015fe:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d01600:	1c40      	adds	r0, r0, #1
c0d01602:	84e8      	strh	r0, [r5, #38]	; 0x26
c0d01604:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d01606:	2900      	cmp	r1, #0
c0d01608:	d1d3      	bne.n	c0d015b2 <io_event+0x3ca>
c0d0160a:	e0a4      	b.n	c0d01756 <io_event+0x56e>
c0d0160c:	20000968 	.word	0x20000968
c0d01610:	00007b32 	.word	0x00007b32
		UX_DEFAULT_EVENT();
c0d01614:	6aa8      	ldr	r0, [r5, #40]	; 0x28
c0d01616:	2800      	cmp	r0, #0
c0d01618:	d100      	bne.n	c0d0161c <io_event+0x434>
c0d0161a:	e09c      	b.n	c0d01756 <io_event+0x56e>
c0d0161c:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d0161e:	212c      	movs	r1, #44	; 0x2c
c0d01620:	5c69      	ldrb	r1, [r5, r1]
c0d01622:	b280      	uxth	r0, r0
c0d01624:	4288      	cmp	r0, r1
c0d01626:	d300      	bcc.n	c0d0162a <io_event+0x442>
c0d01628:	e095      	b.n	c0d01756 <io_event+0x56e>
c0d0162a:	f003 ffd7 	bl	c0d055dc <io_seph_is_status_sent>
c0d0162e:	2800      	cmp	r0, #0
c0d01630:	d000      	beq.n	c0d01634 <io_event+0x44c>
c0d01632:	e090      	b.n	c0d01756 <io_event+0x56e>
c0d01634:	f003 ff4e 	bl	c0d054d4 <os_perso_isonboarded>
c0d01638:	28aa      	cmp	r0, #170	; 0xaa
c0d0163a:	d104      	bne.n	c0d01646 <io_event+0x45e>
c0d0163c:	f003 ff74 	bl	c0d05528 <os_global_pin_is_validated>
c0d01640:	28aa      	cmp	r0, #170	; 0xaa
c0d01642:	d000      	beq.n	c0d01646 <io_event+0x45e>
c0d01644:	e087      	b.n	c0d01756 <io_event+0x56e>
c0d01646:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d01648:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d0164a:	0150      	lsls	r0, r2, #5
c0d0164c:	1808      	adds	r0, r1, r0
c0d0164e:	6b2b      	ldr	r3, [r5, #48]	; 0x30
c0d01650:	2b00      	cmp	r3, #0
c0d01652:	d004      	beq.n	c0d0165e <io_event+0x476>
c0d01654:	4798      	blx	r3
c0d01656:	2800      	cmp	r0, #0
c0d01658:	d007      	beq.n	c0d0166a <io_event+0x482>
c0d0165a:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d0165c:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d0165e:	2801      	cmp	r0, #1
c0d01660:	d101      	bne.n	c0d01666 <io_event+0x47e>
c0d01662:	0150      	lsls	r0, r2, #5
c0d01664:	1808      	adds	r0, r1, r0
	io_seproxyhal_display_default((bagl_element_t *)element);
c0d01666:	f000 ff1d 	bl	c0d024a4 <io_seproxyhal_display_default>
		UX_DEFAULT_EVENT();
c0d0166a:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d0166c:	1c40      	adds	r0, r0, #1
c0d0166e:	84e8      	strh	r0, [r5, #38]	; 0x26
c0d01670:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d01672:	2900      	cmp	r1, #0
c0d01674:	d1d3      	bne.n	c0d0161e <io_event+0x436>
c0d01676:	e06e      	b.n	c0d01756 <io_event+0x56e>
		UX_DISPLAYED_EVENT({});
c0d01678:	f000 febe 	bl	c0d023f8 <io_seproxyhal_init_ux>
c0d0167c:	f000 febe 	bl	c0d023fc <io_seproxyhal_init_button>
c0d01680:	84ee      	strh	r6, [r5, #38]	; 0x26
c0d01682:	2004      	movs	r0, #4
c0d01684:	f003 ffde 	bl	c0d05644 <os_sched_last_status>
c0d01688:	66a8      	str	r0, [r5, #104]	; 0x68
c0d0168a:	2800      	cmp	r0, #0
c0d0168c:	d06a      	beq.n	c0d01764 <io_event+0x57c>
c0d0168e:	2897      	cmp	r0, #151	; 0x97
c0d01690:	d068      	beq.n	c0d01764 <io_event+0x57c>
c0d01692:	6aa8      	ldr	r0, [r5, #40]	; 0x28
c0d01694:	2800      	cmp	r0, #0
c0d01696:	d065      	beq.n	c0d01764 <io_event+0x57c>
c0d01698:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d0169a:	212c      	movs	r1, #44	; 0x2c
c0d0169c:	5c69      	ldrb	r1, [r5, r1]
c0d0169e:	b280      	uxth	r0, r0
c0d016a0:	4288      	cmp	r0, r1
c0d016a2:	d25f      	bcs.n	c0d01764 <io_event+0x57c>
c0d016a4:	f003 ff9a 	bl	c0d055dc <io_seph_is_status_sent>
c0d016a8:	2800      	cmp	r0, #0
c0d016aa:	d15b      	bne.n	c0d01764 <io_event+0x57c>
c0d016ac:	f003 ff12 	bl	c0d054d4 <os_perso_isonboarded>
c0d016b0:	28aa      	cmp	r0, #170	; 0xaa
c0d016b2:	d103      	bne.n	c0d016bc <io_event+0x4d4>
c0d016b4:	f003 ff38 	bl	c0d05528 <os_global_pin_is_validated>
c0d016b8:	28aa      	cmp	r0, #170	; 0xaa
c0d016ba:	d153      	bne.n	c0d01764 <io_event+0x57c>
c0d016bc:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d016be:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d016c0:	0150      	lsls	r0, r2, #5
c0d016c2:	1808      	adds	r0, r1, r0
c0d016c4:	6b2b      	ldr	r3, [r5, #48]	; 0x30
c0d016c6:	2b00      	cmp	r3, #0
c0d016c8:	d004      	beq.n	c0d016d4 <io_event+0x4ec>
c0d016ca:	4798      	blx	r3
c0d016cc:	2800      	cmp	r0, #0
c0d016ce:	d007      	beq.n	c0d016e0 <io_event+0x4f8>
c0d016d0:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d016d2:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d016d4:	2801      	cmp	r0, #1
c0d016d6:	d101      	bne.n	c0d016dc <io_event+0x4f4>
c0d016d8:	0150      	lsls	r0, r2, #5
c0d016da:	1808      	adds	r0, r1, r0
	io_seproxyhal_display_default((bagl_element_t *)element);
c0d016dc:	f000 fee2 	bl	c0d024a4 <io_seproxyhal_display_default>
		UX_DISPLAYED_EVENT({});
c0d016e0:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d016e2:	1c40      	adds	r0, r0, #1
c0d016e4:	84e8      	strh	r0, [r5, #38]	; 0x26
c0d016e6:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d016e8:	2900      	cmp	r1, #0
c0d016ea:	d1d6      	bne.n	c0d0169a <io_event+0x4b2>
c0d016ec:	e03a      	b.n	c0d01764 <io_event+0x57c>
		UX_BUTTON_PUSH_EVENT(G_io_seproxyhal_spi_buffer);
c0d016ee:	6b68      	ldr	r0, [r5, #52]	; 0x34
c0d016f0:	2800      	cmp	r0, #0
c0d016f2:	d003      	beq.n	c0d016fc <io_event+0x514>
c0d016f4:	78f1      	ldrb	r1, [r6, #3]
c0d016f6:	0849      	lsrs	r1, r1, #1
c0d016f8:	f000 ff18 	bl	c0d0252c <io_seproxyhal_button_push>
c0d016fc:	6aa8      	ldr	r0, [r5, #40]	; 0x28
c0d016fe:	2800      	cmp	r0, #0
c0d01700:	d029      	beq.n	c0d01756 <io_event+0x56e>
c0d01702:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d01704:	212c      	movs	r1, #44	; 0x2c
c0d01706:	5c69      	ldrb	r1, [r5, r1]
c0d01708:	b280      	uxth	r0, r0
c0d0170a:	4288      	cmp	r0, r1
c0d0170c:	d223      	bcs.n	c0d01756 <io_event+0x56e>
c0d0170e:	f003 ff65 	bl	c0d055dc <io_seph_is_status_sent>
c0d01712:	2800      	cmp	r0, #0
c0d01714:	d11f      	bne.n	c0d01756 <io_event+0x56e>
c0d01716:	f003 fedd 	bl	c0d054d4 <os_perso_isonboarded>
c0d0171a:	28aa      	cmp	r0, #170	; 0xaa
c0d0171c:	d103      	bne.n	c0d01726 <io_event+0x53e>
c0d0171e:	f003 ff03 	bl	c0d05528 <os_global_pin_is_validated>
c0d01722:	28aa      	cmp	r0, #170	; 0xaa
c0d01724:	d117      	bne.n	c0d01756 <io_event+0x56e>
c0d01726:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d01728:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d0172a:	0150      	lsls	r0, r2, #5
c0d0172c:	1808      	adds	r0, r1, r0
c0d0172e:	6b2b      	ldr	r3, [r5, #48]	; 0x30
c0d01730:	2b00      	cmp	r3, #0
c0d01732:	d004      	beq.n	c0d0173e <io_event+0x556>
c0d01734:	4798      	blx	r3
c0d01736:	2800      	cmp	r0, #0
c0d01738:	d007      	beq.n	c0d0174a <io_event+0x562>
c0d0173a:	8cea      	ldrh	r2, [r5, #38]	; 0x26
c0d0173c:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d0173e:	2801      	cmp	r0, #1
c0d01740:	d101      	bne.n	c0d01746 <io_event+0x55e>
c0d01742:	0150      	lsls	r0, r2, #5
c0d01744:	1808      	adds	r0, r1, r0
	io_seproxyhal_display_default((bagl_element_t *)element);
c0d01746:	f000 fead 	bl	c0d024a4 <io_seproxyhal_display_default>
		UX_BUTTON_PUSH_EVENT(G_io_seproxyhal_spi_buffer);
c0d0174a:	8ce8      	ldrh	r0, [r5, #38]	; 0x26
c0d0174c:	1c40      	adds	r0, r0, #1
c0d0174e:	84e8      	strh	r0, [r5, #38]	; 0x26
c0d01750:	6aa9      	ldr	r1, [r5, #40]	; 0x28
c0d01752:	2900      	cmp	r1, #0
c0d01754:	d1d6      	bne.n	c0d01704 <io_event+0x51c>
c0d01756:	202c      	movs	r0, #44	; 0x2c
c0d01758:	5c28      	ldrb	r0, [r5, r0]
c0d0175a:	8ce9      	ldrh	r1, [r5, #38]	; 0x26
c0d0175c:	4281      	cmp	r1, r0
c0d0175e:	d301      	bcc.n	c0d01764 <io_event+0x57c>
c0d01760:	f003 ff3c 	bl	c0d055dc <io_seph_is_status_sent>
		break;
	}

	// close the event if not done previously (by a display or whatever)
	if (!io_seproxyhal_spi_is_status_sent()) {
c0d01764:	f003 ff3a 	bl	c0d055dc <io_seph_is_status_sent>
c0d01768:	2800      	cmp	r0, #0
c0d0176a:	d101      	bne.n	c0d01770 <io_event+0x588>
		io_seproxyhal_general_status();
c0d0176c:	f000 fd20 	bl	c0d021b0 <io_seproxyhal_general_status>
c0d01770:	2001      	movs	r0, #1
	}

	// command has been processed, DO NOT reset the current APDU transport
	return 1;
c0d01772:	b001      	add	sp, #4
c0d01774:	bdf0      	pop	{r4, r5, r6, r7, pc}
		UX_TICKER_EVENT(G_io_seproxyhal_spi_buffer, {
c0d01776:	482a      	ldr	r0, [pc, #168]	; (c0d01820 <io_event+0x638>)
c0d01778:	4478      	add	r0, pc
c0d0177a:	492a      	ldr	r1, [pc, #168]	; (c0d01824 <io_event+0x63c>)
c0d0177c:	4479      	add	r1, pc
c0d0177e:	4617      	mov	r7, r2
c0d01780:	226d      	movs	r2, #109	; 0x6d
c0d01782:	f001 fa5f 	bl	c0d02c44 <mcu_usb_printf>
c0d01786:	4828      	ldr	r0, [pc, #160]	; (c0d01828 <io_event+0x640>)
c0d01788:	4478      	add	r0, pc
c0d0178a:	f001 fa5b 	bl	c0d02c44 <mcu_usb_printf>
c0d0178e:	4827      	ldr	r0, [pc, #156]	; (c0d0182c <io_event+0x644>)
c0d01790:	4478      	add	r0, pc
c0d01792:	f001 fa57 	bl	c0d02c44 <mcu_usb_printf>
c0d01796:	4821      	ldr	r0, [pc, #132]	; (c0d0181c <io_event+0x634>)
c0d01798:	6801      	ldr	r1, [r0, #0]
c0d0179a:	2900      	cmp	r1, #0
c0d0179c:	d004      	beq.n	c0d017a8 <io_event+0x5c0>
c0d0179e:	403d      	ands	r5, r7
c0d017a0:	2200      	movs	r2, #0
c0d017a2:	6002      	str	r2, [r0, #0]
c0d017a4:	4628      	mov	r0, r5
c0d017a6:	4788      	blx	r1
c0d017a8:	2c00      	cmp	r4, #0
c0d017aa:	d0db      	beq.n	c0d01764 <io_event+0x57c>
c0d017ac:	2c97      	cmp	r4, #151	; 0x97
c0d017ae:	d0d9      	beq.n	c0d01764 <io_event+0x57c>
c0d017b0:	6ab0      	ldr	r0, [r6, #40]	; 0x28
c0d017b2:	2800      	cmp	r0, #0
c0d017b4:	d029      	beq.n	c0d0180a <io_event+0x622>
c0d017b6:	8cf0      	ldrh	r0, [r6, #38]	; 0x26
c0d017b8:	212c      	movs	r1, #44	; 0x2c
c0d017ba:	5c71      	ldrb	r1, [r6, r1]
c0d017bc:	b280      	uxth	r0, r0
c0d017be:	4288      	cmp	r0, r1
c0d017c0:	d223      	bcs.n	c0d0180a <io_event+0x622>
c0d017c2:	f003 ff0b 	bl	c0d055dc <io_seph_is_status_sent>
c0d017c6:	2800      	cmp	r0, #0
c0d017c8:	d11f      	bne.n	c0d0180a <io_event+0x622>
c0d017ca:	f003 fe83 	bl	c0d054d4 <os_perso_isonboarded>
c0d017ce:	28aa      	cmp	r0, #170	; 0xaa
c0d017d0:	d103      	bne.n	c0d017da <io_event+0x5f2>
c0d017d2:	f003 fea9 	bl	c0d05528 <os_global_pin_is_validated>
c0d017d6:	28aa      	cmp	r0, #170	; 0xaa
c0d017d8:	d117      	bne.n	c0d0180a <io_event+0x622>
c0d017da:	6ab1      	ldr	r1, [r6, #40]	; 0x28
c0d017dc:	8cf2      	ldrh	r2, [r6, #38]	; 0x26
c0d017de:	0150      	lsls	r0, r2, #5
c0d017e0:	1808      	adds	r0, r1, r0
c0d017e2:	6b33      	ldr	r3, [r6, #48]	; 0x30
c0d017e4:	2b00      	cmp	r3, #0
c0d017e6:	d004      	beq.n	c0d017f2 <io_event+0x60a>
c0d017e8:	4798      	blx	r3
c0d017ea:	2800      	cmp	r0, #0
c0d017ec:	d007      	beq.n	c0d017fe <io_event+0x616>
c0d017ee:	8cf2      	ldrh	r2, [r6, #38]	; 0x26
c0d017f0:	6ab1      	ldr	r1, [r6, #40]	; 0x28
c0d017f2:	2801      	cmp	r0, #1
c0d017f4:	d101      	bne.n	c0d017fa <io_event+0x612>
c0d017f6:	0150      	lsls	r0, r2, #5
c0d017f8:	1808      	adds	r0, r1, r0
	io_seproxyhal_display_default((bagl_element_t *)element);
c0d017fa:	f000 fe53 	bl	c0d024a4 <io_seproxyhal_display_default>
		UX_TICKER_EVENT(G_io_seproxyhal_spi_buffer, {
c0d017fe:	8cf0      	ldrh	r0, [r6, #38]	; 0x26
c0d01800:	1c40      	adds	r0, r0, #1
c0d01802:	84f0      	strh	r0, [r6, #38]	; 0x26
c0d01804:	6ab1      	ldr	r1, [r6, #40]	; 0x28
c0d01806:	2900      	cmp	r1, #0
c0d01808:	d1d6      	bne.n	c0d017b8 <io_event+0x5d0>
c0d0180a:	202c      	movs	r0, #44	; 0x2c
c0d0180c:	5c30      	ldrb	r0, [r6, r0]
c0d0180e:	8cf1      	ldrh	r1, [r6, #38]	; 0x26
c0d01810:	e7a4      	b.n	c0d0175c <io_event+0x574>
c0d01812:	2005      	movs	r0, #5
			THROW(EXCEPTION_IO_RESET);
c0d01814:	f000 fcbe 	bl	c0d02194 <os_longjmp>
c0d01818:	20000968 	.word	0x20000968
c0d0181c:	20000200 	.word	0x20000200
c0d01820:	00007247 	.word	0x00007247
c0d01824:	0000768c 	.word	0x0000768c
c0d01828:	00007689 	.word	0x00007689
c0d0182c:	00007d96 	.word	0x00007d96

c0d01830 <io_exchange_al>:
}

unsigned short io_exchange_al(unsigned char channel, unsigned short tx_len)
{
c0d01830:	b5b0      	push	{r4, r5, r7, lr}
c0d01832:	4605      	mov	r5, r0
c0d01834:	2007      	movs	r0, #7
	switch (channel & ~(IO_FLAGS)) {
c0d01836:	4028      	ands	r0, r5
c0d01838:	2400      	movs	r4, #0
c0d0183a:	2801      	cmp	r0, #1
c0d0183c:	d012      	beq.n	c0d01864 <io_exchange_al+0x34>
c0d0183e:	2802      	cmp	r0, #2
c0d01840:	d112      	bne.n	c0d01868 <io_exchange_al+0x38>
	case CHANNEL_KEYBOARD:
		break;
	// multiplexed io exchange over a SPI channel and TLV encapsulated protocol
	case CHANNEL_SPI:
		if (tx_len) {
c0d01842:	2900      	cmp	r1, #0
c0d01844:	d007      	beq.n	c0d01856 <io_exchange_al+0x26>
			io_seproxyhal_spi_send(G_io_apdu_buffer, tx_len);
c0d01846:	480a      	ldr	r0, [pc, #40]	; (c0d01870 <io_exchange_al+0x40>)
c0d01848:	f003 febc 	bl	c0d055c4 <io_seph_send>
			if (channel & IO_RESET_AFTER_REPLIED) {
c0d0184c:	0628      	lsls	r0, r5, #24
c0d0184e:	d509      	bpl.n	c0d01864 <io_exchange_al+0x34>
				reset();
c0d01850:	f003 fe34 	bl	c0d054bc <halt>
c0d01854:	e006      	b.n	c0d01864 <io_exchange_al+0x34>
c0d01856:	21ff      	movs	r1, #255	; 0xff
c0d01858:	3152      	adds	r1, #82	; 0x52
			}
			return 0; // nothing received from the master so far (it's a tx transaction)
		} else {
			return io_seproxyhal_spi_recv(G_io_apdu_buffer, sizeof(G_io_apdu_buffer), 0);
c0d0185a:	4805      	ldr	r0, [pc, #20]	; (c0d01870 <io_exchange_al+0x40>)
c0d0185c:	2200      	movs	r2, #0
c0d0185e:	f003 fec9 	bl	c0d055f4 <io_seph_recv>
c0d01862:	4604      	mov	r4, r0
		}
	default:
		THROW(INVALID_PARAMETER);
	}
	return 0;
}
c0d01864:	4620      	mov	r0, r4
c0d01866:	bdb0      	pop	{r4, r5, r7, pc}
c0d01868:	2002      	movs	r0, #2
		THROW(INVALID_PARAMETER);
c0d0186a:	f000 fc93 	bl	c0d02194 <os_longjmp>
c0d0186e:	46c0      	nop			; (mov r8, r8)
c0d01870:	20000285 	.word	0x20000285

c0d01874 <device_is_unlocked>:

STATIC_ASSERT(CX_APILEVEL >= 9, "bad api level");
static const unsigned PIN_VERIFIED = BOLOS_UX_OK; // Seems to work for api 9/10

bool device_is_unlocked()
{
c0d01874:	b580      	push	{r7, lr}
	return os_global_pin_is_validated() == PIN_VERIFIED;
c0d01876:	f003 fe57 	bl	c0d05528 <os_global_pin_is_validated>
c0d0187a:	38aa      	subs	r0, #170	; 0xaa
c0d0187c:	4241      	negs	r1, r0
c0d0187e:	4148      	adcs	r0, r1
c0d01880:	bd80      	pop	{r7, pc}
	...

c0d01884 <derivePrivateKey>:

void derivePrivateKey(
        const bip44_path_t* pathSpec,
        private_key_t* privateKey
)
{
c0d01884:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d01886:	b095      	sub	sp, #84	; 0x54
c0d01888:	460c      	mov	r4, r1
c0d0188a:	4605      	mov	r5, r0
	ENSURE_NOT_DENIED(policyDerivePrivateKey(pathSpec));
c0d0188c:	f001 fde4 	bl	c0d03458 <policyDerivePrivateKey>
	if (policy == POLICY_DENY) {
c0d01890:	2801      	cmp	r0, #1
c0d01892:	d04b      	beq.n	c0d0192c <derivePrivateKey+0xa8>

	// Sanity check
	ASSERT(pathSpec->length < ARRAY_LEN(pathSpec->path));
c0d01894:	6aa8      	ldr	r0, [r5, #40]	; 0x28
c0d01896:	280a      	cmp	r0, #10
c0d01898:	d301      	bcc.n	c0d0189e <derivePrivateKey+0x1a>
c0d0189a:	2000      	movs	r0, #0
c0d0189c:	e000      	b.n	c0d018a0 <derivePrivateKey+0x1c>
c0d0189e:	2001      	movs	r0, #1
c0d018a0:	4925      	ldr	r1, [pc, #148]	; (c0d01938 <derivePrivateKey+0xb4>)
c0d018a2:	4479      	add	r1, pc
c0d018a4:	f7fe fbe4 	bl	c0d00070 <assert>

	TRACE();
c0d018a8:	4824      	ldr	r0, [pc, #144]	; (c0d0193c <derivePrivateKey+0xb8>)
c0d018aa:	4478      	add	r0, pc
c0d018ac:	4924      	ldr	r1, [pc, #144]	; (c0d01940 <derivePrivateKey+0xbc>)
c0d018ae:	4479      	add	r1, pc
c0d018b0:	2219      	movs	r2, #25
c0d018b2:	f001 f9c7 	bl	c0d02c44 <mcu_usb_printf>
c0d018b6:	4823      	ldr	r0, [pc, #140]	; (c0d01944 <derivePrivateKey+0xc0>)
c0d018b8:	4478      	add	r0, pc
c0d018ba:	f001 f9c3 	bl	c0d02c44 <mcu_usb_printf>
c0d018be:	4822      	ldr	r0, [pc, #136]	; (c0d01948 <derivePrivateKey+0xc4>)
c0d018c0:	4478      	add	r0, pc
c0d018c2:	f001 f9bf 	bl	c0d02c44 <mcu_usb_printf>
c0d018c6:	ae01      	add	r6, sp, #4
	uint8_t privateKeySeed[PRIVATE_KEY_SEED_LEN];

	BEGIN_TRY {
		TRY {
c0d018c8:	4630      	mov	r0, r6
c0d018ca:	f006 fe69 	bl	c0d085a0 <setjmp>
c0d018ce:	85b0      	strh	r0, [r6, #44]	; 0x2c
c0d018d0:	0400      	lsls	r0, r0, #16
c0d018d2:	d119      	bne.n	c0d01908 <derivePrivateKey+0x84>
c0d018d4:	a801      	add	r0, sp, #4
c0d018d6:	f003 fea7 	bl	c0d05628 <try_context_set>
c0d018da:	900b      	str	r0, [sp, #44]	; 0x2c
			STATIC_ASSERT(CX_APILEVEL >= 5, "unsupported api level");

			io_seproxyhal_io_heartbeat();
c0d018dc:	f001 f83e 	bl	c0d0295c <io_seproxyhal_io_heartbeat>
			os_perso_derive_node_bip32(
			        CX_CURVE_SECP256K1,
			        pathSpec->path,
			        pathSpec->length,
c0d018e0:	6aaa      	ldr	r2, [r5, #40]	; 0x28
c0d018e2:	2000      	movs	r0, #0
			os_perso_derive_node_bip32(
c0d018e4:	9000      	str	r0, [sp, #0]
c0d018e6:	2621      	movs	r6, #33	; 0x21
c0d018e8:	af0d      	add	r7, sp, #52	; 0x34
c0d018ea:	4630      	mov	r0, r6
c0d018ec:	4629      	mov	r1, r5
c0d018ee:	463b      	mov	r3, r7
c0d018f0:	f003 fdfe 	bl	c0d054f0 <os_perso_derive_node_bip32>
			        privateKeySeed,
			        NULL);
			io_seproxyhal_io_heartbeat();
c0d018f4:	f001 f832 	bl	c0d0295c <io_seproxyhal_io_heartbeat>
c0d018f8:	2220      	movs	r2, #32
                                  size_t                 key_len,
                                  cx_ecfp_private_key_t *pvkey);

static inline int cx_ecfp_init_private_key ( cx_curve_t curve, const unsigned char * rawkey, unsigned int key_len, cx_ecfp_private_key_t * pvkey )
{
  CX_THROW(cx_ecfp_init_private_key_no_throw(curve, rawkey, key_len, pvkey));
c0d018fa:	4630      	mov	r0, r6
c0d018fc:	4639      	mov	r1, r7
c0d018fe:	4623      	mov	r3, r4
c0d01900:	f7fe fda4 	bl	c0d0044c <cx_ecfp_init_private_key_no_throw>
c0d01904:	2800      	cmp	r0, #0
c0d01906:	d112      	bne.n	c0d0192e <derivePrivateKey+0xaa>

			cx_ecfp_init_private_key(CX_CURVE_SECP256K1, privateKeySeed, 32, privateKey);
		}
		FINALLY {
c0d01908:	f003 fe82 	bl	c0d05610 <try_context_get>
c0d0190c:	a901      	add	r1, sp, #4
c0d0190e:	4288      	cmp	r0, r1
c0d01910:	d102      	bne.n	c0d01918 <derivePrivateKey+0x94>
c0d01912:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d01914:	f003 fe88 	bl	c0d05628 <try_context_set>
c0d01918:	a80d      	add	r0, sp, #52	; 0x34
c0d0191a:	2120      	movs	r1, #32
			explicit_bzero(privateKeySeed, SIZEOF(privateKeySeed));
c0d0191c:	f006 fe0a 	bl	c0d08534 <explicit_bzero>
c0d01920:	a801      	add	r0, sp, #4
		}
	} END_TRY;
c0d01922:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d01924:	2800      	cmp	r0, #0
c0d01926:	d102      	bne.n	c0d0192e <derivePrivateKey+0xaa>
}
c0d01928:	b015      	add	sp, #84	; 0x54
c0d0192a:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d0192c:	4801      	ldr	r0, [pc, #4]	; (c0d01934 <derivePrivateKey+0xb0>)
c0d0192e:	f000 fc31 	bl	c0d02194 <os_longjmp>
c0d01932:	46c0      	nop			; (mov r8, r8)
c0d01934:	00006e10 	.word	0x00006e10
c0d01938:	00007575 	.word	0x00007575
c0d0193c:	00007115 	.word	0x00007115
c0d01940:	000075a4 	.word	0x000075a4
c0d01944:	00007c6f 	.word	0x00007c6f
c0d01948:	00007c66 	.word	0x00007c66

c0d0194c <derivePublicKey>:

void derivePublicKey(
        const bip44_path_t* pathSpec,
        public_key_t * publicKey
)
{
c0d0194c:	b570      	push	{r4, r5, r6, lr}
c0d0194e:	b096      	sub	sp, #88	; 0x58
c0d01950:	460c      	mov	r4, r1
c0d01952:	4605      	mov	r5, r0
c0d01954:	466e      	mov	r6, sp
	private_key_t privateKey;
	BEGIN_TRY {
		TRY {
c0d01956:	4630      	mov	r0, r6
c0d01958:	f006 fe22 	bl	c0d085a0 <setjmp>
c0d0195c:	85b0      	strh	r0, [r6, #44]	; 0x2c
c0d0195e:	0400      	lsls	r0, r0, #16
c0d01960:	d11b      	bne.n	c0d0199a <derivePublicKey+0x4e>
c0d01962:	4668      	mov	r0, sp
c0d01964:	f003 fe60 	bl	c0d05628 <try_context_set>
c0d01968:	900a      	str	r0, [sp, #40]	; 0x28
c0d0196a:	a90c      	add	r1, sp, #48	; 0x30
			derivePrivateKey(pathSpec, &privateKey);
c0d0196c:	4628      	mov	r0, r5
c0d0196e:	f7ff ff89 	bl	c0d01884 <derivePrivateKey>
			// We should do cx_ecfp_generate_pair here, but it does not work in SDK < 1.5.4,
			// should work with the new SDK
			io_seproxyhal_io_heartbeat();
c0d01972:	f000 fff3 	bl	c0d0295c <io_seproxyhal_io_heartbeat>
c0d01976:	2021      	movs	r0, #33	; 0x21
c0d01978:	2100      	movs	r1, #0
  CX_THROW(cx_ecfp_init_public_key_no_throw(curve, rawkey, key_len, key));
c0d0197a:	460a      	mov	r2, r1
c0d0197c:	4623      	mov	r3, r4
c0d0197e:	f7fe fd6b 	bl	c0d00458 <cx_ecfp_init_public_key_no_throw>
c0d01982:	2800      	cmp	r0, #0
c0d01984:	d11b      	bne.n	c0d019be <derivePublicKey+0x72>
c0d01986:	2021      	movs	r0, #33	; 0x21
c0d01988:	aa0c      	add	r2, sp, #48	; 0x30
c0d0198a:	2301      	movs	r3, #1
                               cx_ecfp_private_key_t *privkey,
                               bool                   keepprivate);

static inline int cx_ecfp_generate_pair ( cx_curve_t curve, cx_ecfp_public_key_t * pubkey, cx_ecfp_private_key_t * privkey, int keepprivate )
{
  CX_THROW(cx_ecfp_generate_pair_no_throw(curve, pubkey, privkey, keepprivate));
c0d0198c:	4621      	mov	r1, r4
c0d0198e:	f7fe fd57 	bl	c0d00440 <cx_ecfp_generate_pair_no_throw>
c0d01992:	2800      	cmp	r0, #0
c0d01994:	d113      	bne.n	c0d019be <derivePublicKey+0x72>
			cx_ecfp_init_public_key(CX_CURVE_SECP256K1, NULL, 0, publicKey);
			cx_ecfp_generate_pair(CX_CURVE_SECP256K1, publicKey, &privateKey, 1); //1 - private key preserved
			io_seproxyhal_io_heartbeat();
c0d01996:	f000 ffe1 	bl	c0d0295c <io_seproxyhal_io_heartbeat>
		}
		FINALLY {
c0d0199a:	f003 fe39 	bl	c0d05610 <try_context_get>
c0d0199e:	4669      	mov	r1, sp
c0d019a0:	4288      	cmp	r0, r1
c0d019a2:	d102      	bne.n	c0d019aa <derivePublicKey+0x5e>
c0d019a4:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d019a6:	f003 fe3f 	bl	c0d05628 <try_context_set>
c0d019aa:	a80c      	add	r0, sp, #48	; 0x30
c0d019ac:	2128      	movs	r1, #40	; 0x28
			explicit_bzero(&privateKey, SIZEOF(privateKey));
c0d019ae:	f006 fdc1 	bl	c0d08534 <explicit_bzero>
c0d019b2:	4668      	mov	r0, sp
		}
	} END_TRY;
c0d019b4:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d019b6:	2800      	cmp	r0, #0
c0d019b8:	d101      	bne.n	c0d019be <derivePublicKey+0x72>
}
c0d019ba:	b016      	add	sp, #88	; 0x58
c0d019bc:	bd70      	pop	{r4, r5, r6, pc}
c0d019be:	f000 fbe9 	bl	c0d02194 <os_longjmp>
	...

c0d019c4 <testcase_derivePrivateKey>:
	pathSpec->length = pathLength;
	memmove(pathSpec->path, pathArray, pathLength * 4);
}

void testcase_derivePrivateKey(uint32_t* path, uint32_t pathLen, const char* expectedHex)
{
c0d019c4:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d019c6:	b0a3      	sub	sp, #140	; 0x8c
c0d019c8:	9204      	str	r2, [sp, #16]
c0d019ca:	460c      	mov	r4, r1
c0d019cc:	4605      	mov	r5, r0
	PRINTF("testcase_derivePrivateKey ");
c0d019ce:	4836      	ldr	r0, [pc, #216]	; (c0d01aa8 <testcase_derivePrivateKey+0xe4>)
c0d019d0:	4478      	add	r0, pc
c0d019d2:	f001 f937 	bl	c0d02c44 <mcu_usb_printf>
	pathSpec->length = pathLength;
c0d019d6:	9422      	str	r4, [sp, #136]	; 0x88
	memmove(pathSpec->path, pathArray, pathLength * 4);
c0d019d8:	00a2      	lsls	r2, r4, #2
c0d019da:	ac18      	add	r4, sp, #96	; 0x60
c0d019dc:	4620      	mov	r0, r4
c0d019de:	4629      	mov	r1, r5
c0d019e0:	f006 fd99 	bl	c0d08516 <__aeabi_memcpy>

	bip44_path_t pathSpec;
	pathSpec_init(&pathSpec, path, pathLen);
	bip44_PRINTF(&pathSpec);
c0d019e4:	4620      	mov	r0, r4
c0d019e6:	f7fe fc7b 	bl	c0d002e0 <bip44_PRINTF>
	PRINTF("\n");
c0d019ea:	4d30      	ldr	r5, [pc, #192]	; (c0d01aac <testcase_derivePrivateKey+0xe8>)
c0d019ec:	447d      	add	r5, pc
c0d019ee:	4628      	mov	r0, r5
c0d019f0:	f001 f928 	bl	c0d02c44 <mcu_usb_printf>
c0d019f4:	a90e      	add	r1, sp, #56	; 0x38


	private_key_t privateKey;
	derivePrivateKey(&pathSpec, &privateKey);
c0d019f6:	9105      	str	r1, [sp, #20]
c0d019f8:	4620      	mov	r0, r4
c0d019fa:	f7ff ff43 	bl	c0d01884 <derivePrivateKey>
	TRACE("%d", SIZEOF(privateKey.d));
c0d019fe:	4f2c      	ldr	r7, [pc, #176]	; (c0d01ab0 <testcase_derivePrivateKey+0xec>)
c0d01a00:	447f      	add	r7, pc
c0d01a02:	4e2c      	ldr	r6, [pc, #176]	; (c0d01ab4 <testcase_derivePrivateKey+0xf0>)
c0d01a04:	447e      	add	r6, pc
c0d01a06:	221a      	movs	r2, #26
c0d01a08:	4638      	mov	r0, r7
c0d01a0a:	4631      	mov	r1, r6
c0d01a0c:	f001 f91a 	bl	c0d02c44 <mcu_usb_printf>
c0d01a10:	4829      	ldr	r0, [pc, #164]	; (c0d01ab8 <testcase_derivePrivateKey+0xf4>)
c0d01a12:	4478      	add	r0, pc
c0d01a14:	9003      	str	r0, [sp, #12]
c0d01a16:	2420      	movs	r4, #32
c0d01a18:	4621      	mov	r1, r4
c0d01a1a:	f001 f913 	bl	c0d02c44 <mcu_usb_printf>
c0d01a1e:	9501      	str	r5, [sp, #4]
c0d01a20:	4628      	mov	r0, r5
c0d01a22:	f001 f90f 	bl	c0d02c44 <mcu_usb_printf>
c0d01a26:	221b      	movs	r2, #27
	TRACE_BUFFER(privateKey.d, SIZEOF(privateKey.d));
c0d01a28:	4638      	mov	r0, r7
c0d01a2a:	4631      	mov	r1, r6
c0d01a2c:	9600      	str	r6, [sp, #0]
c0d01a2e:	f001 f909 	bl	c0d02c44 <mcu_usb_printf>
c0d01a32:	9a05      	ldr	r2, [sp, #20]
c0d01a34:	3208      	adds	r2, #8
c0d01a36:	9205      	str	r2, [sp, #20]
c0d01a38:	4820      	ldr	r0, [pc, #128]	; (c0d01abc <testcase_derivePrivateKey+0xf8>)
c0d01a3a:	4478      	add	r0, pc
c0d01a3c:	9002      	str	r0, [sp, #8]
c0d01a3e:	4621      	mov	r1, r4
c0d01a40:	f001 f900 	bl	c0d02c44 <mcu_usb_printf>
c0d01a44:	4628      	mov	r0, r5
c0d01a46:	f001 f8fd 	bl	c0d02c44 <mcu_usb_printf>
c0d01a4a:	ad06      	add	r5, sp, #24

	uint8_t expected[32];
	size_t expectedSize = decode_hex(expectedHex, expected, SIZEOF(expected));
c0d01a4c:	9804      	ldr	r0, [sp, #16]
c0d01a4e:	4629      	mov	r1, r5
c0d01a50:	4622      	mov	r2, r4
c0d01a52:	f7ff fa3b 	bl	c0d00ecc <decode_hex>
c0d01a56:	9004      	str	r0, [sp, #16]
c0d01a58:	221f      	movs	r2, #31
	TRACE("%d", SIZEOF(expected));
c0d01a5a:	4638      	mov	r0, r7
c0d01a5c:	4631      	mov	r1, r6
c0d01a5e:	f001 f8f1 	bl	c0d02c44 <mcu_usb_printf>
c0d01a62:	9803      	ldr	r0, [sp, #12]
c0d01a64:	4621      	mov	r1, r4
c0d01a66:	f001 f8ed 	bl	c0d02c44 <mcu_usb_printf>
c0d01a6a:	9e01      	ldr	r6, [sp, #4]
c0d01a6c:	4630      	mov	r0, r6
c0d01a6e:	f001 f8e9 	bl	c0d02c44 <mcu_usb_printf>
	TRACE_BUFFER(expected, SIZEOF(expected));
c0d01a72:	4638      	mov	r0, r7
c0d01a74:	9900      	ldr	r1, [sp, #0]
c0d01a76:	4622      	mov	r2, r4
c0d01a78:	f001 f8e4 	bl	c0d02c44 <mcu_usb_printf>
c0d01a7c:	9802      	ldr	r0, [sp, #8]
c0d01a7e:	4621      	mov	r1, r4
c0d01a80:	462a      	mov	r2, r5
c0d01a82:	f001 f8df 	bl	c0d02c44 <mcu_usb_printf>
c0d01a86:	4630      	mov	r0, r6
c0d01a88:	f001 f8dc 	bl	c0d02c44 <mcu_usb_printf>

	EXPECT_EQ_BYTES(expected, privateKey.d, expectedSize);
c0d01a8c:	4628      	mov	r0, r5
c0d01a8e:	9905      	ldr	r1, [sp, #20]
c0d01a90:	9a04      	ldr	r2, [sp, #16]
c0d01a92:	f006 fd53 	bl	c0d0853c <memcmp>
c0d01a96:	4241      	negs	r1, r0
c0d01a98:	4148      	adcs	r0, r1
c0d01a9a:	4909      	ldr	r1, [pc, #36]	; (c0d01ac0 <testcase_derivePrivateKey+0xfc>)
c0d01a9c:	4479      	add	r1, pc
c0d01a9e:	1cc9      	adds	r1, r1, #3
c0d01aa0:	f7fe fae6 	bl	c0d00070 <assert>
}
c0d01aa4:	b023      	add	sp, #140	; 0x8c
c0d01aa6:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d01aa8:	0000745e 	.word	0x0000745e
c0d01aac:	00007b3a 	.word	0x00007b3a
c0d01ab0:	00006fbf 	.word	0x00006fbf
c0d01ab4:	00007445 	.word	0x00007445
c0d01ab8:	00007a18 	.word	0x00007a18
c0d01abc:	00006fa6 	.word	0x00006fa6
c0d01ac0:	000073c7 	.word	0x000073c7

c0d01ac4 <testPrivateKeyDerivation>:

void testPrivateKeyDerivation()
{
c0d01ac4:	b570      	push	{r4, r5, r6, lr}
c0d01ac6:	b092      	sub	sp, #72	; 0x48


	// Note: Failing tests here? Did you load testing mnemonic
	// "abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon about"?

	TESTCASE(
c0d01ac8:	498a      	ldr	r1, [pc, #552]	; (c0d01cf4 <testPrivateKeyDerivation+0x230>)
c0d01aca:	4479      	add	r1, pc
c0d01acc:	a806      	add	r0, sp, #24
c0d01ace:	4602      	mov	r2, r0
c0d01ad0:	c918      	ldmia	r1!, {r3, r4}
c0d01ad2:	c218      	stmia	r2!, {r3, r4}
c0d01ad4:	c938      	ldmia	r1!, {r3, r4, r5}
c0d01ad6:	c238      	stmia	r2!, {r3, r4, r5}
c0d01ad8:	2405      	movs	r4, #5
c0d01ada:	4a87      	ldr	r2, [pc, #540]	; (c0d01cf8 <testPrivateKeyDerivation+0x234>)
c0d01adc:	447a      	add	r2, pc
c0d01ade:	4621      	mov	r1, r4
c0d01ae0:	f7ff ff70 	bl	c0d019c4 <testcase_derivePrivateKey>
	        (HD + 44, HD + 235, HD + 0, 0, 0),

	        "4d597899db76e87933e7c6841c2d661810f070bad20487ef20eb84e182695a3a"
	);

	TESTCASE(
c0d01ae4:	4985      	ldr	r1, [pc, #532]	; (c0d01cfc <testPrivateKeyDerivation+0x238>)
c0d01ae6:	4479      	add	r1, pc
c0d01ae8:	a806      	add	r0, sp, #24
c0d01aea:	4602      	mov	r2, r0
c0d01aec:	c928      	ldmia	r1!, {r3, r5}
c0d01aee:	c228      	stmia	r2!, {r3, r5}
c0d01af0:	c968      	ldmia	r1!, {r3, r5, r6}
c0d01af2:	c268      	stmia	r2!, {r3, r5, r6}
c0d01af4:	4a82      	ldr	r2, [pc, #520]	; (c0d01d00 <testPrivateKeyDerivation+0x23c>)
c0d01af6:	447a      	add	r2, pc
c0d01af8:	4621      	mov	r1, r4
c0d01afa:	f7ff ff63 	bl	c0d019c4 <testcase_derivePrivateKey>
	{ \
		uint32_t path[] = { UNWRAP path_ }; \
		EXPECT_THROWS(testcase_derivePrivateKey(path, ARRAY_LEN(path), ""), error_ ); \
	}

	TESTCASE( (HD + 43, HD + 235, HD + 0, 0), ERR_REJECTED_BY_POLICY);
c0d01afe:	4881      	ldr	r0, [pc, #516]	; (c0d01d04 <testPrivateKeyDerivation+0x240>)
c0d01b00:	4478      	add	r0, pc
c0d01b02:	4669      	mov	r1, sp
c0d01b04:	c83c      	ldmia	r0!, {r2, r3, r4, r5}
c0d01b06:	c13c      	stmia	r1!, {r2, r3, r4, r5}
c0d01b08:	ac06      	add	r4, sp, #24
c0d01b0a:	4620      	mov	r0, r4
c0d01b0c:	f006 fd48 	bl	c0d085a0 <setjmp>
c0d01b10:	85a0      	strh	r0, [r4, #44]	; 0x2c
c0d01b12:	b280      	uxth	r0, r0
c0d01b14:	4d76      	ldr	r5, [pc, #472]	; (c0d01cf0 <testPrivateKeyDerivation+0x22c>)
c0d01b16:	42a8      	cmp	r0, r5
c0d01b18:	d00d      	beq.n	c0d01b36 <testPrivateKeyDerivation+0x72>
c0d01b1a:	2800      	cmp	r0, #0
c0d01b1c:	d113      	bne.n	c0d01b46 <testPrivateKeyDerivation+0x82>
c0d01b1e:	a806      	add	r0, sp, #24
c0d01b20:	f003 fd82 	bl	c0d05628 <try_context_set>
c0d01b24:	9010      	str	r0, [sp, #64]	; 0x40
c0d01b26:	4668      	mov	r0, sp
c0d01b28:	2104      	movs	r1, #4
c0d01b2a:	4a77      	ldr	r2, [pc, #476]	; (c0d01d08 <testPrivateKeyDerivation+0x244>)
c0d01b2c:	447a      	add	r2, pc
c0d01b2e:	f7ff ff49 	bl	c0d019c4 <testcase_derivePrivateKey>
c0d01b32:	2400      	movs	r4, #0
c0d01b34:	e00d      	b.n	c0d01b52 <testPrivateKeyDerivation+0x8e>
c0d01b36:	a806      	add	r0, sp, #24
c0d01b38:	2100      	movs	r1, #0
c0d01b3a:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d01b3c:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01b3e:	f003 fd73 	bl	c0d05628 <try_context_set>
c0d01b42:	2401      	movs	r4, #1
c0d01b44:	e005      	b.n	c0d01b52 <testPrivateKeyDerivation+0x8e>
c0d01b46:	a806      	add	r0, sp, #24
c0d01b48:	2400      	movs	r4, #0
c0d01b4a:	8584      	strh	r4, [r0, #44]	; 0x2c
c0d01b4c:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01b4e:	f003 fd6b 	bl	c0d05628 <try_context_set>
c0d01b52:	f003 fd5d 	bl	c0d05610 <try_context_get>
c0d01b56:	a906      	add	r1, sp, #24
c0d01b58:	4288      	cmp	r0, r1
c0d01b5a:	d102      	bne.n	c0d01b62 <testPrivateKeyDerivation+0x9e>
c0d01b5c:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01b5e:	f003 fd63 	bl	c0d05628 <try_context_set>
c0d01b62:	486a      	ldr	r0, [pc, #424]	; (c0d01d0c <testPrivateKeyDerivation+0x248>)
c0d01b64:	4478      	add	r0, pc
c0d01b66:	1cc1      	adds	r1, r0, #3
c0d01b68:	4620      	mov	r0, r4
c0d01b6a:	f7fe fa81 	bl	c0d00070 <assert>
c0d01b6e:	a806      	add	r0, sp, #24
c0d01b70:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d01b72:	2800      	cmp	r0, #0
c0d01b74:	d000      	beq.n	c0d01b78 <testPrivateKeyDerivation+0xb4>
c0d01b76:	e0b8      	b.n	c0d01cea <testPrivateKeyDerivation+0x226>
	TESTCASE( (HD + 44, 235, HD + 1, 0, 0), ERR_REJECTED_BY_POLICY);
c0d01b78:	4865      	ldr	r0, [pc, #404]	; (c0d01d10 <testPrivateKeyDerivation+0x24c>)
c0d01b7a:	4478      	add	r0, pc
c0d01b7c:	4669      	mov	r1, sp
c0d01b7e:	c80c      	ldmia	r0!, {r2, r3}
c0d01b80:	c10c      	stmia	r1!, {r2, r3}
c0d01b82:	c81c      	ldmia	r0!, {r2, r3, r4}
c0d01b84:	c11c      	stmia	r1!, {r2, r3, r4}
c0d01b86:	ac06      	add	r4, sp, #24
c0d01b88:	4620      	mov	r0, r4
c0d01b8a:	f006 fd09 	bl	c0d085a0 <setjmp>
c0d01b8e:	85a0      	strh	r0, [r4, #44]	; 0x2c
c0d01b90:	b280      	uxth	r0, r0
c0d01b92:	42a8      	cmp	r0, r5
c0d01b94:	d00d      	beq.n	c0d01bb2 <testPrivateKeyDerivation+0xee>
c0d01b96:	2800      	cmp	r0, #0
c0d01b98:	d113      	bne.n	c0d01bc2 <testPrivateKeyDerivation+0xfe>
c0d01b9a:	a806      	add	r0, sp, #24
c0d01b9c:	f003 fd44 	bl	c0d05628 <try_context_set>
c0d01ba0:	9010      	str	r0, [sp, #64]	; 0x40
c0d01ba2:	4668      	mov	r0, sp
c0d01ba4:	2105      	movs	r1, #5
c0d01ba6:	4a5b      	ldr	r2, [pc, #364]	; (c0d01d14 <testPrivateKeyDerivation+0x250>)
c0d01ba8:	447a      	add	r2, pc
c0d01baa:	f7ff ff0b 	bl	c0d019c4 <testcase_derivePrivateKey>
c0d01bae:	2400      	movs	r4, #0
c0d01bb0:	e00d      	b.n	c0d01bce <testPrivateKeyDerivation+0x10a>
c0d01bb2:	a806      	add	r0, sp, #24
c0d01bb4:	2100      	movs	r1, #0
c0d01bb6:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d01bb8:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01bba:	f003 fd35 	bl	c0d05628 <try_context_set>
c0d01bbe:	2401      	movs	r4, #1
c0d01bc0:	e005      	b.n	c0d01bce <testPrivateKeyDerivation+0x10a>
c0d01bc2:	a806      	add	r0, sp, #24
c0d01bc4:	2400      	movs	r4, #0
c0d01bc6:	8584      	strh	r4, [r0, #44]	; 0x2c
c0d01bc8:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01bca:	f003 fd2d 	bl	c0d05628 <try_context_set>
c0d01bce:	f003 fd1f 	bl	c0d05610 <try_context_get>
c0d01bd2:	a906      	add	r1, sp, #24
c0d01bd4:	4288      	cmp	r0, r1
c0d01bd6:	d102      	bne.n	c0d01bde <testPrivateKeyDerivation+0x11a>
c0d01bd8:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01bda:	f003 fd25 	bl	c0d05628 <try_context_set>
c0d01bde:	484e      	ldr	r0, [pc, #312]	; (c0d01d18 <testPrivateKeyDerivation+0x254>)
c0d01be0:	4478      	add	r0, pc
c0d01be2:	1cc1      	adds	r1, r0, #3
c0d01be4:	4620      	mov	r0, r4
c0d01be6:	f7fe fa43 	bl	c0d00070 <assert>
c0d01bea:	a806      	add	r0, sp, #24
c0d01bec:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d01bee:	2800      	cmp	r0, #0
c0d01bf0:	d17b      	bne.n	c0d01cea <testPrivateKeyDerivation+0x226>
	TESTCASE( (HD + 44, HD + 234, HD + 1, 0, 0), ERR_REJECTED_BY_POLICY);
c0d01bf2:	484a      	ldr	r0, [pc, #296]	; (c0d01d1c <testPrivateKeyDerivation+0x258>)
c0d01bf4:	4478      	add	r0, pc
c0d01bf6:	4669      	mov	r1, sp
c0d01bf8:	c80c      	ldmia	r0!, {r2, r3}
c0d01bfa:	c10c      	stmia	r1!, {r2, r3}
c0d01bfc:	c81c      	ldmia	r0!, {r2, r3, r4}
c0d01bfe:	c11c      	stmia	r1!, {r2, r3, r4}
c0d01c00:	ac06      	add	r4, sp, #24
c0d01c02:	4620      	mov	r0, r4
c0d01c04:	f006 fccc 	bl	c0d085a0 <setjmp>
c0d01c08:	85a0      	strh	r0, [r4, #44]	; 0x2c
c0d01c0a:	b280      	uxth	r0, r0
c0d01c0c:	42a8      	cmp	r0, r5
c0d01c0e:	d00d      	beq.n	c0d01c2c <testPrivateKeyDerivation+0x168>
c0d01c10:	2800      	cmp	r0, #0
c0d01c12:	d113      	bne.n	c0d01c3c <testPrivateKeyDerivation+0x178>
c0d01c14:	a806      	add	r0, sp, #24
c0d01c16:	f003 fd07 	bl	c0d05628 <try_context_set>
c0d01c1a:	9010      	str	r0, [sp, #64]	; 0x40
c0d01c1c:	4668      	mov	r0, sp
c0d01c1e:	2105      	movs	r1, #5
c0d01c20:	4a3f      	ldr	r2, [pc, #252]	; (c0d01d20 <testPrivateKeyDerivation+0x25c>)
c0d01c22:	447a      	add	r2, pc
c0d01c24:	f7ff fece 	bl	c0d019c4 <testcase_derivePrivateKey>
c0d01c28:	2400      	movs	r4, #0
c0d01c2a:	e00d      	b.n	c0d01c48 <testPrivateKeyDerivation+0x184>
c0d01c2c:	a806      	add	r0, sp, #24
c0d01c2e:	2100      	movs	r1, #0
c0d01c30:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d01c32:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01c34:	f003 fcf8 	bl	c0d05628 <try_context_set>
c0d01c38:	2401      	movs	r4, #1
c0d01c3a:	e005      	b.n	c0d01c48 <testPrivateKeyDerivation+0x184>
c0d01c3c:	a806      	add	r0, sp, #24
c0d01c3e:	2400      	movs	r4, #0
c0d01c40:	8584      	strh	r4, [r0, #44]	; 0x2c
c0d01c42:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01c44:	f003 fcf0 	bl	c0d05628 <try_context_set>
c0d01c48:	f003 fce2 	bl	c0d05610 <try_context_get>
c0d01c4c:	a906      	add	r1, sp, #24
c0d01c4e:	4288      	cmp	r0, r1
c0d01c50:	d102      	bne.n	c0d01c58 <testPrivateKeyDerivation+0x194>
c0d01c52:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01c54:	f003 fce8 	bl	c0d05628 <try_context_set>
c0d01c58:	4832      	ldr	r0, [pc, #200]	; (c0d01d24 <testPrivateKeyDerivation+0x260>)
c0d01c5a:	4478      	add	r0, pc
c0d01c5c:	1cc1      	adds	r1, r0, #3
c0d01c5e:	4620      	mov	r0, r4
c0d01c60:	f7fe fa06 	bl	c0d00070 <assert>
c0d01c64:	a806      	add	r0, sp, #24
c0d01c66:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d01c68:	2800      	cmp	r0, #0
c0d01c6a:	d13e      	bne.n	c0d01cea <testPrivateKeyDerivation+0x226>
	TESTCASE( (HD + 44, HD + 235, HD + 1, 0, 0, 0), ERR_REJECTED_BY_POLICY);
c0d01c6c:	482e      	ldr	r0, [pc, #184]	; (c0d01d28 <testPrivateKeyDerivation+0x264>)
c0d01c6e:	4478      	add	r0, pc
c0d01c70:	4669      	mov	r1, sp
c0d01c72:	c81c      	ldmia	r0!, {r2, r3, r4}
c0d01c74:	c11c      	stmia	r1!, {r2, r3, r4}
c0d01c76:	c81c      	ldmia	r0!, {r2, r3, r4}
c0d01c78:	c11c      	stmia	r1!, {r2, r3, r4}
c0d01c7a:	ac06      	add	r4, sp, #24
c0d01c7c:	4620      	mov	r0, r4
c0d01c7e:	f006 fc8f 	bl	c0d085a0 <setjmp>
c0d01c82:	85a0      	strh	r0, [r4, #44]	; 0x2c
c0d01c84:	b280      	uxth	r0, r0
c0d01c86:	42a8      	cmp	r0, r5
c0d01c88:	d00d      	beq.n	c0d01ca6 <testPrivateKeyDerivation+0x1e2>
c0d01c8a:	2800      	cmp	r0, #0
c0d01c8c:	d113      	bne.n	c0d01cb6 <testPrivateKeyDerivation+0x1f2>
c0d01c8e:	a806      	add	r0, sp, #24
c0d01c90:	f003 fcca 	bl	c0d05628 <try_context_set>
c0d01c94:	9010      	str	r0, [sp, #64]	; 0x40
c0d01c96:	4668      	mov	r0, sp
c0d01c98:	2106      	movs	r1, #6
c0d01c9a:	4a24      	ldr	r2, [pc, #144]	; (c0d01d2c <testPrivateKeyDerivation+0x268>)
c0d01c9c:	447a      	add	r2, pc
c0d01c9e:	f7ff fe91 	bl	c0d019c4 <testcase_derivePrivateKey>
c0d01ca2:	2400      	movs	r4, #0
c0d01ca4:	e00d      	b.n	c0d01cc2 <testPrivateKeyDerivation+0x1fe>
c0d01ca6:	a806      	add	r0, sp, #24
c0d01ca8:	2100      	movs	r1, #0
c0d01caa:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d01cac:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01cae:	f003 fcbb 	bl	c0d05628 <try_context_set>
c0d01cb2:	2401      	movs	r4, #1
c0d01cb4:	e005      	b.n	c0d01cc2 <testPrivateKeyDerivation+0x1fe>
c0d01cb6:	a806      	add	r0, sp, #24
c0d01cb8:	2400      	movs	r4, #0
c0d01cba:	8584      	strh	r4, [r0, #44]	; 0x2c
c0d01cbc:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01cbe:	f003 fcb3 	bl	c0d05628 <try_context_set>
c0d01cc2:	f003 fca5 	bl	c0d05610 <try_context_get>
c0d01cc6:	a906      	add	r1, sp, #24
c0d01cc8:	4288      	cmp	r0, r1
c0d01cca:	d102      	bne.n	c0d01cd2 <testPrivateKeyDerivation+0x20e>
c0d01ccc:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d01cce:	f003 fcab 	bl	c0d05628 <try_context_set>
c0d01cd2:	4817      	ldr	r0, [pc, #92]	; (c0d01d30 <testPrivateKeyDerivation+0x26c>)
c0d01cd4:	4478      	add	r0, pc
c0d01cd6:	1cc1      	adds	r1, r0, #3
c0d01cd8:	4620      	mov	r0, r4
c0d01cda:	f7fe f9c9 	bl	c0d00070 <assert>
c0d01cde:	a806      	add	r0, sp, #24
c0d01ce0:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d01ce2:	2800      	cmp	r0, #0
c0d01ce4:	d101      	bne.n	c0d01cea <testPrivateKeyDerivation+0x226>
#undef TESTCASE
}
c0d01ce6:	b012      	add	sp, #72	; 0x48
c0d01ce8:	bd70      	pop	{r4, r5, r6, pc}
c0d01cea:	f000 fa53 	bl	c0d02194 <os_longjmp>
c0d01cee:	46c0      	nop			; (mov r8, r8)
c0d01cf0:	00006e10 	.word	0x00006e10
c0d01cf4:	000076c6 	.word	0x000076c6
c0d01cf8:	000073a3 	.word	0x000073a3
c0d01cfc:	000076be 	.word	0x000076be
c0d01d00:	000073ca 	.word	0x000073ca
c0d01d04:	00007640 	.word	0x00007640
c0d01d08:	000079fb 	.word	0x000079fb
c0d01d0c:	0000739d 	.word	0x0000739d
c0d01d10:	000075d6 	.word	0x000075d6
c0d01d14:	0000797f 	.word	0x0000797f
c0d01d18:	0000733d 	.word	0x0000733d
c0d01d1c:	00007570 	.word	0x00007570
c0d01d20:	00007905 	.word	0x00007905
c0d01d24:	000072df 	.word	0x000072df
c0d01d28:	0000750a 	.word	0x0000750a
c0d01d2c:	0000788b 	.word	0x0000788b
c0d01d30:	00007281 	.word	0x00007281

c0d01d34 <testcase_derivePublicKey>:

void testcase_derivePublicKey(uint32_t* path, uint32_t pathLen, const char* expectedHex)
{
c0d01d34:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d01d36:	b0b5      	sub	sp, #212	; 0xd4
c0d01d38:	9204      	str	r2, [sp, #16]
c0d01d3a:	460c      	mov	r4, r1
c0d01d3c:	4605      	mov	r5, r0
	PRINTF("testcase_derivePublicKey ");
c0d01d3e:	4836      	ldr	r0, [pc, #216]	; (c0d01e18 <testcase_derivePublicKey+0xe4>)
c0d01d40:	4478      	add	r0, pc
c0d01d42:	f000 ff7f 	bl	c0d02c44 <mcu_usb_printf>
	pathSpec->length = pathLength;
c0d01d46:	9434      	str	r4, [sp, #208]	; 0xd0
	memmove(pathSpec->path, pathArray, pathLength * 4);
c0d01d48:	00a2      	lsls	r2, r4, #2
c0d01d4a:	ac2a      	add	r4, sp, #168	; 0xa8
c0d01d4c:	4620      	mov	r0, r4
c0d01d4e:	4629      	mov	r1, r5
c0d01d50:	f006 fbe1 	bl	c0d08516 <__aeabi_memcpy>

	bip44_path_t pathSpec;
	pathSpec_init(&pathSpec, path, pathLen);
	bip44_PRINTF(&pathSpec);
c0d01d54:	4620      	mov	r0, r4
c0d01d56:	f7fe fac3 	bl	c0d002e0 <bip44_PRINTF>
	PRINTF("\n");
c0d01d5a:	4d30      	ldr	r5, [pc, #192]	; (c0d01e1c <testcase_derivePublicKey+0xe8>)
c0d01d5c:	447d      	add	r5, pc
c0d01d5e:	4628      	mov	r0, r5
c0d01d60:	f000 ff70 	bl	c0d02c44 <mcu_usb_printf>
c0d01d64:	a917      	add	r1, sp, #92	; 0x5c

	public_key_t publicKey;
	derivePublicKey(&pathSpec, &publicKey);
c0d01d66:	9105      	str	r1, [sp, #20]
c0d01d68:	4620      	mov	r0, r4
c0d01d6a:	f7ff fdef 	bl	c0d0194c <derivePublicKey>
	TRACE("%d", SIZEOF(publicKey.W));
c0d01d6e:	4e2c      	ldr	r6, [pc, #176]	; (c0d01e20 <testcase_derivePublicKey+0xec>)
c0d01d70:	447e      	add	r6, pc
c0d01d72:	4c2c      	ldr	r4, [pc, #176]	; (c0d01e24 <testcase_derivePublicKey+0xf0>)
c0d01d74:	447c      	add	r4, pc
c0d01d76:	2259      	movs	r2, #89	; 0x59
c0d01d78:	4630      	mov	r0, r6
c0d01d7a:	4621      	mov	r1, r4
c0d01d7c:	f000 ff62 	bl	c0d02c44 <mcu_usb_printf>
c0d01d80:	4829      	ldr	r0, [pc, #164]	; (c0d01e28 <testcase_derivePublicKey+0xf4>)
c0d01d82:	4478      	add	r0, pc
c0d01d84:	9003      	str	r0, [sp, #12]
c0d01d86:	2741      	movs	r7, #65	; 0x41
c0d01d88:	4639      	mov	r1, r7
c0d01d8a:	f000 ff5b 	bl	c0d02c44 <mcu_usb_printf>
c0d01d8e:	9501      	str	r5, [sp, #4]
c0d01d90:	4628      	mov	r0, r5
c0d01d92:	f000 ff57 	bl	c0d02c44 <mcu_usb_printf>
c0d01d96:	225a      	movs	r2, #90	; 0x5a
	TRACE_BUFFER(publicKey.W, SIZEOF(publicKey.W));
c0d01d98:	4630      	mov	r0, r6
c0d01d9a:	4621      	mov	r1, r4
c0d01d9c:	9400      	str	r4, [sp, #0]
c0d01d9e:	f000 ff51 	bl	c0d02c44 <mcu_usb_printf>
c0d01da2:	9a05      	ldr	r2, [sp, #20]
c0d01da4:	3208      	adds	r2, #8
c0d01da6:	9205      	str	r2, [sp, #20]
c0d01da8:	4820      	ldr	r0, [pc, #128]	; (c0d01e2c <testcase_derivePublicKey+0xf8>)
c0d01daa:	4478      	add	r0, pc
c0d01dac:	9002      	str	r0, [sp, #8]
c0d01dae:	4639      	mov	r1, r7
c0d01db0:	f000 ff48 	bl	c0d02c44 <mcu_usb_printf>
c0d01db4:	4628      	mov	r0, r5
c0d01db6:	f000 ff45 	bl	c0d02c44 <mcu_usb_printf>
c0d01dba:	ad06      	add	r5, sp, #24

	uint8_t expected[65];
	decode_hex(expectedHex, expected, SIZEOF(expected));
c0d01dbc:	9804      	ldr	r0, [sp, #16]
c0d01dbe:	4629      	mov	r1, r5
c0d01dc0:	463a      	mov	r2, r7
c0d01dc2:	f7ff f883 	bl	c0d00ecc <decode_hex>
c0d01dc6:	225e      	movs	r2, #94	; 0x5e
	TRACE("%d", SIZEOF(expected));
c0d01dc8:	4630      	mov	r0, r6
c0d01dca:	4621      	mov	r1, r4
c0d01dcc:	f000 ff3a 	bl	c0d02c44 <mcu_usb_printf>
c0d01dd0:	9803      	ldr	r0, [sp, #12]
c0d01dd2:	4639      	mov	r1, r7
c0d01dd4:	f000 ff36 	bl	c0d02c44 <mcu_usb_printf>
c0d01dd8:	9c01      	ldr	r4, [sp, #4]
c0d01dda:	4620      	mov	r0, r4
c0d01ddc:	f000 ff32 	bl	c0d02c44 <mcu_usb_printf>
c0d01de0:	225f      	movs	r2, #95	; 0x5f
	TRACE_BUFFER(expected, SIZEOF(expected));
c0d01de2:	4630      	mov	r0, r6
c0d01de4:	9900      	ldr	r1, [sp, #0]
c0d01de6:	f000 ff2d 	bl	c0d02c44 <mcu_usb_printf>
c0d01dea:	9802      	ldr	r0, [sp, #8]
c0d01dec:	4639      	mov	r1, r7
c0d01dee:	462a      	mov	r2, r5
c0d01df0:	f000 ff28 	bl	c0d02c44 <mcu_usb_printf>
c0d01df4:	4620      	mov	r0, r4
c0d01df6:	f000 ff25 	bl	c0d02c44 <mcu_usb_printf>

	EXPECT_EQ_BYTES(expected, publicKey.W, SIZEOF(expected));
c0d01dfa:	4628      	mov	r0, r5
c0d01dfc:	9905      	ldr	r1, [sp, #20]
c0d01dfe:	463a      	mov	r2, r7
c0d01e00:	f006 fb9c 	bl	c0d0853c <memcmp>
c0d01e04:	4241      	negs	r1, r0
c0d01e06:	4148      	adcs	r0, r1
c0d01e08:	4909      	ldr	r1, [pc, #36]	; (c0d01e30 <testcase_derivePublicKey+0xfc>)
c0d01e0a:	4479      	add	r1, pc
c0d01e0c:	1cc9      	adds	r1, r1, #3
c0d01e0e:	f7fe f92f 	bl	c0d00070 <assert>
}
c0d01e12:	b035      	add	sp, #212	; 0xd4
c0d01e14:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d01e16:	46c0      	nop			; (mov r8, r8)
c0d01e18:	00007231 	.word	0x00007231
c0d01e1c:	000077ca 	.word	0x000077ca
c0d01e20:	00006c4f 	.word	0x00006c4f
c0d01e24:	00007217 	.word	0x00007217
c0d01e28:	000076a8 	.word	0x000076a8
c0d01e2c:	00006c36 	.word	0x00006c36
c0d01e30:	0000719a 	.word	0x0000719a

c0d01e34 <testPublicKeyDerivation>:

void testPublicKeyDerivation()
{
c0d01e34:	b570      	push	{r4, r5, r6, lr}
c0d01e36:	b086      	sub	sp, #24
		uint32_t path[] = { UNWRAP path_ }; \
		testcase_derivePublicKey(path, ARRAY_LEN(path), expectedHex_); \
	}


	TESTCASE(
c0d01e38:	490e      	ldr	r1, [pc, #56]	; (c0d01e74 <testPublicKeyDerivation+0x40>)
c0d01e3a:	4479      	add	r1, pc
c0d01e3c:	a801      	add	r0, sp, #4
c0d01e3e:	4602      	mov	r2, r0
c0d01e40:	c918      	ldmia	r1!, {r3, r4}
c0d01e42:	c218      	stmia	r2!, {r3, r4}
c0d01e44:	c938      	ldmia	r1!, {r3, r4, r5}
c0d01e46:	c238      	stmia	r2!, {r3, r4, r5}
c0d01e48:	2405      	movs	r4, #5
c0d01e4a:	4a0b      	ldr	r2, [pc, #44]	; (c0d01e78 <testPublicKeyDerivation+0x44>)
c0d01e4c:	447a      	add	r2, pc
c0d01e4e:	4621      	mov	r1, r4
c0d01e50:	f7ff ff70 	bl	c0d01d34 <testcase_derivePublicKey>
	        (HD + 44, HD + 235, HD + 0, 0, 0),
	        "04a9a222bc3b1a5a58ada17d10069b3961ebd0f917d4b2106031a061915ca9cc24a06941e0a4c0d5e266850ff980ad349ab8b027c93bf4aead1984168ad43e30ab"
	)

	TESTCASE(
c0d01e54:	4909      	ldr	r1, [pc, #36]	; (c0d01e7c <testPublicKeyDerivation+0x48>)
c0d01e56:	4479      	add	r1, pc
c0d01e58:	a801      	add	r0, sp, #4
c0d01e5a:	4602      	mov	r2, r0
c0d01e5c:	c928      	ldmia	r1!, {r3, r5}
c0d01e5e:	c228      	stmia	r2!, {r3, r5}
c0d01e60:	c968      	ldmia	r1!, {r3, r5, r6}
c0d01e62:	c268      	stmia	r2!, {r3, r5, r6}
c0d01e64:	4a06      	ldr	r2, [pc, #24]	; (c0d01e80 <testPublicKeyDerivation+0x4c>)
c0d01e66:	447a      	add	r2, pc
c0d01e68:	4621      	mov	r1, r4
c0d01e6a:	f7ff ff63 	bl	c0d01d34 <testcase_derivePublicKey>
	        "0484e52dfea57b8f1787488a356374cd8e8515b8ad8db3dd4f9088d8e42ed2fb6d571e8894cccbdbf15e1bd84f8b4362f52d1b5b712b9775c0a51cdd5ee9a9e8ca"
	);


#undef TESTCASE
}
c0d01e6e:	b006      	add	sp, #24
c0d01e70:	bd70      	pop	{r4, r5, r6, pc}
c0d01e72:	46c0      	nop			; (mov r8, r8)
c0d01e74:	00007356 	.word	0x00007356
c0d01e78:	00007174 	.word	0x00007174
c0d01e7c:	0000734e 	.word	0x0000734e
c0d01e80:	000071dd 	.word	0x000071dd

c0d01e84 <run_key_derivation_test>:

void run_key_derivation_test()
{
c0d01e84:	b580      	push	{r7, lr}
	PRINTF("Running key derivation tests\n");
c0d01e86:	4808      	ldr	r0, [pc, #32]	; (c0d01ea8 <run_key_derivation_test+0x24>)
c0d01e88:	4478      	add	r0, pc
c0d01e8a:	f000 fedb 	bl	c0d02c44 <mcu_usb_printf>
	PRINTF("If they fail, make sure you seeded your device with\n");
c0d01e8e:	4807      	ldr	r0, [pc, #28]	; (c0d01eac <run_key_derivation_test+0x28>)
c0d01e90:	4478      	add	r0, pc
c0d01e92:	f000 fed7 	bl	c0d02c44 <mcu_usb_printf>
	PRINTF("12-word mnemonic: 11*abandon about\n");
c0d01e96:	4806      	ldr	r0, [pc, #24]	; (c0d01eb0 <run_key_derivation_test+0x2c>)
c0d01e98:	4478      	add	r0, pc
c0d01e9a:	f000 fed3 	bl	c0d02c44 <mcu_usb_printf>
	testPrivateKeyDerivation();
c0d01e9e:	f7ff fe11 	bl	c0d01ac4 <testPrivateKeyDerivation>
	testPublicKeyDerivation();
c0d01ea2:	f7ff ffc7 	bl	c0d01e34 <testPublicKeyDerivation>
}
c0d01ea6:	bd80      	pop	{r7, pc}
c0d01ea8:	0000723e 	.word	0x0000723e
c0d01eac:	00007254 	.word	0x00007254
c0d01eb0:	00007281 	.word	0x00007281

c0d01eb4 <ui_idle>:
{
c0d01eb4:	b510      	push	{r4, lr}
c0d01eb6:	2400      	movs	r4, #0
c0d01eb8:	43e0      	mvns	r0, r4
	currentInstruction = INS_NONE;
c0d01eba:	4905      	ldr	r1, [pc, #20]	; (c0d01ed0 <ui_idle+0x1c>)
c0d01ebc:	6008      	str	r0, [r1, #0]
	nanos_clear_timer();
c0d01ebe:	f7ff f92b 	bl	c0d01118 <nanos_clear_timer>
	UX_MENU_DISPLAY(0, menu_main, NULL);
c0d01ec2:	4904      	ldr	r1, [pc, #16]	; (c0d01ed4 <ui_idle+0x20>)
c0d01ec4:	4479      	add	r1, pc
c0d01ec6:	4620      	mov	r0, r4
c0d01ec8:	4622      	mov	r2, r4
c0d01eca:	f006 f871 	bl	c0d07fb0 <ux_menu_display>
}
c0d01ece:	bd10      	pop	{r4, pc}
c0d01ed0:	20000858 	.word	0x20000858
c0d01ed4:	000073f0 	.word	0x000073f0

c0d01ed8 <fio_main>:
{
c0d01ed8:	b090      	sub	sp, #64	; 0x40
c0d01eda:	2400      	movs	r4, #0
	volatile size_t rx = 0;
c0d01edc:	940f      	str	r4, [sp, #60]	; 0x3c
	volatile size_t tx = 0;
c0d01ede:	940e      	str	r4, [sp, #56]	; 0x38
c0d01ee0:	a80d      	add	r0, sp, #52	; 0x34
	volatile uint8_t flags = 0;
c0d01ee2:	7004      	strb	r4, [r0, #0]
c0d01ee4:	4d82      	ldr	r5, [pc, #520]	; (c0d020f0 <fio_main+0x218>)
c0d01ee6:	447d      	add	r5, pc
c0d01ee8:	4e7d      	ldr	r6, [pc, #500]	; (c0d020e0 <fio_main+0x208>)
c0d01eea:	af01      	add	r7, sp, #4
			TRY {
c0d01eec:	4638      	mov	r0, r7
c0d01eee:	f006 fb57 	bl	c0d085a0 <setjmp>
c0d01ef2:	85b8      	strh	r0, [r7, #44]	; 0x2c
c0d01ef4:	b287      	uxth	r7, r0
c0d01ef6:	2f00      	cmp	r7, #0
c0d01ef8:	d029      	beq.n	c0d01f4e <fio_main+0x76>
c0d01efa:	2047      	movs	r0, #71	; 0x47
c0d01efc:	0200      	lsls	r0, r0, #8
c0d01efe:	4287      	cmp	r7, r0
c0d01f00:	d01f      	beq.n	c0d01f42 <fio_main+0x6a>
c0d01f02:	2f05      	cmp	r7, #5
c0d01f04:	d100      	bne.n	c0d01f08 <fio_main+0x30>
c0d01f06:	e0a3      	b.n	c0d02050 <fio_main+0x178>
c0d01f08:	a801      	add	r0, sp, #4
			CATCH_OTHER(e)
c0d01f0a:	8584      	strh	r4, [r0, #44]	; 0x2c
c0d01f0c:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d01f0e:	f003 fb8b 	bl	c0d05628 <try_context_set>
				if (e >= _ERR_AUTORESPOND_START && e < _ERR_AUTORESPOND_END) {
c0d01f12:	4876      	ldr	r0, [pc, #472]	; (c0d020ec <fio_main+0x214>)
c0d01f14:	1838      	adds	r0, r7, r0
c0d01f16:	2812      	cmp	r0, #18
c0d01f18:	d827      	bhi.n	c0d01f6a <fio_main+0x92>
					io_send_buf(e, NULL, 0);
c0d01f1a:	4638      	mov	r0, r7
c0d01f1c:	4621      	mov	r1, r4
c0d01f1e:	4622      	mov	r2, r4
c0d01f20:	f7ff f932 	bl	c0d01188 <io_send_buf>
c0d01f24:	43e0      	mvns	r0, r4
	currentInstruction = INS_NONE;
c0d01f26:	496f      	ldr	r1, [pc, #444]	; (c0d020e4 <fio_main+0x20c>)
c0d01f28:	6008      	str	r0, [r1, #0]
c0d01f2a:	a80d      	add	r0, sp, #52	; 0x34
c0d01f2c:	2110      	movs	r1, #16
					flags = IO_ASYNCH_REPLY;
c0d01f2e:	7001      	strb	r1, [r0, #0]
	nanos_clear_timer();
c0d01f30:	f7ff f8f2 	bl	c0d01118 <nanos_clear_timer>
	UX_MENU_DISPLAY(0, menu_main, NULL);
c0d01f34:	4978      	ldr	r1, [pc, #480]	; (c0d02118 <fio_main+0x240>)
c0d01f36:	4479      	add	r1, pc
c0d01f38:	4620      	mov	r0, r4
c0d01f3a:	4622      	mov	r2, r4
c0d01f3c:	f006 f838 	bl	c0d07fb0 <ux_menu_display>
c0d01f40:	e077      	b.n	c0d02032 <fio_main+0x15a>
c0d01f42:	a801      	add	r0, sp, #4
			CATCH(ERR_ASSERT)
c0d01f44:	8584      	strh	r4, [r0, #44]	; 0x2c
c0d01f46:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d01f48:	f003 fb6e 	bl	c0d05628 <try_context_set>
c0d01f4c:	e012      	b.n	c0d01f74 <fio_main+0x9c>
c0d01f4e:	a801      	add	r0, sp, #4
			TRY {
c0d01f50:	f003 fb6a 	bl	c0d05628 <try_context_set>
				rx = tx;
c0d01f54:	990e      	ldr	r1, [sp, #56]	; 0x38
c0d01f56:	910f      	str	r1, [sp, #60]	; 0x3c
				tx = 0; // ensure no race in CATCH_OTHER if io_exchange throws an error
c0d01f58:	940e      	str	r4, [sp, #56]	; 0x38
			TRY {
c0d01f5a:	900b      	str	r0, [sp, #44]	; 0x2c
c0d01f5c:	20ff      	movs	r0, #255	; 0xff
c0d01f5e:	3052      	adds	r0, #82	; 0x52
				ASSERT((unsigned int) rx < sizeof(G_io_apdu_buffer));
c0d01f60:	990f      	ldr	r1, [sp, #60]	; 0x3c
c0d01f62:	4281      	cmp	r1, r0
c0d01f64:	d309      	bcc.n	c0d01f7a <fio_main+0xa2>
c0d01f66:	4620      	mov	r0, r4
c0d01f68:	e008      	b.n	c0d01f7c <fio_main+0xa4>
					PRINTF("Uncaught error 0x%x", (unsigned) e);
c0d01f6a:	486c      	ldr	r0, [pc, #432]	; (c0d0211c <fio_main+0x244>)
c0d01f6c:	4478      	add	r0, pc
c0d01f6e:	4639      	mov	r1, r7
c0d01f70:	f000 fe68 	bl	c0d02c44 <mcu_usb_printf>
c0d01f74:	f000 fb0c 	bl	c0d02590 <io_seproxyhal_se_reset>
c0d01f78:	e05b      	b.n	c0d02032 <fio_main+0x15a>
c0d01f7a:	2001      	movs	r0, #1
				ASSERT((unsigned int) rx < sizeof(G_io_apdu_buffer));
c0d01f7c:	4629      	mov	r1, r5
c0d01f7e:	f7fe f877 	bl	c0d00070 <assert>
c0d01f82:	af0d      	add	r7, sp, #52	; 0x34
				rx = (unsigned int) io_exchange((uint8_t) (CHANNEL_APDU | flags), (uint16_t) rx);
c0d01f84:	7838      	ldrb	r0, [r7, #0]
c0d01f86:	990f      	ldr	r1, [sp, #60]	; 0x3c
c0d01f88:	b289      	uxth	r1, r1
c0d01f8a:	f000 fb2d 	bl	c0d025e8 <io_exchange>
c0d01f8e:	900f      	str	r0, [sp, #60]	; 0x3c
				flags = 0;
c0d01f90:	703c      	strb	r4, [r7, #0]
c0d01f92:	4f51      	ldr	r7, [pc, #324]	; (c0d020d8 <fio_main+0x200>)
				ASSERT(io_state == IO_EXPECT_IO);
c0d01f94:	7839      	ldrb	r1, [r7, #0]
c0d01f96:	392a      	subs	r1, #42	; 0x2a
c0d01f98:	4248      	negs	r0, r1
c0d01f9a:	4148      	adcs	r0, r1
c0d01f9c:	4955      	ldr	r1, [pc, #340]	; (c0d020f4 <fio_main+0x21c>)
c0d01f9e:	4479      	add	r1, pc
c0d01fa0:	f7fe f866 	bl	c0d00070 <assert>
c0d01fa4:	2031      	movs	r0, #49	; 0x31
				io_state = IO_EXPECT_NONE;
c0d01fa6:	7038      	strb	r0, [r7, #0]
				if (rx == 0)
c0d01fa8:	980f      	ldr	r0, [sp, #60]	; 0x3c
c0d01faa:	2800      	cmp	r0, #0
c0d01fac:	d055      	beq.n	c0d0205a <fio_main+0x182>
				VALIDATE(device_is_unlocked(), ERR_DEVICE_LOCKED);
c0d01fae:	f7ff fc61 	bl	c0d01874 <device_is_unlocked>
c0d01fb2:	2800      	cmp	r0, #0
c0d01fb4:	d054      	beq.n	c0d02060 <fio_main+0x188>
				VALIDATE(rx >= SIZEOF(*header), ERR_MALFORMED_REQUEST_HEADER);
c0d01fb6:	980f      	ldr	r0, [sp, #60]	; 0x3c
c0d01fb8:	2804      	cmp	r0, #4
c0d01fba:	d95c      	bls.n	c0d02076 <fio_main+0x19e>
				VALIDATE(rx == header->lc + SIZEOF(*header), ERR_MALFORMED_REQUEST_HEADER);
c0d01fbc:	7930      	ldrb	r0, [r6, #4]
c0d01fbe:	1d40      	adds	r0, r0, #5
c0d01fc0:	990f      	ldr	r1, [sp, #60]	; 0x3c
c0d01fc2:	4281      	cmp	r1, r0
c0d01fc4:	d15d      	bne.n	c0d02082 <fio_main+0x1aa>
				VALIDATE(header->cla == CLA, ERR_BAD_CLA);
c0d01fc6:	7830      	ldrb	r0, [r6, #0]
c0d01fc8:	28d7      	cmp	r0, #215	; 0xd7
c0d01fca:	d164      	bne.n	c0d02096 <fio_main+0x1be>
				TRACE("APDU: ins = %d,   p1 = %d,    p2 = %d", header->ins, header->p1, header->p2);
c0d01fcc:	484e      	ldr	r0, [pc, #312]	; (c0d02108 <fio_main+0x230>)
c0d01fce:	4478      	add	r0, pc
c0d01fd0:	494e      	ldr	r1, [pc, #312]	; (c0d0210c <fio_main+0x234>)
c0d01fd2:	4479      	add	r1, pc
c0d01fd4:	2283      	movs	r2, #131	; 0x83
c0d01fd6:	f000 fe35 	bl	c0d02c44 <mcu_usb_printf>
c0d01fda:	78f3      	ldrb	r3, [r6, #3]
c0d01fdc:	78b2      	ldrb	r2, [r6, #2]
c0d01fde:	7871      	ldrb	r1, [r6, #1]
c0d01fe0:	484b      	ldr	r0, [pc, #300]	; (c0d02110 <fio_main+0x238>)
c0d01fe2:	4478      	add	r0, pc
c0d01fe4:	f000 fe2e 	bl	c0d02c44 <mcu_usb_printf>
c0d01fe8:	484a      	ldr	r0, [pc, #296]	; (c0d02114 <fio_main+0x23c>)
c0d01fea:	4478      	add	r0, pc
c0d01fec:	f000 fe2a 	bl	c0d02c44 <mcu_usb_printf>
				handler_fn_t *handlerFn = lookupHandler(header->ins);
c0d01ff0:	7870      	ldrb	r0, [r6, #1]
c0d01ff2:	f7fe ff27 	bl	c0d00e44 <lookupHandler>
				VALIDATE(handlerFn != NULL, ERR_UNKNOWN_INS);
c0d01ff6:	2800      	cmp	r0, #0
c0d01ff8:	d058      	beq.n	c0d020ac <fio_main+0x1d4>
c0d01ffa:	4607      	mov	r7, r0
c0d01ffc:	4839      	ldr	r0, [pc, #228]	; (c0d020e4 <fio_main+0x20c>)
				if (currentInstruction == INS_NONE)
c0d01ffe:	6800      	ldr	r0, [r0, #0]
c0d02000:	1c41      	adds	r1, r0, #1
c0d02002:	d004      	beq.n	c0d0200e <fio_main+0x136>
					VALIDATE(header->ins == currentInstruction, ERR_STILL_IN_CALL);
c0d02004:	7871      	ldrb	r1, [r6, #1]
c0d02006:	4288      	cmp	r0, r1
c0d02008:	d15b      	bne.n	c0d020c2 <fio_main+0x1ea>
c0d0200a:	2200      	movs	r2, #0
c0d0200c:	e008      	b.n	c0d02020 <fio_main+0x148>
c0d0200e:	2079      	movs	r0, #121	; 0x79
c0d02010:	00c1      	lsls	r1, r0, #3
					explicit_bzero(&instructionState, SIZEOF(instructionState));
c0d02012:	4835      	ldr	r0, [pc, #212]	; (c0d020e8 <fio_main+0x210>)
c0d02014:	f006 fa8e 	bl	c0d08534 <explicit_bzero>
					currentInstruction = header->ins;
c0d02018:	7870      	ldrb	r0, [r6, #1]
c0d0201a:	4932      	ldr	r1, [pc, #200]	; (c0d020e4 <fio_main+0x20c>)
c0d0201c:	6008      	str	r0, [r1, #0]
c0d0201e:	2201      	movs	r2, #1
				          header->lc,
c0d02020:	7933      	ldrb	r3, [r6, #4]
				          header->p2,
c0d02022:	78f1      	ldrb	r1, [r6, #3]
				handlerFn(header->p1,
c0d02024:	78b0      	ldrb	r0, [r6, #2]
c0d02026:	9200      	str	r2, [sp, #0]
c0d02028:	1d72      	adds	r2, r6, #5
c0d0202a:	47b8      	blx	r7
c0d0202c:	a80d      	add	r0, sp, #52	; 0x34
c0d0202e:	2110      	movs	r1, #16
				flags = IO_ASYNCH_REPLY;
c0d02030:	7001      	strb	r1, [r0, #0]
			FINALLY {
c0d02032:	f003 faed 	bl	c0d05610 <try_context_get>
c0d02036:	a901      	add	r1, sp, #4
c0d02038:	4288      	cmp	r0, r1
c0d0203a:	d102      	bne.n	c0d02042 <fio_main+0x16a>
c0d0203c:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d0203e:	f003 faf3 	bl	c0d05628 <try_context_set>
c0d02042:	a801      	add	r0, sp, #4
		END_TRY;
c0d02044:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d02046:	2800      	cmp	r0, #0
c0d02048:	d100      	bne.n	c0d0204c <fio_main+0x174>
c0d0204a:	e74e      	b.n	c0d01eea <fio_main+0x12>
c0d0204c:	f000 f8a2 	bl	c0d02194 <os_longjmp>
c0d02050:	a801      	add	r0, sp, #4
			CATCH(EXCEPTION_IO_RESET)
c0d02052:	8584      	strh	r4, [r0, #44]	; 0x2c
c0d02054:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d02056:	f003 fae7 	bl	c0d05628 <try_context_set>
c0d0205a:	2005      	movs	r0, #5
c0d0205c:	f000 f89a 	bl	c0d02194 <os_longjmp>
				VALIDATE(device_is_unlocked(), ERR_DEVICE_LOCKED);
c0d02060:	482f      	ldr	r0, [pc, #188]	; (c0d02120 <fio_main+0x248>)
c0d02062:	4478      	add	r0, pc
c0d02064:	492f      	ldr	r1, [pc, #188]	; (c0d02124 <fio_main+0x24c>)
c0d02066:	4479      	add	r1, pc
c0d02068:	226d      	movs	r2, #109	; 0x6d
c0d0206a:	f000 fdeb 	bl	c0d02c44 <mcu_usb_printf>
c0d0206e:	481b      	ldr	r0, [pc, #108]	; (c0d020dc <fio_main+0x204>)
c0d02070:	3010      	adds	r0, #16
c0d02072:	f000 f88f 	bl	c0d02194 <os_longjmp>
				VALIDATE(rx >= SIZEOF(*header), ERR_MALFORMED_REQUEST_HEADER);
c0d02076:	4820      	ldr	r0, [pc, #128]	; (c0d020f8 <fio_main+0x220>)
c0d02078:	4478      	add	r0, pc
c0d0207a:	4920      	ldr	r1, [pc, #128]	; (c0d020fc <fio_main+0x224>)
c0d0207c:	4479      	add	r1, pc
c0d0207e:	227a      	movs	r2, #122	; 0x7a
c0d02080:	e004      	b.n	c0d0208c <fio_main+0x1b4>
				VALIDATE(rx == header->lc + SIZEOF(*header), ERR_MALFORMED_REQUEST_HEADER);
c0d02082:	481f      	ldr	r0, [pc, #124]	; (c0d02100 <fio_main+0x228>)
c0d02084:	4478      	add	r0, pc
c0d02086:	491f      	ldr	r1, [pc, #124]	; (c0d02104 <fio_main+0x22c>)
c0d02088:	4479      	add	r1, pc
c0d0208a:	227d      	movs	r2, #125	; 0x7d
c0d0208c:	f000 fdda 	bl	c0d02c44 <mcu_usb_printf>
c0d02090:	4812      	ldr	r0, [pc, #72]	; (c0d020dc <fio_main+0x204>)
c0d02092:	f000 f87f 	bl	c0d02194 <os_longjmp>
				VALIDATE(header->cla == CLA, ERR_BAD_CLA);
c0d02096:	4824      	ldr	r0, [pc, #144]	; (c0d02128 <fio_main+0x250>)
c0d02098:	4478      	add	r0, pc
c0d0209a:	4924      	ldr	r1, [pc, #144]	; (c0d0212c <fio_main+0x254>)
c0d0209c:	4479      	add	r1, pc
c0d0209e:	2281      	movs	r2, #129	; 0x81
c0d020a0:	f000 fdd0 	bl	c0d02c44 <mcu_usb_printf>
c0d020a4:	480d      	ldr	r0, [pc, #52]	; (c0d020dc <fio_main+0x204>)
c0d020a6:	1c40      	adds	r0, r0, #1
c0d020a8:	f000 f874 	bl	c0d02194 <os_longjmp>
				VALIDATE(handlerFn != NULL, ERR_UNKNOWN_INS);
c0d020ac:	4820      	ldr	r0, [pc, #128]	; (c0d02130 <fio_main+0x258>)
c0d020ae:	4478      	add	r0, pc
c0d020b0:	4920      	ldr	r1, [pc, #128]	; (c0d02134 <fio_main+0x25c>)
c0d020b2:	4479      	add	r1, pc
c0d020b4:	2288      	movs	r2, #136	; 0x88
c0d020b6:	f000 fdc5 	bl	c0d02c44 <mcu_usb_printf>
c0d020ba:	4808      	ldr	r0, [pc, #32]	; (c0d020dc <fio_main+0x204>)
c0d020bc:	1c80      	adds	r0, r0, #2
c0d020be:	f000 f869 	bl	c0d02194 <os_longjmp>
					VALIDATE(header->ins == currentInstruction, ERR_STILL_IN_CALL);
c0d020c2:	481d      	ldr	r0, [pc, #116]	; (c0d02138 <fio_main+0x260>)
c0d020c4:	4478      	add	r0, pc
c0d020c6:	491d      	ldr	r1, [pc, #116]	; (c0d0213c <fio_main+0x264>)
c0d020c8:	4479      	add	r1, pc
c0d020ca:	2292      	movs	r2, #146	; 0x92
c0d020cc:	f000 fdba 	bl	c0d02c44 <mcu_usb_printf>
c0d020d0:	4802      	ldr	r0, [pc, #8]	; (c0d020dc <fio_main+0x204>)
c0d020d2:	1cc0      	adds	r0, r0, #3
c0d020d4:	f000 f85e 	bl	c0d02194 <os_longjmp>
c0d020d8:	20000204 	.word	0x20000204
c0d020dc:	00006e01 	.word	0x00006e01
c0d020e0:	20000285 	.word	0x20000285
c0d020e4:	20000858 	.word	0x20000858
c0d020e8:	20000490 	.word	0x20000490
c0d020ec:	ffff9200 	.word	0xffff9200
c0d020f0:	000072d2 	.word	0x000072d2
c0d020f4:	00007228 	.word	0x00007228
c0d020f8:	00006586 	.word	0x00006586
c0d020fc:	00007159 	.word	0x00007159
c0d02100:	0000657a 	.word	0x0000657a
c0d02104:	0000714d 	.word	0x0000714d
c0d02108:	000069f1 	.word	0x000069f1
c0d0210c:	0000720e 	.word	0x0000720e
c0d02110:	00007207 	.word	0x00007207
c0d02114:	0000753c 	.word	0x0000753c
c0d02118:	0000737e 	.word	0x0000737e
c0d0211c:	000072a3 	.word	0x000072a3
c0d02120:	0000659c 	.word	0x0000659c
c0d02124:	0000716f 	.word	0x0000716f
c0d02128:	00006566 	.word	0x00006566
c0d0212c:	00007139 	.word	0x00007139
c0d02130:	00006550 	.word	0x00006550
c0d02134:	00007123 	.word	0x00007123
c0d02138:	0000653a 	.word	0x0000653a
c0d0213c:	0000710d 	.word	0x0000710d

c0d02140 <app_exit>:
{
c0d02140:	b510      	push	{r4, lr}
c0d02142:	b08c      	sub	sp, #48	; 0x30
c0d02144:	466c      	mov	r4, sp
		TRY_L(exit) {
c0d02146:	4620      	mov	r0, r4
c0d02148:	f006 fa2a 	bl	c0d085a0 <setjmp>
c0d0214c:	85a0      	strh	r0, [r4, #44]	; 0x2c
c0d0214e:	0400      	lsls	r0, r0, #16
c0d02150:	d106      	bne.n	c0d02160 <app_exit+0x20>
c0d02152:	4668      	mov	r0, sp
c0d02154:	f003 fa68 	bl	c0d05628 <try_context_set>
c0d02158:	900a      	str	r0, [sp, #40]	; 0x28
c0d0215a:	20ff      	movs	r0, #255	; 0xff
			os_sched_exit(-1);
c0d0215c:	f003 fa24 	bl	c0d055a8 <os_sched_exit>
		FINALLY_L(exit) {
c0d02160:	f003 fa56 	bl	c0d05610 <try_context_get>
c0d02164:	4669      	mov	r1, sp
c0d02166:	4288      	cmp	r0, r1
c0d02168:	d102      	bne.n	c0d02170 <app_exit+0x30>
c0d0216a:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d0216c:	f003 fa5c 	bl	c0d05628 <try_context_set>
c0d02170:	4668      	mov	r0, sp
	END_TRY_L(exit);
c0d02172:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d02174:	2800      	cmp	r0, #0
c0d02176:	d101      	bne.n	c0d0217c <app_exit+0x3c>
}
c0d02178:	b00c      	add	sp, #48	; 0x30
c0d0217a:	bd10      	pop	{r4, pc}
	END_TRY_L(exit);
c0d0217c:	f000 f80a 	bl	c0d02194 <os_longjmp>

c0d02180 <os_sched_exit_ui_callback>:
	{menu_main, NULL, 0, &C_icon_back, "Back", NULL, 61, 40},
	UX_MENU_END,
};

void os_sched_exit_ui_callback(unsigned int userid MARK_UNUSED)
{
c0d02180:	b580      	push	{r7, lr}
c0d02182:	20aa      	movs	r0, #170	; 0xaa
	os_sched_exit(BOLOS_UX_OK);
c0d02184:	f003 fa10 	bl	c0d055a8 <os_sched_exit>
}
c0d02188:	bd80      	pop	{r7, pc}

c0d0218a <os_boot>:

// apdu buffer must hold a complete apdu to avoid troubles
unsigned char G_io_apdu_buffer[IO_APDU_BUFFER_SIZE];

#ifndef BOLOS_OS_UPGRADER_APP
void os_boot(void) {
c0d0218a:	b580      	push	{r7, lr}
c0d0218c:	2000      	movs	r0, #0
  // // TODO patch entry point when romming (f)
  // // set the default try context to nothing
#ifndef HAVE_BOLOS
  try_context_set(NULL);
c0d0218e:	f003 fa4b 	bl	c0d05628 <try_context_set>
#endif // HAVE_BOLOS
}
c0d02192:	bd80      	pop	{r7, pc}

c0d02194 <os_longjmp>:
  }
  return xoracc;
}

#ifndef HAVE_BOLOS
void os_longjmp(unsigned int exception) {
c0d02194:	4604      	mov	r4, r0
#ifdef HAVE_PRINTF  
  unsigned int lr_val;
  __asm volatile("mov %0, lr" :"=r"(lr_val));
c0d02196:	4672      	mov	r2, lr
  PRINTF("exception[%d]: LR=0x%08X\n", exception, lr_val);
c0d02198:	4804      	ldr	r0, [pc, #16]	; (c0d021ac <os_longjmp+0x18>)
c0d0219a:	4478      	add	r0, pc
c0d0219c:	4621      	mov	r1, r4
c0d0219e:	f000 fd51 	bl	c0d02c44 <mcu_usb_printf>
#endif // HAVE_PRINTF
  longjmp(try_context_get()->jmp_buf, exception);
c0d021a2:	f003 fa35 	bl	c0d05610 <try_context_get>
c0d021a6:	4621      	mov	r1, r4
c0d021a8:	f006 fa06 	bl	c0d085b8 <longjmp>
c0d021ac:	0000718a 	.word	0x0000718a

c0d021b0 <io_seproxyhal_general_status>:
  0,
  2,
  SEPROXYHAL_TAG_GENERAL_STATUS_LAST_COMMAND>>8,
  SEPROXYHAL_TAG_GENERAL_STATUS_LAST_COMMAND,
};
void io_seproxyhal_general_status(void) {
c0d021b0:	b580      	push	{r7, lr}
  // send the general status
  io_seproxyhal_spi_send(seph_io_general_status, sizeof(seph_io_general_status));
c0d021b2:	4803      	ldr	r0, [pc, #12]	; (c0d021c0 <io_seproxyhal_general_status+0x10>)
c0d021b4:	4478      	add	r0, pc
c0d021b6:	2105      	movs	r1, #5
c0d021b8:	f003 fa04 	bl	c0d055c4 <io_seph_send>
}
c0d021bc:	bd80      	pop	{r7, pc}
c0d021be:	46c0      	nop			; (mov r8, r8)
c0d021c0:	0000718a 	.word	0x0000718a

c0d021c4 <io_seproxyhal_handle_usb_event>:
}

#ifdef HAVE_IO_USB
#ifdef HAVE_L4_USBLIB

void io_seproxyhal_handle_usb_event(void) {
c0d021c4:	b510      	push	{r4, lr}
  switch(G_io_seproxyhal_spi_buffer[3]) {
c0d021c6:	4816      	ldr	r0, [pc, #88]	; (c0d02220 <io_seproxyhal_handle_usb_event+0x5c>)
c0d021c8:	78c0      	ldrb	r0, [r0, #3]
c0d021ca:	2803      	cmp	r0, #3
c0d021cc:	dc07      	bgt.n	c0d021de <io_seproxyhal_handle_usb_event+0x1a>
c0d021ce:	2801      	cmp	r0, #1
c0d021d0:	d00d      	beq.n	c0d021ee <io_seproxyhal_handle_usb_event+0x2a>
c0d021d2:	2802      	cmp	r0, #2
c0d021d4:	d11f      	bne.n	c0d02216 <io_seproxyhal_handle_usb_event+0x52>
      }
      memset(G_io_app.usb_ep_xfer_len, 0, sizeof(G_io_app.usb_ep_xfer_len));
      memset(G_io_app.usb_ep_timeouts, 0, sizeof(G_io_app.usb_ep_timeouts));
      break;
    case SEPROXYHAL_TAG_USB_EVENT_SOF:
      USBD_LL_SOF(&USBD_Device);
c0d021d6:	4813      	ldr	r0, [pc, #76]	; (c0d02224 <io_seproxyhal_handle_usb_event+0x60>)
c0d021d8:	f005 f8c0 	bl	c0d0735c <USBD_LL_SOF>
      break;
    case SEPROXYHAL_TAG_USB_EVENT_RESUMED:
      USBD_LL_Resume(&USBD_Device);
      break;
  }
}
c0d021dc:	bd10      	pop	{r4, pc}
  switch(G_io_seproxyhal_spi_buffer[3]) {
c0d021de:	2804      	cmp	r0, #4
c0d021e0:	d016      	beq.n	c0d02210 <io_seproxyhal_handle_usb_event+0x4c>
c0d021e2:	2808      	cmp	r0, #8
c0d021e4:	d117      	bne.n	c0d02216 <io_seproxyhal_handle_usb_event+0x52>
      USBD_LL_Resume(&USBD_Device);
c0d021e6:	480f      	ldr	r0, [pc, #60]	; (c0d02224 <io_seproxyhal_handle_usb_event+0x60>)
c0d021e8:	f005 f8b6 	bl	c0d07358 <USBD_LL_Resume>
}
c0d021ec:	bd10      	pop	{r4, pc}
      USBD_LL_SetSpeed(&USBD_Device, USBD_SPEED_FULL);
c0d021ee:	4c0d      	ldr	r4, [pc, #52]	; (c0d02224 <io_seproxyhal_handle_usb_event+0x60>)
c0d021f0:	2101      	movs	r1, #1
c0d021f2:	4620      	mov	r0, r4
c0d021f4:	f005 f8ab 	bl	c0d0734e <USBD_LL_SetSpeed>
      USBD_LL_Reset(&USBD_Device);
c0d021f8:	4620      	mov	r0, r4
c0d021fa:	f005 f88a 	bl	c0d07312 <USBD_LL_Reset>
      if (G_io_app.apdu_media != IO_APDU_MEDIA_NONE) {
c0d021fe:	480a      	ldr	r0, [pc, #40]	; (c0d02228 <io_seproxyhal_handle_usb_event+0x64>)
c0d02200:	7981      	ldrb	r1, [r0, #6]
c0d02202:	2900      	cmp	r1, #0
c0d02204:	d108      	bne.n	c0d02218 <io_seproxyhal_handle_usb_event+0x54>
c0d02206:	2100      	movs	r1, #0
      memset(G_io_app.usb_ep_xfer_len, 0, sizeof(G_io_app.usb_ep_xfer_len));
c0d02208:	60c1      	str	r1, [r0, #12]
      memset(G_io_app.usb_ep_timeouts, 0, sizeof(G_io_app.usb_ep_timeouts));
c0d0220a:	6101      	str	r1, [r0, #16]
c0d0220c:	6141      	str	r1, [r0, #20]
}
c0d0220e:	bd10      	pop	{r4, pc}
      USBD_LL_Suspend(&USBD_Device);
c0d02210:	4804      	ldr	r0, [pc, #16]	; (c0d02224 <io_seproxyhal_handle_usb_event+0x60>)
c0d02212:	f005 f89f 	bl	c0d07354 <USBD_LL_Suspend>
}
c0d02216:	bd10      	pop	{r4, pc}
c0d02218:	2005      	movs	r0, #5
        THROW(EXCEPTION_IO_RESET);
c0d0221a:	f7ff ffbb 	bl	c0d02194 <os_longjmp>
c0d0221e:	46c0      	nop			; (mov r8, r8)
c0d02220:	20000205 	.word	0x20000205
c0d02224:	200009e0 	.word	0x200009e0
c0d02228:	200003d8 	.word	0x200003d8

c0d0222c <io_seproxyhal_get_ep_rx_size>:

uint16_t io_seproxyhal_get_ep_rx_size(uint8_t epnum) {
c0d0222c:	217f      	movs	r1, #127	; 0x7f
  if ((epnum & 0x7F) < IO_USB_MAX_ENDPOINTS) {
c0d0222e:	4001      	ands	r1, r0
c0d02230:	2903      	cmp	r1, #3
c0d02232:	d803      	bhi.n	c0d0223c <io_seproxyhal_get_ep_rx_size+0x10>
    return G_io_app.usb_ep_xfer_len[epnum&0x7F];
c0d02234:	4802      	ldr	r0, [pc, #8]	; (c0d02240 <io_seproxyhal_get_ep_rx_size+0x14>)
c0d02236:	1840      	adds	r0, r0, r1
c0d02238:	7b00      	ldrb	r0, [r0, #12]
  }
  return 0;
}
c0d0223a:	4770      	bx	lr
c0d0223c:	2000      	movs	r0, #0
c0d0223e:	4770      	bx	lr
c0d02240:	200003d8 	.word	0x200003d8

c0d02244 <io_seproxyhal_handle_usb_ep_xfer_event>:

void io_seproxyhal_handle_usb_ep_xfer_event(void) {
c0d02244:	b580      	push	{r7, lr}
  uint8_t epnum;

  epnum = G_io_seproxyhal_spi_buffer[3] & 0x7F;
c0d02246:	4815      	ldr	r0, [pc, #84]	; (c0d0229c <io_seproxyhal_handle_usb_ep_xfer_event+0x58>)
c0d02248:	78c2      	ldrb	r2, [r0, #3]
c0d0224a:	217f      	movs	r1, #127	; 0x7f
c0d0224c:	4011      	ands	r1, r2

  switch(G_io_seproxyhal_spi_buffer[4]) {
c0d0224e:	7902      	ldrb	r2, [r0, #4]
c0d02250:	2a04      	cmp	r2, #4
c0d02252:	d014      	beq.n	c0d0227e <io_seproxyhal_handle_usb_ep_xfer_event+0x3a>
c0d02254:	2a02      	cmp	r2, #2
c0d02256:	d006      	beq.n	c0d02266 <io_seproxyhal_handle_usb_ep_xfer_event+0x22>
c0d02258:	2a01      	cmp	r2, #1
c0d0225a:	d11d      	bne.n	c0d02298 <io_seproxyhal_handle_usb_ep_xfer_event+0x54>
    /* This event is received when a new SETUP token had been received on a control endpoint */
    case SEPROXYHAL_TAG_USB_EP_XFER_SETUP:
      // assume length of setup packet, and that it is on endpoint 0
      USBD_LL_SetupStage(&USBD_Device, &G_io_seproxyhal_spi_buffer[6]);
c0d0225c:	1d81      	adds	r1, r0, #6
c0d0225e:	4811      	ldr	r0, [pc, #68]	; (c0d022a4 <io_seproxyhal_handle_usb_ep_xfer_event+0x60>)
c0d02260:	f004 ff69 	bl	c0d07136 <USBD_LL_SetupStage>
        // prepare reception
        USBD_LL_DataOutStage(&USBD_Device, epnum, &G_io_seproxyhal_spi_buffer[6]);
      }
      break;
  }
}
c0d02264:	bd80      	pop	{r7, pc}
      if (epnum < IO_USB_MAX_ENDPOINTS) {
c0d02266:	2903      	cmp	r1, #3
c0d02268:	d816      	bhi.n	c0d02298 <io_seproxyhal_handle_usb_ep_xfer_event+0x54>
        G_io_app.usb_ep_timeouts[epnum].timeout = 0;
c0d0226a:	004a      	lsls	r2, r1, #1
c0d0226c:	4b0c      	ldr	r3, [pc, #48]	; (c0d022a0 <io_seproxyhal_handle_usb_ep_xfer_event+0x5c>)
c0d0226e:	189a      	adds	r2, r3, r2
c0d02270:	2300      	movs	r3, #0
c0d02272:	8213      	strh	r3, [r2, #16]
        USBD_LL_DataInStage(&USBD_Device, epnum, &G_io_seproxyhal_spi_buffer[6]);
c0d02274:	1d82      	adds	r2, r0, #6
c0d02276:	480b      	ldr	r0, [pc, #44]	; (c0d022a4 <io_seproxyhal_handle_usb_ep_xfer_event+0x60>)
c0d02278:	f004 ffdf 	bl	c0d0723a <USBD_LL_DataInStage>
}
c0d0227c:	bd80      	pop	{r7, pc}
      if (epnum < IO_USB_MAX_ENDPOINTS) {
c0d0227e:	2903      	cmp	r1, #3
c0d02280:	d80a      	bhi.n	c0d02298 <io_seproxyhal_handle_usb_ep_xfer_event+0x54>
        G_io_app.usb_ep_xfer_len[epnum] = MIN(G_io_seproxyhal_spi_buffer[5], IO_SEPROXYHAL_BUFFER_SIZE_B - 6);
c0d02282:	4a07      	ldr	r2, [pc, #28]	; (c0d022a0 <io_seproxyhal_handle_usb_ep_xfer_event+0x5c>)
c0d02284:	1852      	adds	r2, r2, r1
c0d02286:	7943      	ldrb	r3, [r0, #5]
c0d02288:	2b7a      	cmp	r3, #122	; 0x7a
c0d0228a:	d300      	bcc.n	c0d0228e <io_seproxyhal_handle_usb_ep_xfer_event+0x4a>
c0d0228c:	237a      	movs	r3, #122	; 0x7a
c0d0228e:	7313      	strb	r3, [r2, #12]
        USBD_LL_DataOutStage(&USBD_Device, epnum, &G_io_seproxyhal_spi_buffer[6]);
c0d02290:	1d82      	adds	r2, r0, #6
c0d02292:	4804      	ldr	r0, [pc, #16]	; (c0d022a4 <io_seproxyhal_handle_usb_ep_xfer_event+0x60>)
c0d02294:	f004 ff7d 	bl	c0d07192 <USBD_LL_DataOutStage>
}
c0d02298:	bd80      	pop	{r7, pc}
c0d0229a:	46c0      	nop			; (mov r8, r8)
c0d0229c:	20000205 	.word	0x20000205
c0d022a0:	200003d8 	.word	0x200003d8
c0d022a4:	200009e0 	.word	0x200009e0

c0d022a8 <io_usb_send_ep>:
#endif // HAVE_L4_USBLIB

// TODO, refactor this using the USB DataIn event like for the U2F tunnel
// TODO add a blocking parameter, for HID KBD sending, or use a USB busy flag per channel to know if 
// the transfer has been processed or not. and move on to the next transfer on the same endpoint
void io_usb_send_ep(unsigned int ep, unsigned char* buffer, unsigned short length, unsigned int timeout) {
c0d022a8:	b570      	push	{r4, r5, r6, lr}
  if (timeout) {
    timeout++;
  }

  // won't send if overflowing seproxyhal buffer format
  if (length > 255) {
c0d022aa:	2aff      	cmp	r2, #255	; 0xff
c0d022ac:	d81d      	bhi.n	c0d022ea <io_usb_send_ep+0x42>
c0d022ae:	4615      	mov	r5, r2
c0d022b0:	460e      	mov	r6, r1
c0d022b2:	4604      	mov	r4, r0
    return;
  }
  
  G_io_seproxyhal_spi_buffer[0] = SEPROXYHAL_TAG_USB_EP_PREPARE;
c0d022b4:	480d      	ldr	r0, [pc, #52]	; (c0d022ec <io_usb_send_ep+0x44>)
  G_io_seproxyhal_spi_buffer[1] = (3+length)>>8;
  G_io_seproxyhal_spi_buffer[2] = (3+length);
  G_io_seproxyhal_spi_buffer[3] = ep|0x80;
  G_io_seproxyhal_spi_buffer[4] = SEPROXYHAL_TAG_USB_EP_PREPARE_DIR_IN;
  G_io_seproxyhal_spi_buffer[5] = length;
c0d022b6:	7142      	strb	r2, [r0, #5]
c0d022b8:	2120      	movs	r1, #32
  G_io_seproxyhal_spi_buffer[4] = SEPROXYHAL_TAG_USB_EP_PREPARE_DIR_IN;
c0d022ba:	7101      	strb	r1, [r0, #4]
c0d022bc:	2150      	movs	r1, #80	; 0x50
  G_io_seproxyhal_spi_buffer[0] = SEPROXYHAL_TAG_USB_EP_PREPARE;
c0d022be:	7001      	strb	r1, [r0, #0]
c0d022c0:	2180      	movs	r1, #128	; 0x80
  G_io_seproxyhal_spi_buffer[3] = ep|0x80;
c0d022c2:	4321      	orrs	r1, r4
c0d022c4:	70c1      	strb	r1, [r0, #3]
  G_io_seproxyhal_spi_buffer[1] = (3+length)>>8;
c0d022c6:	1cd1      	adds	r1, r2, #3
  G_io_seproxyhal_spi_buffer[2] = (3+length);
c0d022c8:	7081      	strb	r1, [r0, #2]
  G_io_seproxyhal_spi_buffer[1] = (3+length)>>8;
c0d022ca:	0a09      	lsrs	r1, r1, #8
c0d022cc:	7041      	strb	r1, [r0, #1]
c0d022ce:	2106      	movs	r1, #6
  io_seproxyhal_spi_send(G_io_seproxyhal_spi_buffer, 6);
c0d022d0:	f003 f978 	bl	c0d055c4 <io_seph_send>
  io_seproxyhal_spi_send(buffer, length);
c0d022d4:	4630      	mov	r0, r6
c0d022d6:	4629      	mov	r1, r5
c0d022d8:	f003 f974 	bl	c0d055c4 <io_seph_send>
  // setup timeout of the endpoint
  G_io_app.usb_ep_timeouts[ep&0x7F].timeout = IO_RAPDU_TRANSMIT_TIMEOUT_MS;
c0d022dc:	0660      	lsls	r0, r4, #25
c0d022de:	0e00      	lsrs	r0, r0, #24
c0d022e0:	4903      	ldr	r1, [pc, #12]	; (c0d022f0 <io_usb_send_ep+0x48>)
c0d022e2:	1808      	adds	r0, r1, r0
c0d022e4:	217d      	movs	r1, #125	; 0x7d
c0d022e6:	0109      	lsls	r1, r1, #4
c0d022e8:	8201      	strh	r1, [r0, #16]
}
c0d022ea:	bd70      	pop	{r4, r5, r6, pc}
c0d022ec:	20000205 	.word	0x20000205
c0d022f0:	200003d8 	.word	0x200003d8

c0d022f4 <io_usb_send_apdu_data>:

void io_usb_send_apdu_data(unsigned char* buffer, unsigned short length) {
c0d022f4:	b580      	push	{r7, lr}
c0d022f6:	460a      	mov	r2, r1
c0d022f8:	4601      	mov	r1, r0
c0d022fa:	2082      	movs	r0, #130	; 0x82
c0d022fc:	2314      	movs	r3, #20
  // wait for 20 events before hanging up and timeout (~2 seconds of timeout)
  io_usb_send_ep(0x82, buffer, length, 20);
c0d022fe:	f7ff ffd3 	bl	c0d022a8 <io_usb_send_ep>
}
c0d02302:	bd80      	pop	{r7, pc}

c0d02304 <io_usb_send_apdu_data_ep0x83>:

#ifdef HAVE_WEBUSB
void io_usb_send_apdu_data_ep0x83(unsigned char* buffer, unsigned short length) {
c0d02304:	b580      	push	{r7, lr}
c0d02306:	460a      	mov	r2, r1
c0d02308:	4601      	mov	r1, r0
c0d0230a:	2083      	movs	r0, #131	; 0x83
c0d0230c:	2314      	movs	r3, #20
  // wait for 20 events before hanging up and timeout (~2 seconds of timeout)
  io_usb_send_ep(0x83, buffer, length, 20);
c0d0230e:	f7ff ffcb 	bl	c0d022a8 <io_usb_send_ep>
}
c0d02312:	bd80      	pop	{r7, pc}

c0d02314 <io_seproxyhal_handle_event>:
    // copy apdu to apdu buffer
    memcpy(G_io_apdu_buffer, G_io_seproxyhal_spi_buffer+3, G_io_app.apdu_length);
  }
}

unsigned int io_seproxyhal_handle_event(void) {
c0d02314:	b510      	push	{r4, lr}
  return (buf[off] << 8) | buf[off + 1];
c0d02316:	4826      	ldr	r0, [pc, #152]	; (c0d023b0 <io_seproxyhal_handle_event+0x9c>)
c0d02318:	7881      	ldrb	r1, [r0, #2]
c0d0231a:	7842      	ldrb	r2, [r0, #1]
c0d0231c:	0212      	lsls	r2, r2, #8
c0d0231e:	1852      	adds	r2, r2, r1
#ifdef HAVE_BLE
  // continue sending the ble db saved if any
  io_seproxyhal_ble_pairing_db_to_mcu(NULL, 0, BOLOS_FALSE);
#endif // HAVE_BLE

  switch(G_io_seproxyhal_spi_buffer[0]) {
c0d02320:	7801      	ldrb	r1, [r0, #0]
c0d02322:	290f      	cmp	r1, #15
c0d02324:	dc08      	bgt.n	c0d02338 <io_seproxyhal_handle_event+0x24>
c0d02326:	290e      	cmp	r1, #14
c0d02328:	d01c      	beq.n	c0d02364 <io_seproxyhal_handle_event+0x50>
c0d0232a:	290f      	cmp	r1, #15
c0d0232c:	d12d      	bne.n	c0d0238a <io_seproxyhal_handle_event+0x76>
  #ifdef HAVE_IO_USB
    case SEPROXYHAL_TAG_USB_EVENT:
      if (rx_len != 1) {
c0d0232e:	2a01      	cmp	r2, #1
c0d02330:	d132      	bne.n	c0d02398 <io_seproxyhal_handle_event+0x84>
        return 0;
      }
      io_seproxyhal_handle_usb_event();
c0d02332:	f7ff ff47 	bl	c0d021c4 <io_seproxyhal_handle_usb_event>
c0d02336:	e033      	b.n	c0d023a0 <io_seproxyhal_handle_event+0x8c>
  switch(G_io_seproxyhal_spi_buffer[0]) {
c0d02338:	2910      	cmp	r1, #16
c0d0233a:	d02b      	beq.n	c0d02394 <io_seproxyhal_handle_event+0x80>
c0d0233c:	2916      	cmp	r1, #22
c0d0233e:	d124      	bne.n	c0d0238a <io_seproxyhal_handle_event+0x76>
  if (G_io_app.apdu_state == APDU_IDLE) {
c0d02340:	491c      	ldr	r1, [pc, #112]	; (c0d023b4 <io_seproxyhal_handle_event+0xa0>)
c0d02342:	780b      	ldrb	r3, [r1, #0]
c0d02344:	2401      	movs	r4, #1
c0d02346:	2b00      	cmp	r3, #0
c0d02348:	d12b      	bne.n	c0d023a2 <io_seproxyhal_handle_event+0x8e>
c0d0234a:	230a      	movs	r3, #10
    G_io_app.apdu_state = APDU_RAW; // for next call to io_exchange
c0d0234c:	700b      	strb	r3, [r1, #0]
c0d0234e:	2306      	movs	r3, #6
    G_io_app.apdu_media = IO_APDU_MEDIA_RAW; // for application code
c0d02350:	718b      	strb	r3, [r1, #6]
    G_io_app.apdu_length = MIN(size, max);
c0d02352:	2a7d      	cmp	r2, #125	; 0x7d
c0d02354:	d300      	bcc.n	c0d02358 <io_seproxyhal_handle_event+0x44>
c0d02356:	227d      	movs	r2, #125	; 0x7d
c0d02358:	804a      	strh	r2, [r1, #2]
    memcpy(G_io_apdu_buffer, G_io_seproxyhal_spi_buffer+3, G_io_app.apdu_length);
c0d0235a:	1cc1      	adds	r1, r0, #3
c0d0235c:	4816      	ldr	r0, [pc, #88]	; (c0d023b8 <io_seproxyhal_handle_event+0xa4>)
c0d0235e:	f006 f8da 	bl	c0d08516 <__aeabi_memcpy>
c0d02362:	e01e      	b.n	c0d023a2 <io_seproxyhal_handle_event+0x8e>
      return 1;

      // ask the user if not processed here
    case SEPROXYHAL_TAG_TICKER_EVENT:
      // process ticker events to timeout the IO transfers, and forward to the user io_event function too
      G_io_app.ms += 100; // value is by default, don't change the ticker configuration
c0d02364:	4813      	ldr	r0, [pc, #76]	; (c0d023b4 <io_seproxyhal_handle_event+0xa0>)
c0d02366:	6881      	ldr	r1, [r0, #8]
c0d02368:	3164      	adds	r1, #100	; 0x64
c0d0236a:	6081      	str	r1, [r0, #8]
c0d0236c:	2116      	movs	r1, #22
#ifdef HAVE_IO_USB
      {
        unsigned int i = IO_USB_MAX_ENDPOINTS;
        while(i--) {
          if (G_io_app.usb_ep_timeouts[i].timeout) {
c0d0236e:	5a42      	ldrh	r2, [r0, r1]
c0d02370:	2a00      	cmp	r2, #0
c0d02372:	d007      	beq.n	c0d02384 <io_seproxyhal_handle_event+0x70>
            G_io_app.usb_ep_timeouts[i].timeout-=MIN(G_io_app.usb_ep_timeouts[i].timeout, 100);
c0d02374:	2a64      	cmp	r2, #100	; 0x64
c0d02376:	4613      	mov	r3, r2
c0d02378:	d800      	bhi.n	c0d0237c <io_seproxyhal_handle_event+0x68>
c0d0237a:	2364      	movs	r3, #100	; 0x64
c0d0237c:	3b64      	subs	r3, #100	; 0x64
c0d0237e:	5243      	strh	r3, [r0, r1]
            if (!G_io_app.usb_ep_timeouts[i].timeout) {
c0d02380:	2a64      	cmp	r2, #100	; 0x64
c0d02382:	d910      	bls.n	c0d023a6 <io_seproxyhal_handle_event+0x92>
        while(i--) {
c0d02384:	1e89      	subs	r1, r1, #2
c0d02386:	290e      	cmp	r1, #14
c0d02388:	d1f1      	bne.n	c0d0236e <io_seproxyhal_handle_event+0x5a>
c0d0238a:	2002      	movs	r0, #2
      }
#endif // HAVE_BLE_APDU
      __attribute__((fallthrough));     
      // no break is intentional
    default:
      return io_event(CHANNEL_SPI);
c0d0238c:	f7fe ff2c 	bl	c0d011e8 <io_event>
c0d02390:	4604      	mov	r4, r0
c0d02392:	e006      	b.n	c0d023a2 <io_seproxyhal_handle_event+0x8e>
      if (rx_len < 3) {
c0d02394:	2a03      	cmp	r2, #3
c0d02396:	d201      	bcs.n	c0d0239c <io_seproxyhal_handle_event+0x88>
c0d02398:	2400      	movs	r4, #0
c0d0239a:	e002      	b.n	c0d023a2 <io_seproxyhal_handle_event+0x8e>
      io_seproxyhal_handle_usb_ep_xfer_event();
c0d0239c:	f7ff ff52 	bl	c0d02244 <io_seproxyhal_handle_usb_ep_xfer_event>
c0d023a0:	2401      	movs	r4, #1
  }
  // defaultly return as not processed
  return 0;
}
c0d023a2:	4620      	mov	r0, r4
c0d023a4:	bd10      	pop	{r4, pc}
c0d023a6:	2100      	movs	r1, #0
              G_io_app.apdu_state = APDU_IDLE;
c0d023a8:	7001      	strb	r1, [r0, #0]
c0d023aa:	2005      	movs	r0, #5
              THROW(EXCEPTION_IO_RESET);
c0d023ac:	f7ff fef2 	bl	c0d02194 <os_longjmp>
c0d023b0:	20000205 	.word	0x20000205
c0d023b4:	200003d8 	.word	0x200003d8
c0d023b8:	20000285 	.word	0x20000285

c0d023bc <io_seproxyhal_init>:
  1,
  SEPROXYHAL_TAG_MCU_TYPE_PROTECT,
};
#endif // (!defined(HAVE_BOLOS) && defined(HAVE_MCU_PROTECT))

void io_seproxyhal_init(void) {
c0d023bc:	b580      	push	{r7, lr}
// get API level
SYSCALL unsigned int get_api_level(void);

#ifndef HAVE_BOLOS
static inline void check_api_level(unsigned int apiLevel) {
  if (apiLevel < get_api_level()) {
c0d023be:	f003 f86f 	bl	c0d054a0 <get_api_level>
c0d023c2:	280d      	cmp	r0, #13
c0d023c4:	d302      	bcc.n	c0d023cc <io_seproxyhal_init+0x10>
c0d023c6:	20ff      	movs	r0, #255	; 0xff
    os_sched_exit(-1);
c0d023c8:	f003 f8ee 	bl	c0d055a8 <os_sched_exit>
  io_seproxyhal_spi_send(seph_io_mcu_protect, sizeof(seph_io_mcu_protect));
#endif // HAVE_MCU_PROTECT
#endif // HAVE_BOLOS

#ifdef HAVE_BOLOS_APP_STACK_CANARY
  app_stack_canary = APP_STACK_CANARY_MAGIC;
c0d023cc:	4806      	ldr	r0, [pc, #24]	; (c0d023e8 <io_seproxyhal_init+0x2c>)
c0d023ce:	4907      	ldr	r1, [pc, #28]	; (c0d023ec <io_seproxyhal_init+0x30>)
c0d023d0:	6001      	str	r1, [r0, #0]
  memset(&G_io_app, 0, sizeof(G_io_app));
#ifdef TARGET_NANOX
  G_io_app.plane_mode = plane;
#endif // TARGET_NANOX

  G_io_app.apdu_state = APDU_IDLE;
c0d023d2:	4807      	ldr	r0, [pc, #28]	; (c0d023f0 <io_seproxyhal_init+0x34>)
c0d023d4:	2118      	movs	r1, #24
c0d023d6:	f006 f899 	bl	c0d0850c <__aeabi_memclr>
  #ifdef DEBUG_APDU
  debug_apdus_offset = 0;
  #endif // DEBUG_APDU

  #ifdef HAVE_USB_APDU
  io_usb_hid_init();
c0d023da:	f000 fb83 	bl	c0d02ae4 <io_usb_hid_init>
// #endif // TARGET_NANOX
}

void io_seproxyhal_init_button(void) {
  // no button push so far
  G_ux_os.button_mask = 0;
c0d023de:	4805      	ldr	r0, [pc, #20]	; (c0d023f4 <io_seproxyhal_init+0x38>)
c0d023e0:	2100      	movs	r1, #0
c0d023e2:	6001      	str	r1, [r0, #0]
  G_ux_os.button_same_mask_counter = 0;
c0d023e4:	6041      	str	r1, [r0, #4]
}
c0d023e6:	bd80      	pop	{r7, pc}
c0d023e8:	20000ac8 	.word	0x20000ac8
c0d023ec:	dead0031 	.word	0xdead0031
c0d023f0:	200003d8 	.word	0x200003d8
c0d023f4:	200003f0 	.word	0x200003f0

c0d023f8 <io_seproxyhal_init_ux>:
}
c0d023f8:	4770      	bx	lr
	...

c0d023fc <io_seproxyhal_init_button>:
  G_ux_os.button_mask = 0;
c0d023fc:	4802      	ldr	r0, [pc, #8]	; (c0d02408 <io_seproxyhal_init_button+0xc>)
c0d023fe:	2100      	movs	r1, #0
c0d02400:	6001      	str	r1, [r0, #0]
  G_ux_os.button_same_mask_counter = 0;
c0d02402:	6041      	str	r1, [r0, #4]
}
c0d02404:	4770      	bx	lr
c0d02406:	46c0      	nop			; (mov r8, r8)
c0d02408:	200003f0 	.word	0x200003f0

c0d0240c <io_seproxyhal_display_icon>:
    }
  }
}

#else // TARGET_NANOX
void io_seproxyhal_display_icon(bagl_component_t* icon_component, bagl_icon_details_t* icon_det) {
c0d0240c:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0240e:	b089      	sub	sp, #36	; 0x24
c0d02410:	4605      	mov	r5, r0
  bagl_component_t icon_component_mod;
  const bagl_icon_details_t* icon_details = (bagl_icon_details_t*)PIC(icon_det);
c0d02412:	4608      	mov	r0, r1
c0d02414:	f000 ff88 	bl	c0d03328 <pic>
  if (icon_details && icon_details->bitmap) {
c0d02418:	2800      	cmp	r0, #0
c0d0241a:	d03f      	beq.n	c0d0249c <io_seproxyhal_display_icon+0x90>
c0d0241c:	4604      	mov	r4, r0
c0d0241e:	6900      	ldr	r0, [r0, #16]
c0d02420:	2800      	cmp	r0, #0
c0d02422:	d03b      	beq.n	c0d0249c <io_seproxyhal_display_icon+0x90>
    // ensure not being out of bounds in the icon component agianst the declared icon real size
    memcpy(&icon_component_mod, (void *)PIC(icon_component), sizeof(bagl_component_t));
c0d02424:	4628      	mov	r0, r5
c0d02426:	f000 ff7f 	bl	c0d03328 <pic>
c0d0242a:	4601      	mov	r1, r0
c0d0242c:	ad02      	add	r5, sp, #8
c0d0242e:	221c      	movs	r2, #28
c0d02430:	4628      	mov	r0, r5
c0d02432:	9201      	str	r2, [sp, #4]
c0d02434:	f006 f86f 	bl	c0d08516 <__aeabi_memcpy>
    icon_component_mod.width = icon_details->width;
c0d02438:	6822      	ldr	r2, [r4, #0]
    unsigned int w = ((icon_component->width*icon_component->height*icon_details->bpp)/8)+((icon_component->width*icon_component->height*icon_details->bpp)%8?1:0);
    unsigned short length = sizeof(bagl_component_t)
                            +1 /* bpp */
                            +h /* color index */
                            +w; /* image bitmap size */
    G_io_seproxyhal_spi_buffer[0] = SEPROXYHAL_TAG_SCREEN_DISPLAY_STATUS;
c0d0243a:	4819      	ldr	r0, [pc, #100]	; (c0d024a0 <io_seproxyhal_display_icon+0x94>)
c0d0243c:	2165      	movs	r1, #101	; 0x65
c0d0243e:	7001      	strb	r1, [r0, #0]
    icon_component_mod.width = icon_details->width;
c0d02440:	80ea      	strh	r2, [r5, #6]
    icon_component_mod.height = icon_details->height;
c0d02442:	6861      	ldr	r1, [r4, #4]
c0d02444:	8129      	strh	r1, [r5, #8]
    icon_component_mod.width = icon_details->width;
c0d02446:	b292      	uxth	r2, r2
    icon_component_mod.height = icon_details->height;
c0d02448:	b289      	uxth	r1, r1
    unsigned int w = ((icon_component->width*icon_component->height*icon_details->bpp)/8)+((icon_component->width*icon_component->height*icon_details->bpp)%8?1:0);
c0d0244a:	4351      	muls	r1, r2
    unsigned int h = (1<<(icon_details->bpp))*sizeof(unsigned int); 
c0d0244c:	68a3      	ldr	r3, [r4, #8]
    unsigned int w = ((icon_component->width*icon_component->height*icon_details->bpp)/8)+((icon_component->width*icon_component->height*icon_details->bpp)%8?1:0);
c0d0244e:	4359      	muls	r1, r3
c0d02450:	074a      	lsls	r2, r1, #29
c0d02452:	08ce      	lsrs	r6, r1, #3
c0d02454:	2a00      	cmp	r2, #0
c0d02456:	d000      	beq.n	c0d0245a <io_seproxyhal_display_icon+0x4e>
c0d02458:	1c76      	adds	r6, r6, #1
c0d0245a:	2704      	movs	r7, #4
    unsigned int h = (1<<(icon_details->bpp))*sizeof(unsigned int); 
c0d0245c:	409f      	lsls	r7, r3
                            +h /* color index */
c0d0245e:	19b9      	adds	r1, r7, r6
                            +w; /* image bitmap size */
c0d02460:	311d      	adds	r1, #29
    G_io_seproxyhal_spi_buffer[1] = length>>8;
    G_io_seproxyhal_spi_buffer[2] = length;
c0d02462:	7081      	strb	r1, [r0, #2]
    G_io_seproxyhal_spi_buffer[1] = length>>8;
c0d02464:	0a09      	lsrs	r1, r1, #8
c0d02466:	7041      	strb	r1, [r0, #1]
c0d02468:	2103      	movs	r1, #3
    io_seproxyhal_spi_send(G_io_seproxyhal_spi_buffer, 3);
c0d0246a:	f003 f8ab 	bl	c0d055c4 <io_seph_send>
    io_seproxyhal_spi_send((unsigned char*)icon_component, sizeof(bagl_component_t));
c0d0246e:	4628      	mov	r0, r5
c0d02470:	9901      	ldr	r1, [sp, #4]
c0d02472:	f003 f8a7 	bl	c0d055c4 <io_seph_send>
    G_io_seproxyhal_spi_buffer[0] = icon_details->bpp;
c0d02476:	68a1      	ldr	r1, [r4, #8]
c0d02478:	4809      	ldr	r0, [pc, #36]	; (c0d024a0 <io_seproxyhal_display_icon+0x94>)
c0d0247a:	7001      	strb	r1, [r0, #0]
c0d0247c:	2101      	movs	r1, #1
    io_seproxyhal_spi_send(G_io_seproxyhal_spi_buffer, 1);
c0d0247e:	f003 f8a1 	bl	c0d055c4 <io_seph_send>
    io_seproxyhal_spi_send((unsigned char*)PIC(icon_details->colors), h);
c0d02482:	68e0      	ldr	r0, [r4, #12]
c0d02484:	f000 ff50 	bl	c0d03328 <pic>
c0d02488:	b2b9      	uxth	r1, r7
c0d0248a:	f003 f89b 	bl	c0d055c4 <io_seph_send>
    io_seproxyhal_spi_send((unsigned char*)PIC(icon_details->bitmap), w);
c0d0248e:	b2b5      	uxth	r5, r6
c0d02490:	6920      	ldr	r0, [r4, #16]
c0d02492:	f000 ff49 	bl	c0d03328 <pic>
c0d02496:	4629      	mov	r1, r5
c0d02498:	f003 f894 	bl	c0d055c4 <io_seph_send>
  #endif // !SEPROXYHAL_TAG_SCREEN_DISPLAY_RAW_STATUS
  }
}
c0d0249c:	b009      	add	sp, #36	; 0x24
c0d0249e:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d024a0:	20000205 	.word	0x20000205

c0d024a4 <io_seproxyhal_display_default>:

void io_seproxyhal_display_default(const bagl_element_t * el) {
c0d024a4:	b570      	push	{r4, r5, r6, lr}

  const bagl_element_t* element = (const bagl_element_t*) PIC(el);
c0d024a6:	f000 ff3f 	bl	c0d03328 <pic>
c0d024aa:	4604      	mov	r4, r0

  // process automagically address from rom and from ram
  unsigned int type = (element->component.type & ~(BAGL_FLAG_TOUCHABLE));
c0d024ac:	7806      	ldrb	r6, [r0, #0]

  // avoid sending another status :), fixes a lot of bugs in the end
  if (io_seproxyhal_spi_is_status_sent()) {
c0d024ae:	f003 f895 	bl	c0d055dc <io_seph_is_status_sent>
c0d024b2:	2800      	cmp	r0, #0
c0d024b4:	d131      	bne.n	c0d0251a <io_seproxyhal_display_default+0x76>
c0d024b6:	207f      	movs	r0, #127	; 0x7f
c0d024b8:	4006      	ands	r6, r0
c0d024ba:	d02e      	beq.n	c0d0251a <io_seproxyhal_display_default+0x76>
    return;
  }

  if (type != BAGL_NONE) {
    if (element->text != NULL) {
c0d024bc:	69e0      	ldr	r0, [r4, #28]
c0d024be:	2800      	cmp	r0, #0
c0d024c0:	d01d      	beq.n	c0d024fe <io_seproxyhal_display_default+0x5a>
      unsigned int text_adr = (unsigned int)PIC((unsigned int)element->text);
c0d024c2:	f000 ff31 	bl	c0d03328 <pic>
c0d024c6:	4605      	mov	r5, r0
      // consider an icon details descriptor is pointed by the context
      if (type == BAGL_ICON && element->component.icon_id == 0) {
c0d024c8:	2e05      	cmp	r6, #5
c0d024ca:	d102      	bne.n	c0d024d2 <io_seproxyhal_display_default+0x2e>
c0d024cc:	7ea0      	ldrb	r0, [r4, #26]
c0d024ce:	2800      	cmp	r0, #0
c0d024d0:	d024      	beq.n	c0d0251c <io_seproxyhal_display_default+0x78>
        io_seproxyhal_display_icon((bagl_component_t*)&element->component, (bagl_icon_details_t*)text_adr);
      }
      else {
        unsigned short length = sizeof(bagl_component_t)+strlen((const char*)text_adr);
c0d024d2:	4628      	mov	r0, r5
c0d024d4:	f006 f888 	bl	c0d085e8 <strlen>
c0d024d8:	4606      	mov	r6, r0
        G_io_seproxyhal_spi_buffer[0] = SEPROXYHAL_TAG_SCREEN_DISPLAY_STATUS;
c0d024da:	4813      	ldr	r0, [pc, #76]	; (c0d02528 <io_seproxyhal_display_default+0x84>)
c0d024dc:	2165      	movs	r1, #101	; 0x65
c0d024de:	7001      	strb	r1, [r0, #0]
        unsigned short length = sizeof(bagl_component_t)+strlen((const char*)text_adr);
c0d024e0:	4631      	mov	r1, r6
c0d024e2:	311c      	adds	r1, #28
        G_io_seproxyhal_spi_buffer[1] = length>>8;
        G_io_seproxyhal_spi_buffer[2] = length;
c0d024e4:	7081      	strb	r1, [r0, #2]
        G_io_seproxyhal_spi_buffer[1] = length>>8;
c0d024e6:	0a09      	lsrs	r1, r1, #8
c0d024e8:	7041      	strb	r1, [r0, #1]
c0d024ea:	2103      	movs	r1, #3
        io_seproxyhal_spi_send(G_io_seproxyhal_spi_buffer, 3);
c0d024ec:	f003 f86a 	bl	c0d055c4 <io_seph_send>
c0d024f0:	211c      	movs	r1, #28
        io_seproxyhal_spi_send((unsigned char*)&element->component, sizeof(bagl_component_t));
c0d024f2:	4620      	mov	r0, r4
c0d024f4:	f003 f866 	bl	c0d055c4 <io_seph_send>
        io_seproxyhal_spi_send((unsigned char*)text_adr, length-sizeof(bagl_component_t));
c0d024f8:	b2b1      	uxth	r1, r6
c0d024fa:	4628      	mov	r0, r5
c0d024fc:	e00b      	b.n	c0d02516 <io_seproxyhal_display_default+0x72>
      }
    }
    else {
      unsigned short length = sizeof(bagl_component_t);
      G_io_seproxyhal_spi_buffer[0] = SEPROXYHAL_TAG_SCREEN_DISPLAY_STATUS;
c0d024fe:	480a      	ldr	r0, [pc, #40]	; (c0d02528 <io_seproxyhal_display_default+0x84>)
c0d02500:	251c      	movs	r5, #28
      G_io_seproxyhal_spi_buffer[1] = length>>8;
      G_io_seproxyhal_spi_buffer[2] = length;
c0d02502:	7085      	strb	r5, [r0, #2]
c0d02504:	2100      	movs	r1, #0
      G_io_seproxyhal_spi_buffer[1] = length>>8;
c0d02506:	7041      	strb	r1, [r0, #1]
c0d02508:	2165      	movs	r1, #101	; 0x65
      G_io_seproxyhal_spi_buffer[0] = SEPROXYHAL_TAG_SCREEN_DISPLAY_STATUS;
c0d0250a:	7001      	strb	r1, [r0, #0]
c0d0250c:	2103      	movs	r1, #3
      io_seproxyhal_spi_send(G_io_seproxyhal_spi_buffer, 3);
c0d0250e:	f003 f859 	bl	c0d055c4 <io_seph_send>
      io_seproxyhal_spi_send((unsigned char*)&element->component, sizeof(bagl_component_t));
c0d02512:	4620      	mov	r0, r4
c0d02514:	4629      	mov	r1, r5
c0d02516:	f003 f855 	bl	c0d055c4 <io_seph_send>
    }
  }
}
c0d0251a:	bd70      	pop	{r4, r5, r6, pc}
        io_seproxyhal_display_icon((bagl_component_t*)&element->component, (bagl_icon_details_t*)text_adr);
c0d0251c:	4620      	mov	r0, r4
c0d0251e:	4629      	mov	r1, r5
c0d02520:	f7ff ff74 	bl	c0d0240c <io_seproxyhal_display_icon>
}
c0d02524:	bd70      	pop	{r4, r5, r6, pc}
c0d02526:	46c0      	nop			; (mov r8, r8)
c0d02528:	20000205 	.word	0x20000205

c0d0252c <io_seproxyhal_button_push>:
  
  // compute scrolled text length
  return 2*(textlen - e->component.width)*1000/e->component.icon_id + 2*(e->component.stroke & ~(0x80))*100;
}

void io_seproxyhal_button_push(button_push_callback_t button_callback, unsigned int new_button_mask) {
c0d0252c:	b570      	push	{r4, r5, r6, lr}
  if (button_callback) {
c0d0252e:	2800      	cmp	r0, #0
c0d02530:	d025      	beq.n	c0d0257e <io_seproxyhal_button_push+0x52>
c0d02532:	460b      	mov	r3, r1
c0d02534:	4602      	mov	r2, r0
    unsigned int button_mask;
    unsigned int button_same_mask_counter;
    // enable speeded up long push
    if (new_button_mask == G_ux_os.button_mask) {
c0d02536:	4c12      	ldr	r4, [pc, #72]	; (c0d02580 <io_seproxyhal_button_push+0x54>)
c0d02538:	cc03      	ldmia	r4!, {r0, r1}
c0d0253a:	3c08      	subs	r4, #8
c0d0253c:	4298      	cmp	r0, r3
c0d0253e:	d101      	bne.n	c0d02544 <io_seproxyhal_button_push+0x18>
      // each 100ms ~
      G_ux_os.button_same_mask_counter++;
c0d02540:	1c49      	adds	r1, r1, #1
c0d02542:	6061      	str	r1, [r4, #4]
    }

    // when new_button_mask is 0 and 

    // append the button mask
    button_mask = G_ux_os.button_mask | new_button_mask;
c0d02544:	4318      	orrs	r0, r3

    // pre reset variable due to os_sched_exit
    button_same_mask_counter = G_ux_os.button_same_mask_counter;

    // reset button mask
    if (new_button_mask == 0) {
c0d02546:	2b00      	cmp	r3, #0
c0d02548:	d002      	beq.n	c0d02550 <io_seproxyhal_button_push+0x24>

      // notify button released event
      button_mask |= BUTTON_EVT_RELEASED;
    }
    else {
      G_ux_os.button_mask = button_mask;
c0d0254a:	6020      	str	r0, [r4, #0]
    }

    // reset counter when button mask changes
    if (new_button_mask != G_ux_os.button_mask) {
c0d0254c:	4605      	mov	r5, r0
c0d0254e:	e005      	b.n	c0d0255c <io_seproxyhal_button_push+0x30>
c0d02550:	2500      	movs	r5, #0
      G_ux_os.button_mask = 0;
c0d02552:	6025      	str	r5, [r4, #0]
      G_ux_os.button_same_mask_counter=0;
c0d02554:	6065      	str	r5, [r4, #4]
c0d02556:	4e0b      	ldr	r6, [pc, #44]	; (c0d02584 <io_seproxyhal_button_push+0x58>)
      button_mask |= BUTTON_EVT_RELEASED;
c0d02558:	1c76      	adds	r6, r6, #1
c0d0255a:	4330      	orrs	r0, r6
    if (new_button_mask != G_ux_os.button_mask) {
c0d0255c:	429d      	cmp	r5, r3
c0d0255e:	d001      	beq.n	c0d02564 <io_seproxyhal_button_push+0x38>
c0d02560:	2300      	movs	r3, #0
      G_ux_os.button_same_mask_counter=0;
c0d02562:	6063      	str	r3, [r4, #4]
    }

    if (button_same_mask_counter >= BUTTON_FAST_THRESHOLD_CS) {
c0d02564:	2908      	cmp	r1, #8
c0d02566:	d309      	bcc.n	c0d0257c <io_seproxyhal_button_push+0x50>
c0d02568:	4c07      	ldr	r4, [pc, #28]	; (c0d02588 <io_seproxyhal_button_push+0x5c>)
      // fast bit when pressing and timing is right
      if ((button_same_mask_counter%BUTTON_FAST_ACTION_CS) == 0) {
c0d0256a:	434c      	muls	r4, r1
c0d0256c:	2301      	movs	r3, #1
c0d0256e:	4d07      	ldr	r5, [pc, #28]	; (c0d0258c <io_seproxyhal_button_push+0x60>)
c0d02570:	42ac      	cmp	r4, r5
c0d02572:	d201      	bcs.n	c0d02578 <io_seproxyhal_button_push+0x4c>
c0d02574:	079c      	lsls	r4, r3, #30
c0d02576:	4320      	orrs	r0, r4
c0d02578:	07db      	lsls	r3, r3, #31
      }
      */

      // discard the release event after a fastskip has been detected, to avoid strange at release behavior
      // and also to enable user to cancel an operation by starting triggering the fast skip
      button_mask &= ~BUTTON_EVT_RELEASED;
c0d0257a:	4398      	bics	r0, r3
    }

    // indicate if button have been released
    button_callback(button_mask, button_same_mask_counter);
c0d0257c:	4790      	blx	r2

  }
}
c0d0257e:	bd70      	pop	{r4, r5, r6, pc}
c0d02580:	200003f0 	.word	0x200003f0
c0d02584:	7fffffff 	.word	0x7fffffff
c0d02588:	aaaaaaab 	.word	0xaaaaaaab
c0d0258c:	55555556 	.word	0x55555556

c0d02590 <io_seproxyhal_se_reset>:
  SEPROXYHAL_TAG_SE_POWER_OFF,
  0,
  0,
};
void io_seproxyhal_se_reset(void) {
  io_seproxyhal_spi_send(seph_io_se_reset, sizeof(seph_io_se_reset));
c0d02590:	4802      	ldr	r0, [pc, #8]	; (c0d0259c <io_seproxyhal_se_reset+0xc>)
c0d02592:	4478      	add	r0, pc
c0d02594:	2103      	movs	r1, #3
c0d02596:	f003 f815 	bl	c0d055c4 <io_seph_send>
  for(;;);
c0d0259a:	e7fe      	b.n	c0d0259a <io_seproxyhal_se_reset+0xa>
c0d0259c:	00006db1 	.word	0x00006db1

c0d025a0 <os_io_seproxyhal_get_app_name_and_version>:
#ifdef HAVE_IO_U2F
u2f_service_t G_io_u2f;
#endif // HAVE_IO_U2F

unsigned int os_io_seproxyhal_get_app_name_and_version(void) __attribute__((weak));
unsigned int os_io_seproxyhal_get_app_name_and_version(void) {
c0d025a0:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d025a2:	b081      	sub	sp, #4
  unsigned int tx_len, len;
  // build the get app name and version reply
  tx_len = 0;
  G_io_apdu_buffer[tx_len++] = 1; // format ID
c0d025a4:	4e0f      	ldr	r6, [pc, #60]	; (c0d025e4 <os_io_seproxyhal_get_app_name_and_version+0x44>)
c0d025a6:	2401      	movs	r4, #1
c0d025a8:	7034      	strb	r4, [r6, #0]

#ifndef HAVE_BOLOS
  // append app name
  len = os_registry_get_current_app_tag(BOLOS_TAG_APPNAME, G_io_apdu_buffer+tx_len+1, sizeof(G_io_apdu_buffer)-tx_len-1);
c0d025aa:	1cb1      	adds	r1, r6, #2
c0d025ac:	20a7      	movs	r0, #167	; 0xa7
c0d025ae:	0047      	lsls	r7, r0, #1
c0d025b0:	1c7a      	adds	r2, r7, #1
c0d025b2:	4620      	mov	r0, r4
c0d025b4:	f002 ffec 	bl	c0d05590 <os_registry_get_current_app_tag>
c0d025b8:	4605      	mov	r5, r0
  G_io_apdu_buffer[tx_len++] = len;
c0d025ba:	7070      	strb	r0, [r6, #1]
  tx_len += len;
  // append app version
  len = os_registry_get_current_app_tag(BOLOS_TAG_APPVERSION, G_io_apdu_buffer+tx_len+1, sizeof(G_io_apdu_buffer)-tx_len-1);
c0d025bc:	1a3a      	subs	r2, r7, r0
  tx_len += len;
c0d025be:	1987      	adds	r7, r0, r6
  len = os_registry_get_current_app_tag(BOLOS_TAG_APPVERSION, G_io_apdu_buffer+tx_len+1, sizeof(G_io_apdu_buffer)-tx_len-1);
c0d025c0:	1cf9      	adds	r1, r7, #3
c0d025c2:	2002      	movs	r0, #2
c0d025c4:	f002 ffe4 	bl	c0d05590 <os_registry_get_current_app_tag>
  G_io_apdu_buffer[tx_len++] = len;
c0d025c8:	70b8      	strb	r0, [r7, #2]
c0d025ca:	182d      	adds	r5, r5, r0
  tx_len += len;
c0d025cc:	19ae      	adds	r6, r5, r6
#endif // HAVE_BOLOS

#if !defined(HAVE_IO_TASK) || !defined(HAVE_BOLOS)
  // to be fixed within io tasks
  // return OS flags to notify of platform's global state (pin lock etc)
  G_io_apdu_buffer[tx_len++] = 1; // flags length
c0d025ce:	70f4      	strb	r4, [r6, #3]
  G_io_apdu_buffer[tx_len++] = os_flags();
c0d025d0:	f002 ffc6 	bl	c0d05560 <os_flags>
c0d025d4:	2100      	movs	r1, #0
#endif // !defined(HAVE_IO_TASK) || !defined(HAVE_BOLOS)

  // status words
  G_io_apdu_buffer[tx_len++] = 0x90;
  G_io_apdu_buffer[tx_len++] = 0x00;
c0d025d6:	71b1      	strb	r1, [r6, #6]
c0d025d8:	2190      	movs	r1, #144	; 0x90
  G_io_apdu_buffer[tx_len++] = 0x90;
c0d025da:	7171      	strb	r1, [r6, #5]
  G_io_apdu_buffer[tx_len++] = os_flags();
c0d025dc:	7130      	strb	r0, [r6, #4]
  G_io_apdu_buffer[tx_len++] = 0x00;
c0d025de:	1de8      	adds	r0, r5, #7
  return tx_len;
c0d025e0:	b001      	add	sp, #4
c0d025e2:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d025e4:	20000285 	.word	0x20000285

c0d025e8 <io_exchange>:
  return processed;
}

#endif // HAVE_BOLOS_NO_DEFAULT_APDU

unsigned short io_exchange(unsigned char channel, unsigned short tx_len) {
c0d025e8:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d025ea:	b087      	sub	sp, #28
c0d025ec:	4602      	mov	r2, r0
  unsigned short rx_len;
  unsigned int timeout_ms;

#ifdef HAVE_BOLOS_APP_STACK_CANARY
  // behavior upon detected stack overflow is to reset the SE
  if (app_stack_canary != APP_STACK_CANARY_MAGIC) {
c0d025ee:	48b1      	ldr	r0, [pc, #708]	; (c0d028b4 <io_exchange+0x2cc>)
c0d025f0:	6800      	ldr	r0, [r0, #0]
c0d025f2:	4bb1      	ldr	r3, [pc, #708]	; (c0d028b8 <io_exchange+0x2d0>)
c0d025f4:	4298      	cmp	r0, r3
c0d025f6:	d000      	beq.n	c0d025fa <io_exchange+0x12>
c0d025f8:	e156      	b.n	c0d028a8 <io_exchange+0x2c0>
    }
  }
#endif // DEBUG_APDU

reply_apdu:
  switch(channel&~(IO_FLAGS)) {
c0d025fa:	0750      	lsls	r0, r2, #29
c0d025fc:	d007      	beq.n	c0d0260e <io_exchange+0x26>
c0d025fe:	4614      	mov	r4, r2
      }
    }
    break;

  default:
    return io_exchange_al(channel, tx_len);
c0d02600:	b2e0      	uxtb	r0, r4
c0d02602:	b289      	uxth	r1, r1
c0d02604:	f7ff f914 	bl	c0d01830 <io_exchange_al>
  }
}
c0d02608:	b280      	uxth	r0, r0
c0d0260a:	b007      	add	sp, #28
c0d0260c:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d0260e:	20a5      	movs	r0, #165	; 0xa5
c0d02610:	0040      	lsls	r0, r0, #1
c0d02612:	9003      	str	r0, [sp, #12]
c0d02614:	4eaa      	ldr	r6, [pc, #680]	; (c0d028c0 <io_exchange+0x2d8>)
c0d02616:	48ad      	ldr	r0, [pc, #692]	; (c0d028cc <io_exchange+0x2e4>)
c0d02618:	4478      	add	r0, pc
c0d0261a:	9002      	str	r0, [sp, #8]
c0d0261c:	4fa7      	ldr	r7, [pc, #668]	; (c0d028bc <io_exchange+0x2d4>)
c0d0261e:	4614      	mov	r4, r2
c0d02620:	2510      	movs	r5, #16
    if (tx_len && !(channel&IO_ASYNCH_REPLY)) {
c0d02622:	4015      	ands	r5, r2
c0d02624:	0408      	lsls	r0, r1, #16
c0d02626:	d100      	bne.n	c0d0262a <io_exchange+0x42>
c0d02628:	e0ba      	b.n	c0d027a0 <io_exchange+0x1b8>
c0d0262a:	2d00      	cmp	r5, #0
c0d0262c:	d000      	beq.n	c0d02630 <io_exchange+0x48>
c0d0262e:	e0b7      	b.n	c0d027a0 <io_exchange+0x1b8>
c0d02630:	9105      	str	r1, [sp, #20]
c0d02632:	9204      	str	r2, [sp, #16]
c0d02634:	9406      	str	r4, [sp, #24]
      while (io_seproxyhal_spi_is_status_sent()) {
c0d02636:	f002 ffd1 	bl	c0d055dc <io_seph_is_status_sent>
c0d0263a:	2800      	cmp	r0, #0
c0d0263c:	d008      	beq.n	c0d02650 <io_exchange+0x68>
c0d0263e:	2180      	movs	r1, #128	; 0x80
c0d02640:	2200      	movs	r2, #0
        io_seproxyhal_spi_recv(G_io_seproxyhal_spi_buffer, sizeof(G_io_seproxyhal_spi_buffer), 0);
c0d02642:	4638      	mov	r0, r7
c0d02644:	f002 ffd6 	bl	c0d055f4 <io_seph_recv>
c0d02648:	2001      	movs	r0, #1
        os_io_seph_recv_and_process(1);
c0d0264a:	f000 f94b 	bl	c0d028e4 <os_io_seph_recv_and_process>
c0d0264e:	e7f2      	b.n	c0d02636 <io_exchange+0x4e>
c0d02650:	207d      	movs	r0, #125	; 0x7d
c0d02652:	0100      	lsls	r0, r0, #4
      timeout_ms = G_io_app.ms + IO_RAPDU_TRANSMIT_TIMEOUT_MS;
c0d02654:	68b1      	ldr	r1, [r6, #8]
c0d02656:	180c      	adds	r4, r1, r0
        switch(G_io_app.apdu_state) {
c0d02658:	7830      	ldrb	r0, [r6, #0]
c0d0265a:	2809      	cmp	r0, #9
c0d0265c:	dc23      	bgt.n	c0d026a6 <io_exchange+0xbe>
c0d0265e:	2807      	cmp	r0, #7
c0d02660:	9905      	ldr	r1, [sp, #20]
c0d02662:	d02b      	beq.n	c0d026bc <io_exchange+0xd4>
c0d02664:	2809      	cmp	r0, #9
c0d02666:	d163      	bne.n	c0d02730 <io_exchange+0x148>
c0d02668:	2100      	movs	r1, #0
c0d0266a:	4896      	ldr	r0, [pc, #600]	; (c0d028c4 <io_exchange+0x2dc>)
c0d0266c:	9101      	str	r1, [sp, #4]
            u2f_message_set_autoreply_wait_user_presence(&G_io_u2f, false);
c0d0266e:	f003 fe03 	bl	c0d06278 <u2f_message_set_autoreply_wait_user_presence>
            while(!u2f_message_repliable(&G_io_u2f)) {
c0d02672:	4894      	ldr	r0, [pc, #592]	; (c0d028c4 <io_exchange+0x2dc>)
c0d02674:	f003 fb5a 	bl	c0d05d2c <u2f_message_repliable>
c0d02678:	2800      	cmp	r0, #0
c0d0267a:	d13a      	bne.n	c0d026f2 <io_exchange+0x10a>
  io_seproxyhal_spi_send(seph_io_general_status, sizeof(seph_io_general_status));
c0d0267c:	4896      	ldr	r0, [pc, #600]	; (c0d028d8 <io_exchange+0x2f0>)
c0d0267e:	4478      	add	r0, pc
c0d02680:	2105      	movs	r1, #5
c0d02682:	f002 ff9f 	bl	c0d055c4 <io_seph_send>
c0d02686:	2180      	movs	r1, #128	; 0x80
c0d02688:	2200      	movs	r2, #0
                io_seproxyhal_spi_recv(G_io_seproxyhal_spi_buffer, sizeof(G_io_seproxyhal_spi_buffer), 0);
c0d0268a:	4638      	mov	r0, r7
c0d0268c:	f002 ffb2 	bl	c0d055f4 <io_seph_recv>
                if (G_io_app.ms >= timeout_ms) {
c0d02690:	68b0      	ldr	r0, [r6, #8]
c0d02692:	42a0      	cmp	r0, r4
c0d02694:	d300      	bcc.n	c0d02698 <io_exchange+0xb0>
c0d02696:	e101      	b.n	c0d0289c <io_exchange+0x2b4>
                io_seproxyhal_handle_event();
c0d02698:	f7ff fe3c 	bl	c0d02314 <io_seproxyhal_handle_event>
              } while (io_seproxyhal_spi_is_status_sent());
c0d0269c:	f002 ff9e 	bl	c0d055dc <io_seph_is_status_sent>
c0d026a0:	2800      	cmp	r0, #0
c0d026a2:	d1f0      	bne.n	c0d02686 <io_exchange+0x9e>
c0d026a4:	e7e5      	b.n	c0d02672 <io_exchange+0x8a>
        switch(G_io_app.apdu_state) {
c0d026a6:	280a      	cmp	r0, #10
c0d026a8:	9905      	ldr	r1, [sp, #20]
c0d026aa:	d00c      	beq.n	c0d026c6 <io_exchange+0xde>
c0d026ac:	280b      	cmp	r0, #11
c0d026ae:	d142      	bne.n	c0d02736 <io_exchange+0x14e>
            io_usb_hid_send(io_usb_send_apdu_data_ep0x83, tx_len);
c0d026b0:	b289      	uxth	r1, r1
c0d026b2:	4888      	ldr	r0, [pc, #544]	; (c0d028d4 <io_exchange+0x2ec>)
c0d026b4:	4478      	add	r0, pc
c0d026b6:	f000 fa81 	bl	c0d02bbc <io_usb_hid_send>
c0d026ba:	e058      	b.n	c0d0276e <io_exchange+0x186>
            io_usb_hid_send(io_usb_send_apdu_data, tx_len);
c0d026bc:	b289      	uxth	r1, r1
c0d026be:	9802      	ldr	r0, [sp, #8]
c0d026c0:	f000 fa7c 	bl	c0d02bbc <io_usb_hid_send>
c0d026c4:	e053      	b.n	c0d0276e <io_exchange+0x186>
            if (tx_len > sizeof(G_io_apdu_buffer)) {
c0d026c6:	9803      	ldr	r0, [sp, #12]
c0d026c8:	1dc0      	adds	r0, r0, #7
c0d026ca:	b28c      	uxth	r4, r1
c0d026cc:	4284      	cmp	r4, r0
c0d026ce:	d900      	bls.n	c0d026d2 <io_exchange+0xea>
c0d026d0:	e0ec      	b.n	c0d028ac <io_exchange+0x2c4>
            G_io_seproxyhal_spi_buffer[2]  = (tx_len);
c0d026d2:	70b9      	strb	r1, [r7, #2]
c0d026d4:	2053      	movs	r0, #83	; 0x53
            G_io_seproxyhal_spi_buffer[0]  = SEPROXYHAL_TAG_RAPDU;
c0d026d6:	7038      	strb	r0, [r7, #0]
            G_io_seproxyhal_spi_buffer[1]  = (tx_len)>>8;
c0d026d8:	0a08      	lsrs	r0, r1, #8
c0d026da:	7078      	strb	r0, [r7, #1]
c0d026dc:	2103      	movs	r1, #3
            io_seproxyhal_spi_send(G_io_seproxyhal_spi_buffer, 3);
c0d026de:	4638      	mov	r0, r7
c0d026e0:	f002 ff70 	bl	c0d055c4 <io_seph_send>
            io_seproxyhal_spi_send(G_io_apdu_buffer, tx_len);
c0d026e4:	4878      	ldr	r0, [pc, #480]	; (c0d028c8 <io_exchange+0x2e0>)
c0d026e6:	4621      	mov	r1, r4
c0d026e8:	f002 ff6c 	bl	c0d055c4 <io_seph_send>
c0d026ec:	2000      	movs	r0, #0
            G_io_app.apdu_state = APDU_IDLE;
c0d026ee:	7030      	strb	r0, [r6, #0]
c0d026f0:	e040      	b.n	c0d02774 <io_exchange+0x18c>
c0d026f2:	9b05      	ldr	r3, [sp, #20]
            if (1U+ 4U+ tx_len +2U > sizeof(G_io_apdu_buffer)) {
c0d026f4:	b298      	uxth	r0, r3
c0d026f6:	9903      	ldr	r1, [sp, #12]
c0d026f8:	4288      	cmp	r0, r1
c0d026fa:	d900      	bls.n	c0d026fe <io_exchange+0x116>
c0d026fc:	e0d6      	b.n	c0d028ac <io_exchange+0x2c4>
c0d026fe:	2190      	movs	r1, #144	; 0x90
c0d02700:	4a71      	ldr	r2, [pc, #452]	; (c0d028c8 <io_exchange+0x2e0>)
            G_io_apdu_buffer[tx_len] = 0x90; //G_io_apdu_buffer[tx_len-2];
c0d02702:	5411      	strb	r1, [r2, r0]
c0d02704:	1810      	adds	r0, r2, r0
            G_io_apdu_buffer[tx_len+1] = 0x00; //G_io_apdu_buffer[tx_len-1];
c0d02706:	9901      	ldr	r1, [sp, #4]
c0d02708:	7041      	strb	r1, [r0, #1]
            memmove(G_io_apdu_buffer + APDU_OFF_DATA, G_io_apdu_buffer, tx_len);
c0d0270a:	1d50      	adds	r0, r2, #5
            tx_len += 2;
c0d0270c:	1c99      	adds	r1, r3, #2
            memmove(G_io_apdu_buffer + APDU_OFF_DATA, G_io_apdu_buffer, tx_len);
c0d0270e:	b28a      	uxth	r2, r1
c0d02710:	496d      	ldr	r1, [pc, #436]	; (c0d028c8 <io_exchange+0x2e0>)
c0d02712:	f005 ff04 	bl	c0d0851e <__aeabi_memmove>
c0d02716:	2105      	movs	r1, #5
            memset(G_io_apdu_buffer, 0, APDU_OFF_DATA);
c0d02718:	486b      	ldr	r0, [pc, #428]	; (c0d028c8 <io_exchange+0x2e0>)
c0d0271a:	f005 fef7 	bl	c0d0850c <__aeabi_memclr>
            u2f_message_reply(&G_io_u2f, U2F_CMD_MSG, G_io_apdu_buffer, tx_len+5);
c0d0271e:	9805      	ldr	r0, [sp, #20]
c0d02720:	1dc0      	adds	r0, r0, #7
c0d02722:	b283      	uxth	r3, r0
c0d02724:	2183      	movs	r1, #131	; 0x83
c0d02726:	4867      	ldr	r0, [pc, #412]	; (c0d028c4 <io_exchange+0x2dc>)
c0d02728:	4a67      	ldr	r2, [pc, #412]	; (c0d028c8 <io_exchange+0x2e0>)
c0d0272a:	f003 fdd1 	bl	c0d062d0 <u2f_message_reply>
c0d0272e:	e01e      	b.n	c0d0276e <io_exchange+0x186>
        switch(G_io_app.apdu_state) {
c0d02730:	2800      	cmp	r0, #0
c0d02732:	d100      	bne.n	c0d02736 <io_exchange+0x14e>
c0d02734:	e0b5      	b.n	c0d028a2 <io_exchange+0x2ba>
            if (io_exchange_al(channel, tx_len) == 0) {
c0d02736:	9806      	ldr	r0, [sp, #24]
c0d02738:	b2c0      	uxtb	r0, r0
c0d0273a:	b289      	uxth	r1, r1
c0d0273c:	f7ff f878 	bl	c0d01830 <io_exchange_al>
c0d02740:	2800      	cmp	r0, #0
c0d02742:	d014      	beq.n	c0d0276e <io_exchange+0x186>
c0d02744:	e0ad      	b.n	c0d028a2 <io_exchange+0x2ba>
  io_seproxyhal_spi_send(seph_io_general_status, sizeof(seph_io_general_status));
c0d02746:	4865      	ldr	r0, [pc, #404]	; (c0d028dc <io_exchange+0x2f4>)
c0d02748:	4478      	add	r0, pc
c0d0274a:	2105      	movs	r1, #5
c0d0274c:	f002 ff3a 	bl	c0d055c4 <io_seph_send>
c0d02750:	2180      	movs	r1, #128	; 0x80
c0d02752:	2200      	movs	r2, #0
            io_seproxyhal_spi_recv(G_io_seproxyhal_spi_buffer, sizeof(G_io_seproxyhal_spi_buffer), 0);
c0d02754:	4638      	mov	r0, r7
c0d02756:	f002 ff4d 	bl	c0d055f4 <io_seph_recv>
            if (G_io_app.ms >= timeout_ms) {
c0d0275a:	68b0      	ldr	r0, [r6, #8]
c0d0275c:	42a0      	cmp	r0, r4
c0d0275e:	d300      	bcc.n	c0d02762 <io_exchange+0x17a>
c0d02760:	e09c      	b.n	c0d0289c <io_exchange+0x2b4>
            io_seproxyhal_handle_event();
c0d02762:	f7ff fdd7 	bl	c0d02314 <io_seproxyhal_handle_event>
          } while (io_seproxyhal_spi_is_status_sent());
c0d02766:	f002 ff39 	bl	c0d055dc <io_seph_is_status_sent>
c0d0276a:	2800      	cmp	r0, #0
c0d0276c:	d1f0      	bne.n	c0d02750 <io_exchange+0x168>
        while (G_io_app.apdu_state != APDU_IDLE) {
c0d0276e:	7830      	ldrb	r0, [r6, #0]
c0d02770:	2800      	cmp	r0, #0
c0d02772:	d1e8      	bne.n	c0d02746 <io_exchange+0x15e>
c0d02774:	2000      	movs	r0, #0
        G_io_app.apdu_media = IO_APDU_MEDIA_NONE;
c0d02776:	71b0      	strb	r0, [r6, #6]
        G_io_app.apdu_state = APDU_IDLE;
c0d02778:	7030      	strb	r0, [r6, #0]
        G_io_app.apdu_length = 0;
c0d0277a:	8070      	strh	r0, [r6, #2]
        if (channel & IO_RETURN_AFTER_TX) {
c0d0277c:	9906      	ldr	r1, [sp, #24]
c0d0277e:	0689      	lsls	r1, r1, #26
c0d02780:	d500      	bpl.n	c0d02784 <io_exchange+0x19c>
c0d02782:	e741      	b.n	c0d02608 <io_exchange+0x20>
  io_seproxyhal_spi_send(seph_io_general_status, sizeof(seph_io_general_status));
c0d02784:	4852      	ldr	r0, [pc, #328]	; (c0d028d0 <io_exchange+0x2e8>)
c0d02786:	4478      	add	r0, pc
c0d02788:	2105      	movs	r1, #5
c0d0278a:	f002 ff1b 	bl	c0d055c4 <io_seph_send>
c0d0278e:	9c06      	ldr	r4, [sp, #24]
      if (channel & IO_RESET_AFTER_REPLIED) {
c0d02790:	b260      	sxtb	r0, r4
c0d02792:	2800      	cmp	r0, #0
c0d02794:	9a04      	ldr	r2, [sp, #16]
c0d02796:	d503      	bpl.n	c0d027a0 <io_exchange+0x1b8>
c0d02798:	2005      	movs	r0, #5
        os_sched_exit((bolos_task_status_t)EXCEPTION_IO_RESET);
c0d0279a:	f002 ff05 	bl	c0d055a8 <os_sched_exit>
c0d0279e:	9a04      	ldr	r2, [sp, #16]
    if (!(channel&IO_ASYNCH_REPLY)) {
c0d027a0:	2d00      	cmp	r5, #0
c0d027a2:	d104      	bne.n	c0d027ae <io_exchange+0x1c6>
      if ((channel & (CHANNEL_APDU|IO_RECEIVE_DATA)) == (CHANNEL_APDU|IO_RECEIVE_DATA)) {
c0d027a4:	0650      	lsls	r0, r2, #25
c0d027a6:	d476      	bmi.n	c0d02896 <io_exchange+0x2ae>
c0d027a8:	2000      	movs	r0, #0
      G_io_app.apdu_media = IO_APDU_MEDIA_NONE;
c0d027aa:	71b0      	strb	r0, [r6, #6]
      G_io_app.apdu_state = APDU_IDLE;
c0d027ac:	7030      	strb	r0, [r6, #0]
c0d027ae:	4625      	mov	r5, r4
c0d027b0:	2000      	movs	r0, #0
c0d027b2:	8070      	strh	r0, [r6, #2]
  io_seproxyhal_spi_send(seph_io_general_status, sizeof(seph_io_general_status));
c0d027b4:	484a      	ldr	r0, [pc, #296]	; (c0d028e0 <io_exchange+0x2f8>)
c0d027b6:	4478      	add	r0, pc
c0d027b8:	2105      	movs	r1, #5
c0d027ba:	f002 ff03 	bl	c0d055c4 <io_seph_send>
c0d027be:	2180      	movs	r1, #128	; 0x80
c0d027c0:	2400      	movs	r4, #0
      rx_len = io_seproxyhal_spi_recv(G_io_seproxyhal_spi_buffer, sizeof(G_io_seproxyhal_spi_buffer), 0);
c0d027c2:	4638      	mov	r0, r7
c0d027c4:	4622      	mov	r2, r4
c0d027c6:	f002 ff15 	bl	c0d055f4 <io_seph_recv>
      if (rx_len < 3 || rx_len != U2(G_io_seproxyhal_spi_buffer[1],G_io_seproxyhal_spi_buffer[2])+3U) {
c0d027ca:	2803      	cmp	r0, #3
c0d027cc:	d30f      	bcc.n	c0d027ee <io_exchange+0x206>
c0d027ce:	78b9      	ldrb	r1, [r7, #2]
c0d027d0:	787a      	ldrb	r2, [r7, #1]
c0d027d2:	0212      	lsls	r2, r2, #8
c0d027d4:	1851      	adds	r1, r2, r1
c0d027d6:	1cc9      	adds	r1, r1, #3
c0d027d8:	4281      	cmp	r1, r0
c0d027da:	d108      	bne.n	c0d027ee <io_exchange+0x206>
      io_seproxyhal_handle_event();
c0d027dc:	f7ff fd9a 	bl	c0d02314 <io_seproxyhal_handle_event>
      if (G_io_app.apdu_state != APDU_IDLE && G_io_app.apdu_length > 0) {
c0d027e0:	8870      	ldrh	r0, [r6, #2]
c0d027e2:	7831      	ldrb	r1, [r6, #0]
c0d027e4:	2900      	cmp	r1, #0
c0d027e6:	d0e5      	beq.n	c0d027b4 <io_exchange+0x1cc>
c0d027e8:	2800      	cmp	r0, #0
c0d027ea:	d0e3      	beq.n	c0d027b4 <io_exchange+0x1cc>
c0d027ec:	e001      	b.n	c0d027f2 <io_exchange+0x20a>
        G_io_app.apdu_state = APDU_IDLE;
c0d027ee:	7034      	strb	r4, [r6, #0]
c0d027f0:	e7de      	b.n	c0d027b0 <io_exchange+0x1c8>
c0d027f2:	4a35      	ldr	r2, [pc, #212]	; (c0d028c8 <io_exchange+0x2e0>)
  if (DEFAULT_APDU_CLA == G_io_apdu_buffer[APDU_OFF_CLA]) {
c0d027f4:	7811      	ldrb	r1, [r2, #0]
c0d027f6:	29b0      	cmp	r1, #176	; 0xb0
c0d027f8:	d000      	beq.n	c0d027fc <io_exchange+0x214>
c0d027fa:	e705      	b.n	c0d02608 <io_exchange+0x20>
    switch (G_io_apdu_buffer[APDU_OFF_INS]) {
c0d027fc:	7851      	ldrb	r1, [r2, #1]
c0d027fe:	29a7      	cmp	r1, #167	; 0xa7
c0d02800:	d02c      	beq.n	c0d0285c <io_exchange+0x274>
c0d02802:	2902      	cmp	r1, #2
c0d02804:	d00e      	beq.n	c0d02824 <io_exchange+0x23c>
c0d02806:	2901      	cmp	r1, #1
c0d02808:	d000      	beq.n	c0d0280c <io_exchange+0x224>
c0d0280a:	e6fd      	b.n	c0d02608 <io_exchange+0x20>
        if (!G_io_apdu_buffer[APDU_OFF_P1] && !G_io_apdu_buffer[APDU_OFF_P2]) {
c0d0280c:	7891      	ldrb	r1, [r2, #2]
c0d0280e:	78d2      	ldrb	r2, [r2, #3]
c0d02810:	430a      	orrs	r2, r1
c0d02812:	d000      	beq.n	c0d02816 <io_exchange+0x22e>
c0d02814:	e6f8      	b.n	c0d02608 <io_exchange+0x20>
c0d02816:	2007      	movs	r0, #7
c0d02818:	462c      	mov	r4, r5
          *channel &= ~IO_FLAGS;
c0d0281a:	4004      	ands	r4, r0
          *tx_len = os_io_seproxyhal_get_app_name_and_version();
c0d0281c:	f7ff fec0 	bl	c0d025a0 <os_io_seproxyhal_get_app_name_and_version>
c0d02820:	4601      	mov	r1, r0
c0d02822:	e033      	b.n	c0d0288c <io_exchange+0x2a4>
        if (!G_io_apdu_buffer[APDU_OFF_P1] && !G_io_apdu_buffer[APDU_OFF_P2]) {
c0d02824:	7891      	ldrb	r1, [r2, #2]
c0d02826:	78d2      	ldrb	r2, [r2, #3]
c0d02828:	430a      	orrs	r2, r1
c0d0282a:	d000      	beq.n	c0d0282e <io_exchange+0x246>
c0d0282c:	e6ec      	b.n	c0d02608 <io_exchange+0x20>
          if (os_global_pin_is_validated() == BOLOS_UX_OK) {
c0d0282e:	f002 fe7b 	bl	c0d05528 <os_global_pin_is_validated>
c0d02832:	28aa      	cmp	r0, #170	; 0xaa
c0d02834:	d121      	bne.n	c0d0287a <io_exchange+0x292>
c0d02836:	2001      	movs	r0, #1
c0d02838:	4923      	ldr	r1, [pc, #140]	; (c0d028c8 <io_exchange+0x2e0>)
            G_io_apdu_buffer[(*tx_len)++] = 0x01;
c0d0283a:	7008      	strb	r0, [r1, #0]
            i = os_perso_seed_cookie(G_io_apdu_buffer+1+1, MIN(64,sizeof(G_io_apdu_buffer)-1-1-2));
c0d0283c:	1c88      	adds	r0, r1, #2
c0d0283e:	2140      	movs	r1, #64	; 0x40
c0d02840:	f002 fe66 	bl	c0d05510 <os_perso_seed_cookie>
c0d02844:	4b20      	ldr	r3, [pc, #128]	; (c0d028c8 <io_exchange+0x2e0>)
            G_io_apdu_buffer[(*tx_len)++] = i;
c0d02846:	7058      	strb	r0, [r3, #1]
            *tx_len += i;
c0d02848:	1c81      	adds	r1, r0, #2
            G_io_apdu_buffer[(*tx_len)++] = 0x90;
c0d0284a:	b289      	uxth	r1, r1
c0d0284c:	2290      	movs	r2, #144	; 0x90
c0d0284e:	545a      	strb	r2, [r3, r1]
c0d02850:	461a      	mov	r2, r3
c0d02852:	1cc1      	adds	r1, r0, #3
            G_io_apdu_buffer[(*tx_len)++] = 0x00;
c0d02854:	b289      	uxth	r1, r1
c0d02856:	545c      	strb	r4, [r3, r1]
c0d02858:	1d01      	adds	r1, r0, #4
c0d0285a:	e014      	b.n	c0d02886 <io_exchange+0x29e>
        if (!G_io_apdu_buffer[APDU_OFF_P1] && !G_io_apdu_buffer[APDU_OFF_P2]) {
c0d0285c:	7891      	ldrb	r1, [r2, #2]
c0d0285e:	78d2      	ldrb	r2, [r2, #3]
c0d02860:	430a      	orrs	r2, r1
c0d02862:	d000      	beq.n	c0d02866 <io_exchange+0x27e>
c0d02864:	e6d0      	b.n	c0d02608 <io_exchange+0x20>
c0d02866:	4918      	ldr	r1, [pc, #96]	; (c0d028c8 <io_exchange+0x2e0>)
          G_io_apdu_buffer[(*tx_len)++] = 0x00;
c0d02868:	704c      	strb	r4, [r1, #1]
c0d0286a:	2090      	movs	r0, #144	; 0x90
          G_io_apdu_buffer[(*tx_len)++] = 0x90;
c0d0286c:	7008      	strb	r0, [r1, #0]
c0d0286e:	207f      	movs	r0, #127	; 0x7f
c0d02870:	43c0      	mvns	r0, r0
c0d02872:	462c      	mov	r4, r5
          *channel |= IO_RESET_AFTER_REPLIED;
c0d02874:	4304      	orrs	r4, r0
c0d02876:	2102      	movs	r1, #2
c0d02878:	e008      	b.n	c0d0288c <io_exchange+0x2a4>
c0d0287a:	2085      	movs	r0, #133	; 0x85
c0d0287c:	4912      	ldr	r1, [pc, #72]	; (c0d028c8 <io_exchange+0x2e0>)
            G_io_apdu_buffer[(*tx_len)++] = 0x85;
c0d0287e:	7048      	strb	r0, [r1, #1]
c0d02880:	2069      	movs	r0, #105	; 0x69
            G_io_apdu_buffer[(*tx_len)++] = 0x69;
c0d02882:	7008      	strb	r0, [r1, #0]
c0d02884:	2102      	movs	r1, #2
c0d02886:	2007      	movs	r0, #7
c0d02888:	462c      	mov	r4, r5
          *channel &= ~IO_FLAGS;
c0d0288a:	4004      	ands	r4, r0
  switch(channel&~(IO_FLAGS)) {
c0d0288c:	b2e2      	uxtb	r2, r4
c0d0288e:	0760      	lsls	r0, r4, #29
c0d02890:	d100      	bne.n	c0d02894 <io_exchange+0x2ac>
c0d02892:	e6c5      	b.n	c0d02620 <io_exchange+0x38>
c0d02894:	e6b4      	b.n	c0d02600 <io_exchange+0x18>
        return G_io_app.apdu_length-5;
c0d02896:	8870      	ldrh	r0, [r6, #2]
c0d02898:	1f40      	subs	r0, r0, #5
c0d0289a:	e6b5      	b.n	c0d02608 <io_exchange+0x20>
c0d0289c:	2005      	movs	r0, #5
c0d0289e:	f7ff fc79 	bl	c0d02194 <os_longjmp>
c0d028a2:	2004      	movs	r0, #4
            THROW(INVALID_STATE);
c0d028a4:	f7ff fc76 	bl	c0d02194 <os_longjmp>
    io_seproxyhal_se_reset();
c0d028a8:	f7ff fe72 	bl	c0d02590 <io_seproxyhal_se_reset>
c0d028ac:	2002      	movs	r0, #2
c0d028ae:	f7ff fc71 	bl	c0d02194 <os_longjmp>
c0d028b2:	46c0      	nop			; (mov r8, r8)
c0d028b4:	20000ac8 	.word	0x20000ac8
c0d028b8:	dead0031 	.word	0xdead0031
c0d028bc:	20000205 	.word	0x20000205
c0d028c0:	200003d8 	.word	0x200003d8
c0d028c4:	200003f8 	.word	0x200003f8
c0d028c8:	20000285 	.word	0x20000285
c0d028cc:	fffffcd9 	.word	0xfffffcd9
c0d028d0:	00006bb8 	.word	0x00006bb8
c0d028d4:	fffffc4d 	.word	0xfffffc4d
c0d028d8:	00006cc0 	.word	0x00006cc0
c0d028dc:	00006bf6 	.word	0x00006bf6
c0d028e0:	00006b88 	.word	0x00006b88

c0d028e4 <os_io_seph_recv_and_process>:

unsigned int os_io_seph_recv_and_process(unsigned int dont_process_ux_events) {
c0d028e4:	b570      	push	{r4, r5, r6, lr}
c0d028e6:	4604      	mov	r4, r0
  io_seproxyhal_spi_send(seph_io_general_status, sizeof(seph_io_general_status));
c0d028e8:	4810      	ldr	r0, [pc, #64]	; (c0d0292c <os_io_seph_recv_and_process+0x48>)
c0d028ea:	4478      	add	r0, pc
c0d028ec:	2105      	movs	r1, #5
c0d028ee:	f002 fe69 	bl	c0d055c4 <io_seph_send>
  // send general status before receiving next event
  io_seproxyhal_general_status();

  io_seproxyhal_spi_recv(G_io_seproxyhal_spi_buffer, sizeof(G_io_seproxyhal_spi_buffer), 0);
c0d028f2:	4e0c      	ldr	r6, [pc, #48]	; (c0d02924 <os_io_seph_recv_and_process+0x40>)
c0d028f4:	2180      	movs	r1, #128	; 0x80
c0d028f6:	2500      	movs	r5, #0
c0d028f8:	4630      	mov	r0, r6
c0d028fa:	462a      	mov	r2, r5
c0d028fc:	f002 fe7a 	bl	c0d055f4 <io_seph_recv>

  switch (G_io_seproxyhal_spi_buffer[0]) {
c0d02900:	7830      	ldrb	r0, [r6, #0]
c0d02902:	2815      	cmp	r0, #21
c0d02904:	d806      	bhi.n	c0d02914 <os_io_seph_recv_and_process+0x30>
c0d02906:	2101      	movs	r1, #1
c0d02908:	4081      	lsls	r1, r0
c0d0290a:	4807      	ldr	r0, [pc, #28]	; (c0d02928 <os_io_seph_recv_and_process+0x44>)
c0d0290c:	4201      	tst	r1, r0
c0d0290e:	d001      	beq.n	c0d02914 <os_io_seph_recv_and_process+0x30>
    case SEPROXYHAL_TAG_BUTTON_PUSH_EVENT:
    case SEPROXYHAL_TAG_TICKER_EVENT:
    case SEPROXYHAL_TAG_DISPLAY_PROCESSED_EVENT:
    case SEPROXYHAL_TAG_STATUS_EVENT:
      // perform UX event on these ones, don't process as an IO event
      if (dont_process_ux_events) {
c0d02910:	2c00      	cmp	r4, #0
c0d02912:	d104      	bne.n	c0d0291e <os_io_seph_recv_and_process+0x3a>
      }
      __attribute__((fallthrough));

    default:
      // if malformed, then a stall is likely to occur
      if (io_seproxyhal_handle_event()) {
c0d02914:	f7ff fcfe 	bl	c0d02314 <io_seproxyhal_handle_event>
c0d02918:	4605      	mov	r5, r0
c0d0291a:	1e40      	subs	r0, r0, #1
c0d0291c:	4185      	sbcs	r5, r0
        return 1;
      }
  }
  return 0;
}
c0d0291e:	4628      	mov	r0, r5
c0d02920:	bd70      	pop	{r4, r5, r6, pc}
c0d02922:	46c0      	nop			; (mov r8, r8)
c0d02924:	20000205 	.word	0x20000205
c0d02928:	00207020 	.word	0x00207020
c0d0292c:	00006a54 	.word	0x00006a54

c0d02930 <mcu_usb_printc>:

  return ret;
} 

// so unoptimized
void mcu_usb_printc(unsigned char c) {
c0d02930:	b5b0      	push	{r4, r5, r7, lr}
c0d02932:	b082      	sub	sp, #8
c0d02934:	ac01      	add	r4, sp, #4
#else // TARGET_NANOX
  buf[0] = SEPROXYHAL_TAG_PRINTF_STATUS;
#endif // TARGET_NANOX
  buf[1] = 0;
  buf[2] = 1;
  buf[3] = c;
c0d02936:	70e0      	strb	r0, [r4, #3]
c0d02938:	2001      	movs	r0, #1
  buf[2] = 1;
c0d0293a:	70a0      	strb	r0, [r4, #2]
c0d0293c:	2500      	movs	r5, #0
  buf[1] = 0;
c0d0293e:	7065      	strb	r5, [r4, #1]
c0d02940:	2066      	movs	r0, #102	; 0x66
  buf[0] = SEPROXYHAL_TAG_PRINTF_STATUS;
c0d02942:	7020      	strb	r0, [r4, #0]
c0d02944:	2104      	movs	r1, #4
  io_seproxyhal_spi_send(buf, 4);
c0d02946:	4620      	mov	r0, r4
c0d02948:	f002 fe3c 	bl	c0d055c4 <io_seph_send>
c0d0294c:	2103      	movs	r1, #3
#ifndef TARGET_NANOX
#ifndef IO_SEPROXYHAL_DEBUG
  // wait printf ack (no race kthx)
  io_seproxyhal_spi_recv(buf, 3, 0);
c0d0294e:	4620      	mov	r0, r4
c0d02950:	462a      	mov	r2, r5
c0d02952:	f002 fe4f 	bl	c0d055f4 <io_seph_recv>
  buf[0] = 0; // consume tag to avoid misinterpretation (due to IO_CACHE)
#endif // IO_SEPROXYHAL_DEBUG
#endif // TARGET_NANOX
}
c0d02956:	b002      	add	sp, #8
c0d02958:	bdb0      	pop	{r4, r5, r7, pc}
	...

c0d0295c <io_seproxyhal_io_heartbeat>:

void io_seproxyhal_io_heartbeat(void) {
c0d0295c:	b510      	push	{r4, lr}
  io_seproxyhal_spi_send(seph_io_general_status, sizeof(seph_io_general_status));
c0d0295e:	480b      	ldr	r0, [pc, #44]	; (c0d0298c <io_seproxyhal_io_heartbeat+0x30>)
c0d02960:	4478      	add	r0, pc
c0d02962:	2105      	movs	r1, #5
c0d02964:	f002 fe2e 	bl	c0d055c4 <io_seph_send>
c0d02968:	4c07      	ldr	r4, [pc, #28]	; (c0d02988 <io_seproxyhal_io_heartbeat+0x2c>)
c0d0296a:	2180      	movs	r1, #128	; 0x80
c0d0296c:	2200      	movs	r2, #0
  io_seproxyhal_general_status();
  do {
    io_seproxyhal_spi_recv(G_io_seproxyhal_spi_buffer, sizeof(G_io_seproxyhal_spi_buffer), 0);
c0d0296e:	4620      	mov	r0, r4
c0d02970:	f002 fe40 	bl	c0d055f4 <io_seph_recv>
    // avoid a general status to be replied
    if(G_io_seproxyhal_spi_buffer[0] != SEPROXYHAL_TAG_TICKER_EVENT) {
c0d02974:	7820      	ldrb	r0, [r4, #0]
c0d02976:	280e      	cmp	r0, #14
c0d02978:	d001      	beq.n	c0d0297e <io_seproxyhal_io_heartbeat+0x22>
      io_seproxyhal_handle_event();
c0d0297a:	f7ff fccb 	bl	c0d02314 <io_seproxyhal_handle_event>
    }
  } while (io_seproxyhal_spi_is_status_sent());
c0d0297e:	f002 fe2d 	bl	c0d055dc <io_seph_is_status_sent>
c0d02982:	2800      	cmp	r0, #0
c0d02984:	d1f1      	bne.n	c0d0296a <io_seproxyhal_io_heartbeat+0xe>
}
c0d02986:	bd10      	pop	{r4, pc}
c0d02988:	20000205 	.word	0x20000205
c0d0298c:	000069de 	.word	0x000069de

c0d02990 <io_usb_hid_receive>:
volatile unsigned int   G_io_usb_hid_channel;
volatile unsigned int   G_io_usb_hid_remaining_length;
volatile unsigned int   G_io_usb_hid_sequence_number;
volatile unsigned char* G_io_usb_hid_current_buffer;

io_usb_hid_receive_status_t io_usb_hid_receive (io_send_t sndfct, unsigned char* buffer, unsigned short l) {
c0d02990:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d02992:	b081      	sub	sp, #4
c0d02994:	9200      	str	r2, [sp, #0]
c0d02996:	4604      	mov	r4, r0
  // avoid over/under flows
  if (buffer != G_io_usb_ep_buffer) {
c0d02998:	4e4b      	ldr	r6, [pc, #300]	; (c0d02ac8 <io_usb_hid_receive+0x138>)
c0d0299a:	42b1      	cmp	r1, r6
c0d0299c:	d00f      	beq.n	c0d029be <io_usb_hid_receive+0x2e>
c0d0299e:	460f      	mov	r7, r1
    memset(G_io_usb_ep_buffer, 0, sizeof(G_io_usb_ep_buffer));
c0d029a0:	4d49      	ldr	r5, [pc, #292]	; (c0d02ac8 <io_usb_hid_receive+0x138>)
c0d029a2:	2640      	movs	r6, #64	; 0x40
c0d029a4:	4628      	mov	r0, r5
c0d029a6:	4631      	mov	r1, r6
c0d029a8:	f005 fdb0 	bl	c0d0850c <__aeabi_memclr>
c0d029ac:	9a00      	ldr	r2, [sp, #0]
    memmove(G_io_usb_ep_buffer, buffer, MIN(l, sizeof(G_io_usb_ep_buffer)));
c0d029ae:	2a40      	cmp	r2, #64	; 0x40
c0d029b0:	d300      	bcc.n	c0d029b4 <io_usb_hid_receive+0x24>
c0d029b2:	4632      	mov	r2, r6
c0d029b4:	4628      	mov	r0, r5
c0d029b6:	4639      	mov	r1, r7
c0d029b8:	f005 fdb1 	bl	c0d0851e <__aeabi_memmove>
c0d029bc:	4e42      	ldr	r6, [pc, #264]	; (c0d02ac8 <io_usb_hid_receive+0x138>)
  }

  // process the chunk content
  switch(G_io_usb_ep_buffer[2]) {
c0d029be:	78b0      	ldrb	r0, [r6, #2]
c0d029c0:	2801      	cmp	r0, #1
c0d029c2:	dc0a      	bgt.n	c0d029da <io_usb_hid_receive+0x4a>
c0d029c4:	2800      	cmp	r0, #0
c0d029c6:	d02e      	beq.n	c0d02a26 <io_usb_hid_receive+0x96>
c0d029c8:	2801      	cmp	r0, #1
c0d029ca:	d16c      	bne.n	c0d02aa6 <io_usb_hid_receive+0x116>
    // await for the next chunk
    goto apdu_reset;

  case 0x01: // ALLOCATE CHANNEL
    // do not reset the current apdu reception if any
    cx_rng_no_throw(G_io_usb_ep_buffer+3, 4);
c0d029cc:	1cf0      	adds	r0, r6, #3
c0d029ce:	2104      	movs	r1, #4
c0d029d0:	f7fd fd60 	bl	c0d00494 <cx_rng_no_throw>
c0d029d4:	2140      	movs	r1, #64	; 0x40
    // send the response
    sndfct(G_io_usb_ep_buffer, IO_HID_EP_LENGTH);
c0d029d6:	4630      	mov	r0, r6
c0d029d8:	e030      	b.n	c0d02a3c <io_usb_hid_receive+0xac>
  switch(G_io_usb_ep_buffer[2]) {
c0d029da:	2802      	cmp	r0, #2
c0d029dc:	d02c      	beq.n	c0d02a38 <io_usb_hid_receive+0xa8>
c0d029de:	2805      	cmp	r0, #5
c0d029e0:	d161      	bne.n	c0d02aa6 <io_usb_hid_receive+0x116>
c0d029e2:	7930      	ldrb	r0, [r6, #4]
c0d029e4:	78f1      	ldrb	r1, [r6, #3]
c0d029e6:	0209      	lsls	r1, r1, #8
c0d029e8:	1808      	adds	r0, r1, r0
    if ((unsigned int)U2BE(G_io_usb_ep_buffer, 3) != (unsigned int)G_io_usb_hid_sequence_number) {
c0d029ea:	4c38      	ldr	r4, [pc, #224]	; (c0d02acc <io_usb_hid_receive+0x13c>)
c0d029ec:	6821      	ldr	r1, [r4, #0]
c0d029ee:	2700      	movs	r7, #0
c0d029f0:	4281      	cmp	r1, r0
c0d029f2:	d15f      	bne.n	c0d02ab4 <io_usb_hid_receive+0x124>
    if (G_io_usb_hid_sequence_number == 0) {
c0d029f4:	6820      	ldr	r0, [r4, #0]
c0d029f6:	2800      	cmp	r0, #0
c0d029f8:	d023      	beq.n	c0d02a42 <io_usb_hid_receive+0xb2>
c0d029fa:	9800      	ldr	r0, [sp, #0]
c0d029fc:	1f40      	subs	r0, r0, #5
      if (l > G_io_usb_hid_remaining_length) {
c0d029fe:	b282      	uxth	r2, r0
c0d02a00:	4933      	ldr	r1, [pc, #204]	; (c0d02ad0 <io_usb_hid_receive+0x140>)
c0d02a02:	680b      	ldr	r3, [r1, #0]
c0d02a04:	4293      	cmp	r3, r2
c0d02a06:	d200      	bcs.n	c0d02a0a <io_usb_hid_receive+0x7a>
        l = G_io_usb_hid_remaining_length;
c0d02a08:	6808      	ldr	r0, [r1, #0]
c0d02a0a:	4632      	mov	r2, r6
      if (l > sizeof(G_io_usb_ep_buffer) - 5) {
c0d02a0c:	b281      	uxth	r1, r0
c0d02a0e:	293b      	cmp	r1, #59	; 0x3b
c0d02a10:	d300      	bcc.n	c0d02a14 <io_usb_hid_receive+0x84>
c0d02a12:	203b      	movs	r0, #59	; 0x3b
      memmove((void*)G_io_usb_hid_current_buffer, G_io_usb_ep_buffer+5, l);
c0d02a14:	b285      	uxth	r5, r0
c0d02a16:	4e2f      	ldr	r6, [pc, #188]	; (c0d02ad4 <io_usb_hid_receive+0x144>)
c0d02a18:	6830      	ldr	r0, [r6, #0]
c0d02a1a:	1d51      	adds	r1, r2, #5
c0d02a1c:	462a      	mov	r2, r5
c0d02a1e:	f005 fd7e 	bl	c0d0851e <__aeabi_memmove>
    G_io_usb_hid_current_buffer += l;
c0d02a22:	6836      	ldr	r6, [r6, #0]
c0d02a24:	e035      	b.n	c0d02a92 <io_usb_hid_receive+0x102>
c0d02a26:	2700      	movs	r7, #0
    memset(G_io_usb_ep_buffer+3, 0, 4); // PROTOCOL VERSION is 0
c0d02a28:	71b7      	strb	r7, [r6, #6]
c0d02a2a:	7177      	strb	r7, [r6, #5]
c0d02a2c:	7137      	strb	r7, [r6, #4]
c0d02a2e:	70f7      	strb	r7, [r6, #3]
c0d02a30:	2140      	movs	r1, #64	; 0x40
    sndfct(G_io_usb_ep_buffer, IO_HID_EP_LENGTH);
c0d02a32:	4630      	mov	r0, r6
c0d02a34:	47a0      	blx	r4
c0d02a36:	e03d      	b.n	c0d02ab4 <io_usb_hid_receive+0x124>
    goto apdu_reset;

  case 0x02: // ECHO|PING
    // do not reset the current apdu reception if any
    // send the response
    sndfct(G_io_usb_ep_buffer, IO_HID_EP_LENGTH);
c0d02a38:	4823      	ldr	r0, [pc, #140]	; (c0d02ac8 <io_usb_hid_receive+0x138>)
c0d02a3a:	2140      	movs	r1, #64	; 0x40
c0d02a3c:	47a0      	blx	r4
c0d02a3e:	2700      	movs	r7, #0
c0d02a40:	e038      	b.n	c0d02ab4 <io_usb_hid_receive+0x124>
c0d02a42:	79b0      	ldrb	r0, [r6, #6]
c0d02a44:	7971      	ldrb	r1, [r6, #5]
c0d02a46:	0209      	lsls	r1, r1, #8
c0d02a48:	1809      	adds	r1, r1, r0
      G_io_usb_hid_total_length = U2BE(G_io_usb_ep_buffer, 5); //(G_io_usb_ep_buffer[5]<<8)+(G_io_usb_ep_buffer[6]&0xFF);
c0d02a4a:	4823      	ldr	r0, [pc, #140]	; (c0d02ad8 <io_usb_hid_receive+0x148>)
c0d02a4c:	6001      	str	r1, [r0, #0]
      if (G_io_usb_hid_total_length > sizeof(G_io_apdu_buffer)) {
c0d02a4e:	6801      	ldr	r1, [r0, #0]
c0d02a50:	0849      	lsrs	r1, r1, #1
c0d02a52:	29a8      	cmp	r1, #168	; 0xa8
c0d02a54:	d82e      	bhi.n	c0d02ab4 <io_usb_hid_receive+0x124>
      G_io_usb_hid_remaining_length = G_io_usb_hid_total_length;
c0d02a56:	6801      	ldr	r1, [r0, #0]
c0d02a58:	481d      	ldr	r0, [pc, #116]	; (c0d02ad0 <io_usb_hid_receive+0x140>)
c0d02a5a:	6001      	str	r1, [r0, #0]
c0d02a5c:	7871      	ldrb	r1, [r6, #1]
c0d02a5e:	4637      	mov	r7, r6
c0d02a60:	7832      	ldrb	r2, [r6, #0]
c0d02a62:	0212      	lsls	r2, r2, #8
c0d02a64:	1851      	adds	r1, r2, r1
      G_io_usb_hid_channel = U2BE(G_io_usb_ep_buffer, 0);
c0d02a66:	4a1d      	ldr	r2, [pc, #116]	; (c0d02adc <io_usb_hid_receive+0x14c>)
c0d02a68:	6011      	str	r1, [r2, #0]
      G_io_usb_hid_current_buffer = G_io_apdu_buffer;
c0d02a6a:	491a      	ldr	r1, [pc, #104]	; (c0d02ad4 <io_usb_hid_receive+0x144>)
c0d02a6c:	4e1c      	ldr	r6, [pc, #112]	; (c0d02ae0 <io_usb_hid_receive+0x150>)
c0d02a6e:	600e      	str	r6, [r1, #0]
      if (l > G_io_usb_hid_remaining_length) {
c0d02a70:	6802      	ldr	r2, [r0, #0]
      l -= 2;
c0d02a72:	9900      	ldr	r1, [sp, #0]
c0d02a74:	1fc9      	subs	r1, r1, #7
      if (l > G_io_usb_hid_remaining_length) {
c0d02a76:	b28b      	uxth	r3, r1
c0d02a78:	429a      	cmp	r2, r3
c0d02a7a:	d200      	bcs.n	c0d02a7e <io_usb_hid_receive+0xee>
        l = G_io_usb_hid_remaining_length;
c0d02a7c:	6801      	ldr	r1, [r0, #0]
      if (l > sizeof(G_io_usb_ep_buffer) - 7) {
c0d02a7e:	b288      	uxth	r0, r1
c0d02a80:	2839      	cmp	r0, #57	; 0x39
c0d02a82:	d300      	bcc.n	c0d02a86 <io_usb_hid_receive+0xf6>
c0d02a84:	2139      	movs	r1, #57	; 0x39
      memmove((void*)G_io_usb_hid_current_buffer, G_io_usb_ep_buffer+7, l);
c0d02a86:	b28d      	uxth	r5, r1
c0d02a88:	1df9      	adds	r1, r7, #7
c0d02a8a:	4630      	mov	r0, r6
c0d02a8c:	462a      	mov	r2, r5
c0d02a8e:	f005 fd42 	bl	c0d08516 <__aeabi_memcpy>
    G_io_usb_hid_remaining_length -= l;
c0d02a92:	480f      	ldr	r0, [pc, #60]	; (c0d02ad0 <io_usb_hid_receive+0x140>)
c0d02a94:	6801      	ldr	r1, [r0, #0]
c0d02a96:	1b49      	subs	r1, r1, r5
c0d02a98:	6001      	str	r1, [r0, #0]
    G_io_usb_hid_current_buffer += l;
c0d02a9a:	1970      	adds	r0, r6, r5
c0d02a9c:	490d      	ldr	r1, [pc, #52]	; (c0d02ad4 <io_usb_hid_receive+0x144>)
c0d02a9e:	6008      	str	r0, [r1, #0]
    G_io_usb_hid_sequence_number++;
c0d02aa0:	6820      	ldr	r0, [r4, #0]
c0d02aa2:	1c40      	adds	r0, r0, #1
c0d02aa4:	6020      	str	r0, [r4, #0]
    // await for the next chunk
    goto apdu_reset;
  }

  // if more data to be received, notify it
  if (G_io_usb_hid_remaining_length) {
c0d02aa6:	480a      	ldr	r0, [pc, #40]	; (c0d02ad0 <io_usb_hid_receive+0x140>)
c0d02aa8:	6800      	ldr	r0, [r0, #0]
c0d02aaa:	2800      	cmp	r0, #0
c0d02aac:	d001      	beq.n	c0d02ab2 <io_usb_hid_receive+0x122>
c0d02aae:	2701      	movs	r7, #1
c0d02ab0:	e007      	b.n	c0d02ac2 <io_usb_hid_receive+0x132>
c0d02ab2:	2702      	movs	r7, #2
c0d02ab4:	4805      	ldr	r0, [pc, #20]	; (c0d02acc <io_usb_hid_receive+0x13c>)
c0d02ab6:	2100      	movs	r1, #0
c0d02ab8:	6001      	str	r1, [r0, #0]
c0d02aba:	4806      	ldr	r0, [pc, #24]	; (c0d02ad4 <io_usb_hid_receive+0x144>)
c0d02abc:	6001      	str	r1, [r0, #0]
c0d02abe:	4804      	ldr	r0, [pc, #16]	; (c0d02ad0 <io_usb_hid_receive+0x140>)
c0d02ac0:	6001      	str	r1, [r0, #0]
  return IO_USB_APDU_RECEIVED;

apdu_reset:
  io_usb_hid_init();
  return IO_USB_APDU_RESET;
}
c0d02ac2:	4638      	mov	r0, r7
c0d02ac4:	b001      	add	sp, #4
c0d02ac6:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d02ac8:	2000043c 	.word	0x2000043c
c0d02acc:	2000047c 	.word	0x2000047c
c0d02ad0:	20000484 	.word	0x20000484
c0d02ad4:	20000488 	.word	0x20000488
c0d02ad8:	20000480 	.word	0x20000480
c0d02adc:	2000048c 	.word	0x2000048c
c0d02ae0:	20000285 	.word	0x20000285

c0d02ae4 <io_usb_hid_init>:

void io_usb_hid_init(void) {
  G_io_usb_hid_sequence_number = 0; 
c0d02ae4:	4803      	ldr	r0, [pc, #12]	; (c0d02af4 <io_usb_hid_init+0x10>)
c0d02ae6:	2100      	movs	r1, #0
c0d02ae8:	6001      	str	r1, [r0, #0]
  G_io_usb_hid_remaining_length = 0;
  G_io_usb_hid_current_buffer = NULL;
c0d02aea:	4803      	ldr	r0, [pc, #12]	; (c0d02af8 <io_usb_hid_init+0x14>)
c0d02aec:	6001      	str	r1, [r0, #0]
  G_io_usb_hid_remaining_length = 0;
c0d02aee:	4803      	ldr	r0, [pc, #12]	; (c0d02afc <io_usb_hid_init+0x18>)
c0d02af0:	6001      	str	r1, [r0, #0]
}
c0d02af2:	4770      	bx	lr
c0d02af4:	2000047c 	.word	0x2000047c
c0d02af8:	20000488 	.word	0x20000488
c0d02afc:	20000484 	.word	0x20000484

c0d02b00 <io_usb_hid_sent>:

/**
 * sent the next io_usb_hid transport chunk (rx on the host, tx on the device)
 */
void io_usb_hid_sent(io_send_t sndfct) {
c0d02b00:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d02b02:	b081      	sub	sp, #4
  unsigned int l;

  // only prepare next chunk if some data to be sent remain
  if (G_io_usb_hid_remaining_length && G_io_usb_hid_current_buffer) {
c0d02b04:	4a27      	ldr	r2, [pc, #156]	; (c0d02ba4 <io_usb_hid_sent+0xa4>)
c0d02b06:	6815      	ldr	r5, [r2, #0]
c0d02b08:	4b27      	ldr	r3, [pc, #156]	; (c0d02ba8 <io_usb_hid_sent+0xa8>)
c0d02b0a:	6819      	ldr	r1, [r3, #0]
c0d02b0c:	2900      	cmp	r1, #0
c0d02b0e:	d021      	beq.n	c0d02b54 <io_usb_hid_sent+0x54>
c0d02b10:	2d00      	cmp	r5, #0
c0d02b12:	d01f      	beq.n	c0d02b54 <io_usb_hid_sent+0x54>
c0d02b14:	9000      	str	r0, [sp, #0]
    // fill the chunk
    memset(G_io_usb_ep_buffer, 0, sizeof(G_io_usb_ep_buffer));
c0d02b16:	4c27      	ldr	r4, [pc, #156]	; (c0d02bb4 <io_usb_hid_sent+0xb4>)
c0d02b18:	1d67      	adds	r7, r4, #5
c0d02b1a:	263b      	movs	r6, #59	; 0x3b
c0d02b1c:	4638      	mov	r0, r7
c0d02b1e:	4631      	mov	r1, r6
c0d02b20:	f005 fcf4 	bl	c0d0850c <__aeabi_memclr>
c0d02b24:	4a20      	ldr	r2, [pc, #128]	; (c0d02ba8 <io_usb_hid_sent+0xa8>)
c0d02b26:	2005      	movs	r0, #5

    // keep the channel identifier
    G_io_usb_ep_buffer[0] = (G_io_usb_hid_channel>>8)&0xFF;
    G_io_usb_ep_buffer[1] = G_io_usb_hid_channel&0xFF;
    G_io_usb_ep_buffer[2] = 0x05;
c0d02b28:	70a0      	strb	r0, [r4, #2]
    G_io_usb_ep_buffer[0] = (G_io_usb_hid_channel>>8)&0xFF;
c0d02b2a:	4823      	ldr	r0, [pc, #140]	; (c0d02bb8 <io_usb_hid_sent+0xb8>)
c0d02b2c:	6801      	ldr	r1, [r0, #0]
c0d02b2e:	0a09      	lsrs	r1, r1, #8
c0d02b30:	7021      	strb	r1, [r4, #0]
    G_io_usb_ep_buffer[1] = G_io_usb_hid_channel&0xFF;
c0d02b32:	6800      	ldr	r0, [r0, #0]
c0d02b34:	7060      	strb	r0, [r4, #1]
    G_io_usb_ep_buffer[3] = G_io_usb_hid_sequence_number>>8;
c0d02b36:	491d      	ldr	r1, [pc, #116]	; (c0d02bac <io_usb_hid_sent+0xac>)
c0d02b38:	6808      	ldr	r0, [r1, #0]
c0d02b3a:	0a00      	lsrs	r0, r0, #8
c0d02b3c:	70e0      	strb	r0, [r4, #3]
    G_io_usb_ep_buffer[4] = G_io_usb_hid_sequence_number;
c0d02b3e:	6808      	ldr	r0, [r1, #0]
c0d02b40:	7120      	strb	r0, [r4, #4]

    if (G_io_usb_hid_sequence_number == 0) {
c0d02b42:	6809      	ldr	r1, [r1, #0]
c0d02b44:	6810      	ldr	r0, [r2, #0]
c0d02b46:	2900      	cmp	r1, #0
c0d02b48:	d00c      	beq.n	c0d02b64 <io_usb_hid_sent+0x64>
      memmove(G_io_usb_ep_buffer+7, (const void*)G_io_usb_hid_current_buffer, l);
      G_io_usb_hid_current_buffer += l;
      G_io_usb_hid_remaining_length -= l;
    }
    else {
      l = ((G_io_usb_hid_remaining_length>IO_HID_EP_LENGTH-5) ? IO_HID_EP_LENGTH-5 : G_io_usb_hid_remaining_length);
c0d02b4a:	283b      	cmp	r0, #59	; 0x3b
c0d02b4c:	d800      	bhi.n	c0d02b50 <io_usb_hid_sent+0x50>
c0d02b4e:	6816      	ldr	r6, [r2, #0]
      memmove(G_io_usb_ep_buffer+5, (const void*)G_io_usb_hid_current_buffer, l);
c0d02b50:	4638      	mov	r0, r7
c0d02b52:	e012      	b.n	c0d02b7a <io_usb_hid_sent+0x7a>
  G_io_usb_hid_sequence_number = 0; 
c0d02b54:	4815      	ldr	r0, [pc, #84]	; (c0d02bac <io_usb_hid_sent+0xac>)
c0d02b56:	2100      	movs	r1, #0
c0d02b58:	6001      	str	r1, [r0, #0]
  G_io_usb_hid_current_buffer = NULL;
c0d02b5a:	6011      	str	r1, [r2, #0]
  // cleanup when everything has been sent (ack for the last sent usb in packet)
  else {
    io_usb_hid_init();

    // we sent the whole response
    G_io_app.apdu_state = APDU_IDLE;
c0d02b5c:	4814      	ldr	r0, [pc, #80]	; (c0d02bb0 <io_usb_hid_sent+0xb0>)
c0d02b5e:	7001      	strb	r1, [r0, #0]
  G_io_usb_hid_remaining_length = 0;
c0d02b60:	6019      	str	r1, [r3, #0]
c0d02b62:	e01d      	b.n	c0d02ba0 <io_usb_hid_sent+0xa0>
      l = ((G_io_usb_hid_remaining_length>IO_HID_EP_LENGTH-7) ? IO_HID_EP_LENGTH-7 : G_io_usb_hid_remaining_length);
c0d02b64:	2839      	cmp	r0, #57	; 0x39
c0d02b66:	d901      	bls.n	c0d02b6c <io_usb_hid_sent+0x6c>
c0d02b68:	2639      	movs	r6, #57	; 0x39
c0d02b6a:	e000      	b.n	c0d02b6e <io_usb_hid_sent+0x6e>
c0d02b6c:	6816      	ldr	r6, [r2, #0]
      G_io_usb_ep_buffer[5] = G_io_usb_hid_remaining_length>>8;
c0d02b6e:	6810      	ldr	r0, [r2, #0]
c0d02b70:	0a00      	lsrs	r0, r0, #8
c0d02b72:	7160      	strb	r0, [r4, #5]
      G_io_usb_ep_buffer[6] = G_io_usb_hid_remaining_length;
c0d02b74:	6810      	ldr	r0, [r2, #0]
c0d02b76:	71a0      	strb	r0, [r4, #6]
      memmove(G_io_usb_ep_buffer+7, (const void*)G_io_usb_hid_current_buffer, l);
c0d02b78:	1de0      	adds	r0, r4, #7
c0d02b7a:	4629      	mov	r1, r5
c0d02b7c:	4632      	mov	r2, r6
c0d02b7e:	f005 fcce 	bl	c0d0851e <__aeabi_memmove>
c0d02b82:	4b09      	ldr	r3, [pc, #36]	; (c0d02ba8 <io_usb_hid_sent+0xa8>)
c0d02b84:	9a00      	ldr	r2, [sp, #0]
c0d02b86:	4907      	ldr	r1, [pc, #28]	; (c0d02ba4 <io_usb_hid_sent+0xa4>)
c0d02b88:	6818      	ldr	r0, [r3, #0]
c0d02b8a:	1b80      	subs	r0, r0, r6
c0d02b8c:	6018      	str	r0, [r3, #0]
c0d02b8e:	19a8      	adds	r0, r5, r6
c0d02b90:	6008      	str	r0, [r1, #0]
c0d02b92:	4906      	ldr	r1, [pc, #24]	; (c0d02bac <io_usb_hid_sent+0xac>)
    G_io_usb_hid_sequence_number++;
c0d02b94:	6808      	ldr	r0, [r1, #0]
c0d02b96:	1c40      	adds	r0, r0, #1
c0d02b98:	6008      	str	r0, [r1, #0]
    sndfct(G_io_usb_ep_buffer, sizeof(G_io_usb_ep_buffer));
c0d02b9a:	4806      	ldr	r0, [pc, #24]	; (c0d02bb4 <io_usb_hid_sent+0xb4>)
c0d02b9c:	2140      	movs	r1, #64	; 0x40
c0d02b9e:	4790      	blx	r2
  }
}
c0d02ba0:	b001      	add	sp, #4
c0d02ba2:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d02ba4:	20000488 	.word	0x20000488
c0d02ba8:	20000484 	.word	0x20000484
c0d02bac:	2000047c 	.word	0x2000047c
c0d02bb0:	200003d8 	.word	0x200003d8
c0d02bb4:	2000043c 	.word	0x2000043c
c0d02bb8:	2000048c 	.word	0x2000048c

c0d02bbc <io_usb_hid_send>:

void io_usb_hid_send(io_send_t sndfct, unsigned short sndlength) {
c0d02bbc:	b580      	push	{r7, lr}
  // perform send
  if (sndlength) {
c0d02bbe:	2900      	cmp	r1, #0
c0d02bc0:	d00b      	beq.n	c0d02bda <io_usb_hid_send+0x1e>
    G_io_usb_hid_sequence_number = 0; 
c0d02bc2:	4a06      	ldr	r2, [pc, #24]	; (c0d02bdc <io_usb_hid_send+0x20>)
c0d02bc4:	2300      	movs	r3, #0
c0d02bc6:	6013      	str	r3, [r2, #0]
    G_io_usb_hid_current_buffer = G_io_apdu_buffer;
    G_io_usb_hid_remaining_length = sndlength;
c0d02bc8:	4a05      	ldr	r2, [pc, #20]	; (c0d02be0 <io_usb_hid_send+0x24>)
c0d02bca:	6011      	str	r1, [r2, #0]
    G_io_usb_hid_current_buffer = G_io_apdu_buffer;
c0d02bcc:	4a05      	ldr	r2, [pc, #20]	; (c0d02be4 <io_usb_hid_send+0x28>)
c0d02bce:	4b06      	ldr	r3, [pc, #24]	; (c0d02be8 <io_usb_hid_send+0x2c>)
c0d02bd0:	6013      	str	r3, [r2, #0]
    G_io_usb_hid_total_length = sndlength;
c0d02bd2:	4a06      	ldr	r2, [pc, #24]	; (c0d02bec <io_usb_hid_send+0x30>)
c0d02bd4:	6011      	str	r1, [r2, #0]
    io_usb_hid_sent(sndfct);
c0d02bd6:	f7ff ff93 	bl	c0d02b00 <io_usb_hid_sent>
  }
}
c0d02bda:	bd80      	pop	{r7, pc}
c0d02bdc:	2000047c 	.word	0x2000047c
c0d02be0:	20000484 	.word	0x20000484
c0d02be4:	20000488 	.word	0x20000488
c0d02be8:	20000285 	.word	0x20000285
c0d02bec:	20000480 	.word	0x20000480

c0d02bf0 <mcu_usb_prints>:
    mcu_usb_printc(*str++);
  }
}

#else
void mcu_usb_prints(const char* str, unsigned int charcount) {
c0d02bf0:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d02bf2:	b081      	sub	sp, #4
c0d02bf4:	460d      	mov	r5, r1
c0d02bf6:	4604      	mov	r4, r0
c0d02bf8:	209c      	movs	r0, #156	; 0x9c
  if(USBD_Device.dev_state != USBD_STATE_CONFIGURED){
c0d02bfa:	4911      	ldr	r1, [pc, #68]	; (c0d02c40 <mcu_usb_prints+0x50>)
c0d02bfc:	5c08      	ldrb	r0, [r1, r0]
c0d02bfe:	2803      	cmp	r0, #3
c0d02c00:	d11c      	bne.n	c0d02c3c <mcu_usb_prints+0x4c>
    return;
  }
  unsigned char buf[4];
  if(io_seproxyhal_spi_is_status_sent()){
c0d02c02:	f002 fceb 	bl	c0d055dc <io_seph_is_status_sent>
c0d02c06:	2800      	cmp	r0, #0
c0d02c08:	d004      	beq.n	c0d02c14 <mcu_usb_prints+0x24>
c0d02c0a:	4668      	mov	r0, sp
c0d02c0c:	2103      	movs	r1, #3
c0d02c0e:	2200      	movs	r2, #0
      io_seproxyhal_spi_recv(buf, 3, 0);
c0d02c10:	f002 fcf0 	bl	c0d055f4 <io_seph_recv>
c0d02c14:	466e      	mov	r6, sp
  }
  buf[0] = SEPROXYHAL_TAG_PRINTF_STATUS;
  buf[1] = charcount >> 8;
  buf[2] = charcount;
c0d02c16:	70b5      	strb	r5, [r6, #2]
c0d02c18:	2066      	movs	r0, #102	; 0x66
  buf[0] = SEPROXYHAL_TAG_PRINTF_STATUS;
c0d02c1a:	7030      	strb	r0, [r6, #0]
  buf[1] = charcount >> 8;
c0d02c1c:	0a28      	lsrs	r0, r5, #8
c0d02c1e:	7070      	strb	r0, [r6, #1]
c0d02c20:	2703      	movs	r7, #3
  io_seproxyhal_spi_send(buf, 3);
c0d02c22:	4630      	mov	r0, r6
c0d02c24:	4639      	mov	r1, r7
c0d02c26:	f002 fccd 	bl	c0d055c4 <io_seph_send>
  io_seproxyhal_spi_send((unsigned char*)str, charcount);
c0d02c2a:	b2a9      	uxth	r1, r5
c0d02c2c:	4620      	mov	r0, r4
c0d02c2e:	f002 fcc9 	bl	c0d055c4 <io_seph_send>
c0d02c32:	2200      	movs	r2, #0
#ifndef IO_SEPROXYHAL_DEBUG
  // wait printf ack (no race kthx)
  io_seproxyhal_spi_recv(buf, 3, 0);
c0d02c34:	4630      	mov	r0, r6
c0d02c36:	4639      	mov	r1, r7
c0d02c38:	f002 fcdc 	bl	c0d055f4 <io_seph_recv>
  buf[0] = 0; // consume tag to avoid misinterpretation (due to IO_CACHE)
#endif // IO_SEPROXYHAL_DEBUG
}
c0d02c3c:	b001      	add	sp, #4
c0d02c3e:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d02c40:	200009e0 	.word	0x200009e0

c0d02c44 <mcu_usb_printf>:
 * - screen_printc
 */

void screen_printf(const char* format, ...) __attribute__ ((weak, alias ("mcu_usb_printf")));

void mcu_usb_printf(const char* format, ...) {
c0d02c44:	b083      	sub	sp, #12
c0d02c46:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d02c48:	b08c      	sub	sp, #48	; 0x30
c0d02c4a:	ac11      	add	r4, sp, #68	; 0x44
c0d02c4c:	c40e      	stmia	r4!, {r1, r2, r3}
    char cStrlenSet;

    //
    // Check the arguments.
    //
    if(format == 0) {
c0d02c4e:	2800      	cmp	r0, #0
c0d02c50:	d100      	bne.n	c0d02c54 <mcu_usb_printf+0x10>
c0d02c52:	e166      	b.n	c0d02f22 <mcu_usb_printf+0x2de>
c0d02c54:	4604      	mov	r4, r0
c0d02c56:	a811      	add	r0, sp, #68	; 0x44
    }

    //
    // Start the varargs processing.
    //
    va_start(vaArgP, format);
c0d02c58:	9006      	str	r0, [sp, #24]

    //
    // Loop while there are more characters in the string.
    //
    while(*format)
c0d02c5a:	7820      	ldrb	r0, [r4, #0]
c0d02c5c:	2800      	cmp	r0, #0
c0d02c5e:	d100      	bne.n	c0d02c62 <mcu_usb_printf+0x1e>
c0d02c60:	e15f      	b.n	c0d02f22 <mcu_usb_printf+0x2de>
c0d02c62:	2500      	movs	r5, #0
    {
        //
        // Find the first non-% character, or the end of the string.
        //
        for(ulIdx = 0; (format[ulIdx] != '%') && (format[ulIdx] != '\0');
c0d02c64:	2800      	cmp	r0, #0
c0d02c66:	d005      	beq.n	c0d02c74 <mcu_usb_printf+0x30>
c0d02c68:	2825      	cmp	r0, #37	; 0x25
c0d02c6a:	d003      	beq.n	c0d02c74 <mcu_usb_printf+0x30>
c0d02c6c:	1960      	adds	r0, r4, r5
c0d02c6e:	7840      	ldrb	r0, [r0, #1]
            ulIdx++)
c0d02c70:	1c6d      	adds	r5, r5, #1
c0d02c72:	e7f7      	b.n	c0d02c64 <mcu_usb_printf+0x20>
        }

        //
        // Write this portion of the string.
        //
        mcu_usb_prints(format, ulIdx);
c0d02c74:	4620      	mov	r0, r4
c0d02c76:	4629      	mov	r1, r5
c0d02c78:	f7ff ffba 	bl	c0d02bf0 <mcu_usb_prints>
        format += ulIdx;

        //
        // See if the next character is a %.
        //
        if(*format == '%')
c0d02c7c:	5d60      	ldrb	r0, [r4, r5]
c0d02c7e:	2825      	cmp	r0, #37	; 0x25
c0d02c80:	d001      	beq.n	c0d02c86 <mcu_usb_printf+0x42>
c0d02c82:	1964      	adds	r4, r4, r5
c0d02c84:	e7ea      	b.n	c0d02c5c <mcu_usb_printf+0x18>
            ulCount = 0;
            cFill = ' ';
            ulStrlen = 0;
            cStrlenSet = 0;
            ulCap = 0;
            ulBase = 10;
c0d02c86:	1960      	adds	r0, r4, r5
c0d02c88:	1c44      	adds	r4, r0, #1
c0d02c8a:	2600      	movs	r6, #0
c0d02c8c:	2020      	movs	r0, #32
c0d02c8e:	9004      	str	r0, [sp, #16]
c0d02c90:	200a      	movs	r0, #10
c0d02c92:	9605      	str	r6, [sp, #20]
c0d02c94:	9602      	str	r6, [sp, #8]
c0d02c96:	4633      	mov	r3, r6
c0d02c98:	4619      	mov	r1, r3
again:

            //
            // Determine how to handle the next character.
            //
            switch(*format++)
c0d02c9a:	7822      	ldrb	r2, [r4, #0]
c0d02c9c:	1c64      	adds	r4, r4, #1
c0d02c9e:	2300      	movs	r3, #0
c0d02ca0:	2a2d      	cmp	r2, #45	; 0x2d
c0d02ca2:	d0f9      	beq.n	c0d02c98 <mcu_usb_printf+0x54>
c0d02ca4:	2a47      	cmp	r2, #71	; 0x47
c0d02ca6:	dc13      	bgt.n	c0d02cd0 <mcu_usb_printf+0x8c>
c0d02ca8:	2a2f      	cmp	r2, #47	; 0x2f
c0d02caa:	dd1e      	ble.n	c0d02cea <mcu_usb_printf+0xa6>
c0d02cac:	4613      	mov	r3, r2
c0d02cae:	3b30      	subs	r3, #48	; 0x30
c0d02cb0:	2b0a      	cmp	r3, #10
c0d02cb2:	d300      	bcc.n	c0d02cb6 <mcu_usb_printf+0x72>
c0d02cb4:	e0ab      	b.n	c0d02e0e <mcu_usb_printf+0x1ca>
c0d02cb6:	2330      	movs	r3, #48	; 0x30
                {
                    //
                    // If this is a zero, and it is the first digit, then the
                    // fill character is a zero instead of a space.
                    //
                    if((format[-1] == '0') && (ulCount == 0))
c0d02cb8:	4617      	mov	r7, r2
c0d02cba:	405f      	eors	r7, r3
c0d02cbc:	4337      	orrs	r7, r6
c0d02cbe:	d000      	beq.n	c0d02cc2 <mcu_usb_printf+0x7e>
c0d02cc0:	9b04      	ldr	r3, [sp, #16]
c0d02cc2:	270a      	movs	r7, #10
                    }

                    //
                    // Update the digit count.
                    //
                    ulCount *= 10;
c0d02cc4:	4377      	muls	r7, r6
                    ulCount += format[-1] - '0';
c0d02cc6:	18be      	adds	r6, r7, r2
c0d02cc8:	3e30      	subs	r6, #48	; 0x30
c0d02cca:	9304      	str	r3, [sp, #16]
c0d02ccc:	460b      	mov	r3, r1
c0d02cce:	e7e3      	b.n	c0d02c98 <mcu_usb_printf+0x54>
            switch(*format++)
c0d02cd0:	2a67      	cmp	r2, #103	; 0x67
c0d02cd2:	dd04      	ble.n	c0d02cde <mcu_usb_printf+0x9a>
c0d02cd4:	2a72      	cmp	r2, #114	; 0x72
c0d02cd6:	dd1d      	ble.n	c0d02d14 <mcu_usb_printf+0xd0>
c0d02cd8:	2a73      	cmp	r2, #115	; 0x73
c0d02cda:	d135      	bne.n	c0d02d48 <mcu_usb_printf+0x104>
c0d02cdc:	e01f      	b.n	c0d02d1e <mcu_usb_printf+0xda>
c0d02cde:	2a62      	cmp	r2, #98	; 0x62
c0d02ce0:	dc37      	bgt.n	c0d02d52 <mcu_usb_printf+0x10e>
c0d02ce2:	2a48      	cmp	r2, #72	; 0x48
c0d02ce4:	d16d      	bne.n	c0d02dc2 <mcu_usb_printf+0x17e>
c0d02ce6:	2001      	movs	r0, #1
c0d02ce8:	e017      	b.n	c0d02d1a <mcu_usb_printf+0xd6>
c0d02cea:	2a25      	cmp	r2, #37	; 0x25
c0d02cec:	d079      	beq.n	c0d02de2 <mcu_usb_printf+0x19e>
c0d02cee:	2a2a      	cmp	r2, #42	; 0x2a
c0d02cf0:	d020      	beq.n	c0d02d34 <mcu_usb_printf+0xf0>
c0d02cf2:	2a2e      	cmp	r2, #46	; 0x2e
c0d02cf4:	d000      	beq.n	c0d02cf8 <mcu_usb_printf+0xb4>
c0d02cf6:	e08a      	b.n	c0d02e0e <mcu_usb_printf+0x1ca>
                // special %.*H or %.*h format to print a given length of hex digits (case: H UPPER, h lower)
                //
                case '.':
                {
                  // ensure next char is '*' and next one is 's'
                  if (format[0] == '*' && (format[1] == 's' || format[1] == 'H' || format[1] == 'h')) {
c0d02cf8:	7821      	ldrb	r1, [r4, #0]
c0d02cfa:	292a      	cmp	r1, #42	; 0x2a
c0d02cfc:	d000      	beq.n	c0d02d00 <mcu_usb_printf+0xbc>
c0d02cfe:	e086      	b.n	c0d02e0e <mcu_usb_printf+0x1ca>
c0d02d00:	7861      	ldrb	r1, [r4, #1]
c0d02d02:	2948      	cmp	r1, #72	; 0x48
c0d02d04:	d003      	beq.n	c0d02d0e <mcu_usb_printf+0xca>
c0d02d06:	2973      	cmp	r1, #115	; 0x73
c0d02d08:	d001      	beq.n	c0d02d0e <mcu_usb_printf+0xca>
c0d02d0a:	2968      	cmp	r1, #104	; 0x68
c0d02d0c:	d17f      	bne.n	c0d02e0e <mcu_usb_printf+0x1ca>
c0d02d0e:	1c64      	adds	r4, r4, #1
c0d02d10:	2301      	movs	r3, #1
c0d02d12:	e013      	b.n	c0d02d3c <mcu_usb_printf+0xf8>
            switch(*format++)
c0d02d14:	2a68      	cmp	r2, #104	; 0x68
c0d02d16:	d159      	bne.n	c0d02dcc <mcu_usb_printf+0x188>
c0d02d18:	2000      	movs	r0, #0
c0d02d1a:	9002      	str	r0, [sp, #8]
c0d02d1c:	2010      	movs	r0, #16
                case_s:
                {
                    //
                    // Get the string pointer from the varargs.
                    //
                    pcStr = va_arg(vaArgP, char *);
c0d02d1e:	9b06      	ldr	r3, [sp, #24]
c0d02d20:	1d1a      	adds	r2, r3, #4
c0d02d22:	9206      	str	r2, [sp, #24]

                    //
                    // Determine the length of the string. (if not specified using .*)
                    //
                    switch(cStrlenSet) {
c0d02d24:	b2ca      	uxtb	r2, r1
                    pcStr = va_arg(vaArgP, char *);
c0d02d26:	681f      	ldr	r7, [r3, #0]
                    switch(cStrlenSet) {
c0d02d28:	2a01      	cmp	r2, #1
c0d02d2a:	dd20      	ble.n	c0d02d6e <mcu_usb_printf+0x12a>
c0d02d2c:	2a02      	cmp	r2, #2
c0d02d2e:	460b      	mov	r3, r1
c0d02d30:	d1b2      	bne.n	c0d02c98 <mcu_usb_printf+0x54>
c0d02d32:	e069      	b.n	c0d02e08 <mcu_usb_printf+0x1c4>
                  if (*format == 's' ) {                    
c0d02d34:	7821      	ldrb	r1, [r4, #0]
c0d02d36:	2973      	cmp	r1, #115	; 0x73
c0d02d38:	d169      	bne.n	c0d02e0e <mcu_usb_printf+0x1ca>
c0d02d3a:	2302      	movs	r3, #2
c0d02d3c:	9906      	ldr	r1, [sp, #24]
c0d02d3e:	1d0a      	adds	r2, r1, #4
c0d02d40:	9206      	str	r2, [sp, #24]
c0d02d42:	6809      	ldr	r1, [r1, #0]
            switch(*format++)
c0d02d44:	9105      	str	r1, [sp, #20]
c0d02d46:	e7a7      	b.n	c0d02c98 <mcu_usb_printf+0x54>
c0d02d48:	2a75      	cmp	r2, #117	; 0x75
c0d02d4a:	d04c      	beq.n	c0d02de6 <mcu_usb_printf+0x1a2>
c0d02d4c:	2a78      	cmp	r2, #120	; 0x78
c0d02d4e:	d03f      	beq.n	c0d02dd0 <mcu_usb_printf+0x18c>
c0d02d50:	e05d      	b.n	c0d02e0e <mcu_usb_printf+0x1ca>
c0d02d52:	2a63      	cmp	r2, #99	; 0x63
c0d02d54:	d050      	beq.n	c0d02df8 <mcu_usb_printf+0x1b4>
c0d02d56:	2a64      	cmp	r2, #100	; 0x64
c0d02d58:	d159      	bne.n	c0d02e0e <mcu_usb_printf+0x1ca>
                    ulValue = va_arg(vaArgP, unsigned long);
c0d02d5a:	9806      	ldr	r0, [sp, #24]
c0d02d5c:	1d01      	adds	r1, r0, #4
c0d02d5e:	9106      	str	r1, [sp, #24]
c0d02d60:	6805      	ldr	r5, [r0, #0]
c0d02d62:	950b      	str	r5, [sp, #44]	; 0x2c
c0d02d64:	200a      	movs	r0, #10
                    if((long)ulValue < 0)
c0d02d66:	2d00      	cmp	r5, #0
c0d02d68:	d45a      	bmi.n	c0d02e20 <mcu_usb_printf+0x1dc>
c0d02d6a:	2100      	movs	r1, #0
c0d02d6c:	e05b      	b.n	c0d02e26 <mcu_usb_printf+0x1e2>
                    switch(cStrlenSet) {
c0d02d6e:	2a00      	cmp	r2, #0
c0d02d70:	9b02      	ldr	r3, [sp, #8]
c0d02d72:	9d05      	ldr	r5, [sp, #20]
c0d02d74:	d105      	bne.n	c0d02d82 <mcu_usb_printf+0x13e>
c0d02d76:	2100      	movs	r1, #0
                      // compute length with strlen
                      case 0:
                        for(ulIdx = 0; pcStr[ulIdx] != '\0'; ulIdx++)
c0d02d78:	5c7a      	ldrb	r2, [r7, r1]
c0d02d7a:	1c49      	adds	r1, r1, #1
c0d02d7c:	2a00      	cmp	r2, #0
c0d02d7e:	d1fb      	bne.n	c0d02d78 <mcu_usb_printf+0x134>
                    }

                    //
                    // Write the string.
                    //
                    switch(ulBase) {
c0d02d80:	1e4d      	subs	r5, r1, #1
c0d02d82:	2810      	cmp	r0, #16
c0d02d84:	d147      	bne.n	c0d02e16 <mcu_usb_printf+0x1d2>
                      default:
                        mcu_usb_prints(pcStr, ulIdx);
                        break;
                      case 16: {
                        unsigned char nibble1, nibble2;
                        for (ulCount = 0; ulCount < ulIdx; ulCount++) {
c0d02d86:	2d00      	cmp	r5, #0
c0d02d88:	d100      	bne.n	c0d02d8c <mcu_usb_printf+0x148>
c0d02d8a:	e766      	b.n	c0d02c5a <mcu_usb_printf+0x16>
                          nibble1 = (pcStr[ulCount]>>4)&0xF;
c0d02d8c:	7838      	ldrb	r0, [r7, #0]
                          nibble2 = pcStr[ulCount]&0xF;
                          switch(ulCap) {
c0d02d8e:	2b00      	cmp	r3, #0
c0d02d90:	d005      	beq.n	c0d02d9e <mcu_usb_printf+0x15a>
c0d02d92:	2b01      	cmp	r3, #1
c0d02d94:	d111      	bne.n	c0d02dba <mcu_usb_printf+0x176>
c0d02d96:	9505      	str	r5, [sp, #20]
c0d02d98:	4d67      	ldr	r5, [pc, #412]	; (c0d02f38 <mcu_usb_printf+0x2f4>)
c0d02d9a:	447d      	add	r5, pc
c0d02d9c:	e002      	b.n	c0d02da4 <mcu_usb_printf+0x160>
c0d02d9e:	9505      	str	r5, [sp, #20]
c0d02da0:	4d63      	ldr	r5, [pc, #396]	; (c0d02f30 <mcu_usb_printf+0x2ec>)
c0d02da2:	447d      	add	r5, pc
c0d02da4:	260f      	movs	r6, #15
c0d02da6:	4006      	ands	r6, r0
c0d02da8:	0900      	lsrs	r0, r0, #4
c0d02daa:	5c28      	ldrb	r0, [r5, r0]
c0d02dac:	f7ff fdc0 	bl	c0d02930 <mcu_usb_printc>
c0d02db0:	5da8      	ldrb	r0, [r5, r6]
c0d02db2:	f7ff fdbd 	bl	c0d02930 <mcu_usb_printc>
c0d02db6:	9b02      	ldr	r3, [sp, #8]
c0d02db8:	9d05      	ldr	r5, [sp, #20]
                        for (ulCount = 0; ulCount < ulIdx; ulCount++) {
c0d02dba:	1c7f      	adds	r7, r7, #1
c0d02dbc:	1e6d      	subs	r5, r5, #1
c0d02dbe:	d1e5      	bne.n	c0d02d8c <mcu_usb_printf+0x148>
c0d02dc0:	e74b      	b.n	c0d02c5a <mcu_usb_printf+0x16>
            switch(*format++)
c0d02dc2:	2a58      	cmp	r2, #88	; 0x58
c0d02dc4:	d123      	bne.n	c0d02e0e <mcu_usb_printf+0x1ca>
c0d02dc6:	2001      	movs	r0, #1
c0d02dc8:	9002      	str	r0, [sp, #8]
c0d02dca:	e001      	b.n	c0d02dd0 <mcu_usb_printf+0x18c>
c0d02dcc:	2a70      	cmp	r2, #112	; 0x70
c0d02dce:	d11e      	bne.n	c0d02e0e <mcu_usb_printf+0x1ca>
                case 'p':
                {
                    //
                    // Get the value from the varargs.
                    //
                    ulValue = va_arg(vaArgP, unsigned long);
c0d02dd0:	9806      	ldr	r0, [sp, #24]
c0d02dd2:	1d01      	adds	r1, r0, #4
c0d02dd4:	9106      	str	r1, [sp, #24]
c0d02dd6:	6805      	ldr	r5, [r0, #0]
c0d02dd8:	950b      	str	r5, [sp, #44]	; 0x2c
c0d02dda:	2000      	movs	r0, #0
c0d02ddc:	9001      	str	r0, [sp, #4]
c0d02dde:	2010      	movs	r0, #16
c0d02de0:	e022      	b.n	c0d02e28 <mcu_usb_printf+0x1e4>
                case '%':
                {
                    //
                    // Simply write a single %.
                    //
                    mcu_usb_prints(format - 1, 1);
c0d02de2:	1e60      	subs	r0, r4, #1
c0d02de4:	e00e      	b.n	c0d02e04 <mcu_usb_printf+0x1c0>
                    ulValue = va_arg(vaArgP, unsigned long);
c0d02de6:	9806      	ldr	r0, [sp, #24]
c0d02de8:	1d01      	adds	r1, r0, #4
c0d02dea:	9106      	str	r1, [sp, #24]
c0d02dec:	6805      	ldr	r5, [r0, #0]
c0d02dee:	950b      	str	r5, [sp, #44]	; 0x2c
c0d02df0:	2000      	movs	r0, #0
c0d02df2:	9001      	str	r0, [sp, #4]
c0d02df4:	200a      	movs	r0, #10
c0d02df6:	e017      	b.n	c0d02e28 <mcu_usb_printf+0x1e4>
                    ulValue = va_arg(vaArgP, unsigned long);
c0d02df8:	9806      	ldr	r0, [sp, #24]
c0d02dfa:	1d01      	adds	r1, r0, #4
c0d02dfc:	9106      	str	r1, [sp, #24]
c0d02dfe:	6800      	ldr	r0, [r0, #0]
c0d02e00:	900b      	str	r0, [sp, #44]	; 0x2c
c0d02e02:	a80b      	add	r0, sp, #44	; 0x2c
c0d02e04:	2101      	movs	r1, #1
c0d02e06:	e071      	b.n	c0d02eec <mcu_usb_printf+0x2a8>
                        if (pcStr[0] == '\0') {
c0d02e08:	7838      	ldrb	r0, [r7, #0]
c0d02e0a:	2800      	cmp	r0, #0
c0d02e0c:	d071      	beq.n	c0d02ef2 <mcu_usb_printf+0x2ae>
                default:
                {
                    //
                    // Indicate an error.
                    //
                    mcu_usb_prints("ERROR", 5);
c0d02e0e:	4847      	ldr	r0, [pc, #284]	; (c0d02f2c <mcu_usb_printf+0x2e8>)
c0d02e10:	4478      	add	r0, pc
c0d02e12:	2105      	movs	r1, #5
c0d02e14:	e06a      	b.n	c0d02eec <mcu_usb_printf+0x2a8>
                        mcu_usb_prints(pcStr, ulIdx);
c0d02e16:	4638      	mov	r0, r7
c0d02e18:	4629      	mov	r1, r5
c0d02e1a:	f7ff fee9 	bl	c0d02bf0 <mcu_usb_prints>
c0d02e1e:	e071      	b.n	c0d02f04 <mcu_usb_printf+0x2c0>
                        ulValue = -(long)ulValue;
c0d02e20:	426d      	negs	r5, r5
c0d02e22:	950b      	str	r5, [sp, #44]	; 0x2c
c0d02e24:	2101      	movs	r1, #1
c0d02e26:	9101      	str	r1, [sp, #4]
                        (((ulIdx * ulBase) <= ulValue) &&
c0d02e28:	42a8      	cmp	r0, r5
c0d02e2a:	9003      	str	r0, [sp, #12]
c0d02e2c:	d901      	bls.n	c0d02e32 <mcu_usb_printf+0x1ee>
c0d02e2e:	2701      	movs	r7, #1
c0d02e30:	e00f      	b.n	c0d02e52 <mcu_usb_printf+0x20e>
                    for(ulIdx = 1;
c0d02e32:	1e72      	subs	r2, r6, #1
c0d02e34:	4607      	mov	r7, r0
c0d02e36:	4616      	mov	r6, r2
c0d02e38:	2100      	movs	r1, #0
                        (((ulIdx * ulBase) <= ulValue) &&
c0d02e3a:	9803      	ldr	r0, [sp, #12]
c0d02e3c:	463a      	mov	r2, r7
c0d02e3e:	460b      	mov	r3, r1
c0d02e40:	f005 fa40 	bl	c0d082c4 <__aeabi_lmul>
c0d02e44:	1e4a      	subs	r2, r1, #1
c0d02e46:	4191      	sbcs	r1, r2
c0d02e48:	42a8      	cmp	r0, r5
c0d02e4a:	d802      	bhi.n	c0d02e52 <mcu_usb_printf+0x20e>
                    for(ulIdx = 1;
c0d02e4c:	1e72      	subs	r2, r6, #1
c0d02e4e:	2900      	cmp	r1, #0
c0d02e50:	d0f0      	beq.n	c0d02e34 <mcu_usb_printf+0x1f0>
c0d02e52:	9801      	ldr	r0, [sp, #4]
                    if(ulNeg)
c0d02e54:	2800      	cmp	r0, #0
c0d02e56:	9505      	str	r5, [sp, #20]
c0d02e58:	d000      	beq.n	c0d02e5c <mcu_usb_printf+0x218>
c0d02e5a:	1e76      	subs	r6, r6, #1
c0d02e5c:	9a04      	ldr	r2, [sp, #16]
c0d02e5e:	2500      	movs	r5, #0
                    if(ulNeg && (cFill == '0'))
c0d02e60:	2800      	cmp	r0, #0
c0d02e62:	d009      	beq.n	c0d02e78 <mcu_usb_printf+0x234>
c0d02e64:	b2d0      	uxtb	r0, r2
c0d02e66:	2830      	cmp	r0, #48	; 0x30
c0d02e68:	d108      	bne.n	c0d02e7c <mcu_usb_printf+0x238>
c0d02e6a:	a807      	add	r0, sp, #28
c0d02e6c:	212d      	movs	r1, #45	; 0x2d
                        pcBuf[ulPos++] = '-';
c0d02e6e:	7001      	strb	r1, [r0, #0]
c0d02e70:	2001      	movs	r0, #1
c0d02e72:	4629      	mov	r1, r5
c0d02e74:	4605      	mov	r5, r0
c0d02e76:	e002      	b.n	c0d02e7e <mcu_usb_printf+0x23a>
c0d02e78:	4629      	mov	r1, r5
c0d02e7a:	e000      	b.n	c0d02e7e <mcu_usb_printf+0x23a>
c0d02e7c:	2101      	movs	r1, #1
                    if((ulCount > 1) && (ulCount < 16))
c0d02e7e:	1eb0      	subs	r0, r6, #2
c0d02e80:	280d      	cmp	r0, #13
c0d02e82:	d80c      	bhi.n	c0d02e9e <mcu_usb_printf+0x25a>
c0d02e84:	a807      	add	r0, sp, #28
                        for(ulCount--; ulCount; ulCount--)
c0d02e86:	1940      	adds	r0, r0, r5
c0d02e88:	1e76      	subs	r6, r6, #1
                            pcBuf[ulPos++] = cFill;
c0d02e8a:	b2d2      	uxtb	r2, r2
c0d02e8c:	9104      	str	r1, [sp, #16]
c0d02e8e:	4631      	mov	r1, r6
c0d02e90:	f005 fb49 	bl	c0d08526 <__aeabi_memset>
c0d02e94:	9904      	ldr	r1, [sp, #16]
c0d02e96:	1e76      	subs	r6, r6, #1
c0d02e98:	1c6d      	adds	r5, r5, #1
                        for(ulCount--; ulCount; ulCount--)
c0d02e9a:	2e00      	cmp	r6, #0
c0d02e9c:	d1fb      	bne.n	c0d02e96 <mcu_usb_printf+0x252>
                    if(ulNeg)
c0d02e9e:	2900      	cmp	r1, #0
c0d02ea0:	d003      	beq.n	c0d02eaa <mcu_usb_printf+0x266>
c0d02ea2:	a807      	add	r0, sp, #28
c0d02ea4:	212d      	movs	r1, #45	; 0x2d
                        pcBuf[ulPos++] = '-';
c0d02ea6:	5541      	strb	r1, [r0, r5]
c0d02ea8:	1c6d      	adds	r5, r5, #1
                    for(; ulIdx; ulIdx /= ulBase)
c0d02eaa:	2f00      	cmp	r7, #0
c0d02eac:	d01c      	beq.n	c0d02ee8 <mcu_usb_printf+0x2a4>
c0d02eae:	9802      	ldr	r0, [sp, #8]
c0d02eb0:	2800      	cmp	r0, #0
c0d02eb2:	d002      	beq.n	c0d02eba <mcu_usb_printf+0x276>
c0d02eb4:	4823      	ldr	r0, [pc, #140]	; (c0d02f44 <mcu_usb_printf+0x300>)
c0d02eb6:	4478      	add	r0, pc
c0d02eb8:	e001      	b.n	c0d02ebe <mcu_usb_printf+0x27a>
c0d02eba:	4821      	ldr	r0, [pc, #132]	; (c0d02f40 <mcu_usb_printf+0x2fc>)
c0d02ebc:	4478      	add	r0, pc
c0d02ebe:	9004      	str	r0, [sp, #16]
c0d02ec0:	9e03      	ldr	r6, [sp, #12]
c0d02ec2:	9805      	ldr	r0, [sp, #20]
c0d02ec4:	4639      	mov	r1, r7
c0d02ec6:	f005 f951 	bl	c0d0816c <__udivsi3>
c0d02eca:	4631      	mov	r1, r6
c0d02ecc:	f005 f9d4 	bl	c0d08278 <__aeabi_uidivmod>
c0d02ed0:	9804      	ldr	r0, [sp, #16]
c0d02ed2:	5c40      	ldrb	r0, [r0, r1]
c0d02ed4:	a907      	add	r1, sp, #28
                          pcBuf[ulPos++] = g_pcHex[(ulValue / ulIdx) % ulBase];
c0d02ed6:	5548      	strb	r0, [r1, r5]
                    for(; ulIdx; ulIdx /= ulBase)
c0d02ed8:	4638      	mov	r0, r7
c0d02eda:	4631      	mov	r1, r6
c0d02edc:	f005 f946 	bl	c0d0816c <__udivsi3>
c0d02ee0:	1c6d      	adds	r5, r5, #1
c0d02ee2:	42be      	cmp	r6, r7
c0d02ee4:	4607      	mov	r7, r0
c0d02ee6:	d9ec      	bls.n	c0d02ec2 <mcu_usb_printf+0x27e>
c0d02ee8:	a807      	add	r0, sp, #28
                    mcu_usb_prints(pcBuf, ulPos);
c0d02eea:	4629      	mov	r1, r5
c0d02eec:	f7ff fe80 	bl	c0d02bf0 <mcu_usb_prints>
c0d02ef0:	e6b3      	b.n	c0d02c5a <mcu_usb_printf+0x16>
                          do {
c0d02ef2:	9805      	ldr	r0, [sp, #20]
c0d02ef4:	1c47      	adds	r7, r0, #1
                            mcu_usb_prints(" ", 1);
c0d02ef6:	480f      	ldr	r0, [pc, #60]	; (c0d02f34 <mcu_usb_printf+0x2f0>)
c0d02ef8:	4478      	add	r0, pc
c0d02efa:	2101      	movs	r1, #1
c0d02efc:	f7ff fe78 	bl	c0d02bf0 <mcu_usb_prints>
                          } while(ulStrlen-- > 0);
c0d02f00:	1e7f      	subs	r7, r7, #1
c0d02f02:	d1f8      	bne.n	c0d02ef6 <mcu_usb_printf+0x2b2>
                    if(ulCount > ulIdx)
c0d02f04:	42ae      	cmp	r6, r5
c0d02f06:	d800      	bhi.n	c0d02f0a <mcu_usb_printf+0x2c6>
c0d02f08:	e6a7      	b.n	c0d02c5a <mcu_usb_printf+0x16>
                        ulCount -= ulIdx;
c0d02f0a:	1b70      	subs	r0, r6, r5
c0d02f0c:	d100      	bne.n	c0d02f10 <mcu_usb_printf+0x2cc>
c0d02f0e:	e6a4      	b.n	c0d02c5a <mcu_usb_printf+0x16>
                        while(ulCount--)
c0d02f10:	1bad      	subs	r5, r5, r6
                            mcu_usb_prints(" ", 1);
c0d02f12:	480a      	ldr	r0, [pc, #40]	; (c0d02f3c <mcu_usb_printf+0x2f8>)
c0d02f14:	4478      	add	r0, pc
c0d02f16:	2101      	movs	r1, #1
c0d02f18:	f7ff fe6a 	bl	c0d02bf0 <mcu_usb_prints>
                        while(ulCount--)
c0d02f1c:	1c6d      	adds	r5, r5, #1
c0d02f1e:	d3f8      	bcc.n	c0d02f12 <mcu_usb_printf+0x2ce>
c0d02f20:	e69b      	b.n	c0d02c5a <mcu_usb_printf+0x16>

    //
    // End the varargs processing.
    //
    va_end(vaArgP);
}
c0d02f22:	b00c      	add	sp, #48	; 0x30
c0d02f24:	bcf0      	pop	{r4, r5, r6, r7}
c0d02f26:	bc01      	pop	{r0}
c0d02f28:	b003      	add	sp, #12
c0d02f2a:	4700      	bx	r0
c0d02f2c:	00006536 	.word	0x00006536
c0d02f30:	000065aa 	.word	0x000065aa
c0d02f34:	00005ace 	.word	0x00005ace
c0d02f38:	000065c2 	.word	0x000065c2
c0d02f3c:	00005ab2 	.word	0x00005ab2
c0d02f40:	00006490 	.word	0x00006490
c0d02f44:	000064a6 	.word	0x000064a6

c0d02f48 <snprintf>:
#endif // HAVE_PRINTF

#ifdef HAVE_SPRINTF
//unsigned int snprintf(unsigned char * str, unsigned int str_size, const char* format, ...)
int snprintf(char * str, size_t str_size, const char * format, ...)
 {
c0d02f48:	b081      	sub	sp, #4
c0d02f4a:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d02f4c:	b08e      	sub	sp, #56	; 0x38
c0d02f4e:	9313      	str	r3, [sp, #76]	; 0x4c
c0d02f50:	9008      	str	r0, [sp, #32]
    char cStrlenSet;
    
    //
    // Check the arguments.
    //
    if(str == NULL ||str_size < 2) {
c0d02f52:	2800      	cmp	r0, #0
c0d02f54:	d100      	bne.n	c0d02f58 <snprintf+0x10>
c0d02f56:	e1d9      	b.n	c0d0330c <snprintf+0x3c4>
c0d02f58:	460d      	mov	r5, r1
c0d02f5a:	2902      	cmp	r1, #2
c0d02f5c:	d200      	bcs.n	c0d02f60 <snprintf+0x18>
c0d02f5e:	e1d5      	b.n	c0d0330c <snprintf+0x3c4>
c0d02f60:	4614      	mov	r4, r2
      return 0;
    }

    // ensure terminating string with a \0
    memset(str, 0, str_size);
c0d02f62:	9808      	ldr	r0, [sp, #32]
c0d02f64:	4629      	mov	r1, r5
c0d02f66:	f005 fad1 	bl	c0d0850c <__aeabi_memclr>
c0d02f6a:	a813      	add	r0, sp, #76	; 0x4c


    //
    // Start the varargs processing.
    //
    va_start(vaArgP, format);
c0d02f6c:	9009      	str	r0, [sp, #36]	; 0x24

    //
    // Loop while there are more characters in the string.
    //
    while(*format)
c0d02f6e:	7821      	ldrb	r1, [r4, #0]
c0d02f70:	2900      	cmp	r1, #0
c0d02f72:	d100      	bne.n	c0d02f76 <snprintf+0x2e>
c0d02f74:	e1ca      	b.n	c0d0330c <snprintf+0x3c4>
    str_size--;
c0d02f76:	1e6b      	subs	r3, r5, #1
c0d02f78:	2700      	movs	r7, #0
    {
        //
        // Find the first non-% character, or the end of the string.
        //
        for(ulIdx = 0; (format[ulIdx] != '%') && (format[ulIdx] != '\0');
c0d02f7a:	2900      	cmp	r1, #0
c0d02f7c:	d005      	beq.n	c0d02f8a <snprintf+0x42>
c0d02f7e:	2925      	cmp	r1, #37	; 0x25
c0d02f80:	d003      	beq.n	c0d02f8a <snprintf+0x42>
c0d02f82:	19e0      	adds	r0, r4, r7
c0d02f84:	7841      	ldrb	r1, [r0, #1]
            ulIdx++)
c0d02f86:	1c7f      	adds	r7, r7, #1
c0d02f88:	e7f7      	b.n	c0d02f7a <snprintf+0x32>
        }

        //
        // Write this portion of the string.
        //
        ulIdx = MIN(ulIdx, str_size);
c0d02f8a:	429f      	cmp	r7, r3
c0d02f8c:	463d      	mov	r5, r7
c0d02f8e:	d300      	bcc.n	c0d02f92 <snprintf+0x4a>
c0d02f90:	461d      	mov	r5, r3
        memmove(str, format, ulIdx);
c0d02f92:	9808      	ldr	r0, [sp, #32]
c0d02f94:	4621      	mov	r1, r4
c0d02f96:	462a      	mov	r2, r5
c0d02f98:	9307      	str	r3, [sp, #28]
c0d02f9a:	f005 fac0 	bl	c0d0851e <__aeabi_memmove>
        str+= ulIdx;
        str_size -= ulIdx;
c0d02f9e:	9807      	ldr	r0, [sp, #28]
c0d02fa0:	1b42      	subs	r2, r0, r5
c0d02fa2:	d100      	bne.n	c0d02fa6 <snprintf+0x5e>
c0d02fa4:	e1b2      	b.n	c0d0330c <snprintf+0x3c4>
c0d02fa6:	9808      	ldr	r0, [sp, #32]
c0d02fa8:	1940      	adds	r0, r0, r5
        format += ulIdx;

        //
        // See if the next character is a %.
        //
        if(*format == '%')
c0d02faa:	5d61      	ldrb	r1, [r4, r5]
        format += ulIdx;
c0d02fac:	1964      	adds	r4, r4, r5
        if(*format == '%')
c0d02fae:	2925      	cmp	r1, #37	; 0x25
c0d02fb0:	d168      	bne.n	c0d03084 <snprintf+0x13c>
c0d02fb2:	9202      	str	r2, [sp, #8]
c0d02fb4:	9004      	str	r0, [sp, #16]
        {
            //
            // Skip the %.
            //
            format++;
c0d02fb6:	1c64      	adds	r4, r4, #1
c0d02fb8:	2600      	movs	r6, #0
c0d02fba:	2020      	movs	r0, #32
c0d02fbc:	9005      	str	r0, [sp, #20]
c0d02fbe:	200a      	movs	r0, #10
c0d02fc0:	9001      	str	r0, [sp, #4]
c0d02fc2:	9606      	str	r6, [sp, #24]
c0d02fc4:	9603      	str	r6, [sp, #12]
c0d02fc6:	4633      	mov	r3, r6
c0d02fc8:	461a      	mov	r2, r3
again:

            //
            // Determine how to handle the next character.
            //
            switch(*format++)
c0d02fca:	7820      	ldrb	r0, [r4, #0]
c0d02fcc:	1c64      	adds	r4, r4, #1
c0d02fce:	2300      	movs	r3, #0
c0d02fd0:	282d      	cmp	r0, #45	; 0x2d
c0d02fd2:	d0f9      	beq.n	c0d02fc8 <snprintf+0x80>
c0d02fd4:	2847      	cmp	r0, #71	; 0x47
c0d02fd6:	dc13      	bgt.n	c0d03000 <snprintf+0xb8>
c0d02fd8:	282f      	cmp	r0, #47	; 0x2f
c0d02fda:	dd20      	ble.n	c0d0301e <snprintf+0xd6>
c0d02fdc:	4603      	mov	r3, r0
c0d02fde:	3b30      	subs	r3, #48	; 0x30
c0d02fe0:	2b0a      	cmp	r3, #10
c0d02fe2:	d300      	bcc.n	c0d02fe6 <snprintf+0x9e>
c0d02fe4:	e14f      	b.n	c0d03286 <snprintf+0x33e>
c0d02fe6:	2330      	movs	r3, #48	; 0x30
                {
                    //
                    // If this is a zero, and it is the first digit, then the
                    // fill character is a zero instead of a space.
                    //
                    if((format[-1] == '0') && (ulCount == 0))
c0d02fe8:	4601      	mov	r1, r0
c0d02fea:	4059      	eors	r1, r3
c0d02fec:	4331      	orrs	r1, r6
c0d02fee:	d000      	beq.n	c0d02ff2 <snprintf+0xaa>
c0d02ff0:	9b05      	ldr	r3, [sp, #20]
c0d02ff2:	210a      	movs	r1, #10
                    }

                    //
                    // Update the digit count.
                    //
                    ulCount *= 10;
c0d02ff4:	4371      	muls	r1, r6
                    ulCount += format[-1] - '0';
c0d02ff6:	180e      	adds	r6, r1, r0
c0d02ff8:	3e30      	subs	r6, #48	; 0x30
c0d02ffa:	9305      	str	r3, [sp, #20]
c0d02ffc:	4613      	mov	r3, r2
c0d02ffe:	e7e3      	b.n	c0d02fc8 <snprintf+0x80>
            switch(*format++)
c0d03000:	2867      	cmp	r0, #103	; 0x67
c0d03002:	dd04      	ble.n	c0d0300e <snprintf+0xc6>
c0d03004:	2872      	cmp	r0, #114	; 0x72
c0d03006:	dd22      	ble.n	c0d0304e <snprintf+0x106>
c0d03008:	2873      	cmp	r0, #115	; 0x73
c0d0300a:	d13e      	bne.n	c0d0308a <snprintf+0x142>
c0d0300c:	e024      	b.n	c0d03058 <snprintf+0x110>
c0d0300e:	2862      	cmp	r0, #98	; 0x62
c0d03010:	dc40      	bgt.n	c0d03094 <snprintf+0x14c>
c0d03012:	2848      	cmp	r0, #72	; 0x48
c0d03014:	d000      	beq.n	c0d03018 <snprintf+0xd0>
c0d03016:	e0a0      	b.n	c0d0315a <snprintf+0x212>
c0d03018:	2001      	movs	r0, #1
c0d0301a:	9003      	str	r0, [sp, #12]
c0d0301c:	e01a      	b.n	c0d03054 <snprintf+0x10c>
c0d0301e:	2825      	cmp	r0, #37	; 0x25
c0d03020:	d100      	bne.n	c0d03024 <snprintf+0xdc>
c0d03022:	e0aa      	b.n	c0d0317a <snprintf+0x232>
c0d03024:	282a      	cmp	r0, #42	; 0x2a
c0d03026:	d022      	beq.n	c0d0306e <snprintf+0x126>
c0d03028:	282e      	cmp	r0, #46	; 0x2e
c0d0302a:	d000      	beq.n	c0d0302e <snprintf+0xe6>
c0d0302c:	e12b      	b.n	c0d03286 <snprintf+0x33e>
                // special %.*H or %.*h format to print a given length of hex digits (case: H UPPER, h lower)
                //
                case '.':
                {
                  // ensure next char is '*' and next one is 's'/'h'/'H'
                  if (format[0] == '*' && (format[1] == 's' || format[1] == 'H' || format[1] == 'h')) {
c0d0302e:	7821      	ldrb	r1, [r4, #0]
c0d03030:	292a      	cmp	r1, #42	; 0x2a
c0d03032:	9804      	ldr	r0, [sp, #16]
c0d03034:	d000      	beq.n	c0d03038 <snprintf+0xf0>
c0d03036:	e164      	b.n	c0d03302 <snprintf+0x3ba>
c0d03038:	7861      	ldrb	r1, [r4, #1]
c0d0303a:	2948      	cmp	r1, #72	; 0x48
c0d0303c:	d004      	beq.n	c0d03048 <snprintf+0x100>
c0d0303e:	2973      	cmp	r1, #115	; 0x73
c0d03040:	d002      	beq.n	c0d03048 <snprintf+0x100>
c0d03042:	2968      	cmp	r1, #104	; 0x68
c0d03044:	d000      	beq.n	c0d03048 <snprintf+0x100>
c0d03046:	e15b      	b.n	c0d03300 <snprintf+0x3b8>
c0d03048:	1c64      	adds	r4, r4, #1
c0d0304a:	2301      	movs	r3, #1
c0d0304c:	e014      	b.n	c0d03078 <snprintf+0x130>
            switch(*format++)
c0d0304e:	2868      	cmp	r0, #104	; 0x68
c0d03050:	d000      	beq.n	c0d03054 <snprintf+0x10c>
c0d03052:	e088      	b.n	c0d03166 <snprintf+0x21e>
c0d03054:	2010      	movs	r0, #16
c0d03056:	9001      	str	r0, [sp, #4]
                case_s:
                {
                    //
                    // Get the string pointer from the varargs.
                    //
                    pcStr = va_arg(vaArgP, char *);
c0d03058:	9809      	ldr	r0, [sp, #36]	; 0x24
c0d0305a:	1d01      	adds	r1, r0, #4
c0d0305c:	9109      	str	r1, [sp, #36]	; 0x24

                    //
                    // Determine the length of the string. (if not specified using .*)
                    //
                    switch(cStrlenSet) {
c0d0305e:	b2d3      	uxtb	r3, r2
                    pcStr = va_arg(vaArgP, char *);
c0d03060:	6801      	ldr	r1, [r0, #0]
                    switch(cStrlenSet) {
c0d03062:	2b01      	cmp	r3, #1
c0d03064:	dd25      	ble.n	c0d030b2 <snprintf+0x16a>
c0d03066:	2b02      	cmp	r3, #2
c0d03068:	4613      	mov	r3, r2
c0d0306a:	d1ad      	bne.n	c0d02fc8 <snprintf+0x80>
c0d0306c:	e108      	b.n	c0d03280 <snprintf+0x338>
                  if (*format == 's' ) {                    
c0d0306e:	7821      	ldrb	r1, [r4, #0]
c0d03070:	2973      	cmp	r1, #115	; 0x73
c0d03072:	d000      	beq.n	c0d03076 <snprintf+0x12e>
c0d03074:	e147      	b.n	c0d03306 <snprintf+0x3be>
c0d03076:	2302      	movs	r3, #2
c0d03078:	9909      	ldr	r1, [sp, #36]	; 0x24
c0d0307a:	1d08      	adds	r0, r1, #4
c0d0307c:	9009      	str	r0, [sp, #36]	; 0x24
c0d0307e:	6808      	ldr	r0, [r1, #0]
            switch(*format++)
c0d03080:	9006      	str	r0, [sp, #24]
c0d03082:	e7a1      	b.n	c0d02fc8 <snprintf+0x80>
c0d03084:	4613      	mov	r3, r2
c0d03086:	9008      	str	r0, [sp, #32]
c0d03088:	e137      	b.n	c0d032fa <snprintf+0x3b2>
c0d0308a:	2875      	cmp	r0, #117	; 0x75
c0d0308c:	d077      	beq.n	c0d0317e <snprintf+0x236>
c0d0308e:	2878      	cmp	r0, #120	; 0x78
c0d03090:	d06c      	beq.n	c0d0316c <snprintf+0x224>
c0d03092:	e0f8      	b.n	c0d03286 <snprintf+0x33e>
c0d03094:	2863      	cmp	r0, #99	; 0x63
c0d03096:	d100      	bne.n	c0d0309a <snprintf+0x152>
c0d03098:	e0e6      	b.n	c0d03268 <snprintf+0x320>
c0d0309a:	2864      	cmp	r0, #100	; 0x64
c0d0309c:	d000      	beq.n	c0d030a0 <snprintf+0x158>
c0d0309e:	e0f2      	b.n	c0d03286 <snprintf+0x33e>
                    ulValue = va_arg(vaArgP, unsigned long);
c0d030a0:	9809      	ldr	r0, [sp, #36]	; 0x24
c0d030a2:	1d01      	adds	r1, r0, #4
c0d030a4:	9109      	str	r1, [sp, #36]	; 0x24
c0d030a6:	6800      	ldr	r0, [r0, #0]
                    if((long)ulValue < 0)
c0d030a8:	17c1      	asrs	r1, r0, #31
c0d030aa:	1842      	adds	r2, r0, r1
c0d030ac:	404a      	eors	r2, r1
c0d030ae:	0fc5      	lsrs	r5, r0, #31
c0d030b0:	e06a      	b.n	c0d03188 <snprintf+0x240>
                    switch(cStrlenSet) {
c0d030b2:	2b00      	cmp	r3, #0
c0d030b4:	9d07      	ldr	r5, [sp, #28]
c0d030b6:	9a06      	ldr	r2, [sp, #24]
c0d030b8:	d105      	bne.n	c0d030c6 <snprintf+0x17e>
c0d030ba:	2200      	movs	r2, #0
                      // compute length with strlen
                      case 0:
                        for(ulIdx = 0; pcStr[ulIdx] != '\0'; ulIdx++)
c0d030bc:	5c88      	ldrb	r0, [r1, r2]
c0d030be:	1c52      	adds	r2, r2, #1
c0d030c0:	2800      	cmp	r0, #0
c0d030c2:	d1fb      	bne.n	c0d030bc <snprintf+0x174>
                    }

                    //
                    // Write the string.
                    //
                    switch(ulBase) {
c0d030c4:	1e52      	subs	r2, r2, #1
c0d030c6:	9801      	ldr	r0, [sp, #4]
c0d030c8:	2810      	cmp	r0, #16
c0d030ca:	9804      	ldr	r0, [sp, #16]
c0d030cc:	d000      	beq.n	c0d030d0 <snprintf+0x188>
c0d030ce:	e0dd      	b.n	c0d0328c <snprintf+0x344>
                            return 0;
                        }
                        break;
                      case 16: {
                        unsigned char nibble1, nibble2;
                        for (ulCount = 0; ulCount < ulIdx; ulCount++) {
c0d030d0:	2a00      	cmp	r2, #0
c0d030d2:	d100      	bne.n	c0d030d6 <snprintf+0x18e>
c0d030d4:	e0ea      	b.n	c0d032ac <snprintf+0x364>
c0d030d6:	9206      	str	r2, [sp, #24]
c0d030d8:	0050      	lsls	r0, r2, #1
c0d030da:	42bd      	cmp	r5, r7
c0d030dc:	462a      	mov	r2, r5
c0d030de:	d300      	bcc.n	c0d030e2 <snprintf+0x19a>
c0d030e0:	463a      	mov	r2, r7
c0d030e2:	9b02      	ldr	r3, [sp, #8]
c0d030e4:	1a18      	subs	r0, r3, r0
c0d030e6:	9000      	str	r0, [sp, #0]
c0d030e8:	1c90      	adds	r0, r2, #2
c0d030ea:	9002      	str	r0, [sp, #8]
c0d030ec:	9201      	str	r2, [sp, #4]
c0d030ee:	4250      	negs	r0, r2
c0d030f0:	9004      	str	r0, [sp, #16]
c0d030f2:	462e      	mov	r6, r5
                          nibble1 = (pcStr[ulCount]>>4)&0xF;
c0d030f4:	9804      	ldr	r0, [sp, #16]
c0d030f6:	1980      	adds	r0, r0, r6
                          nibble2 = pcStr[ulCount]&0xF;
                          if (str_size < 2) {
c0d030f8:	2802      	cmp	r0, #2
c0d030fa:	d200      	bcs.n	c0d030fe <snprintf+0x1b6>
c0d030fc:	e106      	b.n	c0d0330c <snprintf+0x3c4>
c0d030fe:	7808      	ldrb	r0, [r1, #0]
c0d03100:	9b03      	ldr	r3, [sp, #12]
                              va_end(vaArgP);
                              return 0;
                          }
                          switch(ulCap) {
c0d03102:	2b00      	cmp	r3, #0
c0d03104:	d004      	beq.n	c0d03110 <snprintf+0x1c8>
c0d03106:	2b01      	cmp	r3, #1
c0d03108:	d111      	bne.n	c0d0312e <snprintf+0x1e6>
c0d0310a:	4a84      	ldr	r2, [pc, #528]	; (c0d0331c <snprintf+0x3d4>)
c0d0310c:	447a      	add	r2, pc
c0d0310e:	e001      	b.n	c0d03114 <snprintf+0x1cc>
c0d03110:	4a81      	ldr	r2, [pc, #516]	; (c0d03318 <snprintf+0x3d0>)
c0d03112:	447a      	add	r2, pc
c0d03114:	9205      	str	r2, [sp, #20]
c0d03116:	250f      	movs	r5, #15
c0d03118:	4005      	ands	r5, r0
c0d0311a:	0900      	lsrs	r0, r0, #4
c0d0311c:	5c10      	ldrb	r0, [r2, r0]
c0d0311e:	9a08      	ldr	r2, [sp, #32]
c0d03120:	9b01      	ldr	r3, [sp, #4]
c0d03122:	54d0      	strb	r0, [r2, r3]
c0d03124:	18d0      	adds	r0, r2, r3
c0d03126:	9a05      	ldr	r2, [sp, #20]
c0d03128:	5d53      	ldrb	r3, [r2, r5]
c0d0312a:	7043      	strb	r3, [r0, #1]
c0d0312c:	9d07      	ldr	r5, [sp, #28]
                                str[1] = g_pcHex_cap[nibble2];
                              break;
                          }
                          str+= 2;
                          str_size -= 2;
                          if (str_size == 0) {
c0d0312e:	9802      	ldr	r0, [sp, #8]
c0d03130:	42b0      	cmp	r0, r6
c0d03132:	d100      	bne.n	c0d03136 <snprintf+0x1ee>
c0d03134:	e0ea      	b.n	c0d0330c <snprintf+0x3c4>
                        for (ulCount = 0; ulCount < ulIdx; ulCount++) {
c0d03136:	1c49      	adds	r1, r1, #1
c0d03138:	9a06      	ldr	r2, [sp, #24]
c0d0313a:	1e52      	subs	r2, r2, #1
c0d0313c:	1eb6      	subs	r6, r6, #2
c0d0313e:	9808      	ldr	r0, [sp, #32]
c0d03140:	1c80      	adds	r0, r0, #2
c0d03142:	9008      	str	r0, [sp, #32]
c0d03144:	9206      	str	r2, [sp, #24]
c0d03146:	2a00      	cmp	r2, #0
c0d03148:	d1d4      	bne.n	c0d030f4 <snprintf+0x1ac>
    while(*format)
c0d0314a:	42bd      	cmp	r5, r7
c0d0314c:	d300      	bcc.n	c0d03150 <snprintf+0x208>
c0d0314e:	463d      	mov	r5, r7
c0d03150:	9808      	ldr	r0, [sp, #32]
c0d03152:	1940      	adds	r0, r0, r5
c0d03154:	9008      	str	r0, [sp, #32]
c0d03156:	9b00      	ldr	r3, [sp, #0]
c0d03158:	e0ce      	b.n	c0d032f8 <snprintf+0x3b0>
            switch(*format++)
c0d0315a:	2858      	cmp	r0, #88	; 0x58
c0d0315c:	d000      	beq.n	c0d03160 <snprintf+0x218>
c0d0315e:	e092      	b.n	c0d03286 <snprintf+0x33e>
c0d03160:	2001      	movs	r0, #1
c0d03162:	9003      	str	r0, [sp, #12]
c0d03164:	e002      	b.n	c0d0316c <snprintf+0x224>
c0d03166:	2870      	cmp	r0, #112	; 0x70
c0d03168:	d000      	beq.n	c0d0316c <snprintf+0x224>
c0d0316a:	e08c      	b.n	c0d03286 <snprintf+0x33e>
                case 'p':
                {
                    //
                    // Get the value from the varargs.
                    //
                    ulValue = va_arg(vaArgP, unsigned long);
c0d0316c:	9809      	ldr	r0, [sp, #36]	; 0x24
c0d0316e:	1d01      	adds	r1, r0, #4
c0d03170:	9109      	str	r1, [sp, #36]	; 0x24
c0d03172:	6802      	ldr	r2, [r0, #0]
c0d03174:	2500      	movs	r5, #0
c0d03176:	2010      	movs	r0, #16
c0d03178:	e007      	b.n	c0d0318a <snprintf+0x242>
c0d0317a:	2025      	movs	r0, #37	; 0x25
c0d0317c:	e078      	b.n	c0d03270 <snprintf+0x328>
                    ulValue = va_arg(vaArgP, unsigned long);
c0d0317e:	9809      	ldr	r0, [sp, #36]	; 0x24
c0d03180:	1d01      	adds	r1, r0, #4
c0d03182:	9109      	str	r1, [sp, #36]	; 0x24
c0d03184:	6802      	ldr	r2, [r0, #0]
c0d03186:	2500      	movs	r5, #0
c0d03188:	200a      	movs	r0, #10
                    // Determine the number of digits in the string version of
                    // the value.
                    //
convert:
                    for(ulIdx = 1;
                        (((ulIdx * ulBase) <= ulValue) &&
c0d0318a:	9208      	str	r2, [sp, #32]
c0d0318c:	4290      	cmp	r0, r2
c0d0318e:	9006      	str	r0, [sp, #24]
c0d03190:	d901      	bls.n	c0d03196 <snprintf+0x24e>
c0d03192:	2701      	movs	r7, #1
c0d03194:	e010      	b.n	c0d031b8 <snprintf+0x270>
                    for(ulIdx = 1;
c0d03196:	1e72      	subs	r2, r6, #1
c0d03198:	4607      	mov	r7, r0
c0d0319a:	4616      	mov	r6, r2
c0d0319c:	2100      	movs	r1, #0
                        (((ulIdx * ulBase) <= ulValue) &&
c0d0319e:	9806      	ldr	r0, [sp, #24]
c0d031a0:	463a      	mov	r2, r7
c0d031a2:	460b      	mov	r3, r1
c0d031a4:	f005 f88e 	bl	c0d082c4 <__aeabi_lmul>
c0d031a8:	1e4a      	subs	r2, r1, #1
c0d031aa:	4191      	sbcs	r1, r2
c0d031ac:	9a08      	ldr	r2, [sp, #32]
c0d031ae:	4290      	cmp	r0, r2
c0d031b0:	d802      	bhi.n	c0d031b8 <snprintf+0x270>
                    for(ulIdx = 1;
c0d031b2:	1e72      	subs	r2, r6, #1
c0d031b4:	2900      	cmp	r1, #0
c0d031b6:	d0ef      	beq.n	c0d03198 <snprintf+0x250>

                    //
                    // If the value is negative, reduce the count of padding
                    // characters needed.
                    //
                    if(ulNeg)
c0d031b8:	2d00      	cmp	r5, #0
c0d031ba:	d000      	beq.n	c0d031be <snprintf+0x276>
c0d031bc:	1e76      	subs	r6, r6, #1
c0d031be:	9b05      	ldr	r3, [sp, #20]
c0d031c0:	2000      	movs	r0, #0

                    //
                    // If the value is negative and the value is padded with
                    // zeros, then place the minus sign before the padding.
                    //
                    if(ulNeg && (cFill == '0'))
c0d031c2:	2d00      	cmp	r5, #0
c0d031c4:	d007      	beq.n	c0d031d6 <snprintf+0x28e>
c0d031c6:	b2d9      	uxtb	r1, r3
c0d031c8:	2930      	cmp	r1, #48	; 0x30
c0d031ca:	d107      	bne.n	c0d031dc <snprintf+0x294>
c0d031cc:	a90a      	add	r1, sp, #40	; 0x28
c0d031ce:	222d      	movs	r2, #45	; 0x2d
                    {
                        //
                        // Place the minus sign in the output buffer.
                        //
                        pcBuf[ulPos++] = '-';
c0d031d0:	700a      	strb	r2, [r1, #0]
c0d031d2:	2501      	movs	r5, #1
c0d031d4:	e000      	b.n	c0d031d8 <snprintf+0x290>
c0d031d6:	4605      	mov	r5, r0
c0d031d8:	4601      	mov	r1, r0
c0d031da:	e001      	b.n	c0d031e0 <snprintf+0x298>
c0d031dc:	2101      	movs	r1, #1
c0d031de:	4605      	mov	r5, r0

                    //
                    // Provide additional padding at the beginning of the
                    // string conversion if needed.
                    //
                    if((ulCount > 1) && (ulCount < 16))
c0d031e0:	1eb0      	subs	r0, r6, #2
c0d031e2:	280d      	cmp	r0, #13
c0d031e4:	d80c      	bhi.n	c0d03200 <snprintf+0x2b8>
c0d031e6:	a80a      	add	r0, sp, #40	; 0x28
                    {
                        for(ulCount--; ulCount; ulCount--)
c0d031e8:	1940      	adds	r0, r0, r5
c0d031ea:	1e76      	subs	r6, r6, #1
                        {
                            pcBuf[ulPos++] = cFill;
c0d031ec:	b2da      	uxtb	r2, r3
c0d031ee:	9107      	str	r1, [sp, #28]
c0d031f0:	4631      	mov	r1, r6
c0d031f2:	f005 f998 	bl	c0d08526 <__aeabi_memset>
c0d031f6:	9907      	ldr	r1, [sp, #28]
c0d031f8:	1e76      	subs	r6, r6, #1
c0d031fa:	1c6d      	adds	r5, r5, #1
                        for(ulCount--; ulCount; ulCount--)
c0d031fc:	2e00      	cmp	r6, #0
c0d031fe:	d1fb      	bne.n	c0d031f8 <snprintf+0x2b0>

                    //
                    // If the value is negative, then place the minus sign
                    // before the number.
                    //
                    if(ulNeg)
c0d03200:	2900      	cmp	r1, #0
c0d03202:	d003      	beq.n	c0d0320c <snprintf+0x2c4>
c0d03204:	a80a      	add	r0, sp, #40	; 0x28
c0d03206:	212d      	movs	r1, #45	; 0x2d
                    {
                        //
                        // Place the minus sign in the output buffer.
                        //
                        pcBuf[ulPos++] = '-';
c0d03208:	5541      	strb	r1, [r0, r5]
c0d0320a:	1c6d      	adds	r5, r5, #1
c0d0320c:	9803      	ldr	r0, [sp, #12]
                    }

                    //
                    // Convert the value into a string.
                    //
                    for(; ulIdx; ulIdx /= ulBase)
c0d0320e:	2f00      	cmp	r7, #0
c0d03210:	d01b      	beq.n	c0d0324a <snprintf+0x302>
c0d03212:	2800      	cmp	r0, #0
c0d03214:	d002      	beq.n	c0d0321c <snprintf+0x2d4>
c0d03216:	4843      	ldr	r0, [pc, #268]	; (c0d03324 <snprintf+0x3dc>)
c0d03218:	4478      	add	r0, pc
c0d0321a:	e001      	b.n	c0d03220 <snprintf+0x2d8>
c0d0321c:	4840      	ldr	r0, [pc, #256]	; (c0d03320 <snprintf+0x3d8>)
c0d0321e:	4478      	add	r0, pc
c0d03220:	9007      	str	r0, [sp, #28]
c0d03222:	9e06      	ldr	r6, [sp, #24]
c0d03224:	9808      	ldr	r0, [sp, #32]
c0d03226:	4639      	mov	r1, r7
c0d03228:	f004 ffa0 	bl	c0d0816c <__udivsi3>
c0d0322c:	4631      	mov	r1, r6
c0d0322e:	f005 f823 	bl	c0d08278 <__aeabi_uidivmod>
c0d03232:	9807      	ldr	r0, [sp, #28]
c0d03234:	5c40      	ldrb	r0, [r0, r1]
c0d03236:	a90a      	add	r1, sp, #40	; 0x28
                    {
                        if (!ulCap) {
                          pcBuf[ulPos++] = g_pcHex[(ulValue / ulIdx) % ulBase];
c0d03238:	5548      	strb	r0, [r1, r5]
                    for(; ulIdx; ulIdx /= ulBase)
c0d0323a:	4638      	mov	r0, r7
c0d0323c:	4631      	mov	r1, r6
c0d0323e:	f004 ff95 	bl	c0d0816c <__udivsi3>
c0d03242:	1c6d      	adds	r5, r5, #1
c0d03244:	42be      	cmp	r6, r7
c0d03246:	4607      	mov	r7, r0
c0d03248:	d9ec      	bls.n	c0d03224 <snprintf+0x2dc>
c0d0324a:	9802      	ldr	r0, [sp, #8]
                    }

                    //
                    // Write the string.
                    //
                    ulPos = MIN(ulPos, str_size);
c0d0324c:	4285      	cmp	r5, r0
c0d0324e:	d300      	bcc.n	c0d03252 <snprintf+0x30a>
c0d03250:	4605      	mov	r5, r0
c0d03252:	a90a      	add	r1, sp, #40	; 0x28
c0d03254:	4607      	mov	r7, r0
c0d03256:	9e04      	ldr	r6, [sp, #16]
                    memmove(str, pcBuf, ulPos);
c0d03258:	4630      	mov	r0, r6
c0d0325a:	462a      	mov	r2, r5
c0d0325c:	f005 f95f 	bl	c0d0851e <__aeabi_memmove>
                    str+= ulPos;
                    str_size -= ulPos;
c0d03260:	1b7b      	subs	r3, r7, r5
                    if (str_size == 0) {
c0d03262:	d053      	beq.n	c0d0330c <snprintf+0x3c4>
c0d03264:	1970      	adds	r0, r6, r5
c0d03266:	e046      	b.n	c0d032f6 <snprintf+0x3ae>
                    ulValue = va_arg(vaArgP, unsigned long);
c0d03268:	9809      	ldr	r0, [sp, #36]	; 0x24
c0d0326a:	1d01      	adds	r1, r0, #4
c0d0326c:	9109      	str	r1, [sp, #36]	; 0x24
c0d0326e:	6800      	ldr	r0, [r0, #0]
c0d03270:	9904      	ldr	r1, [sp, #16]
c0d03272:	7008      	strb	r0, [r1, #0]
c0d03274:	4608      	mov	r0, r1
c0d03276:	9902      	ldr	r1, [sp, #8]
c0d03278:	1e4b      	subs	r3, r1, #1
c0d0327a:	d047      	beq.n	c0d0330c <snprintf+0x3c4>
c0d0327c:	1c40      	adds	r0, r0, #1
c0d0327e:	e03a      	b.n	c0d032f6 <snprintf+0x3ae>
                        if (pcStr[0] == '\0') {
c0d03280:	7808      	ldrb	r0, [r1, #0]
c0d03282:	2800      	cmp	r0, #0
c0d03284:	d014      	beq.n	c0d032b0 <snprintf+0x368>
c0d03286:	9b02      	ldr	r3, [sp, #8]
c0d03288:	9804      	ldr	r0, [sp, #16]
c0d0328a:	e034      	b.n	c0d032f6 <snprintf+0x3ae>
c0d0328c:	9802      	ldr	r0, [sp, #8]
                        ulIdx = MIN(ulIdx, str_size);
c0d0328e:	4282      	cmp	r2, r0
c0d03290:	4615      	mov	r5, r2
c0d03292:	d301      	bcc.n	c0d03298 <snprintf+0x350>
c0d03294:	4605      	mov	r5, r0
c0d03296:	4602      	mov	r2, r0
c0d03298:	9206      	str	r2, [sp, #24]
                        memmove(str, pcStr, ulIdx);
c0d0329a:	9804      	ldr	r0, [sp, #16]
c0d0329c:	462a      	mov	r2, r5
c0d0329e:	f005 f93e 	bl	c0d0851e <__aeabi_memmove>
c0d032a2:	9f04      	ldr	r7, [sp, #16]
                        str_size -= ulIdx;
c0d032a4:	9802      	ldr	r0, [sp, #8]
c0d032a6:	1b43      	subs	r3, r0, r5
                        if (str_size == 0) {
c0d032a8:	d111      	bne.n	c0d032ce <snprintf+0x386>
c0d032aa:	e02f      	b.n	c0d0330c <snprintf+0x3c4>
c0d032ac:	9b02      	ldr	r3, [sp, #8]
c0d032ae:	e022      	b.n	c0d032f6 <snprintf+0x3ae>
c0d032b0:	9802      	ldr	r0, [sp, #8]
c0d032b2:	9906      	ldr	r1, [sp, #24]
                          ulStrlen = MIN(ulStrlen, str_size);
c0d032b4:	4281      	cmp	r1, r0
c0d032b6:	d300      	bcc.n	c0d032ba <snprintf+0x372>
c0d032b8:	4601      	mov	r1, r0
                          memset(str, ' ', ulStrlen);
c0d032ba:	9106      	str	r1, [sp, #24]
c0d032bc:	2220      	movs	r2, #32
c0d032be:	9f04      	ldr	r7, [sp, #16]
c0d032c0:	4638      	mov	r0, r7
c0d032c2:	f005 f930 	bl	c0d08526 <__aeabi_memset>
                          str_size -= ulStrlen;
c0d032c6:	9802      	ldr	r0, [sp, #8]
c0d032c8:	9906      	ldr	r1, [sp, #24]
c0d032ca:	1a43      	subs	r3, r0, r1
                          if (str_size == 0) {
c0d032cc:	d01e      	beq.n	c0d0330c <snprintf+0x3c4>
c0d032ce:	9806      	ldr	r0, [sp, #24]
c0d032d0:	1838      	adds	r0, r7, r0
                    if(ulCount > ulIdx)
c0d032d2:	9008      	str	r0, [sp, #32]
c0d032d4:	42ae      	cmp	r6, r5
c0d032d6:	d90f      	bls.n	c0d032f8 <snprintf+0x3b0>
                        ulCount -= ulIdx;
c0d032d8:	1b75      	subs	r5, r6, r5
                        ulCount = MIN(ulCount, str_size);
c0d032da:	429d      	cmp	r5, r3
c0d032dc:	d300      	bcc.n	c0d032e0 <snprintf+0x398>
c0d032de:	461d      	mov	r5, r3
c0d032e0:	2220      	movs	r2, #32
                        memset(str, ' ', ulCount);
c0d032e2:	9808      	ldr	r0, [sp, #32]
c0d032e4:	4629      	mov	r1, r5
c0d032e6:	461e      	mov	r6, r3
c0d032e8:	f005 f91d 	bl	c0d08526 <__aeabi_memset>
c0d032ec:	4633      	mov	r3, r6
                        str_size -= ulCount;
c0d032ee:	1b73      	subs	r3, r6, r5
c0d032f0:	d00c      	beq.n	c0d0330c <snprintf+0x3c4>
c0d032f2:	9808      	ldr	r0, [sp, #32]
c0d032f4:	1940      	adds	r0, r0, r5
c0d032f6:	9008      	str	r0, [sp, #32]
    while(*format)
c0d032f8:	7821      	ldrb	r1, [r4, #0]
c0d032fa:	2900      	cmp	r1, #0
c0d032fc:	d006      	beq.n	c0d0330c <snprintf+0x3c4>
c0d032fe:	e63b      	b.n	c0d02f78 <snprintf+0x30>
c0d03300:	212a      	movs	r1, #42	; 0x2a
c0d03302:	9b02      	ldr	r3, [sp, #8]
c0d03304:	e6bf      	b.n	c0d03086 <snprintf+0x13e>
c0d03306:	9b02      	ldr	r3, [sp, #8]
c0d03308:	9804      	ldr	r0, [sp, #16]
c0d0330a:	e6bc      	b.n	c0d03086 <snprintf+0x13e>
c0d0330c:	2000      	movs	r0, #0
    // End the varargs processing.
    //
    va_end(vaArgP);

    return 0;
}
c0d0330e:	b00e      	add	sp, #56	; 0x38
c0d03310:	bcf0      	pop	{r4, r5, r6, r7}
c0d03312:	bc02      	pop	{r1}
c0d03314:	b001      	add	sp, #4
c0d03316:	4708      	bx	r1
c0d03318:	0000623a 	.word	0x0000623a
c0d0331c:	00006250 	.word	0x00006250
c0d03320:	0000612e 	.word	0x0000612e
c0d03324:	00006144 	.word	0x00006144

c0d03328 <pic>:
// only apply PIC conversion if link_address is in linked code (over 0xC0D00000 in our example)
// this way, PIC call are armless if the address is not meant to be converted
extern void _nvram;
extern void _envram;

void *pic(void *link_address) {
c0d03328:	b580      	push	{r7, lr}
  if (link_address >= &_nvram && link_address < &_envram) {
c0d0332a:	4904      	ldr	r1, [pc, #16]	; (c0d0333c <pic+0x14>)
c0d0332c:	4288      	cmp	r0, r1
c0d0332e:	d304      	bcc.n	c0d0333a <pic+0x12>
c0d03330:	4903      	ldr	r1, [pc, #12]	; (c0d03340 <pic+0x18>)
c0d03332:	4288      	cmp	r0, r1
c0d03334:	d201      	bcs.n	c0d0333a <pic+0x12>
    link_address = pic_internal(link_address);
c0d03336:	f000 f805 	bl	c0d03344 <pic_internal>
  }
  return link_address;
c0d0333a:	bd80      	pop	{r7, pc}
c0d0333c:	c0d00000 	.word	0xc0d00000
c0d03340:	c0d0a1c0 	.word	0xc0d0a1c0

c0d03344 <pic_internal>:
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-parameter"
__attribute__((naked)) void *pic_internal(void *link_address)
{
  // compute the delta offset between LinkMemAddr & ExecMemAddr
  __asm volatile ("mov r2, pc\n");
c0d03344:	467a      	mov	r2, pc
  __asm volatile ("ldr r1, =pic_internal\n");
c0d03346:	4902      	ldr	r1, [pc, #8]	; (c0d03350 <pic_internal+0xc>)
  __asm volatile ("adds r1, r1, #3\n");
c0d03348:	1cc9      	adds	r1, r1, #3
  __asm volatile ("subs r1, r1, r2\n");
c0d0334a:	1a89      	subs	r1, r1, r2

  // adjust value of the given parameter
  __asm volatile ("subs r0, r0, r1\n");
c0d0334c:	1a40      	subs	r0, r0, r1
  __asm volatile ("bx lr\n");
c0d0334e:	4770      	bx	lr
c0d03350:	c0d03345 	.word	0xc0d03345

c0d03354 <handleRunTests>:
        uint8_t p2 MARK_UNUSED,
        uint8_t *wireBuffer MARK_UNUSED,
        size_t wireSize MARK_UNUSED,
        bool isNewCall MARK_UNUSED
)
{
c0d03354:	b5b0      	push	{r4, r5, r7, lr}
c0d03356:	b09c      	sub	sp, #112	; 0x70
c0d03358:	ac10      	add	r4, sp, #64	; 0x40
	// Note: Make sure to have RESET_ON_CRASH flag disabled
	// as it interferes with tests verifying assertions
	BEGIN_ASSERT_NOEXCEPT {
c0d0335a:	4620      	mov	r0, r4
c0d0335c:	f005 f920 	bl	c0d085a0 <setjmp>
c0d03360:	85a0      	strh	r0, [r4, #44]	; 0x2c
c0d03362:	b285      	uxth	r5, r0
c0d03364:	2d00      	cmp	r5, #0
c0d03366:	d01a      	beq.n	c0d0339e <handleRunTests+0x4a>
c0d03368:	2047      	movs	r0, #71	; 0x47
c0d0336a:	0204      	lsls	r4, r0, #8
c0d0336c:	42a5      	cmp	r5, r4
c0d0336e:	d042      	beq.n	c0d033f6 <handleRunTests+0xa2>
c0d03370:	a810      	add	r0, sp, #64	; 0x40
c0d03372:	2400      	movs	r4, #0
		run_endian_test();
		run_textUtils_test();
		run_bip44_test();
		run_key_derivation_test();
		PRINTF("All tests done\n");
	} END_ASSERT_NOEXCEPT;
c0d03374:	8584      	strh	r4, [r0, #44]	; 0x2c
c0d03376:	981a      	ldr	r0, [sp, #104]	; 0x68
c0d03378:	f002 f956 	bl	c0d05628 <try_context_set>
c0d0337c:	2021      	movs	r0, #33	; 0x21
c0d0337e:	9000      	str	r0, [sp, #0]
c0d03380:	9501      	str	r5, [sp, #4]
c0d03382:	ad03      	add	r5, sp, #12
c0d03384:	2132      	movs	r1, #50	; 0x32
c0d03386:	4a20      	ldr	r2, [pc, #128]	; (c0d03408 <handleRunTests+0xb4>)
c0d03388:	447a      	add	r2, pc
c0d0338a:	4b20      	ldr	r3, [pc, #128]	; (c0d0340c <handleRunTests+0xb8>)
c0d0338c:	447b      	add	r3, pc
c0d0338e:	4628      	mov	r0, r5
c0d03390:	f7ff fdda 	bl	c0d02f48 <snprintf>
c0d03394:	4620      	mov	r0, r4
c0d03396:	4629      	mov	r1, r5
c0d03398:	f7fc fe6a 	bl	c0d00070 <assert>
c0d0339c:	e015      	b.n	c0d033ca <handleRunTests+0x76>
c0d0339e:	a810      	add	r0, sp, #64	; 0x40
	BEGIN_ASSERT_NOEXCEPT {
c0d033a0:	f002 f942 	bl	c0d05628 <try_context_set>
c0d033a4:	901a      	str	r0, [sp, #104]	; 0x68
		PRINTF("Running tests\n");
c0d033a6:	481a      	ldr	r0, [pc, #104]	; (c0d03410 <handleRunTests+0xbc>)
c0d033a8:	4478      	add	r0, pc
c0d033aa:	f7ff fc4b 	bl	c0d02c44 <mcu_usb_printf>
		run_hex_test();
c0d033ae:	f7fd fead 	bl	c0d0110c <run_hex_test>
		run_endian_test();
c0d033b2:	f7fd f935 	bl	c0d00620 <run_endian_test>
		run_textUtils_test();
c0d033b6:	f002 faa1 	bl	c0d058fc <run_textUtils_test>
		run_bip44_test();
c0d033ba:	f7fc ffe3 	bl	c0d00384 <run_bip44_test>
		run_key_derivation_test();
c0d033be:	f7fe fd61 	bl	c0d01e84 <run_key_derivation_test>
		PRINTF("All tests done\n");
c0d033c2:	4814      	ldr	r0, [pc, #80]	; (c0d03414 <handleRunTests+0xc0>)
c0d033c4:	4478      	add	r0, pc
c0d033c6:	f7ff fc3d 	bl	c0d02c44 <mcu_usb_printf>
	} END_ASSERT_NOEXCEPT;
c0d033ca:	f002 f921 	bl	c0d05610 <try_context_get>
c0d033ce:	a910      	add	r1, sp, #64	; 0x40
c0d033d0:	4288      	cmp	r0, r1
c0d033d2:	d102      	bne.n	c0d033da <handleRunTests+0x86>
c0d033d4:	981a      	ldr	r0, [sp, #104]	; 0x68
c0d033d6:	f002 f927 	bl	c0d05628 <try_context_set>
c0d033da:	a810      	add	r0, sp, #64	; 0x40
c0d033dc:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d033de:	2800      	cmp	r0, #0
c0d033e0:	d110      	bne.n	c0d03404 <handleRunTests+0xb0>
c0d033e2:	2009      	movs	r0, #9
c0d033e4:	0300      	lsls	r0, r0, #12
c0d033e6:	2100      	movs	r1, #0

	io_send_buf(SUCCESS, NULL, 0);
c0d033e8:	460a      	mov	r2, r1
c0d033ea:	f7fd fecd 	bl	c0d01188 <io_send_buf>
	ui_idle();
c0d033ee:	f7fe fd61 	bl	c0d01eb4 <ui_idle>
}
c0d033f2:	b01c      	add	sp, #112	; 0x70
c0d033f4:	bdb0      	pop	{r4, r5, r7, pc}
c0d033f6:	a810      	add	r0, sp, #64	; 0x40
c0d033f8:	2100      	movs	r1, #0
	} END_ASSERT_NOEXCEPT;
c0d033fa:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d033fc:	981a      	ldr	r0, [sp, #104]	; 0x68
c0d033fe:	f002 f913 	bl	c0d05628 <try_context_set>
c0d03402:	4620      	mov	r0, r4
c0d03404:	f7fe fec6 	bl	c0d02194 <os_longjmp>
c0d03408:	00006003 	.word	0x00006003
c0d0340c:	00006009 	.word	0x00006009
c0d03410:	00005fc4 	.word	0x00005fc4
c0d03414:	00005fb7 	.word	0x00005fb7

c0d03418 <policyForGetPublicKey>:
#define SHOW_IF(expr)      if (expr)    return POLICY_SHOW_BEFORE_RESPONSE;
#define SHOW_UNLESS(expr)  if (!(expr)) return POLICY_SHOW_BEFORE_RESPONSE;


security_policy_t policyForGetPublicKey(const bip44_path_t* pathSpec, get_key_p1_t show_or_not)
{
c0d03418:	b570      	push	{r4, r5, r6, lr}
c0d0341a:	460c      	mov	r4, r1
c0d0341c:	4606      	mov	r6, r0
	DENY_UNLESS(bip44_hasValidFIOPrefix(pathSpec));
c0d0341e:	f7fc fe75 	bl	c0d0010c <bip44_hasValidFIOPrefix>
c0d03422:	2501      	movs	r5, #1
c0d03424:	2800      	cmp	r0, #0
c0d03426:	d015      	beq.n	c0d03454 <policyForGetPublicKey+0x3c>
	DENY_UNLESS(bip44_containsAddress(pathSpec));
c0d03428:	4630      	mov	r0, r6
c0d0342a:	f7fc fe88 	bl	c0d0013e <bip44_containsAddress>
c0d0342e:	2800      	cmp	r0, #0
c0d03430:	d010      	beq.n	c0d03454 <policyForGetPublicKey+0x3c>
	DENY_IF(bip44_containsMoreThanAddress(pathSpec));
c0d03432:	4630      	mov	r0, r6
c0d03434:	f7fc fea0 	bl	c0d00178 <bip44_containsMoreThanAddress>
c0d03438:	2800      	cmp	r0, #0
c0d0343a:	d10b      	bne.n	c0d03454 <policyForGetPublicKey+0x3c>
	WARN_UNLESS(bip44_hasReasonableAddress(pathSpec));
c0d0343c:	4630      	mov	r0, r6
c0d0343e:	f7fc fe85 	bl	c0d0014c <bip44_hasReasonableAddress>
c0d03442:	2800      	cmp	r0, #0
c0d03444:	d003      	beq.n	c0d0344e <policyForGetPublicKey+0x36>
c0d03446:	2c02      	cmp	r4, #2
c0d03448:	d103      	bne.n	c0d03452 <policyForGetPublicKey+0x3a>
c0d0344a:	4625      	mov	r5, r4
c0d0344c:	e002      	b.n	c0d03454 <policyForGetPublicKey+0x3c>
c0d0344e:	2504      	movs	r5, #4
c0d03450:	e000      	b.n	c0d03454 <policyForGetPublicKey+0x3c>
c0d03452:	2503      	movs	r5, #3
	PROMPT_IF(show_or_not != P1_DO_NOT_SHOW_PUBKEY);

	ALLOW();
}
c0d03454:	4628      	mov	r0, r5
c0d03456:	bd70      	pop	{r4, r5, r6, pc}

c0d03458 <policyDerivePrivateKey>:

	PROMPT();
}

security_policy_t policyDerivePrivateKey(const bip44_path_t* pathSpec)
{
c0d03458:	b5b0      	push	{r4, r5, r7, lr}
c0d0345a:	4605      	mov	r5, r0
	DENY_UNLESS(bip44_hasValidFIOPrefix(pathSpec));
c0d0345c:	f7fc fe56 	bl	c0d0010c <bip44_hasValidFIOPrefix>
c0d03460:	2401      	movs	r4, #1
c0d03462:	2800      	cmp	r0, #0
c0d03464:	d00c      	beq.n	c0d03480 <policyDerivePrivateKey+0x28>
	DENY_UNLESS(bip44_containsAddress(pathSpec));
c0d03466:	4628      	mov	r0, r5
c0d03468:	f7fc fe69 	bl	c0d0013e <bip44_containsAddress>
c0d0346c:	2800      	cmp	r0, #0
c0d0346e:	d007      	beq.n	c0d03480 <policyDerivePrivateKey+0x28>
	DENY_IF(bip44_containsMoreThanAddress(pathSpec));
c0d03470:	4628      	mov	r0, r5
c0d03472:	f7fc fe81 	bl	c0d00178 <bip44_containsMoreThanAddress>
c0d03476:	2800      	cmp	r0, #0
c0d03478:	d101      	bne.n	c0d0347e <policyDerivePrivateKey+0x26>
c0d0347a:	2402      	movs	r4, #2
c0d0347c:	e000      	b.n	c0d03480 <policyDerivePrivateKey+0x28>
c0d0347e:	2401      	movs	r4, #1

	ALLOW();
}
c0d03480:	4620      	mov	r0, r4
c0d03482:	bdb0      	pop	{r4, r5, r7, pc}

c0d03484 <policyForSendData>:

security_policy_t policyForSendData(uint8_t should_display) {
c0d03484:	b580      	push	{r7, lr}
	if(should_display == DISPLAY) {
c0d03486:	2801      	cmp	r0, #1
c0d03488:	d003      	beq.n	c0d03492 <policyForSendData+0xe>
c0d0348a:	2802      	cmp	r0, #2
c0d0348c:	d103      	bne.n	c0d03496 <policyForSendData+0x12>
c0d0348e:	2002      	movs	r0, #2
	} else if(should_display == DONT_DISPLAY) {
		ALLOW();
	} else {
		THROW(ERR_NOT_IMPLEMENTED);
	}
}
c0d03490:	bd80      	pop	{r7, pc}
c0d03492:	2003      	movs	r0, #3
c0d03494:	bd80      	pop	{r7, pc}
c0d03496:	4801      	ldr	r0, [pc, #4]	; (c0d0349c <policyForSendData+0x18>)
		THROW(ERR_NOT_IMPLEMENTED);
c0d03498:	f7fe fe7c 	bl	c0d02194 <os_longjmp>
c0d0349c:	00004701 	.word	0x00004701

c0d034a0 <respondSuccessEmptyMsg>:
#include "textUtils.h"

static ins_sign_transaction_context_t *ctx = &(instructionState.signTransactionContext);

void respondSuccessEmptyMsg()
{
c0d034a0:	b580      	push	{r7, lr}
	TRACE();
c0d034a2:	480c      	ldr	r0, [pc, #48]	; (c0d034d4 <respondSuccessEmptyMsg+0x34>)
c0d034a4:	4478      	add	r0, pc
c0d034a6:	490c      	ldr	r1, [pc, #48]	; (c0d034d8 <respondSuccessEmptyMsg+0x38>)
c0d034a8:	4479      	add	r1, pc
c0d034aa:	2212      	movs	r2, #18
c0d034ac:	f7ff fbca 	bl	c0d02c44 <mcu_usb_printf>
c0d034b0:	480a      	ldr	r0, [pc, #40]	; (c0d034dc <respondSuccessEmptyMsg+0x3c>)
c0d034b2:	4478      	add	r0, pc
c0d034b4:	f7ff fbc6 	bl	c0d02c44 <mcu_usb_printf>
c0d034b8:	4809      	ldr	r0, [pc, #36]	; (c0d034e0 <respondSuccessEmptyMsg+0x40>)
c0d034ba:	4478      	add	r0, pc
c0d034bc:	f7ff fbc2 	bl	c0d02c44 <mcu_usb_printf>
c0d034c0:	2009      	movs	r0, #9
c0d034c2:	0300      	lsls	r0, r0, #12
c0d034c4:	2100      	movs	r1, #0
	io_send_buf(SUCCESS, NULL, 0);
c0d034c6:	460a      	mov	r2, r1
c0d034c8:	f7fd fe5e 	bl	c0d01188 <io_send_buf>
	ui_displayBusy(); // needs to happen after I/O
c0d034cc:	f003 fa42 	bl	c0d06954 <ui_displayBusy>
}
c0d034d0:	bd80      	pop	{r7, pc}
c0d034d2:	46c0      	nop			; (mov r8, r8)
c0d034d4:	0000551b 	.word	0x0000551b
c0d034d8:	00005efc 	.word	0x00005efc
c0d034dc:	00006075 	.word	0x00006075
c0d034e0:	0000606c 	.word	0x0000606c

c0d034e4 <signTx_handleInitAPDU>:
// TODO send chainId using sendData instead of here, as it is FIO specific
__noinline_due_to_stack__ void signTx_handleInitAPDU(
	uint8_t p2,
	uint8_t *wireDataBuffer,
	size_t wireDataSize)
{
c0d034e4:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d034e6:	b083      	sub	sp, #12
	{
		// sanity checks
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d034e8:	2800      	cmp	r0, #0
c0d034ea:	d167      	bne.n	c0d035bc <signTx_handleInitAPDU+0xd8>
		ASSERT(wireDataSize < BUFFER_SIZE_PARANOIA);
c0d034ec:	0a91      	lsrs	r1, r2, #10
c0d034ee:	4248      	negs	r0, r1
c0d034f0:	4148      	adcs	r0, r1
c0d034f2:	493a      	ldr	r1, [pc, #232]	; (c0d035dc <signTx_handleInitAPDU+0xf8>)
c0d034f4:	4479      	add	r1, pc
c0d034f6:	f7fc fdbb 	bl	c0d00070 <assert>
 */
cx_err_t cx_sha256_init_no_throw(cx_sha256_t *hash);

static inline int cx_sha256_init ( cx_sha256_t * hash )
{
  cx_sha256_init_no_throw(hash);
c0d034fa:	4e36      	ldr	r6, [pc, #216]	; (c0d035d4 <signTx_handleInitAPDU+0xf0>)
c0d034fc:	1d30      	adds	r0, r6, #4
c0d034fe:	f7fc ffcf 	bl	c0d004a0 <cx_sha256_init_no_throw>
c0d03502:	4f35      	ldr	r7, [pc, #212]	; (c0d035d8 <signTx_handleInitAPDU+0xf4>)
} sha_256_context_t;

static __attribute__((always_inline, unused)) void sha_256_init(sha_256_context_t *ctx)
{
	cx_sha256_init(&ctx->cx_ctx);
	ctx->initialized_magic = HASH_CONTEXT_INITIALIZED_MAGIC;
c0d03504:	8037      	strh	r7, [r6, #0]
c0d03506:	2013      	movs	r0, #19
c0d03508:	0100      	lsls	r0, r0, #4
c0d0350a:	ad02      	add	r5, sp, #8
	}

	{
		sha_256_init(&ctx->txHashContext);

		uint8_t constants[] = {0x30, 0x01};
c0d0350c:	8028      	strh	r0, [r5, #0]
c0d0350e:	4630      	mov	r0, r6
c0d03510:	3070      	adds	r0, #112	; 0x70
c0d03512:	1d04      	adds	r4, r0, #4
c0d03514:	4620      	mov	r0, r4
c0d03516:	f7fc ffc3 	bl	c0d004a0 <cx_sha256_init_no_throw>
c0d0351a:	2070      	movs	r0, #112	; 0x70
c0d0351c:	5237      	strh	r7, [r6, r0]
c0d0351e:	4607      	mov	r7, r0
c0d03520:	2001      	movs	r0, #1
}

static __attribute__((always_inline, unused)) void sha_256_append(sha_256_context_t *ctx,
																  const uint8_t *inBuffer, size_t inSize)
{
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03522:	492f      	ldr	r1, [pc, #188]	; (c0d035e0 <signTx_handleInitAPDU+0xfc>)
c0d03524:	4479      	add	r1, pc
c0d03526:	f7fc fda3 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d0352a:	482e      	ldr	r0, [pc, #184]	; (c0d035e4 <signTx_handleInitAPDU+0x100>)
c0d0352c:	4478      	add	r0, pc
c0d0352e:	492e      	ldr	r1, [pc, #184]	; (c0d035e8 <signTx_handleInitAPDU+0x104>)
c0d03530:	4479      	add	r1, pc
c0d03532:	2224      	movs	r2, #36	; 0x24
c0d03534:	f7ff fb86 	bl	c0d02c44 <mcu_usb_printf>
c0d03538:	482c      	ldr	r0, [pc, #176]	; (c0d035ec <signTx_handleInitAPDU+0x108>)
c0d0353a:	4478      	add	r0, pc
c0d0353c:	2602      	movs	r6, #2
c0d0353e:	4631      	mov	r1, r6
c0d03540:	462a      	mov	r2, r5
c0d03542:	f7ff fb7f 	bl	c0d02c44 <mcu_usb_printf>
c0d03546:	482a      	ldr	r0, [pc, #168]	; (c0d035f0 <signTx_handleInitAPDU+0x10c>)
c0d03548:	4478      	add	r0, pc
c0d0354a:	f7ff fb7b 	bl	c0d02c44 <mcu_usb_printf>
c0d0354e:	2100      	movs	r1, #0
 */
cx_err_t cx_hash_no_throw(cx_hash_t *hash, uint32_t mode, const uint8_t *in, size_t len, uint8_t *out, size_t out_len);

static inline int cx_hash ( cx_hash_t * hash, int mode, const unsigned char * in, unsigned int len, unsigned char * out, unsigned int out_len )
{
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d03550:	9100      	str	r1, [sp, #0]
c0d03552:	9101      	str	r1, [sp, #4]
c0d03554:	4620      	mov	r0, r4
c0d03556:	462a      	mov	r2, r5
c0d03558:	4633      	mov	r3, r6
c0d0355a:	f7fc ff89 	bl	c0d00470 <cx_hash_no_throw>
c0d0355e:	2800      	cmp	r0, #0
c0d03560:	d134      	bne.n	c0d035cc <signTx_handleInitAPDU+0xe8>
  return cx_hash_get_size(hash);
c0d03562:	4620      	mov	r0, r4
c0d03564:	f7fc ff7e 	bl	c0d00464 <cx_hash_get_size>
c0d03568:	491a      	ldr	r1, [pc, #104]	; (c0d035d4 <signTx_handleInitAPDU+0xf0>)

static __attribute__((always_inline, unused)) void sha_256_finalize(sha_256_context_t *ctx,
																	uint8_t *outBuffer, size_t outSize)
{

	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d0356a:	5bc8      	ldrh	r0, [r1, r7]
c0d0356c:	460f      	mov	r7, r1
c0d0356e:	491a      	ldr	r1, [pc, #104]	; (c0d035d8 <signTx_handleInitAPDU+0xf4>)
c0d03570:	1a41      	subs	r1, r0, r1
c0d03572:	4248      	negs	r0, r1
c0d03574:	4148      	adcs	r0, r1
c0d03576:	491f      	ldr	r1, [pc, #124]	; (c0d035f4 <signTx_handleInitAPDU+0x110>)
c0d03578:	4479      	add	r1, pc
c0d0357a:	f7fc fd79 	bl	c0d00070 <assert>
c0d0357e:	2601      	movs	r6, #1
	ASSERT(outSize == SHA_256_SIZE);
c0d03580:	491d      	ldr	r1, [pc, #116]	; (c0d035f8 <signTx_handleInitAPDU+0x114>)
c0d03582:	4479      	add	r1, pc
c0d03584:	4630      	mov	r0, r6
c0d03586:	f7fc fd73 	bl	c0d00070 <assert>
c0d0358a:	2020      	movs	r0, #32
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d0358c:	4639      	mov	r1, r7
c0d0358e:	31e0      	adds	r1, #224	; 0xe0
c0d03590:	9100      	str	r1, [sp, #0]
c0d03592:	9001      	str	r0, [sp, #4]
c0d03594:	2500      	movs	r5, #0
c0d03596:	4620      	mov	r0, r4
c0d03598:	4631      	mov	r1, r6
c0d0359a:	462a      	mov	r2, r5
c0d0359c:	462b      	mov	r3, r5
c0d0359e:	f7fc ff67 	bl	c0d00470 <cx_hash_no_throw>
c0d035a2:	2800      	cmp	r0, #0
c0d035a4:	d112      	bne.n	c0d035cc <signTx_handleInitAPDU+0xe8>
  return cx_hash_get_size(hash);
c0d035a6:	4638      	mov	r0, r7
c0d035a8:	3074      	adds	r0, #116	; 0x74
c0d035aa:	f7fc ff5b 	bl	c0d00464 <cx_hash_get_size>
c0d035ae:	20ff      	movs	r0, #255	; 0xff
c0d035b0:	3022      	adds	r0, #34	; 0x22

		sha_256_init(&ctx->integrityHashContext);
		sha_256_append(&ctx->integrityHashContext, constants, SIZEOF(constants));
		sha_256_finalize(&ctx->integrityHashContext, ctx->prevHash, 32);

		ctx->sectionLevel = 0;
c0d035b2:	543d      	strb	r5, [r7, r0]
	respondSuccessEmptyMsg();
c0d035b4:	f7ff ff74 	bl	c0d034a0 <respondSuccessEmptyMsg>
	}

	signTx_handleInit_ui_runStep();
}
c0d035b8:	b003      	add	sp, #12
c0d035ba:	bdf0      	pop	{r4, r5, r6, r7, pc}
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d035bc:	480f      	ldr	r0, [pc, #60]	; (c0d035fc <signTx_handleInitAPDU+0x118>)
c0d035be:	4478      	add	r0, pc
c0d035c0:	490f      	ldr	r1, [pc, #60]	; (c0d03600 <signTx_handleInitAPDU+0x11c>)
c0d035c2:	4479      	add	r1, pc
c0d035c4:	223d      	movs	r2, #61	; 0x3d
c0d035c6:	f7ff fb3d 	bl	c0d02c44 <mcu_usb_printf>
c0d035ca:	4801      	ldr	r0, [pc, #4]	; (c0d035d0 <signTx_handleInitAPDU+0xec>)
c0d035cc:	f7fe fde2 	bl	c0d02194 <os_longjmp>
c0d035d0:	00006e05 	.word	0x00006e05
c0d035d4:	20000490 	.word	0x20000490
c0d035d8:	00003039 	.word	0x00003039
c0d035dc:	00005edd 	.word	0x00005edd
c0d035e0:	000060d9 	.word	0x000060d9
c0d035e4:	00005493 	.word	0x00005493
c0d035e8:	000060db 	.word	0x000060db
c0d035ec:	000054a6 	.word	0x000054a6
c0d035f0:	00005fde 	.word	0x00005fde
c0d035f4:	000060a2 	.word	0x000060a2
c0d035f8:	000060a6 	.word	0x000060a6
c0d035fc:	00005040 	.word	0x00005040
c0d03600:	00005df9 	.word	0x00005df9

c0d03604 <signTx_handleStartCountedSectionAPDU>:

__noinline_due_to_stack__ void signTx_handleStartCountedSectionAPDU(
	uint8_t p2,
	uint8_t *wireDataBuffer,
	size_t wireDataSize)
{
c0d03604:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d03606:	b089      	sub	sp, #36	; 0x24
	{
		// sanity checks
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d03608:	2800      	cmp	r0, #0
c0d0360a:	d000      	beq.n	c0d0360e <signTx_handleStartCountedSectionAPDU+0xa>
c0d0360c:	e0e7      	b.n	c0d037de <signTx_handleStartCountedSectionAPDU+0x1da>
c0d0360e:	4614      	mov	r4, r2
c0d03610:	460e      	mov	r6, r1
		ASSERT(wireDataSize < BUFFER_SIZE_PARANOIA);
c0d03612:	0a91      	lsrs	r1, r2, #10
c0d03614:	4248      	negs	r0, r1
c0d03616:	4148      	adcs	r0, r1
c0d03618:	4984      	ldr	r1, [pc, #528]	; (c0d0382c <signTx_handleStartCountedSectionAPDU+0x228>)
c0d0361a:	4479      	add	r1, pc
c0d0361c:	f7fc fd28 	bl	c0d00070 <assert>
		struct
		{
			uint8_t sectionLength[9]; // 0-terminated
		} *wireData = (void *)wireDataBuffer;

		VALIDATE(SIZEOF(*wireData) == wireDataSize, ERR_INVALID_DATA);
c0d03620:	2c09      	cmp	r4, #9
c0d03622:	d000      	beq.n	c0d03626 <signTx_handleStartCountedSectionAPDU+0x22>
c0d03624:	e0e5      	b.n	c0d037f2 <signTx_handleStartCountedSectionAPDU+0x1ee>
c0d03626:	21ff      	movs	r1, #255	; 0xff
c0d03628:	3122      	adds	r1, #34	; 0x22

		VALIDATE(ctx->sectionLevel < MAX_NESTED_COUNTED_SECTIONS, ERR_UNEXPECTED_INS);
c0d0362a:	487e      	ldr	r0, [pc, #504]	; (c0d03824 <signTx_handleStartCountedSectionAPDU+0x220>)
c0d0362c:	5c40      	ldrb	r0, [r0, r1]
c0d0362e:	2808      	cmp	r0, #8
c0d03630:	d300      	bcc.n	c0d03634 <signTx_handleStartCountedSectionAPDU+0x30>
c0d03632:	e0e9      	b.n	c0d03808 <signTx_handleStartCountedSectionAPDU+0x204>
	return inBuffer[0];
c0d03634:	79b2      	ldrb	r2, [r6, #6]
c0d03636:	9207      	str	r2, [sp, #28]
c0d03638:	79f3      	ldrb	r3, [r6, #7]
c0d0363a:	7975      	ldrb	r5, [r6, #5]
c0d0363c:	9605      	str	r6, [sp, #20]
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d0363e:	7936      	ldrb	r6, [r6, #4]

		uint64_t parsedSectionLength = (uint32_t)u8be_read(wireData->sectionLength);

		ctx->sectionLevel++;
c0d03640:	1c40      	adds	r0, r0, #1
c0d03642:	4a78      	ldr	r2, [pc, #480]	; (c0d03824 <signTx_handleStartCountedSectionAPDU+0x220>)
c0d03644:	5450      	strb	r0, [r2, r1]
		ctx->expectedSectionLength[ctx->sectionLevel] = parsedSectionLength;
c0d03646:	00c1      	lsls	r1, r0, #3
c0d03648:	1851      	adds	r1, r2, r1
c0d0364a:	4614      	mov	r4, r2
c0d0364c:	2717      	movs	r7, #23
c0d0364e:	013a      	lsls	r2, r7, #4
c0d03650:	2700      	movs	r7, #0
		ctx->currSectionLength[ctx->sectionLevel] = 0;
c0d03652:	508f      	str	r7, [r1, r2]
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03654:	0636      	lsls	r6, r6, #24
c0d03656:	042d      	lsls	r5, r5, #16
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d03658:	19ad      	adds	r5, r5, r6
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d0365a:	18eb      	adds	r3, r5, r3
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d0365c:	9d07      	ldr	r5, [sp, #28]
c0d0365e:	022d      	lsls	r5, r5, #8
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03660:	195b      	adds	r3, r3, r5
c0d03662:	2525      	movs	r5, #37	; 0x25
c0d03664:	00ed      	lsls	r5, r5, #3
		ctx->expectedSectionLength[ctx->sectionLevel] = parsedSectionLength;
c0d03666:	514b      	str	r3, [r1, r5]
c0d03668:	194b      	adds	r3, r1, r5
c0d0366a:	605f      	str	r7, [r3, #4]
		ctx->currSectionLength[ctx->sectionLevel] = 0;
c0d0366c:	1889      	adds	r1, r1, r2
c0d0366e:	604f      	str	r7, [r1, #4]
c0d03670:	ad08      	add	r5, sp, #32

		uint8_t constants[] = {0x30, 0x09, ctx->sectionLevel};
c0d03672:	70a8      	strb	r0, [r5, #2]
c0d03674:	2009      	movs	r0, #9
c0d03676:	7068      	strb	r0, [r5, #1]
c0d03678:	2030      	movs	r0, #48	; 0x30
c0d0367a:	7028      	strb	r0, [r5, #0]
c0d0367c:	4626      	mov	r6, r4
c0d0367e:	4620      	mov	r0, r4
c0d03680:	3070      	adds	r0, #112	; 0x70
c0d03682:	1d04      	adds	r4, r0, #4
c0d03684:	4620      	mov	r0, r4
c0d03686:	f7fc ff0b 	bl	c0d004a0 <cx_sha256_init_no_throw>
c0d0368a:	2170      	movs	r1, #112	; 0x70
c0d0368c:	4866      	ldr	r0, [pc, #408]	; (c0d03828 <signTx_handleStartCountedSectionAPDU+0x224>)
c0d0368e:	9106      	str	r1, [sp, #24]
	ctx->initialized_magic = HASH_CONTEXT_INITIALIZED_MAGIC;
c0d03690:	5270      	strh	r0, [r6, r1]
c0d03692:	2001      	movs	r0, #1
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03694:	4966      	ldr	r1, [pc, #408]	; (c0d03830 <signTx_handleStartCountedSectionAPDU+0x22c>)
c0d03696:	4479      	add	r1, pc
c0d03698:	f7fc fcea 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d0369c:	4865      	ldr	r0, [pc, #404]	; (c0d03834 <signTx_handleStartCountedSectionAPDU+0x230>)
c0d0369e:	4478      	add	r0, pc
c0d036a0:	4965      	ldr	r1, [pc, #404]	; (c0d03838 <signTx_handleStartCountedSectionAPDU+0x234>)
c0d036a2:	4479      	add	r1, pc
c0d036a4:	2224      	movs	r2, #36	; 0x24
c0d036a6:	f7ff facd 	bl	c0d02c44 <mcu_usb_printf>
c0d036aa:	4864      	ldr	r0, [pc, #400]	; (c0d0383c <signTx_handleStartCountedSectionAPDU+0x238>)
c0d036ac:	4478      	add	r0, pc
c0d036ae:	2603      	movs	r6, #3
c0d036b0:	4631      	mov	r1, r6
c0d036b2:	462a      	mov	r2, r5
c0d036b4:	f7ff fac6 	bl	c0d02c44 <mcu_usb_printf>
c0d036b8:	4861      	ldr	r0, [pc, #388]	; (c0d03840 <signTx_handleStartCountedSectionAPDU+0x23c>)
c0d036ba:	4478      	add	r0, pc
c0d036bc:	f7ff fac2 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d036c0:	9700      	str	r7, [sp, #0]
c0d036c2:	9701      	str	r7, [sp, #4]
c0d036c4:	9407      	str	r4, [sp, #28]
c0d036c6:	4620      	mov	r0, r4
c0d036c8:	4639      	mov	r1, r7
c0d036ca:	462a      	mov	r2, r5
c0d036cc:	4633      	mov	r3, r6
c0d036ce:	f7fc fecf 	bl	c0d00470 <cx_hash_no_throw>
c0d036d2:	2800      	cmp	r0, #0
c0d036d4:	d000      	beq.n	c0d036d8 <signTx_handleStartCountedSectionAPDU+0xd4>
c0d036d6:	e0a0      	b.n	c0d0381a <signTx_handleStartCountedSectionAPDU+0x216>
c0d036d8:	9d07      	ldr	r5, [sp, #28]
  return cx_hash_get_size(hash);
c0d036da:	4628      	mov	r0, r5
c0d036dc:	f7fc fec2 	bl	c0d00464 <cx_hash_get_size>
c0d036e0:	4c50      	ldr	r4, [pc, #320]	; (c0d03824 <signTx_handleStartCountedSectionAPDU+0x220>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d036e2:	9806      	ldr	r0, [sp, #24]
c0d036e4:	5a20      	ldrh	r0, [r4, r0]
c0d036e6:	4950      	ldr	r1, [pc, #320]	; (c0d03828 <signTx_handleStartCountedSectionAPDU+0x224>)
c0d036e8:	1a41      	subs	r1, r0, r1
c0d036ea:	4248      	negs	r0, r1
c0d036ec:	4148      	adcs	r0, r1
c0d036ee:	4955      	ldr	r1, [pc, #340]	; (c0d03844 <signTx_handleStartCountedSectionAPDU+0x240>)
c0d036f0:	4479      	add	r1, pc
c0d036f2:	f7fc fcbd 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d036f6:	4854      	ldr	r0, [pc, #336]	; (c0d03848 <signTx_handleStartCountedSectionAPDU+0x244>)
c0d036f8:	4478      	add	r0, pc
c0d036fa:	4954      	ldr	r1, [pc, #336]	; (c0d0384c <signTx_handleStartCountedSectionAPDU+0x248>)
c0d036fc:	4479      	add	r1, pc
c0d036fe:	2224      	movs	r2, #36	; 0x24
c0d03700:	f7ff faa0 	bl	c0d02c44 <mcu_usb_printf>
c0d03704:	34e0      	adds	r4, #224	; 0xe0
c0d03706:	4852      	ldr	r0, [pc, #328]	; (c0d03850 <signTx_handleStartCountedSectionAPDU+0x24c>)
c0d03708:	4478      	add	r0, pc
c0d0370a:	2620      	movs	r6, #32
c0d0370c:	4631      	mov	r1, r6
c0d0370e:	4622      	mov	r2, r4
c0d03710:	f7ff fa98 	bl	c0d02c44 <mcu_usb_printf>
c0d03714:	484f      	ldr	r0, [pc, #316]	; (c0d03854 <signTx_handleStartCountedSectionAPDU+0x250>)
c0d03716:	4478      	add	r0, pc
c0d03718:	f7ff fa94 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d0371c:	9700      	str	r7, [sp, #0]
c0d0371e:	9701      	str	r7, [sp, #4]
c0d03720:	4628      	mov	r0, r5
c0d03722:	4639      	mov	r1, r7
c0d03724:	4622      	mov	r2, r4
c0d03726:	9603      	str	r6, [sp, #12]
c0d03728:	4633      	mov	r3, r6
c0d0372a:	f7fc fea1 	bl	c0d00470 <cx_hash_no_throw>
c0d0372e:	2800      	cmp	r0, #0
c0d03730:	d173      	bne.n	c0d0381a <signTx_handleStartCountedSectionAPDU+0x216>
c0d03732:	9404      	str	r4, [sp, #16]
c0d03734:	9c07      	ldr	r4, [sp, #28]
  return cx_hash_get_size(hash);
c0d03736:	4620      	mov	r0, r4
c0d03738:	f7fc fe94 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d0373c:	4839      	ldr	r0, [pc, #228]	; (c0d03824 <signTx_handleStartCountedSectionAPDU+0x220>)
c0d0373e:	9906      	ldr	r1, [sp, #24]
c0d03740:	5a40      	ldrh	r0, [r0, r1]
c0d03742:	4939      	ldr	r1, [pc, #228]	; (c0d03828 <signTx_handleStartCountedSectionAPDU+0x224>)
c0d03744:	1a41      	subs	r1, r0, r1
c0d03746:	4248      	negs	r0, r1
c0d03748:	4148      	adcs	r0, r1
c0d0374a:	4943      	ldr	r1, [pc, #268]	; (c0d03858 <signTx_handleStartCountedSectionAPDU+0x254>)
c0d0374c:	4479      	add	r1, pc
c0d0374e:	f7fc fc8f 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d03752:	4842      	ldr	r0, [pc, #264]	; (c0d0385c <signTx_handleStartCountedSectionAPDU+0x258>)
c0d03754:	4478      	add	r0, pc
c0d03756:	4942      	ldr	r1, [pc, #264]	; (c0d03860 <signTx_handleStartCountedSectionAPDU+0x25c>)
c0d03758:	4479      	add	r1, pc
c0d0375a:	2224      	movs	r2, #36	; 0x24
c0d0375c:	f7ff fa72 	bl	c0d02c44 <mcu_usb_printf>
c0d03760:	4840      	ldr	r0, [pc, #256]	; (c0d03864 <signTx_handleStartCountedSectionAPDU+0x260>)
c0d03762:	4478      	add	r0, pc
c0d03764:	2609      	movs	r6, #9
c0d03766:	4631      	mov	r1, r6
c0d03768:	9d05      	ldr	r5, [sp, #20]
c0d0376a:	462a      	mov	r2, r5
c0d0376c:	f7ff fa6a 	bl	c0d02c44 <mcu_usb_printf>
c0d03770:	483d      	ldr	r0, [pc, #244]	; (c0d03868 <signTx_handleStartCountedSectionAPDU+0x264>)
c0d03772:	4478      	add	r0, pc
c0d03774:	f7ff fa66 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d03778:	9700      	str	r7, [sp, #0]
c0d0377a:	9701      	str	r7, [sp, #4]
c0d0377c:	4620      	mov	r0, r4
c0d0377e:	4639      	mov	r1, r7
c0d03780:	462a      	mov	r2, r5
c0d03782:	4633      	mov	r3, r6
c0d03784:	f7fc fe74 	bl	c0d00470 <cx_hash_no_throw>
c0d03788:	2800      	cmp	r0, #0
c0d0378a:	d146      	bne.n	c0d0381a <signTx_handleStartCountedSectionAPDU+0x216>
c0d0378c:	9c07      	ldr	r4, [sp, #28]
  return cx_hash_get_size(hash);
c0d0378e:	4620      	mov	r0, r4
c0d03790:	f7fc fe68 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03794:	4823      	ldr	r0, [pc, #140]	; (c0d03824 <signTx_handleStartCountedSectionAPDU+0x220>)
c0d03796:	9906      	ldr	r1, [sp, #24]
c0d03798:	5a40      	ldrh	r0, [r0, r1]
c0d0379a:	4923      	ldr	r1, [pc, #140]	; (c0d03828 <signTx_handleStartCountedSectionAPDU+0x224>)
c0d0379c:	1a41      	subs	r1, r0, r1
c0d0379e:	4248      	negs	r0, r1
c0d037a0:	4148      	adcs	r0, r1
c0d037a2:	4932      	ldr	r1, [pc, #200]	; (c0d0386c <signTx_handleStartCountedSectionAPDU+0x268>)
c0d037a4:	4479      	add	r1, pc
c0d037a6:	f7fc fc63 	bl	c0d00070 <assert>
c0d037aa:	2601      	movs	r6, #1
	ASSERT(outSize == SHA_256_SIZE);
c0d037ac:	4930      	ldr	r1, [pc, #192]	; (c0d03870 <signTx_handleStartCountedSectionAPDU+0x26c>)
c0d037ae:	4479      	add	r1, pc
c0d037b0:	4630      	mov	r0, r6
c0d037b2:	f7fc fc5d 	bl	c0d00070 <assert>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d037b6:	9804      	ldr	r0, [sp, #16]
c0d037b8:	9000      	str	r0, [sp, #0]
c0d037ba:	9803      	ldr	r0, [sp, #12]
c0d037bc:	9001      	str	r0, [sp, #4]
c0d037be:	2200      	movs	r2, #0
c0d037c0:	4620      	mov	r0, r4
c0d037c2:	4631      	mov	r1, r6
c0d037c4:	4613      	mov	r3, r2
c0d037c6:	f7fc fe53 	bl	c0d00470 <cx_hash_no_throw>
c0d037ca:	2800      	cmp	r0, #0
c0d037cc:	d125      	bne.n	c0d0381a <signTx_handleStartCountedSectionAPDU+0x216>
c0d037ce:	4815      	ldr	r0, [pc, #84]	; (c0d03824 <signTx_handleStartCountedSectionAPDU+0x220>)
  return cx_hash_get_size(hash);
c0d037d0:	3074      	adds	r0, #116	; 0x74
c0d037d2:	f7fc fe47 	bl	c0d00464 <cx_hash_get_size>
	respondSuccessEmptyMsg();
c0d037d6:	f7ff fe63 	bl	c0d034a0 <respondSuccessEmptyMsg>
			SIZEOF(wireData->sectionLength));
		sha_256_finalize(&ctx->integrityHashContext, ctx->prevHash, 32);
	}

	signTx_handleStartCountedSection_ui_runStep();
}
c0d037da:	b009      	add	sp, #36	; 0x24
c0d037dc:	bdf0      	pop	{r4, r5, r6, r7, pc}
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d037de:	4825      	ldr	r0, [pc, #148]	; (c0d03874 <signTx_handleStartCountedSectionAPDU+0x270>)
c0d037e0:	4478      	add	r0, pc
c0d037e2:	4925      	ldr	r1, [pc, #148]	; (c0d03878 <signTx_handleStartCountedSectionAPDU+0x274>)
c0d037e4:	4479      	add	r1, pc
c0d037e6:	225e      	movs	r2, #94	; 0x5e
c0d037e8:	f7ff fa2c 	bl	c0d02c44 <mcu_usb_printf>
c0d037ec:	480c      	ldr	r0, [pc, #48]	; (c0d03820 <signTx_handleStartCountedSectionAPDU+0x21c>)
c0d037ee:	f7fe fcd1 	bl	c0d02194 <os_longjmp>
		VALIDATE(SIZEOF(*wireData) == wireDataSize, ERR_INVALID_DATA);
c0d037f2:	4822      	ldr	r0, [pc, #136]	; (c0d0387c <signTx_handleStartCountedSectionAPDU+0x278>)
c0d037f4:	4478      	add	r0, pc
c0d037f6:	4922      	ldr	r1, [pc, #136]	; (c0d03880 <signTx_handleStartCountedSectionAPDU+0x27c>)
c0d037f8:	4479      	add	r1, pc
c0d037fa:	2268      	movs	r2, #104	; 0x68
c0d037fc:	f7ff fa22 	bl	c0d02c44 <mcu_usb_printf>
c0d03800:	4807      	ldr	r0, [pc, #28]	; (c0d03820 <signTx_handleStartCountedSectionAPDU+0x21c>)
c0d03802:	1c80      	adds	r0, r0, #2
c0d03804:	f7fe fcc6 	bl	c0d02194 <os_longjmp>
		VALIDATE(ctx->sectionLevel < MAX_NESTED_COUNTED_SECTIONS, ERR_UNEXPECTED_INS);
c0d03808:	481e      	ldr	r0, [pc, #120]	; (c0d03884 <signTx_handleStartCountedSectionAPDU+0x280>)
c0d0380a:	4478      	add	r0, pc
c0d0380c:	491e      	ldr	r1, [pc, #120]	; (c0d03888 <signTx_handleStartCountedSectionAPDU+0x284>)
c0d0380e:	4479      	add	r1, pc
c0d03810:	226a      	movs	r2, #106	; 0x6a
c0d03812:	f7ff fa17 	bl	c0d02c44 <mcu_usb_printf>
c0d03816:	2005      	movs	r0, #5
c0d03818:	0300      	lsls	r0, r0, #12
c0d0381a:	f7fe fcbb 	bl	c0d02194 <os_longjmp>
c0d0381e:	46c0      	nop			; (mov r8, r8)
c0d03820:	00006e05 	.word	0x00006e05
c0d03824:	20000490 	.word	0x20000490
c0d03828:	00003039 	.word	0x00003039
c0d0382c:	00005dd0 	.word	0x00005dd0
c0d03830:	00005f67 	.word	0x00005f67
c0d03834:	00005321 	.word	0x00005321
c0d03838:	00005f69 	.word	0x00005f69
c0d0383c:	00005334 	.word	0x00005334
c0d03840:	00005e6c 	.word	0x00005e6c
c0d03844:	00005f0d 	.word	0x00005f0d
c0d03848:	000052c7 	.word	0x000052c7
c0d0384c:	00005f0f 	.word	0x00005f0f
c0d03850:	000052d8 	.word	0x000052d8
c0d03854:	00005e10 	.word	0x00005e10
c0d03858:	00005eb1 	.word	0x00005eb1
c0d0385c:	0000526b 	.word	0x0000526b
c0d03860:	00005eb3 	.word	0x00005eb3
c0d03864:	0000527e 	.word	0x0000527e
c0d03868:	00005db4 	.word	0x00005db4
c0d0386c:	00005e76 	.word	0x00005e76
c0d03870:	00005e7a 	.word	0x00005e7a
c0d03874:	00004e1e 	.word	0x00004e1e
c0d03878:	00005bd7 	.word	0x00005bd7
c0d0387c:	00004e0a 	.word	0x00004e0a
c0d03880:	00005bc3 	.word	0x00005bc3
c0d03884:	00004df4 	.word	0x00004df4
c0d03888:	00005bad 	.word	0x00005bad

c0d0388c <signTx_handleEndCountedSectionAPDU>:

__noinline_due_to_stack__ void signTx_handleEndCountedSectionAPDU(
	uint8_t p2,
	uint8_t *wireDataBuffer,
	size_t wireDataSize)
{
c0d0388c:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0388e:	b085      	sub	sp, #20
	{
		// sanity checks
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d03890:	2800      	cmp	r0, #0
c0d03892:	d000      	beq.n	c0d03896 <signTx_handleEndCountedSectionAPDU+0xa>
c0d03894:	e0b4      	b.n	c0d03a00 <signTx_handleEndCountedSectionAPDU+0x174>
		ASSERT(wireDataSize < BUFFER_SIZE_PARANOIA);
c0d03896:	0a91      	lsrs	r1, r2, #10
c0d03898:	4248      	negs	r0, r1
c0d0389a:	4148      	adcs	r0, r1
c0d0389c:	496b      	ldr	r1, [pc, #428]	; (c0d03a4c <signTx_handleEndCountedSectionAPDU+0x1c0>)
c0d0389e:	4479      	add	r1, pc
c0d038a0:	1c49      	adds	r1, r1, #1
c0d038a2:	f7fc fbe5 	bl	c0d00070 <assert>
c0d038a6:	20ff      	movs	r0, #255	; 0xff
c0d038a8:	3022      	adds	r0, #34	; 0x22
	}

	{
		VALIDATE(ctx->sectionLevel > 0, ERR_UNEXPECTED_INS);
c0d038aa:	4c66      	ldr	r4, [pc, #408]	; (c0d03a44 <signTx_handleEndCountedSectionAPDU+0x1b8>)
c0d038ac:	5c21      	ldrb	r1, [r4, r0]
c0d038ae:	2900      	cmp	r1, #0
c0d038b0:	d100      	bne.n	c0d038b4 <signTx_handleEndCountedSectionAPDU+0x28>
c0d038b2:	e0af      	b.n	c0d03a14 <signTx_handleEndCountedSectionAPDU+0x188>
		VALIDATE(
c0d038b4:	00ca      	lsls	r2, r1, #3
c0d038b6:	18a2      	adds	r2, r4, r2
c0d038b8:	2317      	movs	r3, #23
c0d038ba:	011d      	lsls	r5, r3, #4
c0d038bc:	5956      	ldr	r6, [r2, r5]
c0d038be:	2325      	movs	r3, #37	; 0x25
c0d038c0:	00df      	lsls	r7, r3, #3
c0d038c2:	59d3      	ldr	r3, [r2, r7]
c0d038c4:	9303      	str	r3, [sp, #12]
c0d038c6:	405e      	eors	r6, r3
c0d038c8:	1955      	adds	r5, r2, r5
c0d038ca:	686b      	ldr	r3, [r5, #4]
c0d038cc:	19d5      	adds	r5, r2, r7
c0d038ce:	686d      	ldr	r5, [r5, #4]
c0d038d0:	406b      	eors	r3, r5
c0d038d2:	4333      	orrs	r3, r6
c0d038d4:	d000      	beq.n	c0d038d8 <signTx_handleEndCountedSectionAPDU+0x4c>
c0d038d6:	e0a8      	b.n	c0d03a2a <signTx_handleEndCountedSectionAPDU+0x19e>
			ctx->expectedSectionLength[ctx->sectionLevel] == ctx->currSectionLength[ctx->sectionLevel],
			ERR_INVALID_DATA);

		// Add the length of all data received in this section to the parent section
		if (ctx->sectionLevel > 1)
c0d038d8:	2902      	cmp	r1, #2
c0d038da:	d30a      	bcc.n	c0d038f2 <signTx_handleEndCountedSectionAPDU+0x66>
c0d038dc:	232d      	movs	r3, #45	; 0x2d
c0d038de:	00db      	lsls	r3, r3, #3
		{
			ctx->currSectionLength[ctx->sectionLevel - 1] += ctx->currSectionLength[ctx->sectionLevel];
c0d038e0:	18d6      	adds	r6, r2, r3
c0d038e2:	58d7      	ldr	r7, [r2, r3]
c0d038e4:	9c03      	ldr	r4, [sp, #12]
c0d038e6:	193f      	adds	r7, r7, r4
c0d038e8:	4c56      	ldr	r4, [pc, #344]	; (c0d03a44 <signTx_handleEndCountedSectionAPDU+0x1b8>)
c0d038ea:	50d7      	str	r7, [r2, r3]
c0d038ec:	6872      	ldr	r2, [r6, #4]
c0d038ee:	416a      	adcs	r2, r5
c0d038f0:	6072      	str	r2, [r6, #4]
		}

		ctx->sectionLevel--;
c0d038f2:	1e49      	subs	r1, r1, #1
c0d038f4:	5421      	strb	r1, [r4, r0]
c0d038f6:	20a3      	movs	r0, #163	; 0xa3
c0d038f8:	0100      	lsls	r0, r0, #4
c0d038fa:	ad04      	add	r5, sp, #16

		uint8_t constants[] = {0x30, 0x0a};
c0d038fc:	8028      	strh	r0, [r5, #0]
c0d038fe:	4620      	mov	r0, r4
c0d03900:	3070      	adds	r0, #112	; 0x70
c0d03902:	4626      	mov	r6, r4
c0d03904:	1d04      	adds	r4, r0, #4
c0d03906:	4620      	mov	r0, r4
c0d03908:	f7fc fdca 	bl	c0d004a0 <cx_sha256_init_no_throw>
c0d0390c:	2170      	movs	r1, #112	; 0x70
c0d0390e:	484e      	ldr	r0, [pc, #312]	; (c0d03a48 <signTx_handleEndCountedSectionAPDU+0x1bc>)
c0d03910:	9102      	str	r1, [sp, #8]
	ctx->initialized_magic = HASH_CONTEXT_INITIALIZED_MAGIC;
c0d03912:	5270      	strh	r0, [r6, r1]
c0d03914:	2001      	movs	r0, #1
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03916:	494e      	ldr	r1, [pc, #312]	; (c0d03a50 <signTx_handleEndCountedSectionAPDU+0x1c4>)
c0d03918:	4479      	add	r1, pc
c0d0391a:	f7fc fba9 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d0391e:	484d      	ldr	r0, [pc, #308]	; (c0d03a54 <signTx_handleEndCountedSectionAPDU+0x1c8>)
c0d03920:	4478      	add	r0, pc
c0d03922:	494d      	ldr	r1, [pc, #308]	; (c0d03a58 <signTx_handleEndCountedSectionAPDU+0x1cc>)
c0d03924:	4479      	add	r1, pc
c0d03926:	2224      	movs	r2, #36	; 0x24
c0d03928:	f7ff f98c 	bl	c0d02c44 <mcu_usb_printf>
c0d0392c:	484b      	ldr	r0, [pc, #300]	; (c0d03a5c <signTx_handleEndCountedSectionAPDU+0x1d0>)
c0d0392e:	4478      	add	r0, pc
c0d03930:	2702      	movs	r7, #2
c0d03932:	4639      	mov	r1, r7
c0d03934:	462a      	mov	r2, r5
c0d03936:	f7ff f985 	bl	c0d02c44 <mcu_usb_printf>
c0d0393a:	4849      	ldr	r0, [pc, #292]	; (c0d03a60 <signTx_handleEndCountedSectionAPDU+0x1d4>)
c0d0393c:	4478      	add	r0, pc
c0d0393e:	f7ff f981 	bl	c0d02c44 <mcu_usb_printf>
c0d03942:	2600      	movs	r6, #0
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d03944:	9600      	str	r6, [sp, #0]
c0d03946:	9601      	str	r6, [sp, #4]
c0d03948:	9403      	str	r4, [sp, #12]
c0d0394a:	4620      	mov	r0, r4
c0d0394c:	4631      	mov	r1, r6
c0d0394e:	462a      	mov	r2, r5
c0d03950:	463b      	mov	r3, r7
c0d03952:	f7fc fd8d 	bl	c0d00470 <cx_hash_no_throw>
c0d03956:	2800      	cmp	r0, #0
c0d03958:	d170      	bne.n	c0d03a3c <signTx_handleEndCountedSectionAPDU+0x1b0>
c0d0395a:	9c03      	ldr	r4, [sp, #12]
  return cx_hash_get_size(hash);
c0d0395c:	4620      	mov	r0, r4
c0d0395e:	f7fc fd81 	bl	c0d00464 <cx_hash_get_size>
c0d03962:	4f38      	ldr	r7, [pc, #224]	; (c0d03a44 <signTx_handleEndCountedSectionAPDU+0x1b8>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03964:	9802      	ldr	r0, [sp, #8]
c0d03966:	5a38      	ldrh	r0, [r7, r0]
c0d03968:	4937      	ldr	r1, [pc, #220]	; (c0d03a48 <signTx_handleEndCountedSectionAPDU+0x1bc>)
c0d0396a:	1a41      	subs	r1, r0, r1
c0d0396c:	4248      	negs	r0, r1
c0d0396e:	4148      	adcs	r0, r1
c0d03970:	493c      	ldr	r1, [pc, #240]	; (c0d03a64 <signTx_handleEndCountedSectionAPDU+0x1d8>)
c0d03972:	4479      	add	r1, pc
c0d03974:	f7fc fb7c 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d03978:	483b      	ldr	r0, [pc, #236]	; (c0d03a68 <signTx_handleEndCountedSectionAPDU+0x1dc>)
c0d0397a:	4478      	add	r0, pc
c0d0397c:	493b      	ldr	r1, [pc, #236]	; (c0d03a6c <signTx_handleEndCountedSectionAPDU+0x1e0>)
c0d0397e:	4479      	add	r1, pc
c0d03980:	2224      	movs	r2, #36	; 0x24
c0d03982:	f7ff f95f 	bl	c0d02c44 <mcu_usb_printf>
c0d03986:	37e0      	adds	r7, #224	; 0xe0
c0d03988:	4839      	ldr	r0, [pc, #228]	; (c0d03a70 <signTx_handleEndCountedSectionAPDU+0x1e4>)
c0d0398a:	4478      	add	r0, pc
c0d0398c:	2520      	movs	r5, #32
c0d0398e:	4629      	mov	r1, r5
c0d03990:	463a      	mov	r2, r7
c0d03992:	f7ff f957 	bl	c0d02c44 <mcu_usb_printf>
c0d03996:	4837      	ldr	r0, [pc, #220]	; (c0d03a74 <signTx_handleEndCountedSectionAPDU+0x1e8>)
c0d03998:	4478      	add	r0, pc
c0d0399a:	f7ff f953 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d0399e:	9600      	str	r6, [sp, #0]
c0d039a0:	9601      	str	r6, [sp, #4]
c0d039a2:	4620      	mov	r0, r4
c0d039a4:	4631      	mov	r1, r6
c0d039a6:	463a      	mov	r2, r7
c0d039a8:	462b      	mov	r3, r5
c0d039aa:	f7fc fd61 	bl	c0d00470 <cx_hash_no_throw>
c0d039ae:	2800      	cmp	r0, #0
c0d039b0:	d144      	bne.n	c0d03a3c <signTx_handleEndCountedSectionAPDU+0x1b0>
c0d039b2:	9c03      	ldr	r4, [sp, #12]
  return cx_hash_get_size(hash);
c0d039b4:	4620      	mov	r0, r4
c0d039b6:	f7fc fd55 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d039ba:	4822      	ldr	r0, [pc, #136]	; (c0d03a44 <signTx_handleEndCountedSectionAPDU+0x1b8>)
c0d039bc:	9902      	ldr	r1, [sp, #8]
c0d039be:	5a40      	ldrh	r0, [r0, r1]
c0d039c0:	4921      	ldr	r1, [pc, #132]	; (c0d03a48 <signTx_handleEndCountedSectionAPDU+0x1bc>)
c0d039c2:	1a41      	subs	r1, r0, r1
c0d039c4:	4248      	negs	r0, r1
c0d039c6:	4148      	adcs	r0, r1
c0d039c8:	492b      	ldr	r1, [pc, #172]	; (c0d03a78 <signTx_handleEndCountedSectionAPDU+0x1ec>)
c0d039ca:	4479      	add	r1, pc
c0d039cc:	f7fc fb50 	bl	c0d00070 <assert>
c0d039d0:	2601      	movs	r6, #1
	ASSERT(outSize == SHA_256_SIZE);
c0d039d2:	492a      	ldr	r1, [pc, #168]	; (c0d03a7c <signTx_handleEndCountedSectionAPDU+0x1f0>)
c0d039d4:	4479      	add	r1, pc
c0d039d6:	4630      	mov	r0, r6
c0d039d8:	f7fc fb4a 	bl	c0d00070 <assert>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d039dc:	9700      	str	r7, [sp, #0]
c0d039de:	9501      	str	r5, [sp, #4]
c0d039e0:	2200      	movs	r2, #0
c0d039e2:	4620      	mov	r0, r4
c0d039e4:	4631      	mov	r1, r6
c0d039e6:	4613      	mov	r3, r2
c0d039e8:	f7fc fd42 	bl	c0d00470 <cx_hash_no_throw>
c0d039ec:	2800      	cmp	r0, #0
c0d039ee:	d125      	bne.n	c0d03a3c <signTx_handleEndCountedSectionAPDU+0x1b0>
c0d039f0:	4814      	ldr	r0, [pc, #80]	; (c0d03a44 <signTx_handleEndCountedSectionAPDU+0x1b8>)
  return cx_hash_get_size(hash);
c0d039f2:	3074      	adds	r0, #116	; 0x74
c0d039f4:	f7fc fd36 	bl	c0d00464 <cx_hash_get_size>
	respondSuccessEmptyMsg();
c0d039f8:	f7ff fd52 	bl	c0d034a0 <respondSuccessEmptyMsg>
		sha_256_append(&ctx->integrityHashContext, ctx->prevHash, 32);
		sha_256_finalize(&ctx->integrityHashContext, ctx->prevHash, 32);
	}

	signTx_handleEndCountedSection_ui_runStep();
}
c0d039fc:	b005      	add	sp, #20
c0d039fe:	bdf0      	pop	{r4, r5, r6, r7, pc}
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d03a00:	481f      	ldr	r0, [pc, #124]	; (c0d03a80 <signTx_handleEndCountedSectionAPDU+0x1f4>)
c0d03a02:	4478      	add	r0, pc
c0d03a04:	491f      	ldr	r1, [pc, #124]	; (c0d03a84 <signTx_handleEndCountedSectionAPDU+0x1f8>)
c0d03a06:	4479      	add	r1, pc
c0d03a08:	228e      	movs	r2, #142	; 0x8e
c0d03a0a:	f7ff f91b 	bl	c0d02c44 <mcu_usb_printf>
c0d03a0e:	480c      	ldr	r0, [pc, #48]	; (c0d03a40 <signTx_handleEndCountedSectionAPDU+0x1b4>)
c0d03a10:	f7fe fbc0 	bl	c0d02194 <os_longjmp>
		VALIDATE(ctx->sectionLevel > 0, ERR_UNEXPECTED_INS);
c0d03a14:	481c      	ldr	r0, [pc, #112]	; (c0d03a88 <signTx_handleEndCountedSectionAPDU+0x1fc>)
c0d03a16:	4478      	add	r0, pc
c0d03a18:	491c      	ldr	r1, [pc, #112]	; (c0d03a8c <signTx_handleEndCountedSectionAPDU+0x200>)
c0d03a1a:	4479      	add	r1, pc
c0d03a1c:	2293      	movs	r2, #147	; 0x93
c0d03a1e:	f7ff f911 	bl	c0d02c44 <mcu_usb_printf>
c0d03a22:	2005      	movs	r0, #5
c0d03a24:	0300      	lsls	r0, r0, #12
c0d03a26:	f7fe fbb5 	bl	c0d02194 <os_longjmp>
		VALIDATE(
c0d03a2a:	4819      	ldr	r0, [pc, #100]	; (c0d03a90 <signTx_handleEndCountedSectionAPDU+0x204>)
c0d03a2c:	4478      	add	r0, pc
c0d03a2e:	4919      	ldr	r1, [pc, #100]	; (c0d03a94 <signTx_handleEndCountedSectionAPDU+0x208>)
c0d03a30:	4479      	add	r1, pc
c0d03a32:	2296      	movs	r2, #150	; 0x96
c0d03a34:	f7ff f906 	bl	c0d02c44 <mcu_usb_printf>
c0d03a38:	4801      	ldr	r0, [pc, #4]	; (c0d03a40 <signTx_handleEndCountedSectionAPDU+0x1b4>)
c0d03a3a:	1c80      	adds	r0, r0, #2
c0d03a3c:	f7fe fbaa 	bl	c0d02194 <os_longjmp>
c0d03a40:	00006e05 	.word	0x00006e05
c0d03a44:	20000490 	.word	0x20000490
c0d03a48:	00003039 	.word	0x00003039
c0d03a4c:	00005b65 	.word	0x00005b65
c0d03a50:	00005ce5 	.word	0x00005ce5
c0d03a54:	0000509f 	.word	0x0000509f
c0d03a58:	00005ce7 	.word	0x00005ce7
c0d03a5c:	000050b2 	.word	0x000050b2
c0d03a60:	00005bea 	.word	0x00005bea
c0d03a64:	00005c8b 	.word	0x00005c8b
c0d03a68:	00005045 	.word	0x00005045
c0d03a6c:	00005c8d 	.word	0x00005c8d
c0d03a70:	00005056 	.word	0x00005056
c0d03a74:	00005b8e 	.word	0x00005b8e
c0d03a78:	00005c50 	.word	0x00005c50
c0d03a7c:	00005c54 	.word	0x00005c54
c0d03a80:	00004bfc 	.word	0x00004bfc
c0d03a84:	000059b5 	.word	0x000059b5
c0d03a88:	00004be8 	.word	0x00004be8
c0d03a8c:	000059a1 	.word	0x000059a1
c0d03a90:	00004bd2 	.word	0x00004bd2
c0d03a94:	0000598b 	.word	0x0000598b

c0d03a98 <signTx_handleSendDataAPDU>:
// 1				0 (trailing 0)
__noinline_due_to_stack__ void signTx_handleSendDataAPDU(
	uint8_t p2,
	uint8_t *wireDataBuffer,
	size_t wireDataSize)
{
c0d03a98:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d03a9a:	b08f      	sub	sp, #60	; 0x3c
c0d03a9c:	460d      	mov	r5, r1
c0d03a9e:	9009      	str	r0, [sp, #36]	; 0x24
		uint8_t headerLength[1];
		uint8_t header[NAME_STRING_MAX_LENGTH];
	} *wireData1 = (void *)wireDataBuffer;
	const uint8_t expectedWireData1Length = SIZEOF(*wireData1) -
											NAME_STRING_MAX_LENGTH +
											wireData1->headerLength[0] + 1;
c0d03aa0:	7849      	ldrb	r1, [r1, #1]
c0d03aa2:	1cc8      	adds	r0, r1, #3
	struct
	{
		uint8_t storageInstruction[1];
		uint8_t bodyLength[1];
		uint8_t body[MAX_BODY_LENGTH];
	} *wireData2 = ((void *)wireDataBuffer) + expectedWireData1Length;
c0d03aa4:	b2c0      	uxtb	r0, r0
c0d03aa6:	182b      	adds	r3, r5, r0
c0d03aa8:	930c      	str	r3, [sp, #48]	; 0x30
	const uint8_t expectedWireData2Length = SIZEOF(*wireData2) -
											MAX_BODY_LENGTH +
											wireData2->bodyLength[0] + 1;
c0d03aaa:	785b      	ldrb	r3, [r3, #1]
c0d03aac:	1cdb      	adds	r3, r3, #3

	VALIDATE(
c0d03aae:	b2db      	uxtb	r3, r3
c0d03ab0:	1818      	adds	r0, r3, r0
c0d03ab2:	26ff      	movs	r6, #255	; 0xff
c0d03ab4:	4633      	mov	r3, r6
c0d03ab6:	3308      	adds	r3, #8
c0d03ab8:	9308      	str	r3, [sp, #32]
c0d03aba:	4290      	cmp	r0, r2
c0d03abc:	d000      	beq.n	c0d03ac0 <signTx_handleSendDataAPDU+0x28>
c0d03abe:	e1fb      	b.n	c0d03eb8 <signTx_handleSendDataAPDU+0x420>
		expectedWireData1Length + expectedWireData2Length == wireDataSize,
		ERR_INVALID_DATA);
	str_validateNullTerminatedTextBuffer(
		wireData1->header,
c0d03ac0:	1cac      	adds	r4, r5, #2
	str_validateNullTerminatedTextBuffer(
c0d03ac2:	4620      	mov	r0, r4
c0d03ac4:	f001 fe64 	bl	c0d05790 <str_validateNullTerminatedTextBuffer>
c0d03ac8:	3622      	adds	r6, #34	; 0x22
		wireData1->headerLength[0]);

	{
		// Count this data towards the current counted section if there is one
		if (ctx->sectionLevel > 0)
c0d03aca:	4ffe      	ldr	r7, [pc, #1016]	; (c0d03ec4 <signTx_handleSendDataAPDU+0x42c>)
c0d03acc:	9606      	str	r6, [sp, #24]
c0d03ace:	5db8      	ldrb	r0, [r7, r6]
c0d03ad0:	2800      	cmp	r0, #0
c0d03ad2:	9e0c      	ldr	r6, [sp, #48]	; 0x30
c0d03ad4:	950a      	str	r5, [sp, #40]	; 0x28
c0d03ad6:	d011      	beq.n	c0d03afc <signTx_handleSendDataAPDU+0x64>
		{
			ctx->currSectionLength[ctx->sectionLevel] += wireData2->bodyLength[0];
c0d03ad8:	00c0      	lsls	r0, r0, #3
c0d03ada:	1838      	adds	r0, r7, r0
c0d03adc:	2117      	movs	r1, #23
c0d03ade:	0109      	lsls	r1, r1, #4
c0d03ae0:	1842      	adds	r2, r0, r1
c0d03ae2:	5843      	ldr	r3, [r0, r1]
c0d03ae4:	9307      	str	r3, [sp, #28]
c0d03ae6:	7875      	ldrb	r5, [r6, #1]
c0d03ae8:	2300      	movs	r3, #0
c0d03aea:	930b      	str	r3, [sp, #44]	; 0x2c
c0d03aec:	9b07      	ldr	r3, [sp, #28]
c0d03aee:	195b      	adds	r3, r3, r5
c0d03af0:	9d0a      	ldr	r5, [sp, #40]	; 0x28
c0d03af2:	5043      	str	r3, [r0, r1]
c0d03af4:	6850      	ldr	r0, [r2, #4]
c0d03af6:	990b      	ldr	r1, [sp, #44]	; 0x2c
c0d03af8:	4148      	adcs	r0, r1
c0d03afa:	6050      	str	r0, [r2, #4]
c0d03afc:	2041      	movs	r0, #65	; 0x41
c0d03afe:	0080      	lsls	r0, r0, #2
c0d03b00:	9007      	str	r0, [sp, #28]
		}
	}

	ctx->headerBuf = (char *)wireData1->header;
c0d03b02:	503c      	str	r4, [r7, r0]
	return inBuffer[0];
c0d03b04:	7828      	ldrb	r0, [r5, #0]
c0d03b06:	2121      	movs	r1, #33	; 0x21
c0d03b08:	00c9      	lsls	r1, r1, #3
	ctx->encoding = u1be_read(wireData1->encoding);
	ctx->bodyBuf = (char *)wireData2->body;
c0d03b0a:	1cb4      	adds	r4, r6, #2
c0d03b0c:	9105      	str	r1, [sp, #20]
c0d03b0e:	507c      	str	r4, [r7, r1]
c0d03b10:	2109      	movs	r1, #9
c0d03b12:	0149      	lsls	r1, r1, #5
c0d03b14:	910b      	str	r1, [sp, #44]	; 0x2c
	ctx->encoding = u1be_read(wireData1->encoding);
c0d03b16:	5478      	strb	r0, [r7, r1]

	if (ctx->encoding == ENCODING_STRING)
c0d03b18:	2896      	cmp	r0, #150	; 0x96
c0d03b1a:	4633      	mov	r3, r6
c0d03b1c:	d107      	bne.n	c0d03b2e <signTx_handleSendDataAPDU+0x96>
	{
		str_validateNullTerminatedTextBuffer(wireData2->body, wireData2->bodyLength[0]);
c0d03b1e:	7859      	ldrb	r1, [r3, #1]
c0d03b20:	4620      	mov	r0, r4
c0d03b22:	f001 fe35 	bl	c0d05790 <str_validateNullTerminatedTextBuffer>
c0d03b26:	9b0c      	ldr	r3, [sp, #48]	; 0x30
	}

	VALIDATE(
c0d03b28:	48ef      	ldr	r0, [pc, #956]	; (c0d03ee8 <signTx_handleSendDataAPDU+0x450>)
c0d03b2a:	990b      	ldr	r1, [sp, #44]	; 0x2c
c0d03b2c:	5c40      	ldrb	r0, [r0, r1]
c0d03b2e:	4601      	mov	r1, r0
c0d03b30:	316a      	adds	r1, #106	; 0x6a
c0d03b32:	b2c9      	uxtb	r1, r1
c0d03b34:	2906      	cmp	r1, #6
c0d03b36:	d300      	bcc.n	c0d03b3a <signTx_handleSendDataAPDU+0xa2>
c0d03b38:	e1c6      	b.n	c0d03ec8 <signTx_handleSendDataAPDU+0x430>
		ctx->encoding >= ENCODING_STRING && ctx->encoding <= ENCODING_HEX,
		ERR_INVALID_DATA);
	VALIDATE(
c0d03b3a:	7819      	ldrb	r1, [r3, #0]
c0d03b3c:	2903      	cmp	r1, #3
c0d03b3e:	d300      	bcc.n	c0d03b42 <signTx_handleSendDataAPDU+0xaa>
c0d03b40:	e1c5      	b.n	c0d03ece <signTx_handleSendDataAPDU+0x436>
		break;
	}

	// Set correct body and add to tx
	// Always add numbers to ctx->uint64Body for displaying it
	switch (ctx->encoding)
c0d03b42:	2898      	cmp	r0, #152	; 0x98
c0d03b44:	dc0d      	bgt.n	c0d03b62 <signTx_handleSendDataAPDU+0xca>
c0d03b46:	2896      	cmp	r0, #150	; 0x96
c0d03b48:	d100      	bne.n	c0d03b4c <signTx_handleSendDataAPDU+0xb4>
c0d03b4a:	e095      	b.n	c0d03c78 <signTx_handleSendDataAPDU+0x1e0>
c0d03b4c:	2897      	cmp	r0, #151	; 0x97
c0d03b4e:	d15b      	bne.n	c0d03c08 <signTx_handleSendDataAPDU+0x170>
c0d03b50:	7898      	ldrb	r0, [r3, #2]
c0d03b52:	2123      	movs	r1, #35	; 0x23
c0d03b54:	00c9      	lsls	r1, r1, #3
c0d03b56:	4fe4      	ldr	r7, [pc, #912]	; (c0d03ee8 <signTx_handleSendDataAPDU+0x450>)
	{
	case ENCODING_UINT8:
		ctx->uint8Body = u1be_read(wireData2->body);
		ctx->uint64Body = (uint64_t)ctx->uint8Body;
c0d03b58:	5078      	str	r0, [r7, r1]
c0d03b5a:	2243      	movs	r2, #67	; 0x43
c0d03b5c:	0096      	lsls	r6, r2, #2
		ctx->uint8Body = u1be_read(wireData2->body);
c0d03b5e:	55b8      	strb	r0, [r7, r6]
c0d03b60:	e061      	b.n	c0d03c26 <signTx_handleSendDataAPDU+0x18e>
	switch (ctx->encoding)
c0d03b62:	2899      	cmp	r0, #153	; 0x99
c0d03b64:	d03e      	beq.n	c0d03be4 <signTx_handleSendDataAPDU+0x14c>
c0d03b66:	289a      	cmp	r0, #154	; 0x9a
c0d03b68:	d000      	beq.n	c0d03b6c <signTx_handleSendDataAPDU+0xd4>
c0d03b6a:	e082      	b.n	c0d03c72 <signTx_handleSendDataAPDU+0x1da>
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d03b6c:	7998      	ldrb	r0, [r3, #6]
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03b6e:	0600      	lsls	r0, r0, #24
	return inBuffer[0];
c0d03b70:	79d9      	ldrb	r1, [r3, #7]
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03b72:	0409      	lsls	r1, r1, #16
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d03b74:	1808      	adds	r0, r1, r0
	return inBuffer[0];
c0d03b76:	7a59      	ldrb	r1, [r3, #9]
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03b78:	1840      	adds	r0, r0, r1
	return inBuffer[0];
c0d03b7a:	7a19      	ldrb	r1, [r3, #8]
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d03b7c:	0209      	lsls	r1, r1, #8
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03b7e:	1840      	adds	r0, r0, r1
	return inBuffer[0];
c0d03b80:	7919      	ldrb	r1, [r3, #4]
c0d03b82:	795a      	ldrb	r2, [r3, #5]
c0d03b84:	461e      	mov	r6, r3
c0d03b86:	78db      	ldrb	r3, [r3, #3]
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d03b88:	78b5      	ldrb	r5, [r6, #2]
c0d03b8a:	2423      	movs	r4, #35	; 0x23
c0d03b8c:	00e4      	lsls	r4, r4, #3
c0d03b8e:	4fd6      	ldr	r7, [pc, #856]	; (c0d03ee8 <signTx_handleSendDataAPDU+0x450>)
		ctx->uint32Body = u4be_read(wireData2->body);
		ctx->uint64Body = (uint64_t)ctx->uint32Body;
		sha_256_append(&ctx->txHashContext, (uint8_t *)&ctx->uint32Body, wireData2->bodyLength[0]);
		break;
	case ENCODING_UINT64:
		ctx->uint64Body = u8be_read(wireData2->body);
c0d03b90:	5138      	str	r0, [r7, r4]
c0d03b92:	193c      	adds	r4, r7, r4
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03b94:	0628      	lsls	r0, r5, #24
c0d03b96:	041b      	lsls	r3, r3, #16
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d03b98:	1818      	adds	r0, r3, r0
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03b9a:	1880      	adds	r0, r0, r2
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d03b9c:	0209      	lsls	r1, r1, #8
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03b9e:	1840      	adds	r0, r0, r1
c0d03ba0:	6060      	str	r0, [r4, #4]
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03ba2:	8838      	ldrh	r0, [r7, #0]
c0d03ba4:	49d1      	ldr	r1, [pc, #836]	; (c0d03eec <signTx_handleSendDataAPDU+0x454>)
c0d03ba6:	1a41      	subs	r1, r0, r1
c0d03ba8:	4248      	negs	r0, r1
c0d03baa:	4148      	adcs	r0, r1
		sha_256_append(&ctx->txHashContext, (uint8_t *)&ctx->uint64Body, wireData2->bodyLength[0]);
c0d03bac:	7875      	ldrb	r5, [r6, #1]
c0d03bae:	49e1      	ldr	r1, [pc, #900]	; (c0d03f34 <signTx_handleSendDataAPDU+0x49c>)
c0d03bb0:	4479      	add	r1, pc
c0d03bb2:	f7fc fa5d 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d03bb6:	48e0      	ldr	r0, [pc, #896]	; (c0d03f38 <signTx_handleSendDataAPDU+0x4a0>)
c0d03bb8:	4478      	add	r0, pc
c0d03bba:	49e0      	ldr	r1, [pc, #896]	; (c0d03f3c <signTx_handleSendDataAPDU+0x4a4>)
c0d03bbc:	4479      	add	r1, pc
c0d03bbe:	2224      	movs	r2, #36	; 0x24
c0d03bc0:	f7ff f840 	bl	c0d02c44 <mcu_usb_printf>
c0d03bc4:	48de      	ldr	r0, [pc, #888]	; (c0d03f40 <signTx_handleSendDataAPDU+0x4a8>)
c0d03bc6:	4478      	add	r0, pc
c0d03bc8:	4629      	mov	r1, r5
c0d03bca:	4622      	mov	r2, r4
c0d03bcc:	f7ff f83a 	bl	c0d02c44 <mcu_usb_printf>
c0d03bd0:	48dc      	ldr	r0, [pc, #880]	; (c0d03f44 <signTx_handleSendDataAPDU+0x4ac>)
c0d03bd2:	4478      	add	r0, pc
c0d03bd4:	f7ff f836 	bl	c0d02c44 <mcu_usb_printf>
c0d03bd8:	2100      	movs	r1, #0
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d03bda:	9100      	str	r1, [sp, #0]
c0d03bdc:	9101      	str	r1, [sp, #4]
c0d03bde:	1d38      	adds	r0, r7, #4
c0d03be0:	4622      	mov	r2, r4
c0d03be2:	e044      	b.n	c0d03c6e <signTx_handleSendDataAPDU+0x1d6>
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d03be4:	7898      	ldrb	r0, [r3, #2]
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03be6:	0600      	lsls	r0, r0, #24
	return inBuffer[0];
c0d03be8:	78d9      	ldrb	r1, [r3, #3]
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03bea:	0409      	lsls	r1, r1, #16
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d03bec:	1808      	adds	r0, r1, r0
	return inBuffer[0];
c0d03bee:	7959      	ldrb	r1, [r3, #5]
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03bf0:	1840      	adds	r0, r0, r1
	return inBuffer[0];
c0d03bf2:	7919      	ldrb	r1, [r3, #4]
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d03bf4:	0209      	lsls	r1, r1, #8
	return ((uint32_t) u2be_read(inBuffer) << 16) | (uint32_t)(u2be_read(inBuffer + 2));
c0d03bf6:	1840      	adds	r0, r0, r1
c0d03bf8:	2123      	movs	r1, #35	; 0x23
c0d03bfa:	00c9      	lsls	r1, r1, #3
c0d03bfc:	4fba      	ldr	r7, [pc, #744]	; (c0d03ee8 <signTx_handleSendDataAPDU+0x450>)
		ctx->uint64Body = (uint64_t)ctx->uint32Body;
c0d03bfe:	5078      	str	r0, [r7, r1]
c0d03c00:	2211      	movs	r2, #17
c0d03c02:	0116      	lsls	r6, r2, #4
		ctx->uint32Body = u4be_read(wireData2->body);
c0d03c04:	51b8      	str	r0, [r7, r6]
c0d03c06:	e00e      	b.n	c0d03c26 <signTx_handleSendDataAPDU+0x18e>
	switch (ctx->encoding)
c0d03c08:	2898      	cmp	r0, #152	; 0x98
c0d03c0a:	d000      	beq.n	c0d03c0e <signTx_handleSendDataAPDU+0x176>
c0d03c0c:	e151      	b.n	c0d03eb2 <signTx_handleSendDataAPDU+0x41a>
	return inBuffer[0];
c0d03c0e:	78d8      	ldrb	r0, [r3, #3]
	               ((uint32_t) (u1be_read(inBuffer) << 8)) | ((uint32_t) (u1be_read(inBuffer + 1)))
c0d03c10:	7899      	ldrb	r1, [r3, #2]
c0d03c12:	0209      	lsls	r1, r1, #8
c0d03c14:	1808      	adds	r0, r1, r0
c0d03c16:	2187      	movs	r1, #135	; 0x87
c0d03c18:	004e      	lsls	r6, r1, #1
c0d03c1a:	4fb3      	ldr	r7, [pc, #716]	; (c0d03ee8 <signTx_handleSendDataAPDU+0x450>)
		ctx->uint16Body = u2be_read(wireData2->body);
c0d03c1c:	53b8      	strh	r0, [r7, r6]
		ctx->uint64Body = (uint64_t)ctx->uint16Body;
c0d03c1e:	b280      	uxth	r0, r0
c0d03c20:	2123      	movs	r1, #35	; 0x23
c0d03c22:	00c9      	lsls	r1, r1, #3
c0d03c24:	5078      	str	r0, [r7, r1]
c0d03c26:	1878      	adds	r0, r7, r1
c0d03c28:	2400      	movs	r4, #0
c0d03c2a:	6044      	str	r4, [r0, #4]
c0d03c2c:	8838      	ldrh	r0, [r7, #0]
c0d03c2e:	49af      	ldr	r1, [pc, #700]	; (c0d03eec <signTx_handleSendDataAPDU+0x454>)
c0d03c30:	1a41      	subs	r1, r0, r1
c0d03c32:	4248      	negs	r0, r1
c0d03c34:	4148      	adcs	r0, r1
c0d03c36:	785d      	ldrb	r5, [r3, #1]
c0d03c38:	49b9      	ldr	r1, [pc, #740]	; (c0d03f20 <signTx_handleSendDataAPDU+0x488>)
c0d03c3a:	4479      	add	r1, pc
c0d03c3c:	f7fc fa18 	bl	c0d00070 <assert>
c0d03c40:	48b8      	ldr	r0, [pc, #736]	; (c0d03f24 <signTx_handleSendDataAPDU+0x48c>)
c0d03c42:	4478      	add	r0, pc
c0d03c44:	49b8      	ldr	r1, [pc, #736]	; (c0d03f28 <signTx_handleSendDataAPDU+0x490>)
c0d03c46:	4479      	add	r1, pc
c0d03c48:	2224      	movs	r2, #36	; 0x24
c0d03c4a:	f7fe fffb 	bl	c0d02c44 <mcu_usb_printf>
c0d03c4e:	19be      	adds	r6, r7, r6
c0d03c50:	48b6      	ldr	r0, [pc, #728]	; (c0d03f2c <signTx_handleSendDataAPDU+0x494>)
c0d03c52:	4478      	add	r0, pc
c0d03c54:	4629      	mov	r1, r5
c0d03c56:	4632      	mov	r2, r6
c0d03c58:	f7fe fff4 	bl	c0d02c44 <mcu_usb_printf>
c0d03c5c:	48b4      	ldr	r0, [pc, #720]	; (c0d03f30 <signTx_handleSendDataAPDU+0x498>)
c0d03c5e:	4478      	add	r0, pc
c0d03c60:	f7fe fff0 	bl	c0d02c44 <mcu_usb_printf>
c0d03c64:	9400      	str	r4, [sp, #0]
c0d03c66:	9401      	str	r4, [sp, #4]
c0d03c68:	1d38      	adds	r0, r7, #4
c0d03c6a:	4621      	mov	r1, r4
c0d03c6c:	4632      	mov	r2, r6
c0d03c6e:	462b      	mov	r3, r5
c0d03c70:	e03e      	b.n	c0d03cf0 <signTx_handleSendDataAPDU+0x258>
	switch (ctx->encoding)
c0d03c72:	289b      	cmp	r0, #155	; 0x9b
c0d03c74:	d000      	beq.n	c0d03c78 <signTx_handleSendDataAPDU+0x1e0>
c0d03c76:	e11c      	b.n	c0d03eb2 <signTx_handleSendDataAPDU+0x41a>
		break;
	case ENCODING_HEX:
	case ENCODING_STRING:
		PRINTF("SIZEOF BODY: %d", wireData2->bodyLength[0]);
c0d03c78:	7859      	ldrb	r1, [r3, #1]
c0d03c7a:	48a2      	ldr	r0, [pc, #648]	; (c0d03f04 <signTx_handleSendDataAPDU+0x46c>)
c0d03c7c:	4478      	add	r0, pc
c0d03c7e:	461e      	mov	r6, r3
c0d03c80:	f7fe ffe0 	bl	c0d02c44 <mcu_usb_printf>
		TRACE_BUFFER(wireData2->body, SIZEOF(wireData2->body));
c0d03c84:	9a08      	ldr	r2, [sp, #32]
c0d03c86:	324a      	adds	r2, #74	; 0x4a
c0d03c88:	489f      	ldr	r0, [pc, #636]	; (c0d03f08 <signTx_handleSendDataAPDU+0x470>)
c0d03c8a:	4478      	add	r0, pc
c0d03c8c:	9004      	str	r0, [sp, #16]
c0d03c8e:	499f      	ldr	r1, [pc, #636]	; (c0d03f0c <signTx_handleSendDataAPDU+0x474>)
c0d03c90:	4479      	add	r1, pc
c0d03c92:	f7fe ffd7 	bl	c0d02c44 <mcu_usb_printf>
c0d03c96:	489e      	ldr	r0, [pc, #632]	; (c0d03f10 <signTx_handleSendDataAPDU+0x478>)
c0d03c98:	4478      	add	r0, pc
c0d03c9a:	9003      	str	r0, [sp, #12]
c0d03c9c:	21c8      	movs	r1, #200	; 0xc8
c0d03c9e:	4622      	mov	r2, r4
c0d03ca0:	f7fe ffd0 	bl	c0d02c44 <mcu_usb_printf>
c0d03ca4:	4d9b      	ldr	r5, [pc, #620]	; (c0d03f14 <signTx_handleSendDataAPDU+0x47c>)
c0d03ca6:	447d      	add	r5, pc
c0d03ca8:	4628      	mov	r0, r5
c0d03caa:	f7fe ffcb 	bl	c0d02c44 <mcu_usb_printf>
c0d03cae:	4f8e      	ldr	r7, [pc, #568]	; (c0d03ee8 <signTx_handleSendDataAPDU+0x450>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03cb0:	8838      	ldrh	r0, [r7, #0]
c0d03cb2:	498e      	ldr	r1, [pc, #568]	; (c0d03eec <signTx_handleSendDataAPDU+0x454>)
c0d03cb4:	1a41      	subs	r1, r0, r1
c0d03cb6:	4248      	negs	r0, r1
c0d03cb8:	4148      	adcs	r0, r1
		sha_256_append(&ctx->txHashContext, ctx->bodyBuf, wireData2->bodyLength[0]);
c0d03cba:	9905      	ldr	r1, [sp, #20]
c0d03cbc:	587c      	ldr	r4, [r7, r1]
c0d03cbe:	7876      	ldrb	r6, [r6, #1]
c0d03cc0:	4995      	ldr	r1, [pc, #596]	; (c0d03f18 <signTx_handleSendDataAPDU+0x480>)
c0d03cc2:	4479      	add	r1, pc
c0d03cc4:	f7fc f9d4 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d03cc8:	4994      	ldr	r1, [pc, #592]	; (c0d03f1c <signTx_handleSendDataAPDU+0x484>)
c0d03cca:	4479      	add	r1, pc
c0d03ccc:	2224      	movs	r2, #36	; 0x24
c0d03cce:	9804      	ldr	r0, [sp, #16]
c0d03cd0:	f7fe ffb8 	bl	c0d02c44 <mcu_usb_printf>
c0d03cd4:	9803      	ldr	r0, [sp, #12]
c0d03cd6:	4631      	mov	r1, r6
c0d03cd8:	4622      	mov	r2, r4
c0d03cda:	f7fe ffb3 	bl	c0d02c44 <mcu_usb_printf>
c0d03cde:	4628      	mov	r0, r5
c0d03ce0:	f7fe ffb0 	bl	c0d02c44 <mcu_usb_printf>
c0d03ce4:	2100      	movs	r1, #0
c0d03ce6:	9100      	str	r1, [sp, #0]
c0d03ce8:	9101      	str	r1, [sp, #4]
c0d03cea:	1d38      	adds	r0, r7, #4
c0d03cec:	4622      	mov	r2, r4
c0d03cee:	4633      	mov	r3, r6
c0d03cf0:	f7fc fbbe 	bl	c0d00470 <cx_hash_no_throw>
c0d03cf4:	2800      	cmp	r0, #0
c0d03cf6:	d000      	beq.n	c0d03cfa <signTx_handleSendDataAPDU+0x262>
c0d03cf8:	e0d3      	b.n	c0d03ea2 <signTx_handleSendDataAPDU+0x40a>
c0d03cfa:	1d38      	adds	r0, r7, #4
c0d03cfc:	f7fc fbb2 	bl	c0d00464 <cx_hash_get_size>
c0d03d00:	ac0d      	add	r4, sp, #52	; 0x34
		break;
	}

	{
		// Add to integrity hash
		uint8_t constants[] = {0x30, 0x07, p2, ctx->encoding,
c0d03d02:	9809      	ldr	r0, [sp, #36]	; 0x24
c0d03d04:	70a0      	strb	r0, [r4, #2]
c0d03d06:	2607      	movs	r6, #7
c0d03d08:	7066      	strb	r6, [r4, #1]
c0d03d0a:	2030      	movs	r0, #48	; 0x30
c0d03d0c:	7020      	strb	r0, [r4, #0]
c0d03d0e:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d03d10:	5c38      	ldrb	r0, [r7, r0]
c0d03d12:	70e0      	strb	r0, [r4, #3]
							   ctx->sectionLevel, wireData1->headerLength[0], wireData2->storageInstruction[0]};
c0d03d14:	9806      	ldr	r0, [sp, #24]
c0d03d16:	5c38      	ldrb	r0, [r7, r0]
		uint8_t constants[] = {0x30, 0x07, p2, ctx->encoding,
c0d03d18:	7120      	strb	r0, [r4, #4]
							   ctx->sectionLevel, wireData1->headerLength[0], wireData2->storageInstruction[0]};
c0d03d1a:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d03d1c:	7840      	ldrb	r0, [r0, #1]
		uint8_t constants[] = {0x30, 0x07, p2, ctx->encoding,
c0d03d1e:	7160      	strb	r0, [r4, #5]
							   ctx->sectionLevel, wireData1->headerLength[0], wireData2->storageInstruction[0]};
c0d03d20:	980c      	ldr	r0, [sp, #48]	; 0x30
c0d03d22:	7800      	ldrb	r0, [r0, #0]
		uint8_t constants[] = {0x30, 0x07, p2, ctx->encoding,
c0d03d24:	71a0      	strb	r0, [r4, #6]
c0d03d26:	4638      	mov	r0, r7
c0d03d28:	3070      	adds	r0, #112	; 0x70
c0d03d2a:	463d      	mov	r5, r7
c0d03d2c:	1d07      	adds	r7, r0, #4
c0d03d2e:	4638      	mov	r0, r7
c0d03d30:	f7fc fbb6 	bl	c0d004a0 <cx_sha256_init_no_throw>
c0d03d34:	2170      	movs	r1, #112	; 0x70
	ctx->initialized_magic = HASH_CONTEXT_INITIALIZED_MAGIC;
c0d03d36:	486d      	ldr	r0, [pc, #436]	; (c0d03eec <signTx_handleSendDataAPDU+0x454>)
c0d03d38:	910b      	str	r1, [sp, #44]	; 0x2c
c0d03d3a:	5268      	strh	r0, [r5, r1]
c0d03d3c:	2001      	movs	r0, #1
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03d3e:	4982      	ldr	r1, [pc, #520]	; (c0d03f48 <signTx_handleSendDataAPDU+0x4b0>)
c0d03d40:	4479      	add	r1, pc
c0d03d42:	f7fc f995 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d03d46:	4881      	ldr	r0, [pc, #516]	; (c0d03f4c <signTx_handleSendDataAPDU+0x4b4>)
c0d03d48:	4478      	add	r0, pc
c0d03d4a:	4981      	ldr	r1, [pc, #516]	; (c0d03f50 <signTx_handleSendDataAPDU+0x4b8>)
c0d03d4c:	4479      	add	r1, pc
c0d03d4e:	2224      	movs	r2, #36	; 0x24
c0d03d50:	f7fe ff78 	bl	c0d02c44 <mcu_usb_printf>
c0d03d54:	487f      	ldr	r0, [pc, #508]	; (c0d03f54 <signTx_handleSendDataAPDU+0x4bc>)
c0d03d56:	4478      	add	r0, pc
c0d03d58:	4631      	mov	r1, r6
c0d03d5a:	4622      	mov	r2, r4
c0d03d5c:	f7fe ff72 	bl	c0d02c44 <mcu_usb_printf>
c0d03d60:	487d      	ldr	r0, [pc, #500]	; (c0d03f58 <signTx_handleSendDataAPDU+0x4c0>)
c0d03d62:	4478      	add	r0, pc
c0d03d64:	f7fe ff6e 	bl	c0d02c44 <mcu_usb_printf>
c0d03d68:	2500      	movs	r5, #0
c0d03d6a:	9500      	str	r5, [sp, #0]
c0d03d6c:	9501      	str	r5, [sp, #4]
c0d03d6e:	970c      	str	r7, [sp, #48]	; 0x30
c0d03d70:	4638      	mov	r0, r7
c0d03d72:	4629      	mov	r1, r5
c0d03d74:	4622      	mov	r2, r4
c0d03d76:	4633      	mov	r3, r6
c0d03d78:	f7fc fb7a 	bl	c0d00470 <cx_hash_no_throw>
c0d03d7c:	2800      	cmp	r0, #0
c0d03d7e:	4f5a      	ldr	r7, [pc, #360]	; (c0d03ee8 <signTx_handleSendDataAPDU+0x450>)
c0d03d80:	d000      	beq.n	c0d03d84 <signTx_handleSendDataAPDU+0x2ec>
c0d03d82:	e08e      	b.n	c0d03ea2 <signTx_handleSendDataAPDU+0x40a>
  return cx_hash_get_size(hash);
c0d03d84:	980c      	ldr	r0, [sp, #48]	; 0x30
c0d03d86:	f7fc fb6d 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03d8a:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d03d8c:	5a38      	ldrh	r0, [r7, r0]
c0d03d8e:	4e57      	ldr	r6, [pc, #348]	; (c0d03eec <signTx_handleSendDataAPDU+0x454>)
c0d03d90:	1b81      	subs	r1, r0, r6
c0d03d92:	4248      	negs	r0, r1
c0d03d94:	4148      	adcs	r0, r1
c0d03d96:	4971      	ldr	r1, [pc, #452]	; (c0d03f5c <signTx_handleSendDataAPDU+0x4c4>)
c0d03d98:	4479      	add	r1, pc
c0d03d9a:	f7fc f969 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d03d9e:	4870      	ldr	r0, [pc, #448]	; (c0d03f60 <signTx_handleSendDataAPDU+0x4c8>)
c0d03da0:	4478      	add	r0, pc
c0d03da2:	4970      	ldr	r1, [pc, #448]	; (c0d03f64 <signTx_handleSendDataAPDU+0x4cc>)
c0d03da4:	4479      	add	r1, pc
c0d03da6:	2224      	movs	r2, #36	; 0x24
c0d03da8:	f7fe ff4c 	bl	c0d02c44 <mcu_usb_printf>
c0d03dac:	37e0      	adds	r7, #224	; 0xe0
c0d03dae:	486e      	ldr	r0, [pc, #440]	; (c0d03f68 <signTx_handleSendDataAPDU+0x4d0>)
c0d03db0:	4478      	add	r0, pc
c0d03db2:	2420      	movs	r4, #32
c0d03db4:	4621      	mov	r1, r4
c0d03db6:	463a      	mov	r2, r7
c0d03db8:	f7fe ff44 	bl	c0d02c44 <mcu_usb_printf>
c0d03dbc:	486b      	ldr	r0, [pc, #428]	; (c0d03f6c <signTx_handleSendDataAPDU+0x4d4>)
c0d03dbe:	4478      	add	r0, pc
c0d03dc0:	f7fe ff40 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d03dc4:	9500      	str	r5, [sp, #0]
c0d03dc6:	9501      	str	r5, [sp, #4]
c0d03dc8:	980c      	ldr	r0, [sp, #48]	; 0x30
c0d03dca:	4629      	mov	r1, r5
c0d03dcc:	9705      	str	r7, [sp, #20]
c0d03dce:	463a      	mov	r2, r7
c0d03dd0:	9406      	str	r4, [sp, #24]
c0d03dd2:	4623      	mov	r3, r4
c0d03dd4:	f7fc fb4c 	bl	c0d00470 <cx_hash_no_throw>
c0d03dd8:	2800      	cmp	r0, #0
c0d03dda:	d162      	bne.n	c0d03ea2 <signTx_handleSendDataAPDU+0x40a>
  return cx_hash_get_size(hash);
c0d03ddc:	980c      	ldr	r0, [sp, #48]	; 0x30
c0d03dde:	f7fc fb41 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03de2:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d03de4:	4c40      	ldr	r4, [pc, #256]	; (c0d03ee8 <signTx_handleSendDataAPDU+0x450>)
c0d03de6:	5a20      	ldrh	r0, [r4, r0]
c0d03de8:	1b81      	subs	r1, r0, r6
c0d03dea:	4248      	negs	r0, r1
c0d03dec:	4148      	adcs	r0, r1
		sha_256_init(&ctx->integrityHashContext);
		sha_256_append(&ctx->integrityHashContext, constants, SIZEOF(constants));
		sha_256_append(&ctx->integrityHashContext, ctx->prevHash, 32);
		sha_256_append(&ctx->integrityHashContext, ctx->headerBuf, wireData1->headerLength[0]);
c0d03dee:	9907      	ldr	r1, [sp, #28]
c0d03df0:	5866      	ldr	r6, [r4, r1]
c0d03df2:	990a      	ldr	r1, [sp, #40]	; 0x28
c0d03df4:	784f      	ldrb	r7, [r1, #1]
c0d03df6:	495e      	ldr	r1, [pc, #376]	; (c0d03f70 <signTx_handleSendDataAPDU+0x4d8>)
c0d03df8:	4479      	add	r1, pc
c0d03dfa:	f7fc f939 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d03dfe:	485d      	ldr	r0, [pc, #372]	; (c0d03f74 <signTx_handleSendDataAPDU+0x4dc>)
c0d03e00:	4478      	add	r0, pc
c0d03e02:	495d      	ldr	r1, [pc, #372]	; (c0d03f78 <signTx_handleSendDataAPDU+0x4e0>)
c0d03e04:	4479      	add	r1, pc
c0d03e06:	2224      	movs	r2, #36	; 0x24
c0d03e08:	f7fe ff1c 	bl	c0d02c44 <mcu_usb_printf>
c0d03e0c:	485b      	ldr	r0, [pc, #364]	; (c0d03f7c <signTx_handleSendDataAPDU+0x4e4>)
c0d03e0e:	4478      	add	r0, pc
c0d03e10:	4639      	mov	r1, r7
c0d03e12:	4632      	mov	r2, r6
c0d03e14:	f7fe ff16 	bl	c0d02c44 <mcu_usb_printf>
c0d03e18:	4859      	ldr	r0, [pc, #356]	; (c0d03f80 <signTx_handleSendDataAPDU+0x4e8>)
c0d03e1a:	4478      	add	r0, pc
c0d03e1c:	f7fe ff12 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d03e20:	9500      	str	r5, [sp, #0]
c0d03e22:	9501      	str	r5, [sp, #4]
c0d03e24:	980c      	ldr	r0, [sp, #48]	; 0x30
c0d03e26:	4629      	mov	r1, r5
c0d03e28:	4632      	mov	r2, r6
c0d03e2a:	463b      	mov	r3, r7
c0d03e2c:	f7fc fb20 	bl	c0d00470 <cx_hash_no_throw>
c0d03e30:	2800      	cmp	r0, #0
c0d03e32:	d136      	bne.n	c0d03ea2 <signTx_handleSendDataAPDU+0x40a>
c0d03e34:	9e0c      	ldr	r6, [sp, #48]	; 0x30
  return cx_hash_get_size(hash);
c0d03e36:	4630      	mov	r0, r6
c0d03e38:	f7fc fb14 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03e3c:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d03e3e:	5a20      	ldrh	r0, [r4, r0]
c0d03e40:	492a      	ldr	r1, [pc, #168]	; (c0d03eec <signTx_handleSendDataAPDU+0x454>)
c0d03e42:	1a41      	subs	r1, r0, r1
c0d03e44:	4248      	negs	r0, r1
c0d03e46:	4148      	adcs	r0, r1
c0d03e48:	494e      	ldr	r1, [pc, #312]	; (c0d03f84 <signTx_handleSendDataAPDU+0x4ec>)
c0d03e4a:	4479      	add	r1, pc
c0d03e4c:	f7fc f910 	bl	c0d00070 <assert>
c0d03e50:	2501      	movs	r5, #1
	ASSERT(outSize == SHA_256_SIZE);
c0d03e52:	494d      	ldr	r1, [pc, #308]	; (c0d03f88 <signTx_handleSendDataAPDU+0x4f0>)
c0d03e54:	4479      	add	r1, pc
c0d03e56:	4628      	mov	r0, r5
c0d03e58:	f7fc f90a 	bl	c0d00070 <assert>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d03e5c:	9805      	ldr	r0, [sp, #20]
c0d03e5e:	9000      	str	r0, [sp, #0]
c0d03e60:	9806      	ldr	r0, [sp, #24]
c0d03e62:	9001      	str	r0, [sp, #4]
c0d03e64:	2200      	movs	r2, #0
c0d03e66:	4630      	mov	r0, r6
c0d03e68:	4629      	mov	r1, r5
c0d03e6a:	4613      	mov	r3, r2
c0d03e6c:	f7fc fb00 	bl	c0d00470 <cx_hash_no_throw>
c0d03e70:	2800      	cmp	r0, #0
c0d03e72:	d116      	bne.n	c0d03ea2 <signTx_handleSendDataAPDU+0x40a>
  return cx_hash_get_size(hash);
c0d03e74:	4620      	mov	r0, r4
c0d03e76:	3074      	adds	r0, #116	; 0x74
c0d03e78:	f7fc faf4 	bl	c0d00464 <cx_hash_get_size>
		sha_256_finalize(&ctx->integrityHashContext, ctx->prevHash, 32);
	}

	security_policy_t policy = policyForSendData(p2);
c0d03e7c:	9809      	ldr	r0, [sp, #36]	; 0x24
c0d03e7e:	f7ff fb01 	bl	c0d03484 <policyForSendData>
c0d03e82:	b2c0      	uxtb	r0, r0
c0d03e84:	2802      	cmp	r0, #2
c0d03e86:	d004      	beq.n	c0d03e92 <signTx_handleSendDataAPDU+0x3fa>
c0d03e88:	2803      	cmp	r0, #3
c0d03e8a:	9908      	ldr	r1, [sp, #32]
c0d03e8c:	d10b      	bne.n	c0d03ea6 <signTx_handleSendDataAPDU+0x40e>
c0d03e8e:	31ed      	adds	r1, #237	; 0xed
c0d03e90:	e001      	b.n	c0d03e96 <signTx_handleSendDataAPDU+0x3fe>
c0d03e92:	9908      	ldr	r1, [sp, #32]
c0d03e94:	31ee      	adds	r1, #238	; 0xee
c0d03e96:	0228      	lsls	r0, r5, #8
c0d03e98:	5021      	str	r1, [r4, r0]
		default:
			THROW(ERR_NOT_IMPLEMENTED);
		}
	}

	signTx_handleSendData_ui_runStep();
c0d03e9a:	f001 fa0d 	bl	c0d052b8 <signTx_handleSendData_ui_runStep>
}
c0d03e9e:	b00f      	add	sp, #60	; 0x3c
c0d03ea0:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d03ea2:	f7fe f977 	bl	c0d02194 <os_longjmp>
c0d03ea6:	2801      	cmp	r0, #1
c0d03ea8:	d103      	bne.n	c0d03eb2 <signTx_handleSendDataAPDU+0x41a>
c0d03eaa:	480e      	ldr	r0, [pc, #56]	; (c0d03ee4 <signTx_handleSendDataAPDU+0x44c>)
		THROW(ERR_REJECTED_BY_POLICY);
c0d03eac:	3009      	adds	r0, #9
c0d03eae:	f7fe f971 	bl	c0d02194 <os_longjmp>
c0d03eb2:	480f      	ldr	r0, [pc, #60]	; (c0d03ef0 <signTx_handleSendDataAPDU+0x458>)
c0d03eb4:	f7fe f96e 	bl	c0d02194 <os_longjmp>
	VALIDATE(
c0d03eb8:	480e      	ldr	r0, [pc, #56]	; (c0d03ef4 <signTx_handleSendDataAPDU+0x45c>)
c0d03eba:	4478      	add	r0, pc
c0d03ebc:	490e      	ldr	r1, [pc, #56]	; (c0d03ef8 <signTx_handleSendDataAPDU+0x460>)
c0d03ebe:	4479      	add	r1, pc
c0d03ec0:	9a08      	ldr	r2, [sp, #32]
c0d03ec2:	e00a      	b.n	c0d03eda <signTx_handleSendDataAPDU+0x442>
c0d03ec4:	20000490 	.word	0x20000490
c0d03ec8:	9a08      	ldr	r2, [sp, #32]
	VALIDATE(
c0d03eca:	3218      	adds	r2, #24
c0d03ecc:	e001      	b.n	c0d03ed2 <signTx_handleSendDataAPDU+0x43a>
c0d03ece:	9a08      	ldr	r2, [sp, #32]
	VALIDATE(
c0d03ed0:	321c      	adds	r2, #28
c0d03ed2:	480a      	ldr	r0, [pc, #40]	; (c0d03efc <signTx_handleSendDataAPDU+0x464>)
c0d03ed4:	4478      	add	r0, pc
c0d03ed6:	490a      	ldr	r1, [pc, #40]	; (c0d03f00 <signTx_handleSendDataAPDU+0x468>)
c0d03ed8:	4479      	add	r1, pc
c0d03eda:	f7fe feb3 	bl	c0d02c44 <mcu_usb_printf>
c0d03ede:	4801      	ldr	r0, [pc, #4]	; (c0d03ee4 <signTx_handleSendDataAPDU+0x44c>)
c0d03ee0:	f7fe f958 	bl	c0d02194 <os_longjmp>
c0d03ee4:	00006e07 	.word	0x00006e07
c0d03ee8:	20000490 	.word	0x20000490
c0d03eec:	00003039 	.word	0x00003039
c0d03ef0:	00004701 	.word	0x00004701
c0d03ef4:	00004744 	.word	0x00004744
c0d03ef8:	000054fd 	.word	0x000054fd
c0d03efc:	0000472a 	.word	0x0000472a
c0d03f00:	000054e3 	.word	0x000054e3
c0d03f04:	000057a1 	.word	0x000057a1
c0d03f08:	00004d35 	.word	0x00004d35
c0d03f0c:	0000579d 	.word	0x0000579d
c0d03f10:	00004d48 	.word	0x00004d48
c0d03f14:	00005880 	.word	0x00005880
c0d03f18:	0000593b 	.word	0x0000593b
c0d03f1c:	00005941 	.word	0x00005941
c0d03f20:	000059c3 	.word	0x000059c3
c0d03f24:	00004d7d 	.word	0x00004d7d
c0d03f28:	000059c5 	.word	0x000059c5
c0d03f2c:	00004d8e 	.word	0x00004d8e
c0d03f30:	000058c8 	.word	0x000058c8
c0d03f34:	00005a4d 	.word	0x00005a4d
c0d03f38:	00004e07 	.word	0x00004e07
c0d03f3c:	00005a4f 	.word	0x00005a4f
c0d03f40:	00004e1a 	.word	0x00004e1a
c0d03f44:	00005954 	.word	0x00005954
c0d03f48:	000058bd 	.word	0x000058bd
c0d03f4c:	00004c77 	.word	0x00004c77
c0d03f50:	000058bf 	.word	0x000058bf
c0d03f54:	00004c8a 	.word	0x00004c8a
c0d03f58:	000057c4 	.word	0x000057c4
c0d03f5c:	00005865 	.word	0x00005865
c0d03f60:	00004c1f 	.word	0x00004c1f
c0d03f64:	00005867 	.word	0x00005867
c0d03f68:	00004c30 	.word	0x00004c30
c0d03f6c:	00005768 	.word	0x00005768
c0d03f70:	00005805 	.word	0x00005805
c0d03f74:	00004bbf 	.word	0x00004bbf
c0d03f78:	00005807 	.word	0x00005807
c0d03f7c:	00004bd2 	.word	0x00004bd2
c0d03f80:	0000570c 	.word	0x0000570c
c0d03f84:	000057d0 	.word	0x000057d0
c0d03f88:	000057d4 	.word	0x000057d4

c0d03f8c <signTx_handleStartForAPDU>:

__noinline_due_to_stack__ void signTx_handleStartForAPDU(
	uint8_t p2,
	uint8_t *wireDataBuffer,
	size_t wireDataSize)
{
c0d03f8c:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d03f8e:	b089      	sub	sp, #36	; 0x24
	{
		// sanity checks
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d03f90:	2800      	cmp	r0, #0
c0d03f92:	d000      	beq.n	c0d03f96 <signTx_handleStartForAPDU+0xa>
c0d03f94:	e11a      	b.n	c0d041cc <signTx_handleStartForAPDU+0x240>
c0d03f96:	460c      	mov	r4, r1
		ASSERT(wireDataSize < BUFFER_SIZE_PARANOIA);
c0d03f98:	0a91      	lsrs	r1, r2, #10
c0d03f9a:	4248      	negs	r0, r1
c0d03f9c:	4148      	adcs	r0, r1
c0d03f9e:	49a2      	ldr	r1, [pc, #648]	; (c0d04228 <signTx_handleStartForAPDU+0x29c>)
c0d03fa0:	4479      	add	r1, pc
c0d03fa2:	1c49      	adds	r1, r1, #1
c0d03fa4:	f7fc f864 	bl	c0d00070 <assert>
c0d03fa8:	20e5      	movs	r0, #229	; 0xe5
c0d03faa:	0041      	lsls	r1, r0, #1
			uint8_t minNumIterations[1];
			uint8_t maxNumIterations[1];
			uint8_t allowedIterationHashesHash[32];
		} *wireData = (void *)wireDataBuffer;

		VALIDATE(ctx->forLevel < MAX_FOR_DEPTH, ERR_TOO_MANY_NESTED_FOR_BLOCKS);
c0d03fac:	4e9b      	ldr	r6, [pc, #620]	; (c0d0421c <signTx_handleStartForAPDU+0x290>)
c0d03fae:	5c70      	ldrb	r0, [r6, r1]
c0d03fb0:	2805      	cmp	r0, #5
c0d03fb2:	d300      	bcc.n	c0d03fb6 <signTx_handleStartForAPDU+0x2a>
c0d03fb4:	e115      	b.n	c0d041e2 <signTx_handleStartForAPDU+0x256>
c0d03fb6:	9105      	str	r1, [sp, #20]
		VALIDATE(
c0d03fb8:	7860      	ldrb	r0, [r4, #1]
c0d03fba:	9406      	str	r4, [sp, #24]
c0d03fbc:	7821      	ldrb	r1, [r4, #0]
c0d03fbe:	4281      	cmp	r1, r0
c0d03fc0:	d900      	bls.n	c0d03fc4 <signTx_handleStartForAPDU+0x38>
c0d03fc2:	e11b      	b.n	c0d041fc <signTx_handleStartForAPDU+0x270>
c0d03fc4:	20b3      	movs	r0, #179	; 0xb3
c0d03fc6:	0100      	lsls	r0, r0, #4
c0d03fc8:	af08      	add	r7, sp, #32
			wireData->minNumIterations[0] <= wireData->maxNumIterations[0],
			ERR_INVALID_DATA);

		uint8_t constants[] = {0x30, 0x0b};
c0d03fca:	8038      	strh	r0, [r7, #0]
c0d03fcc:	4630      	mov	r0, r6
c0d03fce:	3070      	adds	r0, #112	; 0x70
c0d03fd0:	1d05      	adds	r5, r0, #4
c0d03fd2:	4628      	mov	r0, r5
c0d03fd4:	f7fc fa64 	bl	c0d004a0 <cx_sha256_init_no_throw>
c0d03fd8:	2170      	movs	r1, #112	; 0x70
c0d03fda:	4891      	ldr	r0, [pc, #580]	; (c0d04220 <signTx_handleStartForAPDU+0x294>)
c0d03fdc:	9107      	str	r1, [sp, #28]
	ctx->initialized_magic = HASH_CONTEXT_INITIALIZED_MAGIC;
c0d03fde:	5270      	strh	r0, [r6, r1]
c0d03fe0:	2001      	movs	r0, #1
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d03fe2:	4992      	ldr	r1, [pc, #584]	; (c0d0422c <signTx_handleStartForAPDU+0x2a0>)
c0d03fe4:	4479      	add	r1, pc
c0d03fe6:	f7fc f843 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d03fea:	4891      	ldr	r0, [pc, #580]	; (c0d04230 <signTx_handleStartForAPDU+0x2a4>)
c0d03fec:	4478      	add	r0, pc
c0d03fee:	4991      	ldr	r1, [pc, #580]	; (c0d04234 <signTx_handleStartForAPDU+0x2a8>)
c0d03ff0:	4479      	add	r1, pc
c0d03ff2:	2224      	movs	r2, #36	; 0x24
c0d03ff4:	f7fe fe26 	bl	c0d02c44 <mcu_usb_printf>
c0d03ff8:	488f      	ldr	r0, [pc, #572]	; (c0d04238 <signTx_handleStartForAPDU+0x2ac>)
c0d03ffa:	4478      	add	r0, pc
c0d03ffc:	2402      	movs	r4, #2
c0d03ffe:	4621      	mov	r1, r4
c0d04000:	463a      	mov	r2, r7
c0d04002:	f7fe fe1f 	bl	c0d02c44 <mcu_usb_printf>
c0d04006:	488d      	ldr	r0, [pc, #564]	; (c0d0423c <signTx_handleStartForAPDU+0x2b0>)
c0d04008:	4478      	add	r0, pc
c0d0400a:	f7fe fe1b 	bl	c0d02c44 <mcu_usb_printf>
c0d0400e:	2600      	movs	r6, #0
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04010:	9600      	str	r6, [sp, #0]
c0d04012:	9601      	str	r6, [sp, #4]
c0d04014:	4628      	mov	r0, r5
c0d04016:	4631      	mov	r1, r6
c0d04018:	463a      	mov	r2, r7
c0d0401a:	4623      	mov	r3, r4
c0d0401c:	f7fc fa28 	bl	c0d00470 <cx_hash_no_throw>
c0d04020:	2800      	cmp	r0, #0
c0d04022:	d000      	beq.n	c0d04026 <signTx_handleStartForAPDU+0x9a>
c0d04024:	e0f5      	b.n	c0d04212 <signTx_handleStartForAPDU+0x286>
  return cx_hash_get_size(hash);
c0d04026:	4628      	mov	r0, r5
c0d04028:	f7fc fa1c 	bl	c0d00464 <cx_hash_get_size>
c0d0402c:	4f7b      	ldr	r7, [pc, #492]	; (c0d0421c <signTx_handleStartForAPDU+0x290>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d0402e:	9807      	ldr	r0, [sp, #28]
c0d04030:	5a38      	ldrh	r0, [r7, r0]
c0d04032:	497b      	ldr	r1, [pc, #492]	; (c0d04220 <signTx_handleStartForAPDU+0x294>)
c0d04034:	1a41      	subs	r1, r0, r1
c0d04036:	4248      	negs	r0, r1
c0d04038:	4148      	adcs	r0, r1
c0d0403a:	4981      	ldr	r1, [pc, #516]	; (c0d04240 <signTx_handleStartForAPDU+0x2b4>)
c0d0403c:	4479      	add	r1, pc
c0d0403e:	f7fc f817 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d04042:	4880      	ldr	r0, [pc, #512]	; (c0d04244 <signTx_handleStartForAPDU+0x2b8>)
c0d04044:	4478      	add	r0, pc
c0d04046:	4980      	ldr	r1, [pc, #512]	; (c0d04248 <signTx_handleStartForAPDU+0x2bc>)
c0d04048:	4479      	add	r1, pc
c0d0404a:	2224      	movs	r2, #36	; 0x24
c0d0404c:	f7fe fdfa 	bl	c0d02c44 <mcu_usb_printf>
c0d04050:	37e0      	adds	r7, #224	; 0xe0
c0d04052:	487e      	ldr	r0, [pc, #504]	; (c0d0424c <signTx_handleStartForAPDU+0x2c0>)
c0d04054:	4478      	add	r0, pc
c0d04056:	2420      	movs	r4, #32
c0d04058:	4621      	mov	r1, r4
c0d0405a:	463a      	mov	r2, r7
c0d0405c:	f7fe fdf2 	bl	c0d02c44 <mcu_usb_printf>
c0d04060:	487b      	ldr	r0, [pc, #492]	; (c0d04250 <signTx_handleStartForAPDU+0x2c4>)
c0d04062:	4478      	add	r0, pc
c0d04064:	f7fe fdee 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04068:	9600      	str	r6, [sp, #0]
c0d0406a:	9601      	str	r6, [sp, #4]
c0d0406c:	4628      	mov	r0, r5
c0d0406e:	4631      	mov	r1, r6
c0d04070:	463a      	mov	r2, r7
c0d04072:	9404      	str	r4, [sp, #16]
c0d04074:	4623      	mov	r3, r4
c0d04076:	f7fc f9fb 	bl	c0d00470 <cx_hash_no_throw>
c0d0407a:	2800      	cmp	r0, #0
c0d0407c:	d000      	beq.n	c0d04080 <signTx_handleStartForAPDU+0xf4>
c0d0407e:	e0c8      	b.n	c0d04212 <signTx_handleStartForAPDU+0x286>
  return cx_hash_get_size(hash);
c0d04080:	4628      	mov	r0, r5
c0d04082:	f7fc f9ef 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04086:	4865      	ldr	r0, [pc, #404]	; (c0d0421c <signTx_handleStartForAPDU+0x290>)
c0d04088:	9907      	ldr	r1, [sp, #28]
c0d0408a:	5a40      	ldrh	r0, [r0, r1]
c0d0408c:	4964      	ldr	r1, [pc, #400]	; (c0d04220 <signTx_handleStartForAPDU+0x294>)
c0d0408e:	1a41      	subs	r1, r0, r1
c0d04090:	4248      	negs	r0, r1
c0d04092:	4148      	adcs	r0, r1
c0d04094:	496f      	ldr	r1, [pc, #444]	; (c0d04254 <signTx_handleStartForAPDU+0x2c8>)
c0d04096:	4479      	add	r1, pc
c0d04098:	f7fb ffea 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d0409c:	486e      	ldr	r0, [pc, #440]	; (c0d04258 <signTx_handleStartForAPDU+0x2cc>)
c0d0409e:	4478      	add	r0, pc
c0d040a0:	496e      	ldr	r1, [pc, #440]	; (c0d0425c <signTx_handleStartForAPDU+0x2d0>)
c0d040a2:	4479      	add	r1, pc
c0d040a4:	2224      	movs	r2, #36	; 0x24
c0d040a6:	f7fe fdcd 	bl	c0d02c44 <mcu_usb_printf>
c0d040aa:	486d      	ldr	r0, [pc, #436]	; (c0d04260 <signTx_handleStartForAPDU+0x2d4>)
c0d040ac:	4478      	add	r0, pc
c0d040ae:	2401      	movs	r4, #1
c0d040b0:	4621      	mov	r1, r4
c0d040b2:	9f06      	ldr	r7, [sp, #24]
c0d040b4:	463a      	mov	r2, r7
c0d040b6:	f7fe fdc5 	bl	c0d02c44 <mcu_usb_printf>
c0d040ba:	486a      	ldr	r0, [pc, #424]	; (c0d04264 <signTx_handleStartForAPDU+0x2d8>)
c0d040bc:	4478      	add	r0, pc
c0d040be:	f7fe fdc1 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d040c2:	9600      	str	r6, [sp, #0]
c0d040c4:	9601      	str	r6, [sp, #4]
c0d040c6:	4628      	mov	r0, r5
c0d040c8:	4631      	mov	r1, r6
c0d040ca:	463a      	mov	r2, r7
c0d040cc:	4623      	mov	r3, r4
c0d040ce:	f7fc f9cf 	bl	c0d00470 <cx_hash_no_throw>
c0d040d2:	2800      	cmp	r0, #0
c0d040d4:	d000      	beq.n	c0d040d8 <signTx_handleStartForAPDU+0x14c>
c0d040d6:	e09c      	b.n	c0d04212 <signTx_handleStartForAPDU+0x286>
c0d040d8:	1c7f      	adds	r7, r7, #1
  return cx_hash_get_size(hash);
c0d040da:	4628      	mov	r0, r5
c0d040dc:	f7fc f9c2 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d040e0:	484e      	ldr	r0, [pc, #312]	; (c0d0421c <signTx_handleStartForAPDU+0x290>)
c0d040e2:	9907      	ldr	r1, [sp, #28]
c0d040e4:	5a40      	ldrh	r0, [r0, r1]
c0d040e6:	494e      	ldr	r1, [pc, #312]	; (c0d04220 <signTx_handleStartForAPDU+0x294>)
c0d040e8:	1a41      	subs	r1, r0, r1
c0d040ea:	4248      	negs	r0, r1
c0d040ec:	4148      	adcs	r0, r1
c0d040ee:	495e      	ldr	r1, [pc, #376]	; (c0d04268 <signTx_handleStartForAPDU+0x2dc>)
c0d040f0:	4479      	add	r1, pc
c0d040f2:	f7fb ffbd 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d040f6:	485d      	ldr	r0, [pc, #372]	; (c0d0426c <signTx_handleStartForAPDU+0x2e0>)
c0d040f8:	4478      	add	r0, pc
c0d040fa:	495d      	ldr	r1, [pc, #372]	; (c0d04270 <signTx_handleStartForAPDU+0x2e4>)
c0d040fc:	4479      	add	r1, pc
c0d040fe:	2224      	movs	r2, #36	; 0x24
c0d04100:	f7fe fda0 	bl	c0d02c44 <mcu_usb_printf>
c0d04104:	485b      	ldr	r0, [pc, #364]	; (c0d04274 <signTx_handleStartForAPDU+0x2e8>)
c0d04106:	4478      	add	r0, pc
c0d04108:	2401      	movs	r4, #1
c0d0410a:	4621      	mov	r1, r4
c0d0410c:	463a      	mov	r2, r7
c0d0410e:	f7fe fd99 	bl	c0d02c44 <mcu_usb_printf>
c0d04112:	4859      	ldr	r0, [pc, #356]	; (c0d04278 <signTx_handleStartForAPDU+0x2ec>)
c0d04114:	4478      	add	r0, pc
c0d04116:	f7fe fd95 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d0411a:	9600      	str	r6, [sp, #0]
c0d0411c:	9601      	str	r6, [sp, #4]
c0d0411e:	4628      	mov	r0, r5
c0d04120:	4631      	mov	r1, r6
c0d04122:	463a      	mov	r2, r7
c0d04124:	4623      	mov	r3, r4
c0d04126:	f7fc f9a3 	bl	c0d00470 <cx_hash_no_throw>
c0d0412a:	2800      	cmp	r0, #0
c0d0412c:	d171      	bne.n	c0d04212 <signTx_handleStartForAPDU+0x286>
  return cx_hash_get_size(hash);
c0d0412e:	4628      	mov	r0, r5
c0d04130:	f7fc f998 	bl	c0d00464 <cx_hash_get_size>
c0d04134:	9503      	str	r5, [sp, #12]
c0d04136:	4d39      	ldr	r5, [pc, #228]	; (c0d0421c <signTx_handleStartForAPDU+0x290>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04138:	9807      	ldr	r0, [sp, #28]
c0d0413a:	5a28      	ldrh	r0, [r5, r0]
c0d0413c:	4938      	ldr	r1, [pc, #224]	; (c0d04220 <signTx_handleStartForAPDU+0x294>)
c0d0413e:	1a41      	subs	r1, r0, r1
c0d04140:	4248      	negs	r0, r1
c0d04142:	4148      	adcs	r0, r1
c0d04144:	9f05      	ldr	r7, [sp, #20]
		sha_256_append(&ctx->integrityHashContext, ctx->prevHash, 32);
		// Put possible iterations range into the integrity hash
		sha_256_append(&ctx->integrityHashContext, wireData->minNumIterations, 1);
		sha_256_append(&ctx->integrityHashContext, wireData->maxNumIterations, 1);

		sha_256_finalize(&ctx->integrityHashContext, ctx->intHashes[ctx->forLevel], 32);
c0d04146:	5dee      	ldrb	r6, [r5, r7]
c0d04148:	494c      	ldr	r1, [pc, #304]	; (c0d0427c <signTx_handleStartForAPDU+0x2f0>)
c0d0414a:	4479      	add	r1, pc
c0d0414c:	f7fb ff90 	bl	c0d00070 <assert>
c0d04150:	2401      	movs	r4, #1
	ASSERT(outSize == SHA_256_SIZE);
c0d04152:	494b      	ldr	r1, [pc, #300]	; (c0d04280 <signTx_handleStartForAPDU+0x2f4>)
c0d04154:	4479      	add	r1, pc
c0d04156:	4620      	mov	r0, r4
c0d04158:	f7fb ff8a 	bl	c0d00070 <assert>
c0d0415c:	0170      	lsls	r0, r6, #5
c0d0415e:	1828      	adds	r0, r5, r0
c0d04160:	21ff      	movs	r1, #255	; 0xff
c0d04162:	31cc      	adds	r1, #204	; 0xcc
c0d04164:	1840      	adds	r0, r0, r1
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04166:	9000      	str	r0, [sp, #0]
c0d04168:	9804      	ldr	r0, [sp, #16]
c0d0416a:	9001      	str	r0, [sp, #4]
c0d0416c:	2200      	movs	r2, #0
c0d0416e:	9803      	ldr	r0, [sp, #12]
c0d04170:	4621      	mov	r1, r4
c0d04172:	9207      	str	r2, [sp, #28]
c0d04174:	4613      	mov	r3, r2
c0d04176:	f7fc f97b 	bl	c0d00470 <cx_hash_no_throw>
c0d0417a:	2800      	cmp	r0, #0
c0d0417c:	d149      	bne.n	c0d04212 <signTx_handleStartForAPDU+0x286>
c0d0417e:	4e27      	ldr	r6, [pc, #156]	; (c0d0421c <signTx_handleStartForAPDU+0x290>)
  return cx_hash_get_size(hash);
c0d04180:	4630      	mov	r0, r6
c0d04182:	3074      	adds	r0, #116	; 0x74
c0d04184:	f7fc f96e 	bl	c0d00464 <cx_hash_get_size>

		ctx->forLevel++;
c0d04188:	5df0      	ldrb	r0, [r6, r7]
c0d0418a:	1c40      	adds	r0, r0, #1
c0d0418c:	55f0      	strb	r0, [r6, r7]

		// This will be used at the end of each iteration to
		// check whether the received list is still the same
		memcpy(
			ctx->allowedIterationHashesHash[ctx->forLevel],
c0d0418e:	b2c4      	uxtb	r4, r0
		memcpy(
c0d04190:	0160      	lsls	r0, r4, #5
c0d04192:	1830      	adds	r0, r6, r0
c0d04194:	4923      	ldr	r1, [pc, #140]	; (c0d04224 <signTx_handleStartForAPDU+0x298>)
c0d04196:	1840      	adds	r0, r0, r1
c0d04198:	9d06      	ldr	r5, [sp, #24]
			wireData->allowedIterationHashesHash, 32);
c0d0419a:	1ca9      	adds	r1, r5, #2
c0d0419c:	2220      	movs	r2, #32
		memcpy(
c0d0419e:	f004 f9ba 	bl	c0d08516 <__aeabi_memcpy>

		// Will be decreased in each iteration
		ctx->forMinIterations[ctx->forLevel] = wireData->minNumIterations[0];
c0d041a2:	1930      	adds	r0, r6, r4
c0d041a4:	21df      	movs	r1, #223	; 0xdf
c0d041a6:	0049      	lsls	r1, r1, #1
c0d041a8:	782a      	ldrb	r2, [r5, #0]
c0d041aa:	5442      	strb	r2, [r0, r1]
		ctx->forMaxIterations[ctx->forLevel] = wireData->maxNumIterations[0];
c0d041ac:	5df0      	ldrb	r0, [r6, r7]
c0d041ae:	1830      	adds	r0, r6, r0
c0d041b0:	7869      	ldrb	r1, [r5, #1]
c0d041b2:	2271      	movs	r2, #113	; 0x71
c0d041b4:	0092      	lsls	r2, r2, #2
c0d041b6:	5481      	strb	r1, [r0, r2]
		ctx->forIterationsCnt[ctx->forLevel] = 0;
c0d041b8:	5df0      	ldrb	r0, [r6, r7]
c0d041ba:	1830      	adds	r0, r6, r0
c0d041bc:	2137      	movs	r1, #55	; 0x37
c0d041be:	00c9      	lsls	r1, r1, #3
c0d041c0:	9a07      	ldr	r2, [sp, #28]
c0d041c2:	5442      	strb	r2, [r0, r1]
	respondSuccessEmptyMsg();
c0d041c4:	f7ff f96c 	bl	c0d034a0 <respondSuccessEmptyMsg>
	}

	signTx_handleStartFor_ui_runStep();
}
c0d041c8:	b009      	add	sp, #36	; 0x24
c0d041ca:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d041cc:	22ff      	movs	r2, #255	; 0xff
c0d041ce:	328a      	adds	r2, #138	; 0x8a
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d041d0:	482c      	ldr	r0, [pc, #176]	; (c0d04284 <signTx_handleStartForAPDU+0x2f8>)
c0d041d2:	4478      	add	r0, pc
c0d041d4:	492c      	ldr	r1, [pc, #176]	; (c0d04288 <signTx_handleStartForAPDU+0x2fc>)
c0d041d6:	4479      	add	r1, pc
c0d041d8:	f7fe fd34 	bl	c0d02c44 <mcu_usb_printf>
c0d041dc:	480e      	ldr	r0, [pc, #56]	; (c0d04218 <signTx_handleStartForAPDU+0x28c>)
c0d041de:	f7fd ffd9 	bl	c0d02194 <os_longjmp>
c0d041e2:	22ff      	movs	r2, #255	; 0xff
c0d041e4:	328a      	adds	r2, #138	; 0x8a
		VALIDATE(ctx->forLevel < MAX_FOR_DEPTH, ERR_TOO_MANY_NESTED_FOR_BLOCKS);
c0d041e6:	320c      	adds	r2, #12
c0d041e8:	4828      	ldr	r0, [pc, #160]	; (c0d0428c <signTx_handleStartForAPDU+0x300>)
c0d041ea:	4478      	add	r0, pc
c0d041ec:	4928      	ldr	r1, [pc, #160]	; (c0d04290 <signTx_handleStartForAPDU+0x304>)
c0d041ee:	4479      	add	r1, pc
c0d041f0:	f7fe fd28 	bl	c0d02c44 <mcu_usb_printf>
c0d041f4:	2049      	movs	r0, #73	; 0x49
c0d041f6:	0200      	lsls	r0, r0, #8
c0d041f8:	f7fd ffcc 	bl	c0d02194 <os_longjmp>
c0d041fc:	22ff      	movs	r2, #255	; 0xff
c0d041fe:	328a      	adds	r2, #138	; 0x8a
		VALIDATE(
c0d04200:	320f      	adds	r2, #15
c0d04202:	4824      	ldr	r0, [pc, #144]	; (c0d04294 <signTx_handleStartForAPDU+0x308>)
c0d04204:	4478      	add	r0, pc
c0d04206:	4924      	ldr	r1, [pc, #144]	; (c0d04298 <signTx_handleStartForAPDU+0x30c>)
c0d04208:	4479      	add	r1, pc
c0d0420a:	f7fe fd1b 	bl	c0d02c44 <mcu_usb_printf>
c0d0420e:	4802      	ldr	r0, [pc, #8]	; (c0d04218 <signTx_handleStartForAPDU+0x28c>)
c0d04210:	1c80      	adds	r0, r0, #2
c0d04212:	f7fd ffbf 	bl	c0d02194 <os_longjmp>
c0d04216:	46c0      	nop			; (mov r8, r8)
c0d04218:	00006e05 	.word	0x00006e05
c0d0421c:	20000490 	.word	0x20000490
c0d04220:	00003039 	.word	0x00003039
c0d04224:	0000026b 	.word	0x0000026b
c0d04228:	000054a7 	.word	0x000054a7
c0d0422c:	00005619 	.word	0x00005619
c0d04230:	000049d3 	.word	0x000049d3
c0d04234:	0000561b 	.word	0x0000561b
c0d04238:	000049e6 	.word	0x000049e6
c0d0423c:	0000551e 	.word	0x0000551e
c0d04240:	000055c1 	.word	0x000055c1
c0d04244:	0000497b 	.word	0x0000497b
c0d04248:	000055c3 	.word	0x000055c3
c0d0424c:	0000498c 	.word	0x0000498c
c0d04250:	000054c4 	.word	0x000054c4
c0d04254:	00005567 	.word	0x00005567
c0d04258:	00004921 	.word	0x00004921
c0d0425c:	00005569 	.word	0x00005569
c0d04260:	00004934 	.word	0x00004934
c0d04264:	0000546a 	.word	0x0000546a
c0d04268:	0000550d 	.word	0x0000550d
c0d0426c:	000048c7 	.word	0x000048c7
c0d04270:	0000550f 	.word	0x0000550f
c0d04274:	000048da 	.word	0x000048da
c0d04278:	00005412 	.word	0x00005412
c0d0427c:	000054d0 	.word	0x000054d0
c0d04280:	000054d4 	.word	0x000054d4
c0d04284:	0000442c 	.word	0x0000442c
c0d04288:	000051e5 	.word	0x000051e5
c0d0428c:	00004414 	.word	0x00004414
c0d04290:	000051cd 	.word	0x000051cd
c0d04294:	000043fa 	.word	0x000043fa
c0d04298:	000051b3 	.word	0x000051b3

c0d0429c <signTx_handleEndForAPDU>:

__noinline_due_to_stack__ void signTx_handleEndForAPDU(
	uint8_t p2,
	uint8_t *wireDataBuffer,
	size_t wireDataSize)
{
c0d0429c:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0429e:	b087      	sub	sp, #28
	{
		// sanity checks
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d042a0:	2800      	cmp	r0, #0
c0d042a2:	d000      	beq.n	c0d042a6 <signTx_handleEndForAPDU+0xa>
c0d042a4:	e0ec      	b.n	c0d04480 <signTx_handleEndForAPDU+0x1e4>
		ASSERT(wireDataSize < BUFFER_SIZE_PARANOIA);
c0d042a6:	0a91      	lsrs	r1, r2, #10
c0d042a8:	4248      	negs	r0, r1
c0d042aa:	4148      	adcs	r0, r1
c0d042ac:	4989      	ldr	r1, [pc, #548]	; (c0d044d4 <signTx_handleEndForAPDU+0x238>)
c0d042ae:	4479      	add	r1, pc
c0d042b0:	1c49      	adds	r1, r1, #1
c0d042b2:	f7fb fedd 	bl	c0d00070 <assert>
c0d042b6:	20e5      	movs	r0, #229	; 0xe5
c0d042b8:	0043      	lsls	r3, r0, #1
	}

	{
		// Is there a for to end?
		VALIDATE(ctx->forLevel > 0, ERR_CANT_END_FOR);
c0d042ba:	4d82      	ldr	r5, [pc, #520]	; (c0d044c4 <signTx_handleEndForAPDU+0x228>)
c0d042bc:	5ce8      	ldrb	r0, [r5, r3]
c0d042be:	2800      	cmp	r0, #0
c0d042c0:	d100      	bne.n	c0d042c4 <signTx_handleEndForAPDU+0x28>
c0d042c2:	e0e8      	b.n	c0d04496 <signTx_handleEndForAPDU+0x1fa>
		// Were there enought iterations?
		VALIDATE(
c0d042c4:	1828      	adds	r0, r5, r0
c0d042c6:	2137      	movs	r1, #55	; 0x37
c0d042c8:	00c9      	lsls	r1, r1, #3
c0d042ca:	5c41      	ldrb	r1, [r0, r1]
c0d042cc:	22df      	movs	r2, #223	; 0xdf
c0d042ce:	0052      	lsls	r2, r2, #1
c0d042d0:	5c82      	ldrb	r2, [r0, r2]
c0d042d2:	4291      	cmp	r1, r2
c0d042d4:	d200      	bcs.n	c0d042d8 <signTx_handleEndForAPDU+0x3c>
c0d042d6:	e0e2      	b.n	c0d0449e <signTx_handleEndForAPDU+0x202>
c0d042d8:	9305      	str	r3, [sp, #20]
c0d042da:	2271      	movs	r2, #113	; 0x71
c0d042dc:	0092      	lsls	r2, r2, #2
			ctx->forIterationsCnt[ctx->forLevel] >= ctx->forMinIterations[ctx->forLevel],
			ERR_CANT_END_FOR);
		// Were there not too many iterations?
		VALIDATE(
c0d042de:	5c80      	ldrb	r0, [r0, r2]
c0d042e0:	4281      	cmp	r1, r0
c0d042e2:	d900      	bls.n	c0d042e6 <signTx_handleEndForAPDU+0x4a>
c0d042e4:	e0df      	b.n	c0d044a6 <signTx_handleEndForAPDU+0x20a>
c0d042e6:	20c3      	movs	r0, #195	; 0xc3
c0d042e8:	0100      	lsls	r0, r0, #4
c0d042ea:	ae06      	add	r6, sp, #24
			ctx->forIterationsCnt[ctx->forLevel] <= ctx->forMaxIterations[ctx->forLevel],
			ERR_CANT_END_FOR);

		uint8_t constants[] = {0x30, 0x0c};
c0d042ec:	8030      	strh	r0, [r6, #0]
c0d042ee:	4628      	mov	r0, r5
c0d042f0:	3070      	adds	r0, #112	; 0x70
c0d042f2:	1d04      	adds	r4, r0, #4
c0d042f4:	4620      	mov	r0, r4
c0d042f6:	f7fc f8d3 	bl	c0d004a0 <cx_sha256_init_no_throw>
c0d042fa:	2170      	movs	r1, #112	; 0x70
c0d042fc:	4872      	ldr	r0, [pc, #456]	; (c0d044c8 <signTx_handleEndForAPDU+0x22c>)
c0d042fe:	9104      	str	r1, [sp, #16]
	ctx->initialized_magic = HASH_CONTEXT_INITIALIZED_MAGIC;
c0d04300:	5268      	strh	r0, [r5, r1]
c0d04302:	2001      	movs	r0, #1
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04304:	4976      	ldr	r1, [pc, #472]	; (c0d044e0 <signTx_handleEndForAPDU+0x244>)
c0d04306:	4479      	add	r1, pc
c0d04308:	f7fb feb2 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d0430c:	4875      	ldr	r0, [pc, #468]	; (c0d044e4 <signTx_handleEndForAPDU+0x248>)
c0d0430e:	4478      	add	r0, pc
c0d04310:	4975      	ldr	r1, [pc, #468]	; (c0d044e8 <signTx_handleEndForAPDU+0x24c>)
c0d04312:	4479      	add	r1, pc
c0d04314:	2224      	movs	r2, #36	; 0x24
c0d04316:	f7fe fc95 	bl	c0d02c44 <mcu_usb_printf>
c0d0431a:	4874      	ldr	r0, [pc, #464]	; (c0d044ec <signTx_handleEndForAPDU+0x250>)
c0d0431c:	4478      	add	r0, pc
c0d0431e:	2702      	movs	r7, #2
c0d04320:	4639      	mov	r1, r7
c0d04322:	4632      	mov	r2, r6
c0d04324:	f7fe fc8e 	bl	c0d02c44 <mcu_usb_printf>
c0d04328:	4871      	ldr	r0, [pc, #452]	; (c0d044f0 <signTx_handleEndForAPDU+0x254>)
c0d0432a:	4478      	add	r0, pc
c0d0432c:	f7fe fc8a 	bl	c0d02c44 <mcu_usb_printf>
c0d04330:	2500      	movs	r5, #0
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04332:	9500      	str	r5, [sp, #0]
c0d04334:	9501      	str	r5, [sp, #4]
c0d04336:	4620      	mov	r0, r4
c0d04338:	4629      	mov	r1, r5
c0d0433a:	4632      	mov	r2, r6
c0d0433c:	463b      	mov	r3, r7
c0d0433e:	f7fc f897 	bl	c0d00470 <cx_hash_no_throw>
c0d04342:	2800      	cmp	r0, #0
c0d04344:	d000      	beq.n	c0d04348 <signTx_handleEndForAPDU+0xac>
c0d04346:	e0a4      	b.n	c0d04492 <signTx_handleEndForAPDU+0x1f6>
  return cx_hash_get_size(hash);
c0d04348:	4620      	mov	r0, r4
c0d0434a:	f7fc f88b 	bl	c0d00464 <cx_hash_get_size>
c0d0434e:	4f5d      	ldr	r7, [pc, #372]	; (c0d044c4 <signTx_handleEndForAPDU+0x228>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04350:	9804      	ldr	r0, [sp, #16]
c0d04352:	5a38      	ldrh	r0, [r7, r0]
c0d04354:	495c      	ldr	r1, [pc, #368]	; (c0d044c8 <signTx_handleEndForAPDU+0x22c>)
c0d04356:	1a41      	subs	r1, r0, r1
c0d04358:	4248      	negs	r0, r1
c0d0435a:	4148      	adcs	r0, r1

		sha_256_init(&ctx->integrityHashContext);
		sha_256_append(&ctx->integrityHashContext, constants, SIZEOF(constants));
		sha_256_append(&ctx->integrityHashContext, ctx->intHashes[ctx->forLevel - 1], 32);
c0d0435c:	9905      	ldr	r1, [sp, #20]
c0d0435e:	5c7e      	ldrb	r6, [r7, r1]
c0d04360:	4964      	ldr	r1, [pc, #400]	; (c0d044f4 <signTx_handleEndForAPDU+0x258>)
c0d04362:	4479      	add	r1, pc
c0d04364:	f7fb fe84 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d04368:	4863      	ldr	r0, [pc, #396]	; (c0d044f8 <signTx_handleEndForAPDU+0x25c>)
c0d0436a:	4478      	add	r0, pc
c0d0436c:	4963      	ldr	r1, [pc, #396]	; (c0d044fc <signTx_handleEndForAPDU+0x260>)
c0d0436e:	4479      	add	r1, pc
c0d04370:	2224      	movs	r2, #36	; 0x24
c0d04372:	f7fe fc67 	bl	c0d02c44 <mcu_usb_printf>
c0d04376:	0170      	lsls	r0, r6, #5
c0d04378:	19c0      	adds	r0, r0, r7
c0d0437a:	21ff      	movs	r1, #255	; 0xff
c0d0437c:	31ac      	adds	r1, #172	; 0xac
c0d0437e:	9103      	str	r1, [sp, #12]
c0d04380:	1846      	adds	r6, r0, r1
c0d04382:	485f      	ldr	r0, [pc, #380]	; (c0d04500 <signTx_handleEndForAPDU+0x264>)
c0d04384:	4478      	add	r0, pc
c0d04386:	2720      	movs	r7, #32
c0d04388:	4639      	mov	r1, r7
c0d0438a:	4632      	mov	r2, r6
c0d0438c:	f7fe fc5a 	bl	c0d02c44 <mcu_usb_printf>
c0d04390:	485c      	ldr	r0, [pc, #368]	; (c0d04504 <signTx_handleEndForAPDU+0x268>)
c0d04392:	4478      	add	r0, pc
c0d04394:	f7fe fc56 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04398:	9500      	str	r5, [sp, #0]
c0d0439a:	9501      	str	r5, [sp, #4]
c0d0439c:	4620      	mov	r0, r4
c0d0439e:	4629      	mov	r1, r5
c0d043a0:	4632      	mov	r2, r6
c0d043a2:	463b      	mov	r3, r7
c0d043a4:	f7fc f864 	bl	c0d00470 <cx_hash_no_throw>
c0d043a8:	2800      	cmp	r0, #0
c0d043aa:	d172      	bne.n	c0d04492 <signTx_handleEndForAPDU+0x1f6>
  return cx_hash_get_size(hash);
c0d043ac:	4620      	mov	r0, r4
c0d043ae:	f7fc f859 	bl	c0d00464 <cx_hash_get_size>
c0d043b2:	4f44      	ldr	r7, [pc, #272]	; (c0d044c4 <signTx_handleEndForAPDU+0x228>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d043b4:	9804      	ldr	r0, [sp, #16]
c0d043b6:	5a38      	ldrh	r0, [r7, r0]
c0d043b8:	4943      	ldr	r1, [pc, #268]	; (c0d044c8 <signTx_handleEndForAPDU+0x22c>)
c0d043ba:	1a41      	subs	r1, r0, r1
c0d043bc:	4248      	negs	r0, r1
c0d043be:	4148      	adcs	r0, r1
		sha_256_append(
			&ctx->integrityHashContext,
			ctx->allowedIterationHashesHash[ctx->forLevel], 32);
c0d043c0:	9905      	ldr	r1, [sp, #20]
c0d043c2:	5c7e      	ldrb	r6, [r7, r1]
c0d043c4:	4950      	ldr	r1, [pc, #320]	; (c0d04508 <signTx_handleEndForAPDU+0x26c>)
c0d043c6:	4479      	add	r1, pc
c0d043c8:	f7fb fe52 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d043cc:	484f      	ldr	r0, [pc, #316]	; (c0d0450c <signTx_handleEndForAPDU+0x270>)
c0d043ce:	4478      	add	r0, pc
c0d043d0:	494f      	ldr	r1, [pc, #316]	; (c0d04510 <signTx_handleEndForAPDU+0x274>)
c0d043d2:	4479      	add	r1, pc
c0d043d4:	2224      	movs	r2, #36	; 0x24
c0d043d6:	f7fe fc35 	bl	c0d02c44 <mcu_usb_printf>
c0d043da:	0170      	lsls	r0, r6, #5
c0d043dc:	1838      	adds	r0, r7, r0
c0d043de:	493b      	ldr	r1, [pc, #236]	; (c0d044cc <signTx_handleEndForAPDU+0x230>)
c0d043e0:	1847      	adds	r7, r0, r1
c0d043e2:	484c      	ldr	r0, [pc, #304]	; (c0d04514 <signTx_handleEndForAPDU+0x278>)
c0d043e4:	4478      	add	r0, pc
c0d043e6:	2620      	movs	r6, #32
c0d043e8:	4631      	mov	r1, r6
c0d043ea:	463a      	mov	r2, r7
c0d043ec:	f7fe fc2a 	bl	c0d02c44 <mcu_usb_printf>
c0d043f0:	4849      	ldr	r0, [pc, #292]	; (c0d04518 <signTx_handleEndForAPDU+0x27c>)
c0d043f2:	4478      	add	r0, pc
c0d043f4:	f7fe fc26 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d043f8:	9500      	str	r5, [sp, #0]
c0d043fa:	9501      	str	r5, [sp, #4]
c0d043fc:	4620      	mov	r0, r4
c0d043fe:	4629      	mov	r1, r5
c0d04400:	463a      	mov	r2, r7
c0d04402:	4633      	mov	r3, r6
c0d04404:	f7fc f834 	bl	c0d00470 <cx_hash_no_throw>
c0d04408:	2800      	cmp	r0, #0
c0d0440a:	d142      	bne.n	c0d04492 <signTx_handleEndForAPDU+0x1f6>
  return cx_hash_get_size(hash);
c0d0440c:	4620      	mov	r0, r4
c0d0440e:	f7fc f829 	bl	c0d00464 <cx_hash_get_size>
c0d04412:	4f2c      	ldr	r7, [pc, #176]	; (c0d044c4 <signTx_handleEndForAPDU+0x228>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04414:	9804      	ldr	r0, [sp, #16]
c0d04416:	5a38      	ldrh	r0, [r7, r0]
c0d04418:	492b      	ldr	r1, [pc, #172]	; (c0d044c8 <signTx_handleEndForAPDU+0x22c>)
c0d0441a:	1a41      	subs	r1, r0, r1
c0d0441c:	4248      	negs	r0, r1
c0d0441e:	4148      	adcs	r0, r1
c0d04420:	493e      	ldr	r1, [pc, #248]	; (c0d0451c <signTx_handleEndForAPDU+0x280>)
c0d04422:	4479      	add	r1, pc
c0d04424:	f7fb fe24 	bl	c0d00070 <assert>
c0d04428:	2501      	movs	r5, #1
	ASSERT(outSize == SHA_256_SIZE);
c0d0442a:	493d      	ldr	r1, [pc, #244]	; (c0d04520 <signTx_handleEndForAPDU+0x284>)
c0d0442c:	4479      	add	r1, pc
c0d0442e:	4628      	mov	r0, r5
c0d04430:	f7fb fe1e 	bl	c0d00070 <assert>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04434:	4638      	mov	r0, r7
c0d04436:	30e0      	adds	r0, #224	; 0xe0
c0d04438:	9000      	str	r0, [sp, #0]
c0d0443a:	9601      	str	r6, [sp, #4]
c0d0443c:	2200      	movs	r2, #0
c0d0443e:	4620      	mov	r0, r4
c0d04440:	4629      	mov	r1, r5
c0d04442:	4613      	mov	r3, r2
c0d04444:	f7fc f814 	bl	c0d00470 <cx_hash_no_throw>
c0d04448:	2800      	cmp	r0, #0
c0d0444a:	d122      	bne.n	c0d04492 <signTx_handleEndForAPDU+0x1f6>
  return cx_hash_get_size(hash);
c0d0444c:	4638      	mov	r0, r7
c0d0444e:	3074      	adds	r0, #116	; 0x74
c0d04450:	f7fc f808 	bl	c0d00464 <cx_hash_get_size>
		sha_256_finalize(&ctx->integrityHashContext, ctx->prevHash, 32);

		explicit_bzero(ctx->allowedIterationHashesHash, 32);
c0d04454:	481d      	ldr	r0, [pc, #116]	; (c0d044cc <signTx_handleEndForAPDU+0x230>)
c0d04456:	1838      	adds	r0, r7, r0
c0d04458:	2420      	movs	r4, #32
c0d0445a:	4621      	mov	r1, r4
c0d0445c:	f004 f86a 	bl	c0d08534 <explicit_bzero>
c0d04460:	9d05      	ldr	r5, [sp, #20]
		explicit_bzero(ctx->intHashes[ctx->forLevel - 1], 32);
c0d04462:	5d78      	ldrb	r0, [r7, r5]
c0d04464:	0140      	lsls	r0, r0, #5
c0d04466:	19c0      	adds	r0, r0, r7
c0d04468:	9903      	ldr	r1, [sp, #12]
c0d0446a:	1840      	adds	r0, r0, r1
c0d0446c:	4621      	mov	r1, r4
c0d0446e:	f004 f861 	bl	c0d08534 <explicit_bzero>

		ctx->forLevel--;
c0d04472:	5d78      	ldrb	r0, [r7, r5]
c0d04474:	1e40      	subs	r0, r0, #1
c0d04476:	5578      	strb	r0, [r7, r5]
	respondSuccessEmptyMsg();
c0d04478:	f7ff f812 	bl	c0d034a0 <respondSuccessEmptyMsg>
	}

	signTx_handleEndFor_ui_runStep();
}
c0d0447c:	b007      	add	sp, #28
c0d0447e:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d04480:	20e1      	movs	r0, #225	; 0xe1
c0d04482:	0042      	lsls	r2, r0, #1
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d04484:	4827      	ldr	r0, [pc, #156]	; (c0d04524 <signTx_handleEndForAPDU+0x288>)
c0d04486:	4478      	add	r0, pc
c0d04488:	4927      	ldr	r1, [pc, #156]	; (c0d04528 <signTx_handleEndForAPDU+0x28c>)
c0d0448a:	4479      	add	r1, pc
c0d0448c:	f7fe fbda 	bl	c0d02c44 <mcu_usb_printf>
c0d04490:	480b      	ldr	r0, [pc, #44]	; (c0d044c0 <signTx_handleEndForAPDU+0x224>)
c0d04492:	f7fd fe7f 	bl	c0d02194 <os_longjmp>
c0d04496:	20e1      	movs	r0, #225	; 0xe1
c0d04498:	0040      	lsls	r0, r0, #1
		VALIDATE(ctx->forLevel > 0, ERR_CANT_END_FOR);
c0d0449a:	1d82      	adds	r2, r0, #6
c0d0449c:	e006      	b.n	c0d044ac <signTx_handleEndForAPDU+0x210>
c0d0449e:	20e1      	movs	r0, #225	; 0xe1
c0d044a0:	0042      	lsls	r2, r0, #1
		VALIDATE(
c0d044a2:	320a      	adds	r2, #10
c0d044a4:	e002      	b.n	c0d044ac <signTx_handleEndForAPDU+0x210>
c0d044a6:	20e1      	movs	r0, #225	; 0xe1
c0d044a8:	0042      	lsls	r2, r0, #1
		VALIDATE(
c0d044aa:	320e      	adds	r2, #14
c0d044ac:	480a      	ldr	r0, [pc, #40]	; (c0d044d8 <signTx_handleEndForAPDU+0x23c>)
c0d044ae:	4478      	add	r0, pc
c0d044b0:	490a      	ldr	r1, [pc, #40]	; (c0d044dc <signTx_handleEndForAPDU+0x240>)
c0d044b2:	4479      	add	r1, pc
c0d044b4:	f7fe fbc6 	bl	c0d02c44 <mcu_usb_printf>
c0d044b8:	4805      	ldr	r0, [pc, #20]	; (c0d044d0 <signTx_handleEndForAPDU+0x234>)
c0d044ba:	f7fd fe6b 	bl	c0d02194 <os_longjmp>
c0d044be:	46c0      	nop			; (mov r8, r8)
c0d044c0:	00006e05 	.word	0x00006e05
c0d044c4:	20000490 	.word	0x20000490
c0d044c8:	00003039 	.word	0x00003039
c0d044cc:	0000026b 	.word	0x0000026b
c0d044d0:	00004901 	.word	0x00004901
c0d044d4:	000051b3 	.word	0x000051b3
c0d044d8:	00004150 	.word	0x00004150
c0d044dc:	00004f09 	.word	0x00004f09
c0d044e0:	000052f7 	.word	0x000052f7
c0d044e4:	000046b1 	.word	0x000046b1
c0d044e8:	000052f9 	.word	0x000052f9
c0d044ec:	000046c4 	.word	0x000046c4
c0d044f0:	000051fc 	.word	0x000051fc
c0d044f4:	0000529b 	.word	0x0000529b
c0d044f8:	00004655 	.word	0x00004655
c0d044fc:	0000529d 	.word	0x0000529d
c0d04500:	0000465c 	.word	0x0000465c
c0d04504:	00005194 	.word	0x00005194
c0d04508:	00005237 	.word	0x00005237
c0d0450c:	000045f1 	.word	0x000045f1
c0d04510:	00005239 	.word	0x00005239
c0d04514:	000045fc 	.word	0x000045fc
c0d04518:	00005134 	.word	0x00005134
c0d0451c:	000051f8 	.word	0x000051f8
c0d04520:	000051fc 	.word	0x000051fc
c0d04524:	00004178 	.word	0x00004178
c0d04528:	00004f31 	.word	0x00004f31

c0d0452c <signTx_handleStartIterationAPDU>:

__noinline_due_to_stack__ void signTx_handleStartIterationAPDU(
	uint8_t p2,
	uint8_t *wireDataBuffer,
	size_t wireDataSize)
{
c0d0452c:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0452e:	b087      	sub	sp, #28
	{
		// sanity checks
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d04530:	2800      	cmp	r0, #0
c0d04532:	d000      	beq.n	c0d04536 <signTx_handleStartIterationAPDU+0xa>
c0d04534:	e0a6      	b.n	c0d04684 <signTx_handleStartIterationAPDU+0x158>
		ASSERT(wireDataSize < BUFFER_SIZE_PARANOIA);
c0d04536:	0a91      	lsrs	r1, r2, #10
c0d04538:	4248      	negs	r0, r1
c0d0453a:	4148      	adcs	r0, r1
c0d0453c:	4967      	ldr	r1, [pc, #412]	; (c0d046dc <signTx_handleStartIterationAPDU+0x1b0>)
c0d0453e:	4479      	add	r1, pc
c0d04540:	1c49      	adds	r1, r1, #1
c0d04542:	f7fb fd95 	bl	c0d00070 <assert>
c0d04546:	20e5      	movs	r0, #229	; 0xe5
c0d04548:	0041      	lsls	r1, r0, #1
	}

	{
		VALIDATE(ctx->forLevel > 0, ERR_NOT_IN_FOR);
c0d0454a:	4c61      	ldr	r4, [pc, #388]	; (c0d046d0 <signTx_handleStartIterationAPDU+0x1a4>)
c0d0454c:	5c60      	ldrb	r0, [r4, r1]
c0d0454e:	2800      	cmp	r0, #0
c0d04550:	d100      	bne.n	c0d04554 <signTx_handleStartIterationAPDU+0x28>
c0d04552:	e0a2      	b.n	c0d0469a <signTx_handleStartIterationAPDU+0x16e>
c0d04554:	9103      	str	r1, [sp, #12]
		// Can we start another iteration?
		VALIDATE(
c0d04556:	1820      	adds	r0, r4, r0
c0d04558:	2137      	movs	r1, #55	; 0x37
c0d0455a:	00ca      	lsls	r2, r1, #3
c0d0455c:	5c81      	ldrb	r1, [r0, r2]
c0d0455e:	2371      	movs	r3, #113	; 0x71
c0d04560:	009b      	lsls	r3, r3, #2
c0d04562:	5cc3      	ldrb	r3, [r0, r3]
c0d04564:	4299      	cmp	r1, r3
c0d04566:	d300      	bcc.n	c0d0456a <signTx_handleStartIterationAPDU+0x3e>
c0d04568:	e0a3      	b.n	c0d046b2 <signTx_handleStartIterationAPDU+0x186>
c0d0456a:	1880      	adds	r0, r0, r2
			ctx->forIterationsCnt[ctx->forLevel] < ctx->forMaxIterations[ctx->forLevel],
			ERR_UNEXPECTED_INS);

		ctx->forIterationsCnt[ctx->forLevel]++;
c0d0456c:	1c49      	adds	r1, r1, #1
c0d0456e:	7001      	strb	r1, [r0, #0]
c0d04570:	20d3      	movs	r0, #211	; 0xd3
c0d04572:	0100      	lsls	r0, r0, #4
c0d04574:	ae06      	add	r6, sp, #24

		uint8_t constants[] = {0x30, 0x0d};
c0d04576:	8030      	strh	r0, [r6, #0]
c0d04578:	9602      	str	r6, [sp, #8]
c0d0457a:	4620      	mov	r0, r4
c0d0457c:	3070      	adds	r0, #112	; 0x70
c0d0457e:	1d07      	adds	r7, r0, #4
c0d04580:	4638      	mov	r0, r7
c0d04582:	f7fb ff8d 	bl	c0d004a0 <cx_sha256_init_no_throw>
c0d04586:	2170      	movs	r1, #112	; 0x70
c0d04588:	4852      	ldr	r0, [pc, #328]	; (c0d046d4 <signTx_handleStartIterationAPDU+0x1a8>)
c0d0458a:	9104      	str	r1, [sp, #16]
	ctx->initialized_magic = HASH_CONTEXT_INITIALIZED_MAGIC;
c0d0458c:	5260      	strh	r0, [r4, r1]
c0d0458e:	2001      	movs	r0, #1
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04590:	4953      	ldr	r1, [pc, #332]	; (c0d046e0 <signTx_handleStartIterationAPDU+0x1b4>)
c0d04592:	4479      	add	r1, pc
c0d04594:	f7fb fd6c 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d04598:	4852      	ldr	r0, [pc, #328]	; (c0d046e4 <signTx_handleStartIterationAPDU+0x1b8>)
c0d0459a:	4478      	add	r0, pc
c0d0459c:	4952      	ldr	r1, [pc, #328]	; (c0d046e8 <signTx_handleStartIterationAPDU+0x1bc>)
c0d0459e:	4479      	add	r1, pc
c0d045a0:	2224      	movs	r2, #36	; 0x24
c0d045a2:	f7fe fb4f 	bl	c0d02c44 <mcu_usb_printf>
c0d045a6:	4851      	ldr	r0, [pc, #324]	; (c0d046ec <signTx_handleStartIterationAPDU+0x1c0>)
c0d045a8:	4478      	add	r0, pc
c0d045aa:	2502      	movs	r5, #2
c0d045ac:	4629      	mov	r1, r5
c0d045ae:	4632      	mov	r2, r6
c0d045b0:	f7fe fb48 	bl	c0d02c44 <mcu_usb_printf>
c0d045b4:	484e      	ldr	r0, [pc, #312]	; (c0d046f0 <signTx_handleStartIterationAPDU+0x1c4>)
c0d045b6:	4478      	add	r0, pc
c0d045b8:	f7fe fb44 	bl	c0d02c44 <mcu_usb_printf>
c0d045bc:	2600      	movs	r6, #0
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d045be:	9600      	str	r6, [sp, #0]
c0d045c0:	9601      	str	r6, [sp, #4]
c0d045c2:	9705      	str	r7, [sp, #20]
c0d045c4:	4638      	mov	r0, r7
c0d045c6:	4631      	mov	r1, r6
c0d045c8:	9a02      	ldr	r2, [sp, #8]
c0d045ca:	462b      	mov	r3, r5
c0d045cc:	f7fb ff50 	bl	c0d00470 <cx_hash_no_throw>
c0d045d0:	2800      	cmp	r0, #0
c0d045d2:	d179      	bne.n	c0d046c8 <signTx_handleStartIterationAPDU+0x19c>
  return cx_hash_get_size(hash);
c0d045d4:	9805      	ldr	r0, [sp, #20]
c0d045d6:	f7fb ff45 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d045da:	9804      	ldr	r0, [sp, #16]
c0d045dc:	5a20      	ldrh	r0, [r4, r0]
c0d045de:	493d      	ldr	r1, [pc, #244]	; (c0d046d4 <signTx_handleStartIterationAPDU+0x1a8>)
c0d045e0:	1a41      	subs	r1, r0, r1
c0d045e2:	4248      	negs	r0, r1
c0d045e4:	4148      	adcs	r0, r1
		sha_256_init(&ctx->integrityHashContext);
		sha_256_append(&ctx->integrityHashContext, constants, SIZEOF(constants));
		sha_256_append(&ctx->integrityHashContext, ctx->intHashes[ctx->forLevel], 32);
c0d045e6:	9903      	ldr	r1, [sp, #12]
c0d045e8:	5c65      	ldrb	r5, [r4, r1]
c0d045ea:	4942      	ldr	r1, [pc, #264]	; (c0d046f4 <signTx_handleStartIterationAPDU+0x1c8>)
c0d045ec:	4479      	add	r1, pc
c0d045ee:	f7fb fd3f 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d045f2:	4841      	ldr	r0, [pc, #260]	; (c0d046f8 <signTx_handleStartIterationAPDU+0x1cc>)
c0d045f4:	4478      	add	r0, pc
c0d045f6:	4941      	ldr	r1, [pc, #260]	; (c0d046fc <signTx_handleStartIterationAPDU+0x1d0>)
c0d045f8:	4479      	add	r1, pc
c0d045fa:	2224      	movs	r2, #36	; 0x24
c0d045fc:	f7fe fb22 	bl	c0d02c44 <mcu_usb_printf>
c0d04600:	0168      	lsls	r0, r5, #5
c0d04602:	1820      	adds	r0, r4, r0
c0d04604:	21ff      	movs	r1, #255	; 0xff
c0d04606:	31cc      	adds	r1, #204	; 0xcc
c0d04608:	1845      	adds	r5, r0, r1
c0d0460a:	483d      	ldr	r0, [pc, #244]	; (c0d04700 <signTx_handleStartIterationAPDU+0x1d4>)
c0d0460c:	4478      	add	r0, pc
c0d0460e:	2720      	movs	r7, #32
c0d04610:	4639      	mov	r1, r7
c0d04612:	462a      	mov	r2, r5
c0d04614:	f7fe fb16 	bl	c0d02c44 <mcu_usb_printf>
c0d04618:	483a      	ldr	r0, [pc, #232]	; (c0d04704 <signTx_handleStartIterationAPDU+0x1d8>)
c0d0461a:	4478      	add	r0, pc
c0d0461c:	f7fe fb12 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04620:	9600      	str	r6, [sp, #0]
c0d04622:	9601      	str	r6, [sp, #4]
c0d04624:	9805      	ldr	r0, [sp, #20]
c0d04626:	4631      	mov	r1, r6
c0d04628:	462a      	mov	r2, r5
c0d0462a:	463b      	mov	r3, r7
c0d0462c:	f7fb ff20 	bl	c0d00470 <cx_hash_no_throw>
c0d04630:	2800      	cmp	r0, #0
c0d04632:	d149      	bne.n	c0d046c8 <signTx_handleStartIterationAPDU+0x19c>
c0d04634:	9e05      	ldr	r6, [sp, #20]
  return cx_hash_get_size(hash);
c0d04636:	4630      	mov	r0, r6
c0d04638:	f7fb ff14 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d0463c:	9804      	ldr	r0, [sp, #16]
c0d0463e:	5a20      	ldrh	r0, [r4, r0]
c0d04640:	4924      	ldr	r1, [pc, #144]	; (c0d046d4 <signTx_handleStartIterationAPDU+0x1a8>)
c0d04642:	1a41      	subs	r1, r0, r1
c0d04644:	4248      	negs	r0, r1
c0d04646:	4148      	adcs	r0, r1
c0d04648:	492f      	ldr	r1, [pc, #188]	; (c0d04708 <signTx_handleStartIterationAPDU+0x1dc>)
c0d0464a:	4479      	add	r1, pc
c0d0464c:	f7fb fd10 	bl	c0d00070 <assert>
c0d04650:	2501      	movs	r5, #1
	ASSERT(outSize == SHA_256_SIZE);
c0d04652:	492e      	ldr	r1, [pc, #184]	; (c0d0470c <signTx_handleStartIterationAPDU+0x1e0>)
c0d04654:	4479      	add	r1, pc
c0d04656:	4628      	mov	r0, r5
c0d04658:	f7fb fd0a 	bl	c0d00070 <assert>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d0465c:	4620      	mov	r0, r4
c0d0465e:	30e0      	adds	r0, #224	; 0xe0
c0d04660:	9000      	str	r0, [sp, #0]
c0d04662:	9701      	str	r7, [sp, #4]
c0d04664:	2200      	movs	r2, #0
c0d04666:	4630      	mov	r0, r6
c0d04668:	4629      	mov	r1, r5
c0d0466a:	4613      	mov	r3, r2
c0d0466c:	f7fb ff00 	bl	c0d00470 <cx_hash_no_throw>
c0d04670:	2800      	cmp	r0, #0
c0d04672:	d129      	bne.n	c0d046c8 <signTx_handleStartIterationAPDU+0x19c>
  return cx_hash_get_size(hash);
c0d04674:	3474      	adds	r4, #116	; 0x74
c0d04676:	4620      	mov	r0, r4
c0d04678:	f7fb fef4 	bl	c0d00464 <cx_hash_get_size>
	respondSuccessEmptyMsg();
c0d0467c:	f7fe ff10 	bl	c0d034a0 <respondSuccessEmptyMsg>
		sha_256_finalize(&ctx->integrityHashContext, ctx->prevHash, 32);
	}

	signTx_handleStartIteration_ui_runStep();
}
c0d04680:	b007      	add	sp, #28
c0d04682:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d04684:	20f9      	movs	r0, #249	; 0xf9
c0d04686:	0042      	lsls	r2, r0, #1
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d04688:	4821      	ldr	r0, [pc, #132]	; (c0d04710 <signTx_handleStartIterationAPDU+0x1e4>)
c0d0468a:	4478      	add	r0, pc
c0d0468c:	4921      	ldr	r1, [pc, #132]	; (c0d04714 <signTx_handleStartIterationAPDU+0x1e8>)
c0d0468e:	4479      	add	r1, pc
c0d04690:	f7fe fad8 	bl	c0d02c44 <mcu_usb_printf>
c0d04694:	480d      	ldr	r0, [pc, #52]	; (c0d046cc <signTx_handleStartIterationAPDU+0x1a0>)
c0d04696:	f7fd fd7d 	bl	c0d02194 <os_longjmp>
c0d0469a:	20f9      	movs	r0, #249	; 0xf9
c0d0469c:	0040      	lsls	r0, r0, #1
		VALIDATE(ctx->forLevel > 0, ERR_NOT_IN_FOR);
c0d0469e:	1d42      	adds	r2, r0, #5
c0d046a0:	481d      	ldr	r0, [pc, #116]	; (c0d04718 <signTx_handleStartIterationAPDU+0x1ec>)
c0d046a2:	4478      	add	r0, pc
c0d046a4:	491d      	ldr	r1, [pc, #116]	; (c0d0471c <signTx_handleStartIterationAPDU+0x1f0>)
c0d046a6:	4479      	add	r1, pc
c0d046a8:	f7fe facc 	bl	c0d02c44 <mcu_usb_printf>
c0d046ac:	480a      	ldr	r0, [pc, #40]	; (c0d046d8 <signTx_handleStartIterationAPDU+0x1ac>)
c0d046ae:	f7fd fd71 	bl	c0d02194 <os_longjmp>
c0d046b2:	20f9      	movs	r0, #249	; 0xf9
c0d046b4:	0042      	lsls	r2, r0, #1
		VALIDATE(
c0d046b6:	3209      	adds	r2, #9
c0d046b8:	4819      	ldr	r0, [pc, #100]	; (c0d04720 <signTx_handleStartIterationAPDU+0x1f4>)
c0d046ba:	4478      	add	r0, pc
c0d046bc:	4919      	ldr	r1, [pc, #100]	; (c0d04724 <signTx_handleStartIterationAPDU+0x1f8>)
c0d046be:	4479      	add	r1, pc
c0d046c0:	f7fe fac0 	bl	c0d02c44 <mcu_usb_printf>
c0d046c4:	2005      	movs	r0, #5
c0d046c6:	0300      	lsls	r0, r0, #12
c0d046c8:	f7fd fd64 	bl	c0d02194 <os_longjmp>
c0d046cc:	00006e05 	.word	0x00006e05
c0d046d0:	20000490 	.word	0x20000490
c0d046d4:	00003039 	.word	0x00003039
c0d046d8:	00004902 	.word	0x00004902
c0d046dc:	00004f3d 	.word	0x00004f3d
c0d046e0:	0000506b 	.word	0x0000506b
c0d046e4:	00004425 	.word	0x00004425
c0d046e8:	0000506d 	.word	0x0000506d
c0d046ec:	00004438 	.word	0x00004438
c0d046f0:	00004f70 	.word	0x00004f70
c0d046f4:	00005011 	.word	0x00005011
c0d046f8:	000043cb 	.word	0x000043cb
c0d046fc:	00005013 	.word	0x00005013
c0d04700:	000043d4 	.word	0x000043d4
c0d04704:	00004f0c 	.word	0x00004f0c
c0d04708:	00004fd0 	.word	0x00004fd0
c0d0470c:	00004fd4 	.word	0x00004fd4
c0d04710:	00003f74 	.word	0x00003f74
c0d04714:	00004d2d 	.word	0x00004d2d
c0d04718:	00003f5c 	.word	0x00003f5c
c0d0471c:	00004d15 	.word	0x00004d15
c0d04720:	00003f44 	.word	0x00003f44
c0d04724:	00004cfd 	.word	0x00004cfd

c0d04728 <signTx_handleEndIterationAPDU>:

__noinline_due_to_stack__ void signTx_handleEndIterationAPDU(
	uint8_t p2,
	uint8_t *wireDataBuffer,
	size_t wireDataSize)
{
c0d04728:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0472a:	b091      	sub	sp, #68	; 0x44
	{
		// sanity checks
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d0472c:	2800      	cmp	r0, #0
c0d0472e:	d000      	beq.n	c0d04732 <signTx_handleEndIterationAPDU+0xa>
c0d04730:	e14d      	b.n	c0d049ce <signTx_handleEndIterationAPDU+0x2a6>
c0d04732:	460c      	mov	r4, r1
		ASSERT(wireDataSize < BUFFER_SIZE_PARANOIA);
c0d04734:	0a91      	lsrs	r1, r2, #10
c0d04736:	4248      	negs	r0, r1
c0d04738:	4148      	adcs	r0, r1
c0d0473a:	49af      	ldr	r1, [pc, #700]	; (c0d049f8 <signTx_handleEndIterationAPDU+0x2d0>)
c0d0473c:	4479      	add	r1, pc
c0d0473e:	1c49      	adds	r1, r1, #1
c0d04740:	f7fb fc96 	bl	c0d00070 <assert>
		{
			uint8_t numAllowedHashes[1];
			uint8_t allowedIterationHashes[32 * MAX_NUM_ALLOWED_ITER_HASHES];
		} *wireData = (void *)wireDataBuffer;

		VALIDATE(
c0d04744:	7820      	ldrb	r0, [r4, #0]
c0d04746:	2807      	cmp	r0, #7
c0d04748:	d300      	bcc.n	c0d0474c <signTx_handleEndIterationAPDU+0x24>
c0d0474a:	e14a      	b.n	c0d049e2 <signTx_handleEndIterationAPDU+0x2ba>
			wireData->numAllowedHashes[0] <= MAX_NUM_ALLOWED_ITER_HASHES,
			ERR_INVALID_DATA);
		wireData->allowedIterationHashes[wireData->numAllowedHashes[0] * 32] = 0; // zero terminate them
c0d0474c:	0140      	lsls	r0, r0, #5
c0d0474e:	9407      	str	r4, [sp, #28]
c0d04750:	1c61      	adds	r1, r4, #1
c0d04752:	2500      	movs	r5, #0
c0d04754:	9104      	str	r1, [sp, #16]
c0d04756:	540d      	strb	r5, [r1, r0]
c0d04758:	20e3      	movs	r0, #227	; 0xe3
c0d0475a:	0100      	lsls	r0, r0, #4
c0d0475c:	ac10      	add	r4, sp, #64	; 0x40

		uint8_t constants[] = {0x30, 0x0e};
c0d0475e:	8020      	strh	r0, [r4, #0]
c0d04760:	4fa3      	ldr	r7, [pc, #652]	; (c0d049f0 <signTx_handleEndIterationAPDU+0x2c8>)
c0d04762:	4638      	mov	r0, r7
c0d04764:	3070      	adds	r0, #112	; 0x70
c0d04766:	1d06      	adds	r6, r0, #4
c0d04768:	4630      	mov	r0, r6
c0d0476a:	f7fb fe99 	bl	c0d004a0 <cx_sha256_init_no_throw>
c0d0476e:	2170      	movs	r1, #112	; 0x70
c0d04770:	48a0      	ldr	r0, [pc, #640]	; (c0d049f4 <signTx_handleEndIterationAPDU+0x2cc>)
c0d04772:	9106      	str	r1, [sp, #24]
	ctx->initialized_magic = HASH_CONTEXT_INITIALIZED_MAGIC;
c0d04774:	5278      	strh	r0, [r7, r1]
c0d04776:	2001      	movs	r0, #1
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04778:	49a0      	ldr	r1, [pc, #640]	; (c0d049fc <signTx_handleEndIterationAPDU+0x2d4>)
c0d0477a:	4479      	add	r1, pc
c0d0477c:	f7fb fc78 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d04780:	489f      	ldr	r0, [pc, #636]	; (c0d04a00 <signTx_handleEndIterationAPDU+0x2d8>)
c0d04782:	4478      	add	r0, pc
c0d04784:	499f      	ldr	r1, [pc, #636]	; (c0d04a04 <signTx_handleEndIterationAPDU+0x2dc>)
c0d04786:	4479      	add	r1, pc
c0d04788:	2224      	movs	r2, #36	; 0x24
c0d0478a:	f7fe fa5b 	bl	c0d02c44 <mcu_usb_printf>
c0d0478e:	489e      	ldr	r0, [pc, #632]	; (c0d04a08 <signTx_handleEndIterationAPDU+0x2e0>)
c0d04790:	4478      	add	r0, pc
c0d04792:	2702      	movs	r7, #2
c0d04794:	4639      	mov	r1, r7
c0d04796:	4622      	mov	r2, r4
c0d04798:	f7fe fa54 	bl	c0d02c44 <mcu_usb_printf>
c0d0479c:	489b      	ldr	r0, [pc, #620]	; (c0d04a0c <signTx_handleEndIterationAPDU+0x2e4>)
c0d0479e:	4478      	add	r0, pc
c0d047a0:	f7fe fa50 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d047a4:	9500      	str	r5, [sp, #0]
c0d047a6:	9501      	str	r5, [sp, #4]
c0d047a8:	9605      	str	r6, [sp, #20]
c0d047aa:	4630      	mov	r0, r6
c0d047ac:	4629      	mov	r1, r5
c0d047ae:	4622      	mov	r2, r4
c0d047b0:	463b      	mov	r3, r7
c0d047b2:	f7fb fe5d 	bl	c0d00470 <cx_hash_no_throw>
c0d047b6:	2800      	cmp	r0, #0
c0d047b8:	d000      	beq.n	c0d047bc <signTx_handleEndIterationAPDU+0x94>
c0d047ba:	e110      	b.n	c0d049de <signTx_handleEndIterationAPDU+0x2b6>
c0d047bc:	9e05      	ldr	r6, [sp, #20]
  return cx_hash_get_size(hash);
c0d047be:	4630      	mov	r0, r6
c0d047c0:	f7fb fe50 	bl	c0d00464 <cx_hash_get_size>
c0d047c4:	4f8a      	ldr	r7, [pc, #552]	; (c0d049f0 <signTx_handleEndIterationAPDU+0x2c8>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d047c6:	9806      	ldr	r0, [sp, #24]
c0d047c8:	5a38      	ldrh	r0, [r7, r0]
c0d047ca:	498a      	ldr	r1, [pc, #552]	; (c0d049f4 <signTx_handleEndIterationAPDU+0x2cc>)
c0d047cc:	1a41      	subs	r1, r0, r1
c0d047ce:	4248      	negs	r0, r1
c0d047d0:	4148      	adcs	r0, r1
c0d047d2:	498f      	ldr	r1, [pc, #572]	; (c0d04a10 <signTx_handleEndIterationAPDU+0x2e8>)
c0d047d4:	4479      	add	r1, pc
c0d047d6:	f7fb fc4b 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d047da:	488e      	ldr	r0, [pc, #568]	; (c0d04a14 <signTx_handleEndIterationAPDU+0x2ec>)
c0d047dc:	4478      	add	r0, pc
c0d047de:	498e      	ldr	r1, [pc, #568]	; (c0d04a18 <signTx_handleEndIterationAPDU+0x2f0>)
c0d047e0:	4479      	add	r1, pc
c0d047e2:	2224      	movs	r2, #36	; 0x24
c0d047e4:	f7fe fa2e 	bl	c0d02c44 <mcu_usb_printf>
c0d047e8:	37e0      	adds	r7, #224	; 0xe0
c0d047ea:	488c      	ldr	r0, [pc, #560]	; (c0d04a1c <signTx_handleEndIterationAPDU+0x2f4>)
c0d047ec:	4478      	add	r0, pc
c0d047ee:	2420      	movs	r4, #32
c0d047f0:	4621      	mov	r1, r4
c0d047f2:	463a      	mov	r2, r7
c0d047f4:	f7fe fa26 	bl	c0d02c44 <mcu_usb_printf>
c0d047f8:	4889      	ldr	r0, [pc, #548]	; (c0d04a20 <signTx_handleEndIterationAPDU+0x2f8>)
c0d047fa:	4478      	add	r0, pc
c0d047fc:	f7fe fa22 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04800:	9500      	str	r5, [sp, #0]
c0d04802:	9501      	str	r5, [sp, #4]
c0d04804:	4630      	mov	r0, r6
c0d04806:	4629      	mov	r1, r5
c0d04808:	463a      	mov	r2, r7
c0d0480a:	4623      	mov	r3, r4
c0d0480c:	f7fb fe30 	bl	c0d00470 <cx_hash_no_throw>
c0d04810:	2800      	cmp	r0, #0
c0d04812:	d000      	beq.n	c0d04816 <signTx_handleEndIterationAPDU+0xee>
c0d04814:	e0e3      	b.n	c0d049de <signTx_handleEndIterationAPDU+0x2b6>
c0d04816:	9f05      	ldr	r7, [sp, #20]
  return cx_hash_get_size(hash);
c0d04818:	4638      	mov	r0, r7
c0d0481a:	f7fb fe23 	bl	c0d00464 <cx_hash_get_size>
c0d0481e:	4d74      	ldr	r5, [pc, #464]	; (c0d049f0 <signTx_handleEndIterationAPDU+0x2c8>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04820:	9806      	ldr	r0, [sp, #24]
c0d04822:	5a28      	ldrh	r0, [r5, r0]
c0d04824:	4973      	ldr	r1, [pc, #460]	; (c0d049f4 <signTx_handleEndIterationAPDU+0x2cc>)
c0d04826:	1a41      	subs	r1, r0, r1
c0d04828:	4248      	negs	r0, r1
c0d0482a:	4148      	adcs	r0, r1
c0d0482c:	497d      	ldr	r1, [pc, #500]	; (c0d04a24 <signTx_handleEndIterationAPDU+0x2fc>)
c0d0482e:	4479      	add	r1, pc
c0d04830:	f7fb fc1e 	bl	c0d00070 <assert>
c0d04834:	2601      	movs	r6, #1
	ASSERT(outSize == SHA_256_SIZE);
c0d04836:	497c      	ldr	r1, [pc, #496]	; (c0d04a28 <signTx_handleEndIterationAPDU+0x300>)
c0d04838:	4479      	add	r1, pc
c0d0483a:	4630      	mov	r0, r6
c0d0483c:	f7fb fc18 	bl	c0d00070 <assert>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04840:	9401      	str	r4, [sp, #4]
c0d04842:	a808      	add	r0, sp, #32
c0d04844:	9000      	str	r0, [sp, #0]
c0d04846:	2400      	movs	r4, #0
c0d04848:	4638      	mov	r0, r7
c0d0484a:	4631      	mov	r1, r6
c0d0484c:	4622      	mov	r2, r4
c0d0484e:	4623      	mov	r3, r4
c0d04850:	f7fb fe0e 	bl	c0d00470 <cx_hash_no_throw>
c0d04854:	2800      	cmp	r0, #0
c0d04856:	d000      	beq.n	c0d0485a <signTx_handleEndIterationAPDU+0x132>
c0d04858:	e0c1      	b.n	c0d049de <signTx_handleEndIterationAPDU+0x2b6>
  return cx_hash_get_size(hash);
c0d0485a:	4628      	mov	r0, r5
c0d0485c:	3074      	adds	r0, #116	; 0x74
c0d0485e:	9003      	str	r0, [sp, #12]
c0d04860:	f7fb fe00 	bl	c0d00464 <cx_hash_get_size>
c0d04864:	4a60      	ldr	r2, [pc, #384]	; (c0d049e8 <signTx_handleEndIterationAPDU+0x2c0>)

		// Finalize iteration integrity hash
		uint8_t tmpHashBuf[32];
		sha_256_finalize(&ctx->integrityHashContext, tmpHashBuf, 32);

		TRACE("Iteration integrity hash:");
c0d04866:	3219      	adds	r2, #25
c0d04868:	4f70      	ldr	r7, [pc, #448]	; (c0d04a2c <signTx_handleEndIterationAPDU+0x304>)
c0d0486a:	447f      	add	r7, pc
c0d0486c:	4d70      	ldr	r5, [pc, #448]	; (c0d04a30 <signTx_handleEndIterationAPDU+0x308>)
c0d0486e:	447d      	add	r5, pc
c0d04870:	4638      	mov	r0, r7
c0d04872:	4629      	mov	r1, r5
c0d04874:	f7fe f9e6 	bl	c0d02c44 <mcu_usb_printf>
c0d04878:	486e      	ldr	r0, [pc, #440]	; (c0d04a34 <signTx_handleEndIterationAPDU+0x30c>)
c0d0487a:	4478      	add	r0, pc
c0d0487c:	f7fe f9e2 	bl	c0d02c44 <mcu_usb_printf>
c0d04880:	486d      	ldr	r0, [pc, #436]	; (c0d04a38 <signTx_handleEndIterationAPDU+0x310>)
c0d04882:	4478      	add	r0, pc
c0d04884:	9002      	str	r0, [sp, #8]
c0d04886:	f7fe f9dd 	bl	c0d02c44 <mcu_usb_printf>
		TRACE_BUFFER(tmpHashBuf, SIZEOF(tmpHashBuf));
c0d0488a:	4a57      	ldr	r2, [pc, #348]	; (c0d049e8 <signTx_handleEndIterationAPDU+0x2c0>)
c0d0488c:	321a      	adds	r2, #26
c0d0488e:	4638      	mov	r0, r7
c0d04890:	4629      	mov	r1, r5
c0d04892:	f7fe f9d7 	bl	c0d02c44 <mcu_usb_printf>
c0d04896:	4869      	ldr	r0, [pc, #420]	; (c0d04a3c <signTx_handleEndIterationAPDU+0x314>)
c0d04898:	4478      	add	r0, pc
c0d0489a:	2720      	movs	r7, #32
c0d0489c:	aa08      	add	r2, sp, #32
c0d0489e:	4639      	mov	r1, r7
c0d048a0:	f7fe f9d0 	bl	c0d02c44 <mcu_usb_printf>
c0d048a4:	9802      	ldr	r0, [sp, #8]
c0d048a6:	f7fe f9cd 	bl	c0d02c44 <mcu_usb_printf>

		// Check whether iteration integrity hash is from the list of allowed iteration hashes
		uint8_t iterationIsValid = 0;
		for (uint8_t i = 0; i < wireData->numAllowedHashes[0]; i++)
c0d048aa:	9807      	ldr	r0, [sp, #28]
c0d048ac:	7800      	ldrb	r0, [r0, #0]
c0d048ae:	2800      	cmp	r0, #0
c0d048b0:	d100      	bne.n	c0d048b4 <signTx_handleEndIterationAPDU+0x18c>
c0d048b2:	e080      	b.n	c0d049b6 <signTx_handleEndIterationAPDU+0x28e>
c0d048b4:	a908      	add	r1, sp, #32
c0d048b6:	7809      	ldrb	r1, [r1, #0]
c0d048b8:	4632      	mov	r2, r6
c0d048ba:	4623      	mov	r3, r4
		{
			uint8_t matches = 1;
			for (uint8_t j = 0; j < 32; j++)
			{
				if (wireData->allowedIterationHashes[i * 32 + j] != tmpHashBuf[j])
c0d048bc:	9d07      	ldr	r5, [sp, #28]
c0d048be:	5cad      	ldrb	r5, [r5, r2]
c0d048c0:	428d      	cmp	r5, r1
c0d048c2:	4635      	mov	r5, r6
c0d048c4:	d000      	beq.n	c0d048c8 <signTx_handleEndIterationAPDU+0x1a0>
c0d048c6:	461d      	mov	r5, r3
		for (uint8_t i = 0; i < wireData->numAllowedHashes[0]; i++)
c0d048c8:	3220      	adds	r2, #32
c0d048ca:	1c64      	adds	r4, r4, #1
c0d048cc:	4284      	cmp	r4, r0
c0d048ce:	462b      	mov	r3, r5
c0d048d0:	d3f4      	bcc.n	c0d048bc <signTx_handleEndIterationAPDU+0x194>
					iterationIsValid = 1;
					break;
				}
			}
		}
		VALIDATE(iterationIsValid, ERR_INVALID_ITERATION);
c0d048d2:	2d00      	cmp	r5, #0
c0d048d4:	d06f      	beq.n	c0d049b6 <signTx_handleEndIterationAPDU+0x28e>
c0d048d6:	9e05      	ldr	r6, [sp, #20]
c0d048d8:	4630      	mov	r0, r6
c0d048da:	f7fb fde1 	bl	c0d004a0 <cx_sha256_init_no_throw>
c0d048de:	4d44      	ldr	r5, [pc, #272]	; (c0d049f0 <signTx_handleEndIterationAPDU+0x2c8>)
c0d048e0:	4844      	ldr	r0, [pc, #272]	; (c0d049f4 <signTx_handleEndIterationAPDU+0x2cc>)
	ctx->initialized_magic = HASH_CONTEXT_INITIALIZED_MAGIC;
c0d048e2:	9906      	ldr	r1, [sp, #24]
c0d048e4:	5268      	strh	r0, [r5, r1]
		// is the same as the one from startFor
		sha_256_init(&ctx->integrityHashContext);
		sha_256_append(
			&ctx->integrityHashContext,
			wireData->allowedIterationHashes,
			wireData->numAllowedHashes[0] * 32);
c0d048e6:	9807      	ldr	r0, [sp, #28]
c0d048e8:	7804      	ldrb	r4, [r0, #0]
c0d048ea:	2001      	movs	r0, #1
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d048ec:	4954      	ldr	r1, [pc, #336]	; (c0d04a40 <signTx_handleEndIterationAPDU+0x318>)
c0d048ee:	4479      	add	r1, pc
c0d048f0:	f7fb fbbe 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d048f4:	4853      	ldr	r0, [pc, #332]	; (c0d04a44 <signTx_handleEndIterationAPDU+0x31c>)
c0d048f6:	4478      	add	r0, pc
c0d048f8:	4953      	ldr	r1, [pc, #332]	; (c0d04a48 <signTx_handleEndIterationAPDU+0x320>)
c0d048fa:	4479      	add	r1, pc
c0d048fc:	2224      	movs	r2, #36	; 0x24
c0d048fe:	f7fe f9a1 	bl	c0d02c44 <mcu_usb_printf>
c0d04902:	0164      	lsls	r4, r4, #5
c0d04904:	4851      	ldr	r0, [pc, #324]	; (c0d04a4c <signTx_handleEndIterationAPDU+0x324>)
c0d04906:	4478      	add	r0, pc
c0d04908:	4621      	mov	r1, r4
c0d0490a:	9d04      	ldr	r5, [sp, #16]
c0d0490c:	462a      	mov	r2, r5
c0d0490e:	f7fe f999 	bl	c0d02c44 <mcu_usb_printf>
c0d04912:	484f      	ldr	r0, [pc, #316]	; (c0d04a50 <signTx_handleEndIterationAPDU+0x328>)
c0d04914:	4478      	add	r0, pc
c0d04916:	f7fe f995 	bl	c0d02c44 <mcu_usb_printf>
c0d0491a:	2100      	movs	r1, #0
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d0491c:	9100      	str	r1, [sp, #0]
c0d0491e:	9101      	str	r1, [sp, #4]
c0d04920:	4630      	mov	r0, r6
c0d04922:	462a      	mov	r2, r5
c0d04924:	4623      	mov	r3, r4
c0d04926:	f7fb fda3 	bl	c0d00470 <cx_hash_no_throw>
c0d0492a:	2800      	cmp	r0, #0
c0d0492c:	d157      	bne.n	c0d049de <signTx_handleEndIterationAPDU+0x2b6>
  return cx_hash_get_size(hash);
c0d0492e:	4630      	mov	r0, r6
c0d04930:	f7fb fd98 	bl	c0d00464 <cx_hash_get_size>
c0d04934:	4d2e      	ldr	r5, [pc, #184]	; (c0d049f0 <signTx_handleEndIterationAPDU+0x2c8>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04936:	9806      	ldr	r0, [sp, #24]
c0d04938:	5a28      	ldrh	r0, [r5, r0]
c0d0493a:	492e      	ldr	r1, [pc, #184]	; (c0d049f4 <signTx_handleEndIterationAPDU+0x2cc>)
c0d0493c:	1a41      	subs	r1, r0, r1
c0d0493e:	4248      	negs	r0, r1
c0d04940:	4148      	adcs	r0, r1
c0d04942:	4944      	ldr	r1, [pc, #272]	; (c0d04a54 <signTx_handleEndIterationAPDU+0x32c>)
c0d04944:	4479      	add	r1, pc
c0d04946:	f7fb fb93 	bl	c0d00070 <assert>
c0d0494a:	2401      	movs	r4, #1
	ASSERT(outSize == SHA_256_SIZE);
c0d0494c:	4942      	ldr	r1, [pc, #264]	; (c0d04a58 <signTx_handleEndIterationAPDU+0x330>)
c0d0494e:	4479      	add	r1, pc
c0d04950:	4620      	mov	r0, r4
c0d04952:	f7fb fb8d 	bl	c0d00070 <assert>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04956:	9701      	str	r7, [sp, #4]
c0d04958:	a808      	add	r0, sp, #32
c0d0495a:	9000      	str	r0, [sp, #0]
c0d0495c:	2200      	movs	r2, #0
c0d0495e:	4630      	mov	r0, r6
c0d04960:	4621      	mov	r1, r4
c0d04962:	4613      	mov	r3, r2
c0d04964:	f7fb fd84 	bl	c0d00470 <cx_hash_no_throw>
c0d04968:	2800      	cmp	r0, #0
c0d0496a:	d138      	bne.n	c0d049de <signTx_handleEndIterationAPDU+0x2b6>
  return cx_hash_get_size(hash);
c0d0496c:	9803      	ldr	r0, [sp, #12]
c0d0496e:	f7fb fd79 	bl	c0d00464 <cx_hash_get_size>
c0d04972:	20e5      	movs	r0, #229	; 0xe5
c0d04974:	0040      	lsls	r0, r0, #1
c0d04976:	5c28      	ldrb	r0, [r5, r0]
		sha_256_finalize(&ctx->integrityHashContext, tmpHashBuf, 32);
		uint8_t allowedHashesListValid = 1;
		for (uint8_t i = 0; i < 32; i++)
c0d04978:	0140      	lsls	r0, r0, #5
c0d0497a:	4a1b      	ldr	r2, [pc, #108]	; (c0d049e8 <signTx_handleEndIterationAPDU+0x2c0>)
c0d0497c:	1810      	adds	r0, r2, r0
c0d0497e:	1940      	adds	r0, r0, r5
c0d04980:	3055      	adds	r0, #85	; 0x55
c0d04982:	211f      	movs	r1, #31
c0d04984:	43c9      	mvns	r1, r1
		{
			if (tmpHashBuf[i] != ctx->allowedIterationHashesHash[ctx->forLevel][i])
c0d04986:	1843      	adds	r3, r0, r1
c0d04988:	5ddc      	ldrb	r4, [r3, r7]
c0d0498a:	ab08      	add	r3, sp, #32
c0d0498c:	185b      	adds	r3, r3, r1
c0d0498e:	5ddb      	ldrb	r3, [r3, r7]
c0d04990:	42a3      	cmp	r3, r4
c0d04992:	d105      	bne.n	c0d049a0 <signTx_handleEndIterationAPDU+0x278>
		for (uint8_t i = 0; i < 32; i++)
c0d04994:	1c49      	adds	r1, r1, #1
c0d04996:	d3f6      	bcc.n	c0d04986 <signTx_handleEndIterationAPDU+0x25e>
	respondSuccessEmptyMsg();
c0d04998:	f7fe fd82 	bl	c0d034a0 <respondSuccessEmptyMsg>

		// Number of remaining iterations is decreased in startFor, not here
	}

	signTx_handleEndIteration_ui_runStep();
}
c0d0499c:	b011      	add	sp, #68	; 0x44
c0d0499e:	bdf0      	pop	{r4, r5, r6, r7, pc}
		VALIDATE(allowedHashesListValid, ERR_INVALID_DATA);
c0d049a0:	3242      	adds	r2, #66	; 0x42
c0d049a2:	482e      	ldr	r0, [pc, #184]	; (c0d04a5c <signTx_handleEndIterationAPDU+0x334>)
c0d049a4:	4478      	add	r0, pc
c0d049a6:	492e      	ldr	r1, [pc, #184]	; (c0d04a60 <signTx_handleEndIterationAPDU+0x338>)
c0d049a8:	4479      	add	r1, pc
c0d049aa:	f7fe f94b 	bl	c0d02c44 <mcu_usb_printf>
c0d049ae:	480f      	ldr	r0, [pc, #60]	; (c0d049ec <signTx_handleEndIterationAPDU+0x2c4>)
c0d049b0:	1c80      	adds	r0, r0, #2
c0d049b2:	f7fd fbef 	bl	c0d02194 <os_longjmp>
c0d049b6:	4a0c      	ldr	r2, [pc, #48]	; (c0d049e8 <signTx_handleEndIterationAPDU+0x2c0>)
		VALIDATE(iterationIsValid, ERR_INVALID_ITERATION);
c0d049b8:	322f      	adds	r2, #47	; 0x2f
c0d049ba:	482c      	ldr	r0, [pc, #176]	; (c0d04a6c <signTx_handleEndIterationAPDU+0x344>)
c0d049bc:	4478      	add	r0, pc
c0d049be:	492c      	ldr	r1, [pc, #176]	; (c0d04a70 <signTx_handleEndIterationAPDU+0x348>)
c0d049c0:	4479      	add	r1, pc
c0d049c2:	f7fe f93f 	bl	c0d02c44 <mcu_usb_printf>
c0d049c6:	2051      	movs	r0, #81	; 0x51
c0d049c8:	0200      	lsls	r0, r0, #8
c0d049ca:	f7fd fbe3 	bl	c0d02194 <os_longjmp>
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d049ce:	4825      	ldr	r0, [pc, #148]	; (c0d04a64 <signTx_handleEndIterationAPDU+0x33c>)
c0d049d0:	4478      	add	r0, pc
c0d049d2:	4925      	ldr	r1, [pc, #148]	; (c0d04a68 <signTx_handleEndIterationAPDU+0x340>)
c0d049d4:	4479      	add	r1, pc
c0d049d6:	4a04      	ldr	r2, [pc, #16]	; (c0d049e8 <signTx_handleEndIterationAPDU+0x2c0>)
c0d049d8:	f7fe f934 	bl	c0d02c44 <mcu_usb_printf>
c0d049dc:	4803      	ldr	r0, [pc, #12]	; (c0d049ec <signTx_handleEndIterationAPDU+0x2c4>)
c0d049de:	f7fd fbd9 	bl	c0d02194 <os_longjmp>
c0d049e2:	4a01      	ldr	r2, [pc, #4]	; (c0d049e8 <signTx_handleEndIterationAPDU+0x2c0>)
		VALIDATE(
c0d049e4:	320d      	adds	r2, #13
c0d049e6:	e7dc      	b.n	c0d049a2 <signTx_handleEndIterationAPDU+0x27a>
c0d049e8:	00000216 	.word	0x00000216
c0d049ec:	00006e05 	.word	0x00006e05
c0d049f0:	20000490 	.word	0x20000490
c0d049f4:	00003039 	.word	0x00003039
c0d049f8:	00004d59 	.word	0x00004d59
c0d049fc:	00004e83 	.word	0x00004e83
c0d04a00:	0000423d 	.word	0x0000423d
c0d04a04:	00004e85 	.word	0x00004e85
c0d04a08:	00004250 	.word	0x00004250
c0d04a0c:	00004d88 	.word	0x00004d88
c0d04a10:	00004e29 	.word	0x00004e29
c0d04a14:	000041e3 	.word	0x000041e3
c0d04a18:	00004e2b 	.word	0x00004e2b
c0d04a1c:	000041f4 	.word	0x000041f4
c0d04a20:	00004d2c 	.word	0x00004d2c
c0d04a24:	00004dec 	.word	0x00004dec
c0d04a28:	00004df0 	.word	0x00004df0
c0d04a2c:	00004155 	.word	0x00004155
c0d04a30:	00004c41 	.word	0x00004c41
c0d04a34:	00004c53 	.word	0x00004c53
c0d04a38:	00004ca4 	.word	0x00004ca4
c0d04a3c:	00004148 	.word	0x00004148
c0d04a40:	00004d0f 	.word	0x00004d0f
c0d04a44:	000040c9 	.word	0x000040c9
c0d04a48:	00004d11 	.word	0x00004d11
c0d04a4c:	000040da 	.word	0x000040da
c0d04a50:	00004c12 	.word	0x00004c12
c0d04a54:	00004cd6 	.word	0x00004cd6
c0d04a58:	00004cda 	.word	0x00004cda
c0d04a5c:	00003c5a 	.word	0x00003c5a
c0d04a60:	00004a13 	.word	0x00004a13
c0d04a64:	00003c2e 	.word	0x00003c2e
c0d04a68:	000049e7 	.word	0x000049e7
c0d04a6c:	00003c42 	.word	0x00003c42
c0d04a70:	000049fb 	.word	0x000049fb

c0d04a74 <signTx_handleEndAPDU>:

__noinline_due_to_stack__ void signTx_handleEndAPDU(
	uint8_t p2,
	uint8_t *wireDataBuffer,
	size_t wireDataSize)
{
c0d04a74:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d04a76:	b0cf      	sub	sp, #316	; 0x13c
	{
		// sanity checks
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d04a78:	2800      	cmp	r0, #0
c0d04a7a:	d000      	beq.n	c0d04a7e <signTx_handleEndAPDU+0xa>
c0d04a7c:	e30b      	b.n	c0d05096 <signTx_handleEndAPDU+0x622>
c0d04a7e:	4614      	mov	r4, r2
c0d04a80:	460d      	mov	r5, r1
		ASSERT(wireDataSize < BUFFER_SIZE_PARANOIA);
c0d04a82:	0a91      	lsrs	r1, r2, #10
c0d04a84:	4248      	negs	r0, r1
c0d04a86:	4148      	adcs	r0, r1
c0d04a88:	490a      	ldr	r1, [pc, #40]	; (c0d04ab4 <signTx_handleEndAPDU+0x40>)
c0d04a8a:	4479      	add	r1, pc
c0d04a8c:	1c49      	adds	r1, r1, #1
c0d04a8e:	f7fb faef 	bl	c0d00070 <assert>
c0d04a92:	20d3      	movs	r0, #211	; 0xd3
c0d04a94:	0080      	lsls	r0, r0, #2
	}

	explicit_bzero(&ctx->wittnessPath, SIZEOF(ctx->wittnessPath));
c0d04a96:	4f08      	ldr	r7, [pc, #32]	; (c0d04ab8 <signTx_handleEndAPDU+0x44>)
c0d04a98:	183e      	adds	r6, r7, r0
c0d04a9a:	212c      	movs	r1, #44	; 0x2c
c0d04a9c:	4630      	mov	r0, r6
c0d04a9e:	f003 fd49 	bl	c0d08534 <explicit_bzero>
c0d04aa2:	9613      	str	r6, [sp, #76]	; 0x4c
	{
		// parse
		size_t parsedSize = bip44_parseFromWire(
c0d04aa4:	4630      	mov	r0, r6
c0d04aa6:	4629      	mov	r1, r5
c0d04aa8:	4622      	mov	r2, r4
c0d04aaa:	f7fb fae9 	bl	c0d00080 <bip44_parseFromWire>
			&ctx->wittnessPath,
			wireDataBuffer,
			wireDataSize);
		VALIDATE(parsedSize == wireDataSize, ERR_INVALID_DATA);
c0d04aae:	42a0      	cmp	r0, r4
c0d04ab0:	d004      	beq.n	c0d04abc <signTx_handleEndAPDU+0x48>
c0d04ab2:	e2fa      	b.n	c0d050aa <signTx_handleEndAPDU+0x636>
c0d04ab4:	00004a5d 	.word	0x00004a5d
c0d04ab8:	20000490 	.word	0x20000490
c0d04abc:	ae4c      	add	r6, sp, #304	; 0x130
	}

	{
		uint8_t constants[] = {0x30, 0x06, wireDataSize};
c0d04abe:	70b4      	strb	r4, [r6, #2]
c0d04ac0:	2006      	movs	r0, #6
c0d04ac2:	7070      	strb	r0, [r6, #1]
c0d04ac4:	2030      	movs	r0, #48	; 0x30
c0d04ac6:	7030      	strb	r0, [r6, #0]
c0d04ac8:	4638      	mov	r0, r7
c0d04aca:	3070      	adds	r0, #112	; 0x70
c0d04acc:	463c      	mov	r4, r7
c0d04ace:	1d07      	adds	r7, r0, #4
c0d04ad0:	4638      	mov	r0, r7
c0d04ad2:	f7fb fce5 	bl	c0d004a0 <cx_sha256_init_no_throw>
c0d04ad6:	2270      	movs	r2, #112	; 0x70
c0d04ad8:	4813      	ldr	r0, [pc, #76]	; (c0d04b28 <signTx_handleEndAPDU+0xb4>)
c0d04ada:	920e      	str	r2, [sp, #56]	; 0x38
	ctx->initialized_magic = HASH_CONTEXT_INITIALIZED_MAGIC;
c0d04adc:	52a0      	strh	r0, [r4, r2]
c0d04ade:	2001      	movs	r0, #1
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04ae0:	4912      	ldr	r1, [pc, #72]	; (c0d04b2c <signTx_handleEndAPDU+0xb8>)
c0d04ae2:	4479      	add	r1, pc
c0d04ae4:	f7fb fac4 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d04ae8:	4811      	ldr	r0, [pc, #68]	; (c0d04b30 <signTx_handleEndAPDU+0xbc>)
c0d04aea:	4478      	add	r0, pc
c0d04aec:	4911      	ldr	r1, [pc, #68]	; (c0d04b34 <signTx_handleEndAPDU+0xc0>)
c0d04aee:	4479      	add	r1, pc
c0d04af0:	2224      	movs	r2, #36	; 0x24
c0d04af2:	f7fe f8a7 	bl	c0d02c44 <mcu_usb_printf>
c0d04af6:	4810      	ldr	r0, [pc, #64]	; (c0d04b38 <signTx_handleEndAPDU+0xc4>)
c0d04af8:	4478      	add	r0, pc
c0d04afa:	2503      	movs	r5, #3
c0d04afc:	4629      	mov	r1, r5
c0d04afe:	4632      	mov	r2, r6
c0d04b00:	f7fe f8a0 	bl	c0d02c44 <mcu_usb_printf>
c0d04b04:	480d      	ldr	r0, [pc, #52]	; (c0d04b3c <signTx_handleEndAPDU+0xc8>)
c0d04b06:	4478      	add	r0, pc
c0d04b08:	f7fe f89c 	bl	c0d02c44 <mcu_usb_printf>
c0d04b0c:	2400      	movs	r4, #0
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04b0e:	9400      	str	r4, [sp, #0]
c0d04b10:	9401      	str	r4, [sp, #4]
c0d04b12:	970f      	str	r7, [sp, #60]	; 0x3c
c0d04b14:	4638      	mov	r0, r7
c0d04b16:	4621      	mov	r1, r4
c0d04b18:	4632      	mov	r2, r6
c0d04b1a:	462b      	mov	r3, r5
c0d04b1c:	f7fb fca8 	bl	c0d00470 <cx_hash_no_throw>
c0d04b20:	2800      	cmp	r0, #0
c0d04b22:	d00d      	beq.n	c0d04b40 <signTx_handleEndAPDU+0xcc>
c0d04b24:	e2cb      	b.n	c0d050be <signTx_handleEndAPDU+0x64a>
c0d04b26:	46c0      	nop			; (mov r8, r8)
c0d04b28:	00003039 	.word	0x00003039
c0d04b2c:	00004b1b 	.word	0x00004b1b
c0d04b30:	00003ed5 	.word	0x00003ed5
c0d04b34:	00004b1d 	.word	0x00004b1d
c0d04b38:	00003ee8 	.word	0x00003ee8
c0d04b3c:	00004a20 	.word	0x00004a20
c0d04b40:	9f0f      	ldr	r7, [sp, #60]	; 0x3c
  return cx_hash_get_size(hash);
c0d04b42:	4638      	mov	r0, r7
c0d04b44:	f7fb fc8e 	bl	c0d00464 <cx_hash_get_size>
c0d04b48:	4df2      	ldr	r5, [pc, #968]	; (c0d04f14 <signTx_handleEndAPDU+0x4a0>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04b4a:	980e      	ldr	r0, [sp, #56]	; 0x38
c0d04b4c:	5a28      	ldrh	r0, [r5, r0]
c0d04b4e:	49f2      	ldr	r1, [pc, #968]	; (c0d04f18 <signTx_handleEndAPDU+0x4a4>)
c0d04b50:	1a41      	subs	r1, r0, r1
c0d04b52:	4248      	negs	r0, r1
c0d04b54:	4148      	adcs	r0, r1
c0d04b56:	49f1      	ldr	r1, [pc, #964]	; (c0d04f1c <signTx_handleEndAPDU+0x4a8>)
c0d04b58:	4479      	add	r1, pc
c0d04b5a:	f7fb fa89 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d04b5e:	48f0      	ldr	r0, [pc, #960]	; (c0d04f20 <signTx_handleEndAPDU+0x4ac>)
c0d04b60:	4478      	add	r0, pc
c0d04b62:	49f0      	ldr	r1, [pc, #960]	; (c0d04f24 <signTx_handleEndAPDU+0x4b0>)
c0d04b64:	4479      	add	r1, pc
c0d04b66:	2224      	movs	r2, #36	; 0x24
c0d04b68:	f7fe f86c 	bl	c0d02c44 <mcu_usb_printf>
c0d04b6c:	35e0      	adds	r5, #224	; 0xe0
c0d04b6e:	48fe      	ldr	r0, [pc, #1016]	; (c0d04f68 <signTx_handleEndAPDU+0x4f4>)
c0d04b70:	4478      	add	r0, pc
c0d04b72:	2620      	movs	r6, #32
c0d04b74:	4631      	mov	r1, r6
c0d04b76:	462a      	mov	r2, r5
c0d04b78:	f7fe f864 	bl	c0d02c44 <mcu_usb_printf>
c0d04b7c:	48fb      	ldr	r0, [pc, #1004]	; (c0d04f6c <signTx_handleEndAPDU+0x4f8>)
c0d04b7e:	4478      	add	r0, pc
c0d04b80:	f7fe f860 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04b84:	9400      	str	r4, [sp, #0]
c0d04b86:	9401      	str	r4, [sp, #4]
c0d04b88:	4638      	mov	r0, r7
c0d04b8a:	4621      	mov	r1, r4
c0d04b8c:	462a      	mov	r2, r5
c0d04b8e:	4633      	mov	r3, r6
c0d04b90:	f7fb fc6e 	bl	c0d00470 <cx_hash_no_throw>
c0d04b94:	2800      	cmp	r0, #0
c0d04b96:	d000      	beq.n	c0d04b9a <signTx_handleEndAPDU+0x126>
c0d04b98:	e291      	b.n	c0d050be <signTx_handleEndAPDU+0x64a>
c0d04b9a:	4ff1      	ldr	r7, [pc, #964]	; (c0d04f60 <signTx_handleEndAPDU+0x4ec>)
  return cx_hash_get_size(hash);
c0d04b9c:	4638      	mov	r0, r7
c0d04b9e:	3074      	adds	r0, #116	; 0x74
c0d04ba0:	900c      	str	r0, [sp, #48]	; 0x30
c0d04ba2:	f7fb fc5f 	bl	c0d00464 <cx_hash_get_size>
c0d04ba6:	ae4b      	add	r6, sp, #300	; 0x12c
c0d04ba8:	2501      	movs	r5, #1
		sha_256_append(&ctx->integrityHashContext, constants, SIZEOF(constants));
		sha_256_append(&ctx->integrityHashContext, ctx->prevHash, 32);

		// Extension points
		uint8_t epBuf[1];
		explicit_bzero(epBuf, SIZEOF(epBuf));
c0d04baa:	4630      	mov	r0, r6
c0d04bac:	4629      	mov	r1, r5
c0d04bae:	f003 fcc1 	bl	c0d08534 <explicit_bzero>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04bb2:	8838      	ldrh	r0, [r7, #0]
c0d04bb4:	49eb      	ldr	r1, [pc, #940]	; (c0d04f64 <signTx_handleEndAPDU+0x4f0>)
c0d04bb6:	1a41      	subs	r1, r0, r1
c0d04bb8:	4248      	negs	r0, r1
c0d04bba:	4148      	adcs	r0, r1
c0d04bbc:	49ec      	ldr	r1, [pc, #944]	; (c0d04f70 <signTx_handleEndAPDU+0x4fc>)
c0d04bbe:	4479      	add	r1, pc
c0d04bc0:	f7fb fa56 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d04bc4:	48eb      	ldr	r0, [pc, #940]	; (c0d04f74 <signTx_handleEndAPDU+0x500>)
c0d04bc6:	4478      	add	r0, pc
c0d04bc8:	49eb      	ldr	r1, [pc, #940]	; (c0d04f78 <signTx_handleEndAPDU+0x504>)
c0d04bca:	4479      	add	r1, pc
c0d04bcc:	2224      	movs	r2, #36	; 0x24
c0d04bce:	f7fe f839 	bl	c0d02c44 <mcu_usb_printf>
c0d04bd2:	48ea      	ldr	r0, [pc, #936]	; (c0d04f7c <signTx_handleEndAPDU+0x508>)
c0d04bd4:	4478      	add	r0, pc
c0d04bd6:	4629      	mov	r1, r5
c0d04bd8:	4632      	mov	r2, r6
c0d04bda:	f7fe f833 	bl	c0d02c44 <mcu_usb_printf>
c0d04bde:	48e8      	ldr	r0, [pc, #928]	; (c0d04f80 <signTx_handleEndAPDU+0x50c>)
c0d04be0:	4478      	add	r0, pc
c0d04be2:	f7fe f82f 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04be6:	9400      	str	r4, [sp, #0]
c0d04be8:	9401      	str	r4, [sp, #4]
c0d04bea:	1d3f      	adds	r7, r7, #4
c0d04bec:	4638      	mov	r0, r7
c0d04bee:	4621      	mov	r1, r4
c0d04bf0:	4632      	mov	r2, r6
c0d04bf2:	462b      	mov	r3, r5
c0d04bf4:	f7fb fc3c 	bl	c0d00470 <cx_hash_no_throw>
c0d04bf8:	2800      	cmp	r0, #0
c0d04bfa:	d000      	beq.n	c0d04bfe <signTx_handleEndAPDU+0x18a>
c0d04bfc:	e25f      	b.n	c0d050be <signTx_handleEndAPDU+0x64a>
  return cx_hash_get_size(hash);
c0d04bfe:	4638      	mov	r0, r7
c0d04c00:	f7fb fc30 	bl	c0d00464 <cx_hash_get_size>
c0d04c04:	ad43      	add	r5, sp, #268	; 0x10c
c0d04c06:	2620      	movs	r6, #32
		sha_256_append(&ctx->txHashContext, epBuf, SIZEOF(epBuf));

		// We finish the tx hash appending a 32-byte empty buffer
		uint8_t txHashBuf[32];
		explicit_bzero(txHashBuf, SIZEOF(txHashBuf));
c0d04c08:	4628      	mov	r0, r5
c0d04c0a:	4631      	mov	r1, r6
c0d04c0c:	f003 fc92 	bl	c0d08534 <explicit_bzero>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04c10:	48d3      	ldr	r0, [pc, #844]	; (c0d04f60 <signTx_handleEndAPDU+0x4ec>)
c0d04c12:	8800      	ldrh	r0, [r0, #0]
c0d04c14:	49d3      	ldr	r1, [pc, #844]	; (c0d04f64 <signTx_handleEndAPDU+0x4f0>)
c0d04c16:	1a41      	subs	r1, r0, r1
c0d04c18:	4248      	negs	r0, r1
c0d04c1a:	4148      	adcs	r0, r1
c0d04c1c:	49d9      	ldr	r1, [pc, #868]	; (c0d04f84 <signTx_handleEndAPDU+0x510>)
c0d04c1e:	4479      	add	r1, pc
c0d04c20:	f7fb fa26 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d04c24:	48d8      	ldr	r0, [pc, #864]	; (c0d04f88 <signTx_handleEndAPDU+0x514>)
c0d04c26:	4478      	add	r0, pc
c0d04c28:	49d8      	ldr	r1, [pc, #864]	; (c0d04f8c <signTx_handleEndAPDU+0x518>)
c0d04c2a:	4479      	add	r1, pc
c0d04c2c:	2224      	movs	r2, #36	; 0x24
c0d04c2e:	f7fe f809 	bl	c0d02c44 <mcu_usb_printf>
c0d04c32:	48d7      	ldr	r0, [pc, #860]	; (c0d04f90 <signTx_handleEndAPDU+0x51c>)
c0d04c34:	4478      	add	r0, pc
c0d04c36:	4631      	mov	r1, r6
c0d04c38:	462a      	mov	r2, r5
c0d04c3a:	f7fe f803 	bl	c0d02c44 <mcu_usb_printf>
c0d04c3e:	48d5      	ldr	r0, [pc, #852]	; (c0d04f94 <signTx_handleEndAPDU+0x520>)
c0d04c40:	4478      	add	r0, pc
c0d04c42:	f7fd ffff 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04c46:	9400      	str	r4, [sp, #0]
c0d04c48:	9401      	str	r4, [sp, #4]
c0d04c4a:	4638      	mov	r0, r7
c0d04c4c:	4621      	mov	r1, r4
c0d04c4e:	462a      	mov	r2, r5
c0d04c50:	4633      	mov	r3, r6
c0d04c52:	f7fb fc0d 	bl	c0d00470 <cx_hash_no_throw>
c0d04c56:	2800      	cmp	r0, #0
c0d04c58:	d000      	beq.n	c0d04c5c <signTx_handleEndAPDU+0x1e8>
c0d04c5a:	e230      	b.n	c0d050be <signTx_handleEndAPDU+0x64a>
  return cx_hash_get_size(hash);
c0d04c5c:	4638      	mov	r0, r7
c0d04c5e:	f7fb fc01 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04c62:	48bf      	ldr	r0, [pc, #764]	; (c0d04f60 <signTx_handleEndAPDU+0x4ec>)
c0d04c64:	8800      	ldrh	r0, [r0, #0]
c0d04c66:	49bf      	ldr	r1, [pc, #764]	; (c0d04f64 <signTx_handleEndAPDU+0x4f0>)
c0d04c68:	1a41      	subs	r1, r0, r1
c0d04c6a:	4248      	negs	r0, r1
c0d04c6c:	4148      	adcs	r0, r1
c0d04c6e:	49ca      	ldr	r1, [pc, #808]	; (c0d04f98 <signTx_handleEndAPDU+0x524>)
c0d04c70:	4479      	add	r1, pc
c0d04c72:	f7fb f9fd 	bl	c0d00070 <assert>
c0d04c76:	2401      	movs	r4, #1
	ASSERT(outSize == SHA_256_SIZE);
c0d04c78:	49c8      	ldr	r1, [pc, #800]	; (c0d04f9c <signTx_handleEndAPDU+0x528>)
c0d04c7a:	4479      	add	r1, pc
c0d04c7c:	4620      	mov	r0, r4
c0d04c7e:	f7fb f9f7 	bl	c0d00070 <assert>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04c82:	9601      	str	r6, [sp, #4]
c0d04c84:	a843      	add	r0, sp, #268	; 0x10c
c0d04c86:	9000      	str	r0, [sp, #0]
c0d04c88:	2600      	movs	r6, #0
c0d04c8a:	4638      	mov	r0, r7
c0d04c8c:	4621      	mov	r1, r4
c0d04c8e:	4632      	mov	r2, r6
c0d04c90:	4633      	mov	r3, r6
c0d04c92:	f7fb fbed 	bl	c0d00470 <cx_hash_no_throw>
c0d04c96:	2800      	cmp	r0, #0
c0d04c98:	d000      	beq.n	c0d04c9c <signTx_handleEndAPDU+0x228>
c0d04c9a:	e210      	b.n	c0d050be <signTx_handleEndAPDU+0x64a>
  return cx_hash_get_size(hash);
c0d04c9c:	4638      	mov	r0, r7
c0d04c9e:	f7fb fbe1 	bl	c0d00464 <cx_hash_get_size>
c0d04ca2:	ad3b      	add	r5, sp, #236	; 0xec
c0d04ca4:	2420      	movs	r4, #32
		// we get the resulting tx hash
		sha_256_finalize(&ctx->txHashContext, txHashBuf, SIZEOF(txHashBuf));

		// We finish the integrity hash appending a 32-byte empty buffer
		uint8_t integrityHashBuf[32];
		explicit_bzero(integrityHashBuf, SIZEOF(integrityHashBuf));
c0d04ca6:	4628      	mov	r0, r5
c0d04ca8:	4621      	mov	r1, r4
c0d04caa:	f003 fc43 	bl	c0d08534 <explicit_bzero>
c0d04cae:	4fac      	ldr	r7, [pc, #688]	; (c0d04f60 <signTx_handleEndAPDU+0x4ec>)
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04cb0:	980e      	ldr	r0, [sp, #56]	; 0x38
c0d04cb2:	5a38      	ldrh	r0, [r7, r0]
c0d04cb4:	49ab      	ldr	r1, [pc, #684]	; (c0d04f64 <signTx_handleEndAPDU+0x4f0>)
c0d04cb6:	1a41      	subs	r1, r0, r1
c0d04cb8:	4248      	negs	r0, r1
c0d04cba:	4148      	adcs	r0, r1
c0d04cbc:	49b8      	ldr	r1, [pc, #736]	; (c0d04fa0 <signTx_handleEndAPDU+0x52c>)
c0d04cbe:	4479      	add	r1, pc
c0d04cc0:	f7fb f9d6 	bl	c0d00070 <assert>
	TRACE_BUFFER(inBuffer, inSize);
c0d04cc4:	48b7      	ldr	r0, [pc, #732]	; (c0d04fa4 <signTx_handleEndAPDU+0x530>)
c0d04cc6:	4478      	add	r0, pc
c0d04cc8:	49b7      	ldr	r1, [pc, #732]	; (c0d04fa8 <signTx_handleEndAPDU+0x534>)
c0d04cca:	4479      	add	r1, pc
c0d04ccc:	2224      	movs	r2, #36	; 0x24
c0d04cce:	f7fd ffb9 	bl	c0d02c44 <mcu_usb_printf>
c0d04cd2:	48b6      	ldr	r0, [pc, #728]	; (c0d04fac <signTx_handleEndAPDU+0x538>)
c0d04cd4:	4478      	add	r0, pc
c0d04cd6:	4621      	mov	r1, r4
c0d04cd8:	462a      	mov	r2, r5
c0d04cda:	f7fd ffb3 	bl	c0d02c44 <mcu_usb_printf>
c0d04cde:	48b4      	ldr	r0, [pc, #720]	; (c0d04fb0 <signTx_handleEndAPDU+0x53c>)
c0d04ce0:	4478      	add	r0, pc
c0d04ce2:	f7fd ffaf 	bl	c0d02c44 <mcu_usb_printf>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04ce6:	9600      	str	r6, [sp, #0]
c0d04ce8:	9601      	str	r6, [sp, #4]
c0d04cea:	9f0f      	ldr	r7, [sp, #60]	; 0x3c
c0d04cec:	4638      	mov	r0, r7
c0d04cee:	4631      	mov	r1, r6
c0d04cf0:	462a      	mov	r2, r5
c0d04cf2:	4623      	mov	r3, r4
c0d04cf4:	f7fb fbbc 	bl	c0d00470 <cx_hash_no_throw>
c0d04cf8:	2800      	cmp	r0, #0
c0d04cfa:	d000      	beq.n	c0d04cfe <signTx_handleEndAPDU+0x28a>
c0d04cfc:	e1df      	b.n	c0d050be <signTx_handleEndAPDU+0x64a>
  return cx_hash_get_size(hash);
c0d04cfe:	4638      	mov	r0, r7
c0d04d00:	f7fb fbb0 	bl	c0d00464 <cx_hash_get_size>
	ASSERT(ctx->initialized_magic == HASH_CONTEXT_INITIALIZED_MAGIC);
c0d04d04:	48fb      	ldr	r0, [pc, #1004]	; (c0d050f4 <signTx_handleEndAPDU+0x680>)
c0d04d06:	990e      	ldr	r1, [sp, #56]	; 0x38
c0d04d08:	5a40      	ldrh	r0, [r0, r1]
c0d04d0a:	49fb      	ldr	r1, [pc, #1004]	; (c0d050f8 <signTx_handleEndAPDU+0x684>)
c0d04d0c:	1a41      	subs	r1, r0, r1
c0d04d0e:	4248      	negs	r0, r1
c0d04d10:	4148      	adcs	r0, r1
c0d04d12:	49fc      	ldr	r1, [pc, #1008]	; (c0d05104 <signTx_handleEndAPDU+0x690>)
c0d04d14:	4479      	add	r1, pc
c0d04d16:	f7fb f9ab 	bl	c0d00070 <assert>
c0d04d1a:	2501      	movs	r5, #1
	ASSERT(outSize == SHA_256_SIZE);
c0d04d1c:	49fa      	ldr	r1, [pc, #1000]	; (c0d05108 <signTx_handleEndAPDU+0x694>)
c0d04d1e:	4479      	add	r1, pc
c0d04d20:	4628      	mov	r0, r5
c0d04d22:	f7fb f9a5 	bl	c0d00070 <assert>
  CX_THROW(cx_hash_no_throw(hash, mode, in, len, out, out_len));
c0d04d26:	9401      	str	r4, [sp, #4]
c0d04d28:	a83b      	add	r0, sp, #236	; 0xec
c0d04d2a:	9000      	str	r0, [sp, #0]
c0d04d2c:	2200      	movs	r2, #0
c0d04d2e:	4638      	mov	r0, r7
c0d04d30:	9512      	str	r5, [sp, #72]	; 0x48
c0d04d32:	4629      	mov	r1, r5
c0d04d34:	9211      	str	r2, [sp, #68]	; 0x44
c0d04d36:	4613      	mov	r3, r2
c0d04d38:	f7fb fb9a 	bl	c0d00470 <cx_hash_no_throw>
c0d04d3c:	2800      	cmp	r0, #0
c0d04d3e:	d000      	beq.n	c0d04d42 <signTx_handleEndAPDU+0x2ce>
c0d04d40:	e1bd      	b.n	c0d050be <signTx_handleEndAPDU+0x64a>
  return cx_hash_get_size(hash);
c0d04d42:	980c      	ldr	r0, [sp, #48]	; 0x30
c0d04d44:	f7fb fb8e 	bl	c0d00464 <cx_hash_get_size>

		// We get the resulting integrity hash and check whether it is in the list of allowed hashes
		sha_256_finalize(&ctx->integrityHashContext, integrityHashBuf, SIZEOF(integrityHashBuf));

		// // We save the tx hash into APDU buffer to return it
		memcpy(G_io_apdu_buffer, txHashBuf, SIZEOF(txHashBuf));
c0d04d48:	4fec      	ldr	r7, [pc, #944]	; (c0d050fc <signTx_handleEndAPDU+0x688>)
c0d04d4a:	a943      	add	r1, sp, #268	; 0x10c
c0d04d4c:	2220      	movs	r2, #32
c0d04d4e:	9210      	str	r2, [sp, #64]	; 0x40
c0d04d50:	4638      	mov	r0, r7
c0d04d52:	f003 fbe0 	bl	c0d08516 <__aeabi_memcpy>
c0d04d56:	4ae5      	ldr	r2, [pc, #916]	; (c0d050ec <signTx_handleEndAPDU+0x678>)

		TRACE("Integrity hash:\n\n");
c0d04d58:	322c      	adds	r2, #44	; 0x2c
c0d04d5a:	4cec      	ldr	r4, [pc, #944]	; (c0d0510c <signTx_handleEndAPDU+0x698>)
c0d04d5c:	447c      	add	r4, pc
c0d04d5e:	4eec      	ldr	r6, [pc, #944]	; (c0d05110 <signTx_handleEndAPDU+0x69c>)
c0d04d60:	447e      	add	r6, pc
c0d04d62:	4620      	mov	r0, r4
c0d04d64:	4631      	mov	r1, r6
c0d04d66:	f7fd ff6d 	bl	c0d02c44 <mcu_usb_printf>
c0d04d6a:	48ea      	ldr	r0, [pc, #936]	; (c0d05114 <signTx_handleEndAPDU+0x6a0>)
c0d04d6c:	4478      	add	r0, pc
c0d04d6e:	f7fd ff69 	bl	c0d02c44 <mcu_usb_printf>
c0d04d72:	4de9      	ldr	r5, [pc, #932]	; (c0d05118 <signTx_handleEndAPDU+0x6a4>)
c0d04d74:	447d      	add	r5, pc
c0d04d76:	4628      	mov	r0, r5
c0d04d78:	f7fd ff64 	bl	c0d02c44 <mcu_usb_printf>
		TRACE_BUFFER(integrityHashBuf, SIZEOF(integrityHashBuf));
c0d04d7c:	4adb      	ldr	r2, [pc, #876]	; (c0d050ec <signTx_handleEndAPDU+0x678>)
c0d04d7e:	322d      	adds	r2, #45	; 0x2d
c0d04d80:	4620      	mov	r0, r4
c0d04d82:	4631      	mov	r1, r6
c0d04d84:	f7fd ff5e 	bl	c0d02c44 <mcu_usb_printf>
c0d04d88:	48e4      	ldr	r0, [pc, #912]	; (c0d0511c <signTx_handleEndAPDU+0x6a8>)
c0d04d8a:	4478      	add	r0, pc
c0d04d8c:	aa3b      	add	r2, sp, #236	; 0xec
c0d04d8e:	920a      	str	r2, [sp, #40]	; 0x28
c0d04d90:	9910      	ldr	r1, [sp, #64]	; 0x40
c0d04d92:	f7fd ff57 	bl	c0d02c44 <mcu_usb_printf>
c0d04d96:	4628      	mov	r0, r5
c0d04d98:	f7fd ff54 	bl	c0d02c44 <mcu_usb_printf>
		TRACE("\n\n");
c0d04d9c:	4ad3      	ldr	r2, [pc, #844]	; (c0d050ec <signTx_handleEndAPDU+0x678>)
c0d04d9e:	322e      	adds	r2, #46	; 0x2e
c0d04da0:	4620      	mov	r0, r4
c0d04da2:	4631      	mov	r1, r6
c0d04da4:	f7fd ff4e 	bl	c0d02c44 <mcu_usb_printf>
c0d04da8:	48dd      	ldr	r0, [pc, #884]	; (c0d05120 <signTx_handleEndAPDU+0x6ac>)
c0d04daa:	4478      	add	r0, pc
c0d04dac:	f7fd ff4a 	bl	c0d02c44 <mcu_usb_printf>
c0d04db0:	4628      	mov	r0, r5
c0d04db2:	f7fd ff47 	bl	c0d02c44 <mcu_usb_printf>
c0d04db6:	9812      	ldr	r0, [sp, #72]	; 0x48
c0d04db8:	0204      	lsls	r4, r0, #8
c0d04dba:	25ff      	movs	r5, #255	; 0xff
c0d04dbc:	3552      	adds	r5, #82	; 0x52

		// Check if integrity hash is in the list of allowed hashes
		ctx->ui_step = HANDLE_END_STEP_HASH_NOT_ALLOWED;
c0d04dbe:	4628      	mov	r0, r5
c0d04dc0:	3041      	adds	r0, #65	; 0x41
c0d04dc2:	49cc      	ldr	r1, [pc, #816]	; (c0d050f4 <signTx_handleEndAPDU+0x680>)
c0d04dc4:	5108      	str	r0, [r1, r4]
		for (uint8_t i = 0; i < NUM_ALLOWED_HASHES; i++)
		{
			if (memcmp(integrityHashBuf, ALLOWED_HASHES[i], 32) == 0)
c0d04dc6:	49d7      	ldr	r1, [pc, #860]	; (c0d05124 <signTx_handleEndAPDU+0x6b0>)
c0d04dc8:	4479      	add	r1, pc
c0d04dca:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d04dcc:	9a10      	ldr	r2, [sp, #64]	; 0x40
c0d04dce:	f003 fbb5 	bl	c0d0853c <memcmp>
c0d04dd2:	2800      	cmp	r0, #0
c0d04dd4:	d000      	beq.n	c0d04dd8 <signTx_handleEndAPDU+0x364>
c0d04dd6:	e174      	b.n	c0d050c2 <signTx_handleEndAPDU+0x64e>
c0d04dd8:	950b      	str	r5, [sp, #44]	; 0x2c
			{
				ctx->ui_step = HANDLE_END_STEP_CONFIRM;
c0d04dda:	4628      	mov	r0, r5
c0d04ddc:	303f      	adds	r0, #63	; 0x3f
c0d04dde:	4ec5      	ldr	r6, [pc, #788]	; (c0d050f4 <signTx_handleEndAPDU+0x680>)
c0d04de0:	5130      	str	r0, [r6, r4]
c0d04de2:	48c2      	ldr	r0, [pc, #776]	; (c0d050ec <signTx_handleEndAPDU+0x678>)
			TRACE("Hash NOT ALLOWED");
			THROW(ERR_HASH_NOT_ALLOWED);
		}
		else
		{
			TRACE("Hash ALLOWED");
c0d04de4:	4602      	mov	r2, r0
c0d04de6:	4605      	mov	r5, r0
c0d04de8:	3242      	adds	r2, #66	; 0x42
c0d04dea:	4ccf      	ldr	r4, [pc, #828]	; (c0d05128 <signTx_handleEndAPDU+0x6b4>)
c0d04dec:	447c      	add	r4, pc
c0d04dee:	49cf      	ldr	r1, [pc, #828]	; (c0d0512c <signTx_handleEndAPDU+0x6b8>)
c0d04df0:	4479      	add	r1, pc
c0d04df2:	9109      	str	r1, [sp, #36]	; 0x24
c0d04df4:	4620      	mov	r0, r4
c0d04df6:	f7fd ff25 	bl	c0d02c44 <mcu_usb_printf>
c0d04dfa:	48cd      	ldr	r0, [pc, #820]	; (c0d05130 <signTx_handleEndAPDU+0x6bc>)
c0d04dfc:	4478      	add	r0, pc
c0d04dfe:	f7fd ff21 	bl	c0d02c44 <mcu_usb_printf>
c0d04e02:	48cc      	ldr	r0, [pc, #816]	; (c0d05134 <signTx_handleEndAPDU+0x6c0>)
c0d04e04:	4478      	add	r0, pc
c0d04e06:	9006      	str	r0, [sp, #24]
c0d04e08:	f7fd ff1c 	bl	c0d02c44 <mcu_usb_printf>
c0d04e0c:	ae31      	add	r6, sp, #196	; 0xc4
		}

		// We derive the private key
		private_key_t privateKey;
		derivePrivateKey(&ctx->wittnessPath, &privateKey);
c0d04e0e:	9813      	ldr	r0, [sp, #76]	; 0x4c
c0d04e10:	4631      	mov	r1, r6
c0d04e12:	f7fc fd37 	bl	c0d01884 <derivePrivateKey>
		TRACE("privateKey.d:");
c0d04e16:	462a      	mov	r2, r5
c0d04e18:	3248      	adds	r2, #72	; 0x48
c0d04e1a:	4620      	mov	r0, r4
c0d04e1c:	4625      	mov	r5, r4
c0d04e1e:	9408      	str	r4, [sp, #32]
c0d04e20:	9c09      	ldr	r4, [sp, #36]	; 0x24
c0d04e22:	4621      	mov	r1, r4
c0d04e24:	f7fd ff0e 	bl	c0d02c44 <mcu_usb_printf>
c0d04e28:	48c3      	ldr	r0, [pc, #780]	; (c0d05138 <signTx_handleEndAPDU+0x6c4>)
c0d04e2a:	4478      	add	r0, pc
c0d04e2c:	f7fd ff0a 	bl	c0d02c44 <mcu_usb_printf>
c0d04e30:	9806      	ldr	r0, [sp, #24]
c0d04e32:	f7fd ff07 	bl	c0d02c44 <mcu_usb_printf>
		TRACE_BUFFER(privateKey.d, privateKey.d_len);
c0d04e36:	4aad      	ldr	r2, [pc, #692]	; (c0d050ec <signTx_handleEndAPDU+0x678>)
c0d04e38:	3249      	adds	r2, #73	; 0x49
c0d04e3a:	4628      	mov	r0, r5
c0d04e3c:	4621      	mov	r1, r4
c0d04e3e:	f7fd ff01 	bl	c0d02c44 <mcu_usb_printf>
c0d04e42:	9932      	ldr	r1, [sp, #200]	; 0xc8
c0d04e44:	3608      	adds	r6, #8
c0d04e46:	4dbd      	ldr	r5, [pc, #756]	; (c0d0513c <signTx_handleEndAPDU+0x6c8>)
c0d04e48:	447d      	add	r5, pc
c0d04e4a:	4628      	mov	r0, r5
c0d04e4c:	960d      	str	r6, [sp, #52]	; 0x34
c0d04e4e:	4632      	mov	r2, r6
c0d04e50:	f7fd fef8 	bl	c0d02c44 <mcu_usb_printf>
c0d04e54:	9c06      	ldr	r4, [sp, #24]
c0d04e56:	4620      	mov	r0, r4
c0d04e58:	f7fd fef4 	bl	c0d02c44 <mcu_usb_printf>
c0d04e5c:	206f      	movs	r0, #111	; 0x6f
c0d04e5e:	00c0      	lsls	r0, r0, #3
c0d04e60:	4ea4      	ldr	r6, [pc, #656]	; (c0d050f4 <signTx_handleEndAPDU+0x680>)

		// We want to show pubkey, thus we derive it
		derivePublicKey(&ctx->wittnessPath, &ctx->wittnessPathPubkey);
c0d04e62:	1831      	adds	r1, r6, r0
c0d04e64:	9813      	ldr	r0, [sp, #76]	; 0x4c
c0d04e66:	f7fc fd71 	bl	c0d0194c <derivePublicKey>
		TRACE_BUFFER(ctx->wittnessPathPubkey.W, SIZEOF(ctx->wittnessPathPubkey.W));
c0d04e6a:	4aa0      	ldr	r2, [pc, #640]	; (c0d050ec <signTx_handleEndAPDU+0x678>)
c0d04e6c:	324d      	adds	r2, #77	; 0x4d
c0d04e6e:	9808      	ldr	r0, [sp, #32]
c0d04e70:	9909      	ldr	r1, [sp, #36]	; 0x24
c0d04e72:	f7fd fee7 	bl	c0d02c44 <mcu_usb_printf>
c0d04e76:	2007      	movs	r0, #7
c0d04e78:	01c0      	lsls	r0, r0, #7
c0d04e7a:	1832      	adds	r2, r6, r0
c0d04e7c:	2141      	movs	r1, #65	; 0x41
c0d04e7e:	4628      	mov	r0, r5
c0d04e80:	f7fd fee0 	bl	c0d02c44 <mcu_usb_printf>
c0d04e84:	4620      	mov	r0, r4
c0d04e86:	f7fd fedd 	bl	c0d02c44 <mcu_usb_printf>
c0d04e8a:	ad14      	add	r5, sp, #80	; 0x50
		// Taken from EOS app
		// We use G_io_apdu_buffer to save memory (and also to minimize changes to EOS code)
		// The code produces the signature right where we need it for the respons
		BEGIN_TRY
		{
			TRY
c0d04e8c:	4628      	mov	r0, r5
c0d04e8e:	f003 fb87 	bl	c0d085a0 <setjmp>
c0d04e92:	85a8      	strh	r0, [r5, #44]	; 0x2c
c0d04e94:	0400      	lsls	r0, r0, #16
c0d04e96:	4c95      	ldr	r4, [pc, #596]	; (c0d050ec <signTx_handleEndAPDU+0x678>)
c0d04e98:	d046      	beq.n	c0d04f28 <signTx_handleEndAPDU+0x4b4>
						TRACE("Try %d unsuccesfull! We will not get correct signature!!!!!!!!!!!!!!!!!!!!!!!!!", tries);
						tries++;
					}
				}
			}
			FINALLY
c0d04e9a:	f000 fbb9 	bl	c0d05610 <try_context_get>
c0d04e9e:	a914      	add	r1, sp, #80	; 0x50
c0d04ea0:	4288      	cmp	r0, r1
c0d04ea2:	d102      	bne.n	c0d04eaa <signTx_handleEndAPDU+0x436>
c0d04ea4:	981e      	ldr	r0, [sp, #120]	; 0x78
c0d04ea6:	f000 fbbf 	bl	c0d05628 <try_context_set>
c0d04eaa:	a831      	add	r0, sp, #196	; 0xc4
c0d04eac:	2128      	movs	r1, #40	; 0x28
			{
				memset(&privateKey, 0, sizeof(privateKey));
c0d04eae:	f003 fb2d 	bl	c0d0850c <__aeabi_memclr>
c0d04eb2:	a814      	add	r0, sp, #80	; 0x50
			}
		}
		END_TRY;
c0d04eb4:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d04eb6:	2800      	cmp	r0, #0
c0d04eb8:	d000      	beq.n	c0d04ebc <signTx_handleEndAPDU+0x448>
c0d04eba:	e100      	b.n	c0d050be <signTx_handleEndAPDU+0x64a>

		// We add hash to the response
		TRACE("ecdsa_der_to_sig_result:");
c0d04ebc:	4622      	mov	r2, r4
c0d04ebe:	328c      	adds	r2, #140	; 0x8c
c0d04ec0:	4dac      	ldr	r5, [pc, #688]	; (c0d05174 <signTx_handleEndAPDU+0x700>)
c0d04ec2:	447d      	add	r5, pc
c0d04ec4:	4eac      	ldr	r6, [pc, #688]	; (c0d05178 <signTx_handleEndAPDU+0x704>)
c0d04ec6:	447e      	add	r6, pc
c0d04ec8:	4628      	mov	r0, r5
c0d04eca:	4631      	mov	r1, r6
c0d04ecc:	f7fd feba 	bl	c0d02c44 <mcu_usb_printf>
c0d04ed0:	48aa      	ldr	r0, [pc, #680]	; (c0d0517c <signTx_handleEndAPDU+0x708>)
c0d04ed2:	4478      	add	r0, pc
c0d04ed4:	f7fd feb6 	bl	c0d02c44 <mcu_usb_printf>
c0d04ed8:	48a9      	ldr	r0, [pc, #676]	; (c0d05180 <signTx_handleEndAPDU+0x70c>)
c0d04eda:	4478      	add	r0, pc
c0d04edc:	9005      	str	r0, [sp, #20]
c0d04ede:	f7fd feb1 	bl	c0d02c44 <mcu_usb_printf>
		TRACE_BUFFER(G_io_apdu_buffer, 65);
c0d04ee2:	348d      	adds	r4, #141	; 0x8d
c0d04ee4:	4628      	mov	r0, r5
c0d04ee6:	4631      	mov	r1, r6
c0d04ee8:	4622      	mov	r2, r4
c0d04eea:	f7fd feab 	bl	c0d02c44 <mcu_usb_printf>
c0d04eee:	48a5      	ldr	r0, [pc, #660]	; (c0d05184 <signTx_handleEndAPDU+0x710>)
c0d04ef0:	4478      	add	r0, pc
c0d04ef2:	2141      	movs	r1, #65	; 0x41
c0d04ef4:	463a      	mov	r2, r7
c0d04ef6:	f7fd fea5 	bl	c0d02c44 <mcu_usb_printf>
c0d04efa:	9805      	ldr	r0, [sp, #20]
c0d04efc:	f7fd fea2 	bl	c0d02c44 <mcu_usb_printf>
		memcpy(G_io_apdu_buffer + 65, txHashBuf, 32);
c0d04f00:	3741      	adds	r7, #65	; 0x41
c0d04f02:	a943      	add	r1, sp, #268	; 0x10c
c0d04f04:	2220      	movs	r2, #32
c0d04f06:	4638      	mov	r0, r7
c0d04f08:	f003 fb05 	bl	c0d08516 <__aeabi_memcpy>
	}

	signTx_handleEnd_ui_runStep();
c0d04f0c:	f000 fa32 	bl	c0d05374 <signTx_handleEnd_ui_runStep>
}
c0d04f10:	b04f      	add	sp, #316	; 0x13c
c0d04f12:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d04f14:	20000490 	.word	0x20000490
c0d04f18:	00003039 	.word	0x00003039
c0d04f1c:	00004aa5 	.word	0x00004aa5
c0d04f20:	00003e5f 	.word	0x00003e5f
c0d04f24:	00004aa7 	.word	0x00004aa7
c0d04f28:	a814      	add	r0, sp, #80	; 0x50
			TRY
c0d04f2a:	f000 fb7d 	bl	c0d05628 <try_context_set>
c0d04f2e:	901e      	str	r0, [sp, #120]	; 0x78
				explicit_bzero(G_io_apdu_buffer, SIZEOF(G_io_apdu_buffer));
c0d04f30:	4638      	mov	r0, r7
c0d04f32:	990b      	ldr	r1, [sp, #44]	; 0x2c
c0d04f34:	f003 fafe 	bl	c0d08534 <explicit_bzero>
c0d04f38:	9d11      	ldr	r5, [sp, #68]	; 0x44
					if (tries == 0)
c0d04f3a:	2d00      	cmp	r5, #0
						rng_rfc6979(G_io_apdu_buffer + 100, txHashBuf, privateKey.d, privateKey.d_len, SECP256K1_N, 32, V, K);
c0d04f3c:	4880      	ldr	r0, [pc, #512]	; (c0d05140 <signTx_handleEndAPDU+0x6cc>)
c0d04f3e:	4478      	add	r0, pc
c0d04f40:	9a10      	ldr	r2, [sp, #64]	; 0x40
					if (tries == 0)
c0d04f42:	9511      	str	r5, [sp, #68]	; 0x44
c0d04f44:	d036      	beq.n	c0d04fb4 <signTx_handleEndAPDU+0x540>
c0d04f46:	a920      	add	r1, sp, #128	; 0x80
						rng_rfc6979(G_io_apdu_buffer + 100, txHashBuf, NULL, 0, SECP256K1_N, 32, V, K);
c0d04f48:	9103      	str	r1, [sp, #12]
c0d04f4a:	a928      	add	r1, sp, #160	; 0xa0
c0d04f4c:	9102      	str	r1, [sp, #8]
c0d04f4e:	9201      	str	r2, [sp, #4]
c0d04f50:	9000      	str	r0, [sp, #0]
c0d04f52:	4638      	mov	r0, r7
c0d04f54:	3064      	adds	r0, #100	; 0x64
c0d04f56:	a943      	add	r1, sp, #268	; 0x10c
c0d04f58:	2200      	movs	r2, #0
c0d04f5a:	4613      	mov	r3, r2
c0d04f5c:	e035      	b.n	c0d04fca <signTx_handleEndAPDU+0x556>
c0d04f5e:	46c0      	nop			; (mov r8, r8)
c0d04f60:	20000490 	.word	0x20000490
c0d04f64:	00003039 	.word	0x00003039
c0d04f68:	00003e70 	.word	0x00003e70
c0d04f6c:	000049a8 	.word	0x000049a8
c0d04f70:	00004a3f 	.word	0x00004a3f
c0d04f74:	00003df9 	.word	0x00003df9
c0d04f78:	00004a41 	.word	0x00004a41
c0d04f7c:	00003e0c 	.word	0x00003e0c
c0d04f80:	00004946 	.word	0x00004946
c0d04f84:	000049df 	.word	0x000049df
c0d04f88:	00003d99 	.word	0x00003d99
c0d04f8c:	000049e1 	.word	0x000049e1
c0d04f90:	00003dac 	.word	0x00003dac
c0d04f94:	000048e6 	.word	0x000048e6
c0d04f98:	000049aa 	.word	0x000049aa
c0d04f9c:	000049ae 	.word	0x000049ae
c0d04fa0:	0000493f 	.word	0x0000493f
c0d04fa4:	00003cf9 	.word	0x00003cf9
c0d04fa8:	00004941 	.word	0x00004941
c0d04fac:	00003d0c 	.word	0x00003d0c
c0d04fb0:	00004846 	.word	0x00004846
						rng_rfc6979(G_io_apdu_buffer + 100, txHashBuf, privateKey.d, privateKey.d_len, SECP256K1_N, 32, V, K);
c0d04fb4:	9b32      	ldr	r3, [sp, #200]	; 0xc8
c0d04fb6:	a920      	add	r1, sp, #128	; 0x80
c0d04fb8:	9103      	str	r1, [sp, #12]
c0d04fba:	a928      	add	r1, sp, #160	; 0xa0
c0d04fbc:	9102      	str	r1, [sp, #8]
c0d04fbe:	9201      	str	r2, [sp, #4]
c0d04fc0:	9000      	str	r0, [sp, #0]
c0d04fc2:	4638      	mov	r0, r7
c0d04fc4:	3064      	adds	r0, #100	; 0x64
c0d04fc6:	a943      	add	r1, sp, #268	; 0x10c
c0d04fc8:	9a0d      	ldr	r2, [sp, #52]	; 0x34
c0d04fca:	f7fb fbb8 	bl	c0d0073e <rng_rfc6979>
c0d04fce:	2664      	movs	r6, #100	; 0x64
                       size_t *                     sig_len,
                       uint32_t *                   info);

static inline int cx_ecdsa_sign ( const cx_ecfp_private_key_t * pvkey, int mode, cx_md_t hashID, const unsigned char * hash, unsigned int hash_len, unsigned char * sig, unsigned int sig_len, unsigned int * info )
{
  size_t sig_len_ = sig_len;
c0d04fd0:	964e      	str	r6, [sp, #312]	; 0x138
c0d04fd2:	a84d      	add	r0, sp, #308	; 0x134
  uint32_t info_;
  CX_THROW(cx_ecdsa_sign_no_throw(pvkey, mode, hashID, hash, hash_len, sig, &sig_len_, &info_));
c0d04fd4:	9003      	str	r0, [sp, #12]
c0d04fd6:	a84e      	add	r0, sp, #312	; 0x138
c0d04fd8:	9002      	str	r0, [sp, #8]
c0d04fda:	463d      	mov	r5, r7
c0d04fdc:	3564      	adds	r5, #100	; 0x64
c0d04fde:	9501      	str	r5, [sp, #4]
c0d04fe0:	9810      	ldr	r0, [sp, #64]	; 0x40
c0d04fe2:	9000      	str	r0, [sp, #0]
c0d04fe4:	a831      	add	r0, sp, #196	; 0xc4
c0d04fe6:	2203      	movs	r2, #3
c0d04fe8:	ab43      	add	r3, sp, #268	; 0x10c
c0d04fea:	4945      	ldr	r1, [pc, #276]	; (c0d05100 <signTx_handleEndAPDU+0x68c>)
c0d04fec:	f7fb fa22 	bl	c0d00434 <cx_ecdsa_sign_no_throw>
c0d04ff0:	2800      	cmp	r0, #0
c0d04ff2:	d164      	bne.n	c0d050be <signTx_handleEndAPDU+0x64a>
  if (info) {
    *info = (uint32_t)info_;
c0d04ff4:	984d      	ldr	r0, [sp, #308]	; 0x134
					TRACE_BUFFER(G_io_apdu_buffer + 100, 100);
c0d04ff6:	9007      	str	r0, [sp, #28]
c0d04ff8:	4622      	mov	r2, r4
c0d04ffa:	326e      	adds	r2, #110	; 0x6e
c0d04ffc:	4851      	ldr	r0, [pc, #324]	; (c0d05144 <signTx_handleEndAPDU+0x6d0>)
c0d04ffe:	4478      	add	r0, pc
c0d05000:	4951      	ldr	r1, [pc, #324]	; (c0d05148 <signTx_handleEndAPDU+0x6d4>)
c0d05002:	4479      	add	r1, pc
c0d05004:	f7fd fe1e 	bl	c0d02c44 <mcu_usb_printf>
c0d05008:	4850      	ldr	r0, [pc, #320]	; (c0d0514c <signTx_handleEndAPDU+0x6d8>)
c0d0500a:	4478      	add	r0, pc
c0d0500c:	4631      	mov	r1, r6
c0d0500e:	462a      	mov	r2, r5
c0d05010:	f7fd fe18 	bl	c0d02c44 <mcu_usb_printf>
c0d05014:	484e      	ldr	r0, [pc, #312]	; (c0d05150 <signTx_handleEndAPDU+0x6dc>)
c0d05016:	4478      	add	r0, pc
c0d05018:	f7fd fe14 	bl	c0d02c44 <mcu_usb_printf>
c0d0501c:	5db8      	ldrb	r0, [r7, r6]
					if ((infos & CX_ECCINFO_PARITY_ODD) != 0)
c0d0501e:	9907      	ldr	r1, [sp, #28]
c0d05020:	07c9      	lsls	r1, r1, #31
c0d05022:	d101      	bne.n	c0d05028 <signTx_handleEndAPDU+0x5b4>
c0d05024:	9912      	ldr	r1, [sp, #72]	; 0x48
c0d05026:	e002      	b.n	c0d0502e <signTx_handleEndAPDU+0x5ba>
c0d05028:	9912      	ldr	r1, [sp, #72]	; 0x48
						G_io_apdu_buffer[100] |= 0x01;
c0d0502a:	4308      	orrs	r0, r1
c0d0502c:	55b8      	strb	r0, [r7, r6]
					G_io_apdu_buffer[0] = 27 + 4 + (G_io_apdu_buffer[100] & 0x01);
c0d0502e:	4008      	ands	r0, r1
c0d05030:	301f      	adds	r0, #31
c0d05032:	7038      	strb	r0, [r7, #0]
					ecdsa_der_to_sig(G_io_apdu_buffer + 100, G_io_apdu_buffer + 1);
c0d05034:	1c7e      	adds	r6, r7, #1
c0d05036:	4628      	mov	r0, r5
c0d05038:	4631      	mov	r1, r6
c0d0503a:	f7fb fb16 	bl	c0d0066a <ecdsa_der_to_sig>
					TRACE_BUFFER(G_io_apdu_buffer, 65);
c0d0503e:	4622      	mov	r2, r4
c0d05040:	3276      	adds	r2, #118	; 0x76
c0d05042:	4844      	ldr	r0, [pc, #272]	; (c0d05154 <signTx_handleEndAPDU+0x6e0>)
c0d05044:	4478      	add	r0, pc
c0d05046:	4944      	ldr	r1, [pc, #272]	; (c0d05158 <signTx_handleEndAPDU+0x6e4>)
c0d05048:	4479      	add	r1, pc
c0d0504a:	f7fd fdfb 	bl	c0d02c44 <mcu_usb_printf>
c0d0504e:	4843      	ldr	r0, [pc, #268]	; (c0d0515c <signTx_handleEndAPDU+0x6e8>)
c0d05050:	4478      	add	r0, pc
c0d05052:	2141      	movs	r1, #65	; 0x41
c0d05054:	463a      	mov	r2, r7
c0d05056:	f7fd fdf5 	bl	c0d02c44 <mcu_usb_printf>
c0d0505a:	4841      	ldr	r0, [pc, #260]	; (c0d05160 <signTx_handleEndAPDU+0x6ec>)
c0d0505c:	4478      	add	r0, pc
c0d0505e:	f7fd fdf1 	bl	c0d02c44 <mcu_usb_printf>
					if (check_canonical(G_io_apdu_buffer + 1))
c0d05062:	4630      	mov	r0, r6
c0d05064:	f7fb fae8 	bl	c0d00638 <check_canonical>
c0d05068:	2800      	cmp	r0, #0
c0d0506a:	d000      	beq.n	c0d0506e <signTx_handleEndAPDU+0x5fa>
c0d0506c:	e715      	b.n	c0d04e9a <signTx_handleEndAPDU+0x426>
						TRACE("Try %d unsuccesfull! We will not get correct signature!!!!!!!!!!!!!!!!!!!!!!!!!", tries);
c0d0506e:	4622      	mov	r2, r4
c0d05070:	327f      	adds	r2, #127	; 0x7f
c0d05072:	483c      	ldr	r0, [pc, #240]	; (c0d05164 <signTx_handleEndAPDU+0x6f0>)
c0d05074:	4478      	add	r0, pc
c0d05076:	493c      	ldr	r1, [pc, #240]	; (c0d05168 <signTx_handleEndAPDU+0x6f4>)
c0d05078:	4479      	add	r1, pc
c0d0507a:	f7fd fde3 	bl	c0d02c44 <mcu_usb_printf>
c0d0507e:	483b      	ldr	r0, [pc, #236]	; (c0d0516c <signTx_handleEndAPDU+0x6f8>)
c0d05080:	4478      	add	r0, pc
c0d05082:	9d11      	ldr	r5, [sp, #68]	; 0x44
c0d05084:	4629      	mov	r1, r5
c0d05086:	f7fd fddd 	bl	c0d02c44 <mcu_usb_printf>
c0d0508a:	4839      	ldr	r0, [pc, #228]	; (c0d05170 <signTx_handleEndAPDU+0x6fc>)
c0d0508c:	4478      	add	r0, pc
c0d0508e:	f7fd fdd9 	bl	c0d02c44 <mcu_usb_printf>
						tries++;
c0d05092:	1c6d      	adds	r5, r5, #1
c0d05094:	e751      	b.n	c0d04f3a <signTx_handleEndAPDU+0x4c6>
		VALIDATE(p2 == P2_UNUSED, ERR_INVALID_REQUEST_PARAMETERS);
c0d05096:	483c      	ldr	r0, [pc, #240]	; (c0d05188 <signTx_handleEndAPDU+0x714>)
c0d05098:	4478      	add	r0, pc
c0d0509a:	493c      	ldr	r1, [pc, #240]	; (c0d0518c <signTx_handleEndAPDU+0x718>)
c0d0509c:	4479      	add	r1, pc
c0d0509e:	4a13      	ldr	r2, [pc, #76]	; (c0d050ec <signTx_handleEndAPDU+0x678>)
c0d050a0:	f7fd fdd0 	bl	c0d02c44 <mcu_usb_printf>
c0d050a4:	4812      	ldr	r0, [pc, #72]	; (c0d050f0 <signTx_handleEndAPDU+0x67c>)
c0d050a6:	f7fd f875 	bl	c0d02194 <os_longjmp>
c0d050aa:	4a10      	ldr	r2, [pc, #64]	; (c0d050ec <signTx_handleEndAPDU+0x678>)
		VALIDATE(parsedSize == wireDataSize, ERR_INVALID_DATA);
c0d050ac:	320b      	adds	r2, #11
c0d050ae:	4838      	ldr	r0, [pc, #224]	; (c0d05190 <signTx_handleEndAPDU+0x71c>)
c0d050b0:	4478      	add	r0, pc
c0d050b2:	4938      	ldr	r1, [pc, #224]	; (c0d05194 <signTx_handleEndAPDU+0x720>)
c0d050b4:	4479      	add	r1, pc
c0d050b6:	f7fd fdc5 	bl	c0d02c44 <mcu_usb_printf>
c0d050ba:	480d      	ldr	r0, [pc, #52]	; (c0d050f0 <signTx_handleEndAPDU+0x67c>)
c0d050bc:	1c80      	adds	r0, r0, #2
c0d050be:	f7fd f869 	bl	c0d02194 <os_longjmp>
c0d050c2:	4a0a      	ldr	r2, [pc, #40]	; (c0d050ec <signTx_handleEndAPDU+0x678>)
			TRACE("Hash NOT ALLOWED");
c0d050c4:	323d      	adds	r2, #61	; 0x3d
c0d050c6:	4834      	ldr	r0, [pc, #208]	; (c0d05198 <signTx_handleEndAPDU+0x724>)
c0d050c8:	4478      	add	r0, pc
c0d050ca:	4934      	ldr	r1, [pc, #208]	; (c0d0519c <signTx_handleEndAPDU+0x728>)
c0d050cc:	4479      	add	r1, pc
c0d050ce:	f7fd fdb9 	bl	c0d02c44 <mcu_usb_printf>
c0d050d2:	4833      	ldr	r0, [pc, #204]	; (c0d051a0 <signTx_handleEndAPDU+0x72c>)
c0d050d4:	4478      	add	r0, pc
c0d050d6:	f7fd fdb5 	bl	c0d02c44 <mcu_usb_printf>
c0d050da:	4832      	ldr	r0, [pc, #200]	; (c0d051a4 <signTx_handleEndAPDU+0x730>)
c0d050dc:	4478      	add	r0, pc
c0d050de:	f7fd fdb1 	bl	c0d02c44 <mcu_usb_printf>
c0d050e2:	2009      	movs	r0, #9
c0d050e4:	02c0      	lsls	r0, r0, #11
			THROW(ERR_HASH_NOT_ALLOWED);
c0d050e6:	f7fd f855 	bl	c0d02194 <os_longjmp>
c0d050ea:	46c0      	nop			; (mov r8, r8)
c0d050ec:	0000028d 	.word	0x0000028d
c0d050f0:	00006e05 	.word	0x00006e05
c0d050f4:	20000490 	.word	0x20000490
c0d050f8:	00003039 	.word	0x00003039
c0d050fc:	20000285 	.word	0x20000285
c0d05100:	00000841 	.word	0x00000841
c0d05104:	00004906 	.word	0x00004906
c0d05108:	0000490a 	.word	0x0000490a
c0d0510c:	00003c63 	.word	0x00003c63
c0d05110:	000047a1 	.word	0x000047a1
c0d05114:	000047aa 	.word	0x000047aa
c0d05118:	000047b2 	.word	0x000047b2
c0d0511c:	00003c56 	.word	0x00003c56
c0d05120:	0000477b 	.word	0x0000477b
c0d05124:	0000492d 	.word	0x0000492d
c0d05128:	00003bd3 	.word	0x00003bd3
c0d0512c:	00004711 	.word	0x00004711
c0d05130:	0000473d 	.word	0x0000473d
c0d05134:	00004722 	.word	0x00004722
c0d05138:	0000471c 	.word	0x0000471c
c0d0513c:	00003b98 	.word	0x00003b98
c0d05140:	00004797 	.word	0x00004797
c0d05144:	000039c1 	.word	0x000039c1
c0d05148:	000044ff 	.word	0x000044ff
c0d0514c:	000039d6 	.word	0x000039d6
c0d05150:	00004510 	.word	0x00004510
c0d05154:	0000397b 	.word	0x0000397b
c0d05158:	000044b9 	.word	0x000044b9
c0d0515c:	00003990 	.word	0x00003990
c0d05160:	000044ca 	.word	0x000044ca
c0d05164:	0000394b 	.word	0x0000394b
c0d05168:	00004489 	.word	0x00004489
c0d0516c:	000044d4 	.word	0x000044d4
c0d05170:	0000449a 	.word	0x0000449a
c0d05174:	00003afd 	.word	0x00003afd
c0d05178:	0000463b 	.word	0x0000463b
c0d0517c:	000046d2 	.word	0x000046d2
c0d05180:	0000464c 	.word	0x0000464c
c0d05184:	00003af0 	.word	0x00003af0
c0d05188:	00003566 	.word	0x00003566
c0d0518c:	0000431f 	.word	0x0000431f
c0d05190:	0000354e 	.word	0x0000354e
c0d05194:	00004307 	.word	0x00004307
c0d05198:	000038f7 	.word	0x000038f7
c0d0519c:	00004435 	.word	0x00004435
c0d051a0:	00004454 	.word	0x00004454
c0d051a4:	0000444a 	.word	0x0000444a

c0d051a8 <signTransaction_handleAPDU>:
	uint8_t p1,
	uint8_t p2,
	uint8_t *wireDataBuffer,
	size_t wireDataSize,
	bool isNewCall)
{
c0d051a8:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d051aa:	b083      	sub	sp, #12
c0d051ac:	9302      	str	r3, [sp, #8]
c0d051ae:	9201      	str	r2, [sp, #4]
c0d051b0:	460e      	mov	r6, r1
c0d051b2:	4604      	mov	r4, r0
	TRACE("P1 = 0x%x, P2 = 0x%x, isNewCall = %d", p1, p2, isNewCall);
c0d051b4:	4831      	ldr	r0, [pc, #196]	; (c0d0527c <signTransaction_handleAPDU+0xd4>)
c0d051b6:	4478      	add	r0, pc
c0d051b8:	4931      	ldr	r1, [pc, #196]	; (c0d05280 <signTransaction_handleAPDU+0xd8>)
c0d051ba:	4479      	add	r1, pc
c0d051bc:	4f2c      	ldr	r7, [pc, #176]	; (c0d05270 <signTransaction_handleAPDU+0xc8>)
c0d051be:	463a      	mov	r2, r7
c0d051c0:	f7fd fd40 	bl	c0d02c44 <mcu_usb_printf>
c0d051c4:	482f      	ldr	r0, [pc, #188]	; (c0d05284 <signTransaction_handleAPDU+0xdc>)
c0d051c6:	4478      	add	r0, pc
c0d051c8:	9d08      	ldr	r5, [sp, #32]
c0d051ca:	4621      	mov	r1, r4
c0d051cc:	4632      	mov	r2, r6
c0d051ce:	462b      	mov	r3, r5
c0d051d0:	f7fd fd38 	bl	c0d02c44 <mcu_usb_printf>
c0d051d4:	482c      	ldr	r0, [pc, #176]	; (c0d05288 <signTransaction_handleAPDU+0xe0>)
c0d051d6:	4478      	add	r0, pc
c0d051d8:	f7fd fd34 	bl	c0d02c44 <mcu_usb_printf>

	if (isNewCall)
c0d051dc:	2d00      	cmp	r5, #0
c0d051de:	d004      	beq.n	c0d051ea <signTransaction_handleAPDU+0x42>
	{
		explicit_bzero(ctx, SIZEOF(*ctx));
c0d051e0:	4639      	mov	r1, r7
c0d051e2:	3183      	adds	r1, #131	; 0x83
c0d051e4:	4823      	ldr	r0, [pc, #140]	; (c0d05274 <signTransaction_handleAPDU+0xcc>)
c0d051e6:	f003 f9a5 	bl	c0d08534 <explicit_bzero>
	switch (p1)
c0d051ea:	2c09      	cmp	r4, #9
c0d051ec:	dd08      	ble.n	c0d05200 <signTransaction_handleAPDU+0x58>
c0d051ee:	2c0b      	cmp	r4, #11
c0d051f0:	dd12      	ble.n	c0d05218 <signTransaction_handleAPDU+0x70>
c0d051f2:	2c0c      	cmp	r4, #12
c0d051f4:	d015      	beq.n	c0d05222 <signTransaction_handleAPDU+0x7a>
c0d051f6:	2c0d      	cmp	r4, #13
c0d051f8:	d120      	bne.n	c0d0523c <signTransaction_handleAPDU+0x94>
c0d051fa:	4b2c      	ldr	r3, [pc, #176]	; (c0d052ac <signTransaction_handleAPDU+0x104>)
c0d051fc:	447b      	add	r3, pc
c0d051fe:	e026      	b.n	c0d0524e <signTransaction_handleAPDU+0xa6>
c0d05200:	2c06      	cmp	r4, #6
c0d05202:	dc04      	bgt.n	c0d0520e <signTransaction_handleAPDU+0x66>
c0d05204:	2c01      	cmp	r4, #1
c0d05206:	d10f      	bne.n	c0d05228 <signTransaction_handleAPDU+0x80>
c0d05208:	4b20      	ldr	r3, [pc, #128]	; (c0d0528c <signTransaction_handleAPDU+0xe4>)
c0d0520a:	447b      	add	r3, pc
c0d0520c:	e01f      	b.n	c0d0524e <signTransaction_handleAPDU+0xa6>
c0d0520e:	2c07      	cmp	r4, #7
c0d05210:	d10f      	bne.n	c0d05232 <signTransaction_handleAPDU+0x8a>
c0d05212:	4b23      	ldr	r3, [pc, #140]	; (c0d052a0 <signTransaction_handleAPDU+0xf8>)
c0d05214:	447b      	add	r3, pc
c0d05216:	e01a      	b.n	c0d0524e <signTransaction_handleAPDU+0xa6>
c0d05218:	2c0a      	cmp	r4, #10
c0d0521a:	d114      	bne.n	c0d05246 <signTransaction_handleAPDU+0x9e>
c0d0521c:	4b21      	ldr	r3, [pc, #132]	; (c0d052a4 <signTransaction_handleAPDU+0xfc>)
c0d0521e:	447b      	add	r3, pc
c0d05220:	e015      	b.n	c0d0524e <signTransaction_handleAPDU+0xa6>
c0d05222:	4b21      	ldr	r3, [pc, #132]	; (c0d052a8 <signTransaction_handleAPDU+0x100>)
c0d05224:	447b      	add	r3, pc
c0d05226:	e012      	b.n	c0d0524e <signTransaction_handleAPDU+0xa6>
c0d05228:	2c06      	cmp	r4, #6
c0d0522a:	d116      	bne.n	c0d0525a <signTransaction_handleAPDU+0xb2>
c0d0522c:	4b1b      	ldr	r3, [pc, #108]	; (c0d0529c <signTransaction_handleAPDU+0xf4>)
c0d0522e:	447b      	add	r3, pc
c0d05230:	e00d      	b.n	c0d0524e <signTransaction_handleAPDU+0xa6>
c0d05232:	2c09      	cmp	r4, #9
c0d05234:	d111      	bne.n	c0d0525a <signTransaction_handleAPDU+0xb2>
c0d05236:	4b16      	ldr	r3, [pc, #88]	; (c0d05290 <signTransaction_handleAPDU+0xe8>)
c0d05238:	447b      	add	r3, pc
c0d0523a:	e008      	b.n	c0d0524e <signTransaction_handleAPDU+0xa6>
c0d0523c:	2c0e      	cmp	r4, #14
c0d0523e:	d10c      	bne.n	c0d0525a <signTransaction_handleAPDU+0xb2>
c0d05240:	4b15      	ldr	r3, [pc, #84]	; (c0d05298 <signTransaction_handleAPDU+0xf0>)
c0d05242:	447b      	add	r3, pc
c0d05244:	e003      	b.n	c0d0524e <signTransaction_handleAPDU+0xa6>
c0d05246:	2c0b      	cmp	r4, #11
c0d05248:	d107      	bne.n	c0d0525a <signTransaction_handleAPDU+0xb2>
c0d0524a:	4b12      	ldr	r3, [pc, #72]	; (c0d05294 <signTransaction_handleAPDU+0xec>)
c0d0524c:	447b      	add	r3, pc
c0d0524e:	9a02      	ldr	r2, [sp, #8]
c0d05250:	9901      	ldr	r1, [sp, #4]
	}

	subhandler_fn_t *subhandler = lookup_subhandler(p1);
	VALIDATE(subhandler != NULL, ERR_INVALID_REQUEST_PARAMETERS);
	subhandler(p2, wireDataBuffer, wireDataSize);
c0d05252:	4630      	mov	r0, r6
c0d05254:	4798      	blx	r3
}
c0d05256:	b003      	add	sp, #12
c0d05258:	bdf0      	pop	{r4, r5, r6, r7, pc}
	VALIDATE(subhandler != NULL, ERR_INVALID_REQUEST_PARAMETERS);
c0d0525a:	3708      	adds	r7, #8
c0d0525c:	4814      	ldr	r0, [pc, #80]	; (c0d052b0 <signTransaction_handleAPDU+0x108>)
c0d0525e:	4478      	add	r0, pc
c0d05260:	4914      	ldr	r1, [pc, #80]	; (c0d052b4 <signTransaction_handleAPDU+0x10c>)
c0d05262:	4479      	add	r1, pc
c0d05264:	463a      	mov	r2, r7
c0d05266:	f7fd fced 	bl	c0d02c44 <mcu_usb_printf>
c0d0526a:	4803      	ldr	r0, [pc, #12]	; (c0d05278 <signTransaction_handleAPDU+0xd0>)
c0d0526c:	f7fc ff92 	bl	c0d02194 <os_longjmp>
c0d05270:	00000345 	.word	0x00000345
c0d05274:	20000490 	.word	0x20000490
c0d05278:	00006e05 	.word	0x00006e05
c0d0527c:	00003809 	.word	0x00003809
c0d05280:	00004403 	.word	0x00004403
c0d05284:	00004412 	.word	0x00004412
c0d05288:	00004350 	.word	0x00004350
c0d0528c:	ffffe2d7 	.word	0xffffe2d7
c0d05290:	ffffe3c9 	.word	0xffffe3c9
c0d05294:	ffffed3d 	.word	0xffffed3d
c0d05298:	fffff4e3 	.word	0xfffff4e3
c0d0529c:	fffff843 	.word	0xfffff843
c0d052a0:	ffffe881 	.word	0xffffe881
c0d052a4:	ffffe66b 	.word	0xffffe66b
c0d052a8:	fffff075 	.word	0xfffff075
c0d052ac:	fffff32d 	.word	0xfffff32d
c0d052b0:	000033a0 	.word	0x000033a0
c0d052b4:	00004159 	.word	0x00004159

c0d052b8 <signTx_handleSendData_ui_runStep>:
{
c0d052b8:	b570      	push	{r4, r5, r6, lr}
c0d052ba:	b082      	sub	sp, #8
c0d052bc:	2001      	movs	r0, #1
c0d052be:	0204      	lsls	r4, r0, #8
	UI_STEP_BEGIN(ctx->ui_step, this_fn);
c0d052c0:	4d26      	ldr	r5, [pc, #152]	; (c0d0535c <signTx_handleSendData_ui_runStep+0xa4>)
c0d052c2:	5928      	ldr	r0, [r5, r4]
c0d052c4:	217d      	movs	r1, #125	; 0x7d
c0d052c6:	0089      	lsls	r1, r1, #2
c0d052c8:	4288      	cmp	r0, r1
c0d052ca:	d007      	beq.n	c0d052dc <signTx_handleSendData_ui_runStep+0x24>
c0d052cc:	26ff      	movs	r6, #255	; 0xff
c0d052ce:	36f6      	adds	r6, #246	; 0xf6
c0d052d0:	42b0      	cmp	r0, r6
c0d052d2:	d113      	bne.n	c0d052fc <signTx_handleSendData_ui_runStep+0x44>
		respondSuccessEmptyMsg();
c0d052d4:	f7fe f8e4 	bl	c0d034a0 <respondSuccessEmptyMsg>
c0d052d8:	1c70      	adds	r0, r6, #1
c0d052da:	e039      	b.n	c0d05350 <signTx_handleSendData_ui_runStep+0x98>
c0d052dc:	2009      	movs	r0, #9
c0d052de:	0140      	lsls	r0, r0, #5
		if (ctx->encoding == ENCODING_STRING)
c0d052e0:	5c28      	ldrb	r0, [r5, r0]
c0d052e2:	2896      	cmp	r0, #150	; 0x96
c0d052e4:	d112      	bne.n	c0d0530c <signTx_handleSendData_ui_runStep+0x54>
c0d052e6:	2021      	movs	r0, #33	; 0x21
c0d052e8:	00c0      	lsls	r0, r0, #3
			ui_displayPaginatedText(ctx->headerBuf, ctx->bodyBuf, this_fn);
c0d052ea:	5829      	ldr	r1, [r5, r0]
c0d052ec:	2041      	movs	r0, #65	; 0x41
c0d052ee:	0080      	lsls	r0, r0, #2
c0d052f0:	5828      	ldr	r0, [r5, r0]
c0d052f2:	4a1d      	ldr	r2, [pc, #116]	; (c0d05368 <signTx_handleSendData_ui_runStep+0xb0>)
c0d052f4:	447a      	add	r2, pc
c0d052f6:	f001 f929 	bl	c0d0654c <ui_displayPaginatedText>
c0d052fa:	e027      	b.n	c0d0534c <signTx_handleSendData_ui_runStep+0x94>
	UI_STEP_BEGIN(ctx->ui_step, this_fn);
c0d052fc:	4819      	ldr	r0, [pc, #100]	; (c0d05364 <signTx_handleSendData_ui_runStep+0xac>)
c0d052fe:	4478      	add	r0, pc
c0d05300:	1c41      	adds	r1, r0, #1
c0d05302:	2000      	movs	r0, #0
c0d05304:	f7fa feb4 	bl	c0d00070 <assert>
c0d05308:	1e70      	subs	r0, r6, #1
c0d0530a:	e021      	b.n	c0d05350 <signTx_handleSendData_ui_runStep+0x98>
		else if (ENCODING_UINT8 <= ctx->encoding && ctx->encoding <= ENCODING_UINT64)
c0d0530c:	4601      	mov	r1, r0
c0d0530e:	3169      	adds	r1, #105	; 0x69
c0d05310:	b2c9      	uxtb	r1, r1
c0d05312:	2903      	cmp	r1, #3
c0d05314:	d80d      	bhi.n	c0d05332 <signTx_handleSendData_ui_runStep+0x7a>
c0d05316:	2023      	movs	r0, #35	; 0x23
c0d05318:	00c1      	lsls	r1, r0, #3
			ui_displayUint64Screen(ctx->headerBuf, ctx->uint64Body, this_fn);
c0d0531a:	586a      	ldr	r2, [r5, r1]
c0d0531c:	2041      	movs	r0, #65	; 0x41
c0d0531e:	0080      	lsls	r0, r0, #2
c0d05320:	5828      	ldr	r0, [r5, r0]
c0d05322:	1869      	adds	r1, r5, r1
c0d05324:	684b      	ldr	r3, [r1, #4]
c0d05326:	4911      	ldr	r1, [pc, #68]	; (c0d0536c <signTx_handleSendData_ui_runStep+0xb4>)
c0d05328:	4479      	add	r1, pc
c0d0532a:	9100      	str	r1, [sp, #0]
c0d0532c:	f001 fd0a 	bl	c0d06d44 <ui_displayUint64Screen>
c0d05330:	e00c      	b.n	c0d0534c <signTx_handleSendData_ui_runStep+0x94>
		else if (ctx->encoding == ENCODING_HEX)
c0d05332:	289b      	cmp	r0, #155	; 0x9b
c0d05334:	d10f      	bne.n	c0d05356 <signTx_handleSendData_ui_runStep+0x9e>
c0d05336:	2021      	movs	r0, #33	; 0x21
c0d05338:	00c0      	lsls	r0, r0, #3
				ctx->bodyBuf,
c0d0533a:	5829      	ldr	r1, [r5, r0]
c0d0533c:	2041      	movs	r0, #65	; 0x41
c0d0533e:	0080      	lsls	r0, r0, #2
				ctx->headerBuf,
c0d05340:	5828      	ldr	r0, [r5, r0]
c0d05342:	2204      	movs	r2, #4
			ui_displayHexBufferScreen(
c0d05344:	4b0a      	ldr	r3, [pc, #40]	; (c0d05370 <signTx_handleSendData_ui_runStep+0xb8>)
c0d05346:	447b      	add	r3, pc
c0d05348:	f001 fd0e 	bl	c0d06d68 <ui_displayHexBufferScreen>
c0d0534c:	20ff      	movs	r0, #255	; 0xff
c0d0534e:	30f6      	adds	r0, #246	; 0xf6
c0d05350:	5128      	str	r0, [r5, r4]
}
c0d05352:	b002      	add	sp, #8
c0d05354:	bd70      	pop	{r4, r5, r6, pc}
c0d05356:	4802      	ldr	r0, [pc, #8]	; (c0d05360 <signTx_handleSendData_ui_runStep+0xa8>)
			THROW(ERR_NOT_IMPLEMENTED);
c0d05358:	f7fc ff1c 	bl	c0d02194 <os_longjmp>
c0d0535c:	20000490 	.word	0x20000490
c0d05360:	00004701 	.word	0x00004701
c0d05364:	00004338 	.word	0x00004338
c0d05368:	ffffffc1 	.word	0xffffffc1
c0d0536c:	ffffff8d 	.word	0xffffff8d
c0d05370:	ffffff6f 	.word	0xffffff6f

c0d05374 <signTx_handleEnd_ui_runStep>:
{
c0d05374:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d05376:	b083      	sub	sp, #12
c0d05378:	2001      	movs	r0, #1
c0d0537a:	0207      	lsls	r7, r0, #8
	UI_STEP_BEGIN(ctx->ui_step, this_fn);
c0d0537c:	4e36      	ldr	r6, [pc, #216]	; (c0d05458 <signTx_handleEnd_ui_runStep+0xe4>)
c0d0537e:	59f0      	ldr	r0, [r6, r7]
c0d05380:	2519      	movs	r5, #25
c0d05382:	012c      	lsls	r4, r5, #4
c0d05384:	42a0      	cmp	r0, r4
c0d05386:	d050      	beq.n	c0d0542a <signTx_handleEnd_ui_runStep+0xb6>
c0d05388:	21ff      	movs	r1, #255	; 0xff
c0d0538a:	3192      	adds	r1, #146	; 0x92
c0d0538c:	4288      	cmp	r0, r1
c0d0538e:	d159      	bne.n	c0d05444 <signTx_handleEnd_ui_runStep+0xd0>
c0d05390:	012e      	lsls	r6, r5, #4
		TRACE("\n\nResponding\n");
c0d05392:	4632      	mov	r2, r6
c0d05394:	32ea      	adds	r2, #234	; 0xea
c0d05396:	4d37      	ldr	r5, [pc, #220]	; (c0d05474 <signTx_handleEnd_ui_runStep+0x100>)
c0d05398:	447d      	add	r5, pc
c0d0539a:	4937      	ldr	r1, [pc, #220]	; (c0d05478 <signTx_handleEnd_ui_runStep+0x104>)
c0d0539c:	4479      	add	r1, pc
c0d0539e:	9102      	str	r1, [sp, #8]
c0d053a0:	4628      	mov	r0, r5
c0d053a2:	f7fd fc4f 	bl	c0d02c44 <mcu_usb_printf>
c0d053a6:	4835      	ldr	r0, [pc, #212]	; (c0d0547c <signTx_handleEnd_ui_runStep+0x108>)
c0d053a8:	4478      	add	r0, pc
c0d053aa:	f7fd fc4b 	bl	c0d02c44 <mcu_usb_printf>
c0d053ae:	4834      	ldr	r0, [pc, #208]	; (c0d05480 <signTx_handleEnd_ui_runStep+0x10c>)
c0d053b0:	4478      	add	r0, pc
c0d053b2:	9000      	str	r0, [sp, #0]
c0d053b4:	f7fd fc46 	bl	c0d02c44 <mcu_usb_printf>
c0d053b8:	2009      	movs	r0, #9
c0d053ba:	0300      	lsls	r0, r0, #12
		io_send_buf(SUCCESS, G_io_apdu_buffer, 65 + 32);
c0d053bc:	4927      	ldr	r1, [pc, #156]	; (c0d0545c <signTx_handleEnd_ui_runStep+0xe8>)
c0d053be:	2261      	movs	r2, #97	; 0x61
c0d053c0:	f7fb fee2 	bl	c0d01188 <io_send_buf>
		TRACE("sent SUCCESS");
c0d053c4:	4632      	mov	r2, r6
c0d053c6:	32ec      	adds	r2, #236	; 0xec
c0d053c8:	4628      	mov	r0, r5
c0d053ca:	9c02      	ldr	r4, [sp, #8]
c0d053cc:	4621      	mov	r1, r4
c0d053ce:	f7fd fc39 	bl	c0d02c44 <mcu_usb_printf>
c0d053d2:	482c      	ldr	r0, [pc, #176]	; (c0d05484 <signTx_handleEnd_ui_runStep+0x110>)
c0d053d4:	4478      	add	r0, pc
c0d053d6:	f7fd fc35 	bl	c0d02c44 <mcu_usb_printf>
c0d053da:	9701      	str	r7, [sp, #4]
c0d053dc:	9f00      	ldr	r7, [sp, #0]
c0d053de:	4638      	mov	r0, r7
c0d053e0:	f7fd fc30 	bl	c0d02c44 <mcu_usb_printf>
		ui_displayBusy(); // needs to happen after I/O
c0d053e4:	f001 fab6 	bl	c0d06954 <ui_displayBusy>
		TRACE("going to ui_idle()");
c0d053e8:	4632      	mov	r2, r6
c0d053ea:	32ee      	adds	r2, #238	; 0xee
c0d053ec:	4628      	mov	r0, r5
c0d053ee:	4621      	mov	r1, r4
c0d053f0:	f7fd fc28 	bl	c0d02c44 <mcu_usb_printf>
c0d053f4:	4824      	ldr	r0, [pc, #144]	; (c0d05488 <signTx_handleEnd_ui_runStep+0x114>)
c0d053f6:	4478      	add	r0, pc
c0d053f8:	f7fd fc24 	bl	c0d02c44 <mcu_usb_printf>
c0d053fc:	4638      	mov	r0, r7
c0d053fe:	f7fd fc21 	bl	c0d02c44 <mcu_usb_printf>
		ui_idle();
c0d05402:	f7fc fd57 	bl	c0d01eb4 <ui_idle>
c0d05406:	4634      	mov	r4, r6
		TRACE("ui_idle() done");
c0d05408:	4632      	mov	r2, r6
c0d0540a:	32f0      	adds	r2, #240	; 0xf0
c0d0540c:	4628      	mov	r0, r5
c0d0540e:	9902      	ldr	r1, [sp, #8]
c0d05410:	f7fd fc18 	bl	c0d02c44 <mcu_usb_printf>
c0d05414:	481d      	ldr	r0, [pc, #116]	; (c0d0548c <signTx_handleEnd_ui_runStep+0x118>)
c0d05416:	4478      	add	r0, pc
c0d05418:	f7fd fc14 	bl	c0d02c44 <mcu_usb_printf>
c0d0541c:	4638      	mov	r0, r7
c0d0541e:	9f01      	ldr	r7, [sp, #4]
c0d05420:	4e0d      	ldr	r6, [pc, #52]	; (c0d05458 <signTx_handleEnd_ui_runStep+0xe4>)
c0d05422:	f7fd fc0f 	bl	c0d02c44 <mcu_usb_printf>
c0d05426:	1ca4      	adds	r4, r4, #2
c0d05428:	e012      	b.n	c0d05450 <signTx_handleEnd_ui_runStep+0xdc>
		ui_displayPrompt(
c0d0542a:	480e      	ldr	r0, [pc, #56]	; (c0d05464 <signTx_handleEnd_ui_runStep+0xf0>)
c0d0542c:	4478      	add	r0, pc
c0d0542e:	490e      	ldr	r1, [pc, #56]	; (c0d05468 <signTx_handleEnd_ui_runStep+0xf4>)
c0d05430:	4479      	add	r1, pc
c0d05432:	4a0e      	ldr	r2, [pc, #56]	; (c0d0546c <signTx_handleEnd_ui_runStep+0xf8>)
c0d05434:	447a      	add	r2, pc
c0d05436:	4b0e      	ldr	r3, [pc, #56]	; (c0d05470 <signTx_handleEnd_ui_runStep+0xfc>)
c0d05438:	447b      	add	r3, pc
c0d0543a:	f000 ffcb 	bl	c0d063d4 <ui_displayPrompt>
c0d0543e:	0128      	lsls	r0, r5, #4
c0d05440:	1c44      	adds	r4, r0, #1
c0d05442:	e005      	b.n	c0d05450 <signTx_handleEnd_ui_runStep+0xdc>
	UI_STEP_BEGIN(ctx->ui_step, this_fn);
c0d05444:	4806      	ldr	r0, [pc, #24]	; (c0d05460 <signTx_handleEnd_ui_runStep+0xec>)
c0d05446:	4478      	add	r0, pc
c0d05448:	1c41      	adds	r1, r0, #1
c0d0544a:	2000      	movs	r0, #0
c0d0544c:	f7fa fe10 	bl	c0d00070 <assert>
c0d05450:	51f4      	str	r4, [r6, r7]
}
c0d05452:	b003      	add	sp, #12
c0d05454:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d05456:	46c0      	nop			; (mov r8, r8)
c0d05458:	20000490 	.word	0x20000490
c0d0545c:	20000285 	.word	0x20000285
c0d05460:	0000420a 	.word	0x0000420a
c0d05464:	0000423e 	.word	0x0000423e
c0d05468:	0000423f 	.word	0x0000423f
c0d0546c:	ffffff3d 	.word	0xffffff3d
c0d05470:	000012dd 	.word	0x000012dd
c0d05474:	00003627 	.word	0x00003627
c0d05478:	000042e0 	.word	0x000042e0
c0d0547c:	000042f0 	.word	0x000042f0
c0d05480:	00004176 	.word	0x00004176
c0d05484:	000042d2 	.word	0x000042d2
c0d05488:	000042bd 	.word	0x000042bd
c0d0548c:	000042b0 	.word	0x000042b0

c0d05490 <SVC_Call>:
.thumb
.thumb_func
.global SVC_Call

SVC_Call:
    svc 1
c0d05490:	df01      	svc	1
    cmp r1, #0
c0d05492:	2900      	cmp	r1, #0
    bne exception
c0d05494:	d100      	bne.n	c0d05498 <exception>
    bx lr
c0d05496:	4770      	bx	lr

c0d05498 <exception>:
exception:
    // THROW(ex);
    mov r0, r1
c0d05498:	4608      	mov	r0, r1
    bl os_longjmp
c0d0549a:	f7fc fe7b 	bl	c0d02194 <os_longjmp>
	...

c0d054a0 <get_api_level>:
#include <string.h>

unsigned int SVC_Call(unsigned int syscall_id, void *parameters);
unsigned int SVC_cx_call(unsigned int syscall_id, unsigned int * parameters);

unsigned int get_api_level(void) {
c0d054a0:	b580      	push	{r7, lr}
c0d054a2:	b084      	sub	sp, #16
c0d054a4:	2000      	movs	r0, #0
  unsigned int parameters [2+1];
  parameters[0] = 0;
  parameters[1] = 0;
c0d054a6:	9002      	str	r0, [sp, #8]
  parameters[0] = 0;
c0d054a8:	9001      	str	r0, [sp, #4]
c0d054aa:	4803      	ldr	r0, [pc, #12]	; (c0d054b8 <get_api_level+0x18>)
c0d054ac:	a901      	add	r1, sp, #4
  return SVC_Call(SYSCALL_get_api_level_ID_IN, parameters);
c0d054ae:	f7ff ffef 	bl	c0d05490 <SVC_Call>
c0d054b2:	b004      	add	sp, #16
c0d054b4:	bd80      	pop	{r7, pc}
c0d054b6:	46c0      	nop			; (mov r8, r8)
c0d054b8:	60000138 	.word	0x60000138

c0d054bc <halt>:
}

void halt ( void ) {
c0d054bc:	b580      	push	{r7, lr}
c0d054be:	b082      	sub	sp, #8
c0d054c0:	2000      	movs	r0, #0
  unsigned int parameters [2];
  parameters[1] = 0;
c0d054c2:	9001      	str	r0, [sp, #4]
c0d054c4:	4802      	ldr	r0, [pc, #8]	; (c0d054d0 <halt+0x14>)
c0d054c6:	4669      	mov	r1, sp
  SVC_Call(SYSCALL_halt_ID_IN, parameters);
c0d054c8:	f7ff ffe2 	bl	c0d05490 <SVC_Call>
  return;
}
c0d054cc:	b002      	add	sp, #8
c0d054ce:	bd80      	pop	{r7, pc}
c0d054d0:	6000023c 	.word	0x6000023c

c0d054d4 <os_perso_isonboarded>:
  parameters[1] = 0;
  SVC_Call(SYSCALL_os_perso_finalize_ID_IN, parameters);
  return;
}

bolos_bool_t os_perso_isonboarded ( void ) {
c0d054d4:	b580      	push	{r7, lr}
c0d054d6:	b082      	sub	sp, #8
c0d054d8:	2000      	movs	r0, #0
  unsigned int parameters [2];
  parameters[1] = 0;
c0d054da:	9001      	str	r0, [sp, #4]
c0d054dc:	4803      	ldr	r0, [pc, #12]	; (c0d054ec <os_perso_isonboarded+0x18>)
c0d054de:	4669      	mov	r1, sp
  return (bolos_bool_t) SVC_Call(SYSCALL_os_perso_isonboarded_ID_IN, parameters);
c0d054e0:	f7ff ffd6 	bl	c0d05490 <SVC_Call>
c0d054e4:	b2c0      	uxtb	r0, r0
c0d054e6:	b002      	add	sp, #8
c0d054e8:	bd80      	pop	{r7, pc}
c0d054ea:	46c0      	nop			; (mov r8, r8)
c0d054ec:	60009f4f 	.word	0x60009f4f

c0d054f0 <os_perso_derive_node_bip32>:
}

void os_perso_derive_node_bip32 ( cx_curve_t curve, const unsigned int * path, unsigned int pathLength, unsigned char * privateKey, unsigned char * chain ) {
c0d054f0:	b510      	push	{r4, lr}
c0d054f2:	b088      	sub	sp, #32
c0d054f4:	9c0a      	ldr	r4, [sp, #40]	; 0x28
  unsigned int parameters [2+5];
  parameters[0] = (unsigned int)curve;
  parameters[1] = (unsigned int)path;
  parameters[2] = (unsigned int)pathLength;
  parameters[3] = (unsigned int)privateKey;
  parameters[4] = (unsigned int)chain;
c0d054f6:	9405      	str	r4, [sp, #20]
  parameters[3] = (unsigned int)privateKey;
c0d054f8:	9304      	str	r3, [sp, #16]
  parameters[2] = (unsigned int)pathLength;
c0d054fa:	9203      	str	r2, [sp, #12]
  parameters[1] = (unsigned int)path;
c0d054fc:	9102      	str	r1, [sp, #8]
  parameters[0] = (unsigned int)curve;
c0d054fe:	9001      	str	r0, [sp, #4]
c0d05500:	4802      	ldr	r0, [pc, #8]	; (c0d0550c <os_perso_derive_node_bip32+0x1c>)
c0d05502:	a901      	add	r1, sp, #4
  SVC_Call(SYSCALL_os_perso_derive_node_bip32_ID_IN, parameters);
c0d05504:	f7ff ffc4 	bl	c0d05490 <SVC_Call>
  return;
}
c0d05508:	b008      	add	sp, #32
c0d0550a:	bd10      	pop	{r4, pc}
c0d0550c:	600053ba 	.word	0x600053ba

c0d05510 <os_perso_seed_cookie>:
  parameters[3] = (unsigned int)privateKey;
  SVC_Call(SYSCALL_os_perso_derive_eip2333_ID_IN, parameters);
  return;
}

unsigned int os_perso_seed_cookie ( unsigned char * seed_cookie, unsigned int seed_cookie_length ) {
c0d05510:	b580      	push	{r7, lr}
c0d05512:	b084      	sub	sp, #16
  unsigned int parameters [2+2];
  parameters[0] = (unsigned int)seed_cookie;
  parameters[1] = (unsigned int)seed_cookie_length;
c0d05514:	9101      	str	r1, [sp, #4]
  parameters[0] = (unsigned int)seed_cookie;
c0d05516:	9000      	str	r0, [sp, #0]
c0d05518:	4802      	ldr	r0, [pc, #8]	; (c0d05524 <os_perso_seed_cookie+0x14>)
c0d0551a:	4669      	mov	r1, sp
  return (unsigned int) SVC_Call(SYSCALL_os_perso_seed_cookie_ID_IN, parameters);
c0d0551c:	f7ff ffb8 	bl	c0d05490 <SVC_Call>
c0d05520:	b004      	add	sp, #16
c0d05522:	bd80      	pop	{r7, pc}
c0d05524:	6000a8fc 	.word	0x6000a8fc

c0d05528 <os_global_pin_is_validated>:
  parameters[1] = (unsigned int)length;
  SVC_Call(SYSCALL_os_perso_set_current_identity_pin_ID_IN, parameters);
  return;
}

bolos_bool_t os_global_pin_is_validated ( void ) {
c0d05528:	b580      	push	{r7, lr}
c0d0552a:	b082      	sub	sp, #8
c0d0552c:	2000      	movs	r0, #0
  unsigned int parameters [2];
  parameters[1] = 0;
c0d0552e:	9001      	str	r0, [sp, #4]
c0d05530:	4803      	ldr	r0, [pc, #12]	; (c0d05540 <os_global_pin_is_validated+0x18>)
c0d05532:	4669      	mov	r1, sp
  return (bolos_bool_t) SVC_Call(SYSCALL_os_global_pin_is_validated_ID_IN, parameters);
c0d05534:	f7ff ffac 	bl	c0d05490 <SVC_Call>
c0d05538:	b2c0      	uxtb	r0, r0
c0d0553a:	b002      	add	sp, #8
c0d0553c:	bd80      	pop	{r7, pc}
c0d0553e:	46c0      	nop			; (mov r8, r8)
c0d05540:	6000a03c 	.word	0x6000a03c

c0d05544 <os_ux>:
  parameters[1] = (unsigned int)out_application_entry;
  SVC_Call(SYSCALL_os_registry_get_ID_IN, parameters);
  return;
}

unsigned int os_ux ( bolos_ux_params_t * params ) {
c0d05544:	b580      	push	{r7, lr}
c0d05546:	b084      	sub	sp, #16
c0d05548:	2100      	movs	r1, #0
  unsigned int parameters [2+1];
  parameters[0] = (unsigned int)params;
  parameters[1] = 0;
c0d0554a:	9102      	str	r1, [sp, #8]
  parameters[0] = (unsigned int)params;
c0d0554c:	9001      	str	r0, [sp, #4]
c0d0554e:	4803      	ldr	r0, [pc, #12]	; (c0d0555c <os_ux+0x18>)
c0d05550:	a901      	add	r1, sp, #4
  return (unsigned int) SVC_Call(SYSCALL_os_ux_ID_IN, parameters);
c0d05552:	f7ff ff9d 	bl	c0d05490 <SVC_Call>
c0d05556:	b004      	add	sp, #16
c0d05558:	bd80      	pop	{r7, pc}
c0d0555a:	46c0      	nop			; (mov r8, r8)
c0d0555c:	60006458 	.word	0x60006458

c0d05560 <os_flags>:
  parameters[1] = 0;
  SVC_Call(SYSCALL_os_lib_end_ID_IN, parameters);
  return;
}

unsigned int os_flags ( void ) {
c0d05560:	b580      	push	{r7, lr}
c0d05562:	b082      	sub	sp, #8
c0d05564:	2000      	movs	r0, #0
  unsigned int parameters [2];
  parameters[1] = 0;
c0d05566:	9001      	str	r0, [sp, #4]
c0d05568:	4802      	ldr	r0, [pc, #8]	; (c0d05574 <os_flags+0x14>)
c0d0556a:	4669      	mov	r1, sp
  return (unsigned int) SVC_Call(SYSCALL_os_flags_ID_IN, parameters);
c0d0556c:	f7ff ff90 	bl	c0d05490 <SVC_Call>
c0d05570:	b002      	add	sp, #8
c0d05572:	bd80      	pop	{r7, pc}
c0d05574:	60006a6e 	.word	0x60006a6e

c0d05578 <os_serial>:
  parameters[0] = (unsigned int)version;
  parameters[1] = (unsigned int)maxlength;
  return (unsigned int) SVC_Call(SYSCALL_os_version_ID_IN, parameters);
}

unsigned int os_serial ( unsigned char * serial, unsigned int maxlength ) {
c0d05578:	b580      	push	{r7, lr}
c0d0557a:	b084      	sub	sp, #16
  unsigned int parameters [2+2];
  parameters[0] = (unsigned int)serial;
  parameters[1] = (unsigned int)maxlength;
c0d0557c:	9101      	str	r1, [sp, #4]
  parameters[0] = (unsigned int)serial;
c0d0557e:	9000      	str	r0, [sp, #0]
c0d05580:	4802      	ldr	r0, [pc, #8]	; (c0d0558c <os_serial+0x14>)
c0d05582:	4669      	mov	r1, sp
  return (unsigned int) SVC_Call(SYSCALL_os_serial_ID_IN, parameters);
c0d05584:	f7ff ff84 	bl	c0d05490 <SVC_Call>
c0d05588:	b004      	add	sp, #16
c0d0558a:	bd80      	pop	{r7, pc}
c0d0558c:	60006cb3 	.word	0x60006cb3

c0d05590 <os_registry_get_current_app_tag>:
  parameters[4] = (unsigned int)buffer;
  parameters[5] = (unsigned int)maxlength;
  return (unsigned int) SVC_Call(SYSCALL_os_registry_get_tag_ID_IN, parameters);
}

unsigned int os_registry_get_current_app_tag ( unsigned int tag, unsigned char * buffer, unsigned int maxlen ) {
c0d05590:	b580      	push	{r7, lr}
c0d05592:	b086      	sub	sp, #24
  unsigned int parameters [2+3];
  parameters[0] = (unsigned int)tag;
c0d05594:	ab01      	add	r3, sp, #4
c0d05596:	c307      	stmia	r3!, {r0, r1, r2}
c0d05598:	4802      	ldr	r0, [pc, #8]	; (c0d055a4 <os_registry_get_current_app_tag+0x14>)
c0d0559a:	a901      	add	r1, sp, #4
  parameters[1] = (unsigned int)buffer;
  parameters[2] = (unsigned int)maxlen;
  return (unsigned int) SVC_Call(SYSCALL_os_registry_get_current_app_tag_ID_IN, parameters);
c0d0559c:	f7ff ff78 	bl	c0d05490 <SVC_Call>
c0d055a0:	b006      	add	sp, #24
c0d055a2:	bd80      	pop	{r7, pc}
c0d055a4:	600074d4 	.word	0x600074d4

c0d055a8 <os_sched_exit>:
  parameters[1] = 0;
  SVC_Call(SYSCALL_os_sched_exec_ID_IN, parameters);
  return;
}

void os_sched_exit ( bolos_task_status_t exit_code ) {
c0d055a8:	b580      	push	{r7, lr}
c0d055aa:	b084      	sub	sp, #16
c0d055ac:	2100      	movs	r1, #0
  unsigned int parameters [2+1];
  parameters[0] = (unsigned int)exit_code;
  parameters[1] = 0;
c0d055ae:	9102      	str	r1, [sp, #8]
  parameters[0] = (unsigned int)exit_code;
c0d055b0:	9001      	str	r0, [sp, #4]
c0d055b2:	4803      	ldr	r0, [pc, #12]	; (c0d055c0 <os_sched_exit+0x18>)
c0d055b4:	a901      	add	r1, sp, #4
  SVC_Call(SYSCALL_os_sched_exit_ID_IN, parameters);
c0d055b6:	f7ff ff6b 	bl	c0d05490 <SVC_Call>
  return;
}
c0d055ba:	b004      	add	sp, #16
c0d055bc:	bd80      	pop	{r7, pc}
c0d055be:	46c0      	nop			; (mov r8, r8)
c0d055c0:	60009abe 	.word	0x60009abe

c0d055c4 <io_seph_send>:
  parameters[1] = 0;
  SVC_Call(SYSCALL_os_sched_kill_ID_IN, parameters);
  return;
}

void io_seph_send ( const unsigned char * buffer, unsigned short length ) {
c0d055c4:	b580      	push	{r7, lr}
c0d055c6:	b084      	sub	sp, #16
  unsigned int parameters [2+2];
  parameters[0] = (unsigned int)buffer;
  parameters[1] = (unsigned int)length;
c0d055c8:	9101      	str	r1, [sp, #4]
  parameters[0] = (unsigned int)buffer;
c0d055ca:	9000      	str	r0, [sp, #0]
c0d055cc:	4802      	ldr	r0, [pc, #8]	; (c0d055d8 <io_seph_send+0x14>)
c0d055ce:	4669      	mov	r1, sp
  SVC_Call(SYSCALL_io_seph_send_ID_IN, parameters);
c0d055d0:	f7ff ff5e 	bl	c0d05490 <SVC_Call>
  return;
}
c0d055d4:	b004      	add	sp, #16
c0d055d6:	bd80      	pop	{r7, pc}
c0d055d8:	60008381 	.word	0x60008381

c0d055dc <io_seph_is_status_sent>:

unsigned int io_seph_is_status_sent ( void ) {
c0d055dc:	b580      	push	{r7, lr}
c0d055de:	b082      	sub	sp, #8
c0d055e0:	2000      	movs	r0, #0
  unsigned int parameters [2];
  parameters[1] = 0;
c0d055e2:	9001      	str	r0, [sp, #4]
c0d055e4:	4802      	ldr	r0, [pc, #8]	; (c0d055f0 <io_seph_is_status_sent+0x14>)
c0d055e6:	4669      	mov	r1, sp
  return (unsigned int) SVC_Call(SYSCALL_io_seph_is_status_sent_ID_IN, parameters);
c0d055e8:	f7ff ff52 	bl	c0d05490 <SVC_Call>
c0d055ec:	b002      	add	sp, #8
c0d055ee:	bd80      	pop	{r7, pc}
c0d055f0:	600084bb 	.word	0x600084bb

c0d055f4 <io_seph_recv>:
}

unsigned short io_seph_recv ( unsigned char * buffer, unsigned short maxlength, unsigned int flags ) {
c0d055f4:	b580      	push	{r7, lr}
c0d055f6:	b086      	sub	sp, #24
  unsigned int parameters [2+3];
  parameters[0] = (unsigned int)buffer;
c0d055f8:	ab01      	add	r3, sp, #4
c0d055fa:	c307      	stmia	r3!, {r0, r1, r2}
c0d055fc:	4803      	ldr	r0, [pc, #12]	; (c0d0560c <io_seph_recv+0x18>)
c0d055fe:	a901      	add	r1, sp, #4
  parameters[1] = (unsigned int)maxlength;
  parameters[2] = (unsigned int)flags;
  return (unsigned short) SVC_Call(SYSCALL_io_seph_recv_ID_IN, parameters);
c0d05600:	f7ff ff46 	bl	c0d05490 <SVC_Call>
c0d05604:	b280      	uxth	r0, r0
c0d05606:	b006      	add	sp, #24
c0d05608:	bd80      	pop	{r7, pc}
c0d0560a:	46c0      	nop			; (mov r8, r8)
c0d0560c:	600085e4 	.word	0x600085e4

c0d05610 <try_context_get>:
  parameters[1] = 0;
  SVC_Call(SYSCALL_nvm_erase_page_ID_IN, parameters);
  return;
}

try_context_t * try_context_get ( void ) {
c0d05610:	b580      	push	{r7, lr}
c0d05612:	b082      	sub	sp, #8
c0d05614:	2000      	movs	r0, #0
  unsigned int parameters [2];
  parameters[1] = 0;
c0d05616:	9001      	str	r0, [sp, #4]
c0d05618:	4802      	ldr	r0, [pc, #8]	; (c0d05624 <try_context_get+0x14>)
c0d0561a:	4669      	mov	r1, sp
  return (try_context_t *) SVC_Call(SYSCALL_try_context_get_ID_IN, parameters);
c0d0561c:	f7ff ff38 	bl	c0d05490 <SVC_Call>
c0d05620:	b002      	add	sp, #8
c0d05622:	bd80      	pop	{r7, pc}
c0d05624:	600087b1 	.word	0x600087b1

c0d05628 <try_context_set>:
}

try_context_t * try_context_set ( try_context_t *context ) {
c0d05628:	b580      	push	{r7, lr}
c0d0562a:	b084      	sub	sp, #16
c0d0562c:	2100      	movs	r1, #0
  unsigned int parameters [2+1];
  parameters[0] = (unsigned int)context;
  parameters[1] = 0;
c0d0562e:	9102      	str	r1, [sp, #8]
  parameters[0] = (unsigned int)context;
c0d05630:	9001      	str	r0, [sp, #4]
c0d05632:	4803      	ldr	r0, [pc, #12]	; (c0d05640 <try_context_set+0x18>)
c0d05634:	a901      	add	r1, sp, #4
  return (try_context_t *) SVC_Call(SYSCALL_try_context_set_ID_IN, parameters);
c0d05636:	f7ff ff2b 	bl	c0d05490 <SVC_Call>
c0d0563a:	b004      	add	sp, #16
c0d0563c:	bd80      	pop	{r7, pc}
c0d0563e:	46c0      	nop			; (mov r8, r8)
c0d05640:	60010b06 	.word	0x60010b06

c0d05644 <os_sched_last_status>:
}

bolos_task_status_t os_sched_last_status ( unsigned int task_idx ) {
c0d05644:	b580      	push	{r7, lr}
c0d05646:	b084      	sub	sp, #16
c0d05648:	2100      	movs	r1, #0
  unsigned int parameters [2+1];
  parameters[0] = (unsigned int)task_idx;
  parameters[1] = 0;
c0d0564a:	9102      	str	r1, [sp, #8]
  parameters[0] = (unsigned int)task_idx;
c0d0564c:	9001      	str	r0, [sp, #4]
c0d0564e:	4803      	ldr	r0, [pc, #12]	; (c0d0565c <os_sched_last_status+0x18>)
c0d05650:	a901      	add	r1, sp, #4
  return (bolos_task_status_t) SVC_Call(SYSCALL_os_sched_last_status_ID_IN, parameters);
c0d05652:	f7ff ff1d 	bl	c0d05490 <SVC_Call>
c0d05656:	b2c0      	uxtb	r0, r0
c0d05658:	b004      	add	sp, #16
c0d0565a:	bd80      	pop	{r7, pc}
c0d0565c:	60009c8b 	.word	0x60009c8b

c0d05660 <str_formatUint64>:

	return rawSize + suffixLength;
}

size_t str_formatUint64(uint64_t number, char* out, size_t outSize)
{
c0d05660:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d05662:	b08f      	sub	sp, #60	; 0x3c
c0d05664:	9201      	str	r2, [sp, #4]
c0d05666:	460e      	mov	r6, r1
c0d05668:	4607      	mov	r7, r0
c0d0566a:	9300      	str	r3, [sp, #0]
	ASSERT(outSize < BUFFER_SIZE_PARANOIA);
c0d0566c:	0a99      	lsrs	r1, r3, #10
c0d0566e:	4248      	negs	r0, r1
c0d05670:	4148      	adcs	r0, r1
c0d05672:	492b      	ldr	r1, [pc, #172]	; (c0d05720 <str_formatUint64+0xc0>)
c0d05674:	4479      	add	r1, pc
c0d05676:	f7fa fcfb 	bl	c0d00070 <assert>
c0d0567a:	a907      	add	r1, sp, #28

	char scratchBuffer[30];
	char* ptr = BEGIN(scratchBuffer);
	char* end = END(scratchBuffer);
c0d0567c:	4608      	mov	r0, r1
c0d0567e:	301e      	adds	r0, #30
c0d05680:	9002      	str	r0, [sp, #8]

	// We print in reverse
	// We want at least one iteration
	int place = 0;
	do {
		WRITE_CHAR(ptr, end, '0' + (number % 10));
c0d05682:	1c4a      	adds	r2, r1, #1
c0d05684:	2400      	movs	r4, #0
c0d05686:	9802      	ldr	r0, [sp, #8]
c0d05688:	4282      	cmp	r2, r0
c0d0568a:	9106      	str	r1, [sp, #24]
c0d0568c:	9205      	str	r2, [sp, #20]
c0d0568e:	d901      	bls.n	c0d05694 <str_formatUint64+0x34>
c0d05690:	4620      	mov	r0, r4
c0d05692:	e000      	b.n	c0d05696 <str_formatUint64+0x36>
c0d05694:	2001      	movs	r0, #1
c0d05696:	4923      	ldr	r1, [pc, #140]	; (c0d05724 <str_formatUint64+0xc4>)
c0d05698:	4479      	add	r1, pc
c0d0569a:	f7fa fce9 	bl	c0d00070 <assert>
c0d0569e:	250a      	movs	r5, #10
		number /= 10;
c0d056a0:	4638      	mov	r0, r7
c0d056a2:	4631      	mov	r1, r6
c0d056a4:	462a      	mov	r2, r5
c0d056a6:	4623      	mov	r3, r4
c0d056a8:	f002 fdec 	bl	c0d08284 <__aeabi_uldivmod>
c0d056ac:	9003      	str	r0, [sp, #12]
c0d056ae:	9604      	str	r6, [sp, #16]
c0d056b0:	460e      	mov	r6, r1
c0d056b2:	462a      	mov	r2, r5
c0d056b4:	4623      	mov	r3, r4
c0d056b6:	f002 fe05 	bl	c0d082c4 <__aeabi_lmul>
c0d056ba:	1a38      	subs	r0, r7, r0
c0d056bc:	2130      	movs	r1, #48	; 0x30
		WRITE_CHAR(ptr, end, '0' + (number % 10));
c0d056be:	4301      	orrs	r1, r0
c0d056c0:	9806      	ldr	r0, [sp, #24]
c0d056c2:	7001      	strb	r1, [r0, #0]
c0d056c4:	2009      	movs	r0, #9
		place++;
	} while (number > 0);
c0d056c6:	1bc0      	subs	r0, r0, r7
c0d056c8:	9804      	ldr	r0, [sp, #16]
c0d056ca:	4184      	sbcs	r4, r0
c0d056cc:	9a05      	ldr	r2, [sp, #20]
c0d056ce:	4611      	mov	r1, r2
c0d056d0:	9f03      	ldr	r7, [sp, #12]
c0d056d2:	d3d6      	bcc.n	c0d05682 <str_formatUint64+0x22>
c0d056d4:	a807      	add	r0, sp, #28

	// Size without terminating character
	STATIC_ASSERT(sizeof(ptr - scratchBuffer) == sizeof(size_t), "bad size_t size");
	size_t rawSize = (size_t) (ptr - scratchBuffer);
c0d056d6:	1a14      	subs	r4, r2, r0

	if (rawSize + 1 > outSize) {
c0d056d8:	1c60      	adds	r0, r4, #1
c0d056da:	9900      	ldr	r1, [sp, #0]
c0d056dc:	4288      	cmp	r0, r1
c0d056de:	d819      	bhi.n	c0d05714 <str_formatUint64+0xb4>
		THROW(ERR_DATA_TOO_LARGE);
	}

	// Copy reversed & append terminator
	for (size_t i = 0; i < rawSize; i++) {
c0d056e0:	2c00      	cmp	r4, #0
c0d056e2:	d008      	beq.n	c0d056f6 <str_formatUint64+0x96>
c0d056e4:	a807      	add	r0, sp, #28
c0d056e6:	1e40      	subs	r0, r0, #1
c0d056e8:	9901      	ldr	r1, [sp, #4]
c0d056ea:	4622      	mov	r2, r4
		out[i] = scratchBuffer[rawSize - 1 - i];
c0d056ec:	5c83      	ldrb	r3, [r0, r2]
c0d056ee:	700b      	strb	r3, [r1, #0]
	for (size_t i = 0; i < rawSize; i++) {
c0d056f0:	1c49      	adds	r1, r1, #1
c0d056f2:	1e52      	subs	r2, r2, #1
c0d056f4:	d1fa      	bne.n	c0d056ec <str_formatUint64+0x8c>
c0d056f6:	2100      	movs	r1, #0
c0d056f8:	9801      	ldr	r0, [sp, #4]
	}
	out[rawSize] = 0;
c0d056fa:	5501      	strb	r1, [r0, r4]

	ASSERT(strlen(out) == rawSize);
c0d056fc:	f002 ff74 	bl	c0d085e8 <strlen>
c0d05700:	1b01      	subs	r1, r0, r4
c0d05702:	4248      	negs	r0, r1
c0d05704:	4148      	adcs	r0, r1
c0d05706:	4908      	ldr	r1, [pc, #32]	; (c0d05728 <str_formatUint64+0xc8>)
c0d05708:	4479      	add	r1, pc
c0d0570a:	f7fa fcb1 	bl	c0d00070 <assert>

	return rawSize;
c0d0570e:	4620      	mov	r0, r4
c0d05710:	b00f      	add	sp, #60	; 0x3c
c0d05712:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d05714:	4801      	ldr	r0, [pc, #4]	; (c0d0571c <str_formatUint64+0xbc>)
		THROW(ERR_DATA_TOO_LARGE);
c0d05716:	f7fc fd3d 	bl	c0d02194 <os_longjmp>
c0d0571a:	46c0      	nop			; (mov r8, r8)
c0d0571c:	00004711 	.word	0x00004711
c0d05720:	00004118 	.word	0x00004118
c0d05724:	00004107 	.word	0x00004107
c0d05728:	000040aa 	.word	0x000040aa

c0d0572c <str_validateTextBuffer>:
}

// check if it is ASCII between 32 and 126
void str_validateTextBuffer(const uint8_t* text, size_t textSize)
{
c0d0572c:	b5b0      	push	{r4, r5, r7, lr}
c0d0572e:	460c      	mov	r4, r1
c0d05730:	4605      	mov	r5, r0
	ASSERT(textSize < BUFFER_SIZE_PARANOIA);
c0d05732:	0a89      	lsrs	r1, r1, #10
c0d05734:	4248      	negs	r0, r1
c0d05736:	4148      	adcs	r0, r1
c0d05738:	4910      	ldr	r1, [pc, #64]	; (c0d0577c <str_validateTextBuffer+0x50>)
c0d0573a:	4479      	add	r1, pc
c0d0573c:	f7fa fc98 	bl	c0d00070 <assert>

	for (size_t i = 0; i < textSize; i++) {
c0d05740:	2c00      	cmp	r4, #0
c0d05742:	d007      	beq.n	c0d05754 <str_validateTextBuffer+0x28>
		VALIDATE(text[i] <= 126, ERR_INVALID_DATA);
c0d05744:	7828      	ldrb	r0, [r5, #0]
c0d05746:	287f      	cmp	r0, #127	; 0x7f
c0d05748:	d205      	bcs.n	c0d05756 <str_validateTextBuffer+0x2a>
		VALIDATE(text[i] >= 32, ERR_INVALID_DATA);
c0d0574a:	281f      	cmp	r0, #31
c0d0574c:	d909      	bls.n	c0d05762 <str_validateTextBuffer+0x36>
	for (size_t i = 0; i < textSize; i++) {
c0d0574e:	1c6d      	adds	r5, r5, #1
c0d05750:	1e64      	subs	r4, r4, #1
c0d05752:	d1f7      	bne.n	c0d05744 <str_validateTextBuffer+0x18>
	}
}
c0d05754:	bdb0      	pop	{r4, r5, r7, pc}
		VALIDATE(text[i] <= 126, ERR_INVALID_DATA);
c0d05756:	480a      	ldr	r0, [pc, #40]	; (c0d05780 <str_validateTextBuffer+0x54>)
c0d05758:	4478      	add	r0, pc
c0d0575a:	490a      	ldr	r1, [pc, #40]	; (c0d05784 <str_validateTextBuffer+0x58>)
c0d0575c:	4479      	add	r1, pc
c0d0575e:	2268      	movs	r2, #104	; 0x68
c0d05760:	e004      	b.n	c0d0576c <str_validateTextBuffer+0x40>
		VALIDATE(text[i] >= 32, ERR_INVALID_DATA);
c0d05762:	4809      	ldr	r0, [pc, #36]	; (c0d05788 <str_validateTextBuffer+0x5c>)
c0d05764:	4478      	add	r0, pc
c0d05766:	4909      	ldr	r1, [pc, #36]	; (c0d0578c <str_validateTextBuffer+0x60>)
c0d05768:	4479      	add	r1, pc
c0d0576a:	2269      	movs	r2, #105	; 0x69
c0d0576c:	f7fd fa6a 	bl	c0d02c44 <mcu_usb_printf>
c0d05770:	4801      	ldr	r0, [pc, #4]	; (c0d05778 <str_validateTextBuffer+0x4c>)
c0d05772:	f7fc fd0f 	bl	c0d02194 <os_longjmp>
c0d05776:	46c0      	nop			; (mov r8, r8)
c0d05778:	00006e07 	.word	0x00006e07
c0d0577c:	0000408b 	.word	0x0000408b
c0d05780:	00002ea6 	.word	0x00002ea6
c0d05784:	0000407d 	.word	0x0000407d
c0d05788:	00002e9a 	.word	0x00002e9a
c0d0578c:	00004071 	.word	0x00004071

c0d05790 <str_validateNullTerminatedTextBuffer>:

//text[textSize] has to be 0
void str_validateNullTerminatedTextBuffer(const uint8_t* text, size_t textSize)
{
c0d05790:	b5b0      	push	{r4, r5, r7, lr}
c0d05792:	460c      	mov	r4, r1
c0d05794:	4605      	mov	r5, r0
	str_validateTextBuffer(text, textSize);
c0d05796:	f7ff ffc9 	bl	c0d0572c <str_validateTextBuffer>
	VALIDATE(text[textSize] == 0, ERR_INVALID_DATA);
c0d0579a:	5d28      	ldrb	r0, [r5, r4]
c0d0579c:	2800      	cmp	r0, #0
c0d0579e:	d100      	bne.n	c0d057a2 <str_validateNullTerminatedTextBuffer+0x12>
}
c0d057a0:	bdb0      	pop	{r4, r5, r7, pc}
	VALIDATE(text[textSize] == 0, ERR_INVALID_DATA);
c0d057a2:	4806      	ldr	r0, [pc, #24]	; (c0d057bc <str_validateNullTerminatedTextBuffer+0x2c>)
c0d057a4:	4478      	add	r0, pc
c0d057a6:	4906      	ldr	r1, [pc, #24]	; (c0d057c0 <str_validateNullTerminatedTextBuffer+0x30>)
c0d057a8:	4479      	add	r1, pc
c0d057aa:	2271      	movs	r2, #113	; 0x71
c0d057ac:	f7fd fa4a 	bl	c0d02c44 <mcu_usb_printf>
c0d057b0:	4801      	ldr	r0, [pc, #4]	; (c0d057b8 <str_validateNullTerminatedTextBuffer+0x28>)
c0d057b2:	f7fc fcef 	bl	c0d02194 <os_longjmp>
c0d057b6:	46c0      	nop			; (mov r8, r8)
c0d057b8:	00006e07 	.word	0x00006e07
c0d057bc:	00002e5a 	.word	0x00002e5a
c0d057c0:	00004031 	.word	0x00004031

c0d057c4 <testcase_formatUint64>:

void testcase_formatUint64(
        uint64_t number,
        const char* expected
)
{
c0d057c4:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d057c6:	b095      	sub	sp, #84	; 0x54
c0d057c8:	4616      	mov	r6, r2
c0d057ca:	460c      	mov	r4, r1
c0d057cc:	4605      	mov	r5, r0
	PRINTF("testcase_formatUint64 %s\n", expected);
c0d057ce:	4830      	ldr	r0, [pc, #192]	; (c0d05890 <testcase_formatUint64+0xcc>)
c0d057d0:	4478      	add	r0, pc
c0d057d2:	4611      	mov	r1, r2
c0d057d4:	f7fd fa36 	bl	c0d02c44 <mcu_usb_printf>
c0d057d8:	af01      	add	r7, sp, #4
c0d057da:	231e      	movs	r3, #30

	{
		char tmp[30];
		size_t len = str_formatUint64(number, tmp, SIZEOF(tmp));
c0d057dc:	4628      	mov	r0, r5
c0d057de:	9400      	str	r4, [sp, #0]
c0d057e0:	4621      	mov	r1, r4
c0d057e2:	463a      	mov	r2, r7
c0d057e4:	f7ff ff3c 	bl	c0d05660 <str_formatUint64>
c0d057e8:	4604      	mov	r4, r0
		EXPECT_EQ(len, strlen(expected));
c0d057ea:	4630      	mov	r0, r6
c0d057ec:	f002 fefc 	bl	c0d085e8 <strlen>
c0d057f0:	1a21      	subs	r1, r4, r0
c0d057f2:	4248      	negs	r0, r1
c0d057f4:	4148      	adcs	r0, r1
c0d057f6:	4927      	ldr	r1, [pc, #156]	; (c0d05894 <testcase_formatUint64+0xd0>)
c0d057f8:	4479      	add	r1, pc
c0d057fa:	f7fa fc39 	bl	c0d00070 <assert>
		EXPECT_EQ(strcmp(tmp, expected), 0);
c0d057fe:	4638      	mov	r0, r7
c0d05800:	4631      	mov	r1, r6
c0d05802:	f002 fee7 	bl	c0d085d4 <strcmp>
c0d05806:	4241      	negs	r1, r0
c0d05808:	4148      	adcs	r0, r1
c0d0580a:	4923      	ldr	r1, [pc, #140]	; (c0d05898 <testcase_formatUint64+0xd4>)
c0d0580c:	4479      	add	r1, pc
c0d0580e:	f7fa fc2f 	bl	c0d00070 <assert>
c0d05812:	ac01      	add	r4, sp, #4
	}

	{
		// check for buffer overflows
		char tmp[30];
		EXPECT_THROWS(str_formatUint64(number, tmp, strlen(expected)), ERR_DATA_TOO_LARGE);
c0d05814:	4620      	mov	r0, r4
c0d05816:	f002 fec3 	bl	c0d085a0 <setjmp>
c0d0581a:	85a0      	strh	r0, [r4, #44]	; 0x2c
c0d0581c:	b280      	uxth	r0, r0
c0d0581e:	491b      	ldr	r1, [pc, #108]	; (c0d0588c <testcase_formatUint64+0xc8>)
c0d05820:	4288      	cmp	r0, r1
c0d05822:	d010      	beq.n	c0d05846 <testcase_formatUint64+0x82>
c0d05824:	2800      	cmp	r0, #0
c0d05826:	d116      	bne.n	c0d05856 <testcase_formatUint64+0x92>
c0d05828:	a801      	add	r0, sp, #4
c0d0582a:	f7ff fefd 	bl	c0d05628 <try_context_set>
c0d0582e:	900b      	str	r0, [sp, #44]	; 0x2c
c0d05830:	4630      	mov	r0, r6
c0d05832:	f002 fed9 	bl	c0d085e8 <strlen>
c0d05836:	4603      	mov	r3, r0
c0d05838:	aa0d      	add	r2, sp, #52	; 0x34
c0d0583a:	4628      	mov	r0, r5
c0d0583c:	9900      	ldr	r1, [sp, #0]
c0d0583e:	f7ff ff0f 	bl	c0d05660 <str_formatUint64>
c0d05842:	2400      	movs	r4, #0
c0d05844:	e00d      	b.n	c0d05862 <testcase_formatUint64+0x9e>
c0d05846:	a801      	add	r0, sp, #4
c0d05848:	2100      	movs	r1, #0
c0d0584a:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d0584c:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d0584e:	f7ff feeb 	bl	c0d05628 <try_context_set>
c0d05852:	2401      	movs	r4, #1
c0d05854:	e005      	b.n	c0d05862 <testcase_formatUint64+0x9e>
c0d05856:	a801      	add	r0, sp, #4
c0d05858:	2400      	movs	r4, #0
c0d0585a:	8584      	strh	r4, [r0, #44]	; 0x2c
c0d0585c:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d0585e:	f7ff fee3 	bl	c0d05628 <try_context_set>
c0d05862:	f7ff fed5 	bl	c0d05610 <try_context_get>
c0d05866:	a901      	add	r1, sp, #4
c0d05868:	4288      	cmp	r0, r1
c0d0586a:	d102      	bne.n	c0d05872 <testcase_formatUint64+0xae>
c0d0586c:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d0586e:	f7ff fedb 	bl	c0d05628 <try_context_set>
c0d05872:	490a      	ldr	r1, [pc, #40]	; (c0d0589c <testcase_formatUint64+0xd8>)
c0d05874:	4479      	add	r1, pc
c0d05876:	4620      	mov	r0, r4
c0d05878:	f7fa fbfa 	bl	c0d00070 <assert>
c0d0587c:	a801      	add	r0, sp, #4
c0d0587e:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d05880:	2800      	cmp	r0, #0
c0d05882:	d101      	bne.n	c0d05888 <testcase_formatUint64+0xc4>
	}
}
c0d05884:	b015      	add	sp, #84	; 0x54
c0d05886:	bdf0      	pop	{r4, r5, r6, r7, pc}
		EXPECT_THROWS(str_formatUint64(number, tmp, strlen(expected)), ERR_DATA_TOO_LARGE);
c0d05888:	f7fc fc84 	bl	c0d02194 <os_longjmp>
c0d0588c:	00004711 	.word	0x00004711
c0d05890:	00004019 	.word	0x00004019
c0d05894:	0000400b 	.word	0x0000400b
c0d05898:	0000400f 	.word	0x0000400f
c0d0589c:	00003fbf 	.word	0x00003fbf

c0d058a0 <test_formatUint64>:

void test_formatUint64()
{
c0d058a0:	b5b0      	push	{r4, r5, r7, lr}
c0d058a2:	2400      	movs	r4, #0
	testcase_formatUint64( 0, "0");
c0d058a4:	4a10      	ldr	r2, [pc, #64]	; (c0d058e8 <test_formatUint64+0x48>)
c0d058a6:	447a      	add	r2, pc
c0d058a8:	4620      	mov	r0, r4
c0d058aa:	4621      	mov	r1, r4
c0d058ac:	f7ff ff8a 	bl	c0d057c4 <testcase_formatUint64>
c0d058b0:	2001      	movs	r0, #1
	testcase_formatUint64( 1, "1");
c0d058b2:	4a0e      	ldr	r2, [pc, #56]	; (c0d058ec <test_formatUint64+0x4c>)
c0d058b4:	447a      	add	r2, pc
c0d058b6:	4621      	mov	r1, r4
c0d058b8:	f7ff ff84 	bl	c0d057c4 <testcase_formatUint64>
c0d058bc:	4d09      	ldr	r5, [pc, #36]	; (c0d058e4 <test_formatUint64+0x44>)
	testcase_formatUint64( 4924800, "4924800");
c0d058be:	1c68      	adds	r0, r5, #1
c0d058c0:	4a0b      	ldr	r2, [pc, #44]	; (c0d058f0 <test_formatUint64+0x50>)
c0d058c2:	447a      	add	r2, pc
c0d058c4:	4621      	mov	r1, r4
c0d058c6:	f7ff ff7d 	bl	c0d057c4 <testcase_formatUint64>
	testcase_formatUint64( 4924799, "4924799");
c0d058ca:	4a0a      	ldr	r2, [pc, #40]	; (c0d058f4 <test_formatUint64+0x54>)
c0d058cc:	447a      	add	r2, pc
c0d058ce:	4628      	mov	r0, r5
c0d058d0:	4621      	mov	r1, r4
c0d058d2:	f7ff ff77 	bl	c0d057c4 <testcase_formatUint64>
c0d058d6:	43e0      	mvns	r0, r4
	testcase_formatUint64( -1ll, "18446744073709551615");
c0d058d8:	4a07      	ldr	r2, [pc, #28]	; (c0d058f8 <test_formatUint64+0x58>)
c0d058da:	447a      	add	r2, pc
c0d058dc:	4601      	mov	r1, r0
c0d058de:	f7ff ff71 	bl	c0d057c4 <testcase_formatUint64>
}
c0d058e2:	bdb0      	pop	{r4, r5, r7, pc}
c0d058e4:	004b257f 	.word	0x004b257f
c0d058e8:	0000392d 	.word	0x0000392d
c0d058ec:	000039a2 	.word	0x000039a2
c0d058f0:	00003f89 	.word	0x00003f89
c0d058f4:	00003f87 	.word	0x00003f87
c0d058f8:	00003f81 	.word	0x00003f81

c0d058fc <run_textUtils_test>:

void run_textUtils_test()
{
c0d058fc:	b580      	push	{r7, lr}
	test_formatUint64();
c0d058fe:	f7ff ffcf 	bl	c0d058a0 <test_formatUint64>
}
c0d05902:	bd80      	pop	{r7, pc}

c0d05904 <u2f_apdu_sign>:

    u2f_message_reply(service, U2F_CMD_MSG, (uint8_t *)SW_INTERNAL, sizeof(SW_INTERNAL));
}

void u2f_apdu_sign(u2f_service_t *service, uint8_t p1, uint8_t p2,
                     uint8_t *buffer, uint16_t length) {
c0d05904:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d05906:	b085      	sub	sp, #20
    UNUSED(p2);
    uint8_t keyHandleLength;
    uint8_t i;

    // can't process the apdu if another one is already scheduled in
    if (G_io_app.apdu_state != APDU_IDLE) {
c0d05908:	4a3a      	ldr	r2, [pc, #232]	; (c0d059f4 <u2f_apdu_sign+0xf0>)
c0d0590a:	7812      	ldrb	r2, [r2, #0]
c0d0590c:	2a00      	cmp	r2, #0
c0d0590e:	d003      	beq.n	c0d05918 <u2f_apdu_sign+0x14>
c0d05910:	2183      	movs	r1, #131	; 0x83
        u2f_message_reply(service, U2F_CMD_MSG,
c0d05912:	4a3a      	ldr	r2, [pc, #232]	; (c0d059fc <u2f_apdu_sign+0xf8>)
c0d05914:	447a      	add	r2, pc
c0d05916:	e00b      	b.n	c0d05930 <u2f_apdu_sign+0x2c>
c0d05918:	9c0a      	ldr	r4, [sp, #40]	; 0x28
                  (uint8_t *)SW_BUSY,
                  sizeof(SW_BUSY));
        return;        
    }

    if (length < U2F_HANDLE_SIGN_HEADER_SIZE + 5 /*at least an apdu header*/) {
c0d0591a:	2c45      	cmp	r4, #69	; 0x45
c0d0591c:	d803      	bhi.n	c0d05926 <u2f_apdu_sign+0x22>
c0d0591e:	2183      	movs	r1, #131	; 0x83
c0d05920:	4a37      	ldr	r2, [pc, #220]	; (c0d05a00 <u2f_apdu_sign+0xfc>)
c0d05922:	447a      	add	r2, pc
c0d05924:	e004      	b.n	c0d05930 <u2f_apdu_sign+0x2c>
                  sizeof(SW_WRONG_LENGTH));
        return;
    }

    // Confirm immediately if it's just a validation call
    if (p1 == P1_SIGN_CHECK_ONLY) {
c0d05926:	2907      	cmp	r1, #7
c0d05928:	d107      	bne.n	c0d0593a <u2f_apdu_sign+0x36>
c0d0592a:	2183      	movs	r1, #131	; 0x83
        u2f_message_reply(service, U2F_CMD_MSG,
c0d0592c:	4a35      	ldr	r2, [pc, #212]	; (c0d05a04 <u2f_apdu_sign+0x100>)
c0d0592e:	447a      	add	r2, pc
c0d05930:	2302      	movs	r3, #2
c0d05932:	f000 fccd 	bl	c0d062d0 <u2f_message_reply>
    app_dispatch();
    if ((btchip_context_D.io_flags & IO_ASYNCH_REPLY) == 0) {
        u2f_proxy_response(service, btchip_context_D.outLength);
    }
    */
}
c0d05936:	b005      	add	sp, #20
c0d05938:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d0593a:	461d      	mov	r5, r3
c0d0593c:	3540      	adds	r5, #64	; 0x40
    keyHandleLength = buffer[U2F_HANDLE_SIGN_HEADER_SIZE - 1];
c0d0593e:	782a      	ldrb	r2, [r5, #0]
    if (U2F_HANDLE_SIGN_HEADER_SIZE + keyHandleLength != length) {
c0d05940:	4611      	mov	r1, r2
c0d05942:	3141      	adds	r1, #65	; 0x41
c0d05944:	42a1      	cmp	r1, r4
c0d05946:	d1ea      	bne.n	c0d0591e <u2f_apdu_sign+0x1a>
c0d05948:	9501      	str	r5, [sp, #4]
c0d0594a:	9402      	str	r4, [sp, #8]
c0d0594c:	9003      	str	r0, [sp, #12]
c0d0594e:	9304      	str	r3, [sp, #16]
    if (keyHandleLength == 5) {
c0d05950:	2a00      	cmp	r2, #0
c0d05952:	d01e      	beq.n	c0d05992 <u2f_apdu_sign+0x8e>
c0d05954:	2a05      	cmp	r2, #5
c0d05956:	9d04      	ldr	r5, [sp, #16]
c0d05958:	d10a      	bne.n	c0d05970 <u2f_apdu_sign+0x6c>
        if (memcmp(buffer+U2F_HANDLE_SIGN_HEADER_SIZE, "\xF1\xD0\x00\x00\x00", 5) == 0 ) {
c0d0595a:	4628      	mov	r0, r5
c0d0595c:	3041      	adds	r0, #65	; 0x41
c0d0595e:	492a      	ldr	r1, [pc, #168]	; (c0d05a08 <u2f_apdu_sign+0x104>)
c0d05960:	4479      	add	r1, pc
c0d05962:	4616      	mov	r6, r2
c0d05964:	2205      	movs	r2, #5
c0d05966:	f002 fde9 	bl	c0d0853c <memcmp>
c0d0596a:	4632      	mov	r2, r6
c0d0596c:	2800      	cmp	r0, #0
c0d0596e:	d02d      	beq.n	c0d059cc <u2f_apdu_sign+0xc8>
    for (i = 0; i < keyHandleLength; i++) {
c0d05970:	3541      	adds	r5, #65	; 0x41
c0d05972:	2700      	movs	r7, #0
c0d05974:	4e25      	ldr	r6, [pc, #148]	; (c0d05a0c <u2f_apdu_sign+0x108>)
c0d05976:	447e      	add	r6, pc
        buffer[U2F_HANDLE_SIGN_HEADER_SIZE + i] ^= U2F_PROXY_MAGIC[i % (sizeof(U2F_PROXY_MAGIC)-1)];
c0d05978:	b2f8      	uxtb	r0, r7
c0d0597a:	2103      	movs	r1, #3
c0d0597c:	4614      	mov	r4, r2
c0d0597e:	f002 fc7b 	bl	c0d08278 <__aeabi_uidivmod>
c0d05982:	4622      	mov	r2, r4
c0d05984:	5de8      	ldrb	r0, [r5, r7]
c0d05986:	5c71      	ldrb	r1, [r6, r1]
c0d05988:	4041      	eors	r1, r0
c0d0598a:	55e9      	strb	r1, [r5, r7]
    for (i = 0; i < keyHandleLength; i++) {
c0d0598c:	1c7f      	adds	r7, r7, #1
c0d0598e:	42bc      	cmp	r4, r7
c0d05990:	d1f2      	bne.n	c0d05978 <u2f_apdu_sign+0x74>
    if (length != U2F_HANDLE_SIGN_HEADER_SIZE + 5 + buffer[U2F_HANDLE_SIGN_HEADER_SIZE + 4]) {
c0d05992:	9801      	ldr	r0, [sp, #4]
c0d05994:	7940      	ldrb	r0, [r0, #5]
c0d05996:	3046      	adds	r0, #70	; 0x46
c0d05998:	9902      	ldr	r1, [sp, #8]
c0d0599a:	4288      	cmp	r0, r1
c0d0599c:	d110      	bne.n	c0d059c0 <u2f_apdu_sign+0xbc>
c0d0599e:	9904      	ldr	r1, [sp, #16]
    memmove(G_io_apdu_buffer, buffer + U2F_HANDLE_SIGN_HEADER_SIZE, keyHandleLength);
c0d059a0:	3141      	adds	r1, #65	; 0x41
c0d059a2:	4815      	ldr	r0, [pc, #84]	; (c0d059f8 <u2f_apdu_sign+0xf4>)
c0d059a4:	4615      	mov	r5, r2
c0d059a6:	f002 fdba 	bl	c0d0851e <__aeabi_memmove>
c0d059aa:	2007      	movs	r0, #7
c0d059ac:	4911      	ldr	r1, [pc, #68]	; (c0d059f4 <u2f_apdu_sign+0xf0>)
    G_io_app.apdu_media = IO_APDU_MEDIA_U2F; // the effective transport is managed by the U2F layer
c0d059ae:	7188      	strb	r0, [r1, #6]
    G_io_app.apdu_length = keyHandleLength;
c0d059b0:	804d      	strh	r5, [r1, #2]
c0d059b2:	2009      	movs	r0, #9
    G_io_app.apdu_state = APDU_U2F;
c0d059b4:	7008      	strb	r0, [r1, #0]
c0d059b6:	2101      	movs	r1, #1
    u2f_message_set_autoreply_wait_user_presence(service, true);
c0d059b8:	9803      	ldr	r0, [sp, #12]
c0d059ba:	f000 fc5d 	bl	c0d06278 <u2f_message_set_autoreply_wait_user_presence>
c0d059be:	e7ba      	b.n	c0d05936 <u2f_apdu_sign+0x32>
c0d059c0:	2183      	movs	r1, #131	; 0x83
        u2f_message_reply(service, U2F_CMD_MSG,
c0d059c2:	4a13      	ldr	r2, [pc, #76]	; (c0d05a10 <u2f_apdu_sign+0x10c>)
c0d059c4:	447a      	add	r2, pc
c0d059c6:	2302      	movs	r3, #2
c0d059c8:	9803      	ldr	r0, [sp, #12]
c0d059ca:	e7b2      	b.n	c0d05932 <u2f_apdu_sign+0x2e>
            G_io_apdu_buffer[0] = sizeof(U2F_PROXY_MAGIC)-1;
c0d059cc:	4d0a      	ldr	r5, [pc, #40]	; (c0d059f8 <u2f_apdu_sign+0xf4>)
c0d059ce:	2203      	movs	r2, #3
c0d059d0:	702a      	strb	r2, [r5, #0]
            memcpy(G_io_apdu_buffer+1, U2F_PROXY_MAGIC, sizeof(U2F_PROXY_MAGIC)-1);
c0d059d2:	1c68      	adds	r0, r5, #1
c0d059d4:	490f      	ldr	r1, [pc, #60]	; (c0d05a14 <u2f_apdu_sign+0x110>)
c0d059d6:	4479      	add	r1, pc
c0d059d8:	f002 fd9d 	bl	c0d08516 <__aeabi_memcpy>
c0d059dc:	2000      	movs	r0, #0
            memcpy(G_io_apdu_buffer+1+sizeof(U2F_PROXY_MAGIC)-1, "\x90\x00\x90\x00", 4);
c0d059de:	71e8      	strb	r0, [r5, #7]
c0d059e0:	2190      	movs	r1, #144	; 0x90
c0d059e2:	71a9      	strb	r1, [r5, #6]
c0d059e4:	7168      	strb	r0, [r5, #5]
c0d059e6:	7129      	strb	r1, [r5, #4]
c0d059e8:	2183      	movs	r1, #131	; 0x83
c0d059ea:	2308      	movs	r3, #8
            u2f_message_reply(service, U2F_CMD_MSG,
c0d059ec:	9803      	ldr	r0, [sp, #12]
c0d059ee:	462a      	mov	r2, r5
c0d059f0:	e79f      	b.n	c0d05932 <u2f_apdu_sign+0x2e>
c0d059f2:	46c0      	nop			; (mov r8, r8)
c0d059f4:	200003d8 	.word	0x200003d8
c0d059f8:	20000285 	.word	0x20000285
c0d059fc:	00003f5e 	.word	0x00003f5e
c0d05a00:	00003f52 	.word	0x00003f52
c0d05a04:	00003f48 	.word	0x00003f48
c0d05a08:	00003f18 	.word	0x00003f18
c0d05a0c:	00003dff 	.word	0x00003dff
c0d05a10:	00003eba 	.word	0x00003eba
c0d05a14:	00003d9f 	.word	0x00003d9f

c0d05a18 <u2f_handle_cmd_init>:
}

#endif // U2F_PROXY_MAGIC

void u2f_handle_cmd_init(u2f_service_t *service, uint8_t *buffer,
                         uint16_t length, uint8_t *channelInit) {
c0d05a18:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d05a1a:	b089      	sub	sp, #36	; 0x24
c0d05a1c:	461d      	mov	r5, r3
c0d05a1e:	460e      	mov	r6, r1
c0d05a20:	4604      	mov	r4, r0
    // screen_printf("U2F init\n");
    uint8_t channel[4];
    (void)length;
    if (u2f_is_channel_broadcast(channelInit)) {
c0d05a22:	4618      	mov	r0, r3
c0d05a24:	f000 fc1a 	bl	c0d0625c <u2f_is_channel_broadcast>
c0d05a28:	2800      	cmp	r0, #0
c0d05a2a:	9406      	str	r4, [sp, #24]
c0d05a2c:	9503      	str	r5, [sp, #12]
c0d05a2e:	d00a      	beq.n	c0d05a46 <u2f_handle_cmd_init+0x2e>
        // cx_rng_no_throw(channel, 4); // not available within the IO task, just do without
	service->next_channel += 1;
c0d05a30:	6820      	ldr	r0, [r4, #0]
c0d05a32:	1c40      	adds	r0, r0, #1
c0d05a34:	6020      	str	r0, [r4, #0]
  buf[off + 1] = value & 0xFF;
}
static inline void U4BE_ENCODE(uint8_t *buf, size_t off, uint32_t value) {
  buf[off + 0] = (value >> 24) & 0xFF;
  buf[off + 1] = (value >> 16) & 0xFF;
  buf[off + 2] = (value >> 8) & 0xFF;
c0d05a36:	0a01      	lsrs	r1, r0, #8
  buf[off + 1] = (value >> 16) & 0xFF;
c0d05a38:	9107      	str	r1, [sp, #28]
c0d05a3a:	0c01      	lsrs	r1, r0, #16
c0d05a3c:	9108      	str	r1, [sp, #32]
c0d05a3e:	9004      	str	r0, [sp, #16]
  buf[off + 0] = (value >> 24) & 0xFF;
c0d05a40:	0e00      	lsrs	r0, r0, #24
c0d05a42:	9005      	str	r0, [sp, #20]
c0d05a44:	e010      	b.n	c0d05a68 <u2f_handle_cmd_init+0x50>
        U4BE_ENCODE(channel, 0, service->next_channel);
    } else {
        memcpy(channel, channelInit, 4);
c0d05a46:	7828      	ldrb	r0, [r5, #0]
c0d05a48:	7869      	ldrb	r1, [r5, #1]
c0d05a4a:	0209      	lsls	r1, r1, #8
c0d05a4c:	1808      	adds	r0, r1, r0
c0d05a4e:	78a9      	ldrb	r1, [r5, #2]
c0d05a50:	78ea      	ldrb	r2, [r5, #3]
c0d05a52:	0212      	lsls	r2, r2, #8
c0d05a54:	1851      	adds	r1, r2, r1
c0d05a56:	0409      	lsls	r1, r1, #16
c0d05a58:	1808      	adds	r0, r1, r0
c0d05a5a:	0e01      	lsrs	r1, r0, #24
c0d05a5c:	9104      	str	r1, [sp, #16]
c0d05a5e:	0c01      	lsrs	r1, r0, #16
c0d05a60:	9107      	str	r1, [sp, #28]
c0d05a62:	9005      	str	r0, [sp, #20]
c0d05a64:	0a00      	lsrs	r0, r0, #8
c0d05a66:	9008      	str	r0, [sp, #32]
    }
    memmove(G_io_apdu_buffer, buffer, 8);
c0d05a68:	7870      	ldrb	r0, [r6, #1]
c0d05a6a:	9002      	str	r0, [sp, #8]
c0d05a6c:	7830      	ldrb	r0, [r6, #0]
c0d05a6e:	9001      	str	r0, [sp, #4]
c0d05a70:	78f0      	ldrb	r0, [r6, #3]
c0d05a72:	9000      	str	r0, [sp, #0]
c0d05a74:	78b3      	ldrb	r3, [r6, #2]
c0d05a76:	7971      	ldrb	r1, [r6, #5]
c0d05a78:	7935      	ldrb	r5, [r6, #4]
c0d05a7a:	79f0      	ldrb	r0, [r6, #7]
c0d05a7c:	79b4      	ldrb	r4, [r6, #6]
c0d05a7e:	4e1b      	ldr	r6, [pc, #108]	; (c0d05aec <u2f_handle_cmd_init+0xd4>)
c0d05a80:	2700      	movs	r7, #0
    memcpy(G_io_apdu_buffer + 8, channel, 4);
    G_io_apdu_buffer[12] = INIT_U2F_VERSION;
    G_io_apdu_buffer[13] = INIT_DEVICE_VERSION_MAJOR;
c0d05a82:	7377      	strb	r7, [r6, #13]
c0d05a84:	2201      	movs	r2, #1
    G_io_apdu_buffer[14] = INIT_DEVICE_VERSION_MINOR;
c0d05a86:	73b2      	strb	r2, [r6, #14]
    G_io_apdu_buffer[15] = INIT_BUILD_VERSION;
c0d05a88:	73f7      	strb	r7, [r6, #15]
    G_io_apdu_buffer[16] = INIT_CAPABILITIES;
c0d05a8a:	7437      	strb	r7, [r6, #16]
    memmove(G_io_apdu_buffer, buffer, 8);
c0d05a8c:	71b4      	strb	r4, [r6, #6]
c0d05a8e:	71f0      	strb	r0, [r6, #7]
c0d05a90:	7135      	strb	r5, [r6, #4]
c0d05a92:	7171      	strb	r1, [r6, #5]
c0d05a94:	70b3      	strb	r3, [r6, #2]
c0d05a96:	9800      	ldr	r0, [sp, #0]
c0d05a98:	70f0      	strb	r0, [r6, #3]
c0d05a9a:	9801      	ldr	r0, [sp, #4]
c0d05a9c:	7030      	strb	r0, [r6, #0]
c0d05a9e:	9802      	ldr	r0, [sp, #8]
c0d05aa0:	7070      	strb	r0, [r6, #1]
    memcpy(G_io_apdu_buffer + 8, channel, 4);
c0d05aa2:	9807      	ldr	r0, [sp, #28]
c0d05aa4:	72b0      	strb	r0, [r6, #10]
c0d05aa6:	9d04      	ldr	r5, [sp, #16]
c0d05aa8:	72f5      	strb	r5, [r6, #11]
c0d05aaa:	9c05      	ldr	r4, [sp, #20]
c0d05aac:	7234      	strb	r4, [r6, #8]
c0d05aae:	9808      	ldr	r0, [sp, #32]
c0d05ab0:	7270      	strb	r0, [r6, #9]
c0d05ab2:	2002      	movs	r0, #2
    G_io_apdu_buffer[12] = INIT_U2F_VERSION;
c0d05ab4:	7330      	strb	r0, [r6, #12]

    if (u2f_is_channel_broadcast(channelInit)) {
c0d05ab6:	9803      	ldr	r0, [sp, #12]
c0d05ab8:	f000 fbd0 	bl	c0d0625c <u2f_is_channel_broadcast>
c0d05abc:	2800      	cmp	r0, #0
c0d05abe:	d10b      	bne.n	c0d05ad8 <u2f_handle_cmd_init+0xc0>
c0d05ac0:	0628      	lsls	r0, r5, #24
c0d05ac2:	9907      	ldr	r1, [sp, #28]
c0d05ac4:	0609      	lsls	r1, r1, #24
c0d05ac6:	0a09      	lsrs	r1, r1, #8
c0d05ac8:	1808      	adds	r0, r1, r0
c0d05aca:	9908      	ldr	r1, [sp, #32]
c0d05acc:	0609      	lsls	r1, r1, #24
c0d05ace:	0c09      	lsrs	r1, r1, #16
c0d05ad0:	1840      	adds	r0, r0, r1
c0d05ad2:	b2e1      	uxtb	r1, r4
c0d05ad4:	1841      	adds	r1, r0, r1
c0d05ad6:	e000      	b.n	c0d05ada <u2f_handle_cmd_init+0xc2>
c0d05ad8:	43f9      	mvns	r1, r7
c0d05ada:	9806      	ldr	r0, [sp, #24]
c0d05adc:	6041      	str	r1, [r0, #4]
c0d05ade:	2186      	movs	r1, #134	; 0x86
c0d05ae0:	2311      	movs	r3, #17
        memset(service->channel, 0xff, 4);
    } else {
        memcpy(service->channel, channel, 4);
    }
    u2f_message_reply(service, U2F_CMD_INIT, G_io_apdu_buffer, 17);
c0d05ae2:	4632      	mov	r2, r6
c0d05ae4:	f000 fbf4 	bl	c0d062d0 <u2f_message_reply>
}
c0d05ae8:	b009      	add	sp, #36	; 0x24
c0d05aea:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d05aec:	20000285 	.word	0x20000285

c0d05af0 <u2f_handle_cmd_msg>:
    // screen_printf("U2F ping\n");
    u2f_message_reply(service, U2F_CMD_PING, buffer, length);
}

void u2f_handle_cmd_msg(u2f_service_t *service, uint8_t *buffer,
                        uint16_t length) {
c0d05af0:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d05af2:	b083      	sub	sp, #12
    uint8_t cla = buffer[0];
    uint8_t ins = buffer[1];
    uint8_t p1 = buffer[2];
    uint8_t p2 = buffer[3];
    // in extended length buffer[4] must be 0
    uint32_t dataLength = /*(buffer[4] << 16) |*/ (buffer[5] << 8) | (buffer[6]);
c0d05af4:	798b      	ldrb	r3, [r1, #6]
c0d05af6:	794c      	ldrb	r4, [r1, #5]
c0d05af8:	0224      	lsls	r4, r4, #8
c0d05afa:	18e7      	adds	r7, r4, r3
    uint8_t p1 = buffer[2];
c0d05afc:	788b      	ldrb	r3, [r1, #2]
    uint8_t ins = buffer[1];
c0d05afe:	9302      	str	r3, [sp, #8]
c0d05b00:	784b      	ldrb	r3, [r1, #1]
    uint8_t cla = buffer[0];
c0d05b02:	780e      	ldrb	r6, [r1, #0]
    if (dataLength == (uint16_t)(length - 9) || dataLength == (uint16_t)(length - 7)) {
c0d05b04:	4615      	mov	r5, r2
c0d05b06:	3d09      	subs	r5, #9
c0d05b08:	b2ac      	uxth	r4, r5
c0d05b0a:	42a7      	cmp	r7, r4
c0d05b0c:	d003      	beq.n	c0d05b16 <u2f_handle_cmd_msg+0x26>
c0d05b0e:	1fd2      	subs	r2, r2, #7
c0d05b10:	b294      	uxth	r4, r2
c0d05b12:	42a7      	cmp	r7, r4
c0d05b14:	d118      	bne.n	c0d05b48 <u2f_handle_cmd_msg+0x58>
c0d05b16:	463d      	mov	r5, r7
    G_io_app.apdu_media = IO_APDU_MEDIA_U2F; // the effective transport is managed by the U2F layer
    G_io_app.apdu_state = APDU_U2F;

#else // U2F_PROXY_MAGIC

    if (cla != FIDO_CLA) {
c0d05b18:	2e00      	cmp	r6, #0
c0d05b1a:	d007      	beq.n	c0d05b2c <u2f_handle_cmd_msg+0x3c>
c0d05b1c:	2183      	movs	r1, #131	; 0x83
        u2f_message_reply(service, U2F_CMD_MSG,
c0d05b1e:	4a1b      	ldr	r2, [pc, #108]	; (c0d05b8c <u2f_handle_cmd_msg+0x9c>)
c0d05b20:	447a      	add	r2, pc
c0d05b22:	2302      	movs	r3, #2
c0d05b24:	f000 fbd4 	bl	c0d062d0 <u2f_message_reply>
                 sizeof(SW_UNKNOWN_INSTRUCTION));
        return;
    }

#endif // U2F_PROXY_MAGIC
}
c0d05b28:	b003      	add	sp, #12
c0d05b2a:	bdf0      	pop	{r4, r5, r6, r7, pc}
    switch (ins) {
c0d05b2c:	2b02      	cmp	r3, #2
c0d05b2e:	dc16      	bgt.n	c0d05b5e <u2f_handle_cmd_msg+0x6e>
c0d05b30:	2b01      	cmp	r3, #1
c0d05b32:	d021      	beq.n	c0d05b78 <u2f_handle_cmd_msg+0x88>
c0d05b34:	2b02      	cmp	r3, #2
c0d05b36:	d11b      	bne.n	c0d05b70 <u2f_handle_cmd_msg+0x80>
        u2f_apdu_sign(service, p1, p2, buffer + 7, dataLength);
c0d05b38:	b2aa      	uxth	r2, r5
c0d05b3a:	9200      	str	r2, [sp, #0]
c0d05b3c:	1dcb      	adds	r3, r1, #7
c0d05b3e:	2200      	movs	r2, #0
c0d05b40:	9902      	ldr	r1, [sp, #8]
c0d05b42:	f7ff fedf 	bl	c0d05904 <u2f_apdu_sign>
c0d05b46:	e7ef      	b.n	c0d05b28 <u2f_handle_cmd_msg+0x38>
    else if (dataLength == (uint16_t)(length - 9)%256) {
c0d05b48:	b2ec      	uxtb	r4, r5
c0d05b4a:	42a7      	cmp	r7, r4
c0d05b4c:	d0e4      	beq.n	c0d05b18 <u2f_handle_cmd_msg+0x28>
    else if (dataLength == (uint16_t)(length - 7)%256) {
c0d05b4e:	b2d4      	uxtb	r4, r2
c0d05b50:	42a7      	cmp	r7, r4
c0d05b52:	4615      	mov	r5, r2
c0d05b54:	d0e0      	beq.n	c0d05b18 <u2f_handle_cmd_msg+0x28>
c0d05b56:	2183      	movs	r1, #131	; 0x83
        u2f_message_reply(service, U2F_CMD_MSG,
c0d05b58:	4a0d      	ldr	r2, [pc, #52]	; (c0d05b90 <u2f_handle_cmd_msg+0xa0>)
c0d05b5a:	447a      	add	r2, pc
c0d05b5c:	e7e1      	b.n	c0d05b22 <u2f_handle_cmd_msg+0x32>
    switch (ins) {
c0d05b5e:	2b03      	cmp	r3, #3
c0d05b60:	d00e      	beq.n	c0d05b80 <u2f_handle_cmd_msg+0x90>
c0d05b62:	2bc1      	cmp	r3, #193	; 0xc1
c0d05b64:	d104      	bne.n	c0d05b70 <u2f_handle_cmd_msg+0x80>
c0d05b66:	2183      	movs	r1, #131	; 0x83
    u2f_message_reply(service, U2F_CMD_MSG, (uint8_t *)INFO, sizeof(INFO));
c0d05b68:	4a0a      	ldr	r2, [pc, #40]	; (c0d05b94 <u2f_handle_cmd_msg+0xa4>)
c0d05b6a:	447a      	add	r2, pc
c0d05b6c:	2304      	movs	r3, #4
c0d05b6e:	e7d9      	b.n	c0d05b24 <u2f_handle_cmd_msg+0x34>
c0d05b70:	2183      	movs	r1, #131	; 0x83
        u2f_message_reply(service, U2F_CMD_MSG,
c0d05b72:	4a0b      	ldr	r2, [pc, #44]	; (c0d05ba0 <u2f_handle_cmd_msg+0xb0>)
c0d05b74:	447a      	add	r2, pc
c0d05b76:	e7d4      	b.n	c0d05b22 <u2f_handle_cmd_msg+0x32>
c0d05b78:	2183      	movs	r1, #131	; 0x83
    u2f_message_reply(service, U2F_CMD_MSG, (uint8_t *)SW_INTERNAL, sizeof(SW_INTERNAL));
c0d05b7a:	4a07      	ldr	r2, [pc, #28]	; (c0d05b98 <u2f_handle_cmd_msg+0xa8>)
c0d05b7c:	447a      	add	r2, pc
c0d05b7e:	e7d0      	b.n	c0d05b22 <u2f_handle_cmd_msg+0x32>
c0d05b80:	2183      	movs	r1, #131	; 0x83
    u2f_message_reply(service, U2F_CMD_MSG, (uint8_t *)U2F_VERSION, sizeof(U2F_VERSION));
c0d05b82:	4a06      	ldr	r2, [pc, #24]	; (c0d05b9c <u2f_handle_cmd_msg+0xac>)
c0d05b84:	447a      	add	r2, pc
c0d05b86:	2308      	movs	r3, #8
c0d05b88:	e7cc      	b.n	c0d05b24 <u2f_handle_cmd_msg+0x34>
c0d05b8a:	46c0      	nop			; (mov r8, r8)
c0d05b8c:	00003d6c 	.word	0x00003d6c
c0d05b90:	00003d1a 	.word	0x00003d1a
c0d05b94:	00003d1e 	.word	0x00003d1e
c0d05b98:	00003cf4 	.word	0x00003cf4
c0d05b9c:	00003cfc 	.word	0x00003cfc
c0d05ba0:	00003d1a 	.word	0x00003d1a

c0d05ba4 <u2f_message_complete>:

void u2f_message_complete(u2f_service_t *service) {
c0d05ba4:	b580      	push	{r7, lr}
    uint8_t cmd = service->transportBuffer[0];
c0d05ba6:	69c1      	ldr	r1, [r0, #28]
    uint16_t length = (service->transportBuffer[1] << 8) | (service->transportBuffer[2]);
c0d05ba8:	788a      	ldrb	r2, [r1, #2]
c0d05baa:	784b      	ldrb	r3, [r1, #1]
c0d05bac:	021b      	lsls	r3, r3, #8
c0d05bae:	189b      	adds	r3, r3, r2
    uint8_t cmd = service->transportBuffer[0];
c0d05bb0:	780a      	ldrb	r2, [r1, #0]
    switch (cmd) {
c0d05bb2:	2a81      	cmp	r2, #129	; 0x81
c0d05bb4:	d009      	beq.n	c0d05bca <u2f_message_complete+0x26>
c0d05bb6:	2a83      	cmp	r2, #131	; 0x83
c0d05bb8:	d00d      	beq.n	c0d05bd6 <u2f_message_complete+0x32>
c0d05bba:	2a86      	cmp	r2, #134	; 0x86
c0d05bbc:	d10f      	bne.n	c0d05bde <u2f_message_complete+0x3a>
    case U2F_CMD_INIT:
        u2f_handle_cmd_init(service, service->transportBuffer + 3, length, service->channel);
c0d05bbe:	1cc9      	adds	r1, r1, #3
c0d05bc0:	1d03      	adds	r3, r0, #4
c0d05bc2:	2200      	movs	r2, #0
c0d05bc4:	f7ff ff28 	bl	c0d05a18 <u2f_handle_cmd_init>
    case CTAP2_CMD_CANCEL:
        ctap2_handle_cmd_cancel(service, service->transportBuffer + 3, length);
        break;
#endif        	
    }
}
c0d05bc8:	bd80      	pop	{r7, pc}
        u2f_handle_cmd_ping(service, service->transportBuffer + 3, length);
c0d05bca:	1cca      	adds	r2, r1, #3
    u2f_message_reply(service, U2F_CMD_PING, buffer, length);
c0d05bcc:	b29b      	uxth	r3, r3
c0d05bce:	2181      	movs	r1, #129	; 0x81
c0d05bd0:	f000 fb7e 	bl	c0d062d0 <u2f_message_reply>
}
c0d05bd4:	bd80      	pop	{r7, pc}
        u2f_handle_cmd_msg(service, service->transportBuffer + 3, length);
c0d05bd6:	1cc9      	adds	r1, r1, #3
c0d05bd8:	b29a      	uxth	r2, r3
c0d05bda:	f7ff ff89 	bl	c0d05af0 <u2f_handle_cmd_msg>
}
c0d05bde:	bd80      	pop	{r7, pc}

c0d05be0 <u2f_io_send>:
#include "u2f_processing.h"
#include "u2f_impl.h"

#include "os_io_seproxyhal.h"

void u2f_io_send(uint8_t *buffer, uint16_t length, u2f_transport_media_t media) {
c0d05be0:	b570      	push	{r4, r5, r6, lr}
    if (media == U2F_MEDIA_USB) {
c0d05be2:	2a01      	cmp	r2, #1
c0d05be4:	d112      	bne.n	c0d05c0c <u2f_io_send+0x2c>
c0d05be6:	460d      	mov	r5, r1
c0d05be8:	4601      	mov	r1, r0
        memmove(G_io_usb_ep_buffer, buffer, length);
c0d05bea:	4c0b      	ldr	r4, [pc, #44]	; (c0d05c18 <u2f_io_send+0x38>)
c0d05bec:	4620      	mov	r0, r4
c0d05bee:	462a      	mov	r2, r5
c0d05bf0:	f002 fc95 	bl	c0d0851e <__aeabi_memmove>
        // wipe the remaining to avoid :
        // 1/ data leaks
        // 2/ invalid junk
        memset(G_io_usb_ep_buffer+length, 0, sizeof(G_io_usb_ep_buffer)-length);
c0d05bf4:	1960      	adds	r0, r4, r5
c0d05bf6:	2640      	movs	r6, #64	; 0x40
c0d05bf8:	1b71      	subs	r1, r6, r5
c0d05bfa:	f002 fc87 	bl	c0d0850c <__aeabi_memclr>
c0d05bfe:	2081      	movs	r0, #129	; 0x81
c0d05c00:	2300      	movs	r3, #0
    }
    switch (media) {
    case U2F_MEDIA_USB:
        io_usb_send_ep(U2F_EPIN_ADDR, G_io_usb_ep_buffer, USB_SEGMENT_SIZE, 0);
c0d05c02:	4621      	mov	r1, r4
c0d05c04:	4632      	mov	r2, r6
c0d05c06:	f7fc fb4f 	bl	c0d022a8 <io_usb_send_ep>
#endif
    default:
        PRINTF("Request to send on unsupported media %d\n", media);
        break;
    }
}
c0d05c0a:	bd70      	pop	{r4, r5, r6, pc}
        PRINTF("Request to send on unsupported media %d\n", media);
c0d05c0c:	4803      	ldr	r0, [pc, #12]	; (c0d05c1c <u2f_io_send+0x3c>)
c0d05c0e:	4478      	add	r0, pc
c0d05c10:	4611      	mov	r1, r2
c0d05c12:	f7fd f817 	bl	c0d02c44 <mcu_usb_printf>
}
c0d05c16:	bd70      	pop	{r4, r5, r6, pc}
c0d05c18:	2000043c 	.word	0x2000043c
c0d05c1c:	00003c82 	.word	0x00003c82

c0d05c20 <u2f_transport_init>:
}

/**
 * Initialize the u2f transport and provide the buffer into which to store incoming message
 */
void u2f_transport_init(u2f_service_t *service, uint8_t* message_buffer, uint16_t message_buffer_length) {
c0d05c20:	2300      	movs	r3, #0
    service->transportPacketIndex = 0;
c0d05c22:	7683      	strb	r3, [r0, #26]
    service->transportOffset = 0;
c0d05c24:	82c3      	strh	r3, [r0, #22]
    service->next_channel = 1;
    service->transportReceiveBuffer = message_buffer;
    service->transportReceiveBufferLength = message_buffer_length;
c0d05c26:	8202      	strh	r2, [r0, #16]
    service->transportReceiveBuffer = message_buffer;
c0d05c28:	60c1      	str	r1, [r0, #12]
c0d05c2a:	2201      	movs	r2, #1
    service->next_channel = 1;
c0d05c2c:	6002      	str	r2, [r0, #0]
    service->waitAsynchronousResponse = U2F_WAIT_ASYNCH_IDLE;
c0d05c2e:	8543      	strh	r3, [r0, #42]	; 0x2a
    service->transportMedia = 0;
c0d05c30:	8483      	strh	r3, [r0, #36]	; 0x24
    service->transportBuffer = service->transportReceiveBuffer;
c0d05c32:	61c1      	str	r1, [r0, #28]
    service->transportMedia = 0;
c0d05c34:	6203      	str	r3, [r0, #32]
    u2f_transport_reset(service);
}
c0d05c36:	4770      	bx	lr

c0d05c38 <u2f_transport_sent>:

/**
 * Function called when the previously scheduled message to be sent on the media is effectively sent.
 * And a new message can be scheduled.
 */
void u2f_transport_sent(u2f_service_t* service, u2f_transport_media_t media) {
c0d05c38:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d05c3a:	b081      	sub	sp, #4
c0d05c3c:	460d      	mov	r5, r1
c0d05c3e:	4604      	mov	r4, r0
c0d05c40:	202a      	movs	r0, #42	; 0x2a

bool u2f_message_repliable(u2f_service_t* service) {
    // no more asynch replies
    // finished receiving the command
    // and not sending a user presence required status
    return service->waitAsynchronousResponse == U2F_WAIT_ASYNCH_IDLE
c0d05c42:	5c21      	ldrb	r1, [r4, r0]
c0d05c44:	4620      	mov	r0, r4
c0d05c46:	3020      	adds	r0, #32
        || (service->waitAsynchronousResponse != U2F_WAIT_ASYNCH_ON 
c0d05c48:	2901      	cmp	r1, #1
c0d05c4a:	d019      	beq.n	c0d05c80 <u2f_transport_sent+0x48>
c0d05c4c:	2900      	cmp	r1, #0
c0d05c4e:	d10e      	bne.n	c0d05c6e <u2f_transport_sent+0x36>
c0d05c50:	2100      	movs	r1, #0
c0d05c52:	72c1      	strb	r1, [r0, #11]
    if (service->transportState != U2F_SENDING_RESPONSE 
c0d05c54:	7801      	ldrb	r1, [r0, #0]
        && service->transportState != U2F_SENDING_ERROR) {
c0d05c56:	1ec9      	subs	r1, r1, #3
c0d05c58:	2901      	cmp	r1, #1
c0d05c5a:	d813      	bhi.n	c0d05c84 <u2f_transport_sent+0x4c>
    if (service->transportOffset < service->transportLength) {
c0d05c5c:	8b22      	ldrh	r2, [r4, #24]
c0d05c5e:	8ae3      	ldrh	r3, [r4, #22]
c0d05c60:	429a      	cmp	r2, r3
c0d05c62:	d911      	bls.n	c0d05c88 <u2f_transport_sent+0x50>
            (service->transportPacketIndex == 0 ? (channelHeader + 3)
c0d05c64:	7ea1      	ldrb	r1, [r4, #26]
c0d05c66:	2900      	cmp	r1, #0
c0d05c68:	d01a      	beq.n	c0d05ca0 <u2f_transport_sent+0x68>
c0d05c6a:	2001      	movs	r0, #1
c0d05c6c:	e019      	b.n	c0d05ca2 <u2f_transport_sent+0x6a>
            && service->fakeChannelTransportState == U2F_FAKE_RECEIVED 
c0d05c6e:	7941      	ldrb	r1, [r0, #5]
            && service->sending == false)
c0d05c70:	2906      	cmp	r1, #6
c0d05c72:	d105      	bne.n	c0d05c80 <u2f_transport_sent+0x48>
c0d05c74:	7ac1      	ldrb	r1, [r0, #11]
c0d05c76:	2200      	movs	r2, #0
c0d05c78:	72c2      	strb	r2, [r0, #11]
    if (!u2f_message_repliable(service)) {
c0d05c7a:	2900      	cmp	r1, #0
c0d05c7c:	d102      	bne.n	c0d05c84 <u2f_transport_sent+0x4c>
c0d05c7e:	e7e9      	b.n	c0d05c54 <u2f_transport_sent+0x1c>
c0d05c80:	2100      	movs	r1, #0
c0d05c82:	72c1      	strb	r1, [r0, #11]
}
c0d05c84:	b001      	add	sp, #4
c0d05c86:	bdf0      	pop	{r4, r5, r6, r7, pc}
    else if (service->transportOffset == service->transportLength) {
c0d05c88:	d1fc      	bne.n	c0d05c84 <u2f_transport_sent+0x4c>
c0d05c8a:	2100      	movs	r1, #0
    service->transportMedia = 0;
c0d05c8c:	6001      	str	r1, [r0, #0]
c0d05c8e:	8081      	strh	r1, [r0, #4]
    service->transportPacketIndex = 0;
c0d05c90:	76a1      	strb	r1, [r4, #26]
    service->transportOffset = 0;
c0d05c92:	82e1      	strh	r1, [r4, #22]
    service->waitAsynchronousResponse = U2F_WAIT_ASYNCH_IDLE;
c0d05c94:	8141      	strh	r1, [r0, #10]
        G_io_app.apdu_state = APDU_IDLE;
c0d05c96:	4823      	ldr	r0, [pc, #140]	; (c0d05d24 <u2f_transport_sent+0xec>)
c0d05c98:	7001      	strb	r1, [r0, #0]
    service->transportBuffer = service->transportReceiveBuffer;
c0d05c9a:	68e0      	ldr	r0, [r4, #12]
c0d05c9c:	61e0      	str	r0, [r4, #28]
c0d05c9e:	e7f1      	b.n	c0d05c84 <u2f_transport_sent+0x4c>
c0d05ca0:	2003      	movs	r0, #3
        uint16_t mtu = (media == U2F_MEDIA_USB) ? USB_SEGMENT_SIZE : BLE_SEGMENT_SIZE;
c0d05ca2:	1e6e      	subs	r6, r5, #1
c0d05ca4:	4277      	negs	r7, r6
c0d05ca6:	4177      	adcs	r7, r6
c0d05ca8:	00be      	lsls	r6, r7, #2
            (service->transportPacketIndex == 0 ? (channelHeader + 3)
c0d05caa:	1980      	adds	r0, r0, r6
c0d05cac:	2640      	movs	r6, #64	; 0x40
                                      (mtu - headerSize)
c0d05cae:	1a36      	subs	r6, r6, r0
        uint16_t blockSize = ((service->transportLength - service->transportOffset) >
c0d05cb0:	1ad2      	subs	r2, r2, r3
c0d05cb2:	42b2      	cmp	r2, r6
c0d05cb4:	dc00      	bgt.n	c0d05cb8 <u2f_transport_sent+0x80>
c0d05cb6:	4616      	mov	r6, r2
        if (media == U2F_MEDIA_USB) {
c0d05cb8:	2d01      	cmp	r5, #1
c0d05cba:	d10a      	bne.n	c0d05cd2 <u2f_transport_sent+0x9a>
            memcpy(G_io_usb_ep_buffer, service->channel, 4);
c0d05cbc:	6862      	ldr	r2, [r4, #4]
c0d05cbe:	4b1a      	ldr	r3, [pc, #104]	; (c0d05d28 <u2f_transport_sent+0xf0>)
c0d05cc0:	701a      	strb	r2, [r3, #0]
c0d05cc2:	0e17      	lsrs	r7, r2, #24
c0d05cc4:	70df      	strb	r7, [r3, #3]
c0d05cc6:	0c17      	lsrs	r7, r2, #16
c0d05cc8:	709f      	strb	r7, [r3, #2]
c0d05cca:	0a12      	lsrs	r2, r2, #8
c0d05ccc:	705a      	strb	r2, [r3, #1]
c0d05cce:	2204      	movs	r2, #4
c0d05cd0:	e000      	b.n	c0d05cd4 <u2f_transport_sent+0x9c>
c0d05cd2:	2200      	movs	r2, #0
        if (service->transportPacketIndex == 0) {
c0d05cd4:	2900      	cmp	r1, #0
c0d05cd6:	d001      	beq.n	c0d05cdc <u2f_transport_sent+0xa4>
            G_io_usb_ep_buffer[offset++] = (service->transportPacketIndex - 1);
c0d05cd8:	1e49      	subs	r1, r1, #1
c0d05cda:	e00a      	b.n	c0d05cf2 <u2f_transport_sent+0xba>
c0d05cdc:	4621      	mov	r1, r4
c0d05cde:	3140      	adds	r1, #64	; 0x40
            G_io_usb_ep_buffer[offset++] = service->sendCmd;
c0d05ce0:	7809      	ldrb	r1, [r1, #0]
c0d05ce2:	4b11      	ldr	r3, [pc, #68]	; (c0d05d28 <u2f_transport_sent+0xf0>)
c0d05ce4:	5499      	strb	r1, [r3, r2]
c0d05ce6:	2101      	movs	r1, #1
c0d05ce8:	4311      	orrs	r1, r2
            G_io_usb_ep_buffer[offset++] = (service->transportLength >> 8);
c0d05cea:	7e62      	ldrb	r2, [r4, #25]
c0d05cec:	545a      	strb	r2, [r3, r1]
c0d05cee:	1c4a      	adds	r2, r1, #1
            G_io_usb_ep_buffer[offset++] = (service->transportLength & 0xff);
c0d05cf0:	7e21      	ldrb	r1, [r4, #24]
c0d05cf2:	1837      	adds	r7, r6, r0
c0d05cf4:	4b0c      	ldr	r3, [pc, #48]	; (c0d05d28 <u2f_transport_sent+0xf0>)
c0d05cf6:	5499      	strb	r1, [r3, r2]
        if (service->transportBuffer != NULL) {
c0d05cf8:	69e1      	ldr	r1, [r4, #28]
c0d05cfa:	2900      	cmp	r1, #0
c0d05cfc:	d005      	beq.n	c0d05d0a <u2f_transport_sent+0xd2>
c0d05cfe:	b2b2      	uxth	r2, r6
            memmove(G_io_usb_ep_buffer + headerSize,
c0d05d00:	1818      	adds	r0, r3, r0
                       service->transportBuffer + service->transportOffset, blockSize);
c0d05d02:	8ae3      	ldrh	r3, [r4, #22]
c0d05d04:	18c9      	adds	r1, r1, r3
            memmove(G_io_usb_ep_buffer + headerSize,
c0d05d06:	f002 fc0a 	bl	c0d0851e <__aeabi_memmove>
        service->transportOffset += blockSize;
c0d05d0a:	8ae0      	ldrh	r0, [r4, #22]
c0d05d0c:	1980      	adds	r0, r0, r6
c0d05d0e:	82e0      	strh	r0, [r4, #22]
        service->transportPacketIndex++;
c0d05d10:	7ea0      	ldrb	r0, [r4, #26]
c0d05d12:	1c40      	adds	r0, r0, #1
c0d05d14:	76a0      	strb	r0, [r4, #26]
        u2f_io_send(G_io_usb_ep_buffer, dataSize, media);
c0d05d16:	b2b9      	uxth	r1, r7
c0d05d18:	4803      	ldr	r0, [pc, #12]	; (c0d05d28 <u2f_transport_sent+0xf0>)
c0d05d1a:	462a      	mov	r2, r5
c0d05d1c:	f7ff ff60 	bl	c0d05be0 <u2f_io_send>
c0d05d20:	e7b0      	b.n	c0d05c84 <u2f_transport_sent+0x4c>
c0d05d22:	46c0      	nop			; (mov r8, r8)
c0d05d24:	200003d8 	.word	0x200003d8
c0d05d28:	2000043c 	.word	0x2000043c

c0d05d2c <u2f_message_repliable>:
bool u2f_message_repliable(u2f_service_t* service) {
c0d05d2c:	212a      	movs	r1, #42	; 0x2a
    return service->waitAsynchronousResponse == U2F_WAIT_ASYNCH_IDLE
c0d05d2e:	5c41      	ldrb	r1, [r0, r1]
        || (service->waitAsynchronousResponse != U2F_WAIT_ASYNCH_ON 
c0d05d30:	2900      	cmp	r1, #0
c0d05d32:	d00b      	beq.n	c0d05d4c <u2f_message_repliable+0x20>
c0d05d34:	2901      	cmp	r1, #1
c0d05d36:	d007      	beq.n	c0d05d48 <u2f_message_repliable+0x1c>
c0d05d38:	3025      	adds	r0, #37	; 0x25
            && service->fakeChannelTransportState == U2F_FAKE_RECEIVED 
c0d05d3a:	7801      	ldrb	r1, [r0, #0]
            && service->sending == false)
c0d05d3c:	2906      	cmp	r1, #6
c0d05d3e:	d103      	bne.n	c0d05d48 <u2f_message_repliable+0x1c>
c0d05d40:	7981      	ldrb	r1, [r0, #6]
c0d05d42:	4248      	negs	r0, r1
c0d05d44:	4148      	adcs	r0, r1
    return service->waitAsynchronousResponse == U2F_WAIT_ASYNCH_IDLE
c0d05d46:	4770      	bx	lr
c0d05d48:	2000      	movs	r0, #0
c0d05d4a:	4770      	bx	lr
c0d05d4c:	2001      	movs	r0, #1
c0d05d4e:	4770      	bx	lr

c0d05d50 <u2f_transport_receive_fakeChannel>:
bool u2f_transport_receive_fakeChannel(u2f_service_t *service, uint8_t *buffer, uint16_t size) {
c0d05d50:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d05d52:	b081      	sub	sp, #4
c0d05d54:	4604      	mov	r4, r0
c0d05d56:	2025      	movs	r0, #37	; 0x25
    if (service->fakeChannelTransportState == U2F_INTERNAL_ERROR) {
c0d05d58:	5c20      	ldrb	r0, [r4, r0]
c0d05d5a:	2805      	cmp	r0, #5
c0d05d5c:	d101      	bne.n	c0d05d62 <u2f_transport_receive_fakeChannel+0x12>
c0d05d5e:	2500      	movs	r5, #0
c0d05d60:	e081      	b.n	c0d05e66 <u2f_transport_receive_fakeChannel+0x116>
c0d05d62:	4626      	mov	r6, r4
c0d05d64:	3624      	adds	r6, #36	; 0x24
    if (memcmp(service->channel, buffer, 4) != 0) {
c0d05d66:	7808      	ldrb	r0, [r1, #0]
c0d05d68:	784b      	ldrb	r3, [r1, #1]
c0d05d6a:	021b      	lsls	r3, r3, #8
c0d05d6c:	1818      	adds	r0, r3, r0
c0d05d6e:	788b      	ldrb	r3, [r1, #2]
c0d05d70:	78cd      	ldrb	r5, [r1, #3]
c0d05d72:	022d      	lsls	r5, r5, #8
c0d05d74:	18eb      	adds	r3, r5, r3
c0d05d76:	041b      	lsls	r3, r3, #16
c0d05d78:	1818      	adds	r0, r3, r0
c0d05d7a:	7923      	ldrb	r3, [r4, #4]
c0d05d7c:	7965      	ldrb	r5, [r4, #5]
c0d05d7e:	022d      	lsls	r5, r5, #8
c0d05d80:	18eb      	adds	r3, r5, r3
c0d05d82:	79a5      	ldrb	r5, [r4, #6]
c0d05d84:	79e7      	ldrb	r7, [r4, #7]
c0d05d86:	023f      	lsls	r7, r7, #8
c0d05d88:	197d      	adds	r5, r7, r5
c0d05d8a:	042d      	lsls	r5, r5, #16
c0d05d8c:	18eb      	adds	r3, r5, r3
c0d05d8e:	4283      	cmp	r3, r0
c0d05d90:	d16c      	bne.n	c0d05e6c <u2f_transport_receive_fakeChannel+0x11c>
c0d05d92:	790b      	ldrb	r3, [r1, #4]
    if (service->fakeChannelTransportOffset == 0) {        
c0d05d94:	8c60      	ldrh	r0, [r4, #34]	; 0x22
c0d05d96:	2800      	cmp	r0, #0
c0d05d98:	d010      	beq.n	c0d05dbc <u2f_transport_receive_fakeChannel+0x6c>
        if (buffer[4] != service->fakeChannelTransportPacketIndex) {
c0d05d9a:	7835      	ldrb	r5, [r6, #0]
c0d05d9c:	42ab      	cmp	r3, r5
c0d05d9e:	d165      	bne.n	c0d05e6c <u2f_transport_receive_fakeChannel+0x11c>
        service->fakeChannelTransportPacketIndex++;
c0d05da0:	1c5b      	adds	r3, r3, #1
c0d05da2:	7033      	strb	r3, [r6, #0]
        uint16_t xfer_len = MIN(size - 5, service->transportLength - service->fakeChannelTransportOffset);
c0d05da4:	8b23      	ldrh	r3, [r4, #24]
c0d05da6:	1a1b      	subs	r3, r3, r0
c0d05da8:	1f52      	subs	r2, r2, #5
c0d05daa:	429a      	cmp	r2, r3
c0d05dac:	db00      	blt.n	c0d05db0 <u2f_transport_receive_fakeChannel+0x60>
c0d05dae:	461a      	mov	r2, r3
        service->fakeChannelTransportOffset += xfer_len;
c0d05db0:	1880      	adds	r0, r0, r2
c0d05db2:	8460      	strh	r0, [r4, #34]	; 0x22
c0d05db4:	b292      	uxth	r2, r2
        service->fakeChannelCrc = cx_crc16_update(service->fakeChannelCrc, buffer + 5, xfer_len);   
c0d05db6:	8d20      	ldrh	r0, [r4, #40]	; 0x28
c0d05db8:	1d49      	adds	r1, r1, #5
c0d05dba:	e02a      	b.n	c0d05e12 <u2f_transport_receive_fakeChannel+0xc2>
        if (buffer[4] == U2F_CMD_WINK) {
c0d05dbc:	2b88      	cmp	r3, #136	; 0x88
c0d05dbe:	d114      	bne.n	c0d05dea <u2f_transport_receive_fakeChannel+0x9a>
c0d05dc0:	2501      	movs	r5, #1
    service->sending = true;
c0d05dc2:	71f5      	strb	r5, [r6, #7]
    memcpy(G_io_usb_ep_buffer, service->channel, 4);
c0d05dc4:	6861      	ldr	r1, [r4, #4]
c0d05dc6:	482b      	ldr	r0, [pc, #172]	; (c0d05e74 <u2f_transport_receive_fakeChannel+0x124>)
c0d05dc8:	7001      	strb	r1, [r0, #0]
c0d05dca:	2200      	movs	r2, #0
    G_io_usb_ep_buffer[offset++] = 0;
c0d05dcc:	7182      	strb	r2, [r0, #6]
    G_io_usb_ep_buffer[offset++] = 0;
c0d05dce:	7142      	strb	r2, [r0, #5]
c0d05dd0:	2288      	movs	r2, #136	; 0x88
    G_io_usb_ep_buffer[offset++] = U2F_CMD_WINK;
c0d05dd2:	7102      	strb	r2, [r0, #4]
    memcpy(G_io_usb_ep_buffer, service->channel, 4);
c0d05dd4:	0e0a      	lsrs	r2, r1, #24
c0d05dd6:	70c2      	strb	r2, [r0, #3]
c0d05dd8:	0c0a      	lsrs	r2, r1, #16
c0d05dda:	7082      	strb	r2, [r0, #2]
c0d05ddc:	0a09      	lsrs	r1, r1, #8
c0d05dde:	7041      	strb	r1, [r0, #1]
c0d05de0:	2107      	movs	r1, #7
    u2f_io_send(G_io_usb_ep_buffer, offset, U2F_MEDIA_USB);
c0d05de2:	462a      	mov	r2, r5
c0d05de4:	f7ff fefc 	bl	c0d05be0 <u2f_io_send>
c0d05de8:	e03d      	b.n	c0d05e66 <u2f_transport_receive_fakeChannel+0x116>
        if (commandLength != service->transportLength) {
c0d05dea:	2b83      	cmp	r3, #131	; 0x83
c0d05dec:	d13e      	bne.n	c0d05e6c <u2f_transport_receive_fakeChannel+0x11c>
c0d05dee:	7988      	ldrb	r0, [r1, #6]
c0d05df0:	794b      	ldrb	r3, [r1, #5]
c0d05df2:	021b      	lsls	r3, r3, #8
c0d05df4:	1818      	adds	r0, r3, r0
c0d05df6:	1cc0      	adds	r0, r0, #3
c0d05df8:	8b23      	ldrh	r3, [r4, #24]
c0d05dfa:	b280      	uxth	r0, r0
c0d05dfc:	4298      	cmp	r0, r3
c0d05dfe:	d135      	bne.n	c0d05e6c <u2f_transport_receive_fakeChannel+0x11c>
c0d05e00:	1d09      	adds	r1, r1, #4
c0d05e02:	2000      	movs	r0, #0
        service->fakeChannelTransportPacketIndex = 0;
c0d05e04:	7030      	strb	r0, [r6, #0]
        service->fakeChannelTransportOffset = MIN(size - 4, service->transportLength);
c0d05e06:	1f12      	subs	r2, r2, #4
c0d05e08:	429a      	cmp	r2, r3
c0d05e0a:	db00      	blt.n	c0d05e0e <u2f_transport_receive_fakeChannel+0xbe>
c0d05e0c:	461a      	mov	r2, r3
c0d05e0e:	8462      	strh	r2, [r4, #34]	; 0x22
        service->fakeChannelCrc = cx_crc16_update(0, buffer + 4, service->fakeChannelTransportOffset);
c0d05e10:	b292      	uxth	r2, r2
c0d05e12:	f7fa fb09 	bl	c0d00428 <cx_crc16_update>
c0d05e16:	8520      	strh	r0, [r4, #40]	; 0x28
    if (service->fakeChannelTransportOffset >= service->transportLength) {
c0d05e18:	8b21      	ldrh	r1, [r4, #24]
c0d05e1a:	8c62      	ldrh	r2, [r4, #34]	; 0x22
c0d05e1c:	2501      	movs	r5, #1
c0d05e1e:	428a      	cmp	r2, r1
c0d05e20:	d321      	bcc.n	c0d05e66 <u2f_transport_receive_fakeChannel+0x116>
        if (service->fakeChannelCrc != service->commandCrc) {
c0d05e22:	8ce1      	ldrh	r1, [r4, #38]	; 0x26
c0d05e24:	4288      	cmp	r0, r1
c0d05e26:	d121      	bne.n	c0d05e6c <u2f_transport_receive_fakeChannel+0x11c>
c0d05e28:	2700      	movs	r7, #0
        service->fakeChannelTransportOffset = 0;
c0d05e2a:	8467      	strh	r7, [r4, #34]	; 0x22
c0d05e2c:	2006      	movs	r0, #6
        service->fakeChannelTransportState = U2F_FAKE_RECEIVED;
c0d05e2e:	7070      	strb	r0, [r6, #1]
        if (service->waitAsynchronousResponse == U2F_WAIT_ASYNCH_ON) {
c0d05e30:	79b0      	ldrb	r0, [r6, #6]
c0d05e32:	2801      	cmp	r0, #1
c0d05e34:	d117      	bne.n	c0d05e66 <u2f_transport_receive_fakeChannel+0x116>
c0d05e36:	2201      	movs	r2, #1
    service->sending = true;
c0d05e38:	71f2      	strb	r2, [r6, #7]
    memcpy(G_io_usb_ep_buffer, service->channel, 4);
c0d05e3a:	6861      	ldr	r1, [r4, #4]
c0d05e3c:	480d      	ldr	r0, [pc, #52]	; (c0d05e74 <u2f_transport_receive_fakeChannel+0x124>)
c0d05e3e:	7001      	strb	r1, [r0, #0]
c0d05e40:	2385      	movs	r3, #133	; 0x85
    G_io_usb_ep_buffer[offset++] = 0x85;
c0d05e42:	7203      	strb	r3, [r0, #8]
c0d05e44:	2369      	movs	r3, #105	; 0x69
    G_io_usb_ep_buffer[offset++] = 0x69;
c0d05e46:	71c3      	strb	r3, [r0, #7]
c0d05e48:	2302      	movs	r3, #2
    G_io_usb_ep_buffer[offset++] = 2;
c0d05e4a:	7183      	strb	r3, [r0, #6]
    G_io_usb_ep_buffer[offset++] = 0;
c0d05e4c:	7147      	strb	r7, [r0, #5]
c0d05e4e:	2383      	movs	r3, #131	; 0x83
    G_io_usb_ep_buffer[offset++] = U2F_CMD_MSG;
c0d05e50:	7103      	strb	r3, [r0, #4]
    memcpy(G_io_usb_ep_buffer, service->channel, 4);
c0d05e52:	0e0b      	lsrs	r3, r1, #24
c0d05e54:	70c3      	strb	r3, [r0, #3]
c0d05e56:	0c0b      	lsrs	r3, r1, #16
c0d05e58:	7083      	strb	r3, [r0, #2]
c0d05e5a:	0a09      	lsrs	r1, r1, #8
c0d05e5c:	7041      	strb	r1, [r0, #1]
c0d05e5e:	2109      	movs	r1, #9
    u2f_io_send(G_io_usb_ep_buffer, offset, U2F_MEDIA_USB);
c0d05e60:	f7ff febe 	bl	c0d05be0 <u2f_io_send>
            service->fakeChannelTransportState = U2F_IDLE;
c0d05e64:	7077      	strb	r7, [r6, #1]
}
c0d05e66:	4628      	mov	r0, r5
c0d05e68:	b001      	add	sp, #4
c0d05e6a:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d05e6c:	2005      	movs	r0, #5
    service->fakeChannelTransportState = U2F_INTERNAL_ERROR;
c0d05e6e:	7070      	strb	r0, [r6, #1]
    THROW(EXCEPTION_IO_RESET);
c0d05e70:	f7fc f990 	bl	c0d02194 <os_longjmp>
c0d05e74:	2000043c 	.word	0x2000043c

c0d05e78 <u2f_transport_received>:
                          uint16_t size, u2f_transport_media_t media) {
c0d05e78:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d05e7a:	b089      	sub	sp, #36	; 0x24
c0d05e7c:	4604      	mov	r4, r0
    service->media = media;
c0d05e7e:	7203      	strb	r3, [r0, #8]
c0d05e80:	2020      	movs	r0, #32
    if (service->transportState == U2F_SENDING_RESPONSE) {
c0d05e82:	5c26      	ldrb	r6, [r4, r0]
c0d05e84:	4627      	mov	r7, r4
c0d05e86:	3720      	adds	r7, #32
c0d05e88:	4625      	mov	r5, r4
c0d05e8a:	3540      	adds	r5, #64	; 0x40
c0d05e8c:	2e03      	cmp	r6, #3
c0d05e8e:	d10c      	bne.n	c0d05eaa <u2f_transport_received+0x32>
    G_io_usb_ep_buffer[8] = errorCode;
c0d05e90:	48f1      	ldr	r0, [pc, #964]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d05e92:	2106      	movs	r1, #6
c0d05e94:	7201      	strb	r1, [r0, #8]
c0d05e96:	2100      	movs	r1, #0
    service->transportPacketIndex = 0;
c0d05e98:	76a1      	strb	r1, [r4, #26]
c0d05e9a:	2201      	movs	r2, #1
    service->transportLength = 1;
c0d05e9c:	8322      	strh	r2, [r4, #24]
    service->transportOffset = 0;
c0d05e9e:	82e1      	strh	r1, [r4, #22]
    G_io_usb_ep_buffer[8] = errorCode;
c0d05ea0:	3008      	adds	r0, #8
    service->transportBuffer = G_io_usb_ep_buffer + 8;
c0d05ea2:	61e0      	str	r0, [r4, #28]
c0d05ea4:	2004      	movs	r0, #4
    service->transportState = U2F_SENDING_ERROR;
c0d05ea6:	7038      	strb	r0, [r7, #0]
c0d05ea8:	e018      	b.n	c0d05edc <u2f_transport_received+0x64>
c0d05eaa:	9708      	str	r7, [sp, #32]
c0d05eac:	9307      	str	r3, [sp, #28]
c0d05eae:	4627      	mov	r7, r4
c0d05eb0:	3712      	adds	r7, #18
    if (service->waitAsynchronousResponse != U2F_WAIT_ASYNCH_IDLE) {
c0d05eb2:	7e38      	ldrb	r0, [r7, #24]
c0d05eb4:	2800      	cmp	r0, #0
c0d05eb6:	d019      	beq.n	c0d05eec <u2f_transport_received+0x74>
        if (!u2f_transport_receive_fakeChannel(service, buffer, size)) {
c0d05eb8:	4620      	mov	r0, r4
c0d05eba:	f7ff ff49 	bl	c0d05d50 <u2f_transport_receive_fakeChannel>
c0d05ebe:	2800      	cmp	r0, #0
c0d05ec0:	d112      	bne.n	c0d05ee8 <u2f_transport_received+0x70>
c0d05ec2:	48e5      	ldr	r0, [pc, #916]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d05ec4:	2106      	movs	r1, #6
c0d05ec6:	7201      	strb	r1, [r0, #8]
c0d05ec8:	2100      	movs	r1, #0
c0d05eca:	76a1      	strb	r1, [r4, #26]
c0d05ecc:	2201      	movs	r2, #1
c0d05ece:	8322      	strh	r2, [r4, #24]
c0d05ed0:	82e1      	strh	r1, [r4, #22]
c0d05ed2:	3008      	adds	r0, #8
c0d05ed4:	61e0      	str	r0, [r4, #28]
c0d05ed6:	2004      	movs	r0, #4
c0d05ed8:	9908      	ldr	r1, [sp, #32]
c0d05eda:	7008      	strb	r0, [r1, #0]
c0d05edc:	20bf      	movs	r0, #191	; 0xbf
c0d05ede:	7028      	strb	r0, [r5, #0]
c0d05ee0:	7a21      	ldrb	r1, [r4, #8]
c0d05ee2:	4620      	mov	r0, r4
c0d05ee4:	f7ff fea8 	bl	c0d05c38 <u2f_transport_sent>
}
c0d05ee8:	b009      	add	sp, #36	; 0x24
c0d05eea:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d05eec:	9506      	str	r5, [sp, #24]
    if (service->transportState == U2F_SENDING_ERROR) {
c0d05eee:	2e04      	cmp	r6, #4
c0d05ef0:	d108      	bne.n	c0d05f04 <u2f_transport_received+0x8c>
c0d05ef2:	2600      	movs	r6, #0
    service->transportPacketIndex = 0;
c0d05ef4:	76a6      	strb	r6, [r4, #26]
    service->transportOffset = 0;
c0d05ef6:	82e6      	strh	r6, [r4, #22]
    service->waitAsynchronousResponse = U2F_WAIT_ASYNCH_IDLE;
c0d05ef8:	833e      	strh	r6, [r7, #24]
c0d05efa:	9808      	ldr	r0, [sp, #32]
    service->transportMedia = 0;
c0d05efc:	6006      	str	r6, [r0, #0]
c0d05efe:	8086      	strh	r6, [r0, #4]
    service->transportBuffer = service->transportReceiveBuffer;
c0d05f00:	68e0      	ldr	r0, [r4, #12]
c0d05f02:	61e0      	str	r0, [r4, #28]
c0d05f04:	9b07      	ldr	r3, [sp, #28]
    uint16_t channelHeader = (media == U2F_MEDIA_USB ? 4 : 0);
c0d05f06:	1e58      	subs	r0, r3, #1
c0d05f08:	4245      	negs	r5, r0
c0d05f0a:	4145      	adcs	r5, r0
    if (size < (1 + channelHeader)) {
c0d05f0c:	00a8      	lsls	r0, r5, #2
c0d05f0e:	9005      	str	r0, [sp, #20]
c0d05f10:	1c40      	adds	r0, r0, #1
c0d05f12:	4290      	cmp	r0, r2
c0d05f14:	d83c      	bhi.n	c0d05f90 <u2f_transport_received+0x118>
c0d05f16:	9004      	str	r0, [sp, #16]
    if (media == U2F_MEDIA_USB) {
c0d05f18:	2b01      	cmp	r3, #1
c0d05f1a:	d10a      	bne.n	c0d05f32 <u2f_transport_received+0xba>
        memcpy(service->channel, buffer, 4);
c0d05f1c:	7808      	ldrb	r0, [r1, #0]
c0d05f1e:	784d      	ldrb	r5, [r1, #1]
c0d05f20:	022d      	lsls	r5, r5, #8
c0d05f22:	182b      	adds	r3, r5, r0
c0d05f24:	788d      	ldrb	r5, [r1, #2]
c0d05f26:	78c8      	ldrb	r0, [r1, #3]
c0d05f28:	0200      	lsls	r0, r0, #8
c0d05f2a:	1940      	adds	r0, r0, r5
c0d05f2c:	0400      	lsls	r0, r0, #16
c0d05f2e:	18c0      	adds	r0, r0, r3
c0d05f30:	6060      	str	r0, [r4, #4]
    if (service->transportOffset == 0
c0d05f32:	8ae0      	ldrh	r0, [r4, #22]
c0d05f34:	9003      	str	r0, [sp, #12]
        || (media == U2F_MEDIA_USB && memcmp(service->transportChannel, service->channel, 4) != 0)
c0d05f36:	2800      	cmp	r0, #0
c0d05f38:	9d06      	ldr	r5, [sp, #24]
c0d05f3a:	9b05      	ldr	r3, [sp, #20]
c0d05f3c:	d022      	beq.n	c0d05f84 <u2f_transport_received+0x10c>
c0d05f3e:	9807      	ldr	r0, [sp, #28]
c0d05f40:	2801      	cmp	r0, #1
c0d05f42:	d11c      	bne.n	c0d05f7e <u2f_transport_received+0x106>
c0d05f44:	7920      	ldrb	r0, [r4, #4]
c0d05f46:	7965      	ldrb	r5, [r4, #5]
c0d05f48:	022d      	lsls	r5, r5, #8
c0d05f4a:	1828      	adds	r0, r5, r0
c0d05f4c:	9002      	str	r0, [sp, #8]
c0d05f4e:	79a5      	ldrb	r5, [r4, #6]
c0d05f50:	79e0      	ldrb	r0, [r4, #7]
c0d05f52:	0200      	lsls	r0, r0, #8
c0d05f54:	1940      	adds	r0, r0, r5
c0d05f56:	0400      	lsls	r0, r0, #16
c0d05f58:	9d02      	ldr	r5, [sp, #8]
c0d05f5a:	1940      	adds	r0, r0, r5
c0d05f5c:	9002      	str	r0, [sp, #8]
c0d05f5e:	7ca5      	ldrb	r5, [r4, #18]
c0d05f60:	7ce0      	ldrb	r0, [r4, #19]
c0d05f62:	0200      	lsls	r0, r0, #8
c0d05f64:	1940      	adds	r0, r0, r5
c0d05f66:	9001      	str	r0, [sp, #4]
c0d05f68:	7d25      	ldrb	r5, [r4, #20]
c0d05f6a:	7d60      	ldrb	r0, [r4, #21]
c0d05f6c:	0200      	lsls	r0, r0, #8
c0d05f6e:	1940      	adds	r0, r0, r5
c0d05f70:	0400      	lsls	r0, r0, #16
c0d05f72:	9d01      	ldr	r5, [sp, #4]
c0d05f74:	1940      	adds	r0, r0, r5
        || (buffer[channelHeader] == U2F_CMD_INIT)) {
c0d05f76:	9d02      	ldr	r5, [sp, #8]
c0d05f78:	42a8      	cmp	r0, r5
c0d05f7a:	9d06      	ldr	r5, [sp, #24]
c0d05f7c:	d102      	bne.n	c0d05f84 <u2f_transport_received+0x10c>
c0d05f7e:	5cc8      	ldrb	r0, [r1, r3]
    if (service->transportOffset == 0
c0d05f80:	2886      	cmp	r0, #134	; 0x86
c0d05f82:	d159      	bne.n	c0d06038 <u2f_transport_received+0x1c0>
c0d05f84:	2503      	movs	r5, #3
        if (size < (channelHeader + 3)) {
c0d05f86:	4618      	mov	r0, r3
c0d05f88:	9503      	str	r5, [sp, #12]
c0d05f8a:	4328      	orrs	r0, r5
c0d05f8c:	4290      	cmp	r0, r2
c0d05f8e:	d910      	bls.n	c0d05fb2 <u2f_transport_received+0x13a>
c0d05f90:	48b1      	ldr	r0, [pc, #708]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d05f92:	2185      	movs	r1, #133	; 0x85
c0d05f94:	7201      	strb	r1, [r0, #8]
c0d05f96:	2100      	movs	r1, #0
c0d05f98:	76a1      	strb	r1, [r4, #26]
c0d05f9a:	2201      	movs	r2, #1
c0d05f9c:	8322      	strh	r2, [r4, #24]
c0d05f9e:	82e1      	strh	r1, [r4, #22]
c0d05fa0:	3008      	adds	r0, #8
c0d05fa2:	61e0      	str	r0, [r4, #28]
c0d05fa4:	2004      	movs	r0, #4
c0d05fa6:	9908      	ldr	r1, [sp, #32]
c0d05fa8:	7008      	strb	r0, [r1, #0]
c0d05faa:	20bf      	movs	r0, #191	; 0xbf
c0d05fac:	9906      	ldr	r1, [sp, #24]
c0d05fae:	7008      	strb	r0, [r1, #0]
c0d05fb0:	e796      	b.n	c0d05ee0 <u2f_transport_received+0x68>
        if ((buffer[channelHeader+0]&U2F_MASK_COMMAND) == 0) {
c0d05fb2:	56c8      	ldrsb	r0, [r1, r3]
c0d05fb4:	2800      	cmp	r0, #0
c0d05fb6:	9d06      	ldr	r5, [sp, #24]
c0d05fb8:	d596      	bpl.n	c0d05ee8 <u2f_transport_received+0x70>
c0d05fba:	b2c3      	uxtb	r3, r0
        if (media == U2F_MEDIA_USB) {
c0d05fbc:	9807      	ldr	r0, [sp, #28]
c0d05fbe:	2801      	cmp	r0, #1
c0d05fc0:	d000      	beq.n	c0d05fc4 <u2f_transport_received+0x14c>
c0d05fc2:	e08b      	b.n	c0d060dc <u2f_transport_received+0x264>
            if ((service->transportState == U2F_HANDLE_SEGMENTED) &&
c0d05fc4:	2e01      	cmp	r6, #1
c0d05fc6:	d000      	beq.n	c0d05fca <u2f_transport_received+0x152>
c0d05fc8:	e09c      	b.n	c0d06104 <u2f_transport_received+0x28c>
                (memcmp(service->channel, service->transportChannel, 4) !=
c0d05fca:	7ca0      	ldrb	r0, [r4, #18]
c0d05fcc:	7ce5      	ldrb	r5, [r4, #19]
c0d05fce:	022d      	lsls	r5, r5, #8
c0d05fd0:	1828      	adds	r0, r5, r0
c0d05fd2:	9002      	str	r0, [sp, #8]
c0d05fd4:	7d25      	ldrb	r5, [r4, #20]
c0d05fd6:	7d60      	ldrb	r0, [r4, #21]
c0d05fd8:	0200      	lsls	r0, r0, #8
c0d05fda:	1940      	adds	r0, r0, r5
c0d05fdc:	0400      	lsls	r0, r0, #16
c0d05fde:	9d02      	ldr	r5, [sp, #8]
c0d05fe0:	1940      	adds	r0, r0, r5
c0d05fe2:	9002      	str	r0, [sp, #8]
c0d05fe4:	7925      	ldrb	r5, [r4, #4]
c0d05fe6:	7960      	ldrb	r0, [r4, #5]
c0d05fe8:	0200      	lsls	r0, r0, #8
c0d05fea:	1940      	adds	r0, r0, r5
c0d05fec:	9001      	str	r0, [sp, #4]
c0d05fee:	79a5      	ldrb	r5, [r4, #6]
c0d05ff0:	79e0      	ldrb	r0, [r4, #7]
c0d05ff2:	0200      	lsls	r0, r0, #8
c0d05ff4:	1940      	adds	r0, r0, r5
c0d05ff6:	0400      	lsls	r0, r0, #16
c0d05ff8:	9d01      	ldr	r5, [sp, #4]
c0d05ffa:	1940      	adds	r0, r0, r5
c0d05ffc:	9d02      	ldr	r5, [sp, #8]
c0d05ffe:	1b45      	subs	r5, r0, r5
c0d06000:	1e68      	subs	r0, r5, #1
c0d06002:	4185      	sbcs	r5, r0
                 0) &&
c0d06004:	2b86      	cmp	r3, #134	; 0x86
c0d06006:	d069      	beq.n	c0d060dc <u2f_transport_received+0x264>
c0d06008:	2d00      	cmp	r5, #0
c0d0600a:	d067      	beq.n	c0d060dc <u2f_transport_received+0x264>
c0d0600c:	1d20      	adds	r0, r4, #4
                    memcpy(G_io_usb_ep_buffer, service->channel, 4);
c0d0600e:	6801      	ldr	r1, [r0, #0]
c0d06010:	4891      	ldr	r0, [pc, #580]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d06012:	7001      	strb	r1, [r0, #0]
c0d06014:	2206      	movs	r2, #6
                G_io_usb_ep_buffer[offset++] = ERROR_CHANNEL_BUSY;
c0d06016:	71c2      	strb	r2, [r0, #7]
c0d06018:	2201      	movs	r2, #1
                G_io_usb_ep_buffer[offset++] = 1;
c0d0601a:	7182      	strb	r2, [r0, #6]
c0d0601c:	2300      	movs	r3, #0
                G_io_usb_ep_buffer[offset++] = 0;
c0d0601e:	7143      	strb	r3, [r0, #5]
c0d06020:	23bf      	movs	r3, #191	; 0xbf
                G_io_usb_ep_buffer[offset++] = U2F_STATUS_ERROR;
c0d06022:	7103      	strb	r3, [r0, #4]
                    memcpy(G_io_usb_ep_buffer, service->channel, 4);
c0d06024:	0e0b      	lsrs	r3, r1, #24
c0d06026:	70c3      	strb	r3, [r0, #3]
c0d06028:	0c0b      	lsrs	r3, r1, #16
c0d0602a:	7083      	strb	r3, [r0, #2]
c0d0602c:	0a09      	lsrs	r1, r1, #8
c0d0602e:	7041      	strb	r1, [r0, #1]
c0d06030:	2108      	movs	r1, #8
                u2f_io_send(G_io_usb_ep_buffer, offset, media);
c0d06032:	f7ff fdd5 	bl	c0d05be0 <u2f_io_send>
c0d06036:	e757      	b.n	c0d05ee8 <u2f_transport_received+0x70>
c0d06038:	9002      	str	r0, [sp, #8]
c0d0603a:	2002      	movs	r0, #2
        if (size < (channelHeader + 2)) {
c0d0603c:	4318      	orrs	r0, r3
c0d0603e:	4290      	cmp	r0, r2
c0d06040:	d902      	bls.n	c0d06048 <u2f_transport_received+0x1d0>
    G_io_usb_ep_buffer[8] = errorCode;
c0d06042:	4885      	ldr	r0, [pc, #532]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d06044:	2185      	movs	r1, #133	; 0x85
c0d06046:	e73e      	b.n	c0d05ec6 <u2f_transport_received+0x4e>
        if (media != service->transportMedia) {
c0d06048:	7bf8      	ldrb	r0, [r7, #15]
c0d0604a:	9b07      	ldr	r3, [sp, #28]
c0d0604c:	4298      	cmp	r0, r3
c0d0604e:	d167      	bne.n	c0d06120 <u2f_transport_received+0x2a8>
        if (service->transportState != U2F_HANDLE_SEGMENTED) {
c0d06050:	2e01      	cmp	r6, #1
c0d06052:	d000      	beq.n	c0d06056 <u2f_transport_received+0x1de>
c0d06054:	e085      	b.n	c0d06162 <u2f_transport_received+0x2ea>
        if (media == U2F_MEDIA_USB) {
c0d06056:	9807      	ldr	r0, [sp, #28]
c0d06058:	2801      	cmp	r0, #1
c0d0605a:	d117      	bne.n	c0d0608c <u2f_transport_received+0x214>
            if (memcmp(buffer, service->channel, 4) != 0) {
c0d0605c:	7920      	ldrb	r0, [r4, #4]
c0d0605e:	7963      	ldrb	r3, [r4, #5]
c0d06060:	021b      	lsls	r3, r3, #8
c0d06062:	1818      	adds	r0, r3, r0
c0d06064:	79a3      	ldrb	r3, [r4, #6]
c0d06066:	79e5      	ldrb	r5, [r4, #7]
c0d06068:	022d      	lsls	r5, r5, #8
c0d0606a:	18eb      	adds	r3, r5, r3
c0d0606c:	041b      	lsls	r3, r3, #16
c0d0606e:	1818      	adds	r0, r3, r0
c0d06070:	780b      	ldrb	r3, [r1, #0]
c0d06072:	784d      	ldrb	r5, [r1, #1]
c0d06074:	022d      	lsls	r5, r5, #8
c0d06076:	18eb      	adds	r3, r5, r3
c0d06078:	788d      	ldrb	r5, [r1, #2]
c0d0607a:	78cf      	ldrb	r7, [r1, #3]
c0d0607c:	023f      	lsls	r7, r7, #8
c0d0607e:	197d      	adds	r5, r7, r5
c0d06080:	042d      	lsls	r5, r5, #16
c0d06082:	18eb      	adds	r3, r5, r3
c0d06084:	9d06      	ldr	r5, [sp, #24]
c0d06086:	4283      	cmp	r3, r0
c0d06088:	d000      	beq.n	c0d0608c <u2f_transport_received+0x214>
c0d0608a:	e71a      	b.n	c0d05ec2 <u2f_transport_received+0x4a>
        if (buffer[channelHeader] != service->transportPacketIndex) {
c0d0608c:	7ea0      	ldrb	r0, [r4, #26]
c0d0608e:	9b02      	ldr	r3, [sp, #8]
c0d06090:	4283      	cmp	r3, r0
c0d06092:	d173      	bne.n	c0d0617c <u2f_transport_received+0x304>
c0d06094:	9805      	ldr	r0, [sp, #20]
c0d06096:	1809      	adds	r1, r1, r0
        xfer_len = MIN(size - (channelHeader + 1), service->transportLength - service->transportOffset);
c0d06098:	9804      	ldr	r0, [sp, #16]
c0d0609a:	1a17      	subs	r7, r2, r0
c0d0609c:	8b20      	ldrh	r0, [r4, #24]
c0d0609e:	9a03      	ldr	r2, [sp, #12]
c0d060a0:	1a80      	subs	r0, r0, r2
c0d060a2:	4287      	cmp	r7, r0
c0d060a4:	db00      	blt.n	c0d060a8 <u2f_transport_received+0x230>
c0d060a6:	4607      	mov	r7, r0
        memmove(service->transportBuffer + service->transportOffset, buffer + channelHeader + 1, xfer_len);
c0d060a8:	b2be      	uxth	r6, r7
c0d060aa:	69e0      	ldr	r0, [r4, #28]
c0d060ac:	1880      	adds	r0, r0, r2
c0d060ae:	1c49      	adds	r1, r1, #1
c0d060b0:	4632      	mov	r2, r6
c0d060b2:	f002 fa34 	bl	c0d0851e <__aeabi_memmove>
        if (media == U2F_MEDIA_USB) {
c0d060b6:	9807      	ldr	r0, [sp, #28]
c0d060b8:	2801      	cmp	r0, #1
c0d060ba:	d107      	bne.n	c0d060cc <u2f_transport_received+0x254>
            service->commandCrc = cx_crc16_update(service->commandCrc, service->transportBuffer + service->transportOffset, xfer_len);
c0d060bc:	8ae0      	ldrh	r0, [r4, #22]
c0d060be:	69e1      	ldr	r1, [r4, #28]
c0d060c0:	1809      	adds	r1, r1, r0
c0d060c2:	8ce0      	ldrh	r0, [r4, #38]	; 0x26
c0d060c4:	4632      	mov	r2, r6
c0d060c6:	f7fa f9af 	bl	c0d00428 <cx_crc16_update>
c0d060ca:	84e0      	strh	r0, [r4, #38]	; 0x26
        service->transportOffset += xfer_len;
c0d060cc:	8ae0      	ldrh	r0, [r4, #22]
c0d060ce:	19c6      	adds	r6, r0, r7
c0d060d0:	82e6      	strh	r6, [r4, #22]
        service->transportPacketIndex++;
c0d060d2:	7ea0      	ldrb	r0, [r4, #26]
c0d060d4:	1c40      	adds	r0, r0, #1
c0d060d6:	76a0      	strb	r0, [r4, #26]
c0d060d8:	9907      	ldr	r1, [sp, #28]
c0d060da:	e08c      	b.n	c0d061f6 <u2f_transport_received+0x37e>
c0d060dc:	2086      	movs	r0, #134	; 0x86
              (buffer[channelHeader] == U2F_CMD_INIT))) {
c0d060de:	4058      	eors	r0, r3
c0d060e0:	9302      	str	r3, [sp, #8]
c0d060e2:	2301      	movs	r3, #1
    uint16_t channelHeader = (media == U2F_MEDIA_USB ? 4 : 0);
c0d060e4:	9d07      	ldr	r5, [sp, #28]
c0d060e6:	9301      	str	r3, [sp, #4]
c0d060e8:	405d      	eors	r5, r3
c0d060ea:	9b02      	ldr	r3, [sp, #8]
            !((media == U2F_MEDIA_USB) &&
c0d060ec:	4305      	orrs	r5, r0
c0d060ee:	9d06      	ldr	r5, [sp, #24]
        if ((service->transportState == U2F_HANDLE_SEGMENTED) &&
c0d060f0:	d008      	beq.n	c0d06104 <u2f_transport_received+0x28c>
c0d060f2:	2e01      	cmp	r6, #1
c0d060f4:	d106      	bne.n	c0d06104 <u2f_transport_received+0x28c>
    G_io_usb_ep_buffer[8] = errorCode;
c0d060f6:	4858      	ldr	r0, [pc, #352]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d060f8:	2104      	movs	r1, #4
c0d060fa:	7201      	strb	r1, [r0, #8]
c0d060fc:	2200      	movs	r2, #0
    service->transportPacketIndex = 0;
c0d060fe:	76a2      	strb	r2, [r4, #26]
    service->transportLength = 1;
c0d06100:	9b01      	ldr	r3, [sp, #4]
c0d06102:	e041      	b.n	c0d06188 <u2f_transport_received+0x310>
c0d06104:	461e      	mov	r6, r3
c0d06106:	9b04      	ldr	r3, [sp, #16]
  return (buf[off] << 8) | buf[off + 1];
c0d06108:	18c8      	adds	r0, r1, r3
c0d0610a:	7840      	ldrb	r0, [r0, #1]
c0d0610c:	5ccb      	ldrb	r3, [r1, r3]
c0d0610e:	021b      	lsls	r3, r3, #8
c0d06110:	181b      	adds	r3, r3, r0
        if (commandLength > (service->transportReceiveBufferLength - 3)) {
c0d06112:	8a20      	ldrh	r0, [r4, #16]
c0d06114:	1ec0      	subs	r0, r0, #3
c0d06116:	4298      	cmp	r0, r3
c0d06118:	da05      	bge.n	c0d06126 <u2f_transport_received+0x2ae>
    G_io_usb_ep_buffer[8] = errorCode;
c0d0611a:	484f      	ldr	r0, [pc, #316]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d0611c:	9903      	ldr	r1, [sp, #12]
c0d0611e:	e6d2      	b.n	c0d05ec6 <u2f_transport_received+0x4e>
c0d06120:	484d      	ldr	r0, [pc, #308]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d06122:	218d      	movs	r1, #141	; 0x8d
c0d06124:	e6cf      	b.n	c0d05ec6 <u2f_transport_received+0x4e>
        switch (buffer[channelHeader]) {
c0d06126:	2e81      	cmp	r6, #129	; 0x81
c0d06128:	d003      	beq.n	c0d06132 <u2f_transport_received+0x2ba>
c0d0612a:	2e86      	cmp	r6, #134	; 0x86
c0d0612c:	d033      	beq.n	c0d06196 <u2f_transport_received+0x31e>
c0d0612e:	2e83      	cmp	r6, #131	; 0x83
c0d06130:	d166      	bne.n	c0d06200 <u2f_transport_received+0x388>
            if (media == U2F_MEDIA_USB) {
c0d06132:	9807      	ldr	r0, [sp, #28]
c0d06134:	2801      	cmp	r0, #1
c0d06136:	d13d      	bne.n	c0d061b4 <u2f_transport_received+0x33c>
    return (memcmp(channel, BROADCAST_CHANNEL, 4) == 0);
c0d06138:	7920      	ldrb	r0, [r4, #4]
c0d0613a:	7965      	ldrb	r5, [r4, #5]
c0d0613c:	022d      	lsls	r5, r5, #8
c0d0613e:	182e      	adds	r6, r5, r0
c0d06140:	79a5      	ldrb	r5, [r4, #6]
c0d06142:	79e0      	ldrb	r0, [r4, #7]
c0d06144:	0200      	lsls	r0, r0, #8
c0d06146:	1940      	adds	r0, r0, r5
c0d06148:	9d06      	ldr	r5, [sp, #24]
c0d0614a:	0400      	lsls	r0, r0, #16
c0d0614c:	1980      	adds	r0, r0, r6
                if (u2f_is_channel_broadcast(service->channel) ||
c0d0614e:	1c40      	adds	r0, r0, #1
c0d06150:	d07e      	beq.n	c0d06250 <u2f_transport_received+0x3d8>
c0d06152:	1d20      	adds	r0, r4, #4
    return (memcmp(channel, FORBIDDEN_CHANNEL, 4) == 0);
c0d06154:	7806      	ldrb	r6, [r0, #0]
c0d06156:	7845      	ldrb	r5, [r0, #1]
c0d06158:	022d      	lsls	r5, r5, #8
c0d0615a:	19ae      	adds	r6, r5, r6
c0d0615c:	7885      	ldrb	r5, [r0, #2]
c0d0615e:	78c0      	ldrb	r0, [r0, #3]
c0d06160:	e022      	b.n	c0d061a8 <u2f_transport_received+0x330>
            if (media == U2F_MEDIA_USB) {
c0d06162:	9807      	ldr	r0, [sp, #28]
c0d06164:	2801      	cmp	r0, #1
c0d06166:	d109      	bne.n	c0d0617c <u2f_transport_received+0x304>
c0d06168:	2000      	movs	r0, #0
    service->transportPacketIndex = 0;
c0d0616a:	76a0      	strb	r0, [r4, #26]
    service->transportOffset = 0;
c0d0616c:	82e0      	strh	r0, [r4, #22]
    service->waitAsynchronousResponse = U2F_WAIT_ASYNCH_IDLE;
c0d0616e:	8338      	strh	r0, [r7, #24]
c0d06170:	9908      	ldr	r1, [sp, #32]
    service->transportMedia = 0;
c0d06172:	6008      	str	r0, [r1, #0]
c0d06174:	8088      	strh	r0, [r1, #4]
    service->transportBuffer = service->transportReceiveBuffer;
c0d06176:	68e0      	ldr	r0, [r4, #12]
c0d06178:	61e0      	str	r0, [r4, #28]
c0d0617a:	e6b5      	b.n	c0d05ee8 <u2f_transport_received+0x70>
c0d0617c:	4836      	ldr	r0, [pc, #216]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d0617e:	2104      	movs	r1, #4
c0d06180:	7201      	strb	r1, [r0, #8]
c0d06182:	2200      	movs	r2, #0
c0d06184:	76a2      	strb	r2, [r4, #26]
c0d06186:	2301      	movs	r3, #1
c0d06188:	8323      	strh	r3, [r4, #24]
c0d0618a:	82e2      	strh	r2, [r4, #22]
c0d0618c:	3008      	adds	r0, #8
c0d0618e:	61e0      	str	r0, [r4, #28]
c0d06190:	9808      	ldr	r0, [sp, #32]
c0d06192:	7001      	strb	r1, [r0, #0]
c0d06194:	e6a2      	b.n	c0d05edc <u2f_transport_received+0x64>
            if (media != U2F_MEDIA_USB) {
c0d06196:	9807      	ldr	r0, [sp, #28]
c0d06198:	2801      	cmp	r0, #1
c0d0619a:	d131      	bne.n	c0d06200 <u2f_transport_received+0x388>
    return (memcmp(channel, FORBIDDEN_CHANNEL, 4) == 0);
c0d0619c:	7920      	ldrb	r0, [r4, #4]
c0d0619e:	7965      	ldrb	r5, [r4, #5]
c0d061a0:	022d      	lsls	r5, r5, #8
c0d061a2:	182e      	adds	r6, r5, r0
c0d061a4:	79a5      	ldrb	r5, [r4, #6]
c0d061a6:	79e0      	ldrb	r0, [r4, #7]
c0d061a8:	0200      	lsls	r0, r0, #8
c0d061aa:	1940      	adds	r0, r0, r5
c0d061ac:	9d06      	ldr	r5, [sp, #24]
c0d061ae:	0400      	lsls	r0, r0, #16
c0d061b0:	1980      	adds	r0, r0, r6
c0d061b2:	d04d      	beq.n	c0d06250 <u2f_transport_received+0x3d8>
c0d061b4:	9805      	ldr	r0, [sp, #20]
c0d061b6:	1809      	adds	r1, r1, r0
            xfer_len = MIN(size - (channelHeader), U2F_COMMAND_HEADER_SIZE+commandLength);
c0d061b8:	1a16      	subs	r6, r2, r0
c0d061ba:	1cd8      	adds	r0, r3, #3
c0d061bc:	4286      	cmp	r6, r0
c0d061be:	db00      	blt.n	c0d061c2 <u2f_transport_received+0x34a>
c0d061c0:	4606      	mov	r6, r0
c0d061c2:	9005      	str	r0, [sp, #20]
            memmove(service->transportBuffer, buffer + channelHeader, xfer_len);
c0d061c4:	b2b2      	uxth	r2, r6
c0d061c6:	69e0      	ldr	r0, [r4, #28]
c0d061c8:	9204      	str	r2, [sp, #16]
c0d061ca:	f002 f9a8 	bl	c0d0851e <__aeabi_memmove>
            if (media == U2F_MEDIA_USB) {
c0d061ce:	9807      	ldr	r0, [sp, #28]
c0d061d0:	2801      	cmp	r0, #1
c0d061d2:	d105      	bne.n	c0d061e0 <u2f_transport_received+0x368>
                service->commandCrc = cx_crc16_update(0, service->transportBuffer, xfer_len);
c0d061d4:	69e1      	ldr	r1, [r4, #28]
c0d061d6:	2000      	movs	r0, #0
c0d061d8:	9a04      	ldr	r2, [sp, #16]
c0d061da:	f7fa f925 	bl	c0d00428 <cx_crc16_update>
c0d061de:	84e0      	strh	r0, [r4, #38]	; 0x26
            service->transportLength = U2F_COMMAND_HEADER_SIZE+commandLength;
c0d061e0:	9805      	ldr	r0, [sp, #20]
c0d061e2:	8320      	strh	r0, [r4, #24]
            service->transportOffset = xfer_len;
c0d061e4:	82e6      	strh	r6, [r4, #22]
c0d061e6:	9907      	ldr	r1, [sp, #28]
            service->transportMedia = media;
c0d061e8:	73f9      	strb	r1, [r7, #15]
c0d061ea:	2000      	movs	r0, #0
            service->transportPacketIndex = 0;
c0d061ec:	76a0      	strb	r0, [r4, #26]
            memcpy(service->transportChannel, service->channel, 4);
c0d061ee:	6860      	ldr	r0, [r4, #4]
c0d061f0:	8038      	strh	r0, [r7, #0]
c0d061f2:	0c00      	lsrs	r0, r0, #16
c0d061f4:	8078      	strh	r0, [r7, #2]
    if ((media != U2F_MEDIA_USB) &&
c0d061f6:	2901      	cmp	r1, #1
c0d061f8:	9b08      	ldr	r3, [sp, #32]
c0d061fa:	d109      	bne.n	c0d06210 <u2f_transport_received+0x398>
    } else if (service->transportOffset >= service->transportLength) {
c0d061fc:	8b20      	ldrh	r0, [r4, #24]
c0d061fe:	e019      	b.n	c0d06234 <u2f_transport_received+0x3bc>
c0d06200:	4815      	ldr	r0, [pc, #84]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d06202:	2101      	movs	r1, #1
c0d06204:	7201      	strb	r1, [r0, #8]
c0d06206:	2200      	movs	r2, #0
c0d06208:	76a2      	strb	r2, [r4, #26]
c0d0620a:	8321      	strh	r1, [r4, #24]
c0d0620c:	82e2      	strh	r2, [r4, #22]
c0d0620e:	e660      	b.n	c0d05ed2 <u2f_transport_received+0x5a>
        (service->transportOffset >
c0d06210:	b2b1      	uxth	r1, r6
         (service->transportLength + U2F_COMMAND_HEADER_SIZE))) {
c0d06212:	8b20      	ldrh	r0, [r4, #24]
c0d06214:	1cc2      	adds	r2, r0, #3
    if ((media != U2F_MEDIA_USB) &&
c0d06216:	428a      	cmp	r2, r1
c0d06218:	d20c      	bcs.n	c0d06234 <u2f_transport_received+0x3bc>
    G_io_usb_ep_buffer[8] = errorCode;
c0d0621a:	480f      	ldr	r0, [pc, #60]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d0621c:	2103      	movs	r1, #3
c0d0621e:	7201      	strb	r1, [r0, #8]
c0d06220:	2100      	movs	r1, #0
    service->transportPacketIndex = 0;
c0d06222:	76a1      	strb	r1, [r4, #26]
c0d06224:	2201      	movs	r2, #1
    service->transportLength = 1;
c0d06226:	8322      	strh	r2, [r4, #24]
    service->transportOffset = 0;
c0d06228:	82e1      	strh	r1, [r4, #22]
    G_io_usb_ep_buffer[8] = errorCode;
c0d0622a:	3008      	adds	r0, #8
    service->transportBuffer = G_io_usb_ep_buffer + 8;
c0d0622c:	61e0      	str	r0, [r4, #28]
c0d0622e:	2004      	movs	r0, #4
    service->transportState = U2F_SENDING_ERROR;
c0d06230:	7018      	strb	r0, [r3, #0]
c0d06232:	e653      	b.n	c0d05edc <u2f_transport_received+0x64>
    } else if (service->transportOffset >= service->transportLength) {
c0d06234:	b2b1      	uxth	r1, r6
c0d06236:	4281      	cmp	r1, r0
c0d06238:	d204      	bcs.n	c0d06244 <u2f_transport_received+0x3cc>
c0d0623a:	2001      	movs	r0, #1
        service->transportState = U2F_HANDLE_SEGMENTED;
c0d0623c:	7018      	strb	r0, [r3, #0]
c0d0623e:	2000      	movs	r0, #0
        service->seqTimeout = 0;
c0d06240:	6360      	str	r0, [r4, #52]	; 0x34
c0d06242:	e651      	b.n	c0d05ee8 <u2f_transport_received+0x70>
c0d06244:	2002      	movs	r0, #2
        service->transportState = U2F_PROCESSING_COMMAND;
c0d06246:	7018      	strb	r0, [r3, #0]
        u2f_message_complete(service);
c0d06248:	4620      	mov	r0, r4
c0d0624a:	f7ff fcab 	bl	c0d05ba4 <u2f_message_complete>
c0d0624e:	e64b      	b.n	c0d05ee8 <u2f_transport_received+0x70>
c0d06250:	4801      	ldr	r0, [pc, #4]	; (c0d06258 <u2f_transport_received+0x3e0>)
c0d06252:	210b      	movs	r1, #11
c0d06254:	e637      	b.n	c0d05ec6 <u2f_transport_received+0x4e>
c0d06256:	46c0      	nop			; (mov r8, r8)
c0d06258:	2000043c 	.word	0x2000043c

c0d0625c <u2f_is_channel_broadcast>:
    return (memcmp(channel, BROADCAST_CHANNEL, 4) == 0);
c0d0625c:	7801      	ldrb	r1, [r0, #0]
c0d0625e:	7842      	ldrb	r2, [r0, #1]
c0d06260:	0212      	lsls	r2, r2, #8
c0d06262:	1851      	adds	r1, r2, r1
c0d06264:	7882      	ldrb	r2, [r0, #2]
c0d06266:	78c0      	ldrb	r0, [r0, #3]
c0d06268:	0200      	lsls	r0, r0, #8
c0d0626a:	1880      	adds	r0, r0, r2
c0d0626c:	0400      	lsls	r0, r0, #16
c0d0626e:	1840      	adds	r0, r0, r1
c0d06270:	1c41      	adds	r1, r0, #1
c0d06272:	4248      	negs	r0, r1
c0d06274:	4148      	adcs	r0, r1
c0d06276:	4770      	bx	lr

c0d06278 <u2f_message_set_autoreply_wait_user_presence>:
void u2f_message_set_autoreply_wait_user_presence(u2f_service_t* service, bool enabled) {
c0d06278:	b580      	push	{r7, lr}
c0d0627a:	222a      	movs	r2, #42	; 0x2a
c0d0627c:	5c83      	ldrb	r3, [r0, r2]
c0d0627e:	4602      	mov	r2, r0
c0d06280:	322a      	adds	r2, #42	; 0x2a
    if (enabled) {
c0d06282:	2900      	cmp	r1, #0
c0d06284:	d002      	beq.n	c0d0628c <u2f_message_set_autoreply_wait_user_presence+0x14>
        if (service->waitAsynchronousResponse == U2F_WAIT_ASYNCH_IDLE) {
c0d06286:	2b00      	cmp	r3, #0
c0d06288:	d005      	beq.n	c0d06296 <u2f_message_set_autoreply_wait_user_presence+0x1e>
}
c0d0628a:	bd80      	pop	{r7, pc}
    else if (service->waitAsynchronousResponse == U2F_WAIT_ASYNCH_ON) {
c0d0628c:	2b01      	cmp	r3, #1
c0d0628e:	d1fc      	bne.n	c0d0628a <u2f_message_set_autoreply_wait_user_presence+0x12>
c0d06290:	2002      	movs	r0, #2
        service->waitAsynchronousResponse = U2F_WAIT_ASYNCH_REPLY_READY;
c0d06292:	7010      	strb	r0, [r2, #0]
}
c0d06294:	bd80      	pop	{r7, pc}
c0d06296:	21ff      	movs	r1, #255	; 0xff
c0d06298:	3102      	adds	r1, #2
            service->waitAsynchronousResponse = U2F_WAIT_ASYNCH_ON;
c0d0629a:	8011      	strh	r1, [r2, #0]
    memcpy(G_io_usb_ep_buffer, service->channel, 4);
c0d0629c:	6841      	ldr	r1, [r0, #4]
c0d0629e:	0e0a      	lsrs	r2, r1, #24
c0d062a0:	480a      	ldr	r0, [pc, #40]	; (c0d062cc <u2f_message_set_autoreply_wait_user_presence+0x54>)
c0d062a2:	70c2      	strb	r2, [r0, #3]
c0d062a4:	0c0a      	lsrs	r2, r1, #16
c0d062a6:	7082      	strb	r2, [r0, #2]
c0d062a8:	0a0a      	lsrs	r2, r1, #8
c0d062aa:	7042      	strb	r2, [r0, #1]
c0d062ac:	7001      	strb	r1, [r0, #0]
c0d062ae:	2185      	movs	r1, #133	; 0x85
    G_io_usb_ep_buffer[offset++] = 0x85;
c0d062b0:	7201      	strb	r1, [r0, #8]
c0d062b2:	2169      	movs	r1, #105	; 0x69
    G_io_usb_ep_buffer[offset++] = 0x69;
c0d062b4:	71c1      	strb	r1, [r0, #7]
c0d062b6:	2102      	movs	r1, #2
    G_io_usb_ep_buffer[offset++] = 2;
c0d062b8:	7181      	strb	r1, [r0, #6]
c0d062ba:	2100      	movs	r1, #0
    G_io_usb_ep_buffer[offset++] = 0;
c0d062bc:	7141      	strb	r1, [r0, #5]
c0d062be:	2183      	movs	r1, #131	; 0x83
    G_io_usb_ep_buffer[offset++] = U2F_CMD_MSG;
c0d062c0:	7101      	strb	r1, [r0, #4]
c0d062c2:	2109      	movs	r1, #9
c0d062c4:	2201      	movs	r2, #1
    u2f_io_send(G_io_usb_ep_buffer, offset, U2F_MEDIA_USB);
c0d062c6:	f7ff fc8b 	bl	c0d05be0 <u2f_io_send>
}
c0d062ca:	bd80      	pop	{r7, pc}
c0d062cc:	2000043c 	.word	0x2000043c

c0d062d0 <u2f_message_reply>:
        ;
}

void u2f_message_reply(u2f_service_t *service, uint8_t cmd, uint8_t *buffer, uint16_t len) {
c0d062d0:	b570      	push	{r4, r5, r6, lr}
c0d062d2:	4604      	mov	r4, r0
c0d062d4:	202a      	movs	r0, #42	; 0x2a
    return service->waitAsynchronousResponse == U2F_WAIT_ASYNCH_IDLE
c0d062d6:	5c20      	ldrb	r0, [r4, r0]
c0d062d8:	4625      	mov	r5, r4
c0d062da:	3520      	adds	r5, #32
        || (service->waitAsynchronousResponse != U2F_WAIT_ASYNCH_ON 
c0d062dc:	2800      	cmp	r0, #0
c0d062de:	d007      	beq.n	c0d062f0 <u2f_message_reply+0x20>
c0d062e0:	2801      	cmp	r0, #1
c0d062e2:	d01f      	beq.n	c0d06324 <u2f_message_reply+0x54>
            && service->fakeChannelTransportState == U2F_FAKE_RECEIVED 
c0d062e4:	7968      	ldrb	r0, [r5, #5]
            && service->sending == false)
c0d062e6:	2806      	cmp	r0, #6
c0d062e8:	d11c      	bne.n	c0d06324 <u2f_message_reply+0x54>
c0d062ea:	7ae8      	ldrb	r0, [r5, #11]

    // if U2F is not ready to reply, then gently avoid replying
    if (u2f_message_repliable(service)) 
c0d062ec:	2800      	cmp	r0, #0
c0d062ee:	d119      	bne.n	c0d06324 <u2f_message_reply+0x54>
c0d062f0:	4620      	mov	r0, r4
c0d062f2:	3040      	adds	r0, #64	; 0x40
    {
        service->transportState = U2F_SENDING_RESPONSE;
        service->transportPacketIndex = 0;
        service->transportBuffer = buffer;
c0d062f4:	61e2      	str	r2, [r4, #28]
c0d062f6:	2200      	movs	r2, #0
        service->transportPacketIndex = 0;
c0d062f8:	76a2      	strb	r2, [r4, #26]
c0d062fa:	2603      	movs	r6, #3
        service->transportState = U2F_SENDING_RESPONSE;
c0d062fc:	702e      	strb	r6, [r5, #0]
        service->transportOffset = 0;
        service->transportLength = len;
c0d062fe:	8323      	strh	r3, [r4, #24]
        service->transportOffset = 0;
c0d06300:	82e2      	strh	r2, [r4, #22]
        service->sendCmd = cmd;
c0d06302:	7001      	strb	r1, [r0, #0]
        if (service->transportMedia != U2F_MEDIA_BLE) {
c0d06304:	7869      	ldrb	r1, [r5, #1]
c0d06306:	2903      	cmp	r1, #3
c0d06308:	d10d      	bne.n	c0d06326 <u2f_message_reply+0x56>
            // pump the first message
            u2f_transport_sent(service, service->transportMedia);
        }
        else {
            while (G_io_app.apdu_state != APDU_IDLE) {
c0d0630a:	4e09      	ldr	r6, [pc, #36]	; (c0d06330 <u2f_message_reply+0x60>)
c0d0630c:	7830      	ldrb	r0, [r6, #0]
c0d0630e:	2800      	cmp	r0, #0
c0d06310:	d008      	beq.n	c0d06324 <u2f_message_reply+0x54>
c0d06312:	2103      	movs	r1, #3
                u2f_transport_sent(service, service->transportMedia);       
c0d06314:	4620      	mov	r0, r4
c0d06316:	f7ff fc8f 	bl	c0d05c38 <u2f_transport_sent>
            while (G_io_app.apdu_state != APDU_IDLE) {
c0d0631a:	7830      	ldrb	r0, [r6, #0]
c0d0631c:	2800      	cmp	r0, #0
c0d0631e:	d001      	beq.n	c0d06324 <u2f_message_reply+0x54>
                u2f_transport_sent(service, service->transportMedia);       
c0d06320:	7869      	ldrb	r1, [r5, #1]
c0d06322:	e7f7      	b.n	c0d06314 <u2f_message_reply+0x44>
            }
        }
    }
}
c0d06324:	bd70      	pop	{r4, r5, r6, pc}
            u2f_transport_sent(service, service->transportMedia);
c0d06326:	4620      	mov	r0, r4
c0d06328:	f7ff fc86 	bl	c0d05c38 <u2f_transport_sent>
}
c0d0632c:	bd70      	pop	{r4, r5, r6, pc}
c0d0632e:	46c0      	nop			; (mov r8, r8)
c0d06330:	200003d8 	.word	0x200003d8

c0d06334 <assert_uiPaginatedText_magic>:
#endif

STATIC_ASSERT(SIZEOF(uint8_t) == SIZEOF(char), "bad char size");

void assert_uiPaginatedText_magic()
{
c0d06334:	b580      	push	{r7, lr}
	ASSERT(paginatedTextState->initMagic == INIT_MAGIC_PAGINATED_TEXT);
c0d06336:	4805      	ldr	r0, [pc, #20]	; (c0d0634c <assert_uiPaginatedText_magic+0x18>)
c0d06338:	8800      	ldrh	r0, [r0, #0]
c0d0633a:	4905      	ldr	r1, [pc, #20]	; (c0d06350 <assert_uiPaginatedText_magic+0x1c>)
c0d0633c:	1841      	adds	r1, r0, r1
c0d0633e:	4248      	negs	r0, r1
c0d06340:	4148      	adcs	r0, r1
c0d06342:	4904      	ldr	r1, [pc, #16]	; (c0d06354 <assert_uiPaginatedText_magic+0x20>)
c0d06344:	4479      	add	r1, pc
c0d06346:	f7f9 fe93 	bl	c0d00070 <assert>
}
c0d0634a:	bd80      	pop	{r7, pc}
c0d0634c:	2000085c 	.word	0x2000085c
c0d06350:	fffff6d7 	.word	0xfffff6d7
c0d06354:	00003575 	.word	0x00003575

c0d06358 <assert_uiPrompt_magic>:

void assert_uiPrompt_magic()
{
c0d06358:	b580      	push	{r7, lr}
	ASSERT(promptState->initMagic == INIT_MAGIC_PROMPT);
c0d0635a:	4805      	ldr	r0, [pc, #20]	; (c0d06370 <assert_uiPrompt_magic+0x18>)
c0d0635c:	8800      	ldrh	r0, [r0, #0]
c0d0635e:	4905      	ldr	r1, [pc, #20]	; (c0d06374 <assert_uiPrompt_magic+0x1c>)
c0d06360:	1841      	adds	r1, r0, r1
c0d06362:	4248      	negs	r0, r1
c0d06364:	4148      	adcs	r0, r1
c0d06366:	4904      	ldr	r1, [pc, #16]	; (c0d06378 <assert_uiPrompt_magic+0x20>)
c0d06368:	4479      	add	r1, pc
c0d0636a:	f7f9 fe81 	bl	c0d00070 <assert>
}
c0d0636e:	bd80      	pop	{r7, pc}
c0d06370:	2000085c 	.word	0x2000085c
c0d06374:	ffffeac8 	.word	0xffffeac8
c0d06378:	00003564 	.word	0x00003564

c0d0637c <uiCallback_confirm>:

void uiCallback_confirm(ui_callback_t* cb)
{
c0d0637c:	b580      	push	{r7, lr}
	if (!cb->confirm) return;
c0d0637e:	6841      	ldr	r1, [r0, #4]
c0d06380:	2900      	cmp	r1, #0
c0d06382:	d00d      	beq.n	c0d063a0 <uiCallback_confirm+0x24>

	switch(cb->state) {
c0d06384:	7802      	ldrb	r2, [r0, #0]
c0d06386:	2a01      	cmp	r2, #1
c0d06388:	d00a      	beq.n	c0d063a0 <uiCallback_confirm+0x24>
c0d0638a:	2a00      	cmp	r2, #0
c0d0638c:	d103      	bne.n	c0d06396 <uiCallback_confirm+0x1a>
c0d0638e:	2201      	movs	r2, #1
	case CALLBACK_NOT_RUN:
		// Note: needs to be done before resolving in case it throws
		cb->state = CALLBACK_RUN;
c0d06390:	7002      	strb	r2, [r0, #0]
		cb->confirm();
c0d06392:	4788      	blx	r1
		// Ignore
		break;
	default:
		ASSERT(false);
	}
}
c0d06394:	bd80      	pop	{r7, pc}
c0d06396:	2000      	movs	r0, #0
		ASSERT(false);
c0d06398:	4902      	ldr	r1, [pc, #8]	; (c0d063a4 <uiCallback_confirm+0x28>)
c0d0639a:	4479      	add	r1, pc
c0d0639c:	f7f9 fe68 	bl	c0d00070 <assert>
}
c0d063a0:	bd80      	pop	{r7, pc}
c0d063a2:	46c0      	nop			; (mov r8, r8)
c0d063a4:	00003545 	.word	0x00003545

c0d063a8 <uiCallback_reject>:

void uiCallback_reject(ui_callback_t* cb)
{
c0d063a8:	b580      	push	{r7, lr}
	if (!cb->reject) return;
c0d063aa:	6881      	ldr	r1, [r0, #8]
c0d063ac:	2900      	cmp	r1, #0
c0d063ae:	d00d      	beq.n	c0d063cc <uiCallback_reject+0x24>

	switch(cb->state) {
c0d063b0:	7802      	ldrb	r2, [r0, #0]
c0d063b2:	2a01      	cmp	r2, #1
c0d063b4:	d00a      	beq.n	c0d063cc <uiCallback_reject+0x24>
c0d063b6:	2a00      	cmp	r2, #0
c0d063b8:	d103      	bne.n	c0d063c2 <uiCallback_reject+0x1a>
c0d063ba:	2201      	movs	r2, #1
	case CALLBACK_NOT_RUN:
		// Note: needs to be done before resolving in case it throws
		cb->state = CALLBACK_RUN;
c0d063bc:	7002      	strb	r2, [r0, #0]
		cb->reject();
c0d063be:	4788      	blx	r1
		// Ignore
		break;
	default:
		ASSERT(false);
	}
}
c0d063c0:	bd80      	pop	{r7, pc}
c0d063c2:	2000      	movs	r0, #0
		ASSERT(false);
c0d063c4:	4902      	ldr	r1, [pc, #8]	; (c0d063d0 <uiCallback_reject+0x28>)
c0d063c6:	4479      	add	r1, pc
c0d063c8:	f7f9 fe52 	bl	c0d00070 <assert>
}
c0d063cc:	bd80      	pop	{r7, pc}
c0d063ce:	46c0      	nop			; (mov r8, r8)
c0d063d0:	0000352c 	.word	0x0000352c

c0d063d4 <ui_displayPrompt>:
void ui_displayPrompt(
        const char* headerStr,
        const char* bodyStr,
        ui_callback_fn_t* confirm,
        ui_callback_fn_t* reject)
{
c0d063d4:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d063d6:	b087      	sub	sp, #28
c0d063d8:	9302      	str	r3, [sp, #8]
c0d063da:	9201      	str	r2, [sp, #4]
c0d063dc:	9105      	str	r1, [sp, #20]
c0d063de:	9004      	str	r0, [sp, #16]
c0d063e0:	2000      	movs	r0, #0
c0d063e2:	9003      	str	r0, [sp, #12]
	TRACE_STACK_USAGE();
c0d063e4:	9006      	str	r0, [sp, #24]
c0d063e6:	484a      	ldr	r0, [pc, #296]	; (c0d06510 <ui_displayPrompt+0x13c>)
c0d063e8:	4478      	add	r0, pc
c0d063ea:	494a      	ldr	r1, [pc, #296]	; (c0d06514 <ui_displayPrompt+0x140>)
c0d063ec:	4479      	add	r1, pc
c0d063ee:	228c      	movs	r2, #140	; 0x8c
c0d063f0:	f7fc fc28 	bl	c0d02c44 <mcu_usb_printf>
c0d063f4:	4c41      	ldr	r4, [pc, #260]	; (c0d064fc <ui_displayPrompt+0x128>)
c0d063f6:	a806      	add	r0, sp, #24
c0d063f8:	1b01      	subs	r1, r0, r4
c0d063fa:	4847      	ldr	r0, [pc, #284]	; (c0d06518 <ui_displayPrompt+0x144>)
c0d063fc:	4478      	add	r0, pc
c0d063fe:	f7fc fc21 	bl	c0d02c44 <mcu_usb_printf>
c0d06402:	4846      	ldr	r0, [pc, #280]	; (c0d0651c <ui_displayPrompt+0x148>)
c0d06404:	4478      	add	r0, pc
c0d06406:	f7fc fc1d 	bl	c0d02c44 <mcu_usb_printf>
c0d0640a:	6820      	ldr	r0, [r4, #0]
c0d0640c:	493c      	ldr	r1, [pc, #240]	; (c0d06500 <ui_displayPrompt+0x12c>)
c0d0640e:	4288      	cmp	r0, r1
c0d06410:	d00e      	beq.n	c0d06430 <ui_displayPrompt+0x5c>
c0d06412:	4843      	ldr	r0, [pc, #268]	; (c0d06520 <ui_displayPrompt+0x14c>)
c0d06414:	4478      	add	r0, pc
c0d06416:	4943      	ldr	r1, [pc, #268]	; (c0d06524 <ui_displayPrompt+0x150>)
c0d06418:	4479      	add	r1, pc
c0d0641a:	228c      	movs	r2, #140	; 0x8c
c0d0641c:	f7fc fc12 	bl	c0d02c44 <mcu_usb_printf>
c0d06420:	4841      	ldr	r0, [pc, #260]	; (c0d06528 <ui_displayPrompt+0x154>)
c0d06422:	4478      	add	r0, pc
c0d06424:	f7fc fc0e 	bl	c0d02c44 <mcu_usb_printf>
c0d06428:	4840      	ldr	r0, [pc, #256]	; (c0d0652c <ui_displayPrompt+0x158>)
c0d0642a:	4478      	add	r0, pc
c0d0642c:	f7fc fc0a 	bl	c0d02c44 <mcu_usb_printf>
	TRACE("%s", headerStr);
c0d06430:	4c3f      	ldr	r4, [pc, #252]	; (c0d06530 <ui_displayPrompt+0x15c>)
c0d06432:	447c      	add	r4, pc
c0d06434:	4d3f      	ldr	r5, [pc, #252]	; (c0d06534 <ui_displayPrompt+0x160>)
c0d06436:	447d      	add	r5, pc
c0d06438:	228d      	movs	r2, #141	; 0x8d
c0d0643a:	4620      	mov	r0, r4
c0d0643c:	4629      	mov	r1, r5
c0d0643e:	f7fc fc01 	bl	c0d02c44 <mcu_usb_printf>
c0d06442:	4e3d      	ldr	r6, [pc, #244]	; (c0d06538 <ui_displayPrompt+0x164>)
c0d06444:	447e      	add	r6, pc
c0d06446:	4630      	mov	r0, r6
c0d06448:	9904      	ldr	r1, [sp, #16]
c0d0644a:	f7fc fbfb 	bl	c0d02c44 <mcu_usb_printf>
c0d0644e:	4f3b      	ldr	r7, [pc, #236]	; (c0d0653c <ui_displayPrompt+0x168>)
c0d06450:	447f      	add	r7, pc
c0d06452:	4638      	mov	r0, r7
c0d06454:	f7fc fbf6 	bl	c0d02c44 <mcu_usb_printf>
c0d06458:	228e      	movs	r2, #142	; 0x8e
	TRACE("%s", bodyStr);
c0d0645a:	4620      	mov	r0, r4
c0d0645c:	4629      	mov	r1, r5
c0d0645e:	f7fc fbf1 	bl	c0d02c44 <mcu_usb_printf>
c0d06462:	4630      	mov	r0, r6
c0d06464:	9905      	ldr	r1, [sp, #20]
c0d06466:	f7fc fbed 	bl	c0d02c44 <mcu_usb_printf>
c0d0646a:	4638      	mov	r0, r7
c0d0646c:	f7fc fbea 	bl	c0d02c44 <mcu_usb_printf>

	size_t header_len = strlen(headerStr);
c0d06470:	9804      	ldr	r0, [sp, #16]
c0d06472:	f002 f8b9 	bl	c0d085e8 <strlen>
c0d06476:	4604      	mov	r4, r0
c0d06478:	2601      	movs	r6, #1
	size_t text_len = strlen(bodyStr);
	// sanity checks, keep 1 byte for null terminator
	ASSERT(header_len < SIZEOF(promptState->header));
c0d0647a:	281e      	cmp	r0, #30
c0d0647c:	4637      	mov	r7, r6
c0d0647e:	d300      	bcc.n	c0d06482 <ui_displayPrompt+0xae>
c0d06480:	9f03      	ldr	r7, [sp, #12]
	size_t text_len = strlen(bodyStr);
c0d06482:	9805      	ldr	r0, [sp, #20]
c0d06484:	f002 f8b0 	bl	c0d085e8 <strlen>
c0d06488:	4605      	mov	r5, r0
	ASSERT(header_len < SIZEOF(promptState->header));
c0d0648a:	492d      	ldr	r1, [pc, #180]	; (c0d06540 <ui_displayPrompt+0x16c>)
c0d0648c:	4479      	add	r1, pc
c0d0648e:	4638      	mov	r0, r7
c0d06490:	f7f9 fdee 	bl	c0d00070 <assert>
	ASSERT(text_len < SIZEOF(promptState->text));
c0d06494:	2d1e      	cmp	r5, #30
c0d06496:	d300      	bcc.n	c0d0649a <ui_displayPrompt+0xc6>
c0d06498:	9e03      	ldr	r6, [sp, #12]
c0d0649a:	492a      	ldr	r1, [pc, #168]	; (c0d06544 <ui_displayPrompt+0x170>)
c0d0649c:	4479      	add	r1, pc
c0d0649e:	4630      	mov	r0, r6
c0d064a0:	f7f9 fde6 	bl	c0d00070 <assert>
c0d064a4:	2043      	movs	r0, #67	; 0x43
c0d064a6:	0081      	lsls	r1, r0, #2

	// clear all memory
	explicit_bzero(&displayState, SIZEOF(displayState));
c0d064a8:	4e16      	ldr	r6, [pc, #88]	; (c0d06504 <ui_displayPrompt+0x130>)
c0d064aa:	4630      	mov	r0, r6
c0d064ac:	f002 f842 	bl	c0d08534 <explicit_bzero>
	promptState_t* ctx = promptState;

	// Copy data
	memmove(ctx->header, headerStr, header_len + 1);
c0d064b0:	1cb0      	adds	r0, r6, #2
c0d064b2:	1c62      	adds	r2, r4, #1
c0d064b4:	9904      	ldr	r1, [sp, #16]
c0d064b6:	f002 f832 	bl	c0d0851e <__aeabi_memmove>
	memmove(ctx->text, bodyStr, text_len + 1);
c0d064ba:	4630      	mov	r0, r6
c0d064bc:	3020      	adds	r0, #32
c0d064be:	1c6a      	adds	r2, r5, #1
c0d064c0:	9905      	ldr	r1, [sp, #20]
c0d064c2:	f002 f82c 	bl	c0d0851e <__aeabi_memmove>
c0d064c6:	2040      	movs	r0, #64	; 0x40
	cb->state = CALLBACK_NOT_RUN;
c0d064c8:	9903      	ldr	r1, [sp, #12]
c0d064ca:	5431      	strb	r1, [r6, r0]
	cb->confirm = confirm;
c0d064cc:	9801      	ldr	r0, [sp, #4]
c0d064ce:	6470      	str	r0, [r6, #68]	; 0x44
	cb->reject = reject;
c0d064d0:	9802      	ldr	r0, [sp, #8]
c0d064d2:	64b0      	str	r0, [r6, #72]	; 0x48
c0d064d4:	480c      	ldr	r0, [pc, #48]	; (c0d06508 <ui_displayPrompt+0x134>)

	uiCallback_init(&ctx->callback, confirm, reject);
	ctx->initMagic = INIT_MAGIC_PROMPT;
c0d064d6:	8030      	strh	r0, [r6, #0]
	ASSERT(io_state == IO_EXPECT_NONE || io_state == IO_EXPECT_UI);
c0d064d8:	4c0c      	ldr	r4, [pc, #48]	; (c0d0650c <ui_displayPrompt+0x138>)
c0d064da:	7821      	ldrb	r1, [r4, #0]
c0d064dc:	392f      	subs	r1, #47	; 0x2f
c0d064de:	2002      	movs	r0, #2
c0d064e0:	4381      	bics	r1, r0
c0d064e2:	4248      	negs	r0, r1
c0d064e4:	4148      	adcs	r0, r1
c0d064e6:	4918      	ldr	r1, [pc, #96]	; (c0d06548 <ui_displayPrompt+0x174>)
c0d064e8:	4479      	add	r1, pc
c0d064ea:	f7f9 fdc1 	bl	c0d00070 <assert>
c0d064ee:	202f      	movs	r0, #47	; 0x2f
	io_state = IO_EXPECT_UI;
c0d064f0:	7020      	strb	r0, [r4, #0]

	ui_displayPrompt_run();
c0d064f2:	f000 fa91 	bl	c0d06a18 <ui_displayPrompt_run>
	#ifdef HEADLESS
	if (confirm) {
		autoconfirmPrompt();
	}
	#endif // HEADLESS
}
c0d064f6:	b007      	add	sp, #28
c0d064f8:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d064fa:	46c0      	nop			; (mov r8, r8)
c0d064fc:	20000ac8 	.word	0x20000ac8
c0d06500:	dead0031 	.word	0xdead0031
c0d06504:	2000085c 	.word	0x2000085c
c0d06508:	00001538 	.word	0x00001538
c0d0650c:	20000204 	.word	0x20000204
c0d06510:	000025d7 	.word	0x000025d7
c0d06514:	00003519 	.word	0x00003519
c0d06518:	0000351a 	.word	0x0000351a
c0d0651c:	00003122 	.word	0x00003122
c0d06520:	000025ab 	.word	0x000025ab
c0d06524:	000034ed 	.word	0x000034ed
c0d06528:	00003508 	.word	0x00003508
c0d0652c:	000030fc 	.word	0x000030fc
c0d06530:	0000258d 	.word	0x0000258d
c0d06534:	000034cf 	.word	0x000034cf
c0d06538:	00002289 	.word	0x00002289
c0d0653c:	000030d6 	.word	0x000030d6
c0d06540:	000034d9 	.word	0x000034d9
c0d06544:	000034dd 	.word	0x000034dd
c0d06548:	000034a5 	.word	0x000034a5

c0d0654c <ui_displayPaginatedText>:

void ui_displayPaginatedText(
        const char* headerStr,
        const char* bodyStr,
        ui_callback_fn_t* callback)
{
c0d0654c:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0654e:	b089      	sub	sp, #36	; 0x24
c0d06550:	9204      	str	r2, [sp, #16]
c0d06552:	9107      	str	r1, [sp, #28]
c0d06554:	4605      	mov	r5, r0
c0d06556:	2000      	movs	r0, #0
c0d06558:	9006      	str	r0, [sp, #24]
	TRACE_STACK_USAGE();
c0d0655a:	9008      	str	r0, [sp, #32]
c0d0655c:	485d      	ldr	r0, [pc, #372]	; (c0d066d4 <ui_displayPaginatedText+0x188>)
c0d0655e:	4478      	add	r0, pc
c0d06560:	495d      	ldr	r1, [pc, #372]	; (c0d066d8 <ui_displayPaginatedText+0x18c>)
c0d06562:	4479      	add	r1, pc
c0d06564:	22b1      	movs	r2, #177	; 0xb1
c0d06566:	f7fc fb6d 	bl	c0d02c44 <mcu_usb_printf>
c0d0656a:	4c55      	ldr	r4, [pc, #340]	; (c0d066c0 <ui_displayPaginatedText+0x174>)
c0d0656c:	a808      	add	r0, sp, #32
c0d0656e:	1b01      	subs	r1, r0, r4
c0d06570:	485a      	ldr	r0, [pc, #360]	; (c0d066dc <ui_displayPaginatedText+0x190>)
c0d06572:	4478      	add	r0, pc
c0d06574:	f7fc fb66 	bl	c0d02c44 <mcu_usb_printf>
c0d06578:	4859      	ldr	r0, [pc, #356]	; (c0d066e0 <ui_displayPaginatedText+0x194>)
c0d0657a:	4478      	add	r0, pc
c0d0657c:	f7fc fb62 	bl	c0d02c44 <mcu_usb_printf>
c0d06580:	6820      	ldr	r0, [r4, #0]
c0d06582:	4950      	ldr	r1, [pc, #320]	; (c0d066c4 <ui_displayPaginatedText+0x178>)
c0d06584:	4288      	cmp	r0, r1
c0d06586:	d00e      	beq.n	c0d065a6 <ui_displayPaginatedText+0x5a>
c0d06588:	4856      	ldr	r0, [pc, #344]	; (c0d066e4 <ui_displayPaginatedText+0x198>)
c0d0658a:	4478      	add	r0, pc
c0d0658c:	4956      	ldr	r1, [pc, #344]	; (c0d066e8 <ui_displayPaginatedText+0x19c>)
c0d0658e:	4479      	add	r1, pc
c0d06590:	22b1      	movs	r2, #177	; 0xb1
c0d06592:	f7fc fb57 	bl	c0d02c44 <mcu_usb_printf>
c0d06596:	4855      	ldr	r0, [pc, #340]	; (c0d066ec <ui_displayPaginatedText+0x1a0>)
c0d06598:	4478      	add	r0, pc
c0d0659a:	f7fc fb53 	bl	c0d02c44 <mcu_usb_printf>
c0d0659e:	4854      	ldr	r0, [pc, #336]	; (c0d066f0 <ui_displayPaginatedText+0x1a4>)
c0d065a0:	4478      	add	r0, pc
c0d065a2:	f7fc fb4f 	bl	c0d02c44 <mcu_usb_printf>
	TRACE("%s", headerStr);
c0d065a6:	4e53      	ldr	r6, [pc, #332]	; (c0d066f4 <ui_displayPaginatedText+0x1a8>)
c0d065a8:	447e      	add	r6, pc
c0d065aa:	4f53      	ldr	r7, [pc, #332]	; (c0d066f8 <ui_displayPaginatedText+0x1ac>)
c0d065ac:	447f      	add	r7, pc
c0d065ae:	22b2      	movs	r2, #178	; 0xb2
c0d065b0:	4630      	mov	r0, r6
c0d065b2:	4639      	mov	r1, r7
c0d065b4:	f7fc fb46 	bl	c0d02c44 <mcu_usb_printf>
c0d065b8:	4c50      	ldr	r4, [pc, #320]	; (c0d066fc <ui_displayPaginatedText+0x1b0>)
c0d065ba:	447c      	add	r4, pc
c0d065bc:	4620      	mov	r0, r4
c0d065be:	4629      	mov	r1, r5
c0d065c0:	f7fc fb40 	bl	c0d02c44 <mcu_usb_printf>
c0d065c4:	9505      	str	r5, [sp, #20]
c0d065c6:	4d4e      	ldr	r5, [pc, #312]	; (c0d06700 <ui_displayPaginatedText+0x1b4>)
c0d065c8:	447d      	add	r5, pc
c0d065ca:	4628      	mov	r0, r5
c0d065cc:	f7fc fb3a 	bl	c0d02c44 <mcu_usb_printf>
c0d065d0:	22b3      	movs	r2, #179	; 0xb3
c0d065d2:	9603      	str	r6, [sp, #12]
	TRACE("%s", bodyStr);
c0d065d4:	4630      	mov	r0, r6
c0d065d6:	9702      	str	r7, [sp, #8]
c0d065d8:	4639      	mov	r1, r7
c0d065da:	f7fc fb33 	bl	c0d02c44 <mcu_usb_printf>
c0d065de:	4620      	mov	r0, r4
c0d065e0:	9907      	ldr	r1, [sp, #28]
c0d065e2:	f7fc fb2f 	bl	c0d02c44 <mcu_usb_printf>
c0d065e6:	9501      	str	r5, [sp, #4]
c0d065e8:	4628      	mov	r0, r5
c0d065ea:	f7fc fb2b 	bl	c0d02c44 <mcu_usb_printf>

	paginatedTextState_t* ctx = paginatedTextState;
	size_t header_len = strlen(headerStr);
c0d065ee:	9805      	ldr	r0, [sp, #20]
c0d065f0:	f001 fffa 	bl	c0d085e8 <strlen>
c0d065f4:	4606      	mov	r6, r0
c0d065f6:	2501      	movs	r5, #1
	size_t body_len = strlen(bodyStr);
	// sanity checks
	ASSERT(header_len < SIZEOF(ctx->header));
c0d065f8:	281e      	cmp	r0, #30
c0d065fa:	462f      	mov	r7, r5
c0d065fc:	d300      	bcc.n	c0d06600 <ui_displayPaginatedText+0xb4>
c0d065fe:	9f06      	ldr	r7, [sp, #24]
	size_t body_len = strlen(bodyStr);
c0d06600:	9807      	ldr	r0, [sp, #28]
c0d06602:	f001 fff1 	bl	c0d085e8 <strlen>
c0d06606:	4604      	mov	r4, r0
	ASSERT(header_len < SIZEOF(ctx->header));
c0d06608:	493e      	ldr	r1, [pc, #248]	; (c0d06704 <ui_displayPaginatedText+0x1b8>)
c0d0660a:	4479      	add	r1, pc
c0d0660c:	4638      	mov	r0, r7
c0d0660e:	f7f9 fd2f 	bl	c0d00070 <assert>
	ASSERT(body_len < SIZEOF(ctx->fullText));
c0d06612:	2cc8      	cmp	r4, #200	; 0xc8
c0d06614:	4628      	mov	r0, r5
c0d06616:	d300      	bcc.n	c0d0661a <ui_displayPaginatedText+0xce>
c0d06618:	9806      	ldr	r0, [sp, #24]
c0d0661a:	493b      	ldr	r1, [pc, #236]	; (c0d06708 <ui_displayPaginatedText+0x1bc>)
c0d0661c:	4479      	add	r1, pc
c0d0661e:	f7f9 fd27 	bl	c0d00070 <assert>
c0d06622:	2043      	movs	r0, #67	; 0x43
c0d06624:	0081      	lsls	r1, r0, #2

	// clear all memory
	explicit_bzero(ctx, SIZEOF(*ctx));
c0d06626:	4f28      	ldr	r7, [pc, #160]	; (c0d066c8 <ui_displayPaginatedText+0x17c>)
c0d06628:	4638      	mov	r0, r7
c0d0662a:	f001 ff83 	bl	c0d08534 <explicit_bzero>

	// Copy data
	memmove(ctx->header, headerStr, header_len);
c0d0662e:	1cb8      	adds	r0, r7, #2
c0d06630:	9905      	ldr	r1, [sp, #20]
c0d06632:	4632      	mov	r2, r6
c0d06634:	f001 ff73 	bl	c0d0851e <__aeabi_memmove>
	memmove(ctx->fullText, bodyStr, body_len);
c0d06638:	463e      	mov	r6, r7
c0d0663a:	3632      	adds	r6, #50	; 0x32
c0d0663c:	4630      	mov	r0, r6
c0d0663e:	9907      	ldr	r1, [sp, #28]
c0d06640:	4622      	mov	r2, r4
c0d06642:	f001 ff6c 	bl	c0d0851e <__aeabi_memmove>
c0d06646:	20fc      	movs	r0, #252	; 0xfc
c0d06648:	9c06      	ldr	r4, [sp, #24]

	ctx->scrollIndex = 0;
c0d0664a:	503c      	str	r4, [r7, r0]

	memmove(
c0d0664c:	4638      	mov	r0, r7
c0d0664e:	3020      	adds	r0, #32
c0d06650:	2211      	movs	r2, #17
c0d06652:	4631      	mov	r1, r6
c0d06654:	f001 ff5f 	bl	c0d08516 <__aeabi_memcpy>
c0d06658:	0228      	lsls	r0, r5, #8
	cb->state = CALLBACK_NOT_RUN;
c0d0665a:	543c      	strb	r4, [r7, r0]
c0d0665c:	1838      	adds	r0, r7, r0
	cb->confirm = confirm;
c0d0665e:	9904      	ldr	r1, [sp, #16]
c0d06660:	6041      	str	r1, [r0, #4]
	cb->reject = reject;
c0d06662:	6084      	str	r4, [r0, #8]
c0d06664:	4819      	ldr	r0, [pc, #100]	; (c0d066cc <ui_displayPaginatedText+0x180>)
	        ctx->fullText,
	        SIZEOF(ctx->currentText) - 1
	);

	uiCallback_init(&ctx->callback, callback, NULL);
	ctx->initMagic = INIT_MAGIC_PAGINATED_TEXT;
c0d06666:	8038      	strh	r0, [r7, #0]
c0d06668:	22cd      	movs	r2, #205	; 0xcd
c0d0666a:	9c03      	ldr	r4, [sp, #12]
	TRACE("setting timeout");
c0d0666c:	4620      	mov	r0, r4
c0d0666e:	9d02      	ldr	r5, [sp, #8]
c0d06670:	4629      	mov	r1, r5
c0d06672:	f7fc fae7 	bl	c0d02c44 <mcu_usb_printf>
c0d06676:	4825      	ldr	r0, [pc, #148]	; (c0d0670c <ui_displayPaginatedText+0x1c0>)
c0d06678:	4478      	add	r0, pc
c0d0667a:	f7fc fae3 	bl	c0d02c44 <mcu_usb_printf>
c0d0667e:	9e01      	ldr	r6, [sp, #4]
c0d06680:	4630      	mov	r0, r6
c0d06682:	f7fc fadf 	bl	c0d02c44 <mcu_usb_printf>
c0d06686:	22ce      	movs	r2, #206	; 0xce
	TRACE("done");
c0d06688:	4620      	mov	r0, r4
c0d0668a:	4629      	mov	r1, r5
c0d0668c:	f7fc fada 	bl	c0d02c44 <mcu_usb_printf>
c0d06690:	481f      	ldr	r0, [pc, #124]	; (c0d06710 <ui_displayPaginatedText+0x1c4>)
c0d06692:	4478      	add	r0, pc
c0d06694:	f7fc fad6 	bl	c0d02c44 <mcu_usb_printf>
c0d06698:	4630      	mov	r0, r6
c0d0669a:	f7fc fad3 	bl	c0d02c44 <mcu_usb_printf>
	ASSERT(io_state == IO_EXPECT_NONE || io_state == IO_EXPECT_UI);
c0d0669e:	4c0c      	ldr	r4, [pc, #48]	; (c0d066d0 <ui_displayPaginatedText+0x184>)
c0d066a0:	7821      	ldrb	r1, [r4, #0]
c0d066a2:	392f      	subs	r1, #47	; 0x2f
c0d066a4:	2002      	movs	r0, #2
c0d066a6:	4381      	bics	r1, r0
c0d066a8:	4248      	negs	r0, r1
c0d066aa:	4148      	adcs	r0, r1
c0d066ac:	4919      	ldr	r1, [pc, #100]	; (c0d06714 <ui_displayPaginatedText+0x1c8>)
c0d066ae:	4479      	add	r1, pc
c0d066b0:	f7f9 fcde 	bl	c0d00070 <assert>
c0d066b4:	202f      	movs	r0, #47	; 0x2f
	io_state = IO_EXPECT_UI;
c0d066b6:	7020      	strb	r0, [r4, #0]

	ui_displayPaginatedText_run();
c0d066b8:	f000 fa28 	bl	c0d06b0c <ui_displayPaginatedText_run>
	#ifdef HEADLESS
	if (callback) {
		autoconfirmPaginatedText();
	}
	#endif // HEADLESS
}
c0d066bc:	b009      	add	sp, #36	; 0x24
c0d066be:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d066c0:	20000ac8 	.word	0x20000ac8
c0d066c4:	dead0031 	.word	0xdead0031
c0d066c8:	2000085c 	.word	0x2000085c
c0d066cc:	00000929 	.word	0x00000929
c0d066d0:	20000204 	.word	0x20000204
c0d066d4:	00002461 	.word	0x00002461
c0d066d8:	0000343f 	.word	0x0000343f
c0d066dc:	000033a4 	.word	0x000033a4
c0d066e0:	00002fac 	.word	0x00002fac
c0d066e4:	00002435 	.word	0x00002435
c0d066e8:	00003413 	.word	0x00003413
c0d066ec:	00003392 	.word	0x00003392
c0d066f0:	00002f86 	.word	0x00002f86
c0d066f4:	00002417 	.word	0x00002417
c0d066f8:	000033f5 	.word	0x000033f5
c0d066fc:	00002113 	.word	0x00002113
c0d06700:	00002f5e 	.word	0x00002f5e
c0d06704:	000033af 	.word	0x000033af
c0d06708:	000033b1 	.word	0x000033b1
c0d0670c:	00003369 	.word	0x00003369
c0d06710:	0000303e 	.word	0x0000303e
c0d06714:	00003343 	.word	0x00003343

c0d06718 <respond_with_user_reject>:

void respond_with_user_reject()
{
c0d06718:	b580      	push	{r7, lr}
c0d0671a:	4804      	ldr	r0, [pc, #16]	; (c0d0672c <respond_with_user_reject+0x14>)
c0d0671c:	2100      	movs	r1, #0
	io_send_buf(ERR_REJECTED_BY_USER, NULL, 0);
c0d0671e:	460a      	mov	r2, r1
c0d06720:	f7fa fd32 	bl	c0d01188 <io_send_buf>
	ui_idle();
c0d06724:	f7fb fbc6 	bl	c0d01eb4 <ui_idle>
}
c0d06728:	bd80      	pop	{r7, pc}
c0d0672a:	46c0      	nop			; (mov r8, r8)
c0d0672c:	00006e09 	.word	0x00006e09

c0d06730 <ui_paginatedText_button>:

unsigned int ui_paginatedText_button(
        unsigned int button_mask,
        unsigned int button_mask_counter MARK_UNUSED
)
{
c0d06730:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d06732:	b08d      	sub	sp, #52	; 0x34
c0d06734:	4604      	mov	r4, r0
c0d06736:	ad01      	add	r5, sp, #4
	paginatedTextState_t* ctx = paginatedTextState;
	TRY_CATCH_UI({
c0d06738:	4628      	mov	r0, r5
c0d0673a:	f001 ff31 	bl	c0d085a0 <setjmp>
c0d0673e:	85a8      	strh	r0, [r5, #44]	; 0x2c
c0d06740:	b285      	uxth	r5, r0
c0d06742:	2d00      	cmp	r5, #0
c0d06744:	d01a      	beq.n	c0d0677c <ui_paginatedText_button+0x4c>
c0d06746:	2d05      	cmp	r5, #5
c0d06748:	d06f      	beq.n	c0d0682a <ui_paginatedText_button+0xfa>
c0d0674a:	a801      	add	r0, sp, #4
c0d0674c:	2100      	movs	r1, #0
c0d0674e:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d06750:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d06752:	f7fe ff69 	bl	c0d05628 <try_context_set>
c0d06756:	4840      	ldr	r0, [pc, #256]	; (c0d06858 <ui_paginatedText_button+0x128>)
c0d06758:	4478      	add	r0, pc
c0d0675a:	4940      	ldr	r1, [pc, #256]	; (c0d0685c <ui_paginatedText_button+0x12c>)
c0d0675c:	4479      	add	r1, pc
c0d0675e:	2267      	movs	r2, #103	; 0x67
c0d06760:	f7fc fa70 	bl	c0d02c44 <mcu_usb_printf>
c0d06764:	483e      	ldr	r0, [pc, #248]	; (c0d06860 <ui_paginatedText_button+0x130>)
c0d06766:	4478      	add	r0, pc
c0d06768:	4629      	mov	r1, r5
c0d0676a:	f7fc fa6b 	bl	c0d02c44 <mcu_usb_printf>
c0d0676e:	483d      	ldr	r0, [pc, #244]	; (c0d06864 <ui_paginatedText_button+0x134>)
c0d06770:	4478      	add	r0, pc
c0d06772:	f7fc fa67 	bl	c0d02c44 <mcu_usb_printf>
};

static inline void ui_crash_handler()
{
	#ifdef RESET_ON_CRASH
	io_seproxyhal_se_reset();
c0d06776:	f7fb ff0b 	bl	c0d02590 <io_seproxyhal_se_reset>
c0d0677a:	e047      	b.n	c0d0680c <ui_paginatedText_button+0xdc>
c0d0677c:	a801      	add	r0, sp, #4
c0d0677e:	f7fe ff53 	bl	c0d05628 <try_context_set>
c0d06782:	900b      	str	r0, [sp, #44]	; 0x2c
c0d06784:	f7ff fdd6 	bl	c0d06334 <assert_uiPaginatedText_magic>
c0d06788:	482c      	ldr	r0, [pc, #176]	; (c0d0683c <ui_paginatedText_button+0x10c>)
c0d0678a:	7801      	ldrb	r1, [r0, #0]
c0d0678c:	392f      	subs	r1, #47	; 0x2f
c0d0678e:	4248      	negs	r0, r1
c0d06790:	4148      	adcs	r0, r1
c0d06792:	492f      	ldr	r1, [pc, #188]	; (c0d06850 <ui_paginatedText_button+0x120>)
c0d06794:	4479      	add	r1, pc
c0d06796:	f7f9 fc6b 	bl	c0d00070 <assert>
c0d0679a:	f7fb f86b 	bl	c0d01874 <device_is_unlocked>
c0d0679e:	492d      	ldr	r1, [pc, #180]	; (c0d06854 <ui_paginatedText_button+0x124>)
c0d067a0:	4479      	add	r1, pc
c0d067a2:	f7f9 fc65 	bl	c0d00070 <assert>
c0d067a6:	2c01      	cmp	r4, #1
c0d067a8:	dd08      	ble.n	c0d067bc <ui_paginatedText_button+0x8c>
c0d067aa:	2c02      	cmp	r4, #2
c0d067ac:	d015      	beq.n	c0d067da <ui_paginatedText_button+0xaa>
c0d067ae:	4824      	ldr	r0, [pc, #144]	; (c0d06840 <ui_paginatedText_button+0x110>)
c0d067b0:	4284      	cmp	r4, r0
c0d067b2:	d012      	beq.n	c0d067da <ui_paginatedText_button+0xaa>
c0d067b4:	4823      	ldr	r0, [pc, #140]	; (c0d06844 <ui_paginatedText_button+0x114>)
c0d067b6:	4284      	cmp	r4, r0
c0d067b8:	d005      	beq.n	c0d067c6 <ui_paginatedText_button+0x96>
c0d067ba:	e027      	b.n	c0d0680c <ui_paginatedText_button+0xdc>
c0d067bc:	4822      	ldr	r0, [pc, #136]	; (c0d06848 <ui_paginatedText_button+0x118>)
c0d067be:	4284      	cmp	r4, r0
c0d067c0:	d01e      	beq.n	c0d06800 <ui_paginatedText_button+0xd0>
c0d067c2:	2c01      	cmp	r4, #1
c0d067c4:	d122      	bne.n	c0d0680c <ui_paginatedText_button+0xdc>
	assert_uiPaginatedText_magic();
c0d067c6:	f7ff fdb5 	bl	c0d06334 <assert_uiPaginatedText_magic>
c0d067ca:	20fc      	movs	r0, #252	; 0xfc
	if (ctx->scrollIndex > 0) {
c0d067cc:	491f      	ldr	r1, [pc, #124]	; (c0d0684c <ui_paginatedText_button+0x11c>)
c0d067ce:	580a      	ldr	r2, [r1, r0]
c0d067d0:	2a00      	cmp	r2, #0
c0d067d2:	d01b      	beq.n	c0d0680c <ui_paginatedText_button+0xdc>
		ctx->scrollIndex--;
c0d067d4:	1e52      	subs	r2, r2, #1
c0d067d6:	500a      	str	r2, [r1, r0]
c0d067d8:	e00f      	b.n	c0d067fa <ui_paginatedText_button+0xca>
	assert_uiPaginatedText_magic();
c0d067da:	f7ff fdab 	bl	c0d06334 <assert_uiPaginatedText_magic>
c0d067de:	24fc      	movs	r4, #252	; 0xfc
	if (ctx->scrollIndex + SIZEOF(ctx->currentText) < 1 + strlen(ctx->fullText)) {
c0d067e0:	4d1a      	ldr	r5, [pc, #104]	; (c0d0684c <ui_paginatedText_button+0x11c>)
c0d067e2:	592e      	ldr	r6, [r5, r4]
c0d067e4:	4637      	mov	r7, r6
c0d067e6:	3712      	adds	r7, #18
c0d067e8:	4628      	mov	r0, r5
c0d067ea:	3032      	adds	r0, #50	; 0x32
c0d067ec:	f001 fefc 	bl	c0d085e8 <strlen>
c0d067f0:	1c40      	adds	r0, r0, #1
c0d067f2:	4287      	cmp	r7, r0
c0d067f4:	d20a      	bcs.n	c0d0680c <ui_paginatedText_button+0xdc>
		paginatedTextState->scrollIndex++;
c0d067f6:	1c70      	adds	r0, r6, #1
c0d067f8:	5128      	str	r0, [r5, r4]
c0d067fa:	f000 fa15 	bl	c0d06c28 <scroll_update_display_content>
c0d067fe:	e005      	b.n	c0d0680c <ui_paginatedText_button+0xdc>
c0d06800:	2001      	movs	r0, #1
c0d06802:	0200      	lsls	r0, r0, #8
	TRY_CATCH_UI({
c0d06804:	4911      	ldr	r1, [pc, #68]	; (c0d0684c <ui_paginatedText_button+0x11c>)
c0d06806:	1808      	adds	r0, r1, r0
c0d06808:	f7ff fdb8 	bl	c0d0637c <uiCallback_confirm>
c0d0680c:	f7fe ff00 	bl	c0d05610 <try_context_get>
c0d06810:	a901      	add	r1, sp, #4
c0d06812:	4288      	cmp	r0, r1
c0d06814:	d102      	bne.n	c0d0681c <ui_paginatedText_button+0xec>
c0d06816:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d06818:	f7fe ff06 	bl	c0d05628 <try_context_set>
c0d0681c:	a801      	add	r0, sp, #4
c0d0681e:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d06820:	2800      	cmp	r0, #0
c0d06822:	d109      	bne.n	c0d06838 <ui_paginatedText_button+0x108>
c0d06824:	2000      	movs	r0, #0
		case BUTTON_EVT_RELEASED | BUTTON_LEFT | BUTTON_RIGHT: // PROCEED
			uiCallback_confirm(&ctx->callback);
			break;
		}
	});
	return 0;
c0d06826:	b00d      	add	sp, #52	; 0x34
c0d06828:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d0682a:	a801      	add	r0, sp, #4
c0d0682c:	2100      	movs	r1, #0
	TRY_CATCH_UI({
c0d0682e:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d06830:	980b      	ldr	r0, [sp, #44]	; 0x2c
c0d06832:	f7fe fef9 	bl	c0d05628 <try_context_set>
c0d06836:	2005      	movs	r0, #5
c0d06838:	f7fb fcac 	bl	c0d02194 <os_longjmp>
c0d0683c:	20000204 	.word	0x20000204
c0d06840:	40000002 	.word	0x40000002
c0d06844:	40000001 	.word	0x40000001
c0d06848:	80000003 	.word	0x80000003
c0d0684c:	2000085c 	.word	0x2000085c
c0d06850:	00003271 	.word	0x00003271
c0d06854:	0000327e 	.word	0x0000327e
c0d06858:	00002267 	.word	0x00002267
c0d0685c:	000032db 	.word	0x000032db
c0d06860:	000032e9 	.word	0x000032e9
c0d06864:	00002db6 	.word	0x00002db6

c0d06868 <ui_prompt_button>:

unsigned int ui_prompt_button(
        unsigned int button_mask,
        unsigned int button_mask_counter MARK_UNUSED
)
{
c0d06868:	b5b0      	push	{r4, r5, r7, lr}
c0d0686a:	b08c      	sub	sp, #48	; 0x30
c0d0686c:	4604      	mov	r4, r0
c0d0686e:	466d      	mov	r5, sp
	TRY_CATCH_UI({
c0d06870:	4628      	mov	r0, r5
c0d06872:	f001 fe95 	bl	c0d085a0 <setjmp>
c0d06876:	85a8      	strh	r0, [r5, #44]	; 0x2c
c0d06878:	b285      	uxth	r5, r0
c0d0687a:	4668      	mov	r0, sp
c0d0687c:	2d00      	cmp	r5, #0
c0d0687e:	d019      	beq.n	c0d068b4 <ui_prompt_button+0x4c>
c0d06880:	2100      	movs	r1, #0
c0d06882:	2d05      	cmp	r5, #5
c0d06884:	d04a      	beq.n	c0d0691c <ui_prompt_button+0xb4>
c0d06886:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d06888:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d0688a:	f7fe fecd 	bl	c0d05628 <try_context_set>
c0d0688e:	482d      	ldr	r0, [pc, #180]	; (c0d06944 <ui_prompt_button+0xdc>)
c0d06890:	4478      	add	r0, pc
c0d06892:	492d      	ldr	r1, [pc, #180]	; (c0d06948 <ui_prompt_button+0xe0>)
c0d06894:	4479      	add	r1, pc
c0d06896:	227e      	movs	r2, #126	; 0x7e
c0d06898:	f7fc f9d4 	bl	c0d02c44 <mcu_usb_printf>
c0d0689c:	482b      	ldr	r0, [pc, #172]	; (c0d0694c <ui_prompt_button+0xe4>)
c0d0689e:	4478      	add	r0, pc
c0d068a0:	4629      	mov	r1, r5
c0d068a2:	f7fc f9cf 	bl	c0d02c44 <mcu_usb_printf>
c0d068a6:	482a      	ldr	r0, [pc, #168]	; (c0d06950 <ui_prompt_button+0xe8>)
c0d068a8:	4478      	add	r0, pc
c0d068aa:	f7fc f9cb 	bl	c0d02c44 <mcu_usb_printf>
c0d068ae:	f7fb fe6f 	bl	c0d02590 <io_seproxyhal_se_reset>
c0d068b2:	e024      	b.n	c0d068fe <ui_prompt_button+0x96>
c0d068b4:	f7fe feb8 	bl	c0d05628 <try_context_set>
c0d068b8:	900a      	str	r0, [sp, #40]	; 0x28
c0d068ba:	f7ff fd4d 	bl	c0d06358 <assert_uiPrompt_magic>
c0d068be:	481b      	ldr	r0, [pc, #108]	; (c0d0692c <ui_prompt_button+0xc4>)
c0d068c0:	7801      	ldrb	r1, [r0, #0]
c0d068c2:	392f      	subs	r1, #47	; 0x2f
c0d068c4:	4248      	negs	r0, r1
c0d068c6:	4148      	adcs	r0, r1
c0d068c8:	491c      	ldr	r1, [pc, #112]	; (c0d0693c <ui_prompt_button+0xd4>)
c0d068ca:	4479      	add	r1, pc
c0d068cc:	1c49      	adds	r1, r1, #1
c0d068ce:	f7f9 fbcf 	bl	c0d00070 <assert>
c0d068d2:	f7fa ffcf 	bl	c0d01874 <device_is_unlocked>
c0d068d6:	491a      	ldr	r1, [pc, #104]	; (c0d06940 <ui_prompt_button+0xd8>)
c0d068d8:	4479      	add	r1, pc
c0d068da:	1c49      	adds	r1, r1, #1
c0d068dc:	f7f9 fbc8 	bl	c0d00070 <assert>
c0d068e0:	4813      	ldr	r0, [pc, #76]	; (c0d06930 <ui_prompt_button+0xc8>)
c0d068e2:	4284      	cmp	r4, r0
c0d068e4:	d007      	beq.n	c0d068f6 <ui_prompt_button+0x8e>
c0d068e6:	4813      	ldr	r0, [pc, #76]	; (c0d06934 <ui_prompt_button+0xcc>)
c0d068e8:	4284      	cmp	r4, r0
c0d068ea:	d108      	bne.n	c0d068fe <ui_prompt_button+0x96>
c0d068ec:	4812      	ldr	r0, [pc, #72]	; (c0d06938 <ui_prompt_button+0xd0>)
c0d068ee:	3040      	adds	r0, #64	; 0x40
c0d068f0:	f7ff fd5a 	bl	c0d063a8 <uiCallback_reject>
c0d068f4:	e003      	b.n	c0d068fe <ui_prompt_button+0x96>
c0d068f6:	4810      	ldr	r0, [pc, #64]	; (c0d06938 <ui_prompt_button+0xd0>)
c0d068f8:	3040      	adds	r0, #64	; 0x40
c0d068fa:	f7ff fd3f 	bl	c0d0637c <uiCallback_confirm>
c0d068fe:	f7fe fe87 	bl	c0d05610 <try_context_get>
c0d06902:	4669      	mov	r1, sp
c0d06904:	4288      	cmp	r0, r1
c0d06906:	d102      	bne.n	c0d0690e <ui_prompt_button+0xa6>
c0d06908:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d0690a:	f7fe fe8d 	bl	c0d05628 <try_context_set>
c0d0690e:	4668      	mov	r0, sp
c0d06910:	8d80      	ldrh	r0, [r0, #44]	; 0x2c
c0d06912:	2800      	cmp	r0, #0
c0d06914:	d107      	bne.n	c0d06926 <ui_prompt_button+0xbe>
c0d06916:	2000      	movs	r0, #0
		case BUTTON_EVT_RELEASED | BUTTON_RIGHT: // APPROVE
			uiCallback_confirm(&promptState->callback);
			break;
		}
	})
	return 0;
c0d06918:	b00c      	add	sp, #48	; 0x30
c0d0691a:	bdb0      	pop	{r4, r5, r7, pc}
	TRY_CATCH_UI({
c0d0691c:	8581      	strh	r1, [r0, #44]	; 0x2c
c0d0691e:	980a      	ldr	r0, [sp, #40]	; 0x28
c0d06920:	f7fe fe82 	bl	c0d05628 <try_context_set>
c0d06924:	2005      	movs	r0, #5
c0d06926:	f7fb fc35 	bl	c0d02194 <os_longjmp>
c0d0692a:	46c0      	nop			; (mov r8, r8)
c0d0692c:	20000204 	.word	0x20000204
c0d06930:	80000002 	.word	0x80000002
c0d06934:	80000001 	.word	0x80000001
c0d06938:	2000085c 	.word	0x2000085c
c0d0693c:	0000318f 	.word	0x0000318f
c0d06940:	0000319b 	.word	0x0000319b
c0d06944:	0000212f 	.word	0x0000212f
c0d06948:	000031f9 	.word	0x000031f9
c0d0694c:	000031b1 	.word	0x000031b1
c0d06950:	00002c7e 	.word	0x00002c7e

c0d06954 <ui_displayBusy>:
		return element;
	}
}

void ui_displayBusy()
{
c0d06954:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d06956:	b081      	sub	sp, #4
c0d06958:	212c      	movs	r1, #44	; 0x2c
	UX_DISPLAY(ui_busy, NULL);
c0d0695a:	9100      	str	r1, [sp, #0]
c0d0695c:	4f2a      	ldr	r7, [pc, #168]	; (c0d06a08 <ui_displayBusy+0xb4>)
c0d0695e:	2002      	movs	r0, #2
c0d06960:	5478      	strb	r0, [r7, r1]
c0d06962:	2064      	movs	r0, #100	; 0x64
c0d06964:	2103      	movs	r1, #3
c0d06966:	5439      	strb	r1, [r7, r0]
c0d06968:	4828      	ldr	r0, [pc, #160]	; (c0d06a0c <ui_displayBusy+0xb8>)
c0d0696a:	4478      	add	r0, pc
c0d0696c:	4928      	ldr	r1, [pc, #160]	; (c0d06a10 <ui_displayBusy+0xbc>)
c0d0696e:	4479      	add	r1, pc
c0d06970:	62b9      	str	r1, [r7, #40]	; 0x28
c0d06972:	2600      	movs	r6, #0
c0d06974:	633e      	str	r6, [r7, #48]	; 0x30
c0d06976:	6378      	str	r0, [r7, #52]	; 0x34
c0d06978:	463c      	mov	r4, r7
c0d0697a:	3464      	adds	r4, #100	; 0x64
c0d0697c:	6066      	str	r6, [r4, #4]
c0d0697e:	4620      	mov	r0, r4
c0d06980:	f7fe fde0 	bl	c0d05544 <os_ux>
c0d06984:	2504      	movs	r5, #4
c0d06986:	4628      	mov	r0, r5
c0d06988:	f7fe fe5c 	bl	c0d05644 <os_sched_last_status>
c0d0698c:	6060      	str	r0, [r4, #4]
c0d0698e:	f7fb fd33 	bl	c0d023f8 <io_seproxyhal_init_ux>
c0d06992:	f7fb fd33 	bl	c0d023fc <io_seproxyhal_init_button>
c0d06996:	84fe      	strh	r6, [r7, #38]	; 0x26
c0d06998:	4628      	mov	r0, r5
c0d0699a:	f7fe fe53 	bl	c0d05644 <os_sched_last_status>
c0d0699e:	6060      	str	r0, [r4, #4]
c0d069a0:	9c00      	ldr	r4, [sp, #0]
c0d069a2:	2800      	cmp	r0, #0
c0d069a4:	d02d      	beq.n	c0d06a02 <ui_displayBusy+0xae>
c0d069a6:	2897      	cmp	r0, #151	; 0x97
c0d069a8:	d02b      	beq.n	c0d06a02 <ui_displayBusy+0xae>
c0d069aa:	6ab8      	ldr	r0, [r7, #40]	; 0x28
c0d069ac:	2800      	cmp	r0, #0
c0d069ae:	d028      	beq.n	c0d06a02 <ui_displayBusy+0xae>
c0d069b0:	8cf8      	ldrh	r0, [r7, #38]	; 0x26
c0d069b2:	5d39      	ldrb	r1, [r7, r4]
c0d069b4:	b280      	uxth	r0, r0
c0d069b6:	4288      	cmp	r0, r1
c0d069b8:	d223      	bcs.n	c0d06a02 <ui_displayBusy+0xae>
c0d069ba:	f7fe fe0f 	bl	c0d055dc <io_seph_is_status_sent>
c0d069be:	2800      	cmp	r0, #0
c0d069c0:	d11f      	bne.n	c0d06a02 <ui_displayBusy+0xae>
c0d069c2:	f7fe fd87 	bl	c0d054d4 <os_perso_isonboarded>
c0d069c6:	28aa      	cmp	r0, #170	; 0xaa
c0d069c8:	d103      	bne.n	c0d069d2 <ui_displayBusy+0x7e>
c0d069ca:	f7fe fdad 	bl	c0d05528 <os_global_pin_is_validated>
c0d069ce:	28aa      	cmp	r0, #170	; 0xaa
c0d069d0:	d117      	bne.n	c0d06a02 <ui_displayBusy+0xae>
c0d069d2:	6ab9      	ldr	r1, [r7, #40]	; 0x28
c0d069d4:	8cfa      	ldrh	r2, [r7, #38]	; 0x26
c0d069d6:	0150      	lsls	r0, r2, #5
c0d069d8:	1808      	adds	r0, r1, r0
c0d069da:	6b3b      	ldr	r3, [r7, #48]	; 0x30
c0d069dc:	2b00      	cmp	r3, #0
c0d069de:	d004      	beq.n	c0d069ea <ui_displayBusy+0x96>
c0d069e0:	4798      	blx	r3
c0d069e2:	2800      	cmp	r0, #0
c0d069e4:	d007      	beq.n	c0d069f6 <ui_displayBusy+0xa2>
c0d069e6:	8cfa      	ldrh	r2, [r7, #38]	; 0x26
c0d069e8:	6ab9      	ldr	r1, [r7, #40]	; 0x28
c0d069ea:	2801      	cmp	r0, #1
c0d069ec:	d101      	bne.n	c0d069f2 <ui_displayBusy+0x9e>
c0d069ee:	0150      	lsls	r0, r2, #5
c0d069f0:	1808      	adds	r0, r1, r0
c0d069f2:	f7fa fbf5 	bl	c0d011e0 <io_seproxyhal_display>
c0d069f6:	8cf8      	ldrh	r0, [r7, #38]	; 0x26
c0d069f8:	1c40      	adds	r0, r0, #1
c0d069fa:	84f8      	strh	r0, [r7, #38]	; 0x26
c0d069fc:	6ab9      	ldr	r1, [r7, #40]	; 0x28
c0d069fe:	2900      	cmp	r1, #0
c0d06a00:	d1d7      	bne.n	c0d069b2 <ui_displayBusy+0x5e>
}
c0d06a02:	b001      	add	sp, #4
c0d06a04:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d06a06:	46c0      	nop			; (mov r8, r8)
c0d06a08:	20000968 	.word	0x20000968
c0d06a0c:	000000a7 	.word	0x000000a7
c0d06a10:	00003166 	.word	0x00003166

c0d06a14 <ui_busy_button>:
{
c0d06a14:	2000      	movs	r0, #0
	return 0;
c0d06a16:	4770      	bx	lr

c0d06a18 <ui_displayPrompt_run>:

void ui_displayPrompt_run()
{
c0d06a18:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d06a1a:	b081      	sub	sp, #4
c0d06a1c:	212c      	movs	r1, #44	; 0x2c
	UX_DISPLAY(ui_prompt, ui_prepro_prompt);
c0d06a1e:	9100      	str	r1, [sp, #0]
c0d06a20:	4f2b      	ldr	r7, [pc, #172]	; (c0d06ad0 <ui_displayPrompt_run+0xb8>)
c0d06a22:	2005      	movs	r0, #5
c0d06a24:	5478      	strb	r0, [r7, r1]
c0d06a26:	2064      	movs	r0, #100	; 0x64
c0d06a28:	2103      	movs	r1, #3
c0d06a2a:	5439      	strb	r1, [r7, r0]
c0d06a2c:	4829      	ldr	r0, [pc, #164]	; (c0d06ad4 <ui_displayPrompt_run+0xbc>)
c0d06a2e:	4478      	add	r0, pc
c0d06a30:	4929      	ldr	r1, [pc, #164]	; (c0d06ad8 <ui_displayPrompt_run+0xc0>)
c0d06a32:	4479      	add	r1, pc
c0d06a34:	62b9      	str	r1, [r7, #40]	; 0x28
c0d06a36:	4929      	ldr	r1, [pc, #164]	; (c0d06adc <ui_displayPrompt_run+0xc4>)
c0d06a38:	4479      	add	r1, pc
c0d06a3a:	6339      	str	r1, [r7, #48]	; 0x30
c0d06a3c:	6378      	str	r0, [r7, #52]	; 0x34
c0d06a3e:	463c      	mov	r4, r7
c0d06a40:	3464      	adds	r4, #100	; 0x64
c0d06a42:	2600      	movs	r6, #0
c0d06a44:	6066      	str	r6, [r4, #4]
c0d06a46:	4620      	mov	r0, r4
c0d06a48:	f7fe fd7c 	bl	c0d05544 <os_ux>
c0d06a4c:	2504      	movs	r5, #4
c0d06a4e:	4628      	mov	r0, r5
c0d06a50:	f7fe fdf8 	bl	c0d05644 <os_sched_last_status>
c0d06a54:	6060      	str	r0, [r4, #4]
c0d06a56:	f7fb fccf 	bl	c0d023f8 <io_seproxyhal_init_ux>
c0d06a5a:	f7fb fccf 	bl	c0d023fc <io_seproxyhal_init_button>
c0d06a5e:	84fe      	strh	r6, [r7, #38]	; 0x26
c0d06a60:	4628      	mov	r0, r5
c0d06a62:	f7fe fdef 	bl	c0d05644 <os_sched_last_status>
c0d06a66:	6060      	str	r0, [r4, #4]
c0d06a68:	9c00      	ldr	r4, [sp, #0]
c0d06a6a:	2800      	cmp	r0, #0
c0d06a6c:	d02d      	beq.n	c0d06aca <ui_displayPrompt_run+0xb2>
c0d06a6e:	2897      	cmp	r0, #151	; 0x97
c0d06a70:	d02b      	beq.n	c0d06aca <ui_displayPrompt_run+0xb2>
c0d06a72:	6ab8      	ldr	r0, [r7, #40]	; 0x28
c0d06a74:	2800      	cmp	r0, #0
c0d06a76:	d028      	beq.n	c0d06aca <ui_displayPrompt_run+0xb2>
c0d06a78:	8cf8      	ldrh	r0, [r7, #38]	; 0x26
c0d06a7a:	5d39      	ldrb	r1, [r7, r4]
c0d06a7c:	b280      	uxth	r0, r0
c0d06a7e:	4288      	cmp	r0, r1
c0d06a80:	d223      	bcs.n	c0d06aca <ui_displayPrompt_run+0xb2>
c0d06a82:	f7fe fdab 	bl	c0d055dc <io_seph_is_status_sent>
c0d06a86:	2800      	cmp	r0, #0
c0d06a88:	d11f      	bne.n	c0d06aca <ui_displayPrompt_run+0xb2>
c0d06a8a:	f7fe fd23 	bl	c0d054d4 <os_perso_isonboarded>
c0d06a8e:	28aa      	cmp	r0, #170	; 0xaa
c0d06a90:	d103      	bne.n	c0d06a9a <ui_displayPrompt_run+0x82>
c0d06a92:	f7fe fd49 	bl	c0d05528 <os_global_pin_is_validated>
c0d06a96:	28aa      	cmp	r0, #170	; 0xaa
c0d06a98:	d117      	bne.n	c0d06aca <ui_displayPrompt_run+0xb2>
c0d06a9a:	6ab9      	ldr	r1, [r7, #40]	; 0x28
c0d06a9c:	8cfa      	ldrh	r2, [r7, #38]	; 0x26
c0d06a9e:	0150      	lsls	r0, r2, #5
c0d06aa0:	1808      	adds	r0, r1, r0
c0d06aa2:	6b3b      	ldr	r3, [r7, #48]	; 0x30
c0d06aa4:	2b00      	cmp	r3, #0
c0d06aa6:	d004      	beq.n	c0d06ab2 <ui_displayPrompt_run+0x9a>
c0d06aa8:	4798      	blx	r3
c0d06aaa:	2800      	cmp	r0, #0
c0d06aac:	d007      	beq.n	c0d06abe <ui_displayPrompt_run+0xa6>
c0d06aae:	8cfa      	ldrh	r2, [r7, #38]	; 0x26
c0d06ab0:	6ab9      	ldr	r1, [r7, #40]	; 0x28
c0d06ab2:	2801      	cmp	r0, #1
c0d06ab4:	d101      	bne.n	c0d06aba <ui_displayPrompt_run+0xa2>
c0d06ab6:	0150      	lsls	r0, r2, #5
c0d06ab8:	1808      	adds	r0, r1, r0
c0d06aba:	f7fa fb91 	bl	c0d011e0 <io_seproxyhal_display>
c0d06abe:	8cf8      	ldrh	r0, [r7, #38]	; 0x26
c0d06ac0:	1c40      	adds	r0, r0, #1
c0d06ac2:	84f8      	strh	r0, [r7, #38]	; 0x26
c0d06ac4:	6ab9      	ldr	r1, [r7, #40]	; 0x28
c0d06ac6:	2900      	cmp	r1, #0
c0d06ac8:	d1d7      	bne.n	c0d06a7a <ui_displayPrompt_run+0x62>
}
c0d06aca:	b001      	add	sp, #4
c0d06acc:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d06ace:	46c0      	nop			; (mov r8, r8)
c0d06ad0:	20000968 	.word	0x20000968
c0d06ad4:	fffffe37 	.word	0xfffffe37
c0d06ad8:	000030e2 	.word	0x000030e2
c0d06adc:	000000a5 	.word	0x000000a5

c0d06ae0 <ui_prepro_prompt>:
{
c0d06ae0:	b510      	push	{r4, lr}
c0d06ae2:	4604      	mov	r4, r0
	assert_uiPrompt_magic();
c0d06ae4:	f7ff fc38 	bl	c0d06358 <assert_uiPrompt_magic>
	switch (element->component.userid) {
c0d06ae8:	7860      	ldrb	r0, [r4, #1]
c0d06aea:	2803      	cmp	r0, #3
c0d06aec:	d004      	beq.n	c0d06af8 <ui_prepro_prompt+0x18>
c0d06aee:	2804      	cmp	r0, #4
c0d06af0:	d107      	bne.n	c0d06b02 <ui_prepro_prompt+0x22>
		return ctx->callback.reject ? element : NULL;
c0d06af2:	4805      	ldr	r0, [pc, #20]	; (c0d06b08 <ui_prepro_prompt+0x28>)
c0d06af4:	6c80      	ldr	r0, [r0, #72]	; 0x48
c0d06af6:	e001      	b.n	c0d06afc <ui_prepro_prompt+0x1c>
		return ctx->callback.confirm ? element : NULL;
c0d06af8:	4803      	ldr	r0, [pc, #12]	; (c0d06b08 <ui_prepro_prompt+0x28>)
c0d06afa:	6c40      	ldr	r0, [r0, #68]	; 0x44
c0d06afc:	2800      	cmp	r0, #0
c0d06afe:	d100      	bne.n	c0d06b02 <ui_prepro_prompt+0x22>
c0d06b00:	4604      	mov	r4, r0
}
c0d06b02:	4620      	mov	r0, r4
c0d06b04:	bd10      	pop	{r4, pc}
c0d06b06:	46c0      	nop			; (mov r8, r8)
c0d06b08:	2000085c 	.word	0x2000085c

c0d06b0c <ui_displayPaginatedText_run>:

void ui_displayPaginatedText_run()
{
c0d06b0c:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d06b0e:	b081      	sub	sp, #4
c0d06b10:	212c      	movs	r1, #44	; 0x2c
	UX_DISPLAY(ui_paginatedText, ui_prepro_paginatedText);
c0d06b12:	9100      	str	r1, [sp, #0]
c0d06b14:	4f2b      	ldr	r7, [pc, #172]	; (c0d06bc4 <ui_displayPaginatedText_run+0xb8>)
c0d06b16:	2005      	movs	r0, #5
c0d06b18:	5478      	strb	r0, [r7, r1]
c0d06b1a:	2064      	movs	r0, #100	; 0x64
c0d06b1c:	2103      	movs	r1, #3
c0d06b1e:	5439      	strb	r1, [r7, r0]
c0d06b20:	4829      	ldr	r0, [pc, #164]	; (c0d06bc8 <ui_displayPaginatedText_run+0xbc>)
c0d06b22:	4478      	add	r0, pc
c0d06b24:	4929      	ldr	r1, [pc, #164]	; (c0d06bcc <ui_displayPaginatedText_run+0xc0>)
c0d06b26:	4479      	add	r1, pc
c0d06b28:	62b9      	str	r1, [r7, #40]	; 0x28
c0d06b2a:	4929      	ldr	r1, [pc, #164]	; (c0d06bd0 <ui_displayPaginatedText_run+0xc4>)
c0d06b2c:	4479      	add	r1, pc
c0d06b2e:	6339      	str	r1, [r7, #48]	; 0x30
c0d06b30:	6378      	str	r0, [r7, #52]	; 0x34
c0d06b32:	463c      	mov	r4, r7
c0d06b34:	3464      	adds	r4, #100	; 0x64
c0d06b36:	2600      	movs	r6, #0
c0d06b38:	6066      	str	r6, [r4, #4]
c0d06b3a:	4620      	mov	r0, r4
c0d06b3c:	f7fe fd02 	bl	c0d05544 <os_ux>
c0d06b40:	2504      	movs	r5, #4
c0d06b42:	4628      	mov	r0, r5
c0d06b44:	f7fe fd7e 	bl	c0d05644 <os_sched_last_status>
c0d06b48:	6060      	str	r0, [r4, #4]
c0d06b4a:	f7fb fc55 	bl	c0d023f8 <io_seproxyhal_init_ux>
c0d06b4e:	f7fb fc55 	bl	c0d023fc <io_seproxyhal_init_button>
c0d06b52:	84fe      	strh	r6, [r7, #38]	; 0x26
c0d06b54:	4628      	mov	r0, r5
c0d06b56:	f7fe fd75 	bl	c0d05644 <os_sched_last_status>
c0d06b5a:	6060      	str	r0, [r4, #4]
c0d06b5c:	9c00      	ldr	r4, [sp, #0]
c0d06b5e:	2800      	cmp	r0, #0
c0d06b60:	d02d      	beq.n	c0d06bbe <ui_displayPaginatedText_run+0xb2>
c0d06b62:	2897      	cmp	r0, #151	; 0x97
c0d06b64:	d02b      	beq.n	c0d06bbe <ui_displayPaginatedText_run+0xb2>
c0d06b66:	6ab8      	ldr	r0, [r7, #40]	; 0x28
c0d06b68:	2800      	cmp	r0, #0
c0d06b6a:	d028      	beq.n	c0d06bbe <ui_displayPaginatedText_run+0xb2>
c0d06b6c:	8cf8      	ldrh	r0, [r7, #38]	; 0x26
c0d06b6e:	5d39      	ldrb	r1, [r7, r4]
c0d06b70:	b280      	uxth	r0, r0
c0d06b72:	4288      	cmp	r0, r1
c0d06b74:	d223      	bcs.n	c0d06bbe <ui_displayPaginatedText_run+0xb2>
c0d06b76:	f7fe fd31 	bl	c0d055dc <io_seph_is_status_sent>
c0d06b7a:	2800      	cmp	r0, #0
c0d06b7c:	d11f      	bne.n	c0d06bbe <ui_displayPaginatedText_run+0xb2>
c0d06b7e:	f7fe fca9 	bl	c0d054d4 <os_perso_isonboarded>
c0d06b82:	28aa      	cmp	r0, #170	; 0xaa
c0d06b84:	d103      	bne.n	c0d06b8e <ui_displayPaginatedText_run+0x82>
c0d06b86:	f7fe fccf 	bl	c0d05528 <os_global_pin_is_validated>
c0d06b8a:	28aa      	cmp	r0, #170	; 0xaa
c0d06b8c:	d117      	bne.n	c0d06bbe <ui_displayPaginatedText_run+0xb2>
c0d06b8e:	6ab9      	ldr	r1, [r7, #40]	; 0x28
c0d06b90:	8cfa      	ldrh	r2, [r7, #38]	; 0x26
c0d06b92:	0150      	lsls	r0, r2, #5
c0d06b94:	1808      	adds	r0, r1, r0
c0d06b96:	6b3b      	ldr	r3, [r7, #48]	; 0x30
c0d06b98:	2b00      	cmp	r3, #0
c0d06b9a:	d004      	beq.n	c0d06ba6 <ui_displayPaginatedText_run+0x9a>
c0d06b9c:	4798      	blx	r3
c0d06b9e:	2800      	cmp	r0, #0
c0d06ba0:	d007      	beq.n	c0d06bb2 <ui_displayPaginatedText_run+0xa6>
c0d06ba2:	8cfa      	ldrh	r2, [r7, #38]	; 0x26
c0d06ba4:	6ab9      	ldr	r1, [r7, #40]	; 0x28
c0d06ba6:	2801      	cmp	r0, #1
c0d06ba8:	d101      	bne.n	c0d06bae <ui_displayPaginatedText_run+0xa2>
c0d06baa:	0150      	lsls	r0, r2, #5
c0d06bac:	1808      	adds	r0, r1, r0
c0d06bae:	f7fa fb17 	bl	c0d011e0 <io_seproxyhal_display>
c0d06bb2:	8cf8      	ldrh	r0, [r7, #38]	; 0x26
c0d06bb4:	1c40      	adds	r0, r0, #1
c0d06bb6:	84f8      	strh	r0, [r7, #38]	; 0x26
c0d06bb8:	6ab9      	ldr	r1, [r7, #40]	; 0x28
c0d06bba:	2900      	cmp	r1, #0
c0d06bbc:	d1d7      	bne.n	c0d06b6e <ui_displayPaginatedText_run+0x62>
}
c0d06bbe:	b001      	add	sp, #4
c0d06bc0:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d06bc2:	46c0      	nop			; (mov r8, r8)
c0d06bc4:	20000968 	.word	0x20000968
c0d06bc8:	fffffc0b 	.word	0xfffffc0b
c0d06bcc:	0000308e 	.word	0x0000308e
c0d06bd0:	000000a5 	.word	0x000000a5

c0d06bd4 <ui_prepro_paginatedText>:
{
c0d06bd4:	b570      	push	{r4, r5, r6, lr}
c0d06bd6:	4604      	mov	r4, r0
	assert_uiPaginatedText_magic();
c0d06bd8:	f7ff fbac 	bl	c0d06334 <assert_uiPaginatedText_magic>
	bool textFitsSinglePage = strlen(ctx->currentText) >= strlen(ctx->fullText);
c0d06bdc:	4e11      	ldr	r6, [pc, #68]	; (c0d06c24 <ui_prepro_paginatedText+0x50>)
c0d06bde:	4630      	mov	r0, r6
c0d06be0:	3020      	adds	r0, #32
c0d06be2:	f001 fd01 	bl	c0d085e8 <strlen>
c0d06be6:	4605      	mov	r5, r0
c0d06be8:	4630      	mov	r0, r6
c0d06bea:	3032      	adds	r0, #50	; 0x32
c0d06bec:	f001 fcfc 	bl	c0d085e8 <strlen>
	switch (element->component.userid) {
c0d06bf0:	7861      	ldrb	r1, [r4, #1]
c0d06bf2:	2902      	cmp	r1, #2
c0d06bf4:	d008      	beq.n	c0d06c08 <ui_prepro_paginatedText+0x34>
c0d06bf6:	2901      	cmp	r1, #1
c0d06bf8:	d111      	bne.n	c0d06c1e <ui_prepro_paginatedText+0x4a>
c0d06bfa:	21fc      	movs	r1, #252	; 0xfc
		return (ctx->scrollIndex != 0 || textFitsSinglePage)
c0d06bfc:	5872      	ldr	r2, [r6, r1]
c0d06bfe:	2a00      	cmp	r2, #0
c0d06c00:	4621      	mov	r1, r4
c0d06c02:	d109      	bne.n	c0d06c18 <ui_prepro_paginatedText+0x44>
c0d06c04:	4611      	mov	r1, r2
c0d06c06:	e007      	b.n	c0d06c18 <ui_prepro_paginatedText+0x44>
c0d06c08:	21fc      	movs	r1, #252	; 0xfc
		return ((ctx->scrollIndex + SIZEOF(ctx->currentText)
c0d06c0a:	5871      	ldr	r1, [r6, r1]
c0d06c0c:	3112      	adds	r1, #18
		         < strlen(ctx->fullText) + 1)
c0d06c0e:	1c42      	adds	r2, r0, #1
		        || textFitsSinglePage)
c0d06c10:	4291      	cmp	r1, r2
c0d06c12:	4621      	mov	r1, r4
c0d06c14:	d300      	bcc.n	c0d06c18 <ui_prepro_paginatedText+0x44>
c0d06c16:	2100      	movs	r1, #0
c0d06c18:	4285      	cmp	r5, r0
c0d06c1a:	d200      	bcs.n	c0d06c1e <ui_prepro_paginatedText+0x4a>
c0d06c1c:	460c      	mov	r4, r1
}
c0d06c1e:	4620      	mov	r0, r4
c0d06c20:	bd70      	pop	{r4, r5, r6, pc}
c0d06c22:	46c0      	nop			; (mov r8, r8)
c0d06c24:	2000085c 	.word	0x2000085c

c0d06c28 <scroll_update_display_content>:
{
c0d06c28:	b570      	push	{r4, r5, r6, lr}
	assert_uiPaginatedText_magic();
c0d06c2a:	f7ff fb83 	bl	c0d06334 <assert_uiPaginatedText_magic>
c0d06c2e:	2031      	movs	r0, #49	; 0x31
	ASSERT(ctx->currentText[SIZEOF(ctx->currentText) - 1] == '\0');
c0d06c30:	4c2c      	ldr	r4, [pc, #176]	; (c0d06ce4 <scroll_update_display_content+0xbc>)
c0d06c32:	5c21      	ldrb	r1, [r4, r0]
c0d06c34:	4248      	negs	r0, r1
c0d06c36:	4148      	adcs	r0, r1
c0d06c38:	492c      	ldr	r1, [pc, #176]	; (c0d06cec <scroll_update_display_content+0xc4>)
c0d06c3a:	4479      	add	r1, pc
c0d06c3c:	f7f9 fa18 	bl	c0d00070 <assert>
c0d06c40:	26fc      	movs	r6, #252	; 0xfc
	ASSERT(ctx->scrollIndex + SIZEOF(ctx->currentText) <= SIZEOF(ctx->fullText));
c0d06c42:	59a0      	ldr	r0, [r4, r6]
c0d06c44:	3012      	adds	r0, #18
c0d06c46:	2500      	movs	r5, #0
c0d06c48:	28c9      	cmp	r0, #201	; 0xc9
c0d06c4a:	d301      	bcc.n	c0d06c50 <scroll_update_display_content+0x28>
c0d06c4c:	4628      	mov	r0, r5
c0d06c4e:	e000      	b.n	c0d06c52 <scroll_update_display_content+0x2a>
c0d06c50:	2001      	movs	r0, #1
c0d06c52:	4927      	ldr	r1, [pc, #156]	; (c0d06cf0 <scroll_update_display_content+0xc8>)
c0d06c54:	4479      	add	r1, pc
c0d06c56:	f7f9 fa0b 	bl	c0d00070 <assert>
	        ctx->fullText + ctx->scrollIndex,
c0d06c5a:	59a0      	ldr	r0, [r4, r6]
c0d06c5c:	1821      	adds	r1, r4, r0
c0d06c5e:	3132      	adds	r1, #50	; 0x32
	ASSERT(ctx->currentText[SIZEOF(ctx->currentText) - 1] == '\0');
c0d06c60:	3420      	adds	r4, #32
c0d06c62:	2211      	movs	r2, #17
	memmove(
c0d06c64:	4620      	mov	r0, r4
c0d06c66:	f001 fc5a 	bl	c0d0851e <__aeabi_memmove>
	UX_REDISPLAY();
c0d06c6a:	f7fb fbc5 	bl	c0d023f8 <io_seproxyhal_init_ux>
c0d06c6e:	f7fb fbc5 	bl	c0d023fc <io_seproxyhal_init_button>
c0d06c72:	4c1d      	ldr	r4, [pc, #116]	; (c0d06ce8 <scroll_update_display_content+0xc0>)
c0d06c74:	84e5      	strh	r5, [r4, #38]	; 0x26
c0d06c76:	2004      	movs	r0, #4
c0d06c78:	f7fe fce4 	bl	c0d05644 <os_sched_last_status>
c0d06c7c:	66a0      	str	r0, [r4, #104]	; 0x68
c0d06c7e:	2800      	cmp	r0, #0
c0d06c80:	d02e      	beq.n	c0d06ce0 <scroll_update_display_content+0xb8>
c0d06c82:	2897      	cmp	r0, #151	; 0x97
c0d06c84:	d02c      	beq.n	c0d06ce0 <scroll_update_display_content+0xb8>
c0d06c86:	6aa0      	ldr	r0, [r4, #40]	; 0x28
c0d06c88:	2800      	cmp	r0, #0
c0d06c8a:	d029      	beq.n	c0d06ce0 <scroll_update_display_content+0xb8>
c0d06c8c:	8ce0      	ldrh	r0, [r4, #38]	; 0x26
c0d06c8e:	212c      	movs	r1, #44	; 0x2c
c0d06c90:	5c61      	ldrb	r1, [r4, r1]
c0d06c92:	b280      	uxth	r0, r0
c0d06c94:	4288      	cmp	r0, r1
c0d06c96:	d223      	bcs.n	c0d06ce0 <scroll_update_display_content+0xb8>
c0d06c98:	f7fe fca0 	bl	c0d055dc <io_seph_is_status_sent>
c0d06c9c:	2800      	cmp	r0, #0
c0d06c9e:	d11f      	bne.n	c0d06ce0 <scroll_update_display_content+0xb8>
c0d06ca0:	f7fe fc18 	bl	c0d054d4 <os_perso_isonboarded>
c0d06ca4:	28aa      	cmp	r0, #170	; 0xaa
c0d06ca6:	d103      	bne.n	c0d06cb0 <scroll_update_display_content+0x88>
c0d06ca8:	f7fe fc3e 	bl	c0d05528 <os_global_pin_is_validated>
c0d06cac:	28aa      	cmp	r0, #170	; 0xaa
c0d06cae:	d117      	bne.n	c0d06ce0 <scroll_update_display_content+0xb8>
c0d06cb0:	6aa1      	ldr	r1, [r4, #40]	; 0x28
c0d06cb2:	8ce2      	ldrh	r2, [r4, #38]	; 0x26
c0d06cb4:	0150      	lsls	r0, r2, #5
c0d06cb6:	1808      	adds	r0, r1, r0
c0d06cb8:	6b23      	ldr	r3, [r4, #48]	; 0x30
c0d06cba:	2b00      	cmp	r3, #0
c0d06cbc:	d004      	beq.n	c0d06cc8 <scroll_update_display_content+0xa0>
c0d06cbe:	4798      	blx	r3
c0d06cc0:	2800      	cmp	r0, #0
c0d06cc2:	d007      	beq.n	c0d06cd4 <scroll_update_display_content+0xac>
c0d06cc4:	8ce2      	ldrh	r2, [r4, #38]	; 0x26
c0d06cc6:	6aa1      	ldr	r1, [r4, #40]	; 0x28
c0d06cc8:	2801      	cmp	r0, #1
c0d06cca:	d101      	bne.n	c0d06cd0 <scroll_update_display_content+0xa8>
c0d06ccc:	0150      	lsls	r0, r2, #5
c0d06cce:	1808      	adds	r0, r1, r0
c0d06cd0:	f7fa fa86 	bl	c0d011e0 <io_seproxyhal_display>
c0d06cd4:	8ce0      	ldrh	r0, [r4, #38]	; 0x26
c0d06cd6:	1c40      	adds	r0, r0, #1
c0d06cd8:	84e0      	strh	r0, [r4, #38]	; 0x26
c0d06cda:	6aa1      	ldr	r1, [r4, #40]	; 0x28
c0d06cdc:	2900      	cmp	r1, #0
c0d06cde:	d1d6      	bne.n	c0d06c8e <scroll_update_display_content+0x66>
}
c0d06ce0:	bd70      	pop	{r4, r5, r6, pc}
c0d06ce2:	46c0      	nop			; (mov r8, r8)
c0d06ce4:	2000085c 	.word	0x2000085c
c0d06ce8:	20000968 	.word	0x20000968
c0d06cec:	00002e64 	.word	0x00002e64
c0d06cf0:	00002e63 	.word	0x00002e63

c0d06cf4 <ui_displayPathScreen>:
void ui_displayPathScreen(
        const char* screenHeader,
        const bip44_path_t* path,
        ui_callback_fn_t callback
)
{
c0d06cf4:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d06cf6:	b09f      	sub	sp, #124	; 0x7c
c0d06cf8:	4614      	mov	r4, r2
c0d06cfa:	460e      	mov	r6, r1
c0d06cfc:	4605      	mov	r5, r0
	ASSERT(strlen(screenHeader) > 0);
c0d06cfe:	7800      	ldrb	r0, [r0, #0]
c0d06d00:	1e41      	subs	r1, r0, #1
c0d06d02:	4188      	sbcs	r0, r1
c0d06d04:	490d      	ldr	r1, [pc, #52]	; (c0d06d3c <ui_displayPathScreen+0x48>)
c0d06d06:	4479      	add	r1, pc
c0d06d08:	f7f9 f9b2 	bl	c0d00070 <assert>
	ASSERT(strlen(screenHeader) < BUFFER_SIZE_PARANOIA);
c0d06d0c:	4628      	mov	r0, r5
c0d06d0e:	f001 fc6b 	bl	c0d085e8 <strlen>
c0d06d12:	0a81      	lsrs	r1, r0, #10
c0d06d14:	4248      	negs	r0, r1
c0d06d16:	4148      	adcs	r0, r1
c0d06d18:	4909      	ldr	r1, [pc, #36]	; (c0d06d40 <ui_displayPathScreen+0x4c>)
c0d06d1a:	4479      	add	r1, pc
c0d06d1c:	f7f9 f9a8 	bl	c0d00070 <assert>
c0d06d20:	466f      	mov	r7, sp
c0d06d22:	227a      	movs	r2, #122	; 0x7a

	char pathStr[1 + BIP44_MAX_PATH_STRING_LENGTH];
	bip44_printToStr(path, pathStr, SIZEOF(pathStr));
c0d06d24:	4630      	mov	r0, r6
c0d06d26:	4639      	mov	r1, r7
c0d06d28:	f7f9 fa2e 	bl	c0d00188 <bip44_printToStr>

	ui_displayPaginatedText(
c0d06d2c:	4628      	mov	r0, r5
c0d06d2e:	4639      	mov	r1, r7
c0d06d30:	4622      	mov	r2, r4
c0d06d32:	f7ff fc0b 	bl	c0d0654c <ui_displayPaginatedText>
	        screenHeader,
	        pathStr,
	        callback
	);
}
c0d06d36:	b01f      	add	sp, #124	; 0x7c
c0d06d38:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d06d3a:	46c0      	nop			; (mov r8, r8)
c0d06d3c:	00002f4e 	.word	0x00002f4e
c0d06d40:	00002f4d 	.word	0x00002f4d

c0d06d44 <ui_displayUint64Screen>:
void ui_displayUint64Screen(
        const char* screenHeader,
        uint64_t value,
        ui_callback_fn_t callback
)
{
c0d06d44:	b5b0      	push	{r4, r5, r7, lr}
c0d06d46:	b088      	sub	sp, #32
c0d06d48:	4619      	mov	r1, r3
c0d06d4a:	4604      	mov	r4, r0
c0d06d4c:	466d      	mov	r5, sp
c0d06d4e:	231e      	movs	r3, #30
	char valueStr[30];
	str_formatUint64(value, valueStr, SIZEOF(valueStr));
c0d06d50:	4610      	mov	r0, r2
c0d06d52:	462a      	mov	r2, r5
c0d06d54:	f7fe fc84 	bl	c0d05660 <str_formatUint64>
c0d06d58:	9a0c      	ldr	r2, [sp, #48]	; 0x30

	ui_displayPaginatedText(
c0d06d5a:	4620      	mov	r0, r4
c0d06d5c:	4629      	mov	r1, r5
c0d06d5e:	f7ff fbf5 	bl	c0d0654c <ui_displayPaginatedText>
	        screenHeader,
	        valueStr,
	        callback
	);
}
c0d06d62:	b008      	add	sp, #32
c0d06d64:	bdb0      	pop	{r4, r5, r7, pc}
	...

c0d06d68 <ui_displayHexBufferScreen>:
void ui_displayHexBufferScreen(
        const char* screenHeader,
        const uint8_t* buffer, size_t bufferSize,
        ui_callback_fn_t callback
)
{
c0d06d68:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d06d6a:	b0a3      	sub	sp, #140	; 0x8c
c0d06d6c:	9301      	str	r3, [sp, #4]
c0d06d6e:	4616      	mov	r6, r2
c0d06d70:	9100      	str	r1, [sp, #0]
c0d06d72:	4605      	mov	r5, r0
	ASSERT(strlen(screenHeader) > 0);
c0d06d74:	7800      	ldrb	r0, [r0, #0]
c0d06d76:	1e41      	subs	r1, r0, #1
c0d06d78:	4188      	sbcs	r0, r1
c0d06d7a:	4922      	ldr	r1, [pc, #136]	; (c0d06e04 <ui_displayHexBufferScreen+0x9c>)
c0d06d7c:	4479      	add	r1, pc
c0d06d7e:	f7f9 f977 	bl	c0d00070 <assert>
	ASSERT(strlen(screenHeader) < BUFFER_SIZE_PARANOIA);
c0d06d82:	4628      	mov	r0, r5
c0d06d84:	f001 fc30 	bl	c0d085e8 <strlen>
c0d06d88:	0a81      	lsrs	r1, r0, #10
c0d06d8a:	4248      	negs	r0, r1
c0d06d8c:	4148      	adcs	r0, r1
c0d06d8e:	491e      	ldr	r1, [pc, #120]	; (c0d06e08 <ui_displayHexBufferScreen+0xa0>)
c0d06d90:	4479      	add	r1, pc
c0d06d92:	f7f9 f96d 	bl	c0d00070 <assert>
	ASSERT(bufferSize > 0);
c0d06d96:	1e71      	subs	r1, r6, #1
c0d06d98:	4630      	mov	r0, r6
c0d06d9a:	4188      	sbcs	r0, r1
c0d06d9c:	491b      	ldr	r1, [pc, #108]	; (c0d06e0c <ui_displayHexBufferScreen+0xa4>)
c0d06d9e:	4479      	add	r1, pc
c0d06da0:	f7f9 f966 	bl	c0d00070 <assert>
	ASSERT(bufferSize <= 65); // this is used for hashes, and pubkeys, they are all smaller
c0d06da4:	2e42      	cmp	r6, #66	; 0x42
c0d06da6:	d301      	bcc.n	c0d06dac <ui_displayHexBufferScreen+0x44>
c0d06da8:	2000      	movs	r0, #0
c0d06daa:	e000      	b.n	c0d06dae <ui_displayHexBufferScreen+0x46>
c0d06dac:	2001      	movs	r0, #1
c0d06dae:	4918      	ldr	r1, [pc, #96]	; (c0d06e10 <ui_displayHexBufferScreen+0xa8>)
c0d06db0:	4479      	add	r1, pc
c0d06db2:	f7f9 f95d 	bl	c0d00070 <assert>
c0d06db6:	ac02      	add	r4, sp, #8
c0d06db8:	2783      	movs	r7, #131	; 0x83

	char bufferHex[2 * 65 + 1];
	explicit_bzero(bufferHex, SIZEOF(bufferHex));
c0d06dba:	4620      	mov	r0, r4
c0d06dbc:	4639      	mov	r1, r7
c0d06dbe:	f001 fbb9 	bl	c0d08534 <explicit_bzero>

	size_t length = encode_hex(
c0d06dc2:	9800      	ldr	r0, [sp, #0]
c0d06dc4:	4631      	mov	r1, r6
c0d06dc6:	4622      	mov	r2, r4
c0d06dc8:	463b      	mov	r3, r7
c0d06dca:	f7fa f8ab 	bl	c0d00f24 <encode_hex>
c0d06dce:	4607      	mov	r7, r0
	                        buffer, bufferSize,
	                        bufferHex, SIZEOF(bufferHex)
	                );
	ASSERT(length == strlen(bufferHex));
c0d06dd0:	4620      	mov	r0, r4
c0d06dd2:	f001 fc09 	bl	c0d085e8 <strlen>
c0d06dd6:	1a39      	subs	r1, r7, r0
c0d06dd8:	4248      	negs	r0, r1
c0d06dda:	4148      	adcs	r0, r1
c0d06ddc:	490d      	ldr	r1, [pc, #52]	; (c0d06e14 <ui_displayHexBufferScreen+0xac>)
c0d06dde:	4479      	add	r1, pc
c0d06de0:	f7f9 f946 	bl	c0d00070 <assert>
	ASSERT(length == 2 * bufferSize);
c0d06de4:	0070      	lsls	r0, r6, #1
c0d06de6:	1a39      	subs	r1, r7, r0
c0d06de8:	4248      	negs	r0, r1
c0d06dea:	4148      	adcs	r0, r1
c0d06dec:	490a      	ldr	r1, [pc, #40]	; (c0d06e18 <ui_displayHexBufferScreen+0xb0>)
c0d06dee:	4479      	add	r1, pc
c0d06df0:	f7f9 f93e 	bl	c0d00070 <assert>

	ui_displayPaginatedText(
c0d06df4:	4628      	mov	r0, r5
c0d06df6:	4621      	mov	r1, r4
c0d06df8:	9a01      	ldr	r2, [sp, #4]
c0d06dfa:	f7ff fba7 	bl	c0d0654c <ui_displayPaginatedText>
	        screenHeader,
	        bufferHex,
	        callback
	);
}
c0d06dfe:	b023      	add	sp, #140	; 0x8c
c0d06e00:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d06e02:	46c0      	nop			; (mov r8, r8)
c0d06e04:	00002efe 	.word	0x00002efe
c0d06e08:	00002efd 	.word	0x00002efd
c0d06e0c:	00002f02 	.word	0x00002f02
c0d06e10:	00002f03 	.word	0x00002f03
c0d06e14:	00002ee8 	.word	0x00002ee8
c0d06e18:	00002eeb 	.word	0x00002eeb

c0d06e1c <USBD_LL_Init>:
  */
USBD_StatusTypeDef  USBD_LL_Init (USBD_HandleTypeDef *pdev)
{ 
  UNUSED(pdev);
  ep_in_stall = 0;
  ep_out_stall = 0;
c0d06e1c:	4902      	ldr	r1, [pc, #8]	; (c0d06e28 <USBD_LL_Init+0xc>)
c0d06e1e:	2000      	movs	r0, #0
c0d06e20:	6008      	str	r0, [r1, #0]
  ep_in_stall = 0;
c0d06e22:	4902      	ldr	r1, [pc, #8]	; (c0d06e2c <USBD_LL_Init+0x10>)
c0d06e24:	6008      	str	r0, [r1, #0]
  return USBD_OK;
c0d06e26:	4770      	bx	lr
c0d06e28:	200009dc 	.word	0x200009dc
c0d06e2c:	200009d8 	.word	0x200009d8

c0d06e30 <USBD_LL_DeInit>:
  * @brief  De-Initializes the Low Level portion of the Device driver.
  * @param  pdev: Device handle
  * @retval USBD Status
  */
USBD_StatusTypeDef  USBD_LL_DeInit (USBD_HandleTypeDef *pdev)
{
c0d06e30:	b510      	push	{r4, lr}
  UNUSED(pdev);
  // usb off
  G_io_seproxyhal_spi_buffer[0] = SEPROXYHAL_TAG_USB_CONFIG;
c0d06e32:	4807      	ldr	r0, [pc, #28]	; (c0d06e50 <USBD_LL_DeInit+0x20>)
c0d06e34:	2102      	movs	r1, #2
  G_io_seproxyhal_spi_buffer[1] = 0;
  G_io_seproxyhal_spi_buffer[2] = 1;
  G_io_seproxyhal_spi_buffer[3] = SEPROXYHAL_TAG_USB_CONFIG_DISCONNECT;
c0d06e36:	70c1      	strb	r1, [r0, #3]
c0d06e38:	2101      	movs	r1, #1
  G_io_seproxyhal_spi_buffer[2] = 1;
c0d06e3a:	7081      	strb	r1, [r0, #2]
c0d06e3c:	2400      	movs	r4, #0
  G_io_seproxyhal_spi_buffer[1] = 0;
c0d06e3e:	7044      	strb	r4, [r0, #1]
c0d06e40:	214f      	movs	r1, #79	; 0x4f
  G_io_seproxyhal_spi_buffer[0] = SEPROXYHAL_TAG_USB_CONFIG;
c0d06e42:	7001      	strb	r1, [r0, #0]
c0d06e44:	2104      	movs	r1, #4
  io_seproxyhal_spi_send(G_io_seproxyhal_spi_buffer, 4);
c0d06e46:	f7fe fbbd 	bl	c0d055c4 <io_seph_send>

  return USBD_OK; 
c0d06e4a:	4620      	mov	r0, r4
c0d06e4c:	bd10      	pop	{r4, pc}
c0d06e4e:	46c0      	nop			; (mov r8, r8)
c0d06e50:	20000205 	.word	0x20000205

c0d06e54 <USBD_LL_Start>:
  * @brief  Starts the Low Level portion of the Device driver. 
  * @param  pdev: Device handle
  * @retval USBD Status
  */
USBD_StatusTypeDef  USBD_LL_Start(USBD_HandleTypeDef *pdev)
{
c0d06e54:	b570      	push	{r4, r5, r6, lr}
c0d06e56:	b082      	sub	sp, #8
c0d06e58:	466d      	mov	r5, sp
c0d06e5a:	2400      	movs	r4, #0
  // reset address
  buffer[0] = SEPROXYHAL_TAG_USB_CONFIG;
  buffer[1] = 0;
  buffer[2] = 2;
  buffer[3] = SEPROXYHAL_TAG_USB_CONFIG_ADDR;
  buffer[4] = 0;
c0d06e5c:	712c      	strb	r4, [r5, #4]
c0d06e5e:	2003      	movs	r0, #3
  buffer[3] = SEPROXYHAL_TAG_USB_CONFIG_ADDR;
c0d06e60:	70e8      	strb	r0, [r5, #3]
c0d06e62:	2002      	movs	r0, #2
  buffer[2] = 2;
c0d06e64:	70a8      	strb	r0, [r5, #2]
  buffer[1] = 0;
c0d06e66:	706c      	strb	r4, [r5, #1]
c0d06e68:	264f      	movs	r6, #79	; 0x4f
  buffer[0] = SEPROXYHAL_TAG_USB_CONFIG;
c0d06e6a:	702e      	strb	r6, [r5, #0]
c0d06e6c:	2105      	movs	r1, #5
  io_seproxyhal_spi_send(buffer, 5);
c0d06e6e:	4628      	mov	r0, r5
c0d06e70:	f7fe fba8 	bl	c0d055c4 <io_seph_send>
c0d06e74:	2001      	movs	r0, #1
  
  // start usb operation
  buffer[0] = SEPROXYHAL_TAG_USB_CONFIG;
  buffer[1] = 0;
  buffer[2] = 1;
  buffer[3] = SEPROXYHAL_TAG_USB_CONFIG_CONNECT;
c0d06e76:	70e8      	strb	r0, [r5, #3]
  buffer[2] = 1;
c0d06e78:	70a8      	strb	r0, [r5, #2]
  buffer[1] = 0;
c0d06e7a:	706c      	strb	r4, [r5, #1]
  buffer[0] = SEPROXYHAL_TAG_USB_CONFIG;
c0d06e7c:	702e      	strb	r6, [r5, #0]
c0d06e7e:	2104      	movs	r1, #4
  io_seproxyhal_spi_send(buffer, 4);
c0d06e80:	4628      	mov	r0, r5
c0d06e82:	f7fe fb9f 	bl	c0d055c4 <io_seph_send>
  return USBD_OK; 
c0d06e86:	4620      	mov	r0, r4
c0d06e88:	b002      	add	sp, #8
c0d06e8a:	bd70      	pop	{r4, r5, r6, pc}

c0d06e8c <USBD_LL_Stop>:
  * @brief  Stops the Low Level portion of the Device driver.
  * @param  pdev: Device handle
  * @retval USBD Status
  */
USBD_StatusTypeDef  USBD_LL_Stop (USBD_HandleTypeDef *pdev)
{
c0d06e8c:	b510      	push	{r4, lr}
c0d06e8e:	b082      	sub	sp, #8
c0d06e90:	a801      	add	r0, sp, #4
c0d06e92:	2102      	movs	r1, #2
  UNUSED(pdev);
  uint8_t buffer[4];
  buffer[0] = SEPROXYHAL_TAG_USB_CONFIG;
  buffer[1] = 0;
  buffer[2] = 1;
  buffer[3] = SEPROXYHAL_TAG_USB_CONFIG_DISCONNECT;
c0d06e94:	70c1      	strb	r1, [r0, #3]
c0d06e96:	2101      	movs	r1, #1
  buffer[2] = 1;
c0d06e98:	7081      	strb	r1, [r0, #2]
c0d06e9a:	2400      	movs	r4, #0
  buffer[1] = 0;
c0d06e9c:	7044      	strb	r4, [r0, #1]
c0d06e9e:	214f      	movs	r1, #79	; 0x4f
  buffer[0] = SEPROXYHAL_TAG_USB_CONFIG;
c0d06ea0:	7001      	strb	r1, [r0, #0]
c0d06ea2:	2104      	movs	r1, #4
  io_seproxyhal_spi_send(buffer, 4);
c0d06ea4:	f7fe fb8e 	bl	c0d055c4 <io_seph_send>
  return USBD_OK; 
c0d06ea8:	4620      	mov	r0, r4
c0d06eaa:	b002      	add	sp, #8
c0d06eac:	bd10      	pop	{r4, pc}
	...

c0d06eb0 <USBD_LL_OpenEP>:
  */
USBD_StatusTypeDef  USBD_LL_OpenEP  (USBD_HandleTypeDef *pdev, 
                                      uint8_t  ep_addr,                                      
                                      uint8_t  ep_type,
                                      uint16_t ep_mps)
{
c0d06eb0:	b570      	push	{r4, r5, r6, lr}
c0d06eb2:	b082      	sub	sp, #8
  uint8_t buffer[8];
  UNUSED(pdev);

  ep_in_stall = 0;
c0d06eb4:	4814      	ldr	r0, [pc, #80]	; (c0d06f08 <USBD_LL_OpenEP+0x58>)
c0d06eb6:	2400      	movs	r4, #0
c0d06eb8:	6004      	str	r4, [r0, #0]
  ep_out_stall = 0;
c0d06eba:	4814      	ldr	r0, [pc, #80]	; (c0d06f0c <USBD_LL_OpenEP+0x5c>)
c0d06ebc:	6004      	str	r4, [r0, #0]
c0d06ebe:	466d      	mov	r5, sp
  buffer[1] = 0;
  buffer[2] = 5;
  buffer[3] = SEPROXYHAL_TAG_USB_CONFIG_ENDPOINTS;
  buffer[4] = 1;
  buffer[5] = ep_addr;
  buffer[6] = 0;
c0d06ec0:	71ac      	strb	r4, [r5, #6]
  buffer[5] = ep_addr;
c0d06ec2:	7169      	strb	r1, [r5, #5]
c0d06ec4:	2001      	movs	r0, #1
  buffer[4] = 1;
c0d06ec6:	7128      	strb	r0, [r5, #4]
c0d06ec8:	2104      	movs	r1, #4
  buffer[3] = SEPROXYHAL_TAG_USB_CONFIG_ENDPOINTS;
c0d06eca:	70e9      	strb	r1, [r5, #3]
c0d06ecc:	2605      	movs	r6, #5
  buffer[2] = 5;
c0d06ece:	70ae      	strb	r6, [r5, #2]
  buffer[1] = 0;
c0d06ed0:	706c      	strb	r4, [r5, #1]
c0d06ed2:	244f      	movs	r4, #79	; 0x4f
  buffer[0] = SEPROXYHAL_TAG_USB_CONFIG;
c0d06ed4:	702c      	strb	r4, [r5, #0]
  switch(ep_type) {
c0d06ed6:	2a01      	cmp	r2, #1
c0d06ed8:	dc05      	bgt.n	c0d06ee6 <USBD_LL_OpenEP+0x36>
c0d06eda:	2a00      	cmp	r2, #0
c0d06edc:	d00a      	beq.n	c0d06ef4 <USBD_LL_OpenEP+0x44>
c0d06ede:	2a01      	cmp	r2, #1
c0d06ee0:	d10a      	bne.n	c0d06ef8 <USBD_LL_OpenEP+0x48>
c0d06ee2:	4608      	mov	r0, r1
c0d06ee4:	e006      	b.n	c0d06ef4 <USBD_LL_OpenEP+0x44>
c0d06ee6:	2a02      	cmp	r2, #2
c0d06ee8:	d003      	beq.n	c0d06ef2 <USBD_LL_OpenEP+0x42>
c0d06eea:	2a03      	cmp	r2, #3
c0d06eec:	d104      	bne.n	c0d06ef8 <USBD_LL_OpenEP+0x48>
c0d06eee:	2002      	movs	r0, #2
c0d06ef0:	e000      	b.n	c0d06ef4 <USBD_LL_OpenEP+0x44>
c0d06ef2:	2003      	movs	r0, #3
c0d06ef4:	4669      	mov	r1, sp
c0d06ef6:	7188      	strb	r0, [r1, #6]
c0d06ef8:	4668      	mov	r0, sp
      break;
    case USBD_EP_TYPE_INTR:
      buffer[6] = SEPROXYHAL_TAG_USB_CONFIG_TYPE_INTERRUPT;
      break;
  }
  buffer[7] = ep_mps;
c0d06efa:	71c3      	strb	r3, [r0, #7]
c0d06efc:	2108      	movs	r1, #8
  io_seproxyhal_spi_send(buffer, 8);
c0d06efe:	f7fe fb61 	bl	c0d055c4 <io_seph_send>
c0d06f02:	2000      	movs	r0, #0
  return USBD_OK; 
c0d06f04:	b002      	add	sp, #8
c0d06f06:	bd70      	pop	{r4, r5, r6, pc}
c0d06f08:	200009d8 	.word	0x200009d8
c0d06f0c:	200009dc 	.word	0x200009dc

c0d06f10 <USBD_LL_StallEP>:
  * @param  pdev: Device handle
  * @param  ep_addr: Endpoint Number
  * @retval USBD Status
  */
USBD_StatusTypeDef  USBD_LL_StallEP (USBD_HandleTypeDef *pdev, uint8_t ep_addr)   
{ 
c0d06f10:	b5b0      	push	{r4, r5, r7, lr}
c0d06f12:	b082      	sub	sp, #8
c0d06f14:	460d      	mov	r5, r1
c0d06f16:	4668      	mov	r0, sp
c0d06f18:	2400      	movs	r4, #0
  buffer[0] = SEPROXYHAL_TAG_USB_EP_PREPARE;
  buffer[1] = 0;
  buffer[2] = 3;
  buffer[3] = ep_addr;
  buffer[4] = SEPROXYHAL_TAG_USB_EP_PREPARE_DIR_STALL;
  buffer[5] = 0;
c0d06f1a:	7144      	strb	r4, [r0, #5]
c0d06f1c:	2140      	movs	r1, #64	; 0x40
  buffer[4] = SEPROXYHAL_TAG_USB_EP_PREPARE_DIR_STALL;
c0d06f1e:	7101      	strb	r1, [r0, #4]
  buffer[3] = ep_addr;
c0d06f20:	70c5      	strb	r5, [r0, #3]
c0d06f22:	2103      	movs	r1, #3
  buffer[2] = 3;
c0d06f24:	7081      	strb	r1, [r0, #2]
  buffer[1] = 0;
c0d06f26:	7044      	strb	r4, [r0, #1]
c0d06f28:	2150      	movs	r1, #80	; 0x50
  buffer[0] = SEPROXYHAL_TAG_USB_EP_PREPARE;
c0d06f2a:	7001      	strb	r1, [r0, #0]
c0d06f2c:	2106      	movs	r1, #6
  io_seproxyhal_spi_send(buffer, 6);
c0d06f2e:	f7fe fb49 	bl	c0d055c4 <io_seph_send>
  if (ep_addr & 0x80) {
c0d06f32:	0628      	lsls	r0, r5, #24
c0d06f34:	d501      	bpl.n	c0d06f3a <USBD_LL_StallEP+0x2a>
c0d06f36:	4807      	ldr	r0, [pc, #28]	; (c0d06f54 <USBD_LL_StallEP+0x44>)
c0d06f38:	e000      	b.n	c0d06f3c <USBD_LL_StallEP+0x2c>
c0d06f3a:	4805      	ldr	r0, [pc, #20]	; (c0d06f50 <USBD_LL_StallEP+0x40>)
c0d06f3c:	6801      	ldr	r1, [r0, #0]
c0d06f3e:	227f      	movs	r2, #127	; 0x7f
c0d06f40:	4015      	ands	r5, r2
c0d06f42:	2201      	movs	r2, #1
c0d06f44:	40aa      	lsls	r2, r5
c0d06f46:	430a      	orrs	r2, r1
c0d06f48:	6002      	str	r2, [r0, #0]
    ep_in_stall |= (1<<(ep_addr&0x7F));
  }
  else {
    ep_out_stall |= (1<<(ep_addr&0x7F)); 
  }
  return USBD_OK; 
c0d06f4a:	4620      	mov	r0, r4
c0d06f4c:	b002      	add	sp, #8
c0d06f4e:	bdb0      	pop	{r4, r5, r7, pc}
c0d06f50:	200009dc 	.word	0x200009dc
c0d06f54:	200009d8 	.word	0x200009d8

c0d06f58 <USBD_LL_ClearStallEP>:
  * @param  pdev: Device handle
  * @param  ep_addr: Endpoint Number
  * @retval USBD Status
  */
USBD_StatusTypeDef  USBD_LL_ClearStallEP (USBD_HandleTypeDef *pdev, uint8_t ep_addr)   
{
c0d06f58:	b5b0      	push	{r4, r5, r7, lr}
c0d06f5a:	b082      	sub	sp, #8
c0d06f5c:	460d      	mov	r5, r1
c0d06f5e:	4668      	mov	r0, sp
c0d06f60:	2400      	movs	r4, #0
  buffer[0] = SEPROXYHAL_TAG_USB_EP_PREPARE;
  buffer[1] = 0;
  buffer[2] = 3;
  buffer[3] = ep_addr;
  buffer[4] = SEPROXYHAL_TAG_USB_EP_PREPARE_DIR_UNSTALL;
  buffer[5] = 0;
c0d06f62:	7144      	strb	r4, [r0, #5]
c0d06f64:	2180      	movs	r1, #128	; 0x80
  buffer[4] = SEPROXYHAL_TAG_USB_EP_PREPARE_DIR_UNSTALL;
c0d06f66:	7101      	strb	r1, [r0, #4]
  buffer[3] = ep_addr;
c0d06f68:	70c5      	strb	r5, [r0, #3]
c0d06f6a:	2103      	movs	r1, #3
  buffer[2] = 3;
c0d06f6c:	7081      	strb	r1, [r0, #2]
  buffer[1] = 0;
c0d06f6e:	7044      	strb	r4, [r0, #1]
c0d06f70:	2150      	movs	r1, #80	; 0x50
  buffer[0] = SEPROXYHAL_TAG_USB_EP_PREPARE;
c0d06f72:	7001      	strb	r1, [r0, #0]
c0d06f74:	2106      	movs	r1, #6
  io_seproxyhal_spi_send(buffer, 6);
c0d06f76:	f7fe fb25 	bl	c0d055c4 <io_seph_send>
  if (ep_addr & 0x80) {
c0d06f7a:	0628      	lsls	r0, r5, #24
c0d06f7c:	d501      	bpl.n	c0d06f82 <USBD_LL_ClearStallEP+0x2a>
c0d06f7e:	4807      	ldr	r0, [pc, #28]	; (c0d06f9c <USBD_LL_ClearStallEP+0x44>)
c0d06f80:	e000      	b.n	c0d06f84 <USBD_LL_ClearStallEP+0x2c>
c0d06f82:	4805      	ldr	r0, [pc, #20]	; (c0d06f98 <USBD_LL_ClearStallEP+0x40>)
c0d06f84:	6801      	ldr	r1, [r0, #0]
c0d06f86:	227f      	movs	r2, #127	; 0x7f
c0d06f88:	4015      	ands	r5, r2
c0d06f8a:	2201      	movs	r2, #1
c0d06f8c:	40aa      	lsls	r2, r5
c0d06f8e:	4391      	bics	r1, r2
c0d06f90:	6001      	str	r1, [r0, #0]
    ep_in_stall &= ~(1<<(ep_addr&0x7F));
  }
  else {
    ep_out_stall &= ~(1<<(ep_addr&0x7F)); 
  }
  return USBD_OK; 
c0d06f92:	4620      	mov	r0, r4
c0d06f94:	b002      	add	sp, #8
c0d06f96:	bdb0      	pop	{r4, r5, r7, pc}
c0d06f98:	200009dc 	.word	0x200009dc
c0d06f9c:	200009d8 	.word	0x200009d8

c0d06fa0 <USBD_LL_IsStallEP>:
c0d06fa0:	0608      	lsls	r0, r1, #24
c0d06fa2:	d501      	bpl.n	c0d06fa8 <USBD_LL_IsStallEP+0x8>
c0d06fa4:	4805      	ldr	r0, [pc, #20]	; (c0d06fbc <USBD_LL_IsStallEP+0x1c>)
c0d06fa6:	e000      	b.n	c0d06faa <USBD_LL_IsStallEP+0xa>
c0d06fa8:	4803      	ldr	r0, [pc, #12]	; (c0d06fb8 <USBD_LL_IsStallEP+0x18>)
c0d06faa:	7802      	ldrb	r2, [r0, #0]
c0d06fac:	207f      	movs	r0, #127	; 0x7f
c0d06fae:	4001      	ands	r1, r0
c0d06fb0:	2001      	movs	r0, #1
c0d06fb2:	4088      	lsls	r0, r1
c0d06fb4:	4010      	ands	r0, r2
  }
  else
  {
    return ep_out_stall & (1<<(ep_addr&0x7F));
  }
}
c0d06fb6:	4770      	bx	lr
c0d06fb8:	200009dc 	.word	0x200009dc
c0d06fbc:	200009d8 	.word	0x200009d8

c0d06fc0 <USBD_LL_SetUSBAddress>:
  * @param  pdev: Device handle
  * @param  ep_addr: Endpoint Number
  * @retval USBD Status
  */
USBD_StatusTypeDef  USBD_LL_SetUSBAddress (USBD_HandleTypeDef *pdev, uint8_t dev_addr)   
{
c0d06fc0:	b510      	push	{r4, lr}
c0d06fc2:	b082      	sub	sp, #8
c0d06fc4:	4668      	mov	r0, sp
  uint8_t buffer[5];
  buffer[0] = SEPROXYHAL_TAG_USB_CONFIG;
  buffer[1] = 0;
  buffer[2] = 2;
  buffer[3] = SEPROXYHAL_TAG_USB_CONFIG_ADDR;
  buffer[4] = dev_addr;
c0d06fc6:	7101      	strb	r1, [r0, #4]
c0d06fc8:	2103      	movs	r1, #3
  buffer[3] = SEPROXYHAL_TAG_USB_CONFIG_ADDR;
c0d06fca:	70c1      	strb	r1, [r0, #3]
c0d06fcc:	2102      	movs	r1, #2
  buffer[2] = 2;
c0d06fce:	7081      	strb	r1, [r0, #2]
c0d06fd0:	2400      	movs	r4, #0
  buffer[1] = 0;
c0d06fd2:	7044      	strb	r4, [r0, #1]
c0d06fd4:	214f      	movs	r1, #79	; 0x4f
  buffer[0] = SEPROXYHAL_TAG_USB_CONFIG;
c0d06fd6:	7001      	strb	r1, [r0, #0]
c0d06fd8:	2105      	movs	r1, #5
  io_seproxyhal_spi_send(buffer, 5);
c0d06fda:	f7fe faf3 	bl	c0d055c4 <io_seph_send>
  return USBD_OK; 
c0d06fde:	4620      	mov	r0, r4
c0d06fe0:	b002      	add	sp, #8
c0d06fe2:	bd10      	pop	{r4, pc}

c0d06fe4 <USBD_LL_Transmit>:
  */
USBD_StatusTypeDef  USBD_LL_Transmit (USBD_HandleTypeDef *pdev, 
                                      uint8_t  ep_addr,                                      
                                      uint8_t  *pbuf,
                                      uint16_t  size)
{
c0d06fe4:	b5b0      	push	{r4, r5, r7, lr}
c0d06fe6:	b082      	sub	sp, #8
c0d06fe8:	461c      	mov	r4, r3
c0d06fea:	4615      	mov	r5, r2
c0d06fec:	4668      	mov	r0, sp
  buffer[0] = SEPROXYHAL_TAG_USB_EP_PREPARE;
  buffer[1] = (3+size)>>8;
  buffer[2] = (3+size);
  buffer[3] = ep_addr;
  buffer[4] = SEPROXYHAL_TAG_USB_EP_PREPARE_DIR_IN;
  buffer[5] = size;
c0d06fee:	7143      	strb	r3, [r0, #5]
c0d06ff0:	2220      	movs	r2, #32
  buffer[4] = SEPROXYHAL_TAG_USB_EP_PREPARE_DIR_IN;
c0d06ff2:	7102      	strb	r2, [r0, #4]
  buffer[3] = ep_addr;
c0d06ff4:	70c1      	strb	r1, [r0, #3]
c0d06ff6:	2150      	movs	r1, #80	; 0x50
  buffer[0] = SEPROXYHAL_TAG_USB_EP_PREPARE;
c0d06ff8:	7001      	strb	r1, [r0, #0]
  buffer[1] = (3+size)>>8;
c0d06ffa:	1cd9      	adds	r1, r3, #3
  buffer[2] = (3+size);
c0d06ffc:	7081      	strb	r1, [r0, #2]
  buffer[1] = (3+size)>>8;
c0d06ffe:	0a09      	lsrs	r1, r1, #8
c0d07000:	7041      	strb	r1, [r0, #1]
c0d07002:	2106      	movs	r1, #6
  io_seproxyhal_spi_send(buffer, 6);
c0d07004:	f7fe fade 	bl	c0d055c4 <io_seph_send>
  io_seproxyhal_spi_send(pbuf, size);
c0d07008:	4628      	mov	r0, r5
c0d0700a:	4621      	mov	r1, r4
c0d0700c:	f7fe fada 	bl	c0d055c4 <io_seph_send>
c0d07010:	2000      	movs	r0, #0
  return USBD_OK;   
c0d07012:	b002      	add	sp, #8
c0d07014:	bdb0      	pop	{r4, r5, r7, pc}

c0d07016 <USBD_LL_PrepareReceive>:
  * @retval USBD Status
  */
USBD_StatusTypeDef  USBD_LL_PrepareReceive(USBD_HandleTypeDef *pdev, 
                                           uint8_t  ep_addr,
                                           uint16_t  size)
{
c0d07016:	b510      	push	{r4, lr}
c0d07018:	b082      	sub	sp, #8
c0d0701a:	4668      	mov	r0, sp
  buffer[0] = SEPROXYHAL_TAG_USB_EP_PREPARE;
  buffer[1] = (3/*+size*/)>>8;
  buffer[2] = (3/*+size*/);
  buffer[3] = ep_addr;
  buffer[4] = SEPROXYHAL_TAG_USB_EP_PREPARE_DIR_OUT;
  buffer[5] = size; // expected size, not transmitted here !
c0d0701c:	7142      	strb	r2, [r0, #5]
c0d0701e:	2230      	movs	r2, #48	; 0x30
  buffer[4] = SEPROXYHAL_TAG_USB_EP_PREPARE_DIR_OUT;
c0d07020:	7102      	strb	r2, [r0, #4]
  buffer[3] = ep_addr;
c0d07022:	70c1      	strb	r1, [r0, #3]
c0d07024:	2103      	movs	r1, #3
  buffer[2] = (3/*+size*/);
c0d07026:	7081      	strb	r1, [r0, #2]
c0d07028:	2400      	movs	r4, #0
  buffer[1] = (3/*+size*/)>>8;
c0d0702a:	7044      	strb	r4, [r0, #1]
c0d0702c:	2150      	movs	r1, #80	; 0x50
  buffer[0] = SEPROXYHAL_TAG_USB_EP_PREPARE;
c0d0702e:	7001      	strb	r1, [r0, #0]
c0d07030:	2106      	movs	r1, #6
  io_seproxyhal_spi_send(buffer, 6);
c0d07032:	f7fe fac7 	bl	c0d055c4 <io_seph_send>
  return USBD_OK;   
c0d07036:	4620      	mov	r0, r4
c0d07038:	b002      	add	sp, #8
c0d0703a:	bd10      	pop	{r4, pc}

c0d0703c <USBD_Init>:
* @param  pdesc: Descriptor structure address
* @param  id: Low level core index
* @retval None
*/
USBD_StatusTypeDef USBD_Init(USBD_HandleTypeDef *pdev, USBD_DescriptorsTypeDef *pdesc, uint8_t id)
{
c0d0703c:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0703e:	b081      	sub	sp, #4
  /* Check whether the USB Host handle is valid */
  if(pdev == NULL)
c0d07040:	2800      	cmp	r0, #0
c0d07042:	d012      	beq.n	c0d0706a <USBD_Init+0x2e>
c0d07044:	4615      	mov	r5, r2
c0d07046:	460e      	mov	r6, r1
c0d07048:	4604      	mov	r4, r0
c0d0704a:	4607      	mov	r7, r0
c0d0704c:	379c      	adds	r7, #156	; 0x9c
c0d0704e:	21d4      	movs	r1, #212	; 0xd4
  {
    USBD_ErrLog("Invalid Device handle");
    return USBD_FAIL; 
  }

  memset(pdev, 0, sizeof(USBD_HandleTypeDef));
c0d07050:	f001 fa5c 	bl	c0d0850c <__aeabi_memclr>
  
  /* Assign USBD Descriptors */
  if(pdesc != NULL)
c0d07054:	2e00      	cmp	r6, #0
c0d07056:	d000      	beq.n	c0d0705a <USBD_Init+0x1e>
  {
    pdev->pDesc = pdesc;
c0d07058:	617e      	str	r6, [r7, #20]
  }
  
  /* Set Device initial State */
  pdev->dev_state  = USBD_STATE_DEFAULT;
  pdev->id = id;
c0d0705a:	7025      	strb	r5, [r4, #0]
c0d0705c:	2001      	movs	r0, #1
  pdev->dev_state  = USBD_STATE_DEFAULT;
c0d0705e:	7038      	strb	r0, [r7, #0]
  /* Initialize low level driver */
  USBD_LL_Init(pdev);
c0d07060:	4620      	mov	r0, r4
c0d07062:	f7ff fedb 	bl	c0d06e1c <USBD_LL_Init>
c0d07066:	2000      	movs	r0, #0
c0d07068:	e000      	b.n	c0d0706c <USBD_Init+0x30>
c0d0706a:	2002      	movs	r0, #2
  
  return USBD_OK; 
}
c0d0706c:	b001      	add	sp, #4
c0d0706e:	bdf0      	pop	{r4, r5, r6, r7, pc}

c0d07070 <USBD_DeInit>:
*         Re-Initialize th device library
* @param  pdev: device instance
* @retval status: status
*/
USBD_StatusTypeDef USBD_DeInit(USBD_HandleTypeDef *pdev)
{
c0d07070:	b5b0      	push	{r4, r5, r7, lr}
c0d07072:	4604      	mov	r4, r0
c0d07074:	209c      	movs	r0, #156	; 0x9c
c0d07076:	2101      	movs	r1, #1
  /* Set Default State */
  pdev->dev_state  = USBD_STATE_DEFAULT;
c0d07078:	5421      	strb	r1, [r4, r0]
c0d0707a:	25b4      	movs	r5, #180	; 0xb4
  
  /* Free Class Resources */
  uint8_t intf;
  for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
    if(pdev->interfacesClass[intf].pClass != NULL) {
c0d0707c:	5960      	ldr	r0, [r4, r5]
c0d0707e:	2800      	cmp	r0, #0
c0d07080:	d006      	beq.n	c0d07090 <USBD_DeInit+0x20>
      ((DeInit_t)PIC(pdev->interfacesClass[intf].pClass->DeInit))(pdev, pdev->dev_config);  
c0d07082:	6840      	ldr	r0, [r0, #4]
c0d07084:	f7fc f950 	bl	c0d03328 <pic>
c0d07088:	4602      	mov	r2, r0
c0d0708a:	7921      	ldrb	r1, [r4, #4]
c0d0708c:	4620      	mov	r0, r4
c0d0708e:	4790      	blx	r2
  for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
c0d07090:	3508      	adds	r5, #8
c0d07092:	2dcc      	cmp	r5, #204	; 0xcc
c0d07094:	d1f2      	bne.n	c0d0707c <USBD_DeInit+0xc>
    }
  }
  
    /* Stop the low level driver  */
  USBD_LL_Stop(pdev); 
c0d07096:	4620      	mov	r0, r4
c0d07098:	f7ff fef8 	bl	c0d06e8c <USBD_LL_Stop>
  
  /* Initialize low level driver */
  USBD_LL_DeInit(pdev);
c0d0709c:	4620      	mov	r0, r4
c0d0709e:	f7ff fec7 	bl	c0d06e30 <USBD_LL_DeInit>
c0d070a2:	2000      	movs	r0, #0
  
  return USBD_OK;
c0d070a4:	bdb0      	pop	{r4, r5, r7, pc}

c0d070a6 <USBD_RegisterClassForInterface>:
  * @retval USBD Status
  */
USBD_StatusTypeDef USBD_RegisterClassForInterface(uint8_t interfaceidx, USBD_HandleTypeDef *pdev, USBD_ClassTypeDef *pclass)
{
  USBD_StatusTypeDef   status = USBD_OK;
  if(pclass != 0)
c0d070a6:	2a00      	cmp	r2, #0
c0d070a8:	d008      	beq.n	c0d070bc <USBD_RegisterClassForInterface+0x16>
c0d070aa:	4603      	mov	r3, r0
c0d070ac:	2000      	movs	r0, #0
  {
    if (interfaceidx < USBD_MAX_NUM_INTERFACES) {
c0d070ae:	2b02      	cmp	r3, #2
c0d070b0:	d803      	bhi.n	c0d070ba <USBD_RegisterClassForInterface+0x14>
      /* link the class to the USB Device handle */
      pdev->interfacesClass[interfaceidx].pClass = pclass;
c0d070b2:	00db      	lsls	r3, r3, #3
c0d070b4:	18c9      	adds	r1, r1, r3
c0d070b6:	23b4      	movs	r3, #180	; 0xb4
c0d070b8:	50ca      	str	r2, [r1, r3]
  {
    USBD_ErrLog("Invalid Class handle");
    status = USBD_FAIL; 
  }
  
  return status;
c0d070ba:	4770      	bx	lr
c0d070bc:	2002      	movs	r0, #2
c0d070be:	4770      	bx	lr

c0d070c0 <USBD_Start>:
  *         Start the USB Device Core.
  * @param  pdev: Device Handle
  * @retval USBD Status
  */
USBD_StatusTypeDef  USBD_Start  (USBD_HandleTypeDef *pdev)
{
c0d070c0:	b580      	push	{r7, lr}
  
  /* Start the low level driver  */
  USBD_LL_Start(pdev); 
c0d070c2:	f7ff fec7 	bl	c0d06e54 <USBD_LL_Start>
c0d070c6:	2000      	movs	r0, #0
  
  return USBD_OK;  
c0d070c8:	bd80      	pop	{r7, pc}

c0d070ca <USBD_SetClassConfig>:
* @param  cfgidx: configuration index
* @retval status
*/

USBD_StatusTypeDef USBD_SetClassConfig(USBD_HandleTypeDef  *pdev, uint8_t cfgidx)
{
c0d070ca:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d070cc:	b081      	sub	sp, #4
c0d070ce:	460c      	mov	r4, r1
c0d070d0:	4605      	mov	r5, r0
c0d070d2:	2600      	movs	r6, #0
c0d070d4:	27b4      	movs	r7, #180	; 0xb4
  /* Set configuration  and Start the Class*/
  uint8_t intf;
  for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
    if(usbd_is_valid_intf(pdev, intf)) {
c0d070d6:	4628      	mov	r0, r5
c0d070d8:	4631      	mov	r1, r6
c0d070da:	f000 f95c 	bl	c0d07396 <usbd_is_valid_intf>
c0d070de:	2800      	cmp	r0, #0
c0d070e0:	d007      	beq.n	c0d070f2 <USBD_SetClassConfig+0x28>
      ((Init_t)PIC(pdev->interfacesClass[intf].pClass->Init))(pdev, cfgidx);
c0d070e2:	59e8      	ldr	r0, [r5, r7]
c0d070e4:	6800      	ldr	r0, [r0, #0]
c0d070e6:	f7fc f91f 	bl	c0d03328 <pic>
c0d070ea:	4602      	mov	r2, r0
c0d070ec:	4628      	mov	r0, r5
c0d070ee:	4621      	mov	r1, r4
c0d070f0:	4790      	blx	r2
  for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
c0d070f2:	3708      	adds	r7, #8
c0d070f4:	1c76      	adds	r6, r6, #1
c0d070f6:	2e03      	cmp	r6, #3
c0d070f8:	d1ed      	bne.n	c0d070d6 <USBD_SetClassConfig+0xc>
c0d070fa:	2000      	movs	r0, #0
    }
  }

  return USBD_OK; 
c0d070fc:	b001      	add	sp, #4
c0d070fe:	bdf0      	pop	{r4, r5, r6, r7, pc}

c0d07100 <USBD_ClrClassConfig>:
* @param  pdev: device instance
* @param  cfgidx: configuration index
* @retval status: USBD_StatusTypeDef
*/
USBD_StatusTypeDef USBD_ClrClassConfig(USBD_HandleTypeDef  *pdev, uint8_t cfgidx)
{
c0d07100:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d07102:	b081      	sub	sp, #4
c0d07104:	460c      	mov	r4, r1
c0d07106:	4605      	mov	r5, r0
c0d07108:	2600      	movs	r6, #0
c0d0710a:	27b4      	movs	r7, #180	; 0xb4
  /* Clear configuration  and De-initialize the Class process*/
  uint8_t intf;
  for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
    if(usbd_is_valid_intf(pdev, intf)) {
c0d0710c:	4628      	mov	r0, r5
c0d0710e:	4631      	mov	r1, r6
c0d07110:	f000 f941 	bl	c0d07396 <usbd_is_valid_intf>
c0d07114:	2800      	cmp	r0, #0
c0d07116:	d007      	beq.n	c0d07128 <USBD_ClrClassConfig+0x28>
      ((DeInit_t)PIC(pdev->interfacesClass[intf].pClass->DeInit))(pdev, cfgidx);  
c0d07118:	59e8      	ldr	r0, [r5, r7]
c0d0711a:	6840      	ldr	r0, [r0, #4]
c0d0711c:	f7fc f904 	bl	c0d03328 <pic>
c0d07120:	4602      	mov	r2, r0
c0d07122:	4628      	mov	r0, r5
c0d07124:	4621      	mov	r1, r4
c0d07126:	4790      	blx	r2
  for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
c0d07128:	3708      	adds	r7, #8
c0d0712a:	1c76      	adds	r6, r6, #1
c0d0712c:	2e03      	cmp	r6, #3
c0d0712e:	d1ed      	bne.n	c0d0710c <USBD_ClrClassConfig+0xc>
c0d07130:	2000      	movs	r0, #0
    }
  }
  return USBD_OK;
c0d07132:	b001      	add	sp, #4
c0d07134:	bdf0      	pop	{r4, r5, r6, r7, pc}

c0d07136 <USBD_LL_SetupStage>:
*         Handle the setup stage
* @param  pdev: device instance
* @retval status
*/
USBD_StatusTypeDef USBD_LL_SetupStage(USBD_HandleTypeDef *pdev, uint8_t *psetup)
{
c0d07136:	b570      	push	{r4, r5, r6, lr}
c0d07138:	4604      	mov	r4, r0
c0d0713a:	4606      	mov	r6, r0
c0d0713c:	3694      	adds	r6, #148	; 0x94
  USBD_ParseSetupRequest(&pdev->request, psetup);
c0d0713e:	4635      	mov	r5, r6
c0d07140:	3514      	adds	r5, #20
c0d07142:	4628      	mov	r0, r5
c0d07144:	f000 fb5e 	bl	c0d07804 <USBD_ParseSetupRequest>
c0d07148:	2094      	movs	r0, #148	; 0x94
c0d0714a:	2101      	movs	r1, #1
  
  pdev->ep0_state = USBD_EP0_SETUP;
c0d0714c:	5021      	str	r1, [r4, r0]
c0d0714e:	20ae      	movs	r0, #174	; 0xae
  pdev->ep0_data_len = pdev->request.wLength;
c0d07150:	5a20      	ldrh	r0, [r4, r0]
c0d07152:	6070      	str	r0, [r6, #4]
  
  switch (pdev->request.bmRequest & 0x1F) 
c0d07154:	7d31      	ldrb	r1, [r6, #20]
c0d07156:	201f      	movs	r0, #31
c0d07158:	4008      	ands	r0, r1
c0d0715a:	2802      	cmp	r0, #2
c0d0715c:	d008      	beq.n	c0d07170 <USBD_LL_SetupStage+0x3a>
c0d0715e:	2801      	cmp	r0, #1
c0d07160:	d00b      	beq.n	c0d0717a <USBD_LL_SetupStage+0x44>
c0d07162:	2800      	cmp	r0, #0
c0d07164:	d10e      	bne.n	c0d07184 <USBD_LL_SetupStage+0x4e>
  {
  case USB_REQ_RECIPIENT_DEVICE:   
    USBD_StdDevReq (pdev, &pdev->request);
c0d07166:	4620      	mov	r0, r4
c0d07168:	4629      	mov	r1, r5
c0d0716a:	f000 f91f 	bl	c0d073ac <USBD_StdDevReq>
c0d0716e:	e00e      	b.n	c0d0718e <USBD_LL_SetupStage+0x58>
  case USB_REQ_RECIPIENT_INTERFACE:     
    USBD_StdItfReq(pdev, &pdev->request);
    break;
    
  case USB_REQ_RECIPIENT_ENDPOINT:        
    USBD_StdEPReq(pdev, &pdev->request);   
c0d07170:	4620      	mov	r0, r4
c0d07172:	4629      	mov	r1, r5
c0d07174:	f000 fac3 	bl	c0d076fe <USBD_StdEPReq>
c0d07178:	e009      	b.n	c0d0718e <USBD_LL_SetupStage+0x58>
    USBD_StdItfReq(pdev, &pdev->request);
c0d0717a:	4620      	mov	r0, r4
c0d0717c:	4629      	mov	r1, r5
c0d0717e:	f000 fa9a 	bl	c0d076b6 <USBD_StdItfReq>
c0d07182:	e004      	b.n	c0d0718e <USBD_LL_SetupStage+0x58>
c0d07184:	2080      	movs	r0, #128	; 0x80
    break;
    
  default:           
    USBD_LL_StallEP(pdev , pdev->request.bmRequest & 0x80);
c0d07186:	4001      	ands	r1, r0
c0d07188:	4620      	mov	r0, r4
c0d0718a:	f7ff fec1 	bl	c0d06f10 <USBD_LL_StallEP>
c0d0718e:	2000      	movs	r0, #0
    break;
  }  
  return USBD_OK;  
c0d07190:	bd70      	pop	{r4, r5, r6, pc}

c0d07192 <USBD_LL_DataOutStage>:
* @param  pdev: device instance
* @param  epnum: endpoint index
* @retval status
*/
USBD_StatusTypeDef USBD_LL_DataOutStage(USBD_HandleTypeDef *pdev , uint8_t epnum, uint8_t *pdata)
{
c0d07192:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d07194:	b083      	sub	sp, #12
c0d07196:	9202      	str	r2, [sp, #8]
c0d07198:	4604      	mov	r4, r0
c0d0719a:	4606      	mov	r6, r0
c0d0719c:	3694      	adds	r6, #148	; 0x94
c0d0719e:	9101      	str	r1, [sp, #4]
  USBD_EndpointTypeDef    *pep;
  
  if(epnum == 0) 
c0d071a0:	2900      	cmp	r1, #0
c0d071a2:	d01a      	beq.n	c0d071da <USBD_LL_DataOutStage+0x48>
c0d071a4:	2700      	movs	r7, #0
c0d071a6:	25b4      	movs	r5, #180	; 0xb4
  }
  else {

    uint8_t intf;
    for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
      if( usbd_is_valid_intf(pdev, intf) &&  (pdev->interfacesClass[intf].pClass->DataOut != NULL)&&
c0d071a8:	4620      	mov	r0, r4
c0d071aa:	4639      	mov	r1, r7
c0d071ac:	f000 f8f3 	bl	c0d07396 <usbd_is_valid_intf>
c0d071b0:	2800      	cmp	r0, #0
c0d071b2:	d00d      	beq.n	c0d071d0 <USBD_LL_DataOutStage+0x3e>
c0d071b4:	5960      	ldr	r0, [r4, r5]
c0d071b6:	6980      	ldr	r0, [r0, #24]
c0d071b8:	2800      	cmp	r0, #0
c0d071ba:	d009      	beq.n	c0d071d0 <USBD_LL_DataOutStage+0x3e>
         (pdev->dev_state == USBD_STATE_CONFIGURED))
c0d071bc:	7a31      	ldrb	r1, [r6, #8]
      if( usbd_is_valid_intf(pdev, intf) &&  (pdev->interfacesClass[intf].pClass->DataOut != NULL)&&
c0d071be:	2903      	cmp	r1, #3
c0d071c0:	d106      	bne.n	c0d071d0 <USBD_LL_DataOutStage+0x3e>
      {
        ((DataOut_t)PIC(pdev->interfacesClass[intf].pClass->DataOut))(pdev, epnum, pdata); 
c0d071c2:	f7fc f8b1 	bl	c0d03328 <pic>
c0d071c6:	4603      	mov	r3, r0
c0d071c8:	4620      	mov	r0, r4
c0d071ca:	9901      	ldr	r1, [sp, #4]
c0d071cc:	9a02      	ldr	r2, [sp, #8]
c0d071ce:	4798      	blx	r3
    for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
c0d071d0:	3508      	adds	r5, #8
c0d071d2:	1c7f      	adds	r7, r7, #1
c0d071d4:	2f03      	cmp	r7, #3
c0d071d6:	d1e7      	bne.n	c0d071a8 <USBD_LL_DataOutStage+0x16>
c0d071d8:	e02c      	b.n	c0d07234 <USBD_LL_DataOutStage+0xa2>
    if ( pdev->ep0_state == USBD_EP0_DATA_OUT)
c0d071da:	6830      	ldr	r0, [r6, #0]
c0d071dc:	2803      	cmp	r0, #3
c0d071de:	d129      	bne.n	c0d07234 <USBD_LL_DataOutStage+0xa2>
      if(pep->rem_length > pep->maxpacket)
c0d071e0:	6de1      	ldr	r1, [r4, #92]	; 0x5c
c0d071e2:	6e20      	ldr	r0, [r4, #96]	; 0x60
c0d071e4:	4281      	cmp	r1, r0
c0d071e6:	d90a      	bls.n	c0d071fe <USBD_LL_DataOutStage+0x6c>
        pep->rem_length -=  pep->maxpacket;
c0d071e8:	1a09      	subs	r1, r1, r0
c0d071ea:	65e1      	str	r1, [r4, #92]	; 0x5c
                            MIN(pep->rem_length ,pep->maxpacket));
c0d071ec:	4281      	cmp	r1, r0
c0d071ee:	d300      	bcc.n	c0d071f2 <USBD_LL_DataOutStage+0x60>
c0d071f0:	4601      	mov	r1, r0
        USBD_CtlContinueRx (pdev, 
c0d071f2:	b28a      	uxth	r2, r1
c0d071f4:	4620      	mov	r0, r4
c0d071f6:	9902      	ldr	r1, [sp, #8]
c0d071f8:	f000 fd8e 	bl	c0d07d18 <USBD_CtlContinueRx>
c0d071fc:	e01a      	b.n	c0d07234 <USBD_LL_DataOutStage+0xa2>
c0d071fe:	2500      	movs	r5, #0
c0d07200:	27b4      	movs	r7, #180	; 0xb4
          if(usbd_is_valid_intf(pdev, intf) &&  (pdev->interfacesClass[intf].pClass->EP0_RxReady != NULL)&&
c0d07202:	4620      	mov	r0, r4
c0d07204:	4629      	mov	r1, r5
c0d07206:	f000 f8c6 	bl	c0d07396 <usbd_is_valid_intf>
c0d0720a:	2800      	cmp	r0, #0
c0d0720c:	d00b      	beq.n	c0d07226 <USBD_LL_DataOutStage+0x94>
c0d0720e:	59e0      	ldr	r0, [r4, r7]
c0d07210:	6900      	ldr	r0, [r0, #16]
c0d07212:	2800      	cmp	r0, #0
c0d07214:	d007      	beq.n	c0d07226 <USBD_LL_DataOutStage+0x94>
             (pdev->dev_state == USBD_STATE_CONFIGURED))
c0d07216:	7a31      	ldrb	r1, [r6, #8]
          if(usbd_is_valid_intf(pdev, intf) &&  (pdev->interfacesClass[intf].pClass->EP0_RxReady != NULL)&&
c0d07218:	2903      	cmp	r1, #3
c0d0721a:	d104      	bne.n	c0d07226 <USBD_LL_DataOutStage+0x94>
            ((EP0_RxReady_t)PIC(pdev->interfacesClass[intf].pClass->EP0_RxReady))(pdev); 
c0d0721c:	f7fc f884 	bl	c0d03328 <pic>
c0d07220:	4601      	mov	r1, r0
c0d07222:	4620      	mov	r0, r4
c0d07224:	4788      	blx	r1
        for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
c0d07226:	3708      	adds	r7, #8
c0d07228:	1c6d      	adds	r5, r5, #1
c0d0722a:	2d03      	cmp	r5, #3
c0d0722c:	d1e9      	bne.n	c0d07202 <USBD_LL_DataOutStage+0x70>
        USBD_CtlSendStatus(pdev);
c0d0722e:	4620      	mov	r0, r4
c0d07230:	f000 fd79 	bl	c0d07d26 <USBD_CtlSendStatus>
c0d07234:	2000      	movs	r0, #0
      }
    }
  }  
  return USBD_OK;
c0d07236:	b003      	add	sp, #12
c0d07238:	bdf0      	pop	{r4, r5, r6, r7, pc}

c0d0723a <USBD_LL_DataInStage>:
* @param  pdev: device instance
* @param  epnum: endpoint index
* @retval status
*/
USBD_StatusTypeDef USBD_LL_DataInStage(USBD_HandleTypeDef *pdev ,uint8_t epnum, uint8_t *pdata)
{
c0d0723a:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d0723c:	b081      	sub	sp, #4
c0d0723e:	4604      	mov	r4, r0
c0d07240:	4607      	mov	r7, r0
c0d07242:	3794      	adds	r7, #148	; 0x94
c0d07244:	9100      	str	r1, [sp, #0]
  USBD_EndpointTypeDef    *pep;
  UNUSED(pdata);
    
  if(epnum == 0) 
c0d07246:	2900      	cmp	r1, #0
c0d07248:	d01a      	beq.n	c0d07280 <USBD_LL_DataInStage+0x46>
c0d0724a:	463d      	mov	r5, r7
c0d0724c:	2600      	movs	r6, #0
c0d0724e:	27b4      	movs	r7, #180	; 0xb4
    }
  }
  else {
    uint8_t intf;
    for (intf = 0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
      if( usbd_is_valid_intf(pdev, intf) && (pdev->interfacesClass[intf].pClass->DataIn != NULL)&&
c0d07250:	4620      	mov	r0, r4
c0d07252:	4631      	mov	r1, r6
c0d07254:	f000 f89f 	bl	c0d07396 <usbd_is_valid_intf>
c0d07258:	2800      	cmp	r0, #0
c0d0725a:	d00c      	beq.n	c0d07276 <USBD_LL_DataInStage+0x3c>
c0d0725c:	59e0      	ldr	r0, [r4, r7]
c0d0725e:	6940      	ldr	r0, [r0, #20]
c0d07260:	2800      	cmp	r0, #0
c0d07262:	d008      	beq.n	c0d07276 <USBD_LL_DataInStage+0x3c>
         (pdev->dev_state == USBD_STATE_CONFIGURED))
c0d07264:	7a29      	ldrb	r1, [r5, #8]
      if( usbd_is_valid_intf(pdev, intf) && (pdev->interfacesClass[intf].pClass->DataIn != NULL)&&
c0d07266:	2903      	cmp	r1, #3
c0d07268:	d105      	bne.n	c0d07276 <USBD_LL_DataInStage+0x3c>
      {
        ((DataIn_t)PIC(pdev->interfacesClass[intf].pClass->DataIn))(pdev, epnum); 
c0d0726a:	f7fc f85d 	bl	c0d03328 <pic>
c0d0726e:	4602      	mov	r2, r0
c0d07270:	4620      	mov	r0, r4
c0d07272:	9900      	ldr	r1, [sp, #0]
c0d07274:	4790      	blx	r2
    for (intf = 0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
c0d07276:	3708      	adds	r7, #8
c0d07278:	1c76      	adds	r6, r6, #1
c0d0727a:	2e03      	cmp	r6, #3
c0d0727c:	d1e8      	bne.n	c0d07250 <USBD_LL_DataInStage+0x16>
c0d0727e:	e045      	b.n	c0d0730c <USBD_LL_DataInStage+0xd2>
    if ( pdev->ep0_state == USBD_EP0_DATA_IN)
c0d07280:	6838      	ldr	r0, [r7, #0]
c0d07282:	2802      	cmp	r0, #2
c0d07284:	d13c      	bne.n	c0d07300 <USBD_LL_DataInStage+0xc6>
      if(pep->rem_length > pep->maxpacket)
c0d07286:	69e0      	ldr	r0, [r4, #28]
c0d07288:	6a25      	ldr	r5, [r4, #32]
c0d0728a:	42a8      	cmp	r0, r5
c0d0728c:	d909      	bls.n	c0d072a2 <USBD_LL_DataInStage+0x68>
        pep->rem_length -=  pep->maxpacket;
c0d0728e:	1b40      	subs	r0, r0, r5
c0d07290:	61e0      	str	r0, [r4, #28]
        pdev->pData = (uint8_t *)pdev->pData + pep->maxpacket;
c0d07292:	6bf9      	ldr	r1, [r7, #60]	; 0x3c
c0d07294:	1949      	adds	r1, r1, r5
c0d07296:	63f9      	str	r1, [r7, #60]	; 0x3c
        USBD_CtlContinueSendData (pdev, 
c0d07298:	b282      	uxth	r2, r0
c0d0729a:	4620      	mov	r0, r4
c0d0729c:	f000 fd2e 	bl	c0d07cfc <USBD_CtlContinueSendData>
c0d072a0:	e02e      	b.n	c0d07300 <USBD_LL_DataInStage+0xc6>
        if((pep->total_length % pep->maxpacket == 0) &&
c0d072a2:	69a6      	ldr	r6, [r4, #24]
c0d072a4:	4630      	mov	r0, r6
c0d072a6:	4629      	mov	r1, r5
c0d072a8:	f000 ffe6 	bl	c0d08278 <__aeabi_uidivmod>
c0d072ac:	42ae      	cmp	r6, r5
c0d072ae:	d30c      	bcc.n	c0d072ca <USBD_LL_DataInStage+0x90>
c0d072b0:	2900      	cmp	r1, #0
c0d072b2:	d10a      	bne.n	c0d072ca <USBD_LL_DataInStage+0x90>
             (pep->total_length < pdev->ep0_data_len ))
c0d072b4:	6878      	ldr	r0, [r7, #4]
        if((pep->total_length % pep->maxpacket == 0) &&
c0d072b6:	4286      	cmp	r6, r0
c0d072b8:	d207      	bcs.n	c0d072ca <USBD_LL_DataInStage+0x90>
c0d072ba:	2500      	movs	r5, #0
          USBD_CtlContinueSendData(pdev , NULL, 0);
c0d072bc:	4620      	mov	r0, r4
c0d072be:	4629      	mov	r1, r5
c0d072c0:	462a      	mov	r2, r5
c0d072c2:	f000 fd1b 	bl	c0d07cfc <USBD_CtlContinueSendData>
          pdev->ep0_data_len = 0;
c0d072c6:	607d      	str	r5, [r7, #4]
c0d072c8:	e01a      	b.n	c0d07300 <USBD_LL_DataInStage+0xc6>
c0d072ca:	2500      	movs	r5, #0
c0d072cc:	26b4      	movs	r6, #180	; 0xb4
            if(usbd_is_valid_intf(pdev, intf) && (pdev->interfacesClass[intf].pClass->EP0_TxSent != NULL)&&
c0d072ce:	4620      	mov	r0, r4
c0d072d0:	4629      	mov	r1, r5
c0d072d2:	f000 f860 	bl	c0d07396 <usbd_is_valid_intf>
c0d072d6:	2800      	cmp	r0, #0
c0d072d8:	d00b      	beq.n	c0d072f2 <USBD_LL_DataInStage+0xb8>
c0d072da:	59a0      	ldr	r0, [r4, r6]
c0d072dc:	68c0      	ldr	r0, [r0, #12]
c0d072de:	2800      	cmp	r0, #0
c0d072e0:	d007      	beq.n	c0d072f2 <USBD_LL_DataInStage+0xb8>
               (pdev->dev_state == USBD_STATE_CONFIGURED))
c0d072e2:	7a39      	ldrb	r1, [r7, #8]
            if(usbd_is_valid_intf(pdev, intf) && (pdev->interfacesClass[intf].pClass->EP0_TxSent != NULL)&&
c0d072e4:	2903      	cmp	r1, #3
c0d072e6:	d104      	bne.n	c0d072f2 <USBD_LL_DataInStage+0xb8>
              ((EP0_RxReady_t)PIC(pdev->interfacesClass[intf].pClass->EP0_TxSent))(pdev); 
c0d072e8:	f7fc f81e 	bl	c0d03328 <pic>
c0d072ec:	4601      	mov	r1, r0
c0d072ee:	4620      	mov	r0, r4
c0d072f0:	4788      	blx	r1
          for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
c0d072f2:	3608      	adds	r6, #8
c0d072f4:	1c6d      	adds	r5, r5, #1
c0d072f6:	2d03      	cmp	r5, #3
c0d072f8:	d1e9      	bne.n	c0d072ce <USBD_LL_DataInStage+0x94>
          USBD_CtlReceiveStatus(pdev);
c0d072fa:	4620      	mov	r0, r4
c0d072fc:	f000 fd1f 	bl	c0d07d3e <USBD_CtlReceiveStatus>
    if (pdev->dev_test_mode == 1)
c0d07300:	7b38      	ldrb	r0, [r7, #12]
c0d07302:	2801      	cmp	r0, #1
c0d07304:	d102      	bne.n	c0d0730c <USBD_LL_DataInStage+0xd2>
c0d07306:	4639      	mov	r1, r7
c0d07308:	2000      	movs	r0, #0
      pdev->dev_test_mode = 0;
c0d0730a:	7338      	strb	r0, [r7, #12]
c0d0730c:	2000      	movs	r0, #0
      }
    }
  }
  return USBD_OK;
c0d0730e:	b001      	add	sp, #4
c0d07310:	bdf0      	pop	{r4, r5, r6, r7, pc}

c0d07312 <USBD_LL_Reset>:
* @param  pdev: device instance
* @retval status
*/

USBD_StatusTypeDef USBD_LL_Reset(USBD_HandleTypeDef  *pdev)
{
c0d07312:	b570      	push	{r4, r5, r6, lr}
c0d07314:	4604      	mov	r4, r0
c0d07316:	209c      	movs	r0, #156	; 0x9c
c0d07318:	2101      	movs	r1, #1
  pdev->ep_out[0].maxpacket = USB_MAX_EP0_SIZE;
  

  pdev->ep_in[0].maxpacket = USB_MAX_EP0_SIZE;
  /* Upon Reset call user call back */
  pdev->dev_state = USBD_STATE_DEFAULT;
c0d0731a:	5421      	strb	r1, [r4, r0]
c0d0731c:	2040      	movs	r0, #64	; 0x40
  pdev->ep_in[0].maxpacket = USB_MAX_EP0_SIZE;
c0d0731e:	6220      	str	r0, [r4, #32]
  pdev->ep_out[0].maxpacket = USB_MAX_EP0_SIZE;
c0d07320:	6620      	str	r0, [r4, #96]	; 0x60
c0d07322:	2500      	movs	r5, #0
c0d07324:	26b4      	movs	r6, #180	; 0xb4
 
  uint8_t intf;
  for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
    if( usbd_is_valid_intf(pdev, intf))
c0d07326:	4620      	mov	r0, r4
c0d07328:	4629      	mov	r1, r5
c0d0732a:	f000 f834 	bl	c0d07396 <usbd_is_valid_intf>
c0d0732e:	2800      	cmp	r0, #0
c0d07330:	d007      	beq.n	c0d07342 <USBD_LL_Reset+0x30>
    {
      ((DeInit_t)PIC(pdev->interfacesClass[intf].pClass->DeInit))(pdev, pdev->dev_config); 
c0d07332:	59a0      	ldr	r0, [r4, r6]
c0d07334:	6840      	ldr	r0, [r0, #4]
c0d07336:	f7fb fff7 	bl	c0d03328 <pic>
c0d0733a:	4602      	mov	r2, r0
c0d0733c:	7921      	ldrb	r1, [r4, #4]
c0d0733e:	4620      	mov	r0, r4
c0d07340:	4790      	blx	r2
  for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
c0d07342:	3608      	adds	r6, #8
c0d07344:	1c6d      	adds	r5, r5, #1
c0d07346:	2d03      	cmp	r5, #3
c0d07348:	d1ed      	bne.n	c0d07326 <USBD_LL_Reset+0x14>
c0d0734a:	2000      	movs	r0, #0
    }
  }
  
  return USBD_OK;
c0d0734c:	bd70      	pop	{r4, r5, r6, pc}

c0d0734e <USBD_LL_SetSpeed>:
* @param  pdev: device instance
* @retval status
*/
USBD_StatusTypeDef USBD_LL_SetSpeed(USBD_HandleTypeDef  *pdev, USBD_SpeedTypeDef speed)
{
  pdev->dev_speed = speed;
c0d0734e:	7401      	strb	r1, [r0, #16]
c0d07350:	2000      	movs	r0, #0
  return USBD_OK;
c0d07352:	4770      	bx	lr

c0d07354 <USBD_LL_Suspend>:
* @param  pdev: device instance
* @retval status
*/

USBD_StatusTypeDef USBD_LL_Suspend(USBD_HandleTypeDef  *pdev)
{
c0d07354:	2000      	movs	r0, #0
  UNUSED(pdev);
  // Ignored, gently
  //pdev->dev_old_state =  pdev->dev_state;
  //pdev->dev_state  = USBD_STATE_SUSPENDED;
  return USBD_OK;
c0d07356:	4770      	bx	lr

c0d07358 <USBD_LL_Resume>:
* @param  pdev: device instance
* @retval status
*/

USBD_StatusTypeDef USBD_LL_Resume(USBD_HandleTypeDef  *pdev)
{
c0d07358:	2000      	movs	r0, #0
  UNUSED(pdev);
  // Ignored, gently
  //pdev->dev_state = pdev->dev_old_state;  
  return USBD_OK;
c0d0735a:	4770      	bx	lr

c0d0735c <USBD_LL_SOF>:
* @param  pdev: device instance
* @retval status
*/

USBD_StatusTypeDef USBD_LL_SOF(USBD_HandleTypeDef  *pdev)
{
c0d0735c:	b570      	push	{r4, r5, r6, lr}
c0d0735e:	4604      	mov	r4, r0
c0d07360:	209c      	movs	r0, #156	; 0x9c
  if(pdev->dev_state == USBD_STATE_CONFIGURED)
c0d07362:	5c20      	ldrb	r0, [r4, r0]
c0d07364:	2803      	cmp	r0, #3
c0d07366:	d114      	bne.n	c0d07392 <USBD_LL_SOF+0x36>
c0d07368:	2500      	movs	r5, #0
c0d0736a:	26b4      	movs	r6, #180	; 0xb4
  {
    uint8_t intf;
    for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
      if( usbd_is_valid_intf(pdev, intf) && pdev->interfacesClass[intf].pClass->SOF != NULL)
c0d0736c:	4620      	mov	r0, r4
c0d0736e:	4629      	mov	r1, r5
c0d07370:	f000 f811 	bl	c0d07396 <usbd_is_valid_intf>
c0d07374:	2800      	cmp	r0, #0
c0d07376:	d008      	beq.n	c0d0738a <USBD_LL_SOF+0x2e>
c0d07378:	59a0      	ldr	r0, [r4, r6]
c0d0737a:	69c0      	ldr	r0, [r0, #28]
c0d0737c:	2800      	cmp	r0, #0
c0d0737e:	d004      	beq.n	c0d0738a <USBD_LL_SOF+0x2e>
      {
        ((SOF_t)PIC(pdev->interfacesClass[intf].pClass->SOF))(pdev); 
c0d07380:	f7fb ffd2 	bl	c0d03328 <pic>
c0d07384:	4601      	mov	r1, r0
c0d07386:	4620      	mov	r0, r4
c0d07388:	4788      	blx	r1
    for (intf =0; intf < USBD_MAX_NUM_INTERFACES; intf++) {
c0d0738a:	3608      	adds	r6, #8
c0d0738c:	1c6d      	adds	r5, r5, #1
c0d0738e:	2d03      	cmp	r5, #3
c0d07390:	d1ec      	bne.n	c0d0736c <USBD_LL_SOF+0x10>
c0d07392:	2000      	movs	r0, #0
      }
    }
  }
  return USBD_OK;
c0d07394:	bd70      	pop	{r4, r5, r6, pc}

c0d07396 <usbd_is_valid_intf>:
/** @defgroup USBD_REQ_Private_Functions
  * @{
  */ 

unsigned int usbd_is_valid_intf(USBD_HandleTypeDef *pdev , unsigned int intf) {
  return intf < USBD_MAX_NUM_INTERFACES && pdev->interfacesClass[intf].pClass != NULL;
c0d07396:	2902      	cmp	r1, #2
c0d07398:	d806      	bhi.n	c0d073a8 <usbd_is_valid_intf+0x12>
c0d0739a:	00c9      	lsls	r1, r1, #3
c0d0739c:	1840      	adds	r0, r0, r1
c0d0739e:	21b4      	movs	r1, #180	; 0xb4
c0d073a0:	5840      	ldr	r0, [r0, r1]
c0d073a2:	1e41      	subs	r1, r0, #1
c0d073a4:	4188      	sbcs	r0, r1
c0d073a6:	4770      	bx	lr
c0d073a8:	2000      	movs	r0, #0
c0d073aa:	4770      	bx	lr

c0d073ac <USBD_StdDevReq>:
* @param  pdev: device instance
* @param  req: usb request
* @retval status
*/
USBD_StatusTypeDef  USBD_StdDevReq (USBD_HandleTypeDef *pdev , USBD_SetupReqTypedef  *req)
{
c0d073ac:	b580      	push	{r7, lr}
  USBD_StatusTypeDef ret = USBD_OK;  
  
  switch (req->bRequest) 
c0d073ae:	784a      	ldrb	r2, [r1, #1]
c0d073b0:	2a04      	cmp	r2, #4
c0d073b2:	dd08      	ble.n	c0d073c6 <USBD_StdDevReq+0x1a>
c0d073b4:	2a07      	cmp	r2, #7
c0d073b6:	dc0f      	bgt.n	c0d073d8 <USBD_StdDevReq+0x2c>
c0d073b8:	2a05      	cmp	r2, #5
c0d073ba:	d014      	beq.n	c0d073e6 <USBD_StdDevReq+0x3a>
c0d073bc:	2a06      	cmp	r2, #6
c0d073be:	d11b      	bne.n	c0d073f8 <USBD_StdDevReq+0x4c>
  {
  case USB_REQ_GET_DESCRIPTOR: 
    
    USBD_GetDescriptor (pdev, req) ;
c0d073c0:	f000 f821 	bl	c0d07406 <USBD_GetDescriptor>
c0d073c4:	e01d      	b.n	c0d07402 <USBD_StdDevReq+0x56>
  switch (req->bRequest) 
c0d073c6:	2a00      	cmp	r2, #0
c0d073c8:	d010      	beq.n	c0d073ec <USBD_StdDevReq+0x40>
c0d073ca:	2a01      	cmp	r2, #1
c0d073cc:	d017      	beq.n	c0d073fe <USBD_StdDevReq+0x52>
c0d073ce:	2a03      	cmp	r2, #3
c0d073d0:	d112      	bne.n	c0d073f8 <USBD_StdDevReq+0x4c>
    USBD_GetStatus (pdev , req);
    break;
    
    
  case USB_REQ_SET_FEATURE:   
    USBD_SetFeature (pdev , req);    
c0d073d2:	f000 f92a 	bl	c0d0762a <USBD_SetFeature>
c0d073d6:	e014      	b.n	c0d07402 <USBD_StdDevReq+0x56>
  switch (req->bRequest) 
c0d073d8:	2a08      	cmp	r2, #8
c0d073da:	d00a      	beq.n	c0d073f2 <USBD_StdDevReq+0x46>
c0d073dc:	2a09      	cmp	r2, #9
c0d073de:	d10b      	bne.n	c0d073f8 <USBD_StdDevReq+0x4c>
    USBD_SetConfig (pdev , req);
c0d073e0:	f000 f8b1 	bl	c0d07546 <USBD_SetConfig>
c0d073e4:	e00d      	b.n	c0d07402 <USBD_StdDevReq+0x56>
    USBD_SetAddress(pdev, req);
c0d073e6:	f000 f88b 	bl	c0d07500 <USBD_SetAddress>
c0d073ea:	e00a      	b.n	c0d07402 <USBD_StdDevReq+0x56>
    USBD_GetStatus (pdev , req);
c0d073ec:	f000 f8f9 	bl	c0d075e2 <USBD_GetStatus>
c0d073f0:	e007      	b.n	c0d07402 <USBD_StdDevReq+0x56>
    USBD_GetConfig (pdev , req);
c0d073f2:	f000 f8df 	bl	c0d075b4 <USBD_GetConfig>
c0d073f6:	e004      	b.n	c0d07402 <USBD_StdDevReq+0x56>
  case USB_REQ_CLEAR_FEATURE:                                   
    USBD_ClrFeature (pdev , req);
    break;
    
  default:  
    USBD_CtlError(pdev , req);
c0d073f8:	f000 fbce 	bl	c0d07b98 <USBD_CtlError>
c0d073fc:	e001      	b.n	c0d07402 <USBD_StdDevReq+0x56>
    USBD_ClrFeature (pdev , req);
c0d073fe:	f000 f931 	bl	c0d07664 <USBD_ClrFeature>
c0d07402:	2000      	movs	r0, #0
    break;
  }
  
  return ret;
c0d07404:	bd80      	pop	{r7, pc}

c0d07406 <USBD_GetDescriptor>:
* @param  req: usb request
* @retval status
*/
void USBD_GetDescriptor(USBD_HandleTypeDef *pdev , 
                               USBD_SetupReqTypedef *req)
{
c0d07406:	b5b0      	push	{r4, r5, r7, lr}
c0d07408:	b082      	sub	sp, #8
c0d0740a:	460d      	mov	r5, r1
c0d0740c:	4604      	mov	r4, r0
c0d0740e:	a801      	add	r0, sp, #4
c0d07410:	2100      	movs	r1, #0
  uint16_t len = 0;
c0d07412:	8001      	strh	r1, [r0, #0]
c0d07414:	4620      	mov	r0, r4
c0d07416:	30b0      	adds	r0, #176	; 0xb0
  uint8_t *pbuf = NULL;
  
    
  switch (req->wValue >> 8)
c0d07418:	886b      	ldrh	r3, [r5, #2]
c0d0741a:	0a1a      	lsrs	r2, r3, #8
c0d0741c:	2a05      	cmp	r2, #5
c0d0741e:	dc11      	bgt.n	c0d07444 <USBD_GetDescriptor+0x3e>
c0d07420:	2a01      	cmp	r2, #1
c0d07422:	d01a      	beq.n	c0d0745a <USBD_GetDescriptor+0x54>
c0d07424:	2a02      	cmp	r2, #2
c0d07426:	d021      	beq.n	c0d0746c <USBD_GetDescriptor+0x66>
c0d07428:	2a03      	cmp	r2, #3
c0d0742a:	d132      	bne.n	c0d07492 <USBD_GetDescriptor+0x8c>
      }
    }
    break;
    
  case USB_DESC_TYPE_STRING:
    switch ((uint8_t)(req->wValue))
c0d0742c:	b2d9      	uxtb	r1, r3
c0d0742e:	2902      	cmp	r1, #2
c0d07430:	dc34      	bgt.n	c0d0749c <USBD_GetDescriptor+0x96>
c0d07432:	2900      	cmp	r1, #0
c0d07434:	d058      	beq.n	c0d074e8 <USBD_GetDescriptor+0xe2>
c0d07436:	2901      	cmp	r1, #1
c0d07438:	d05c      	beq.n	c0d074f4 <USBD_GetDescriptor+0xee>
c0d0743a:	2902      	cmp	r1, #2
c0d0743c:	d129      	bne.n	c0d07492 <USBD_GetDescriptor+0x8c>
    case USBD_IDX_MFC_STR:
      pbuf = ((GetManufacturerStrDescriptor_t)PIC(pdev->pDesc->GetManufacturerStrDescriptor))(pdev->dev_speed, &len);
      break;
      
    case USBD_IDX_PRODUCT_STR:
      pbuf = ((GetProductStrDescriptor_t)PIC(pdev->pDesc->GetProductStrDescriptor))(pdev->dev_speed, &len);
c0d0743e:	6800      	ldr	r0, [r0, #0]
c0d07440:	68c0      	ldr	r0, [r0, #12]
c0d07442:	e00c      	b.n	c0d0745e <USBD_GetDescriptor+0x58>
  switch (req->wValue >> 8)
c0d07444:	2a06      	cmp	r2, #6
c0d07446:	d019      	beq.n	c0d0747c <USBD_GetDescriptor+0x76>
c0d07448:	2a07      	cmp	r2, #7
c0d0744a:	d01f      	beq.n	c0d0748c <USBD_GetDescriptor+0x86>
c0d0744c:	2a0f      	cmp	r2, #15
c0d0744e:	d120      	bne.n	c0d07492 <USBD_GetDescriptor+0x8c>
    if(pdev->pDesc->GetBOSDescriptor != NULL) {
c0d07450:	6800      	ldr	r0, [r0, #0]
c0d07452:	69c0      	ldr	r0, [r0, #28]
c0d07454:	2800      	cmp	r0, #0
c0d07456:	d102      	bne.n	c0d0745e <USBD_GetDescriptor+0x58>
c0d07458:	e01b      	b.n	c0d07492 <USBD_GetDescriptor+0x8c>
    pbuf = ((GetDeviceDescriptor_t)PIC(pdev->pDesc->GetDeviceDescriptor))(pdev->dev_speed, &len);
c0d0745a:	6800      	ldr	r0, [r0, #0]
c0d0745c:	6800      	ldr	r0, [r0, #0]
c0d0745e:	f7fb ff63 	bl	c0d03328 <pic>
c0d07462:	4602      	mov	r2, r0
c0d07464:	7c20      	ldrb	r0, [r4, #16]
c0d07466:	a901      	add	r1, sp, #4
c0d07468:	4790      	blx	r2
c0d0746a:	e02b      	b.n	c0d074c4 <USBD_GetDescriptor+0xbe>
    if(pdev->interfacesClass[0].pClass != NULL) {
c0d0746c:	6840      	ldr	r0, [r0, #4]
c0d0746e:	2800      	cmp	r0, #0
c0d07470:	d029      	beq.n	c0d074c6 <USBD_GetDescriptor+0xc0>
      if(pdev->dev_speed == USBD_SPEED_HIGH )   
c0d07472:	7c21      	ldrb	r1, [r4, #16]
c0d07474:	2900      	cmp	r1, #0
c0d07476:	d01f      	beq.n	c0d074b8 <USBD_GetDescriptor+0xb2>
        pbuf   = (uint8_t *)((GetFSConfigDescriptor_t)PIC(pdev->interfacesClass[0].pClass->GetFSConfigDescriptor))(&len);
c0d07478:	6ac0      	ldr	r0, [r0, #44]	; 0x2c
c0d0747a:	e01e      	b.n	c0d074ba <USBD_GetDescriptor+0xb4>
#endif   
    }
    break;
  case USB_DESC_TYPE_DEVICE_QUALIFIER:                   

    if(pdev->dev_speed == USBD_SPEED_HIGH && pdev->interfacesClass[0].pClass != NULL )   
c0d0747c:	7c21      	ldrb	r1, [r4, #16]
c0d0747e:	2900      	cmp	r1, #0
c0d07480:	d107      	bne.n	c0d07492 <USBD_GetDescriptor+0x8c>
c0d07482:	6840      	ldr	r0, [r0, #4]
c0d07484:	2800      	cmp	r0, #0
c0d07486:	d004      	beq.n	c0d07492 <USBD_GetDescriptor+0x8c>
    {
      pbuf   = (uint8_t *)((GetDeviceQualifierDescriptor_t)PIC(pdev->interfacesClass[0].pClass->GetDeviceQualifierDescriptor))(&len);
c0d07488:	6b40      	ldr	r0, [r0, #52]	; 0x34
c0d0748a:	e016      	b.n	c0d074ba <USBD_GetDescriptor+0xb4>
    {
      goto default_error;
    } 

  case USB_DESC_TYPE_OTHER_SPEED_CONFIGURATION:
    if(pdev->dev_speed == USBD_SPEED_HIGH && pdev->interfacesClass[0].pClass != NULL)   
c0d0748c:	7c21      	ldrb	r1, [r4, #16]
c0d0748e:	2900      	cmp	r1, #0
c0d07490:	d00d      	beq.n	c0d074ae <USBD_GetDescriptor+0xa8>
      goto default_error;
    }

  default: 
  default_error:
     USBD_CtlError(pdev , req);
c0d07492:	4620      	mov	r0, r4
c0d07494:	4629      	mov	r1, r5
c0d07496:	f000 fb7f 	bl	c0d07b98 <USBD_CtlError>
c0d0749a:	e023      	b.n	c0d074e4 <USBD_GetDescriptor+0xde>
    switch ((uint8_t)(req->wValue))
c0d0749c:	2903      	cmp	r1, #3
c0d0749e:	d026      	beq.n	c0d074ee <USBD_GetDescriptor+0xe8>
c0d074a0:	2904      	cmp	r1, #4
c0d074a2:	d02a      	beq.n	c0d074fa <USBD_GetDescriptor+0xf4>
c0d074a4:	2905      	cmp	r1, #5
c0d074a6:	d1f4      	bne.n	c0d07492 <USBD_GetDescriptor+0x8c>
      pbuf = ((GetInterfaceStrDescriptor_t)PIC(pdev->pDesc->GetInterfaceStrDescriptor))(pdev->dev_speed, &len);
c0d074a8:	6800      	ldr	r0, [r0, #0]
c0d074aa:	6980      	ldr	r0, [r0, #24]
c0d074ac:	e7d7      	b.n	c0d0745e <USBD_GetDescriptor+0x58>
    if(pdev->dev_speed == USBD_SPEED_HIGH && pdev->interfacesClass[0].pClass != NULL)   
c0d074ae:	6840      	ldr	r0, [r0, #4]
c0d074b0:	2800      	cmp	r0, #0
c0d074b2:	d0ee      	beq.n	c0d07492 <USBD_GetDescriptor+0x8c>
      pbuf   = (uint8_t *)((GetOtherSpeedConfigDescriptor_t)PIC(pdev->interfacesClass[0].pClass->GetOtherSpeedConfigDescriptor))(&len);
c0d074b4:	6b00      	ldr	r0, [r0, #48]	; 0x30
c0d074b6:	e000      	b.n	c0d074ba <USBD_GetDescriptor+0xb4>
        pbuf   = (uint8_t *)((GetHSConfigDescriptor_t)PIC(pdev->interfacesClass[0].pClass->GetHSConfigDescriptor))(&len);
c0d074b8:	6a80      	ldr	r0, [r0, #40]	; 0x28
c0d074ba:	f7fb ff35 	bl	c0d03328 <pic>
c0d074be:	4601      	mov	r1, r0
c0d074c0:	a801      	add	r0, sp, #4
c0d074c2:	4788      	blx	r1
c0d074c4:	4601      	mov	r1, r0
c0d074c6:	a801      	add	r0, sp, #4
    return;
  }
  
  if((len != 0)&& (req->wLength != 0))
c0d074c8:	8802      	ldrh	r2, [r0, #0]
c0d074ca:	2a00      	cmp	r2, #0
c0d074cc:	d00a      	beq.n	c0d074e4 <USBD_GetDescriptor+0xde>
c0d074ce:	88e8      	ldrh	r0, [r5, #6]
c0d074d0:	2800      	cmp	r0, #0
c0d074d2:	d007      	beq.n	c0d074e4 <USBD_GetDescriptor+0xde>
  {
    
    len = MIN(len , req->wLength);
c0d074d4:	4282      	cmp	r2, r0
c0d074d6:	d300      	bcc.n	c0d074da <USBD_GetDescriptor+0xd4>
c0d074d8:	4602      	mov	r2, r0
c0d074da:	a801      	add	r0, sp, #4
c0d074dc:	8002      	strh	r2, [r0, #0]
    
    // prepare abort if host does not read the whole data
    //USBD_CtlReceiveStatus(pdev);

    // start transfer
    USBD_CtlSendData (pdev, 
c0d074de:	4620      	mov	r0, r4
c0d074e0:	f000 fbf6 	bl	c0d07cd0 <USBD_CtlSendData>
                      pbuf,
                      len);
  }
  
}
c0d074e4:	b002      	add	sp, #8
c0d074e6:	bdb0      	pop	{r4, r5, r7, pc}
     pbuf = ((GetLangIDStrDescriptor_t)PIC(pdev->pDesc->GetLangIDStrDescriptor))(pdev->dev_speed, &len);        
c0d074e8:	6800      	ldr	r0, [r0, #0]
c0d074ea:	6840      	ldr	r0, [r0, #4]
c0d074ec:	e7b7      	b.n	c0d0745e <USBD_GetDescriptor+0x58>
      pbuf = ((GetSerialStrDescriptor_t)PIC(pdev->pDesc->GetSerialStrDescriptor))(pdev->dev_speed, &len);
c0d074ee:	6800      	ldr	r0, [r0, #0]
c0d074f0:	6900      	ldr	r0, [r0, #16]
c0d074f2:	e7b4      	b.n	c0d0745e <USBD_GetDescriptor+0x58>
      pbuf = ((GetManufacturerStrDescriptor_t)PIC(pdev->pDesc->GetManufacturerStrDescriptor))(pdev->dev_speed, &len);
c0d074f4:	6800      	ldr	r0, [r0, #0]
c0d074f6:	6880      	ldr	r0, [r0, #8]
c0d074f8:	e7b1      	b.n	c0d0745e <USBD_GetDescriptor+0x58>
      pbuf = ((GetConfigurationStrDescriptor_t)PIC(pdev->pDesc->GetConfigurationStrDescriptor))(pdev->dev_speed, &len);
c0d074fa:	6800      	ldr	r0, [r0, #0]
c0d074fc:	6940      	ldr	r0, [r0, #20]
c0d074fe:	e7ae      	b.n	c0d0745e <USBD_GetDescriptor+0x58>

c0d07500 <USBD_SetAddress>:
* @param  req: usb request
* @retval status
*/
void USBD_SetAddress(USBD_HandleTypeDef *pdev , 
                            USBD_SetupReqTypedef *req)
{
c0d07500:	b570      	push	{r4, r5, r6, lr}
c0d07502:	4604      	mov	r4, r0
  uint8_t  dev_addr; 
  
  if ((req->wIndex == 0) && (req->wLength == 0)) 
c0d07504:	8888      	ldrh	r0, [r1, #4]
c0d07506:	2800      	cmp	r0, #0
c0d07508:	d107      	bne.n	c0d0751a <USBD_SetAddress+0x1a>
c0d0750a:	88c8      	ldrh	r0, [r1, #6]
c0d0750c:	2800      	cmp	r0, #0
c0d0750e:	d104      	bne.n	c0d0751a <USBD_SetAddress+0x1a>
c0d07510:	4626      	mov	r6, r4
c0d07512:	369c      	adds	r6, #156	; 0x9c
  {
    dev_addr = (uint8_t)(req->wValue) & 0x7F;     
    
    if (pdev->dev_state == USBD_STATE_CONFIGURED) 
c0d07514:	7830      	ldrb	r0, [r6, #0]
c0d07516:	2803      	cmp	r0, #3
c0d07518:	d103      	bne.n	c0d07522 <USBD_SetAddress+0x22>
c0d0751a:	4620      	mov	r0, r4
c0d0751c:	f000 fb3c 	bl	c0d07b98 <USBD_CtlError>
  } 
  else 
  {
     USBD_CtlError(pdev , req);                        
  } 
}
c0d07520:	bd70      	pop	{r4, r5, r6, pc}
c0d07522:	7888      	ldrb	r0, [r1, #2]
c0d07524:	257f      	movs	r5, #127	; 0x7f
c0d07526:	4005      	ands	r5, r0
      pdev->dev_address = dev_addr;
c0d07528:	70b5      	strb	r5, [r6, #2]
      USBD_LL_SetUSBAddress(pdev, dev_addr);               
c0d0752a:	4620      	mov	r0, r4
c0d0752c:	4629      	mov	r1, r5
c0d0752e:	f7ff fd47 	bl	c0d06fc0 <USBD_LL_SetUSBAddress>
      USBD_CtlSendStatus(pdev);                         
c0d07532:	4620      	mov	r0, r4
c0d07534:	f000 fbf7 	bl	c0d07d26 <USBD_CtlSendStatus>
      if (dev_addr != 0) 
c0d07538:	2d00      	cmp	r5, #0
c0d0753a:	d001      	beq.n	c0d07540 <USBD_SetAddress+0x40>
c0d0753c:	2002      	movs	r0, #2
c0d0753e:	e000      	b.n	c0d07542 <USBD_SetAddress+0x42>
c0d07540:	2001      	movs	r0, #1
c0d07542:	7030      	strb	r0, [r6, #0]
}
c0d07544:	bd70      	pop	{r4, r5, r6, pc}

c0d07546 <USBD_SetConfig>:
* @param  req: usb request
* @retval status
*/
void USBD_SetConfig(USBD_HandleTypeDef *pdev , 
                           USBD_SetupReqTypedef *req)
{
c0d07546:	b570      	push	{r4, r5, r6, lr}
c0d07548:	460d      	mov	r5, r1
c0d0754a:	4604      	mov	r4, r0
  
  uint8_t  cfgidx;
  
  cfgidx = (uint8_t)(req->wValue);                 
c0d0754c:	788e      	ldrb	r6, [r1, #2]
  
  if (cfgidx > USBD_MAX_NUM_CONFIGURATION ) 
c0d0754e:	2e02      	cmp	r6, #2
c0d07550:	d21c      	bcs.n	c0d0758c <USBD_SetConfig+0x46>
c0d07552:	209c      	movs	r0, #156	; 0x9c
  {            
     USBD_CtlError(pdev , req);                              
  } 
  else 
  {
    switch (pdev->dev_state) 
c0d07554:	5c21      	ldrb	r1, [r4, r0]
c0d07556:	4620      	mov	r0, r4
c0d07558:	309c      	adds	r0, #156	; 0x9c
c0d0755a:	2903      	cmp	r1, #3
c0d0755c:	d006      	beq.n	c0d0756c <USBD_SetConfig+0x26>
c0d0755e:	2902      	cmp	r1, #2
c0d07560:	d114      	bne.n	c0d0758c <USBD_SetConfig+0x46>
    {
    case USBD_STATE_ADDRESSED:
      if (cfgidx) 
c0d07562:	2e00      	cmp	r6, #0
c0d07564:	d022      	beq.n	c0d075ac <USBD_SetConfig+0x66>
c0d07566:	2103      	movs	r1, #3
      {                                                                               
        pdev->dev_config = cfgidx;
        pdev->dev_state = USBD_STATE_CONFIGURED;
c0d07568:	7001      	strb	r1, [r0, #0]
c0d0756a:	e008      	b.n	c0d0757e <USBD_SetConfig+0x38>
      }
      USBD_CtlSendStatus(pdev);
      break;
      
    case USBD_STATE_CONFIGURED:
      if (cfgidx == 0) 
c0d0756c:	2e00      	cmp	r6, #0
c0d0756e:	d012      	beq.n	c0d07596 <USBD_SetConfig+0x50>
        pdev->dev_state = USBD_STATE_ADDRESSED;
        pdev->dev_config = cfgidx;          
        USBD_ClrClassConfig(pdev , cfgidx);
        USBD_CtlSendStatus(pdev);
      } 
      else  if (cfgidx != pdev->dev_config) 
c0d07570:	6860      	ldr	r0, [r4, #4]
c0d07572:	42b0      	cmp	r0, r6
c0d07574:	d01a      	beq.n	c0d075ac <USBD_SetConfig+0x66>
      {
        /* Clear old configuration */
        USBD_ClrClassConfig(pdev , pdev->dev_config);
c0d07576:	b2c1      	uxtb	r1, r0
c0d07578:	4620      	mov	r0, r4
c0d0757a:	f7ff fdc1 	bl	c0d07100 <USBD_ClrClassConfig>
c0d0757e:	6066      	str	r6, [r4, #4]
c0d07580:	4620      	mov	r0, r4
c0d07582:	4631      	mov	r1, r6
c0d07584:	f7ff fda1 	bl	c0d070ca <USBD_SetClassConfig>
c0d07588:	2802      	cmp	r0, #2
c0d0758a:	d10f      	bne.n	c0d075ac <USBD_SetConfig+0x66>
c0d0758c:	4620      	mov	r0, r4
c0d0758e:	4629      	mov	r1, r5
c0d07590:	f000 fb02 	bl	c0d07b98 <USBD_CtlError>
    default:          
       USBD_CtlError(pdev , req);                     
      break;
    }
  }
}
c0d07594:	bd70      	pop	{r4, r5, r6, pc}
c0d07596:	2100      	movs	r1, #0
        pdev->dev_config = cfgidx;          
c0d07598:	6061      	str	r1, [r4, #4]
c0d0759a:	2102      	movs	r1, #2
        pdev->dev_state = USBD_STATE_ADDRESSED;
c0d0759c:	7001      	strb	r1, [r0, #0]
        USBD_ClrClassConfig(pdev , cfgidx);
c0d0759e:	4620      	mov	r0, r4
c0d075a0:	4631      	mov	r1, r6
c0d075a2:	f7ff fdad 	bl	c0d07100 <USBD_ClrClassConfig>
        USBD_CtlSendStatus(pdev);
c0d075a6:	4620      	mov	r0, r4
c0d075a8:	f000 fbbd 	bl	c0d07d26 <USBD_CtlSendStatus>
c0d075ac:	4620      	mov	r0, r4
c0d075ae:	f000 fbba 	bl	c0d07d26 <USBD_CtlSendStatus>
}
c0d075b2:	bd70      	pop	{r4, r5, r6, pc}

c0d075b4 <USBD_GetConfig>:
* @param  req: usb request
* @retval status
*/
void USBD_GetConfig(USBD_HandleTypeDef *pdev , 
                           USBD_SetupReqTypedef *req)
{
c0d075b4:	b580      	push	{r7, lr}

  if (req->wLength != 1) 
c0d075b6:	88ca      	ldrh	r2, [r1, #6]
c0d075b8:	2a01      	cmp	r2, #1
c0d075ba:	d10a      	bne.n	c0d075d2 <USBD_GetConfig+0x1e>
c0d075bc:	229c      	movs	r2, #156	; 0x9c
  {                   
     USBD_CtlError(pdev , req);
  }
  else 
  {
    switch (pdev->dev_state )  
c0d075be:	5c82      	ldrb	r2, [r0, r2]
c0d075c0:	2a03      	cmp	r2, #3
c0d075c2:	d009      	beq.n	c0d075d8 <USBD_GetConfig+0x24>
c0d075c4:	2a02      	cmp	r2, #2
c0d075c6:	d104      	bne.n	c0d075d2 <USBD_GetConfig+0x1e>
c0d075c8:	2100      	movs	r1, #0
    {
    case USBD_STATE_ADDRESSED:                     
      pdev->dev_default_config = 0;
c0d075ca:	6081      	str	r1, [r0, #8]
c0d075cc:	4601      	mov	r1, r0
c0d075ce:	3108      	adds	r1, #8
c0d075d0:	e003      	b.n	c0d075da <USBD_GetConfig+0x26>
c0d075d2:	f000 fae1 	bl	c0d07b98 <USBD_CtlError>
    default:
       USBD_CtlError(pdev , req);
      break;
    }
  }
}
c0d075d6:	bd80      	pop	{r7, pc}
                        (uint8_t *)&pdev->dev_config,
c0d075d8:	1d01      	adds	r1, r0, #4
c0d075da:	2201      	movs	r2, #1
c0d075dc:	f000 fb78 	bl	c0d07cd0 <USBD_CtlSendData>
}
c0d075e0:	bd80      	pop	{r7, pc}

c0d075e2 <USBD_GetStatus>:
* @param  req: usb request
* @retval status
*/
void USBD_GetStatus(USBD_HandleTypeDef *pdev , 
                           USBD_SetupReqTypedef *req)
{
c0d075e2:	b5b0      	push	{r4, r5, r7, lr}
c0d075e4:	4604      	mov	r4, r0
c0d075e6:	209c      	movs	r0, #156	; 0x9c
  
    
  switch (pdev->dev_state) 
c0d075e8:	5c20      	ldrb	r0, [r4, r0]
c0d075ea:	22fe      	movs	r2, #254	; 0xfe
c0d075ec:	4002      	ands	r2, r0
c0d075ee:	2a02      	cmp	r2, #2
c0d075f0:	d10f      	bne.n	c0d07612 <USBD_GetStatus+0x30>
c0d075f2:	4620      	mov	r0, r4
c0d075f4:	309c      	adds	r0, #156	; 0x9c
c0d075f6:	2101      	movs	r1, #1
  {
  case USBD_STATE_ADDRESSED:
  case USBD_STATE_CONFIGURED:
    
#if ( USBD_SELF_POWERED == 1)
    pdev->dev_config_status = USB_CONFIG_SELF_POWERED;                                  
c0d075f8:	60e1      	str	r1, [r4, #12]
c0d075fa:	4625      	mov	r5, r4
c0d075fc:	350c      	adds	r5, #12
#else
    pdev->dev_config_status = 0;                                   
#endif
                      
    if (pdev->dev_remote_wakeup) USBD_CtlReceiveStatus(pdev);
c0d075fe:	6880      	ldr	r0, [r0, #8]
c0d07600:	2800      	cmp	r0, #0
c0d07602:	d00a      	beq.n	c0d0761a <USBD_GetStatus+0x38>
c0d07604:	4620      	mov	r0, r4
c0d07606:	f000 fb9a 	bl	c0d07d3e <USBD_CtlReceiveStatus>
    {
       pdev->dev_config_status |= USB_CONFIG_REMOTE_WAKEUP;                                
c0d0760a:	68e1      	ldr	r1, [r4, #12]
c0d0760c:	2002      	movs	r0, #2
    if (pdev->dev_remote_wakeup) USBD_CtlReceiveStatus(pdev);
c0d0760e:	4308      	orrs	r0, r1
c0d07610:	e004      	b.n	c0d0761c <USBD_GetStatus+0x3a>
                      (uint8_t *)& pdev->dev_config_status,
                      2);
    break;
    
  default :
    USBD_CtlError(pdev , req);                        
c0d07612:	4620      	mov	r0, r4
c0d07614:	f000 fac0 	bl	c0d07b98 <USBD_CtlError>
    break;
  }
}
c0d07618:	bdb0      	pop	{r4, r5, r7, pc}
c0d0761a:	2003      	movs	r0, #3
       pdev->dev_config_status |= USB_CONFIG_REMOTE_WAKEUP;                                
c0d0761c:	60e0      	str	r0, [r4, #12]
c0d0761e:	2202      	movs	r2, #2
    USBD_CtlSendData (pdev, 
c0d07620:	4620      	mov	r0, r4
c0d07622:	4629      	mov	r1, r5
c0d07624:	f000 fb54 	bl	c0d07cd0 <USBD_CtlSendData>
}
c0d07628:	bdb0      	pop	{r4, r5, r7, pc}

c0d0762a <USBD_SetFeature>:
* @param  req: usb request
* @retval status
*/
void USBD_SetFeature(USBD_HandleTypeDef *pdev , 
                            USBD_SetupReqTypedef *req)
{
c0d0762a:	b5b0      	push	{r4, r5, r7, lr}
c0d0762c:	4604      	mov	r4, r0

  if (req->wValue == USB_FEATURE_REMOTE_WAKEUP)
c0d0762e:	8848      	ldrh	r0, [r1, #2]
c0d07630:	2801      	cmp	r0, #1
c0d07632:	d116      	bne.n	c0d07662 <USBD_SetFeature+0x38>
c0d07634:	460d      	mov	r5, r1
c0d07636:	20a4      	movs	r0, #164	; 0xa4
c0d07638:	2101      	movs	r1, #1
  {
    pdev->dev_remote_wakeup = 1;  
c0d0763a:	5021      	str	r1, [r4, r0]
    if(usbd_is_valid_intf(pdev, LOBYTE(req->wIndex))) {
c0d0763c:	7928      	ldrb	r0, [r5, #4]
  return intf < USBD_MAX_NUM_INTERFACES && pdev->interfacesClass[intf].pClass != NULL;
c0d0763e:	2802      	cmp	r0, #2
c0d07640:	d80c      	bhi.n	c0d0765c <USBD_SetFeature+0x32>
c0d07642:	00c0      	lsls	r0, r0, #3
c0d07644:	1820      	adds	r0, r4, r0
c0d07646:	21b4      	movs	r1, #180	; 0xb4
c0d07648:	5840      	ldr	r0, [r0, r1]
    if(usbd_is_valid_intf(pdev, LOBYTE(req->wIndex))) {
c0d0764a:	2800      	cmp	r0, #0
c0d0764c:	d006      	beq.n	c0d0765c <USBD_SetFeature+0x32>
      ((Setup_t)PIC(pdev->interfacesClass[LOBYTE(req->wIndex)].pClass->Setup)) (pdev, req);   
c0d0764e:	6880      	ldr	r0, [r0, #8]
c0d07650:	f7fb fe6a 	bl	c0d03328 <pic>
c0d07654:	4602      	mov	r2, r0
c0d07656:	4620      	mov	r0, r4
c0d07658:	4629      	mov	r1, r5
c0d0765a:	4790      	blx	r2
    }
    USBD_CtlSendStatus(pdev);
c0d0765c:	4620      	mov	r0, r4
c0d0765e:	f000 fb62 	bl	c0d07d26 <USBD_CtlSendStatus>
  }

}
c0d07662:	bdb0      	pop	{r4, r5, r7, pc}

c0d07664 <USBD_ClrFeature>:
* @param  req: usb request
* @retval status
*/
void USBD_ClrFeature(USBD_HandleTypeDef *pdev , 
                            USBD_SetupReqTypedef *req)
{
c0d07664:	b5b0      	push	{r4, r5, r7, lr}
c0d07666:	460d      	mov	r5, r1
c0d07668:	4604      	mov	r4, r0
c0d0766a:	209c      	movs	r0, #156	; 0x9c
  switch (pdev->dev_state)
c0d0766c:	5c20      	ldrb	r0, [r4, r0]
c0d0766e:	21fe      	movs	r1, #254	; 0xfe
c0d07670:	4001      	ands	r1, r0
c0d07672:	2902      	cmp	r1, #2
c0d07674:	d11a      	bne.n	c0d076ac <USBD_ClrFeature+0x48>
  {
  case USBD_STATE_ADDRESSED:
  case USBD_STATE_CONFIGURED:
    if (req->wValue == USB_FEATURE_REMOTE_WAKEUP) 
c0d07676:	8868      	ldrh	r0, [r5, #2]
c0d07678:	2801      	cmp	r0, #1
c0d0767a:	d11b      	bne.n	c0d076b4 <USBD_ClrFeature+0x50>
c0d0767c:	4620      	mov	r0, r4
c0d0767e:	309c      	adds	r0, #156	; 0x9c
c0d07680:	2100      	movs	r1, #0
    {
      pdev->dev_remote_wakeup = 0; 
c0d07682:	6081      	str	r1, [r0, #8]
      if(usbd_is_valid_intf(pdev, LOBYTE(req->wIndex))) {
c0d07684:	7928      	ldrb	r0, [r5, #4]
  return intf < USBD_MAX_NUM_INTERFACES && pdev->interfacesClass[intf].pClass != NULL;
c0d07686:	2802      	cmp	r0, #2
c0d07688:	d80c      	bhi.n	c0d076a4 <USBD_ClrFeature+0x40>
c0d0768a:	00c0      	lsls	r0, r0, #3
c0d0768c:	1820      	adds	r0, r4, r0
c0d0768e:	21b4      	movs	r1, #180	; 0xb4
c0d07690:	5840      	ldr	r0, [r0, r1]
      if(usbd_is_valid_intf(pdev, LOBYTE(req->wIndex))) {
c0d07692:	2800      	cmp	r0, #0
c0d07694:	d006      	beq.n	c0d076a4 <USBD_ClrFeature+0x40>
        ((Setup_t)PIC(pdev->interfacesClass[LOBYTE(req->wIndex)].pClass->Setup)) (pdev, req);   
c0d07696:	6880      	ldr	r0, [r0, #8]
c0d07698:	f7fb fe46 	bl	c0d03328 <pic>
c0d0769c:	4602      	mov	r2, r0
c0d0769e:	4620      	mov	r0, r4
c0d076a0:	4629      	mov	r1, r5
c0d076a2:	4790      	blx	r2
      }
      USBD_CtlSendStatus(pdev);
c0d076a4:	4620      	mov	r0, r4
c0d076a6:	f000 fb3e 	bl	c0d07d26 <USBD_CtlSendStatus>
    
  default :
     USBD_CtlError(pdev , req);
    break;
  }
}
c0d076aa:	bdb0      	pop	{r4, r5, r7, pc}
     USBD_CtlError(pdev , req);
c0d076ac:	4620      	mov	r0, r4
c0d076ae:	4629      	mov	r1, r5
c0d076b0:	f000 fa72 	bl	c0d07b98 <USBD_CtlError>
}
c0d076b4:	bdb0      	pop	{r4, r5, r7, pc}

c0d076b6 <USBD_StdItfReq>:
{
c0d076b6:	b5b0      	push	{r4, r5, r7, lr}
c0d076b8:	460d      	mov	r5, r1
c0d076ba:	4604      	mov	r4, r0
c0d076bc:	209c      	movs	r0, #156	; 0x9c
  switch (pdev->dev_state) 
c0d076be:	5c20      	ldrb	r0, [r4, r0]
c0d076c0:	2803      	cmp	r0, #3
c0d076c2:	d116      	bne.n	c0d076f2 <USBD_StdItfReq+0x3c>
    if (usbd_is_valid_intf(pdev, LOBYTE(req->wIndex))) 
c0d076c4:	7928      	ldrb	r0, [r5, #4]
  return intf < USBD_MAX_NUM_INTERFACES && pdev->interfacesClass[intf].pClass != NULL;
c0d076c6:	2802      	cmp	r0, #2
c0d076c8:	d813      	bhi.n	c0d076f2 <USBD_StdItfReq+0x3c>
c0d076ca:	00c0      	lsls	r0, r0, #3
c0d076cc:	1820      	adds	r0, r4, r0
c0d076ce:	21b4      	movs	r1, #180	; 0xb4
c0d076d0:	5840      	ldr	r0, [r0, r1]
    if (usbd_is_valid_intf(pdev, LOBYTE(req->wIndex))) 
c0d076d2:	2800      	cmp	r0, #0
c0d076d4:	d00d      	beq.n	c0d076f2 <USBD_StdItfReq+0x3c>
      ((Setup_t)PIC(pdev->interfacesClass[LOBYTE(req->wIndex)].pClass->Setup)) (pdev, req);
c0d076d6:	6880      	ldr	r0, [r0, #8]
c0d076d8:	f7fb fe26 	bl	c0d03328 <pic>
c0d076dc:	4602      	mov	r2, r0
c0d076de:	4620      	mov	r0, r4
c0d076e0:	4629      	mov	r1, r5
c0d076e2:	4790      	blx	r2
      if((req->wLength == 0)&& (ret == USBD_OK))
c0d076e4:	88e8      	ldrh	r0, [r5, #6]
c0d076e6:	2800      	cmp	r0, #0
c0d076e8:	d107      	bne.n	c0d076fa <USBD_StdItfReq+0x44>
         USBD_CtlSendStatus(pdev);
c0d076ea:	4620      	mov	r0, r4
c0d076ec:	f000 fb1b 	bl	c0d07d26 <USBD_CtlSendStatus>
c0d076f0:	e003      	b.n	c0d076fa <USBD_StdItfReq+0x44>
c0d076f2:	4620      	mov	r0, r4
c0d076f4:	4629      	mov	r1, r5
c0d076f6:	f000 fa4f 	bl	c0d07b98 <USBD_CtlError>
c0d076fa:	2000      	movs	r0, #0
  return USBD_OK;
c0d076fc:	bdb0      	pop	{r4, r5, r7, pc}

c0d076fe <USBD_StdEPReq>:
{
c0d076fe:	b5b0      	push	{r4, r5, r7, lr}
c0d07700:	b082      	sub	sp, #8
c0d07702:	460d      	mov	r5, r1
c0d07704:	4604      	mov	r4, r0
  ep_addr  = LOBYTE(req->wIndex);
c0d07706:	7909      	ldrb	r1, [r1, #4]
c0d07708:	207f      	movs	r0, #127	; 0x7f
  if ((ep_addr & 0x7F) > IO_USB_MAX_ENDPOINTS) {
c0d0770a:	4008      	ands	r0, r1
c0d0770c:	2805      	cmp	r0, #5
c0d0770e:	d304      	bcc.n	c0d0771a <USBD_StdEPReq+0x1c>
c0d07710:	4620      	mov	r0, r4
c0d07712:	4629      	mov	r1, r5
c0d07714:	f000 fa40 	bl	c0d07b98 <USBD_CtlError>
c0d07718:	e071      	b.n	c0d077fe <USBD_StdEPReq+0x100>
  if ((req->bmRequest & 0x60) == 0x20 && usbd_is_valid_intf(pdev, LOBYTE(req->wIndex)))
c0d0771a:	2902      	cmp	r1, #2
c0d0771c:	d812      	bhi.n	c0d07744 <USBD_StdEPReq+0x46>
c0d0771e:	782a      	ldrb	r2, [r5, #0]
c0d07720:	2360      	movs	r3, #96	; 0x60
c0d07722:	4013      	ands	r3, r2
c0d07724:	2b20      	cmp	r3, #32
c0d07726:	d10d      	bne.n	c0d07744 <USBD_StdEPReq+0x46>
  return intf < USBD_MAX_NUM_INTERFACES && pdev->interfacesClass[intf].pClass != NULL;
c0d07728:	00ca      	lsls	r2, r1, #3
c0d0772a:	18a2      	adds	r2, r4, r2
c0d0772c:	23b4      	movs	r3, #180	; 0xb4
c0d0772e:	58d2      	ldr	r2, [r2, r3]
  if ((req->bmRequest & 0x60) == 0x20 && usbd_is_valid_intf(pdev, LOBYTE(req->wIndex)))
c0d07730:	2a00      	cmp	r2, #0
c0d07732:	d007      	beq.n	c0d07744 <USBD_StdEPReq+0x46>
    ((Setup_t)PIC(pdev->interfacesClass[LOBYTE(req->wIndex)].pClass->Setup)) (pdev, req);
c0d07734:	6890      	ldr	r0, [r2, #8]
c0d07736:	f7fb fdf7 	bl	c0d03328 <pic>
c0d0773a:	4602      	mov	r2, r0
c0d0773c:	4620      	mov	r0, r4
c0d0773e:	4629      	mov	r1, r5
c0d07740:	4790      	blx	r2
c0d07742:	e05c      	b.n	c0d077fe <USBD_StdEPReq+0x100>
  switch (req->bRequest) 
c0d07744:	786a      	ldrb	r2, [r5, #1]
c0d07746:	2a00      	cmp	r2, #0
c0d07748:	d00a      	beq.n	c0d07760 <USBD_StdEPReq+0x62>
c0d0774a:	2a01      	cmp	r2, #1
c0d0774c:	d011      	beq.n	c0d07772 <USBD_StdEPReq+0x74>
c0d0774e:	2a03      	cmp	r2, #3
c0d07750:	d155      	bne.n	c0d077fe <USBD_StdEPReq+0x100>
c0d07752:	209c      	movs	r0, #156	; 0x9c
    switch (pdev->dev_state) 
c0d07754:	5c20      	ldrb	r0, [r4, r0]
c0d07756:	2803      	cmp	r0, #3
c0d07758:	d01a      	beq.n	c0d07790 <USBD_StdEPReq+0x92>
c0d0775a:	2802      	cmp	r0, #2
c0d0775c:	d00f      	beq.n	c0d0777e <USBD_StdEPReq+0x80>
c0d0775e:	e7d7      	b.n	c0d07710 <USBD_StdEPReq+0x12>
c0d07760:	229c      	movs	r2, #156	; 0x9c
    switch (pdev->dev_state) 
c0d07762:	5ca2      	ldrb	r2, [r4, r2]
c0d07764:	2a03      	cmp	r2, #3
c0d07766:	d02e      	beq.n	c0d077c6 <USBD_StdEPReq+0xc8>
c0d07768:	2a02      	cmp	r2, #2
c0d0776a:	d1d1      	bne.n	c0d07710 <USBD_StdEPReq+0x12>
      if ((ep_addr & 0x7F) != 0x00) 
c0d0776c:	2800      	cmp	r0, #0
c0d0776e:	d10b      	bne.n	c0d07788 <USBD_StdEPReq+0x8a>
c0d07770:	e045      	b.n	c0d077fe <USBD_StdEPReq+0x100>
c0d07772:	229c      	movs	r2, #156	; 0x9c
    switch (pdev->dev_state) 
c0d07774:	5ca2      	ldrb	r2, [r4, r2]
c0d07776:	2a03      	cmp	r2, #3
c0d07778:	d031      	beq.n	c0d077de <USBD_StdEPReq+0xe0>
c0d0777a:	2a02      	cmp	r2, #2
c0d0777c:	d1c8      	bne.n	c0d07710 <USBD_StdEPReq+0x12>
c0d0777e:	2080      	movs	r0, #128	; 0x80
c0d07780:	460a      	mov	r2, r1
c0d07782:	4302      	orrs	r2, r0
c0d07784:	2a80      	cmp	r2, #128	; 0x80
c0d07786:	d03a      	beq.n	c0d077fe <USBD_StdEPReq+0x100>
c0d07788:	4620      	mov	r0, r4
c0d0778a:	f7ff fbc1 	bl	c0d06f10 <USBD_LL_StallEP>
c0d0778e:	e036      	b.n	c0d077fe <USBD_StdEPReq+0x100>
      if (req->wValue == USB_FEATURE_EP_HALT)
c0d07790:	8868      	ldrh	r0, [r5, #2]
c0d07792:	2800      	cmp	r0, #0
c0d07794:	d107      	bne.n	c0d077a6 <USBD_StdEPReq+0xa8>
c0d07796:	2080      	movs	r0, #128	; 0x80
c0d07798:	4308      	orrs	r0, r1
c0d0779a:	2880      	cmp	r0, #128	; 0x80
c0d0779c:	d003      	beq.n	c0d077a6 <USBD_StdEPReq+0xa8>
          USBD_LL_StallEP(pdev , ep_addr);
c0d0779e:	4620      	mov	r0, r4
c0d077a0:	f7ff fbb6 	bl	c0d06f10 <USBD_LL_StallEP>
      if(usbd_is_valid_intf(pdev, LOBYTE(req->wIndex))) {
c0d077a4:	7929      	ldrb	r1, [r5, #4]
  return intf < USBD_MAX_NUM_INTERFACES && pdev->interfacesClass[intf].pClass != NULL;
c0d077a6:	2902      	cmp	r1, #2
c0d077a8:	d826      	bhi.n	c0d077f8 <USBD_StdEPReq+0xfa>
c0d077aa:	00c8      	lsls	r0, r1, #3
c0d077ac:	1820      	adds	r0, r4, r0
c0d077ae:	21b4      	movs	r1, #180	; 0xb4
c0d077b0:	5840      	ldr	r0, [r0, r1]
c0d077b2:	2800      	cmp	r0, #0
c0d077b4:	d020      	beq.n	c0d077f8 <USBD_StdEPReq+0xfa>
c0d077b6:	6880      	ldr	r0, [r0, #8]
c0d077b8:	f7fb fdb6 	bl	c0d03328 <pic>
c0d077bc:	4602      	mov	r2, r0
c0d077be:	4620      	mov	r0, r4
c0d077c0:	4629      	mov	r1, r5
c0d077c2:	4790      	blx	r2
c0d077c4:	e018      	b.n	c0d077f8 <USBD_StdEPReq+0xfa>
        unsigned short status = USBD_LL_IsStallEP(pdev, ep_addr)? 1 : 0;        
c0d077c6:	4620      	mov	r0, r4
c0d077c8:	f7ff fbea 	bl	c0d06fa0 <USBD_LL_IsStallEP>
c0d077cc:	1e41      	subs	r1, r0, #1
c0d077ce:	4188      	sbcs	r0, r1
c0d077d0:	a901      	add	r1, sp, #4
c0d077d2:	8008      	strh	r0, [r1, #0]
c0d077d4:	2202      	movs	r2, #2
        USBD_CtlSendData (pdev,
c0d077d6:	4620      	mov	r0, r4
c0d077d8:	f000 fa7a 	bl	c0d07cd0 <USBD_CtlSendData>
c0d077dc:	e00f      	b.n	c0d077fe <USBD_StdEPReq+0x100>
      if (req->wValue == USB_FEATURE_EP_HALT)
c0d077de:	886a      	ldrh	r2, [r5, #2]
c0d077e0:	2a00      	cmp	r2, #0
c0d077e2:	d10c      	bne.n	c0d077fe <USBD_StdEPReq+0x100>
        if ((ep_addr & 0x7F) != 0x00) 
c0d077e4:	2800      	cmp	r0, #0
c0d077e6:	d007      	beq.n	c0d077f8 <USBD_StdEPReq+0xfa>
          USBD_LL_ClearStallEP(pdev , ep_addr);
c0d077e8:	4620      	mov	r0, r4
c0d077ea:	f7ff fbb5 	bl	c0d06f58 <USBD_LL_ClearStallEP>
          if(usbd_is_valid_intf(pdev, LOBYTE(req->wIndex))) {
c0d077ee:	7928      	ldrb	r0, [r5, #4]
  return intf < USBD_MAX_NUM_INTERFACES && pdev->interfacesClass[intf].pClass != NULL;
c0d077f0:	2802      	cmp	r0, #2
c0d077f2:	d801      	bhi.n	c0d077f8 <USBD_StdEPReq+0xfa>
c0d077f4:	00c0      	lsls	r0, r0, #3
c0d077f6:	e7d9      	b.n	c0d077ac <USBD_StdEPReq+0xae>
c0d077f8:	4620      	mov	r0, r4
c0d077fa:	f000 fa94 	bl	c0d07d26 <USBD_CtlSendStatus>
c0d077fe:	2000      	movs	r0, #0
}
c0d07800:	b002      	add	sp, #8
c0d07802:	bdb0      	pop	{r4, r5, r7, pc}

c0d07804 <USBD_ParseSetupRequest>:
* @retval None
*/

void USBD_ParseSetupRequest(USBD_SetupReqTypedef *req, uint8_t *pdata)
{
  req->bmRequest     = *(uint8_t *)  (pdata);
c0d07804:	780a      	ldrb	r2, [r1, #0]
c0d07806:	7002      	strb	r2, [r0, #0]
  req->bRequest      = *(uint8_t *)  (pdata +  1);
c0d07808:	784a      	ldrb	r2, [r1, #1]
c0d0780a:	7042      	strb	r2, [r0, #1]
  req->wValue        = SWAPBYTE      (pdata +  2);
c0d0780c:	788a      	ldrb	r2, [r1, #2]
c0d0780e:	78cb      	ldrb	r3, [r1, #3]
c0d07810:	021b      	lsls	r3, r3, #8
c0d07812:	189a      	adds	r2, r3, r2
c0d07814:	8042      	strh	r2, [r0, #2]
  req->wIndex        = SWAPBYTE      (pdata +  4);
c0d07816:	790a      	ldrb	r2, [r1, #4]
c0d07818:	794b      	ldrb	r3, [r1, #5]
c0d0781a:	021b      	lsls	r3, r3, #8
c0d0781c:	189a      	adds	r2, r3, r2
c0d0781e:	8082      	strh	r2, [r0, #4]
  req->wLength       = SWAPBYTE      (pdata +  6);
c0d07820:	798a      	ldrb	r2, [r1, #6]
c0d07822:	79c9      	ldrb	r1, [r1, #7]
c0d07824:	0209      	lsls	r1, r1, #8
c0d07826:	1889      	adds	r1, r1, r2
c0d07828:	80c1      	strh	r1, [r0, #6]

}
c0d0782a:	4770      	bx	lr

c0d0782c <USBD_CtlStall>:
* @param  pdev: device instance
* @param  req: usb request
* @retval None
*/
void USBD_CtlStall( USBD_HandleTypeDef *pdev)
{
c0d0782c:	b510      	push	{r4, lr}
c0d0782e:	4604      	mov	r4, r0
c0d07830:	2180      	movs	r1, #128	; 0x80
  USBD_LL_StallEP(pdev , 0x80);
c0d07832:	f7ff fb6d 	bl	c0d06f10 <USBD_LL_StallEP>
c0d07836:	2100      	movs	r1, #0
  USBD_LL_StallEP(pdev , 0);
c0d07838:	4620      	mov	r0, r4
c0d0783a:	f7ff fb69 	bl	c0d06f10 <USBD_LL_StallEP>
}
c0d0783e:	bd10      	pop	{r4, pc}

c0d07840 <USBD_HID_Setup>:
  * @param  req: usb requests
  * @retval status
  */
uint8_t  USBD_HID_Setup (USBD_HandleTypeDef *pdev, 
                                USBD_SetupReqTypedef *req)
{
c0d07840:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d07842:	b083      	sub	sp, #12
c0d07844:	460e      	mov	r6, r1
c0d07846:	4605      	mov	r5, r0
c0d07848:	a802      	add	r0, sp, #8
c0d0784a:	2400      	movs	r4, #0
  uint16_t len = 0;
c0d0784c:	8004      	strh	r4, [r0, #0]
c0d0784e:	a801      	add	r0, sp, #4
  uint8_t  *pbuf = NULL;

  uint8_t val = 0;
c0d07850:	7004      	strb	r4, [r0, #0]

  switch (req->bmRequest & USB_REQ_TYPE_MASK)
c0d07852:	7809      	ldrb	r1, [r1, #0]
c0d07854:	2060      	movs	r0, #96	; 0x60
c0d07856:	4008      	ands	r0, r1
c0d07858:	d010      	beq.n	c0d0787c <USBD_HID_Setup+0x3c>
c0d0785a:	2820      	cmp	r0, #32
c0d0785c:	d137      	bne.n	c0d078ce <USBD_HID_Setup+0x8e>
  {
  case USB_REQ_TYPE_CLASS :  
    switch (req->bRequest)
c0d0785e:	7870      	ldrb	r0, [r6, #1]
c0d07860:	4601      	mov	r1, r0
c0d07862:	390a      	subs	r1, #10
c0d07864:	2902      	cmp	r1, #2
c0d07866:	d332      	bcc.n	c0d078ce <USBD_HID_Setup+0x8e>
c0d07868:	2802      	cmp	r0, #2
c0d0786a:	d01b      	beq.n	c0d078a4 <USBD_HID_Setup+0x64>
c0d0786c:	2803      	cmp	r0, #3
c0d0786e:	d019      	beq.n	c0d078a4 <USBD_HID_Setup+0x64>
                        (uint8_t *)&val,
                        1);      
      break;      
      
    default:
      USBD_CtlError (pdev, req);
c0d07870:	4628      	mov	r0, r5
c0d07872:	4631      	mov	r1, r6
c0d07874:	f000 f990 	bl	c0d07b98 <USBD_CtlError>
c0d07878:	2402      	movs	r4, #2
c0d0787a:	e028      	b.n	c0d078ce <USBD_HID_Setup+0x8e>
      return USBD_FAIL; 
    }
    break;
    
  case USB_REQ_TYPE_STANDARD:
    switch (req->bRequest)
c0d0787c:	7870      	ldrb	r0, [r6, #1]
c0d0787e:	280b      	cmp	r0, #11
c0d07880:	d013      	beq.n	c0d078aa <USBD_HID_Setup+0x6a>
c0d07882:	280a      	cmp	r0, #10
c0d07884:	d00e      	beq.n	c0d078a4 <USBD_HID_Setup+0x64>
c0d07886:	2806      	cmp	r0, #6
c0d07888:	d121      	bne.n	c0d078ce <USBD_HID_Setup+0x8e>
    {
    case USB_REQ_GET_DESCRIPTOR: 
      // 0x22
      if( req->wValue >> 8 == HID_REPORT_DESC)
c0d0788a:	78f0      	ldrb	r0, [r6, #3]
c0d0788c:	2400      	movs	r4, #0
c0d0788e:	2821      	cmp	r0, #33	; 0x21
c0d07890:	d00f      	beq.n	c0d078b2 <USBD_HID_Setup+0x72>
c0d07892:	2822      	cmp	r0, #34	; 0x22
      
      //USBD_CtlReceiveStatus(pdev);
      
      USBD_CtlSendData (pdev, 
                        pbuf,
                        len);
c0d07894:	4622      	mov	r2, r4
c0d07896:	4621      	mov	r1, r4
      if( req->wValue >> 8 == HID_REPORT_DESC)
c0d07898:	d116      	bne.n	c0d078c8 <USBD_HID_Setup+0x88>
c0d0789a:	af02      	add	r7, sp, #8
        pbuf =  USBD_HID_GetReportDescriptor_impl(&len);
c0d0789c:	4638      	mov	r0, r7
c0d0789e:	f000 f84f 	bl	c0d07940 <USBD_HID_GetReportDescriptor_impl>
c0d078a2:	e00a      	b.n	c0d078ba <USBD_HID_Setup+0x7a>
c0d078a4:	a901      	add	r1, sp, #4
c0d078a6:	2201      	movs	r2, #1
c0d078a8:	e00e      	b.n	c0d078c8 <USBD_HID_Setup+0x88>
      break;

    case USB_REQ_SET_INTERFACE :
      //hhid->AltSetting = (uint8_t)(req->wValue);
      USBD_CtlSendStatus(pdev);
c0d078aa:	4628      	mov	r0, r5
c0d078ac:	f000 fa3b 	bl	c0d07d26 <USBD_CtlSendStatus>
c0d078b0:	e00d      	b.n	c0d078ce <USBD_HID_Setup+0x8e>
c0d078b2:	af02      	add	r7, sp, #8
        pbuf = USBD_HID_GetHidDescriptor_impl(&len);
c0d078b4:	4638      	mov	r0, r7
c0d078b6:	f000 f829 	bl	c0d0790c <USBD_HID_GetHidDescriptor_impl>
c0d078ba:	4601      	mov	r1, r0
c0d078bc:	883a      	ldrh	r2, [r7, #0]
c0d078be:	88f0      	ldrh	r0, [r6, #6]
c0d078c0:	4282      	cmp	r2, r0
c0d078c2:	d300      	bcc.n	c0d078c6 <USBD_HID_Setup+0x86>
c0d078c4:	4602      	mov	r2, r0
c0d078c6:	803a      	strh	r2, [r7, #0]
c0d078c8:	4628      	mov	r0, r5
c0d078ca:	f000 fa01 	bl	c0d07cd0 <USBD_CtlSendData>
      
    }
  }

  return USBD_OK;
}
c0d078ce:	4620      	mov	r0, r4
c0d078d0:	b003      	add	sp, #12
c0d078d2:	bdf0      	pop	{r4, r5, r6, r7, pc}

c0d078d4 <USBD_HID_Init>:
  * @param  cfgidx: Configuration index
  * @retval status
  */
uint8_t  USBD_HID_Init (USBD_HandleTypeDef *pdev, 
                               uint8_t cfgidx)
{
c0d078d4:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d078d6:	b081      	sub	sp, #4
c0d078d8:	4604      	mov	r4, r0
c0d078da:	2182      	movs	r1, #130	; 0x82
c0d078dc:	2603      	movs	r6, #3
c0d078de:	2540      	movs	r5, #64	; 0x40
  UNUSED(cfgidx);

  /* Open EP IN */
  USBD_LL_OpenEP(pdev,
c0d078e0:	4632      	mov	r2, r6
c0d078e2:	462b      	mov	r3, r5
c0d078e4:	f7ff fae4 	bl	c0d06eb0 <USBD_LL_OpenEP>
c0d078e8:	2702      	movs	r7, #2
                 HID_EPIN_ADDR,
                 USBD_EP_TYPE_INTR,
                 HID_EPIN_SIZE);
  
  /* Open EP OUT */
  USBD_LL_OpenEP(pdev,
c0d078ea:	4620      	mov	r0, r4
c0d078ec:	4639      	mov	r1, r7
c0d078ee:	4632      	mov	r2, r6
c0d078f0:	462b      	mov	r3, r5
c0d078f2:	f7ff fadd 	bl	c0d06eb0 <USBD_LL_OpenEP>
                 HID_EPOUT_ADDR,
                 USBD_EP_TYPE_INTR,
                 HID_EPOUT_SIZE);

        /* Prepare Out endpoint to receive 1st packet */ 
  USBD_LL_PrepareReceive(pdev, HID_EPOUT_ADDR, HID_EPOUT_SIZE);
c0d078f6:	4620      	mov	r0, r4
c0d078f8:	4639      	mov	r1, r7
c0d078fa:	462a      	mov	r2, r5
c0d078fc:	f7ff fb8b 	bl	c0d07016 <USBD_LL_PrepareReceive>
c0d07900:	2000      	movs	r0, #0
  USBD_LL_Transmit (pdev, 
                    HID_EPIN_ADDR,                                      
                    NULL,
                    0);
  */
  return USBD_OK;
c0d07902:	b001      	add	sp, #4
c0d07904:	bdf0      	pop	{r4, r5, r6, r7, pc}

c0d07906 <USBD_HID_DeInit>:
  * @param  cfgidx: Configuration index
  * @retval status
  */
uint8_t  USBD_HID_DeInit (USBD_HandleTypeDef *pdev, 
                                 uint8_t cfgidx)
{
c0d07906:	2000      	movs	r0, #0
  
  // /* Close HID EP OUT */
  // USBD_LL_CloseEP(pdev,
  //                 HID_EPOUT_ADDR);
  
  return USBD_OK;
c0d07908:	4770      	bx	lr
	...

c0d0790c <USBD_HID_GetHidDescriptor_impl>:
{
  *length = sizeof (USBD_CfgDesc);
  return (uint8_t*)USBD_CfgDesc;
}

uint8_t* USBD_HID_GetHidDescriptor_impl(uint16_t* len) {
c0d0790c:	21ac      	movs	r1, #172	; 0xac
  switch (USBD_Device.request.wIndex&0xFF) {
c0d0790e:	4a09      	ldr	r2, [pc, #36]	; (c0d07934 <USBD_HID_GetHidDescriptor_impl+0x28>)
c0d07910:	5c51      	ldrb	r1, [r2, r1]
c0d07912:	2209      	movs	r2, #9
c0d07914:	2901      	cmp	r1, #1
c0d07916:	d004      	beq.n	c0d07922 <USBD_HID_GetHidDescriptor_impl+0x16>
c0d07918:	2900      	cmp	r1, #0
c0d0791a:	d105      	bne.n	c0d07928 <USBD_HID_GetHidDescriptor_impl+0x1c>
c0d0791c:	4907      	ldr	r1, [pc, #28]	; (c0d0793c <USBD_HID_GetHidDescriptor_impl+0x30>)
c0d0791e:	4479      	add	r1, pc
c0d07920:	e004      	b.n	c0d0792c <USBD_HID_GetHidDescriptor_impl+0x20>
c0d07922:	4905      	ldr	r1, [pc, #20]	; (c0d07938 <USBD_HID_GetHidDescriptor_impl+0x2c>)
c0d07924:	4479      	add	r1, pc
c0d07926:	e001      	b.n	c0d0792c <USBD_HID_GetHidDescriptor_impl+0x20>
c0d07928:	2200      	movs	r2, #0
c0d0792a:	4611      	mov	r1, r2
c0d0792c:	8002      	strh	r2, [r0, #0]
      return (uint8_t*)USBD_HID_Desc_kbd; 
#endif // HAVE_USB_HIDKBD
  }
  *len = 0;
  return 0;
}
c0d0792e:	4608      	mov	r0, r1
c0d07930:	4770      	bx	lr
c0d07932:	46c0      	nop			; (mov r8, r8)
c0d07934:	200009e0 	.word	0x200009e0
c0d07938:	000023c8 	.word	0x000023c8
c0d0793c:	000023da 	.word	0x000023da

c0d07940 <USBD_HID_GetReportDescriptor_impl>:

uint8_t* USBD_HID_GetReportDescriptor_impl(uint16_t* len) {
c0d07940:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d07942:	b081      	sub	sp, #4
c0d07944:	4602      	mov	r2, r0
c0d07946:	20ac      	movs	r0, #172	; 0xac
  switch (USBD_Device.request.wIndex&0xFF) {
c0d07948:	4913      	ldr	r1, [pc, #76]	; (c0d07998 <USBD_HID_GetReportDescriptor_impl+0x58>)
c0d0794a:	5c08      	ldrb	r0, [r1, r0]
c0d0794c:	2422      	movs	r4, #34	; 0x22
c0d0794e:	2800      	cmp	r0, #0
c0d07950:	d01a      	beq.n	c0d07988 <USBD_HID_GetReportDescriptor_impl+0x48>
c0d07952:	2801      	cmp	r0, #1
c0d07954:	d11b      	bne.n	c0d0798e <USBD_HID_GetReportDescriptor_impl+0x4e>
#ifdef HAVE_IO_U2F
  case U2F_INTF:

    // very dirty work due to lack of callback when USB_HID_Init is called
    USBD_LL_OpenEP(&USBD_Device,
c0d07956:	4810      	ldr	r0, [pc, #64]	; (c0d07998 <USBD_HID_GetReportDescriptor_impl+0x58>)
c0d07958:	2181      	movs	r1, #129	; 0x81
c0d0795a:	2703      	movs	r7, #3
c0d0795c:	2640      	movs	r6, #64	; 0x40
c0d0795e:	9200      	str	r2, [sp, #0]
c0d07960:	463a      	mov	r2, r7
c0d07962:	4633      	mov	r3, r6
c0d07964:	f7ff faa4 	bl	c0d06eb0 <USBD_LL_OpenEP>
c0d07968:	2501      	movs	r5, #1
                   U2F_EPIN_ADDR,
                   USBD_EP_TYPE_INTR,
                   U2F_EPIN_SIZE);
    
    USBD_LL_OpenEP(&USBD_Device,
c0d0796a:	480b      	ldr	r0, [pc, #44]	; (c0d07998 <USBD_HID_GetReportDescriptor_impl+0x58>)
c0d0796c:	4629      	mov	r1, r5
c0d0796e:	463a      	mov	r2, r7
c0d07970:	4633      	mov	r3, r6
c0d07972:	f7ff fa9d 	bl	c0d06eb0 <USBD_LL_OpenEP>
                   U2F_EPOUT_ADDR,
                   USBD_EP_TYPE_INTR,
                   U2F_EPOUT_SIZE);

    /* Prepare Out endpoint to receive 1st packet */ 
    USBD_LL_PrepareReceive(&USBD_Device, U2F_EPOUT_ADDR, U2F_EPOUT_SIZE);
c0d07976:	4808      	ldr	r0, [pc, #32]	; (c0d07998 <USBD_HID_GetReportDescriptor_impl+0x58>)
c0d07978:	4629      	mov	r1, r5
c0d0797a:	4632      	mov	r2, r6
c0d0797c:	f7ff fb4b 	bl	c0d07016 <USBD_LL_PrepareReceive>
c0d07980:	9a00      	ldr	r2, [sp, #0]
c0d07982:	4807      	ldr	r0, [pc, #28]	; (c0d079a0 <USBD_HID_GetReportDescriptor_impl+0x60>)
c0d07984:	4478      	add	r0, pc
c0d07986:	e004      	b.n	c0d07992 <USBD_HID_GetReportDescriptor_impl+0x52>
c0d07988:	4804      	ldr	r0, [pc, #16]	; (c0d0799c <USBD_HID_GetReportDescriptor_impl+0x5c>)
c0d0798a:	4478      	add	r0, pc
c0d0798c:	e001      	b.n	c0d07992 <USBD_HID_GetReportDescriptor_impl+0x52>
c0d0798e:	2400      	movs	r4, #0
c0d07990:	4620      	mov	r0, r4
c0d07992:	8014      	strh	r4, [r2, #0]
    return (uint8_t*)HID_ReportDesc_kbd;
#endif // HAVE_USB_HIDKBD
  }
  *len = 0;
  return 0;
}
c0d07994:	b001      	add	sp, #4
c0d07996:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d07998:	200009e0 	.word	0x200009e0
c0d0799c:	00002399 	.word	0x00002399
c0d079a0:	0000237d 	.word	0x0000237d

c0d079a4 <USBD_U2F_Init>:
  * @param  cfgidx: Configuration index
  * @retval status
  */
uint8_t  USBD_U2F_Init (USBD_HandleTypeDef *pdev, 
                               uint8_t cfgidx)
{
c0d079a4:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d079a6:	b081      	sub	sp, #4
c0d079a8:	4604      	mov	r4, r0
c0d079aa:	2181      	movs	r1, #129	; 0x81
c0d079ac:	2603      	movs	r6, #3
c0d079ae:	2540      	movs	r5, #64	; 0x40
  UNUSED(cfgidx);

  /* Open EP IN */
  USBD_LL_OpenEP(pdev,
c0d079b0:	4632      	mov	r2, r6
c0d079b2:	462b      	mov	r3, r5
c0d079b4:	f7ff fa7c 	bl	c0d06eb0 <USBD_LL_OpenEP>
c0d079b8:	2701      	movs	r7, #1
                 U2F_EPIN_ADDR,
                 USBD_EP_TYPE_INTR,
                 U2F_EPIN_SIZE);
  
  /* Open EP OUT */
  USBD_LL_OpenEP(pdev,
c0d079ba:	4620      	mov	r0, r4
c0d079bc:	4639      	mov	r1, r7
c0d079be:	4632      	mov	r2, r6
c0d079c0:	462b      	mov	r3, r5
c0d079c2:	f7ff fa75 	bl	c0d06eb0 <USBD_LL_OpenEP>
                 U2F_EPOUT_ADDR,
                 USBD_EP_TYPE_INTR,
                 U2F_EPOUT_SIZE);

        /* Prepare Out endpoint to receive 1st packet */ 
  USBD_LL_PrepareReceive(pdev, U2F_EPOUT_ADDR, U2F_EPOUT_SIZE);
c0d079c6:	4620      	mov	r0, r4
c0d079c8:	4639      	mov	r1, r7
c0d079ca:	462a      	mov	r2, r5
c0d079cc:	f7ff fb23 	bl	c0d07016 <USBD_LL_PrepareReceive>
c0d079d0:	2000      	movs	r0, #0

  return USBD_OK;
c0d079d2:	b001      	add	sp, #4
c0d079d4:	bdf0      	pop	{r4, r5, r6, r7, pc}
	...

c0d079d8 <USBD_U2F_DataIn_impl>:
}

uint8_t  USBD_U2F_DataIn_impl (USBD_HandleTypeDef *pdev, 
                              uint8_t epnum)
{
c0d079d8:	b580      	push	{r7, lr}
  UNUSED(pdev);
  // only the data hid endpoint will receive data
  switch (epnum) {
c0d079da:	2901      	cmp	r1, #1
c0d079dc:	d103      	bne.n	c0d079e6 <USBD_U2F_DataIn_impl+0xe>
  // FIDO endpoint
  case (U2F_EPIN_ADDR&0x7F):
    // advance the u2f sending machine state
    u2f_transport_sent(&G_io_u2f, U2F_MEDIA_USB);
c0d079de:	4803      	ldr	r0, [pc, #12]	; (c0d079ec <USBD_U2F_DataIn_impl+0x14>)
c0d079e0:	2101      	movs	r1, #1
c0d079e2:	f7fe f929 	bl	c0d05c38 <u2f_transport_sent>
c0d079e6:	2000      	movs	r0, #0
    break;
  } 
  return USBD_OK;
c0d079e8:	bd80      	pop	{r7, pc}
c0d079ea:	46c0      	nop			; (mov r8, r8)
c0d079ec:	200003f8 	.word	0x200003f8

c0d079f0 <USBD_U2F_DataOut_impl>:
}

uint8_t  USBD_U2F_DataOut_impl (USBD_HandleTypeDef *pdev, 
                              uint8_t epnum, uint8_t* buffer)
{
c0d079f0:	b5b0      	push	{r4, r5, r7, lr}
  switch (epnum) {
c0d079f2:	2901      	cmp	r1, #1
c0d079f4:	d10e      	bne.n	c0d07a14 <USBD_U2F_DataOut_impl+0x24>
c0d079f6:	4614      	mov	r4, r2
c0d079f8:	2501      	movs	r5, #1
c0d079fa:	2240      	movs	r2, #64	; 0x40
  // FIDO endpoint
  case (U2F_EPOUT_ADDR&0x7F):
      USBD_LL_PrepareReceive(pdev, U2F_EPOUT_ADDR , U2F_EPOUT_SIZE);
c0d079fc:	4629      	mov	r1, r5
c0d079fe:	f7ff fb0a 	bl	c0d07016 <USBD_LL_PrepareReceive>
      u2f_transport_received(&G_io_u2f, buffer, io_seproxyhal_get_ep_rx_size(U2F_EPOUT_ADDR), U2F_MEDIA_USB);
c0d07a02:	4628      	mov	r0, r5
c0d07a04:	f7fa fc12 	bl	c0d0222c <io_seproxyhal_get_ep_rx_size>
c0d07a08:	4602      	mov	r2, r0
c0d07a0a:	4803      	ldr	r0, [pc, #12]	; (c0d07a18 <USBD_U2F_DataOut_impl+0x28>)
c0d07a0c:	4621      	mov	r1, r4
c0d07a0e:	462b      	mov	r3, r5
c0d07a10:	f7fe fa32 	bl	c0d05e78 <u2f_transport_received>
c0d07a14:	2000      	movs	r0, #0
    break;
  }

  return USBD_OK;
c0d07a16:	bdb0      	pop	{r4, r5, r7, pc}
c0d07a18:	200003f8 	.word	0x200003f8

c0d07a1c <USBD_HID_DataIn_impl>:
}
#endif // HAVE_IO_U2F

uint8_t  USBD_HID_DataIn_impl (USBD_HandleTypeDef *pdev, 
                              uint8_t epnum)
{
c0d07a1c:	b580      	push	{r7, lr}
  UNUSED(pdev);
  switch (epnum) {
c0d07a1e:	2902      	cmp	r1, #2
c0d07a20:	d103      	bne.n	c0d07a2a <USBD_HID_DataIn_impl+0xe>
    // HID gen endpoint
    case (HID_EPIN_ADDR&0x7F):
      io_usb_hid_sent(io_usb_send_apdu_data);
c0d07a22:	4803      	ldr	r0, [pc, #12]	; (c0d07a30 <USBD_HID_DataIn_impl+0x14>)
c0d07a24:	4478      	add	r0, pc
c0d07a26:	f7fb f86b 	bl	c0d02b00 <io_usb_hid_sent>
c0d07a2a:	2000      	movs	r0, #0
      break;
  }

  return USBD_OK;
c0d07a2c:	bd80      	pop	{r7, pc}
c0d07a2e:	46c0      	nop			; (mov r8, r8)
c0d07a30:	ffffa8cd 	.word	0xffffa8cd

c0d07a34 <USBD_HID_DataOut_impl>:
}

uint8_t  USBD_HID_DataOut_impl (USBD_HandleTypeDef *pdev, 
                              uint8_t epnum, uint8_t* buffer)
{
c0d07a34:	b5b0      	push	{r4, r5, r7, lr}
  // only the data hid endpoint will receive data
  switch (epnum) {
c0d07a36:	2902      	cmp	r1, #2
c0d07a38:	d11a      	bne.n	c0d07a70 <USBD_HID_DataOut_impl+0x3c>
c0d07a3a:	4614      	mov	r4, r2
c0d07a3c:	2102      	movs	r1, #2
c0d07a3e:	2240      	movs	r2, #64	; 0x40

  // HID gen endpoint
  case (HID_EPOUT_ADDR&0x7F):
    // prepare receiving the next chunk (masked time)
    USBD_LL_PrepareReceive(pdev, HID_EPOUT_ADDR , HID_EPOUT_SIZE);
c0d07a40:	f7ff fae9 	bl	c0d07016 <USBD_LL_PrepareReceive>

#ifndef HAVE_USB_HIDKBD
    // avoid troubles when an apdu has not been replied yet
    if (G_io_app.apdu_media == IO_APDU_MEDIA_NONE) {      
c0d07a44:	4d0b      	ldr	r5, [pc, #44]	; (c0d07a74 <USBD_HID_DataOut_impl+0x40>)
c0d07a46:	79a8      	ldrb	r0, [r5, #6]
c0d07a48:	2800      	cmp	r0, #0
c0d07a4a:	d111      	bne.n	c0d07a70 <USBD_HID_DataOut_impl+0x3c>
c0d07a4c:	2002      	movs	r0, #2
      // add to the hid transport
      switch(io_usb_hid_receive(io_usb_send_apdu_data, buffer, io_seproxyhal_get_ep_rx_size(HID_EPOUT_ADDR))) {
c0d07a4e:	f7fa fbed 	bl	c0d0222c <io_seproxyhal_get_ep_rx_size>
c0d07a52:	4602      	mov	r2, r0
c0d07a54:	4809      	ldr	r0, [pc, #36]	; (c0d07a7c <USBD_HID_DataOut_impl+0x48>)
c0d07a56:	4478      	add	r0, pc
c0d07a58:	4621      	mov	r1, r4
c0d07a5a:	f7fa ff99 	bl	c0d02990 <io_usb_hid_receive>
c0d07a5e:	2802      	cmp	r0, #2
c0d07a60:	d106      	bne.n	c0d07a70 <USBD_HID_DataOut_impl+0x3c>
c0d07a62:	2007      	movs	r0, #7
        default:
          break;

        case IO_USB_APDU_RECEIVED:
          G_io_app.apdu_media = IO_APDU_MEDIA_USB_HID; // for application code
          G_io_app.apdu_state = APDU_USB_HID; // for next call to io_exchange
c0d07a64:	7028      	strb	r0, [r5, #0]
c0d07a66:	2001      	movs	r0, #1
          G_io_app.apdu_media = IO_APDU_MEDIA_USB_HID; // for application code
c0d07a68:	71a8      	strb	r0, [r5, #6]
          G_io_app.apdu_length = G_io_usb_hid_total_length;
c0d07a6a:	4803      	ldr	r0, [pc, #12]	; (c0d07a78 <USBD_HID_DataOut_impl+0x44>)
c0d07a6c:	6800      	ldr	r0, [r0, #0]
c0d07a6e:	8068      	strh	r0, [r5, #2]
c0d07a70:	2000      	movs	r0, #0
    }
#endif // HAVE_USB_HIDKBD
    break;
  }

  return USBD_OK;
c0d07a72:	bdb0      	pop	{r4, r5, r7, pc}
c0d07a74:	200003d8 	.word	0x200003d8
c0d07a78:	20000480 	.word	0x20000480
c0d07a7c:	ffffa89b 	.word	0xffffa89b

c0d07a80 <USBD_WEBUSB_Init>:

#ifdef HAVE_WEBUSB

uint8_t  USBD_WEBUSB_Init (USBD_HandleTypeDef *pdev, 
                               uint8_t cfgidx)
{
c0d07a80:	b570      	push	{r4, r5, r6, lr}
c0d07a82:	4604      	mov	r4, r0
c0d07a84:	2183      	movs	r1, #131	; 0x83
c0d07a86:	2503      	movs	r5, #3
c0d07a88:	2640      	movs	r6, #64	; 0x40
  UNUSED(cfgidx);

  /* Open EP IN */
  USBD_LL_OpenEP(pdev,
c0d07a8a:	462a      	mov	r2, r5
c0d07a8c:	4633      	mov	r3, r6
c0d07a8e:	f7ff fa0f 	bl	c0d06eb0 <USBD_LL_OpenEP>
                 WEBUSB_EPIN_ADDR,
                 USBD_EP_TYPE_INTR,
                 WEBUSB_EPIN_SIZE);
  
  /* Open EP OUT */
  USBD_LL_OpenEP(pdev,
c0d07a92:	4620      	mov	r0, r4
c0d07a94:	4629      	mov	r1, r5
c0d07a96:	462a      	mov	r2, r5
c0d07a98:	4633      	mov	r3, r6
c0d07a9a:	f7ff fa09 	bl	c0d06eb0 <USBD_LL_OpenEP>
                 WEBUSB_EPOUT_ADDR,
                 USBD_EP_TYPE_INTR,
                 WEBUSB_EPOUT_SIZE);

        /* Prepare Out endpoint to receive 1st packet */ 
  USBD_LL_PrepareReceive(pdev, WEBUSB_EPOUT_ADDR, WEBUSB_EPOUT_SIZE);
c0d07a9e:	4620      	mov	r0, r4
c0d07aa0:	4629      	mov	r1, r5
c0d07aa2:	4632      	mov	r2, r6
c0d07aa4:	f7ff fab7 	bl	c0d07016 <USBD_LL_PrepareReceive>
c0d07aa8:	2000      	movs	r0, #0

  return USBD_OK;
c0d07aaa:	bd70      	pop	{r4, r5, r6, pc}

c0d07aac <USBD_WEBUSB_DeInit>:
}

uint8_t  USBD_WEBUSB_DeInit (USBD_HandleTypeDef *pdev, 
                                 uint8_t cfgidx) {
c0d07aac:	2000      	movs	r0, #0
  UNUSED(pdev);
  UNUSED(cfgidx);
  return USBD_OK;
c0d07aae:	4770      	bx	lr

c0d07ab0 <USBD_WEBUSB_Setup>:
}

uint8_t  USBD_WEBUSB_Setup (USBD_HandleTypeDef *pdev, 
                                USBD_SetupReqTypedef *req)
{
c0d07ab0:	2000      	movs	r0, #0
  UNUSED(pdev);
  UNUSED(req);
  return USBD_OK;
c0d07ab2:	4770      	bx	lr

c0d07ab4 <USBD_WEBUSB_DataIn>:
}

uint8_t  USBD_WEBUSB_DataIn (USBD_HandleTypeDef *pdev, 
                              uint8_t epnum)
{
c0d07ab4:	b580      	push	{r7, lr}
  UNUSED(pdev);
  switch (epnum) {
c0d07ab6:	2903      	cmp	r1, #3
c0d07ab8:	d103      	bne.n	c0d07ac2 <USBD_WEBUSB_DataIn+0xe>
    // HID gen endpoint
    case (WEBUSB_EPIN_ADDR&0x7F):
      io_usb_hid_sent(io_usb_send_apdu_data_ep0x83);
c0d07aba:	4803      	ldr	r0, [pc, #12]	; (c0d07ac8 <USBD_WEBUSB_DataIn+0x14>)
c0d07abc:	4478      	add	r0, pc
c0d07abe:	f7fb f81f 	bl	c0d02b00 <io_usb_hid_sent>
c0d07ac2:	2000      	movs	r0, #0
      break;
  }
  return USBD_OK;
c0d07ac4:	bd80      	pop	{r7, pc}
c0d07ac6:	46c0      	nop			; (mov r8, r8)
c0d07ac8:	ffffa845 	.word	0xffffa845

c0d07acc <USBD_WEBUSB_DataOut>:
}

uint8_t USBD_WEBUSB_DataOut (USBD_HandleTypeDef *pdev, 
                              uint8_t epnum, uint8_t* buffer)
{
c0d07acc:	b5b0      	push	{r4, r5, r7, lr}
  // only the data hid endpoint will receive data
  switch (epnum) {
c0d07ace:	2903      	cmp	r1, #3
c0d07ad0:	d11a      	bne.n	c0d07b08 <USBD_WEBUSB_DataOut+0x3c>
c0d07ad2:	4614      	mov	r4, r2
c0d07ad4:	2103      	movs	r1, #3
c0d07ad6:	2240      	movs	r2, #64	; 0x40

  // HID gen endpoint
  case (WEBUSB_EPOUT_ADDR&0x7F):
    // prepare receiving the next chunk (masked time)
    USBD_LL_PrepareReceive(pdev, WEBUSB_EPOUT_ADDR, WEBUSB_EPOUT_SIZE);
c0d07ad8:	f7ff fa9d 	bl	c0d07016 <USBD_LL_PrepareReceive>

    // avoid troubles when an apdu has not been replied yet
    if (G_io_app.apdu_media == IO_APDU_MEDIA_NONE) {      
c0d07adc:	4d0b      	ldr	r5, [pc, #44]	; (c0d07b0c <USBD_WEBUSB_DataOut+0x40>)
c0d07ade:	79a8      	ldrb	r0, [r5, #6]
c0d07ae0:	2800      	cmp	r0, #0
c0d07ae2:	d111      	bne.n	c0d07b08 <USBD_WEBUSB_DataOut+0x3c>
c0d07ae4:	2003      	movs	r0, #3
      // add to the hid transport
      switch(io_usb_hid_receive(io_usb_send_apdu_data_ep0x83, buffer, io_seproxyhal_get_ep_rx_size(WEBUSB_EPOUT_ADDR))) {
c0d07ae6:	f7fa fba1 	bl	c0d0222c <io_seproxyhal_get_ep_rx_size>
c0d07aea:	4602      	mov	r2, r0
c0d07aec:	4809      	ldr	r0, [pc, #36]	; (c0d07b14 <USBD_WEBUSB_DataOut+0x48>)
c0d07aee:	4478      	add	r0, pc
c0d07af0:	4621      	mov	r1, r4
c0d07af2:	f7fa ff4d 	bl	c0d02990 <io_usb_hid_receive>
c0d07af6:	2802      	cmp	r0, #2
c0d07af8:	d106      	bne.n	c0d07b08 <USBD_WEBUSB_DataOut+0x3c>
c0d07afa:	200b      	movs	r0, #11
        default:
          break;

        case IO_USB_APDU_RECEIVED:
          G_io_app.apdu_media = IO_APDU_MEDIA_USB_WEBUSB; // for application code
          G_io_app.apdu_state = APDU_USB_WEBUSB; // for next call to io_exchange
c0d07afc:	7028      	strb	r0, [r5, #0]
c0d07afe:	2005      	movs	r0, #5
          G_io_app.apdu_media = IO_APDU_MEDIA_USB_WEBUSB; // for application code
c0d07b00:	71a8      	strb	r0, [r5, #6]
          G_io_app.apdu_length = G_io_usb_hid_total_length;
c0d07b02:	4803      	ldr	r0, [pc, #12]	; (c0d07b10 <USBD_WEBUSB_DataOut+0x44>)
c0d07b04:	6800      	ldr	r0, [r0, #0]
c0d07b06:	8068      	strh	r0, [r5, #2]
c0d07b08:	2000      	movs	r0, #0
      }
    }
    break;
  }

  return USBD_OK;
c0d07b0a:	bdb0      	pop	{r4, r5, r7, pc}
c0d07b0c:	200003d8 	.word	0x200003d8
c0d07b10:	20000480 	.word	0x20000480
c0d07b14:	ffffa813 	.word	0xffffa813

c0d07b18 <USBD_DeviceDescriptor>:
{
c0d07b18:	2012      	movs	r0, #18
  *length = sizeof(USBD_DeviceDesc);
c0d07b1a:	8008      	strh	r0, [r1, #0]
  return (uint8_t*)USBD_DeviceDesc;
c0d07b1c:	4801      	ldr	r0, [pc, #4]	; (c0d07b24 <USBD_DeviceDescriptor+0xc>)
c0d07b1e:	4478      	add	r0, pc
c0d07b20:	4770      	bx	lr
c0d07b22:	46c0      	nop			; (mov r8, r8)
c0d07b24:	00002482 	.word	0x00002482

c0d07b28 <USBD_LangIDStrDescriptor>:
{
c0d07b28:	2004      	movs	r0, #4
  *length = sizeof(USBD_LangIDDesc);  
c0d07b2a:	8008      	strh	r0, [r1, #0]
  return (uint8_t*)USBD_LangIDDesc;
c0d07b2c:	4801      	ldr	r0, [pc, #4]	; (c0d07b34 <USBD_LangIDStrDescriptor+0xc>)
c0d07b2e:	4478      	add	r0, pc
c0d07b30:	4770      	bx	lr
c0d07b32:	46c0      	nop			; (mov r8, r8)
c0d07b34:	00002484 	.word	0x00002484

c0d07b38 <USBD_ManufacturerStrDescriptor>:
{
c0d07b38:	200e      	movs	r0, #14
  *length = sizeof(USBD_MANUFACTURER_STRING);
c0d07b3a:	8008      	strh	r0, [r1, #0]
  return (uint8_t*)USBD_MANUFACTURER_STRING;
c0d07b3c:	4801      	ldr	r0, [pc, #4]	; (c0d07b44 <USBD_ManufacturerStrDescriptor+0xc>)
c0d07b3e:	4478      	add	r0, pc
c0d07b40:	4770      	bx	lr
c0d07b42:	46c0      	nop			; (mov r8, r8)
c0d07b44:	00002478 	.word	0x00002478

c0d07b48 <USBD_ProductStrDescriptor>:
{
c0d07b48:	200e      	movs	r0, #14
  *length = sizeof(USBD_PRODUCT_FS_STRING);
c0d07b4a:	8008      	strh	r0, [r1, #0]
  return (uint8_t*)USBD_PRODUCT_FS_STRING;
c0d07b4c:	4801      	ldr	r0, [pc, #4]	; (c0d07b54 <USBD_ProductStrDescriptor+0xc>)
c0d07b4e:	4478      	add	r0, pc
c0d07b50:	4770      	bx	lr
c0d07b52:	46c0      	nop			; (mov r8, r8)
c0d07b54:	00002476 	.word	0x00002476

c0d07b58 <USBD_SerialStrDescriptor>:
{
c0d07b58:	200a      	movs	r0, #10
  *length = sizeof(USB_SERIAL_STRING);
c0d07b5a:	8008      	strh	r0, [r1, #0]
  return (uint8_t*)USB_SERIAL_STRING;
c0d07b5c:	4801      	ldr	r0, [pc, #4]	; (c0d07b64 <USBD_SerialStrDescriptor+0xc>)
c0d07b5e:	4478      	add	r0, pc
c0d07b60:	4770      	bx	lr
c0d07b62:	46c0      	nop			; (mov r8, r8)
c0d07b64:	00002474 	.word	0x00002474

c0d07b68 <USBD_ConfigStrDescriptor>:
{
c0d07b68:	200e      	movs	r0, #14
  *length = sizeof(USBD_CONFIGURATION_FS_STRING);
c0d07b6a:	8008      	strh	r0, [r1, #0]
  return (uint8_t*)USBD_CONFIGURATION_FS_STRING;
c0d07b6c:	4801      	ldr	r0, [pc, #4]	; (c0d07b74 <USBD_ConfigStrDescriptor+0xc>)
c0d07b6e:	4478      	add	r0, pc
c0d07b70:	4770      	bx	lr
c0d07b72:	46c0      	nop			; (mov r8, r8)
c0d07b74:	00002456 	.word	0x00002456

c0d07b78 <USBD_InterfaceStrDescriptor>:
{
c0d07b78:	200e      	movs	r0, #14
  *length = sizeof(USBD_INTERFACE_FS_STRING);
c0d07b7a:	8008      	strh	r0, [r1, #0]
  return (uint8_t*)USBD_INTERFACE_FS_STRING;
c0d07b7c:	4801      	ldr	r0, [pc, #4]	; (c0d07b84 <USBD_InterfaceStrDescriptor+0xc>)
c0d07b7e:	4478      	add	r0, pc
c0d07b80:	4770      	bx	lr
c0d07b82:	46c0      	nop			; (mov r8, r8)
c0d07b84:	00002446 	.word	0x00002446

c0d07b88 <USBD_BOSDescriptor>:
};

#endif // HAVE_WEBUSB

static uint8_t *USBD_BOSDescriptor(USBD_SpeedTypeDef speed, uint16_t *length)
{
c0d07b88:	2039      	movs	r0, #57	; 0x39
  UNUSED(speed);
#ifdef HAVE_WEBUSB
  *length = sizeof(C_usb_bos);
c0d07b8a:	8008      	strh	r0, [r1, #0]
  return (uint8_t*)C_usb_bos;
c0d07b8c:	4801      	ldr	r0, [pc, #4]	; (c0d07b94 <USBD_BOSDescriptor+0xc>)
c0d07b8e:	4478      	add	r0, pc
c0d07b90:	4770      	bx	lr
c0d07b92:	46c0      	nop			; (mov r8, r8)
c0d07b94:	000021b7 	.word	0x000021b7

c0d07b98 <USBD_CtlError>:
  '4', 0x00, '6', 0x00, '7', 0x00, '6', 0x00, '5', 0x00, '7', 0x00,
  '2', 0x00, '}', 0x00, 0x00, 0x00, 0x00, 0x00 // propertyData, double unicode nul terminated
};

// upon unsupported request, check for webusb request
void USBD_CtlError( USBD_HandleTypeDef *pdev , USBD_SetupReqTypedef *req) {
c0d07b98:	b580      	push	{r7, lr}
    USBD_CtlSendData (pdev, (unsigned char*)C_webusb_url_descriptor, MIN(req->wLength, sizeof(C_webusb_url_descriptor)));
  }
  else 
#endif // WEBUSB_URL_SIZE_B
    // SETUP (LE): 0x80 0x06 0x03 0x77 0x00 0x00 0xXX 0xXX
    if ((req->bmRequest & 0x80) 
c0d07b9a:	780a      	ldrb	r2, [r1, #0]
c0d07b9c:	b252      	sxtb	r2, r2
    && req->bRequest == USB_REQ_GET_DESCRIPTOR 
c0d07b9e:	2a00      	cmp	r2, #0
c0d07ba0:	d402      	bmi.n	c0d07ba8 <USBD_CtlError+0x10>
      && req->bRequest == WINUSB_VENDOR_CODE
      && req->wIndex == MS_OS_20_DESCRIPTOR_INDEX) {
    USBD_CtlSendData(pdev, (unsigned char*)C_winusb_request_descriptor, MIN(req->wLength, sizeof(C_winusb_request_descriptor)));
  }
  else {
    USBD_CtlStall(pdev);
c0d07ba2:	f7ff fe43 	bl	c0d0782c <USBD_CtlStall>
  }
}
c0d07ba6:	bd80      	pop	{r7, pc}
    && req->bRequest == USB_REQ_GET_DESCRIPTOR 
c0d07ba8:	784a      	ldrb	r2, [r1, #1]
    && (req->wValue>>8) == USB_DESC_TYPE_STRING 
c0d07baa:	2a77      	cmp	r2, #119	; 0x77
c0d07bac:	d00c      	beq.n	c0d07bc8 <USBD_CtlError+0x30>
c0d07bae:	2a06      	cmp	r2, #6
c0d07bb0:	d1f7      	bne.n	c0d07ba2 <USBD_CtlError+0xa>
c0d07bb2:	884a      	ldrh	r2, [r1, #2]
c0d07bb4:	4b14      	ldr	r3, [pc, #80]	; (c0d07c08 <USBD_CtlError+0x70>)
    && (req->wValue & 0xFF) == 0xEE) {
c0d07bb6:	429a      	cmp	r2, r3
c0d07bb8:	d1f3      	bne.n	c0d07ba2 <USBD_CtlError+0xa>
    USBD_CtlSendData(pdev, (unsigned char*)C_winusb_string_descriptor, MIN(req->wLength, sizeof(C_winusb_string_descriptor)));
c0d07bba:	88ca      	ldrh	r2, [r1, #6]
c0d07bbc:	2a12      	cmp	r2, #18
c0d07bbe:	d300      	bcc.n	c0d07bc2 <USBD_CtlError+0x2a>
c0d07bc0:	2212      	movs	r2, #18
c0d07bc2:	4912      	ldr	r1, [pc, #72]	; (c0d07c0c <USBD_CtlError+0x74>)
c0d07bc4:	4479      	add	r1, pc
c0d07bc6:	e01c      	b.n	c0d07c02 <USBD_CtlError+0x6a>
    && req->wIndex == WINUSB_GET_COMPATIBLE_ID_FEATURE) {
c0d07bc8:	888a      	ldrh	r2, [r1, #4]
  else if ((req->bmRequest & 0x80) 
c0d07bca:	2a04      	cmp	r2, #4
c0d07bcc:	d106      	bne.n	c0d07bdc <USBD_CtlError+0x44>
    USBD_CtlSendData(pdev, (unsigned char*)C_winusb_wcid, MIN(req->wLength, sizeof(C_winusb_wcid)));
c0d07bce:	88ca      	ldrh	r2, [r1, #6]
c0d07bd0:	2a28      	cmp	r2, #40	; 0x28
c0d07bd2:	d300      	bcc.n	c0d07bd6 <USBD_CtlError+0x3e>
c0d07bd4:	2228      	movs	r2, #40	; 0x28
c0d07bd6:	490e      	ldr	r1, [pc, #56]	; (c0d07c10 <USBD_CtlError+0x78>)
c0d07bd8:	4479      	add	r1, pc
c0d07bda:	e012      	b.n	c0d07c02 <USBD_CtlError+0x6a>
    && req->wIndex == WINUSB_GET_EXTENDED_PROPERTIES_OS_FEATURE 
c0d07bdc:	888a      	ldrh	r2, [r1, #4]
  else if ((req->bmRequest & 0x80) 
c0d07bde:	2a05      	cmp	r2, #5
c0d07be0:	d106      	bne.n	c0d07bf0 <USBD_CtlError+0x58>
    USBD_CtlSendData(pdev, (unsigned char*)C_winusb_guid, MIN(req->wLength, sizeof(C_winusb_guid)));
c0d07be2:	88ca      	ldrh	r2, [r1, #6]
c0d07be4:	2a92      	cmp	r2, #146	; 0x92
c0d07be6:	d300      	bcc.n	c0d07bea <USBD_CtlError+0x52>
c0d07be8:	2292      	movs	r2, #146	; 0x92
c0d07bea:	490a      	ldr	r1, [pc, #40]	; (c0d07c14 <USBD_CtlError+0x7c>)
c0d07bec:	4479      	add	r1, pc
c0d07bee:	e008      	b.n	c0d07c02 <USBD_CtlError+0x6a>
      && req->wIndex == MS_OS_20_DESCRIPTOR_INDEX) {
c0d07bf0:	888a      	ldrh	r2, [r1, #4]
  else if ((req->bmRequest & 0x80)
c0d07bf2:	2a07      	cmp	r2, #7
c0d07bf4:	d1d5      	bne.n	c0d07ba2 <USBD_CtlError+0xa>
    USBD_CtlSendData(pdev, (unsigned char*)C_winusb_request_descriptor, MIN(req->wLength, sizeof(C_winusb_request_descriptor)));
c0d07bf6:	88ca      	ldrh	r2, [r1, #6]
c0d07bf8:	2ab2      	cmp	r2, #178	; 0xb2
c0d07bfa:	d300      	bcc.n	c0d07bfe <USBD_CtlError+0x66>
c0d07bfc:	22b2      	movs	r2, #178	; 0xb2
c0d07bfe:	4906      	ldr	r1, [pc, #24]	; (c0d07c18 <USBD_CtlError+0x80>)
c0d07c00:	4479      	add	r1, pc
c0d07c02:	f000 f865 	bl	c0d07cd0 <USBD_CtlSendData>
}
c0d07c06:	bd80      	pop	{r7, pc}
c0d07c08:	000003ee 	.word	0x000003ee
c0d07c0c:	000021dc 	.word	0x000021dc
c0d07c10:	00002404 	.word	0x00002404
c0d07c14:	000021c6 	.word	0x000021c6
c0d07c18:	00002244 	.word	0x00002244

c0d07c1c <USB_power>:
  // nothing to do ?
  return 0;
}
#endif // HAVE_USB_CLASS_CCID

void USB_power(unsigned char enabled) {
c0d07c1c:	b5b0      	push	{r4, r5, r7, lr}
c0d07c1e:	4604      	mov	r4, r0
  memset(&USBD_Device, 0, sizeof(USBD_Device));
c0d07c20:	481b      	ldr	r0, [pc, #108]	; (c0d07c90 <USB_power+0x74>)
c0d07c22:	21d4      	movs	r1, #212	; 0xd4
c0d07c24:	f000 fc72 	bl	c0d0850c <__aeabi_memclr>

  // init timeouts and other global fields
  memset(G_io_app.usb_ep_xfer_len, 0, sizeof(G_io_app.usb_ep_xfer_len));
c0d07c28:	481a      	ldr	r0, [pc, #104]	; (c0d07c94 <USB_power+0x78>)
c0d07c2a:	2100      	movs	r1, #0
c0d07c2c:	60c1      	str	r1, [r0, #12]
  memset(G_io_app.usb_ep_timeouts, 0, sizeof(G_io_app.usb_ep_timeouts));
c0d07c2e:	6101      	str	r1, [r0, #16]
c0d07c30:	6141      	str	r1, [r0, #20]

  if (enabled) {
c0d07c32:	2c00      	cmp	r4, #0
c0d07c34:	d027      	beq.n	c0d07c86 <USB_power+0x6a>
    memset(&USBD_Device, 0, sizeof(USBD_Device));
c0d07c36:	4c16      	ldr	r4, [pc, #88]	; (c0d07c90 <USB_power+0x74>)
c0d07c38:	21d4      	movs	r1, #212	; 0xd4
c0d07c3a:	4620      	mov	r0, r4
c0d07c3c:	f000 fc66 	bl	c0d0850c <__aeabi_memclr>
    /* Init Device Library */
    USBD_Init(&USBD_Device, (USBD_DescriptorsTypeDef*)&HID_Desc, 0);
c0d07c40:	4917      	ldr	r1, [pc, #92]	; (c0d07ca0 <USB_power+0x84>)
c0d07c42:	4479      	add	r1, pc
c0d07c44:	2500      	movs	r5, #0
c0d07c46:	4620      	mov	r0, r4
c0d07c48:	462a      	mov	r2, r5
c0d07c4a:	f7ff f9f7 	bl	c0d0703c <USBD_Init>
    
    /* Register the HID class */
    USBD_RegisterClassForInterface(HID_INTF,  &USBD_Device, (USBD_ClassTypeDef*)&USBD_HID);
c0d07c4e:	4a15      	ldr	r2, [pc, #84]	; (c0d07ca4 <USB_power+0x88>)
c0d07c50:	447a      	add	r2, pc
c0d07c52:	4628      	mov	r0, r5
c0d07c54:	4621      	mov	r1, r4
c0d07c56:	f7ff fa26 	bl	c0d070a6 <USBD_RegisterClassForInterface>
c0d07c5a:	2001      	movs	r0, #1
#ifdef HAVE_IO_U2F
    USBD_RegisterClassForInterface(U2F_INTF,  &USBD_Device, (USBD_ClassTypeDef*)&USBD_U2F);
c0d07c5c:	4a12      	ldr	r2, [pc, #72]	; (c0d07ca8 <USB_power+0x8c>)
c0d07c5e:	447a      	add	r2, pc
c0d07c60:	4621      	mov	r1, r4
c0d07c62:	f7ff fa20 	bl	c0d070a6 <USBD_RegisterClassForInterface>
c0d07c66:	22ff      	movs	r2, #255	; 0xff
c0d07c68:	3252      	adds	r2, #82	; 0x52
    // initialize the U2F tunnel transport
    u2f_transport_init(&G_io_u2f, G_io_apdu_buffer, IO_APDU_BUFFER_SIZE);
c0d07c6a:	480b      	ldr	r0, [pc, #44]	; (c0d07c98 <USB_power+0x7c>)
c0d07c6c:	490b      	ldr	r1, [pc, #44]	; (c0d07c9c <USB_power+0x80>)
c0d07c6e:	f7fd ffd7 	bl	c0d05c20 <u2f_transport_init>
c0d07c72:	2002      	movs	r0, #2
#ifdef HAVE_USB_CLASS_CCID
    USBD_RegisterClassForInterface(CCID_INTF, &USBD_Device, (USBD_ClassTypeDef*)&USBD_CCID);
#endif // HAVE_USB_CLASS_CCID

#ifdef HAVE_WEBUSB
    USBD_RegisterClassForInterface(WEBUSB_INTF, &USBD_Device, (USBD_ClassTypeDef*)&USBD_WEBUSB);
c0d07c74:	4a0d      	ldr	r2, [pc, #52]	; (c0d07cac <USB_power+0x90>)
c0d07c76:	447a      	add	r2, pc
c0d07c78:	4621      	mov	r1, r4
c0d07c7a:	f7ff fa14 	bl	c0d070a6 <USBD_RegisterClassForInterface>
#endif // HAVE_WEBUSB

    /* Start Device Process */
    USBD_Start(&USBD_Device);
c0d07c7e:	4620      	mov	r0, r4
c0d07c80:	f7ff fa1e 	bl	c0d070c0 <USBD_Start>
  }
  else {
    USBD_DeInit(&USBD_Device);
  }
}
c0d07c84:	bdb0      	pop	{r4, r5, r7, pc}
    USBD_DeInit(&USBD_Device);
c0d07c86:	4802      	ldr	r0, [pc, #8]	; (c0d07c90 <USB_power+0x74>)
c0d07c88:	f7ff f9f2 	bl	c0d07070 <USBD_DeInit>
}
c0d07c8c:	bdb0      	pop	{r4, r5, r7, pc}
c0d07c8e:	46c0      	nop			; (mov r8, r8)
c0d07c90:	200009e0 	.word	0x200009e0
c0d07c94:	200003d8 	.word	0x200003d8
c0d07c98:	200003f8 	.word	0x200003f8
c0d07c9c:	20000285 	.word	0x20000285
c0d07ca0:	0000213e 	.word	0x0000213e
c0d07ca4:	000022a8 	.word	0x000022a8
c0d07ca8:	000022d2 	.word	0x000022d2
c0d07cac:	000022f2 	.word	0x000022f2

c0d07cb0 <USBD_GetCfgDesc_impl>:
{
c0d07cb0:	2160      	movs	r1, #96	; 0x60
  *length = sizeof (USBD_CfgDesc);
c0d07cb2:	8001      	strh	r1, [r0, #0]
  return (uint8_t*)USBD_CfgDesc;
c0d07cb4:	4801      	ldr	r0, [pc, #4]	; (c0d07cbc <USBD_GetCfgDesc_impl+0xc>)
c0d07cb6:	4478      	add	r0, pc
c0d07cb8:	4770      	bx	lr
c0d07cba:	46c0      	nop			; (mov r8, r8)
c0d07cbc:	0000234e 	.word	0x0000234e

c0d07cc0 <USBD_GetDeviceQualifierDesc_impl>:
{
c0d07cc0:	210a      	movs	r1, #10
  *length = sizeof (USBD_DeviceQualifierDesc);
c0d07cc2:	8001      	strh	r1, [r0, #0]
  return (uint8_t*)USBD_DeviceQualifierDesc;
c0d07cc4:	4801      	ldr	r0, [pc, #4]	; (c0d07ccc <USBD_GetDeviceQualifierDesc_impl+0xc>)
c0d07cc6:	4478      	add	r0, pc
c0d07cc8:	4770      	bx	lr
c0d07cca:	46c0      	nop			; (mov r8, r8)
c0d07ccc:	0000239e 	.word	0x0000239e

c0d07cd0 <USBD_CtlSendData>:
* @retval status
*/
USBD_StatusTypeDef  USBD_CtlSendData (USBD_HandleTypeDef  *pdev, 
                               uint8_t *pbuf,
                               uint16_t len)
{
c0d07cd0:	b5b0      	push	{r4, r5, r7, lr}
c0d07cd2:	460c      	mov	r4, r1
c0d07cd4:	2194      	movs	r1, #148	; 0x94
c0d07cd6:	2302      	movs	r3, #2
  /* Set EP0 State */
  pdev->ep0_state          = USBD_EP0_DATA_IN;                                      
c0d07cd8:	5043      	str	r3, [r0, r1]
  pdev->ep_in[0].total_length = len;
c0d07cda:	6182      	str	r2, [r0, #24]
  pdev->ep_in[0].rem_length   = len;
c0d07cdc:	61c2      	str	r2, [r0, #28]
c0d07cde:	4601      	mov	r1, r0
c0d07ce0:	3194      	adds	r1, #148	; 0x94
  // store the continuation data if needed
  pdev->pData = pbuf;
c0d07ce2:	63cc      	str	r4, [r1, #60]	; 0x3c
 /* Start the transfer */
  USBD_LL_Transmit (pdev, 0x00, pbuf, MIN(len, pdev->ep_in[0].maxpacket));  
c0d07ce4:	6a01      	ldr	r1, [r0, #32]
c0d07ce6:	4291      	cmp	r1, r2
c0d07ce8:	d800      	bhi.n	c0d07cec <USBD_CtlSendData+0x1c>
c0d07cea:	460a      	mov	r2, r1
c0d07cec:	b293      	uxth	r3, r2
c0d07cee:	2500      	movs	r5, #0
c0d07cf0:	4629      	mov	r1, r5
c0d07cf2:	4622      	mov	r2, r4
c0d07cf4:	f7ff f976 	bl	c0d06fe4 <USBD_LL_Transmit>
  
  return USBD_OK;
c0d07cf8:	4628      	mov	r0, r5
c0d07cfa:	bdb0      	pop	{r4, r5, r7, pc}

c0d07cfc <USBD_CtlContinueSendData>:
* @retval status
*/
USBD_StatusTypeDef  USBD_CtlContinueSendData (USBD_HandleTypeDef  *pdev, 
                                       uint8_t *pbuf,
                                       uint16_t len)
{
c0d07cfc:	b5b0      	push	{r4, r5, r7, lr}
c0d07cfe:	460c      	mov	r4, r1
 /* Start the next transfer */
  USBD_LL_Transmit (pdev, 0x00, pbuf, MIN(len, pdev->ep_in[0].maxpacket));   
c0d07d00:	6a01      	ldr	r1, [r0, #32]
c0d07d02:	4291      	cmp	r1, r2
c0d07d04:	d800      	bhi.n	c0d07d08 <USBD_CtlContinueSendData+0xc>
c0d07d06:	460a      	mov	r2, r1
c0d07d08:	b293      	uxth	r3, r2
c0d07d0a:	2500      	movs	r5, #0
c0d07d0c:	4629      	mov	r1, r5
c0d07d0e:	4622      	mov	r2, r4
c0d07d10:	f7ff f968 	bl	c0d06fe4 <USBD_LL_Transmit>
  return USBD_OK;
c0d07d14:	4628      	mov	r0, r5
c0d07d16:	bdb0      	pop	{r4, r5, r7, pc}

c0d07d18 <USBD_CtlContinueRx>:
* @retval status
*/
USBD_StatusTypeDef  USBD_CtlContinueRx (USBD_HandleTypeDef  *pdev, 
                                          uint8_t *pbuf,                                          
                                          uint16_t len)
{
c0d07d18:	b510      	push	{r4, lr}
c0d07d1a:	2400      	movs	r4, #0
  UNUSED(pbuf);
  USBD_LL_PrepareReceive (pdev,
c0d07d1c:	4621      	mov	r1, r4
c0d07d1e:	f7ff f97a 	bl	c0d07016 <USBD_LL_PrepareReceive>
                          0,                                            
                          len);
  return USBD_OK;
c0d07d22:	4620      	mov	r0, r4
c0d07d24:	bd10      	pop	{r4, pc}

c0d07d26 <USBD_CtlSendStatus>:
*         send zero lzngth packet on the ctl pipe
* @param  pdev: device instance
* @retval status
*/
USBD_StatusTypeDef  USBD_CtlSendStatus (USBD_HandleTypeDef  *pdev)
{
c0d07d26:	b510      	push	{r4, lr}
c0d07d28:	2194      	movs	r1, #148	; 0x94
c0d07d2a:	2204      	movs	r2, #4

  /* Set EP0 State */
  pdev->ep0_state = USBD_EP0_STATUS_IN;
c0d07d2c:	5042      	str	r2, [r0, r1]
c0d07d2e:	2400      	movs	r4, #0
  
 /* Start the transfer */
  USBD_LL_Transmit (pdev, 0x00, NULL, 0);   
c0d07d30:	4621      	mov	r1, r4
c0d07d32:	4622      	mov	r2, r4
c0d07d34:	4623      	mov	r3, r4
c0d07d36:	f7ff f955 	bl	c0d06fe4 <USBD_LL_Transmit>
  
  return USBD_OK;
c0d07d3a:	4620      	mov	r0, r4
c0d07d3c:	bd10      	pop	{r4, pc}

c0d07d3e <USBD_CtlReceiveStatus>:
*         receive zero lzngth packet on the ctl pipe
* @param  pdev: device instance
* @retval status
*/
USBD_StatusTypeDef  USBD_CtlReceiveStatus (USBD_HandleTypeDef  *pdev)
{
c0d07d3e:	b510      	push	{r4, lr}
c0d07d40:	2194      	movs	r1, #148	; 0x94
c0d07d42:	2205      	movs	r2, #5
  /* Set EP0 State */
  pdev->ep0_state = USBD_EP0_STATUS_OUT; 
c0d07d44:	5042      	str	r2, [r0, r1]
c0d07d46:	2400      	movs	r4, #0
  
 /* Start the transfer */  
  USBD_LL_PrepareReceive ( pdev,
c0d07d48:	4621      	mov	r1, r4
c0d07d4a:	4622      	mov	r2, r4
c0d07d4c:	f7ff f963 	bl	c0d07016 <USBD_LL_PrepareReceive>
                    0,
                    0);  

  return USBD_OK;
c0d07d50:	4620      	mov	r0, r4
c0d07d52:	bd10      	pop	{r4, pc}

c0d07d54 <ux_menu_element_preprocessor>:
    return ux_menu.menu_iterator(entry_idx);
  } 
  return &ux_menu.menu_entries[entry_idx];
} 

const bagl_element_t* ux_menu_element_preprocessor(const bagl_element_t* element) {
c0d07d54:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d07d56:	b083      	sub	sp, #12
c0d07d58:	4607      	mov	r7, r0
  //todo avoid center alignment when text_x or icon_x AND text_x are not 0
  memmove(&G_ux.tmp_element, element, sizeof(bagl_element_t));
c0d07d5a:	4866      	ldr	r0, [pc, #408]	; (c0d07ef4 <ux_menu_element_preprocessor+0x1a0>)
c0d07d5c:	1d06      	adds	r6, r0, #4
c0d07d5e:	2220      	movs	r2, #32
c0d07d60:	4630      	mov	r0, r6
c0d07d62:	4639      	mov	r1, r7
c0d07d64:	f000 fbdb 	bl	c0d0851e <__aeabi_memmove>

  // ask the current entry first, to setup other entries
  const ux_menu_entry_t* current_entry = (const ux_menu_entry_t*)PIC(ux_menu_get_entry(ux_menu.current_entry));
c0d07d68:	4c63      	ldr	r4, [pc, #396]	; (c0d07ef8 <ux_menu_element_preprocessor+0x1a4>)
  if (ux_menu.menu_iterator) {
c0d07d6a:	6921      	ldr	r1, [r4, #16]
  const ux_menu_entry_t* current_entry = (const ux_menu_entry_t*)PIC(ux_menu_get_entry(ux_menu.current_entry));
c0d07d6c:	68a0      	ldr	r0, [r4, #8]
  if (ux_menu.menu_iterator) {
c0d07d6e:	2900      	cmp	r1, #0
c0d07d70:	d001      	beq.n	c0d07d76 <ux_menu_element_preprocessor+0x22>
    return ux_menu.menu_iterator(entry_idx);
c0d07d72:	4788      	blx	r1
c0d07d74:	e003      	b.n	c0d07d7e <ux_menu_element_preprocessor+0x2a>
c0d07d76:	211c      	movs	r1, #28
  return &ux_menu.menu_entries[entry_idx];
c0d07d78:	4341      	muls	r1, r0
c0d07d7a:	6820      	ldr	r0, [r4, #0]
c0d07d7c:	1840      	adds	r0, r0, r1
  const ux_menu_entry_t* current_entry = (const ux_menu_entry_t*)PIC(ux_menu_get_entry(ux_menu.current_entry));
c0d07d7e:	f7fb fad3 	bl	c0d03328 <pic>
  if (current_entry == NULL) {
c0d07d82:	2800      	cmp	r0, #0
c0d07d84:	d100      	bne.n	c0d07d88 <ux_menu_element_preprocessor+0x34>
c0d07d86:	e0a8      	b.n	c0d07eda <ux_menu_element_preprocessor+0x186>
c0d07d88:	4605      	mov	r5, r0
c0d07d8a:	9602      	str	r6, [sp, #8]
    return NULL;
  }
  const bagl_icon_details_t* current_entry_icon = (const bagl_icon_details_t*)PIC(current_entry->icon);
c0d07d8c:	68c0      	ldr	r0, [r0, #12]
c0d07d8e:	f7fb facb 	bl	c0d03328 <pic>
c0d07d92:	9001      	str	r0, [sp, #4]

  const ux_menu_entry_t* previous_entry = NULL;
  if (ux_menu.current_entry) {
c0d07d94:	68a0      	ldr	r0, [r4, #8]
c0d07d96:	2600      	movs	r6, #0
c0d07d98:	2800      	cmp	r0, #0
c0d07d9a:	d005      	beq.n	c0d07da8 <ux_menu_element_preprocessor+0x54>
  if (ux_menu.menu_iterator) {
c0d07d9c:	6921      	ldr	r1, [r4, #16]
    previous_entry = (const ux_menu_entry_t*)PIC(ux_menu_get_entry(ux_menu.current_entry-1));
c0d07d9e:	1e40      	subs	r0, r0, #1
  if (ux_menu.menu_iterator) {
c0d07da0:	2900      	cmp	r1, #0
c0d07da2:	d004      	beq.n	c0d07dae <ux_menu_element_preprocessor+0x5a>
    return ux_menu.menu_iterator(entry_idx);
c0d07da4:	4788      	blx	r1
c0d07da6:	e006      	b.n	c0d07db6 <ux_menu_element_preprocessor+0x62>
  }
  const ux_menu_entry_t* next_entry = NULL;
  if (ux_menu.current_entry < ux_menu.menu_entries_count-1) {
c0d07da8:	4630      	mov	r0, r6
c0d07daa:	4632      	mov	r2, r6
c0d07dac:	e007      	b.n	c0d07dbe <ux_menu_element_preprocessor+0x6a>
c0d07dae:	211c      	movs	r1, #28
  return &ux_menu.menu_entries[entry_idx];
c0d07db0:	4341      	muls	r1, r0
c0d07db2:	6820      	ldr	r0, [r4, #0]
c0d07db4:	1840      	adds	r0, r0, r1
    previous_entry = (const ux_menu_entry_t*)PIC(ux_menu_get_entry(ux_menu.current_entry-1));
c0d07db6:	f7fb fab7 	bl	c0d03328 <pic>
c0d07dba:	4602      	mov	r2, r0
  if (ux_menu.current_entry < ux_menu.menu_entries_count-1) {
c0d07dbc:	68a0      	ldr	r0, [r4, #8]
c0d07dbe:	6861      	ldr	r1, [r4, #4]
c0d07dc0:	1e49      	subs	r1, r1, #1
c0d07dc2:	4288      	cmp	r0, r1
c0d07dc4:	d211      	bcs.n	c0d07dea <ux_menu_element_preprocessor+0x96>
c0d07dc6:	4623      	mov	r3, r4
c0d07dc8:	9200      	str	r2, [sp, #0]
  if (ux_menu.menu_iterator) {
c0d07dca:	6921      	ldr	r1, [r4, #16]
    next_entry = (const ux_menu_entry_t*)PIC(ux_menu_get_entry(ux_menu.current_entry+1));
c0d07dcc:	1c40      	adds	r0, r0, #1
  if (ux_menu.menu_iterator) {
c0d07dce:	2900      	cmp	r1, #0
c0d07dd0:	d002      	beq.n	c0d07dd8 <ux_menu_element_preprocessor+0x84>
c0d07dd2:	461c      	mov	r4, r3
    return ux_menu.menu_iterator(entry_idx);
c0d07dd4:	4788      	blx	r1
c0d07dd6:	e004      	b.n	c0d07de2 <ux_menu_element_preprocessor+0x8e>
c0d07dd8:	211c      	movs	r1, #28
  return &ux_menu.menu_entries[entry_idx];
c0d07dda:	4341      	muls	r1, r0
c0d07ddc:	461c      	mov	r4, r3
c0d07dde:	6818      	ldr	r0, [r3, #0]
c0d07de0:	1840      	adds	r0, r0, r1
    next_entry = (const ux_menu_entry_t*)PIC(ux_menu_get_entry(ux_menu.current_entry+1));
c0d07de2:	f7fb faa1 	bl	c0d03328 <pic>
c0d07de6:	4606      	mov	r6, r0
c0d07de8:	9a00      	ldr	r2, [sp, #0]
  }

  switch(element->component.userid) {
c0d07dea:	7878      	ldrb	r0, [r7, #1]
c0d07dec:	2840      	cmp	r0, #64	; 0x40
c0d07dee:	dc09      	bgt.n	c0d07e04 <ux_menu_element_preprocessor+0xb0>
c0d07df0:	2820      	cmp	r0, #32
c0d07df2:	dc21      	bgt.n	c0d07e38 <ux_menu_element_preprocessor+0xe4>
c0d07df4:	2810      	cmp	r0, #16
c0d07df6:	d02f      	beq.n	c0d07e58 <ux_menu_element_preprocessor+0x104>
c0d07df8:	2820      	cmp	r0, #32
c0d07dfa:	d170      	bne.n	c0d07ede <ux_menu_element_preprocessor+0x18a>
      if (current_entry->icon_x) {
        G_ux.tmp_element.component.x = current_entry->icon_x;
      }
      break;
    case 0x20:
      if (current_entry->line2 != NULL) {
c0d07dfc:	6968      	ldr	r0, [r5, #20]
c0d07dfe:	2800      	cmp	r0, #0
c0d07e00:	d16b      	bne.n	c0d07eda <ux_menu_element_preprocessor+0x186>
c0d07e02:	e050      	b.n	c0d07ea6 <ux_menu_element_preprocessor+0x152>
  switch(element->component.userid) {
c0d07e04:	2880      	cmp	r0, #128	; 0x80
c0d07e06:	dc1f      	bgt.n	c0d07e48 <ux_menu_element_preprocessor+0xf4>
c0d07e08:	2841      	cmp	r0, #65	; 0x41
c0d07e0a:	d030      	beq.n	c0d07e6e <ux_menu_element_preprocessor+0x11a>
c0d07e0c:	2842      	cmp	r0, #66	; 0x42
c0d07e0e:	d166      	bne.n	c0d07ede <ux_menu_element_preprocessor+0x18a>
      if (current_entry->line2 != NULL
c0d07e10:	6969      	ldr	r1, [r5, #20]
c0d07e12:	2000      	movs	r0, #0
        || current_entry->icon != NULL
c0d07e14:	2900      	cmp	r1, #0
c0d07e16:	d16a      	bne.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
c0d07e18:	68e9      	ldr	r1, [r5, #12]
        || ux_menu.current_entry == ux_menu.menu_entries_count-1
c0d07e1a:	2900      	cmp	r1, #0
c0d07e1c:	d167      	bne.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
        || ux_menu.menu_entries_count == 1
c0d07e1e:	2e00      	cmp	r6, #0
c0d07e20:	d065      	beq.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
c0d07e22:	6861      	ldr	r1, [r4, #4]
c0d07e24:	1e49      	subs	r1, r1, #1
c0d07e26:	d062      	beq.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
c0d07e28:	68a2      	ldr	r2, [r4, #8]
c0d07e2a:	428a      	cmp	r2, r1
c0d07e2c:	d05f      	beq.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
        || next_entry->icon != NULL) {
c0d07e2e:	68f1      	ldr	r1, [r6, #12]
      if (current_entry->line2 != NULL
c0d07e30:	2900      	cmp	r1, #0
c0d07e32:	d15c      	bne.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
      G_ux.tmp_element.text = next_entry->line1;
c0d07e34:	6930      	ldr	r0, [r6, #16]
c0d07e36:	e030      	b.n	c0d07e9a <ux_menu_element_preprocessor+0x146>
  switch(element->component.userid) {
c0d07e38:	2821      	cmp	r0, #33	; 0x21
c0d07e3a:	d031      	beq.n	c0d07ea0 <ux_menu_element_preprocessor+0x14c>
c0d07e3c:	2822      	cmp	r0, #34	; 0x22
c0d07e3e:	d14e      	bne.n	c0d07ede <ux_menu_element_preprocessor+0x18a>
        return NULL;
      }
      G_ux.tmp_element.text = current_entry->line1;
      goto adjust_text_x;
    case 0x22:
      if (current_entry->line2 == NULL) {
c0d07e40:	6968      	ldr	r0, [r5, #20]
c0d07e42:	2800      	cmp	r0, #0
c0d07e44:	d130      	bne.n	c0d07ea8 <ux_menu_element_preprocessor+0x154>
c0d07e46:	e048      	b.n	c0d07eda <ux_menu_element_preprocessor+0x186>
  switch(element->component.userid) {
c0d07e48:	2882      	cmp	r0, #130	; 0x82
c0d07e4a:	d041      	beq.n	c0d07ed0 <ux_menu_element_preprocessor+0x17c>
c0d07e4c:	2881      	cmp	r0, #129	; 0x81
c0d07e4e:	d146      	bne.n	c0d07ede <ux_menu_element_preprocessor+0x18a>
      if (ux_menu.current_entry == 0) {
c0d07e50:	68a0      	ldr	r0, [r4, #8]
c0d07e52:	2800      	cmp	r0, #0
c0d07e54:	d143      	bne.n	c0d07ede <ux_menu_element_preprocessor+0x18a>
c0d07e56:	e040      	b.n	c0d07eda <ux_menu_element_preprocessor+0x186>
      if (current_entry->icon == NULL) {
c0d07e58:	68e8      	ldr	r0, [r5, #12]
c0d07e5a:	2800      	cmp	r0, #0
c0d07e5c:	d03d      	beq.n	c0d07eda <ux_menu_element_preprocessor+0x186>
      G_ux.tmp_element.text = (const char*)current_entry->icon;
c0d07e5e:	4925      	ldr	r1, [pc, #148]	; (c0d07ef4 <ux_menu_element_preprocessor+0x1a0>)
c0d07e60:	6208      	str	r0, [r1, #32]
      if (current_entry->icon_x) {
c0d07e62:	7e68      	ldrb	r0, [r5, #25]
c0d07e64:	2800      	cmp	r0, #0
c0d07e66:	d03a      	beq.n	c0d07ede <ux_menu_element_preprocessor+0x18a>
        G_ux.tmp_element.component.x = current_entry->icon_x;
c0d07e68:	4922      	ldr	r1, [pc, #136]	; (c0d07ef4 <ux_menu_element_preprocessor+0x1a0>)
c0d07e6a:	80c8      	strh	r0, [r1, #6]
c0d07e6c:	e037      	b.n	c0d07ede <ux_menu_element_preprocessor+0x18a>
      if (current_entry->line2 != NULL
c0d07e6e:	6969      	ldr	r1, [r5, #20]
c0d07e70:	2000      	movs	r0, #0
        || current_entry->icon != NULL
c0d07e72:	2900      	cmp	r1, #0
c0d07e74:	d13b      	bne.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
        || ux_menu.current_entry == 0
c0d07e76:	2a00      	cmp	r2, #0
c0d07e78:	d039      	beq.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
c0d07e7a:	68e9      	ldr	r1, [r5, #12]
c0d07e7c:	2900      	cmp	r1, #0
c0d07e7e:	d136      	bne.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
c0d07e80:	68a1      	ldr	r1, [r4, #8]
c0d07e82:	2900      	cmp	r1, #0
c0d07e84:	d033      	beq.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
c0d07e86:	6861      	ldr	r1, [r4, #4]
c0d07e88:	2901      	cmp	r1, #1
c0d07e8a:	d030      	beq.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
        || previous_entry->icon != NULL
c0d07e8c:	68d1      	ldr	r1, [r2, #12]
        || previous_entry->line2 != NULL) {
c0d07e8e:	2900      	cmp	r1, #0
c0d07e90:	d12d      	bne.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
c0d07e92:	6951      	ldr	r1, [r2, #20]
      if (current_entry->line2 != NULL
c0d07e94:	2900      	cmp	r1, #0
c0d07e96:	d12a      	bne.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
      G_ux.tmp_element.text = previous_entry->line1;
c0d07e98:	6910      	ldr	r0, [r2, #16]
c0d07e9a:	4916      	ldr	r1, [pc, #88]	; (c0d07ef4 <ux_menu_element_preprocessor+0x1a0>)
c0d07e9c:	6208      	str	r0, [r1, #32]
c0d07e9e:	e01e      	b.n	c0d07ede <ux_menu_element_preprocessor+0x18a>
      if (current_entry->line2 == NULL) {
c0d07ea0:	6968      	ldr	r0, [r5, #20]
c0d07ea2:	2800      	cmp	r0, #0
c0d07ea4:	d019      	beq.n	c0d07eda <ux_menu_element_preprocessor+0x186>
c0d07ea6:	6928      	ldr	r0, [r5, #16]
c0d07ea8:	4a12      	ldr	r2, [pc, #72]	; (c0d07ef4 <ux_menu_element_preprocessor+0x1a0>)
c0d07eaa:	6210      	str	r0, [r2, #32]
c0d07eac:	9801      	ldr	r0, [sp, #4]
        return NULL;
      }
      G_ux.tmp_element.text = current_entry->line2;
    adjust_text_x:
      if (current_entry_icon) {
c0d07eae:	2800      	cmp	r0, #0
c0d07eb0:	d006      	beq.n	c0d07ec0 <ux_menu_element_preprocessor+0x16c>
        G_ux.tmp_element.component.x += current_entry_icon->width;
c0d07eb2:	8800      	ldrh	r0, [r0, #0]
c0d07eb4:	88d1      	ldrh	r1, [r2, #6]
c0d07eb6:	1809      	adds	r1, r1, r0
c0d07eb8:	80d1      	strh	r1, [r2, #6]
        G_ux.tmp_element.component.width -= current_entry_icon->width;
c0d07eba:	8951      	ldrh	r1, [r2, #10]
c0d07ebc:	1a08      	subs	r0, r1, r0
c0d07ebe:	8150      	strh	r0, [r2, #10]
      }
      if (current_entry->text_x) {
c0d07ec0:	7e28      	ldrb	r0, [r5, #24]
c0d07ec2:	2800      	cmp	r0, #0
c0d07ec4:	d00b      	beq.n	c0d07ede <ux_menu_element_preprocessor+0x18a>
c0d07ec6:	2108      	movs	r1, #8
c0d07ec8:	4a0a      	ldr	r2, [pc, #40]	; (c0d07ef4 <ux_menu_element_preprocessor+0x1a0>)
        G_ux.tmp_element.component.x = current_entry->text_x;
        // discard the 'center' flag
        G_ux.tmp_element.component.font_id = BAGL_FONT_OPEN_SANS_EXTRABOLD_11px;
c0d07eca:	8391      	strh	r1, [r2, #28]
        G_ux.tmp_element.component.x = current_entry->text_x;
c0d07ecc:	80d0      	strh	r0, [r2, #6]
c0d07ece:	e006      	b.n	c0d07ede <ux_menu_element_preprocessor+0x18a>
      if (ux_menu.current_entry == ux_menu.menu_entries_count-1) {
c0d07ed0:	6860      	ldr	r0, [r4, #4]
c0d07ed2:	68a1      	ldr	r1, [r4, #8]
c0d07ed4:	1e40      	subs	r0, r0, #1
c0d07ed6:	4281      	cmp	r1, r0
c0d07ed8:	d101      	bne.n	c0d07ede <ux_menu_element_preprocessor+0x18a>
c0d07eda:	2000      	movs	r0, #0
c0d07edc:	e007      	b.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
      }
      break;
  }
  // ensure prepro agrees to the element to be displayed
  if (ux_menu.menu_entry_preprocessor) {
c0d07ede:	68e2      	ldr	r2, [r4, #12]
c0d07ee0:	2a00      	cmp	r2, #0
c0d07ee2:	9802      	ldr	r0, [sp, #8]
c0d07ee4:	d003      	beq.n	c0d07eee <ux_menu_element_preprocessor+0x19a>
    // menu is denied by the menu entry preprocessor
    return ux_menu.menu_entry_preprocessor(current_entry, &G_ux.tmp_element);
c0d07ee6:	4803      	ldr	r0, [pc, #12]	; (c0d07ef4 <ux_menu_element_preprocessor+0x1a0>)
c0d07ee8:	1d01      	adds	r1, r0, #4
c0d07eea:	4628      	mov	r0, r5
c0d07eec:	4790      	blx	r2
  }

  return &G_ux.tmp_element;
}
c0d07eee:	b003      	add	sp, #12
c0d07ef0:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d07ef2:	46c0      	nop			; (mov r8, r8)
c0d07ef4:	20000968 	.word	0x20000968
c0d07ef8:	20000ab4 	.word	0x20000ab4

c0d07efc <ux_menu_elements_button>:

unsigned int ux_menu_elements_button (unsigned int button_mask, unsigned int button_mask_counter) {
c0d07efc:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d07efe:	b081      	sub	sp, #4
c0d07f00:	4605      	mov	r5, r0
  UNUSED(button_mask_counter);

  const ux_menu_entry_t* current_entry = (const ux_menu_entry_t*)PIC(ux_menu_get_entry(ux_menu.current_entry));
c0d07f02:	4f25      	ldr	r7, [pc, #148]	; (c0d07f98 <ux_menu_elements_button+0x9c>)
  if (ux_menu.menu_iterator) {
c0d07f04:	6939      	ldr	r1, [r7, #16]
  const ux_menu_entry_t* current_entry = (const ux_menu_entry_t*)PIC(ux_menu_get_entry(ux_menu.current_entry));
c0d07f06:	68b8      	ldr	r0, [r7, #8]
  if (ux_menu.menu_iterator) {
c0d07f08:	2900      	cmp	r1, #0
c0d07f0a:	d001      	beq.n	c0d07f10 <ux_menu_elements_button+0x14>
    return ux_menu.menu_iterator(entry_idx);
c0d07f0c:	4788      	blx	r1
c0d07f0e:	e003      	b.n	c0d07f18 <ux_menu_elements_button+0x1c>
c0d07f10:	211c      	movs	r1, #28
  return &ux_menu.menu_entries[entry_idx];
c0d07f12:	4341      	muls	r1, r0
c0d07f14:	6838      	ldr	r0, [r7, #0]
c0d07f16:	1840      	adds	r0, r0, r1
  const ux_menu_entry_t* current_entry = (const ux_menu_entry_t*)PIC(ux_menu_get_entry(ux_menu.current_entry));
c0d07f18:	f7fb fa06 	bl	c0d03328 <pic>
c0d07f1c:	2401      	movs	r4, #1
  if (current_entry == NULL) {
c0d07f1e:	2800      	cmp	r0, #0
c0d07f20:	d037      	beq.n	c0d07f92 <ux_menu_elements_button+0x96>
c0d07f22:	4606      	mov	r6, r0
c0d07f24:	481d      	ldr	r0, [pc, #116]	; (c0d07f9c <ux_menu_elements_button+0xa0>)
    return 1;
  }

  switch (button_mask) {
c0d07f26:	4285      	cmp	r5, r0
c0d07f28:	dd14      	ble.n	c0d07f54 <ux_menu_elements_button+0x58>
c0d07f2a:	481d      	ldr	r0, [pc, #116]	; (c0d07fa0 <ux_menu_elements_button+0xa4>)
c0d07f2c:	4285      	cmp	r5, r0
c0d07f2e:	d016      	beq.n	c0d07f5e <ux_menu_elements_button+0x62>
c0d07f30:	481c      	ldr	r0, [pc, #112]	; (c0d07fa4 <ux_menu_elements_button+0xa8>)
c0d07f32:	4285      	cmp	r5, r0
c0d07f34:	d01a      	beq.n	c0d07f6c <ux_menu_elements_button+0x70>
c0d07f36:	481c      	ldr	r0, [pc, #112]	; (c0d07fa8 <ux_menu_elements_button+0xac>)
c0d07f38:	4285      	cmp	r5, r0
c0d07f3a:	d12a      	bne.n	c0d07f92 <ux_menu_elements_button+0x96>
    // enter menu or exit menu
    case BUTTON_EVT_RELEASED|BUTTON_LEFT|BUTTON_RIGHT:
      // menu is priority 1
      if (current_entry->menu) {
c0d07f3c:	6830      	ldr	r0, [r6, #0]
c0d07f3e:	2800      	cmp	r0, #0
c0d07f40:	d01e      	beq.n	c0d07f80 <ux_menu_elements_button+0x84>
        // use userid as the pointer to current entry in the parent menu
        UX_MENU_DISPLAY(current_entry->userid, (const ux_menu_entry_t*)PIC(current_entry->menu), ux_menu.menu_entry_preprocessor);
c0d07f42:	68b4      	ldr	r4, [r6, #8]
c0d07f44:	f7fb f9f0 	bl	c0d03328 <pic>
c0d07f48:	4601      	mov	r1, r0
c0d07f4a:	68fa      	ldr	r2, [r7, #12]
c0d07f4c:	4620      	mov	r0, r4
c0d07f4e:	f000 f82f 	bl	c0d07fb0 <ux_menu_display>
c0d07f52:	e01d      	b.n	c0d07f90 <ux_menu_elements_button+0x94>
c0d07f54:	4915      	ldr	r1, [pc, #84]	; (c0d07fac <ux_menu_elements_button+0xb0>)
  switch (button_mask) {
c0d07f56:	428d      	cmp	r5, r1
c0d07f58:	d008      	beq.n	c0d07f6c <ux_menu_elements_button+0x70>
c0d07f5a:	4285      	cmp	r5, r0
c0d07f5c:	d119      	bne.n	c0d07f92 <ux_menu_elements_button+0x96>
      goto redraw;

    case BUTTON_EVT_FAST|BUTTON_RIGHT:
    case BUTTON_EVT_RELEASED|BUTTON_RIGHT:
      // entry 0 is the number of entries in the menu list
      if (ux_menu.current_entry >= ux_menu.menu_entries_count-1) {
c0d07f5e:	6879      	ldr	r1, [r7, #4]
c0d07f60:	68b8      	ldr	r0, [r7, #8]
c0d07f62:	1e49      	subs	r1, r1, #1
c0d07f64:	4288      	cmp	r0, r1
c0d07f66:	d213      	bcs.n	c0d07f90 <ux_menu_elements_button+0x94>
        return 0;
      }
      ux_menu.current_entry++;
c0d07f68:	1c40      	adds	r0, r0, #1
c0d07f6a:	e003      	b.n	c0d07f74 <ux_menu_elements_button+0x78>
      if (ux_menu.current_entry == 0) {
c0d07f6c:	68b8      	ldr	r0, [r7, #8]
c0d07f6e:	2800      	cmp	r0, #0
c0d07f70:	d00e      	beq.n	c0d07f90 <ux_menu_elements_button+0x94>
      ux_menu.current_entry--;
c0d07f72:	1e40      	subs	r0, r0, #1
c0d07f74:	60b8      	str	r0, [r7, #8]
c0d07f76:	2400      	movs	r4, #0
    redraw:
#ifdef HAVE_BOLOS_UX
      ux_stack_display(0);
c0d07f78:	4620      	mov	r0, r4
c0d07f7a:	f000 f87f 	bl	c0d0807c <ux_stack_display>
c0d07f7e:	e008      	b.n	c0d07f92 <ux_menu_elements_button+0x96>
      else if (current_entry->callback) {
c0d07f80:	6870      	ldr	r0, [r6, #4]
c0d07f82:	2800      	cmp	r0, #0
c0d07f84:	d005      	beq.n	c0d07f92 <ux_menu_elements_button+0x96>
        ((ux_menu_callback_t)PIC(current_entry->callback))(current_entry->userid);
c0d07f86:	f7fb f9cf 	bl	c0d03328 <pic>
c0d07f8a:	4601      	mov	r1, r0
c0d07f8c:	68b0      	ldr	r0, [r6, #8]
c0d07f8e:	4788      	blx	r1
c0d07f90:	2400      	movs	r4, #0
      UX_REDISPLAY();
#endif
      return 0;
  }
  return 1;
}
c0d07f92:	4620      	mov	r0, r4
c0d07f94:	b001      	add	sp, #4
c0d07f96:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d07f98:	20000ab4 	.word	0x20000ab4
c0d07f9c:	80000002 	.word	0x80000002
c0d07fa0:	40000002 	.word	0x40000002
c0d07fa4:	40000001 	.word	0x40000001
c0d07fa8:	80000003 	.word	0x80000003
c0d07fac:	80000001 	.word	0x80000001

c0d07fb0 <ux_menu_display>:

const ux_menu_entry_t UX_MENU_END_ENTRY = UX_MENU_END;

void ux_menu_display(unsigned int current_entry, 
                     const ux_menu_entry_t* menu_entries,
                     ux_menu_preprocessor_t menu_entry_preprocessor) {
c0d07fb0:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d07fb2:	b083      	sub	sp, #12
c0d07fb4:	9201      	str	r2, [sp, #4]
c0d07fb6:	9000      	str	r0, [sp, #0]
  // reset to first entry
  ux_menu.menu_entries_count = 0;
c0d07fb8:	4e21      	ldr	r6, [pc, #132]	; (c0d08040 <ux_menu_display+0x90>)
c0d07fba:	2400      	movs	r4, #0
c0d07fbc:	6074      	str	r4, [r6, #4]

  // count entries
  if (menu_entries) {
c0d07fbe:	2900      	cmp	r1, #0
c0d07fc0:	9102      	str	r1, [sp, #8]
c0d07fc2:	d017      	beq.n	c0d07ff4 <ux_menu_display+0x44>
c0d07fc4:	460b      	mov	r3, r1
    for(;;) {
      if (memcmp(&menu_entries[ux_menu.menu_entries_count], &UX_MENU_END_ENTRY, sizeof(ux_menu_entry_t)) == 0) {
c0d07fc6:	4920      	ldr	r1, [pc, #128]	; (c0d08048 <ux_menu_display+0x98>)
c0d07fc8:	4479      	add	r1, pc
c0d07fca:	221c      	movs	r2, #28
c0d07fcc:	4618      	mov	r0, r3
c0d07fce:	f000 fab5 	bl	c0d0853c <memcmp>
c0d07fd2:	2800      	cmp	r0, #0
c0d07fd4:	d00e      	beq.n	c0d07ff4 <ux_menu_display+0x44>
    for(;;) {
c0d07fd6:	9f02      	ldr	r7, [sp, #8]
c0d07fd8:	371c      	adds	r7, #28
c0d07fda:	2400      	movs	r4, #0
c0d07fdc:	4d1b      	ldr	r5, [pc, #108]	; (c0d0804c <ux_menu_display+0x9c>)
c0d07fde:	447d      	add	r5, pc
        break;
      }
      ux_menu.menu_entries_count++;
c0d07fe0:	1c64      	adds	r4, r4, #1
c0d07fe2:	6074      	str	r4, [r6, #4]
c0d07fe4:	221c      	movs	r2, #28
      if (memcmp(&menu_entries[ux_menu.menu_entries_count], &UX_MENU_END_ENTRY, sizeof(ux_menu_entry_t)) == 0) {
c0d07fe6:	4638      	mov	r0, r7
c0d07fe8:	4629      	mov	r1, r5
c0d07fea:	f000 faa7 	bl	c0d0853c <memcmp>
c0d07fee:	371c      	adds	r7, #28
c0d07ff0:	2800      	cmp	r0, #0
c0d07ff2:	d1f5      	bne.n	c0d07fe0 <ux_menu_display+0x30>
c0d07ff4:	9900      	ldr	r1, [sp, #0]
    }
  }

  if (current_entry != UX_MENU_UNCHANGED_ENTRY) {
c0d07ff6:	1c48      	adds	r0, r1, #1
c0d07ff8:	9802      	ldr	r0, [sp, #8]
c0d07ffa:	d003      	beq.n	c0d08004 <ux_menu_display+0x54>
    ux_menu.current_entry = current_entry;
    if (ux_menu.current_entry > ux_menu.menu_entries_count) {
c0d07ffc:	428c      	cmp	r4, r1
c0d07ffe:	d200      	bcs.n	c0d08002 <ux_menu_display+0x52>
c0d08000:	2100      	movs	r1, #0
c0d08002:	60b1      	str	r1, [r6, #8]
c0d08004:	2500      	movs	r5, #0
      ux_menu.current_entry = 0;
    }
  }
  ux_menu.menu_entries = menu_entries;
  ux_menu.menu_entry_preprocessor = menu_entry_preprocessor;
c0d08006:	9901      	ldr	r1, [sp, #4]
c0d08008:	60f1      	str	r1, [r6, #12]
  ux_menu.menu_iterator = NULL;
c0d0800a:	6135      	str	r5, [r6, #16]
  ux_menu.menu_entries = menu_entries;
c0d0800c:	6030      	str	r0, [r6, #0]

#ifdef HAVE_BOLOS_UX
  ux_stack_init(0);
c0d0800e:	4628      	mov	r0, r5
c0d08010:	f000 f858 	bl	c0d080c4 <ux_stack_init>
c0d08014:	202c      	movs	r0, #44	; 0x2c

  // static dashboard content
  G_ux.stack[0].element_arrays[0].element_array = ux_menu_elements;
c0d08016:	490b      	ldr	r1, [pc, #44]	; (c0d08044 <ux_menu_display+0x94>)
c0d08018:	2209      	movs	r2, #9
  G_ux.stack[0].element_arrays[0].element_array_count = ARRAYLEN(ux_menu_elements);
c0d0801a:	540a      	strb	r2, [r1, r0]
c0d0801c:	2025      	movs	r0, #37	; 0x25
c0d0801e:	2201      	movs	r2, #1
  G_ux.stack[0].element_arrays_count = 1;
c0d08020:	540a      	strb	r2, [r1, r0]
  G_ux.stack[0].element_arrays[0].element_array = ux_menu_elements;
c0d08022:	480b      	ldr	r0, [pc, #44]	; (c0d08050 <ux_menu_display+0xa0>)
c0d08024:	4478      	add	r0, pc
c0d08026:	6288      	str	r0, [r1, #40]	; 0x28

  // ensure the string_buffer will be set before each button is displayed
  G_ux.stack[0].screen_before_element_display_callback = ux_menu_element_preprocessor;
  G_ux.stack[0].button_push_callback = ux_menu_elements_button;
c0d08028:	480a      	ldr	r0, [pc, #40]	; (c0d08054 <ux_menu_display+0xa4>)
c0d0802a:	4478      	add	r0, pc
  G_ux.stack[0].screen_before_element_display_callback = ux_menu_element_preprocessor;
c0d0802c:	4a0a      	ldr	r2, [pc, #40]	; (c0d08058 <ux_menu_display+0xa8>)
c0d0802e:	447a      	add	r2, pc
c0d08030:	630a      	str	r2, [r1, #48]	; 0x30
  G_ux.stack[0].button_push_callback = ux_menu_elements_button;
c0d08032:	6348      	str	r0, [r1, #52]	; 0x34

  ux_stack_display(0);
c0d08034:	4628      	mov	r0, r5
c0d08036:	f000 f821 	bl	c0d0807c <ux_stack_display>
#else
  // display the menu current entry
  UX_DISPLAY(ux_menu_elements, ux_menu_element_preprocessor);
#endif
}
c0d0803a:	b003      	add	sp, #12
c0d0803c:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d0803e:	46c0      	nop			; (mov r8, r8)
c0d08040:	20000ab4 	.word	0x20000ab4
c0d08044:	20000968 	.word	0x20000968
c0d08048:	000021c8 	.word	0x000021c8
c0d0804c:	000021b2 	.word	0x000021b2
c0d08050:	0000204c 	.word	0x0000204c
c0d08054:	fffffecf 	.word	0xfffffecf
c0d08058:	fffffd23 	.word	0xfffffd23

c0d0805c <ux_stack_push>:
    }
  }
  return 0;
}

unsigned int ux_stack_push(void) {
c0d0805c:	b510      	push	{r4, lr}
  // only push if an available slot exists
  if (G_ux.stack_count < ARRAYLEN(G_ux.stack)) {
c0d0805e:	4c06      	ldr	r4, [pc, #24]	; (c0d08078 <ux_stack_push+0x1c>)
c0d08060:	7820      	ldrb	r0, [r4, #0]
c0d08062:	2800      	cmp	r0, #0
c0d08064:	d106      	bne.n	c0d08074 <ux_stack_push+0x18>
    memset(&G_ux.stack[G_ux.stack_count], 0, sizeof(G_ux.stack[0]));
c0d08066:	4620      	mov	r0, r4
c0d08068:	3024      	adds	r0, #36	; 0x24
c0d0806a:	2120      	movs	r1, #32
c0d0806c:	f000 fa4e 	bl	c0d0850c <__aeabi_memclr>
c0d08070:	2001      	movs	r0, #1
#ifdef HAVE_UX_FLOW
    memset(&G_ux.flow_stack[G_ux.stack_count], 0, sizeof(G_ux.flow_stack[0]));
#endif // HAVE_UX_FLOW
    G_ux.stack_count++;
c0d08072:	7020      	strb	r0, [r4, #0]
  }
  // return the stack top index
  return G_ux.stack_count-1;
c0d08074:	1e40      	subs	r0, r0, #1
c0d08076:	bd10      	pop	{r4, pc}
c0d08078:	20000968 	.word	0x20000968

c0d0807c <ux_stack_display>:
}
#endif // UX_STACK_SLOT_ARRAY_COUNT == 1
#endif // TARGET_NANOX

// common code for all screens
void ux_stack_display(unsigned int stack_slot) {
c0d0807c:	b5b0      	push	{r4, r5, r7, lr}
c0d0807e:	4604      	mov	r4, r0
  // don't display any elements of a previous screen replacement
  if(G_ux.stack_count > 0 && stack_slot+1 == G_ux.stack_count) {
c0d08080:	480f      	ldr	r0, [pc, #60]	; (c0d080c0 <ux_stack_display+0x44>)
c0d08082:	7801      	ldrb	r1, [r0, #0]
c0d08084:	2900      	cmp	r1, #0
c0d08086:	d00c      	beq.n	c0d080a2 <ux_stack_display+0x26>
c0d08088:	1c62      	adds	r2, r4, #1
c0d0808a:	428a      	cmp	r2, r1
c0d0808c:	d109      	bne.n	c0d080a2 <ux_stack_display+0x26>
    io_seproxyhal_init_ux();
    // at worse a redisplay of the current screen has been requested, ensure to redraw it correctly
    G_ux.stack[stack_slot].element_index = 0;
c0d0808e:	0161      	lsls	r1, r4, #5
c0d08090:	1845      	adds	r5, r0, r1
    io_seproxyhal_init_ux();
c0d08092:	f7fa f9b1 	bl	c0d023f8 <io_seproxyhal_init_ux>
c0d08096:	2000      	movs	r0, #0
    G_ux.stack[stack_slot].element_index = 0;
c0d08098:	84e8      	strh	r0, [r5, #38]	; 0x26
#ifdef TARGET_NANOX
    ux_stack_display_elements(&G_ux.stack[stack_slot]); // on balenos, no need to wait for the display processed event
#else // TARGET_NANOX
    ux_stack_al_display_next_element(stack_slot);
c0d0809a:	4620      	mov	r0, r4
c0d0809c:	f000 f822 	bl	c0d080e4 <ux_stack_al_display_next_element>
    if (G_ux.exit_code == BOLOS_UX_OK) {
      G_ux.exit_code = BOLOS_UX_REDRAW;
    }
  }
  // else don't draw (in stack insertion)
}
c0d080a0:	bdb0      	pop	{r4, r5, r7, pc}
c0d080a2:	2200      	movs	r2, #0
c0d080a4:	43d2      	mvns	r2, r2
  else if (stack_slot == -1UL || G_ux.stack_count == 0) {
c0d080a6:	1aa2      	subs	r2, r4, r2
c0d080a8:	1e53      	subs	r3, r2, #1
c0d080aa:	419a      	sbcs	r2, r3
  if(G_ux.stack_count > 0 && stack_slot+1 == G_ux.stack_count) {
c0d080ac:	1e4b      	subs	r3, r1, #1
c0d080ae:	4199      	sbcs	r1, r3
  else if (stack_slot == -1UL || G_ux.stack_count == 0) {
c0d080b0:	420a      	tst	r2, r1
c0d080b2:	d104      	bne.n	c0d080be <ux_stack_display+0x42>
c0d080b4:	7841      	ldrb	r1, [r0, #1]
c0d080b6:	29aa      	cmp	r1, #170	; 0xaa
c0d080b8:	d101      	bne.n	c0d080be <ux_stack_display+0x42>
c0d080ba:	2169      	movs	r1, #105	; 0x69
      G_ux.exit_code = BOLOS_UX_REDRAW;
c0d080bc:	7041      	strb	r1, [r0, #1]
}
c0d080be:	bdb0      	pop	{r4, r5, r7, pc}
c0d080c0:	20000968 	.word	0x20000968

c0d080c4 <ux_stack_init>:
void ux_stack_init(unsigned int stack_slot) {
c0d080c4:	b510      	push	{r4, lr}
c0d080c6:	4604      	mov	r4, r0
  io_seproxyhal_init_ux(); // glitch upon ux_stack_display for a button being pressed in a previous screen
c0d080c8:	f7fa f996 	bl	c0d023f8 <io_seproxyhal_init_ux>
  if (stack_slot < UX_STACK_SLOT_COUNT) {
c0d080cc:	2c00      	cmp	r4, #0
c0d080ce:	d000      	beq.n	c0d080d2 <ux_stack_init+0xe>
}
c0d080d0:	bd10      	pop	{r4, pc}
    G_ux.stack[stack_slot].exit_code_after_elements_displayed = BOLOS_UX_CONTINUE;
c0d080d2:	4803      	ldr	r0, [pc, #12]	; (c0d080e0 <ux_stack_init+0x1c>)
c0d080d4:	3024      	adds	r0, #36	; 0x24
c0d080d6:	2120      	movs	r1, #32
c0d080d8:	f000 fa18 	bl	c0d0850c <__aeabi_memclr>
}
c0d080dc:	bd10      	pop	{r4, pc}
c0d080de:	46c0      	nop			; (mov r8, r8)
c0d080e0:	20000968 	.word	0x20000968

c0d080e4 <ux_stack_al_display_next_element>:
void ux_stack_al_display_next_element(unsigned int stack_slot) {
c0d080e4:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d080e6:	b081      	sub	sp, #4
c0d080e8:	4604      	mov	r4, r0
c0d080ea:	2004      	movs	r0, #4
  unsigned int status = os_sched_last_status(TASK_BOLOS_UX);
c0d080ec:	f7fd faaa 	bl	c0d05644 <os_sched_last_status>
  if (status != BOLOS_UX_IGNORE && status != BOLOS_UX_CONTINUE) {
c0d080f0:	2800      	cmp	r0, #0
c0d080f2:	d037      	beq.n	c0d08164 <ux_stack_al_display_next_element+0x80>
c0d080f4:	2897      	cmp	r0, #151	; 0x97
c0d080f6:	d035      	beq.n	c0d08164 <ux_stack_al_display_next_element+0x80>
      && G_ux.stack[stack_slot].element_index < G_ux.stack[stack_slot].element_arrays[0].element_array_count
c0d080f8:	0160      	lsls	r0, r4, #5
c0d080fa:	491b      	ldr	r1, [pc, #108]	; (c0d08168 <ux_stack_al_display_next_element+0x84>)
c0d080fc:	180c      	adds	r4, r1, r0
    while (G_ux.stack[stack_slot].element_arrays[0].element_array
c0d080fe:	6aa0      	ldr	r0, [r4, #40]	; 0x28
      && G_ux.stack[stack_slot].element_index < G_ux.stack[stack_slot].element_arrays[0].element_array_count
c0d08100:	2800      	cmp	r0, #0
c0d08102:	d02f      	beq.n	c0d08164 <ux_stack_al_display_next_element+0x80>
c0d08104:	4625      	mov	r5, r4
c0d08106:	3528      	adds	r5, #40	; 0x28
c0d08108:	4626      	mov	r6, r4
c0d0810a:	3626      	adds	r6, #38	; 0x26
c0d0810c:	4627      	mov	r7, r4
c0d0810e:	3730      	adds	r7, #48	; 0x30
c0d08110:	342c      	adds	r4, #44	; 0x2c
c0d08112:	8830      	ldrh	r0, [r6, #0]
c0d08114:	7821      	ldrb	r1, [r4, #0]
c0d08116:	b280      	uxth	r0, r0
      && ! io_seproxyhal_spi_is_status_sent()
c0d08118:	4288      	cmp	r0, r1
c0d0811a:	d223      	bcs.n	c0d08164 <ux_stack_al_display_next_element+0x80>
c0d0811c:	f7fd fa5e 	bl	c0d055dc <io_seph_is_status_sent>
      && (os_perso_isonboarded() != BOLOS_UX_OK || os_global_pin_is_validated() == BOLOS_UX_OK)) {
c0d08120:	2800      	cmp	r0, #0
c0d08122:	d11f      	bne.n	c0d08164 <ux_stack_al_display_next_element+0x80>
c0d08124:	f7fd f9d6 	bl	c0d054d4 <os_perso_isonboarded>
c0d08128:	28aa      	cmp	r0, #170	; 0xaa
c0d0812a:	d103      	bne.n	c0d08134 <ux_stack_al_display_next_element+0x50>
c0d0812c:	f7fd f9fc 	bl	c0d05528 <os_global_pin_is_validated>
    while (G_ux.stack[stack_slot].element_arrays[0].element_array
c0d08130:	28aa      	cmp	r0, #170	; 0xaa
c0d08132:	d117      	bne.n	c0d08164 <ux_stack_al_display_next_element+0x80>
      const bagl_element_t* element = &G_ux.stack[stack_slot].element_arrays[0].element_array[G_ux.stack[stack_slot].element_index];
c0d08134:	6828      	ldr	r0, [r5, #0]
c0d08136:	8831      	ldrh	r1, [r6, #0]
c0d08138:	0149      	lsls	r1, r1, #5
c0d0813a:	1840      	adds	r0, r0, r1
      if (!G_ux.stack[stack_slot].screen_before_element_display_callback || (element = G_ux.stack[stack_slot].screen_before_element_display_callback(element)) ) {
c0d0813c:	6839      	ldr	r1, [r7, #0]
c0d0813e:	2900      	cmp	r1, #0
c0d08140:	d002      	beq.n	c0d08148 <ux_stack_al_display_next_element+0x64>
c0d08142:	4788      	blx	r1
c0d08144:	2800      	cmp	r0, #0
c0d08146:	d007      	beq.n	c0d08158 <ux_stack_al_display_next_element+0x74>
        if ((unsigned int)element == 1) { /*backward compat with coding to avoid smashing everything*/
c0d08148:	2801      	cmp	r0, #1
c0d0814a:	d103      	bne.n	c0d08154 <ux_stack_al_display_next_element+0x70>
          element = &G_ux.stack[stack_slot].element_arrays[0].element_array[G_ux.stack[stack_slot].element_index];
c0d0814c:	6828      	ldr	r0, [r5, #0]
c0d0814e:	8831      	ldrh	r1, [r6, #0]
c0d08150:	0149      	lsls	r1, r1, #5
c0d08152:	1840      	adds	r0, r0, r1
        io_seproxyhal_display(element);
c0d08154:	f7f9 f844 	bl	c0d011e0 <io_seproxyhal_display>
      G_ux.stack[stack_slot].element_index++;
c0d08158:	8830      	ldrh	r0, [r6, #0]
c0d0815a:	1c40      	adds	r0, r0, #1
c0d0815c:	8030      	strh	r0, [r6, #0]
    while (G_ux.stack[stack_slot].element_arrays[0].element_array
c0d0815e:	6829      	ldr	r1, [r5, #0]
      && G_ux.stack[stack_slot].element_index < G_ux.stack[stack_slot].element_arrays[0].element_array_count
c0d08160:	2900      	cmp	r1, #0
c0d08162:	d1d7      	bne.n	c0d08114 <ux_stack_al_display_next_element+0x30>
}
c0d08164:	b001      	add	sp, #4
c0d08166:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d08168:	20000968 	.word	0x20000968

c0d0816c <__udivsi3>:
c0d0816c:	2200      	movs	r2, #0
c0d0816e:	0843      	lsrs	r3, r0, #1
c0d08170:	428b      	cmp	r3, r1
c0d08172:	d374      	bcc.n	c0d0825e <__udivsi3+0xf2>
c0d08174:	0903      	lsrs	r3, r0, #4
c0d08176:	428b      	cmp	r3, r1
c0d08178:	d35f      	bcc.n	c0d0823a <__udivsi3+0xce>
c0d0817a:	0a03      	lsrs	r3, r0, #8
c0d0817c:	428b      	cmp	r3, r1
c0d0817e:	d344      	bcc.n	c0d0820a <__udivsi3+0x9e>
c0d08180:	0b03      	lsrs	r3, r0, #12
c0d08182:	428b      	cmp	r3, r1
c0d08184:	d328      	bcc.n	c0d081d8 <__udivsi3+0x6c>
c0d08186:	0c03      	lsrs	r3, r0, #16
c0d08188:	428b      	cmp	r3, r1
c0d0818a:	d30d      	bcc.n	c0d081a8 <__udivsi3+0x3c>
c0d0818c:	22ff      	movs	r2, #255	; 0xff
c0d0818e:	0209      	lsls	r1, r1, #8
c0d08190:	ba12      	rev	r2, r2
c0d08192:	0c03      	lsrs	r3, r0, #16
c0d08194:	428b      	cmp	r3, r1
c0d08196:	d302      	bcc.n	c0d0819e <__udivsi3+0x32>
c0d08198:	1212      	asrs	r2, r2, #8
c0d0819a:	0209      	lsls	r1, r1, #8
c0d0819c:	d065      	beq.n	c0d0826a <__udivsi3+0xfe>
c0d0819e:	0b03      	lsrs	r3, r0, #12
c0d081a0:	428b      	cmp	r3, r1
c0d081a2:	d319      	bcc.n	c0d081d8 <__udivsi3+0x6c>
c0d081a4:	e000      	b.n	c0d081a8 <__udivsi3+0x3c>
c0d081a6:	0a09      	lsrs	r1, r1, #8
c0d081a8:	0bc3      	lsrs	r3, r0, #15
c0d081aa:	428b      	cmp	r3, r1
c0d081ac:	d301      	bcc.n	c0d081b2 <__udivsi3+0x46>
c0d081ae:	03cb      	lsls	r3, r1, #15
c0d081b0:	1ac0      	subs	r0, r0, r3
c0d081b2:	4152      	adcs	r2, r2
c0d081b4:	0b83      	lsrs	r3, r0, #14
c0d081b6:	428b      	cmp	r3, r1
c0d081b8:	d301      	bcc.n	c0d081be <__udivsi3+0x52>
c0d081ba:	038b      	lsls	r3, r1, #14
c0d081bc:	1ac0      	subs	r0, r0, r3
c0d081be:	4152      	adcs	r2, r2
c0d081c0:	0b43      	lsrs	r3, r0, #13
c0d081c2:	428b      	cmp	r3, r1
c0d081c4:	d301      	bcc.n	c0d081ca <__udivsi3+0x5e>
c0d081c6:	034b      	lsls	r3, r1, #13
c0d081c8:	1ac0      	subs	r0, r0, r3
c0d081ca:	4152      	adcs	r2, r2
c0d081cc:	0b03      	lsrs	r3, r0, #12
c0d081ce:	428b      	cmp	r3, r1
c0d081d0:	d301      	bcc.n	c0d081d6 <__udivsi3+0x6a>
c0d081d2:	030b      	lsls	r3, r1, #12
c0d081d4:	1ac0      	subs	r0, r0, r3
c0d081d6:	4152      	adcs	r2, r2
c0d081d8:	0ac3      	lsrs	r3, r0, #11
c0d081da:	428b      	cmp	r3, r1
c0d081dc:	d301      	bcc.n	c0d081e2 <__udivsi3+0x76>
c0d081de:	02cb      	lsls	r3, r1, #11
c0d081e0:	1ac0      	subs	r0, r0, r3
c0d081e2:	4152      	adcs	r2, r2
c0d081e4:	0a83      	lsrs	r3, r0, #10
c0d081e6:	428b      	cmp	r3, r1
c0d081e8:	d301      	bcc.n	c0d081ee <__udivsi3+0x82>
c0d081ea:	028b      	lsls	r3, r1, #10
c0d081ec:	1ac0      	subs	r0, r0, r3
c0d081ee:	4152      	adcs	r2, r2
c0d081f0:	0a43      	lsrs	r3, r0, #9
c0d081f2:	428b      	cmp	r3, r1
c0d081f4:	d301      	bcc.n	c0d081fa <__udivsi3+0x8e>
c0d081f6:	024b      	lsls	r3, r1, #9
c0d081f8:	1ac0      	subs	r0, r0, r3
c0d081fa:	4152      	adcs	r2, r2
c0d081fc:	0a03      	lsrs	r3, r0, #8
c0d081fe:	428b      	cmp	r3, r1
c0d08200:	d301      	bcc.n	c0d08206 <__udivsi3+0x9a>
c0d08202:	020b      	lsls	r3, r1, #8
c0d08204:	1ac0      	subs	r0, r0, r3
c0d08206:	4152      	adcs	r2, r2
c0d08208:	d2cd      	bcs.n	c0d081a6 <__udivsi3+0x3a>
c0d0820a:	09c3      	lsrs	r3, r0, #7
c0d0820c:	428b      	cmp	r3, r1
c0d0820e:	d301      	bcc.n	c0d08214 <__udivsi3+0xa8>
c0d08210:	01cb      	lsls	r3, r1, #7
c0d08212:	1ac0      	subs	r0, r0, r3
c0d08214:	4152      	adcs	r2, r2
c0d08216:	0983      	lsrs	r3, r0, #6
c0d08218:	428b      	cmp	r3, r1
c0d0821a:	d301      	bcc.n	c0d08220 <__udivsi3+0xb4>
c0d0821c:	018b      	lsls	r3, r1, #6
c0d0821e:	1ac0      	subs	r0, r0, r3
c0d08220:	4152      	adcs	r2, r2
c0d08222:	0943      	lsrs	r3, r0, #5
c0d08224:	428b      	cmp	r3, r1
c0d08226:	d301      	bcc.n	c0d0822c <__udivsi3+0xc0>
c0d08228:	014b      	lsls	r3, r1, #5
c0d0822a:	1ac0      	subs	r0, r0, r3
c0d0822c:	4152      	adcs	r2, r2
c0d0822e:	0903      	lsrs	r3, r0, #4
c0d08230:	428b      	cmp	r3, r1
c0d08232:	d301      	bcc.n	c0d08238 <__udivsi3+0xcc>
c0d08234:	010b      	lsls	r3, r1, #4
c0d08236:	1ac0      	subs	r0, r0, r3
c0d08238:	4152      	adcs	r2, r2
c0d0823a:	08c3      	lsrs	r3, r0, #3
c0d0823c:	428b      	cmp	r3, r1
c0d0823e:	d301      	bcc.n	c0d08244 <__udivsi3+0xd8>
c0d08240:	00cb      	lsls	r3, r1, #3
c0d08242:	1ac0      	subs	r0, r0, r3
c0d08244:	4152      	adcs	r2, r2
c0d08246:	0883      	lsrs	r3, r0, #2
c0d08248:	428b      	cmp	r3, r1
c0d0824a:	d301      	bcc.n	c0d08250 <__udivsi3+0xe4>
c0d0824c:	008b      	lsls	r3, r1, #2
c0d0824e:	1ac0      	subs	r0, r0, r3
c0d08250:	4152      	adcs	r2, r2
c0d08252:	0843      	lsrs	r3, r0, #1
c0d08254:	428b      	cmp	r3, r1
c0d08256:	d301      	bcc.n	c0d0825c <__udivsi3+0xf0>
c0d08258:	004b      	lsls	r3, r1, #1
c0d0825a:	1ac0      	subs	r0, r0, r3
c0d0825c:	4152      	adcs	r2, r2
c0d0825e:	1a41      	subs	r1, r0, r1
c0d08260:	d200      	bcs.n	c0d08264 <__udivsi3+0xf8>
c0d08262:	4601      	mov	r1, r0
c0d08264:	4152      	adcs	r2, r2
c0d08266:	4610      	mov	r0, r2
c0d08268:	4770      	bx	lr
c0d0826a:	e7ff      	b.n	c0d0826c <__udivsi3+0x100>
c0d0826c:	b501      	push	{r0, lr}
c0d0826e:	2000      	movs	r0, #0
c0d08270:	f000 f806 	bl	c0d08280 <__aeabi_idiv0>
c0d08274:	bd02      	pop	{r1, pc}
c0d08276:	46c0      	nop			; (mov r8, r8)

c0d08278 <__aeabi_uidivmod>:
c0d08278:	2900      	cmp	r1, #0
c0d0827a:	d0f7      	beq.n	c0d0826c <__udivsi3+0x100>
c0d0827c:	e776      	b.n	c0d0816c <__udivsi3>
c0d0827e:	4770      	bx	lr

c0d08280 <__aeabi_idiv0>:
c0d08280:	4770      	bx	lr
c0d08282:	46c0      	nop			; (mov r8, r8)

c0d08284 <__aeabi_uldivmod>:
c0d08284:	2b00      	cmp	r3, #0
c0d08286:	d111      	bne.n	c0d082ac <__aeabi_uldivmod+0x28>
c0d08288:	2a00      	cmp	r2, #0
c0d0828a:	d10f      	bne.n	c0d082ac <__aeabi_uldivmod+0x28>
c0d0828c:	2900      	cmp	r1, #0
c0d0828e:	d100      	bne.n	c0d08292 <__aeabi_uldivmod+0xe>
c0d08290:	2800      	cmp	r0, #0
c0d08292:	d002      	beq.n	c0d0829a <__aeabi_uldivmod+0x16>
c0d08294:	2100      	movs	r1, #0
c0d08296:	43c9      	mvns	r1, r1
c0d08298:	0008      	movs	r0, r1
c0d0829a:	b407      	push	{r0, r1, r2}
c0d0829c:	4802      	ldr	r0, [pc, #8]	; (c0d082a8 <__aeabi_uldivmod+0x24>)
c0d0829e:	a102      	add	r1, pc, #8	; (adr r1, c0d082a8 <__aeabi_uldivmod+0x24>)
c0d082a0:	1840      	adds	r0, r0, r1
c0d082a2:	9002      	str	r0, [sp, #8]
c0d082a4:	bd03      	pop	{r0, r1, pc}
c0d082a6:	46c0      	nop			; (mov r8, r8)
c0d082a8:	ffffffd9 	.word	0xffffffd9
c0d082ac:	b403      	push	{r0, r1}
c0d082ae:	4668      	mov	r0, sp
c0d082b0:	b501      	push	{r0, lr}
c0d082b2:	9802      	ldr	r0, [sp, #8]
c0d082b4:	f000 f834 	bl	c0d08320 <__udivmoddi4>
c0d082b8:	9b01      	ldr	r3, [sp, #4]
c0d082ba:	469e      	mov	lr, r3
c0d082bc:	b002      	add	sp, #8
c0d082be:	bc0c      	pop	{r2, r3}
c0d082c0:	4770      	bx	lr
c0d082c2:	46c0      	nop			; (mov r8, r8)

c0d082c4 <__aeabi_lmul>:
c0d082c4:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d082c6:	46ce      	mov	lr, r9
c0d082c8:	4647      	mov	r7, r8
c0d082ca:	b580      	push	{r7, lr}
c0d082cc:	0007      	movs	r7, r0
c0d082ce:	4699      	mov	r9, r3
c0d082d0:	0c3b      	lsrs	r3, r7, #16
c0d082d2:	469c      	mov	ip, r3
c0d082d4:	0413      	lsls	r3, r2, #16
c0d082d6:	0c1b      	lsrs	r3, r3, #16
c0d082d8:	001d      	movs	r5, r3
c0d082da:	000e      	movs	r6, r1
c0d082dc:	4661      	mov	r1, ip
c0d082de:	0400      	lsls	r0, r0, #16
c0d082e0:	0c14      	lsrs	r4, r2, #16
c0d082e2:	0c00      	lsrs	r0, r0, #16
c0d082e4:	4345      	muls	r5, r0
c0d082e6:	434b      	muls	r3, r1
c0d082e8:	4360      	muls	r0, r4
c0d082ea:	4361      	muls	r1, r4
c0d082ec:	18c0      	adds	r0, r0, r3
c0d082ee:	0c2c      	lsrs	r4, r5, #16
c0d082f0:	1820      	adds	r0, r4, r0
c0d082f2:	468c      	mov	ip, r1
c0d082f4:	4283      	cmp	r3, r0
c0d082f6:	d903      	bls.n	c0d08300 <__aeabi_lmul+0x3c>
c0d082f8:	2380      	movs	r3, #128	; 0x80
c0d082fa:	025b      	lsls	r3, r3, #9
c0d082fc:	4698      	mov	r8, r3
c0d082fe:	44c4      	add	ip, r8
c0d08300:	4649      	mov	r1, r9
c0d08302:	4379      	muls	r1, r7
c0d08304:	4372      	muls	r2, r6
c0d08306:	0c03      	lsrs	r3, r0, #16
c0d08308:	4463      	add	r3, ip
c0d0830a:	042d      	lsls	r5, r5, #16
c0d0830c:	0c2d      	lsrs	r5, r5, #16
c0d0830e:	18c9      	adds	r1, r1, r3
c0d08310:	0400      	lsls	r0, r0, #16
c0d08312:	1940      	adds	r0, r0, r5
c0d08314:	1889      	adds	r1, r1, r2
c0d08316:	bcc0      	pop	{r6, r7}
c0d08318:	46b9      	mov	r9, r7
c0d0831a:	46b0      	mov	r8, r6
c0d0831c:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d0831e:	46c0      	nop			; (mov r8, r8)

c0d08320 <__udivmoddi4>:
c0d08320:	b5f0      	push	{r4, r5, r6, r7, lr}
c0d08322:	4657      	mov	r7, sl
c0d08324:	464e      	mov	r6, r9
c0d08326:	4645      	mov	r5, r8
c0d08328:	46de      	mov	lr, fp
c0d0832a:	b5e0      	push	{r5, r6, r7, lr}
c0d0832c:	0004      	movs	r4, r0
c0d0832e:	000d      	movs	r5, r1
c0d08330:	4692      	mov	sl, r2
c0d08332:	4699      	mov	r9, r3
c0d08334:	b083      	sub	sp, #12
c0d08336:	428b      	cmp	r3, r1
c0d08338:	d830      	bhi.n	c0d0839c <__udivmoddi4+0x7c>
c0d0833a:	d02d      	beq.n	c0d08398 <__udivmoddi4+0x78>
c0d0833c:	4649      	mov	r1, r9
c0d0833e:	4650      	mov	r0, sl
c0d08340:	f000 f8ba 	bl	c0d084b8 <__clzdi2>
c0d08344:	0029      	movs	r1, r5
c0d08346:	0006      	movs	r6, r0
c0d08348:	0020      	movs	r0, r4
c0d0834a:	f000 f8b5 	bl	c0d084b8 <__clzdi2>
c0d0834e:	1a33      	subs	r3, r6, r0
c0d08350:	4698      	mov	r8, r3
c0d08352:	3b20      	subs	r3, #32
c0d08354:	469b      	mov	fp, r3
c0d08356:	d433      	bmi.n	c0d083c0 <__udivmoddi4+0xa0>
c0d08358:	465a      	mov	r2, fp
c0d0835a:	4653      	mov	r3, sl
c0d0835c:	4093      	lsls	r3, r2
c0d0835e:	4642      	mov	r2, r8
c0d08360:	001f      	movs	r7, r3
c0d08362:	4653      	mov	r3, sl
c0d08364:	4093      	lsls	r3, r2
c0d08366:	001e      	movs	r6, r3
c0d08368:	42af      	cmp	r7, r5
c0d0836a:	d83a      	bhi.n	c0d083e2 <__udivmoddi4+0xc2>
c0d0836c:	42af      	cmp	r7, r5
c0d0836e:	d100      	bne.n	c0d08372 <__udivmoddi4+0x52>
c0d08370:	e078      	b.n	c0d08464 <__udivmoddi4+0x144>
c0d08372:	465b      	mov	r3, fp
c0d08374:	1ba4      	subs	r4, r4, r6
c0d08376:	41bd      	sbcs	r5, r7
c0d08378:	2b00      	cmp	r3, #0
c0d0837a:	da00      	bge.n	c0d0837e <__udivmoddi4+0x5e>
c0d0837c:	e075      	b.n	c0d0846a <__udivmoddi4+0x14a>
c0d0837e:	2200      	movs	r2, #0
c0d08380:	2300      	movs	r3, #0
c0d08382:	9200      	str	r2, [sp, #0]
c0d08384:	9301      	str	r3, [sp, #4]
c0d08386:	2301      	movs	r3, #1
c0d08388:	465a      	mov	r2, fp
c0d0838a:	4093      	lsls	r3, r2
c0d0838c:	9301      	str	r3, [sp, #4]
c0d0838e:	2301      	movs	r3, #1
c0d08390:	4642      	mov	r2, r8
c0d08392:	4093      	lsls	r3, r2
c0d08394:	9300      	str	r3, [sp, #0]
c0d08396:	e028      	b.n	c0d083ea <__udivmoddi4+0xca>
c0d08398:	4282      	cmp	r2, r0
c0d0839a:	d9cf      	bls.n	c0d0833c <__udivmoddi4+0x1c>
c0d0839c:	2200      	movs	r2, #0
c0d0839e:	2300      	movs	r3, #0
c0d083a0:	9200      	str	r2, [sp, #0]
c0d083a2:	9301      	str	r3, [sp, #4]
c0d083a4:	9b0c      	ldr	r3, [sp, #48]	; 0x30
c0d083a6:	2b00      	cmp	r3, #0
c0d083a8:	d001      	beq.n	c0d083ae <__udivmoddi4+0x8e>
c0d083aa:	601c      	str	r4, [r3, #0]
c0d083ac:	605d      	str	r5, [r3, #4]
c0d083ae:	9800      	ldr	r0, [sp, #0]
c0d083b0:	9901      	ldr	r1, [sp, #4]
c0d083b2:	b003      	add	sp, #12
c0d083b4:	bcf0      	pop	{r4, r5, r6, r7}
c0d083b6:	46bb      	mov	fp, r7
c0d083b8:	46b2      	mov	sl, r6
c0d083ba:	46a9      	mov	r9, r5
c0d083bc:	46a0      	mov	r8, r4
c0d083be:	bdf0      	pop	{r4, r5, r6, r7, pc}
c0d083c0:	4642      	mov	r2, r8
c0d083c2:	2320      	movs	r3, #32
c0d083c4:	1a9b      	subs	r3, r3, r2
c0d083c6:	4652      	mov	r2, sl
c0d083c8:	40da      	lsrs	r2, r3
c0d083ca:	4641      	mov	r1, r8
c0d083cc:	0013      	movs	r3, r2
c0d083ce:	464a      	mov	r2, r9
c0d083d0:	408a      	lsls	r2, r1
c0d083d2:	0017      	movs	r7, r2
c0d083d4:	4642      	mov	r2, r8
c0d083d6:	431f      	orrs	r7, r3
c0d083d8:	4653      	mov	r3, sl
c0d083da:	4093      	lsls	r3, r2
c0d083dc:	001e      	movs	r6, r3
c0d083de:	42af      	cmp	r7, r5
c0d083e0:	d9c4      	bls.n	c0d0836c <__udivmoddi4+0x4c>
c0d083e2:	2200      	movs	r2, #0
c0d083e4:	2300      	movs	r3, #0
c0d083e6:	9200      	str	r2, [sp, #0]
c0d083e8:	9301      	str	r3, [sp, #4]
c0d083ea:	4643      	mov	r3, r8
c0d083ec:	2b00      	cmp	r3, #0
c0d083ee:	d0d9      	beq.n	c0d083a4 <__udivmoddi4+0x84>
c0d083f0:	07fb      	lsls	r3, r7, #31
c0d083f2:	0872      	lsrs	r2, r6, #1
c0d083f4:	431a      	orrs	r2, r3
c0d083f6:	4646      	mov	r6, r8
c0d083f8:	087b      	lsrs	r3, r7, #1
c0d083fa:	e00e      	b.n	c0d0841a <__udivmoddi4+0xfa>
c0d083fc:	42ab      	cmp	r3, r5
c0d083fe:	d101      	bne.n	c0d08404 <__udivmoddi4+0xe4>
c0d08400:	42a2      	cmp	r2, r4
c0d08402:	d80c      	bhi.n	c0d0841e <__udivmoddi4+0xfe>
c0d08404:	1aa4      	subs	r4, r4, r2
c0d08406:	419d      	sbcs	r5, r3
c0d08408:	2001      	movs	r0, #1
c0d0840a:	1924      	adds	r4, r4, r4
c0d0840c:	416d      	adcs	r5, r5
c0d0840e:	2100      	movs	r1, #0
c0d08410:	3e01      	subs	r6, #1
c0d08412:	1824      	adds	r4, r4, r0
c0d08414:	414d      	adcs	r5, r1
c0d08416:	2e00      	cmp	r6, #0
c0d08418:	d006      	beq.n	c0d08428 <__udivmoddi4+0x108>
c0d0841a:	42ab      	cmp	r3, r5
c0d0841c:	d9ee      	bls.n	c0d083fc <__udivmoddi4+0xdc>
c0d0841e:	3e01      	subs	r6, #1
c0d08420:	1924      	adds	r4, r4, r4
c0d08422:	416d      	adcs	r5, r5
c0d08424:	2e00      	cmp	r6, #0
c0d08426:	d1f8      	bne.n	c0d0841a <__udivmoddi4+0xfa>
c0d08428:	9800      	ldr	r0, [sp, #0]
c0d0842a:	9901      	ldr	r1, [sp, #4]
c0d0842c:	465b      	mov	r3, fp
c0d0842e:	1900      	adds	r0, r0, r4
c0d08430:	4169      	adcs	r1, r5
c0d08432:	2b00      	cmp	r3, #0
c0d08434:	db24      	blt.n	c0d08480 <__udivmoddi4+0x160>
c0d08436:	002b      	movs	r3, r5
c0d08438:	465a      	mov	r2, fp
c0d0843a:	4644      	mov	r4, r8
c0d0843c:	40d3      	lsrs	r3, r2
c0d0843e:	002a      	movs	r2, r5
c0d08440:	40e2      	lsrs	r2, r4
c0d08442:	001c      	movs	r4, r3
c0d08444:	465b      	mov	r3, fp
c0d08446:	0015      	movs	r5, r2
c0d08448:	2b00      	cmp	r3, #0
c0d0844a:	db2a      	blt.n	c0d084a2 <__udivmoddi4+0x182>
c0d0844c:	0026      	movs	r6, r4
c0d0844e:	409e      	lsls	r6, r3
c0d08450:	0033      	movs	r3, r6
c0d08452:	0026      	movs	r6, r4
c0d08454:	4647      	mov	r7, r8
c0d08456:	40be      	lsls	r6, r7
c0d08458:	0032      	movs	r2, r6
c0d0845a:	1a80      	subs	r0, r0, r2
c0d0845c:	4199      	sbcs	r1, r3
c0d0845e:	9000      	str	r0, [sp, #0]
c0d08460:	9101      	str	r1, [sp, #4]
c0d08462:	e79f      	b.n	c0d083a4 <__udivmoddi4+0x84>
c0d08464:	42a3      	cmp	r3, r4
c0d08466:	d8bc      	bhi.n	c0d083e2 <__udivmoddi4+0xc2>
c0d08468:	e783      	b.n	c0d08372 <__udivmoddi4+0x52>
c0d0846a:	4642      	mov	r2, r8
c0d0846c:	2320      	movs	r3, #32
c0d0846e:	2100      	movs	r1, #0
c0d08470:	1a9b      	subs	r3, r3, r2
c0d08472:	2200      	movs	r2, #0
c0d08474:	9100      	str	r1, [sp, #0]
c0d08476:	9201      	str	r2, [sp, #4]
c0d08478:	2201      	movs	r2, #1
c0d0847a:	40da      	lsrs	r2, r3
c0d0847c:	9201      	str	r2, [sp, #4]
c0d0847e:	e786      	b.n	c0d0838e <__udivmoddi4+0x6e>
c0d08480:	4642      	mov	r2, r8
c0d08482:	2320      	movs	r3, #32
c0d08484:	1a9b      	subs	r3, r3, r2
c0d08486:	002a      	movs	r2, r5
c0d08488:	4646      	mov	r6, r8
c0d0848a:	409a      	lsls	r2, r3
c0d0848c:	0023      	movs	r3, r4
c0d0848e:	40f3      	lsrs	r3, r6
c0d08490:	4644      	mov	r4, r8
c0d08492:	4313      	orrs	r3, r2
c0d08494:	002a      	movs	r2, r5
c0d08496:	40e2      	lsrs	r2, r4
c0d08498:	001c      	movs	r4, r3
c0d0849a:	465b      	mov	r3, fp
c0d0849c:	0015      	movs	r5, r2
c0d0849e:	2b00      	cmp	r3, #0
c0d084a0:	dad4      	bge.n	c0d0844c <__udivmoddi4+0x12c>
c0d084a2:	4642      	mov	r2, r8
c0d084a4:	002f      	movs	r7, r5
c0d084a6:	2320      	movs	r3, #32
c0d084a8:	0026      	movs	r6, r4
c0d084aa:	4097      	lsls	r7, r2
c0d084ac:	1a9b      	subs	r3, r3, r2
c0d084ae:	40de      	lsrs	r6, r3
c0d084b0:	003b      	movs	r3, r7
c0d084b2:	4333      	orrs	r3, r6
c0d084b4:	e7cd      	b.n	c0d08452 <__udivmoddi4+0x132>
c0d084b6:	46c0      	nop			; (mov r8, r8)

c0d084b8 <__clzdi2>:
c0d084b8:	b510      	push	{r4, lr}
c0d084ba:	2900      	cmp	r1, #0
c0d084bc:	d103      	bne.n	c0d084c6 <__clzdi2+0xe>
c0d084be:	f000 f807 	bl	c0d084d0 <__clzsi2>
c0d084c2:	3020      	adds	r0, #32
c0d084c4:	e002      	b.n	c0d084cc <__clzdi2+0x14>
c0d084c6:	0008      	movs	r0, r1
c0d084c8:	f000 f802 	bl	c0d084d0 <__clzsi2>
c0d084cc:	bd10      	pop	{r4, pc}
c0d084ce:	46c0      	nop			; (mov r8, r8)

c0d084d0 <__clzsi2>:
c0d084d0:	211c      	movs	r1, #28
c0d084d2:	2301      	movs	r3, #1
c0d084d4:	041b      	lsls	r3, r3, #16
c0d084d6:	4298      	cmp	r0, r3
c0d084d8:	d301      	bcc.n	c0d084de <__clzsi2+0xe>
c0d084da:	0c00      	lsrs	r0, r0, #16
c0d084dc:	3910      	subs	r1, #16
c0d084de:	0a1b      	lsrs	r3, r3, #8
c0d084e0:	4298      	cmp	r0, r3
c0d084e2:	d301      	bcc.n	c0d084e8 <__clzsi2+0x18>
c0d084e4:	0a00      	lsrs	r0, r0, #8
c0d084e6:	3908      	subs	r1, #8
c0d084e8:	091b      	lsrs	r3, r3, #4
c0d084ea:	4298      	cmp	r0, r3
c0d084ec:	d301      	bcc.n	c0d084f2 <__clzsi2+0x22>
c0d084ee:	0900      	lsrs	r0, r0, #4
c0d084f0:	3904      	subs	r1, #4
c0d084f2:	a202      	add	r2, pc, #8	; (adr r2, c0d084fc <__clzsi2+0x2c>)
c0d084f4:	5c10      	ldrb	r0, [r2, r0]
c0d084f6:	1840      	adds	r0, r0, r1
c0d084f8:	4770      	bx	lr
c0d084fa:	46c0      	nop			; (mov r8, r8)
c0d084fc:	02020304 	.word	0x02020304
c0d08500:	01010101 	.word	0x01010101
	...

c0d0850c <__aeabi_memclr>:
c0d0850c:	b510      	push	{r4, lr}
c0d0850e:	2200      	movs	r2, #0
c0d08510:	f000 f809 	bl	c0d08526 <__aeabi_memset>
c0d08514:	bd10      	pop	{r4, pc}

c0d08516 <__aeabi_memcpy>:
c0d08516:	b510      	push	{r4, lr}
c0d08518:	f000 f81e 	bl	c0d08558 <memcpy>
c0d0851c:	bd10      	pop	{r4, pc}

c0d0851e <__aeabi_memmove>:
c0d0851e:	b510      	push	{r4, lr}
c0d08520:	f000 f823 	bl	c0d0856a <memmove>
c0d08524:	bd10      	pop	{r4, pc}

c0d08526 <__aeabi_memset>:
c0d08526:	000b      	movs	r3, r1
c0d08528:	b510      	push	{r4, lr}
c0d0852a:	0011      	movs	r1, r2
c0d0852c:	001a      	movs	r2, r3
c0d0852e:	f000 f82f 	bl	c0d08590 <memset>
c0d08532:	bd10      	pop	{r4, pc}

c0d08534 <explicit_bzero>:
c0d08534:	b510      	push	{r4, lr}
c0d08536:	f000 f85e 	bl	c0d085f6 <bzero>
c0d0853a:	bd10      	pop	{r4, pc}

c0d0853c <memcmp>:
c0d0853c:	b530      	push	{r4, r5, lr}
c0d0853e:	2400      	movs	r4, #0
c0d08540:	3901      	subs	r1, #1
c0d08542:	42a2      	cmp	r2, r4
c0d08544:	d101      	bne.n	c0d0854a <memcmp+0xe>
c0d08546:	2000      	movs	r0, #0
c0d08548:	e005      	b.n	c0d08556 <memcmp+0x1a>
c0d0854a:	5d03      	ldrb	r3, [r0, r4]
c0d0854c:	3401      	adds	r4, #1
c0d0854e:	5d0d      	ldrb	r5, [r1, r4]
c0d08550:	42ab      	cmp	r3, r5
c0d08552:	d0f6      	beq.n	c0d08542 <memcmp+0x6>
c0d08554:	1b58      	subs	r0, r3, r5
c0d08556:	bd30      	pop	{r4, r5, pc}

c0d08558 <memcpy>:
c0d08558:	2300      	movs	r3, #0
c0d0855a:	b510      	push	{r4, lr}
c0d0855c:	429a      	cmp	r2, r3
c0d0855e:	d100      	bne.n	c0d08562 <memcpy+0xa>
c0d08560:	bd10      	pop	{r4, pc}
c0d08562:	5ccc      	ldrb	r4, [r1, r3]
c0d08564:	54c4      	strb	r4, [r0, r3]
c0d08566:	3301      	adds	r3, #1
c0d08568:	e7f8      	b.n	c0d0855c <memcpy+0x4>

c0d0856a <memmove>:
c0d0856a:	b510      	push	{r4, lr}
c0d0856c:	4288      	cmp	r0, r1
c0d0856e:	d902      	bls.n	c0d08576 <memmove+0xc>
c0d08570:	188b      	adds	r3, r1, r2
c0d08572:	4298      	cmp	r0, r3
c0d08574:	d303      	bcc.n	c0d0857e <memmove+0x14>
c0d08576:	2300      	movs	r3, #0
c0d08578:	e007      	b.n	c0d0858a <memmove+0x20>
c0d0857a:	5c8b      	ldrb	r3, [r1, r2]
c0d0857c:	5483      	strb	r3, [r0, r2]
c0d0857e:	3a01      	subs	r2, #1
c0d08580:	d2fb      	bcs.n	c0d0857a <memmove+0x10>
c0d08582:	bd10      	pop	{r4, pc}
c0d08584:	5ccc      	ldrb	r4, [r1, r3]
c0d08586:	54c4      	strb	r4, [r0, r3]
c0d08588:	3301      	adds	r3, #1
c0d0858a:	429a      	cmp	r2, r3
c0d0858c:	d1fa      	bne.n	c0d08584 <memmove+0x1a>
c0d0858e:	e7f8      	b.n	c0d08582 <memmove+0x18>

c0d08590 <memset>:
c0d08590:	0003      	movs	r3, r0
c0d08592:	1882      	adds	r2, r0, r2
c0d08594:	4293      	cmp	r3, r2
c0d08596:	d100      	bne.n	c0d0859a <memset+0xa>
c0d08598:	4770      	bx	lr
c0d0859a:	7019      	strb	r1, [r3, #0]
c0d0859c:	3301      	adds	r3, #1
c0d0859e:	e7f9      	b.n	c0d08594 <memset+0x4>

c0d085a0 <setjmp>:
c0d085a0:	c0f0      	stmia	r0!, {r4, r5, r6, r7}
c0d085a2:	4641      	mov	r1, r8
c0d085a4:	464a      	mov	r2, r9
c0d085a6:	4653      	mov	r3, sl
c0d085a8:	465c      	mov	r4, fp
c0d085aa:	466d      	mov	r5, sp
c0d085ac:	4676      	mov	r6, lr
c0d085ae:	c07e      	stmia	r0!, {r1, r2, r3, r4, r5, r6}
c0d085b0:	3828      	subs	r0, #40	; 0x28
c0d085b2:	c8f0      	ldmia	r0!, {r4, r5, r6, r7}
c0d085b4:	2000      	movs	r0, #0
c0d085b6:	4770      	bx	lr

c0d085b8 <longjmp>:
c0d085b8:	3010      	adds	r0, #16
c0d085ba:	c87c      	ldmia	r0!, {r2, r3, r4, r5, r6}
c0d085bc:	4690      	mov	r8, r2
c0d085be:	4699      	mov	r9, r3
c0d085c0:	46a2      	mov	sl, r4
c0d085c2:	46ab      	mov	fp, r5
c0d085c4:	46b5      	mov	sp, r6
c0d085c6:	c808      	ldmia	r0!, {r3}
c0d085c8:	3828      	subs	r0, #40	; 0x28
c0d085ca:	c8f0      	ldmia	r0!, {r4, r5, r6, r7}
c0d085cc:	1c08      	adds	r0, r1, #0
c0d085ce:	d100      	bne.n	c0d085d2 <longjmp+0x1a>
c0d085d0:	2001      	movs	r0, #1
c0d085d2:	4718      	bx	r3

c0d085d4 <strcmp>:
c0d085d4:	7802      	ldrb	r2, [r0, #0]
c0d085d6:	780b      	ldrb	r3, [r1, #0]
c0d085d8:	2a00      	cmp	r2, #0
c0d085da:	d003      	beq.n	c0d085e4 <strcmp+0x10>
c0d085dc:	3001      	adds	r0, #1
c0d085de:	3101      	adds	r1, #1
c0d085e0:	429a      	cmp	r2, r3
c0d085e2:	d0f7      	beq.n	c0d085d4 <strcmp>
c0d085e4:	1ad0      	subs	r0, r2, r3
c0d085e6:	4770      	bx	lr

c0d085e8 <strlen>:
c0d085e8:	2300      	movs	r3, #0
c0d085ea:	5cc2      	ldrb	r2, [r0, r3]
c0d085ec:	3301      	adds	r3, #1
c0d085ee:	2a00      	cmp	r2, #0
c0d085f0:	d1fb      	bne.n	c0d085ea <strlen+0x2>
c0d085f2:	1e58      	subs	r0, r3, #1
c0d085f4:	4770      	bx	lr

c0d085f6 <bzero>:
c0d085f6:	b510      	push	{r4, lr}
c0d085f8:	000a      	movs	r2, r1
c0d085fa:	2100      	movs	r1, #0
c0d085fc:	f7ff ffc8 	bl	c0d08590 <memset>
c0d08600:	bd10      	pop	{r4, pc}
c0d08602:	6156      	.short	0x6156
c0d08604:	6164696c 	.word	0x6164696c
c0d08608:	6e6f6974 	.word	0x6e6f6974
c0d0860c:	72724520 	.word	0x72724520
c0d08610:	6920726f 	.word	0x6920726f
c0d08614:	7325206e 	.word	0x7325206e
c0d08618:	6425203a 	.word	0x6425203a
c0d0861c:	7273000a 	.word	0x7273000a
c0d08620:	69622f63 	.word	0x69622f63
c0d08624:	2e343470 	.word	0x2e343470
c0d08628:	72730063 	.word	0x72730063
c0d0862c:	69622f63 	.word	0x69622f63
c0d08630:	2e343470 	.word	0x2e343470
c0d08634:	39333a63 	.word	0x39333a63
c0d08638:	63727300 	.word	0x63727300
c0d0863c:	7069622f 	.word	0x7069622f
c0d08640:	632e3434 	.word	0x632e3434
c0d08644:	0035363a 	.word	0x0035363a
c0d08648:	2f637273 	.word	0x2f637273
c0d0864c:	34706962 	.word	0x34706962
c0d08650:	3a632e34 	.word	0x3a632e34
c0d08654:	73003538 	.word	0x73003538
c0d08658:	622f6372 	.word	0x622f6372
c0d0865c:	34347069 	.word	0x34347069
c0d08660:	383a632e 	.word	0x383a632e
c0d08664:	72730037 	.word	0x72730037
c0d08668:	69622f63 	.word	0x69622f63
c0d0866c:	2e343470 	.word	0x2e343470
c0d08670:	30313a63 	.word	0x30313a63
c0d08674:	006d0038 	.word	0x006d0038
c0d08678:	2f637273 	.word	0x2f637273
c0d0867c:	34706962 	.word	0x34706962
c0d08680:	3a632e34 	.word	0x3a632e34
c0d08684:	00303131 	.word	0x00303131
c0d08688:	2f637273 	.word	0x2f637273
c0d0868c:	34706962 	.word	0x34706962
c0d08690:	3a632e34 	.word	0x3a632e34
c0d08694:	00363131 	.word	0x00363131
c0d08698:	2764252f 	.word	0x2764252f
c0d0869c:	63727300 	.word	0x63727300
c0d086a0:	7069622f 	.word	0x7069622f
c0d086a4:	632e3434 	.word	0x632e3434
c0d086a8:	3831313a 	.word	0x3831313a
c0d086ac:	64252f00 	.word	0x64252f00
c0d086b0:	63727300 	.word	0x63727300
c0d086b4:	7069622f 	.word	0x7069622f
c0d086b8:	632e3434 	.word	0x632e3434
c0d086bc:	3232313a 	.word	0x3232313a
c0d086c0:	63727300 	.word	0x63727300
c0d086c4:	7069622f 	.word	0x7069622f
c0d086c8:	632e3434 	.word	0x632e3434
c0d086cc:	3332313a 	.word	0x3332313a
c0d086d0:	00732500 	.word	0x00732500
c0d086d4:	74736574 	.word	0x74736574
c0d086d8:	65736163 	.word	0x65736163
c0d086dc:	7069625f 	.word	0x7069625f
c0d086e0:	705f3434 	.word	0x705f3434
c0d086e4:	746e6972 	.word	0x746e6972
c0d086e8:	74536f54 	.word	0x74536f54
c0d086ec:	73252072 	.word	0x73252072
c0d086f0:	7273000a 	.word	0x7273000a
c0d086f4:	69622f63 	.word	0x69622f63
c0d086f8:	5f343470 	.word	0x5f343470
c0d086fc:	74736574 	.word	0x74736574
c0d08700:	323a632e 	.word	0x323a632e
c0d08704:	72730033 	.word	0x72730033
c0d08708:	69622f63 	.word	0x69622f63
c0d0870c:	5f343470 	.word	0x5f343470
c0d08710:	74736574 	.word	0x74736574
c0d08714:	323a632e 	.word	0x323a632e
c0d08718:	72730038 	.word	0x72730038
c0d0871c:	69622f63 	.word	0x69622f63
c0d08720:	5f343470 	.word	0x5f343470
c0d08724:	74736574 	.word	0x74736574
c0d08728:	323a632e 	.word	0x323a632e
c0d0872c:	2f6d0039 	.word	0x2f6d0039
c0d08730:	2f322f31 	.word	0x2f322f31
c0d08734:	2f342f33 	.word	0x2f342f33
c0d08738:	2f362f35 	.word	0x2f362f35
c0d0873c:	2f6d0037 	.word	0x2f6d0037
c0d08740:	2f273434 	.word	0x2f273434
c0d08744:	35313831 	.word	0x35313831
c0d08748:	27302f27 	.word	0x27302f27
c0d0874c:	352f312f 	.word	0x352f312f
c0d08750:	2f6d0035 	.word	0x2f6d0035
c0d08754:	2f273434 	.word	0x2f273434
c0d08758:	35313831 	.word	0x35313831
c0d0875c:	00000027 	.word	0x00000027
c0d08760:	00000001 	.word	0x00000001
c0d08764:	00000002 	.word	0x00000002
c0d08768:	00000003 	.word	0x00000003
c0d0876c:	00000004 	.word	0x00000004
c0d08770:	00000005 	.word	0x00000005
c0d08774:	00000006 	.word	0x00000006
c0d08778:	00000007 	.word	0x00000007
c0d0877c:	8000002c 	.word	0x8000002c
c0d08780:	80000717 	.word	0x80000717
c0d08784:	80000000 	.word	0x80000000
c0d08788:	00000001 	.word	0x00000001
c0d0878c:	00000037 	.word	0x00000037
c0d08790:	2f637273 	.word	0x2f637273
c0d08794:	69646e65 	.word	0x69646e65
c0d08798:	745f6e61 	.word	0x745f6e61
c0d0879c:	2e747365 	.word	0x2e747365
c0d087a0:	31313a63 	.word	0x31313a63
c0d087a4:	63727300 	.word	0x63727300
c0d087a8:	646e652f 	.word	0x646e652f
c0d087ac:	5f6e6169 	.word	0x5f6e6169
c0d087b0:	74736574 	.word	0x74736574
c0d087b4:	313a632e 	.word	0x313a632e
c0d087b8:	72730032 	.word	0x72730032
c0d087bc:	6e652f63 	.word	0x6e652f63
c0d087c0:	6e616964 	.word	0x6e616964
c0d087c4:	7365745f 	.word	0x7365745f
c0d087c8:	3a632e74 	.word	0x3a632e74
c0d087cc:	73003331 	.word	0x73003331
c0d087d0:	652f6372 	.word	0x652f6372
c0d087d4:	6169646e 	.word	0x6169646e
c0d087d8:	65745f6e 	.word	0x65745f6e
c0d087dc:	632e7473 	.word	0x632e7473
c0d087e0:	0035313a 	.word	0x0035313a
c0d087e4:	2f637273 	.word	0x2f637273
c0d087e8:	69646e65 	.word	0x69646e65
c0d087ec:	745f6e61 	.word	0x745f6e61
c0d087f0:	2e747365 	.word	0x2e747365
c0d087f4:	36313a63 	.word	0x36313a63
c0d087f8:	63727300 	.word	0x63727300
c0d087fc:	646e652f 	.word	0x646e652f
c0d08800:	5f6e6169 	.word	0x5f6e6169
c0d08804:	74736574 	.word	0x74736574
c0d08808:	313a632e 	.word	0x313a632e
c0d0880c:	72730037 	.word	0x72730037
c0d08810:	6e652f63 	.word	0x6e652f63
c0d08814:	6e616964 	.word	0x6e616964
c0d08818:	7365745f 	.word	0x7365745f
c0d0881c:	3a632e74 	.word	0x3a632e74
c0d08820:	73003931 	.word	0x73003931
c0d08824:	652f6372 	.word	0x652f6372
c0d08828:	6169646e 	.word	0x6169646e
c0d0882c:	65745f6e 	.word	0x65745f6e
c0d08830:	632e7473 	.word	0x632e7473
c0d08834:	0030323a 	.word	0x0030323a
c0d08838:	2f637273 	.word	0x2f637273
c0d0883c:	69646e65 	.word	0x69646e65
c0d08840:	745f6e61 	.word	0x745f6e61
c0d08844:	2e747365 	.word	0x2e747365
c0d08848:	31323a63 	.word	0x31323a63
c0d0884c:	63727300 	.word	0x63727300
c0d08850:	646e652f 	.word	0x646e652f
c0d08854:	5f6e6169 	.word	0x5f6e6169
c0d08858:	74736574 	.word	0x74736574
c0d0885c:	323a632e 	.word	0x323a632e
c0d08860:	72730033 	.word	0x72730033
c0d08864:	6e652f63 	.word	0x6e652f63
c0d08868:	6e616964 	.word	0x6e616964
c0d0886c:	7365745f 	.word	0x7365745f
c0d08870:	3a632e74 	.word	0x3a632e74
c0d08874:	73003432 	.word	0x73003432
c0d08878:	652f6372 	.word	0x652f6372
c0d0887c:	6169646e 	.word	0x6169646e
c0d08880:	65745f6e 	.word	0x65745f6e
c0d08884:	632e7473 	.word	0x632e7473
c0d08888:	0035323a 	.word	0x0035323a
c0d0888c:	2f637273 	.word	0x2f637273
c0d08890:	69646e65 	.word	0x69646e65
c0d08894:	745f6e61 	.word	0x745f6e61
c0d08898:	2e747365 	.word	0x2e747365
c0d0889c:	37333a63 	.word	0x37333a63
c0d088a0:	63727300 	.word	0x63727300
c0d088a4:	646e652f 	.word	0x646e652f
c0d088a8:	5f6e6169 	.word	0x5f6e6169
c0d088ac:	74736574 	.word	0x74736574
c0d088b0:	333a632e 	.word	0x333a632e
c0d088b4:	72730038 	.word	0x72730038
c0d088b8:	6e652f63 	.word	0x6e652f63
c0d088bc:	6e616964 	.word	0x6e616964
c0d088c0:	7365745f 	.word	0x7365745f
c0d088c4:	3a632e74 	.word	0x3a632e74
c0d088c8:	73003933 	.word	0x73003933
c0d088cc:	652f6372 	.word	0x652f6372
c0d088d0:	6169646e 	.word	0x6169646e
c0d088d4:	65745f6e 	.word	0x65745f6e
c0d088d8:	632e7473 	.word	0x632e7473
c0d088dc:	0033343a 	.word	0x0033343a
c0d088e0:	2f637273 	.word	0x2f637273
c0d088e4:	69646e65 	.word	0x69646e65
c0d088e8:	745f6e61 	.word	0x745f6e61
c0d088ec:	2e747365 	.word	0x2e747365
c0d088f0:	34343a63 	.word	0x34343a63
c0d088f4:	63727300 	.word	0x63727300
c0d088f8:	646e652f 	.word	0x646e652f
c0d088fc:	5f6e6169 	.word	0x5f6e6169
c0d08900:	74736574 	.word	0x74736574
c0d08904:	343a632e 	.word	0x343a632e
c0d08908:	72730035 	.word	0x72730035
c0d0890c:	6e652f63 	.word	0x6e652f63
c0d08910:	6e616964 	.word	0x6e616964
c0d08914:	7365745f 	.word	0x7365745f
c0d08918:	3a632e74 	.word	0x3a632e74
c0d0891c:	73003834 	.word	0x73003834
c0d08920:	652f6372 	.word	0x652f6372
c0d08924:	6169646e 	.word	0x6169646e
c0d08928:	65745f6e 	.word	0x65745f6e
c0d0892c:	632e7473 	.word	0x632e7473
c0d08930:	0039343a 	.word	0x0039343a
c0d08934:	2f637273 	.word	0x2f637273
c0d08938:	69646e65 	.word	0x69646e65
c0d0893c:	745f6e61 	.word	0x745f6e61
c0d08940:	2e747365 	.word	0x2e747365
c0d08944:	30353a63 	.word	0x30353a63
c0d08948:	63727300 	.word	0x63727300
c0d0894c:	646e652f 	.word	0x646e652f
c0d08950:	5f6e6169 	.word	0x5f6e6169
c0d08954:	74736574 	.word	0x74736574
c0d08958:	353a632e 	.word	0x353a632e
c0d0895c:	72730033 	.word	0x72730033
c0d08960:	6e652f63 	.word	0x6e652f63
c0d08964:	6e616964 	.word	0x6e616964
c0d08968:	7365745f 	.word	0x7365745f
c0d0896c:	3a632e74 	.word	0x3a632e74
c0d08970:	73003435 	.word	0x73003435
c0d08974:	652f6372 	.word	0x652f6372
c0d08978:	6169646e 	.word	0x6169646e
c0d0897c:	65745f6e 	.word	0x65745f6e
c0d08980:	632e7473 	.word	0x632e7473
c0d08984:	0035353a 	.word	0x0035353a
c0d08988:	5f6e7572 	.word	0x5f6e7572
c0d0898c:	69646e65 	.word	0x69646e65
c0d08990:	745f6e61 	.word	0x745f6e61
c0d08994:	0a747365 	.word	0x0a747365
c0d08998:	00          	.byte	0x00
c0d08999:	73          	.byte	0x73
c0d0899a:	6372      	.short	0x6372
c0d0899c:	7465672f 	.word	0x7465672f
c0d089a0:	6c627550 	.word	0x6c627550
c0d089a4:	654b6369 	.word	0x654b6369
c0d089a8:	00632e79 	.word	0x00632e79
c0d089ac:	2f637273 	.word	0x2f637273
c0d089b0:	50746567 	.word	0x50746567
c0d089b4:	696c6275 	.word	0x696c6275
c0d089b8:	79654b63 	.word	0x79654b63
c0d089bc:	313a632e 	.word	0x313a632e
c0d089c0:	5b003334 	.word	0x5b003334
c0d089c4:	253a7325 	.word	0x253a7325
c0d089c8:	00205d64 	.word	0x00205d64
c0d089cc:	50746567 	.word	0x50746567
c0d089d0:	696c6275 	.word	0x696c6275
c0d089d4:	79654b63 	.word	0x79654b63
c0d089d8:	6e61685f 	.word	0x6e61685f
c0d089dc:	41656c64 	.word	0x41656c64
c0d089e0:	00554450 	.word	0x00554450
c0d089e4:	682a2e25 	.word	0x682a2e25
c0d089e8:	63727300 	.word	0x63727300
c0d089ec:	7465672f 	.word	0x7465672f
c0d089f0:	6c627550 	.word	0x6c627550
c0d089f4:	654b6369 	.word	0x654b6369
c0d089f8:	3a632e79 	.word	0x3a632e79
c0d089fc:	72003339 	.word	0x72003339
c0d08a00:	65476e75 	.word	0x65476e75
c0d08a04:	62755074 	.word	0x62755074
c0d08a08:	4b63696c 	.word	0x4b63696c
c0d08a0c:	49557965 	.word	0x49557965
c0d08a10:	776f6c46 	.word	0x776f6c46
c0d08a14:	6c6f5000 	.word	0x6c6f5000
c0d08a18:	3a796369 	.word	0x3a796369
c0d08a1c:	00642520 	.word	0x00642520
c0d08a20:	2f637273 	.word	0x2f637273
c0d08a24:	50746567 	.word	0x50746567
c0d08a28:	696c6275 	.word	0x696c6275
c0d08a2c:	79654b63 	.word	0x79654b63
c0d08a30:	313a632e 	.word	0x313a632e
c0d08a34:	67003831 	.word	0x67003831
c0d08a38:	75507465 	.word	0x75507465
c0d08a3c:	63696c62 	.word	0x63696c62
c0d08a40:	5f79654b 	.word	0x5f79654b
c0d08a44:	725f6975 	.word	0x725f6975
c0d08a48:	74536e75 	.word	0x74536e75
c0d08a4c:	55007065 	.word	0x55007065
c0d08a50:	74732049 	.word	0x74732049
c0d08a54:	25207065 	.word	0x25207065
c0d08a58:	72730064 	.word	0x72730064
c0d08a5c:	65672f63 	.word	0x65672f63
c0d08a60:	62755074 	.word	0x62755074
c0d08a64:	4b63696c 	.word	0x4b63696c
c0d08a68:	632e7965 	.word	0x632e7965
c0d08a6c:	0033353a 	.word	0x0033353a
c0d08a70:	73756e55 	.word	0x73756e55
c0d08a74:	206c6175 	.word	0x206c6175
c0d08a78:	75716572 	.word	0x75716572
c0d08a7c:	00747365 	.word	0x00747365
c0d08a80:	636f7250 	.word	0x636f7250
c0d08a84:	20646565 	.word	0x20646565
c0d08a88:	68746977 	.word	0x68746977
c0d08a8c:	72616320 	.word	0x72616320
c0d08a90:	78450065 	.word	0x78450065
c0d08a94:	74726f70 	.word	0x74726f70
c0d08a98:	62757020 	.word	0x62757020
c0d08a9c:	2063696c 	.word	0x2063696c
c0d08aa0:	0079656b 	.word	0x0079656b
c0d08aa4:	6c627550 	.word	0x6c627550
c0d08aa8:	6b206369 	.word	0x6b206369
c0d08aac:	43007965 	.word	0x43007965
c0d08ab0:	69666e6f 	.word	0x69666e6f
c0d08ab4:	65206d72 	.word	0x65206d72
c0d08ab8:	726f7078 	.word	0x726f7078
c0d08abc:	75700074 	.word	0x75700074
c0d08ac0:	63696c62 	.word	0x63696c62
c0d08ac4:	79656b20 	.word	0x79656b20
c0d08ac8:	7273003f 	.word	0x7273003f
c0d08acc:	65672f63 	.word	0x65672f63
c0d08ad0:	62755074 	.word	0x62755074
c0d08ad4:	4b63696c 	.word	0x4b63696c
c0d08ad8:	632e7965 	.word	0x632e7965
c0d08adc:	0037373a 	.word	0x0037373a
c0d08ae0:	6f707845 	.word	0x6f707845
c0d08ae4:	64207472 	.word	0x64207472
c0d08ae8:	2e656e6f 	.word	0x2e656e6f
c0d08aec:	76646100 	.word	0x76646100
c0d08af0:	65636e61 	.word	0x65636e61
c0d08af4:	67617453 	.word	0x67617453
c0d08af8:	64410065 	.word	0x64410065
c0d08afc:	636e6176 	.word	0x636e6176
c0d08b00:	20676e69 	.word	0x20676e69
c0d08b04:	6d6f7266 	.word	0x6d6f7266
c0d08b08:	61747320 	.word	0x61747320
c0d08b0c:	203a6567 	.word	0x203a6567
c0d08b10:	73006425 	.word	0x73006425
c0d08b14:	672f6372 	.word	0x672f6372
c0d08b18:	75507465 	.word	0x75507465
c0d08b1c:	63696c62 	.word	0x63696c62
c0d08b20:	2e79654b 	.word	0x2e79654b
c0d08b24:	33333a63 	.word	0x33333a63
c0d08b28:	00          	.byte	0x00
c0d08b29:	73          	.byte	0x73
c0d08b2a:	6372      	.short	0x6372
c0d08b2c:	7465672f 	.word	0x7465672f
c0d08b30:	69726553 	.word	0x69726553
c0d08b34:	632e6c61 	.word	0x632e6c61
c0d08b38:	74656700 	.word	0x74656700
c0d08b3c:	69726553 	.word	0x69726553
c0d08b40:	685f6c61 	.word	0x685f6c61
c0d08b44:	6c646e61 	.word	0x6c646e61
c0d08b48:	44504165 	.word	0x44504165
c0d08b4c:	72730055 	.word	0x72730055
c0d08b50:	65672f63 	.word	0x65672f63
c0d08b54:	72655374 	.word	0x72655374
c0d08b58:	2e6c6169 	.word	0x2e6c6169
c0d08b5c:	37323a63 	.word	0x37323a63
c0d08b60:	00          	.byte	0x00
c0d08b61:	73          	.byte	0x73
c0d08b62:	6372      	.short	0x6372
c0d08b64:	7465672f 	.word	0x7465672f
c0d08b68:	73726556 	.word	0x73726556
c0d08b6c:	2e6e6f69 	.word	0x2e6e6f69
c0d08b70:	00000063 	.word	0x00000063

c0d08b74 <C_icon_back_colors>:
c0d08b74:	00000000 00ffffff                       ........

c0d08b7c <C_icon_back_bitmap>:
c0d08b7c:	c1fe01e0 067f38fd c4ff81df bcfff37f     .....8..........
c0d08b8c:	f1e7e71f 7807f83f 00000000              ....?..x....

c0d08b98 <C_icon_back>:
c0d08b98:	0000000e 0000000e 00000001 c0d08b74     ............t...
c0d08ba8:	c0d08b7c                                |...

c0d08bac <C_icon_dashboard_colors>:
c0d08bac:	00000000 00ffffff                       ........

c0d08bb4 <C_icon_dashboard_bitmap>:
c0d08bb4:	c1fe01e0 067038ff 9e7e79d8 b9e7e79f     .....8p..y~.....
c0d08bc4:	f1c0e601 7807f83f 00000000              ....?..x....

c0d08bd0 <C_icon_dashboard>:
c0d08bd0:	0000000e 0000000e 00000001 c0d08bac     ................
c0d08be0:	c0d08bb4 2f637273 55786568 736c6974     ....src/hexUtils
c0d08bf0:	343a632e 72730034 65682f63 69745578     .c:44.src/hexUti
c0d08c00:	632e736c 0035343a 2f637273 55786568     ls.c:45.src/hexU
c0d08c10:	736c6974 343a632e                        tils.c:46.

c0d08c1a <HEX_ALPHABET>:
c0d08c1a:	33323130 37363534 62613938 66656463     0123456789abcdef
c0d08c2a:	63727300 7865682f 6c697455 3a632e73     .src/hexUtils.c:
c0d08c3a:	74003335 5f747365 5f786568 6262696e     53.test_hex_nibb
c0d08c4a:	000a656c 2f637273 55786568 736c6974     le..src/hexUtils
c0d08c5a:	393a632e 65740034 685f7473 6e5f7865     .c:94.test_hex_n
c0d08c6a:	6c626269 6e692065 696c6176 73000a64     ibble invalid..s
c0d08c7a:	682f6372 74557865 2e736c69 31313a63     rc/hexUtils.c:11
c0d08c8a:	66660034 00613100 33006232 64340063     4.ff.1a.2b.3c.4d
c0d08c9a:	00663500 74003839 5f747365 5f786568     .5f.98.test_hex_
c0d08caa:	73726170 0a676e69 63727300 7865682f     parsing..src/hex
c0d08cba:	6c697455 3a632e73 00363331 00300000     Utils.c:136...0.
c0d08cca:	00000000 00310000 00010000 00320000     ......1.......2.
c0d08cda:	00020000 00330000 00030000 00340000     ......3.......4.
c0d08cea:	00040000 00350000 00050000 00360000     ......5.......6.
c0d08cfa:	00060000 00370000 00070000 00380000     ......7.......8.
c0d08d0a:	00080000 00390000 00090000 00610000     ......9.......a.
c0d08d1a:	000a0000 00620000 000b0000 00630000     ......b.......c.
c0d08d2a:	000c0000 00640000 000d0000 00650000     ......d.......e.
c0d08d3a:	000e0000 00660000 000f0000 00410000     ......f.......A.
c0d08d4a:	000a0000 00420000 000b0000 00430000     ......B.......C.
c0d08d5a:	000c0000 00440000 000d0000 00450000     ......D.......E.
c0d08d6a:	000e0000 00460000 000f0000 01000000     ......F.........
c0d08d7a:	3b3a2f2e 4847403f 5f5c5b5a 7a686760     ./:;?@GHZ[\_`ghz
c0d08d8a:	ff807f7b 8c8c0000 00ffc0d0 91d60000     {...............
c0d08d9a:	0000c0d0 8c8f0000 001ac0d0 8c920000     ................
c0d08daa:	002bc0d0 8c950000 003cc0d0 8c980000     ..+.......<.....
c0d08dba:	004dc0d0 8c9b0000 005fc0d0 8c9e0000     ..M......._.....
c0d08dca:	0098c0d0 72730000 6f692f63 323a632e     ......src/io.c:2
c0d08dda:	72730030 6f692f63 323a632e 72730031     0.src/io.c:21.sr
c0d08dea:	6f692f63 343a632e 72730032 6f692f63     c/io.c:42.src/io
c0d08dfa:	343a632e 72730033 6f692f63 383a632e     .c:43.src/io.c:8
c0d08e0a:	6f690036 6576655f 7400746e 72656d69     6.io_event.timer
c0d08e1a:	63727300 79656b2f 69726544 69746176     .src/keyDerivati
c0d08e2a:	632e6e6f 0033323a 74736574 65736163     on.c:23.testcase
c0d08e3a:	7265645f 50657669 61766972 654b6574     _derivePrivateKe
c0d08e4a:	74002079 63747365 5f657361 69726564     y .testcase_deri
c0d08e5a:	72506576 74617669 79654b65 63727300     vePrivateKey.src
c0d08e6a:	79656b2f 69726544 69746176 745f6e6f     /keyDerivation_t
c0d08e7a:	2e747365 34333a63 35643400 39383739     est.c:34.4d59789
c0d08e8a:	37626439 37386536 65333339 38366337     9db76e87933e7c68
c0d08e9a:	32633134 31363664 66303138 62303730     41c2d661810f070b
c0d08eaa:	30326461 65373834 65303266 65343862     ad20487ef20eb84e
c0d08eba:	36323831 33613539 37300061 38643236     182695a3a.0762d8
c0d08eca:	61623037 30306133 64353236 38633230     70ba3a00625d02c8
c0d08eda:	64343733 33646362 64316633 38643466     374dbcd33f1df4d8
c0d08eea:	62613166 38616162 37383339 63356261     f1abbaa89387ab5c
c0d08efa:	61666138 64333335 73003039 6b2f6372     8afa533d90.src/k
c0d08f0a:	65447965 61766972 6e6f6974 7365745f     eyDerivation_tes
c0d08f1a:	3a632e74 73003137 6b2f6372 65447965     t.c:71.src/keyDe
c0d08f2a:	61766972 6e6f6974 7365745f 3a632e74     rivation_test.c:
c0d08f3a:	73003237 6b2f6372 65447965 61766972     72.src/keyDeriva
c0d08f4a:	6e6f6974 7365745f 3a632e74 73003337     tion_test.c:73.s
c0d08f5a:	6b2f6372 65447965 61766972 6e6f6974     rc/keyDerivation
c0d08f6a:	7365745f 3a632e74 74003437 63747365     _test.c:74.testc
c0d08f7a:	5f657361 69726564 75506576 63696c62     ase_derivePublic
c0d08f8a:	2079654b 73657400 73616374 65645f65     Key .testcase_de
c0d08f9a:	65766972 6c627550 654b6369 72730079     rivePublicKey.sr
c0d08faa:	656b2f63 72654479 74617669 5f6e6f69     c/keyDerivation_
c0d08fba:	74736574 393a632e 34300037 32613961     test.c:97.04a9a2
c0d08fca:	63623232 61316233 38356135 31616461     22bc3b1a5a58ada1
c0d08fda:	30316437 62393630 31363933 30646265     7d10069b3961ebd0
c0d08fea:	37313966 32623464 30363031 30613133     f917d4b2106031a0
c0d08ffa:	31393136 39616335 34326363 39363061     61915ca9cc24a069
c0d0900a:	30653134 30633461 32653564 35383636     41e0a4c0d5e26685
c0d0901a:	39666630 64613038 61393433 30623862     0ff980ad349ab8b0
c0d0902a:	39633732 34666233 64616561 34383931     27c93bf4aead1984
c0d0903a:	61383631 65333464 62613033 38343000     168ad43e30ab.048
c0d0904a:	32356534 61656664 38623735 38373166     4e52dfea57b8f178
c0d0905a:	38383437 36353361 63343733 38653864     7488a356374cd8e8
c0d0906a:	62353135 38646138 64336264 39663464     515b8ad8db3dd4f9
c0d0907a:	64383830 32346538 66326465 35643662     088d8e42ed2fb6d5
c0d0908a:	38653137 63343938 64626363 35316662     71e8894cccbdbf15
c0d0909a:	64623165 38663438 36333462 32356632     e1bd84f8b4362f52
c0d090aa:	35623164 32313762 37373962 61306335     d1b5b712b9775c0a
c0d090ba:	64633135 65653564 65396139 00616338     51cdd5ee9a9e8ca.
c0d090ca:	6e6e7552 20676e69 2079656b 69726564     Running key deri
c0d090da:	69746176 74206e6f 73747365 6649000a     vation tests..If
c0d090ea:	65687420 61662079 202c6c69 656b616d      they fail, make
c0d090fa:	72757320 6f792065 65732075 64656465      sure you seeded
c0d0910a:	756f7920 65642072 65636976 74697720      your device wit
c0d0911a:	31000a68 6f772d32 6d206472 6f6d656e     h..12-word mnemo
c0d0912a:	3a63696e 2a313120 6e616261 206e6f64     nic: 11*abandon 
c0d0913a:	756f6261 00000a74 002b0000 00eb8000     about.....+.....
c0d0914a:	00008000 00008000 002c0000 00eb8000     ..........,.....
c0d0915a:	00010000 00008000 00000000 002c0000     ..............,.
c0d0916a:	00ea8000 00018000 00008000 00000000     ................
c0d0917a:	002c0000 00eb8000 00018000 00008000     ..,.............
	...
c0d09192:	002c0000 00eb8000 00008000 00008000     ..,.............
c0d091a2:	00000000 002c0000 00eb8000 00008000     ......,.........
c0d091b2:	00008000 07d00000 72730000 616d2f63     ..........src/ma
c0d091c2:	632e6e69 0035393a 2f637273 6e69616d     in.c:95.src/main
c0d091d2:	313a632e 73003030 6d2f6372 2e6e6961     .c:100.src/main.
c0d091e2:	69660063 616d5f6f 41006e69 3a554450     c.fio_main.APDU:
c0d091f2:	736e6920 25203d20 20202c64 20317020      ins = %d,   p1 
c0d09202:	6425203d 2020202c 20327020 6425203d     = %d,    p2 = %d
c0d09212:	636e5500 68677561 72652074 20726f72     .Uncaught error 
c0d09222:	78257830 72615700 676e696e 4544003a     0x%x.Warning:.DE
c0d09232:	204c4556 73726576 216e6f69 6f624100     VEL version!.Abo
c0d09242:	51007475 20746975 00707061 73726556     ut.Quit app.Vers
c0d09252:	006e6f69 2e302e30 61420031 00006b63     ion.0.0.1.Back..
	...

c0d09264 <menu_about>:
	...
c0d09274:	c0d0924e c0d09256 00000000 c0d092b8     N...V...........
	...
c0d0928c:	c0d08b98 c0d0925c 00000000 0000283d     ....\.......=(..
	...

c0d092b8 <menu_main>:
	...
c0d092c8:	c0d09227 c0d09230 00000000 c0d09264     '...0.......d...
	...
c0d092e4:	c0d0923f 00000000 00000000 00000000     ?...............
c0d092f4:	c0d02181 00000000 c0d08bd0 c0d09245     .!..........E...
c0d09304:	00000000 00001d32 00000000 00000000     ....2...........
	...
c0d09328:	65637865 6f697470 64255b6e 4c203a5d     exception[%d]: L
c0d09338:	78303d52 58383025                        R=0x%08X..

c0d09342 <seph_io_general_status>:
c0d09342:	00020060                                 `....

c0d09347 <seph_io_se_reset>:
c0d09347:	45000046 524f5252                        F..ERROR.

c0d09350 <g_pcHex>:
c0d09350:	33323130 37363534 62613938 66656463     0123456789abcdef

c0d09360 <g_pcHex_cap>:
c0d09360:	33323130 37363534 42413938 46454443     0123456789ABCDEF
c0d09370:	6e6e7552 20676e69 74736574 41000a73     Running tests..A
c0d09380:	74206c6c 73747365 6e6f6420 25000a65     ll tests done..%
c0d09390:	64253a73 78257820 63727300 6e75722f     s:%d x%x.src/run
c0d093a0:	74736554 00632e73 70736572 53646e6f     Tests.c.respondS
c0d093b0:	65636375 6d457373 4d797470 73006773     uccessEmptyMsg.s
c0d093c0:	732f6372 546e6769 736e6172 69746361     rc/signTransacti
c0d093d0:	632e6e6f 63727300 6769732f 6172546e     on.c.src/signTra
c0d093e0:	6361736e 6e6f6974 363a632e 72730032     nsaction.c:62.sr
c0d093f0:	69732f63 72546e67 61736e61 6f697463     c/signTransactio
c0d09400:	3a632e6e 73003539 732f6372 546e6769     n.c:95.src/signT
c0d09410:	736e6172 69746361 632e6e6f 3334313a     ransaction.c:143
c0d09420:	5a495300 20464f45 59444f42 6425203a     .SIZEOF BODY: %d
c0d09430:	67697300 5f78546e 646e6168 6553656c     .signTx_handleSe
c0d09440:	6144646e 50416174 73005544 732f6372     ndDataAPDU.src/s
c0d09450:	546e6769 736e6172 69746361 632e6e6f     ignTransaction.c
c0d09460:	3439333a 63727300 6769732f 6172546e     :394.src/signTra
c0d09470:	6361736e 6e6f6974 343a632e 73003135     nsaction.c:451.s
c0d09480:	732f6372 546e6769 736e6172 69746361     rc/signTransacti
c0d09490:	632e6e6f 3939343a 63727300 6769732f     on.c:499.src/sig
c0d094a0:	6172546e 6361736e 6e6f6974 353a632e     nTransaction.c:5
c0d094b0:	73003533 546e6769 61685f78 656c646e     35.signTx_handle
c0d094c0:	49646e45 61726574 6e6f6974 55445041     EndIterationAPDU
c0d094d0:	65744900 69746172 69206e6f 6765746e     .Iteration integ
c0d094e0:	79746972 73616820 73003a68 732f6372     rity hash:.src/s
c0d094f0:	546e6769 736e6172 69746361 632e6e6f     ignTransaction.c
c0d09500:	3435363a 67697300 5f78546e 646e6168     :654.signTx_hand
c0d09510:	6e45656c 44504164 6e490055 72676574     leEndAPDU.Integr
c0d09520:	20797469 68736168 000a0a3a 68736148     ity hash:...Hash
c0d09530:	544f4e20 4c4c4120 4445574f 73614800      NOT ALLOWED.Has
c0d09540:	4c412068 45574f4c 72700044 74617669     h ALLOWED.privat
c0d09550:	79654b65 003a642e 20797254 75206425     eKey.d:.Try %d u
c0d09560:	6375736e 66736563 216c6c75 20655720     nsuccesfull! We 
c0d09570:	6c6c6977 746f6e20 74656720 726f6320     will not get cor
c0d09580:	74636572 67697320 7574616e 21216572     rect signature!!
c0d09590:	21212121 21212121 21212121 21212121     !!!!!!!!!!!!!!!!
c0d095a0:	21212121 00212121 73646365 65645f61     !!!!!!!.ecdsa_de
c0d095b0:	6f745f72 6769735f 7365725f 3a746c75     r_to_sig_result:
c0d095c0:	67697300 6172546e 6361736e 6e6f6974     .signTransaction
c0d095d0:	6e61685f 41656c64 00554450 3d203150     _handleAPDU.P1 =
c0d095e0:	25783020 50202c78 203d2032 78257830      0x%x, P2 = 0x%x
c0d095f0:	7369202c 4377654e 206c6c61 6425203d     , isNewCall = %d
c0d09600:	63727300 7361682f 3a682e68 73003533     .src/hash.h:35.s
c0d09610:	325f6168 615f3635 6e657070 72730064     ha_256_append.sr
c0d09620:	61682f63 682e6873 0039343a 2f637273     c/hash.h:49.src/
c0d09630:	68736168 353a682e 72730030 69732f63     hash.h:50.src/si
c0d09640:	72546e67 61736e61 6f697463 3a632e6e     gnTransaction.c:
c0d09650:	00323931 2f637273 6e676973 6e617254     192.src/signTran
c0d09660:	74636173 2e6e6f69 32363a63 69530031     saction.c:621.Si
c0d09670:	74006e67 736e6172 69746361 003f6e6f     gn.transaction?.
c0d09680:	6e676973 685f7854 6c646e61 646e4565     signTx_handleEnd
c0d09690:	5f69755f 536e7572 00706574 65520a0a     _ui_runStep...Re
c0d096a0:	6e6f7073 676e6964 6573000a 5320746e     sponding..sent S
c0d096b0:	45434355 67005353 676e696f 206f7420     UCCESS.going to 
c0d096c0:	695f6975 28656c64 69750029 6c64695f     ui_idle().ui_idl
c0d096d0:	20292865 656e6f64                        e() done.

c0d096d9 <SECP256K1_N>:
c0d096d9:	ffffffff ffffffff ffffffff feffffff     ................
c0d096e9:	e6dcaeba 3ba048af 8c5ed2bf 414136d0     .....H.;..^..6AA

c0d096f9 <ALLOWED_HASHES>:
c0d096f9:	647c3417 98871f8f 2680a9c5 d8187c87     .4|d.......&.|..
c0d09709:	79734626 531e17c4 864b7737 62c02df1     &Fsy...S7wK..-.b
c0d09719:	2f637273 74786574 6c697455 3a632e73     src/textUtils.c:
c0d09729:	73003331 742f6372 55747865 736c6974     13.src/textUtils
c0d09739:	323a632e 72730033 65742f63 74557478     .c:23.src/textUt
c0d09749:	2e736c69 36323a63 63727300 7865742f     ils.c:26.src/tex
c0d09759:	69745574 632e736c 0032333a 2f637273     tUtils.c:32.src/
c0d09769:	74786574 6c697455 3a632e73 20003433     textUtils.c:34. 
c0d09779:	004f4946 2f637273 74786574 6c697455     FIO.src/textUtil
c0d09789:	3a632e73 73003735 742f6372 55747865     s.c:57.src/textU
c0d09799:	736c6974 363a632e 72730034 65742f63     tils.c:64.src/te
c0d097a9:	74557478 2e736c69 34373a63 63727300     xtUtils.c:74.src
c0d097b9:	7865742f 69745574 632e736c 0033393a     /textUtils.c:93.
c0d097c9:	2f637273 74786574 6c697455 3a632e73     src/textUtils.c:
c0d097d9:	00313031 2f637273 74786574 6c697455     101.src/textUtil
c0d097e9:	00632e73 74736574 65736163 726f665f     s.c.testcase_for
c0d097f9:	5574616d 36746e69 73252034 7273000a     matUint64 %s..sr
c0d09809:	65742f63 74557478 5f736c69 74736574     c/textUtils_test
c0d09819:	313a632e 72730039 65742f63 74557478     .c:19.src/textUt
c0d09829:	5f736c69 74736574 323a632e 72730030     ils_test.c:20.sr
c0d09839:	65742f63 74557478 5f736c69 74736574     c/textUtils_test
c0d09849:	323a632e 39340036 30383432 39340030     .c:26.4924800.49
c0d09859:	39373432 38310039 37363434 37303434     24799.1844674407
c0d09869:	39303733 36313535                        3709551615.

c0d09874 <SW_INTERNAL>:
c0d09874:	                                         o.

c0d09876 <SW_BUSY>:
c0d09876:	                                         ..

c0d09878 <SW_WRONG_LENGTH>:
c0d09878:	                                         g.

c0d0987a <SW_PROOF_OF_PRESENCE_REQUIRED>:
c0d0987a:	d0f18569 00000000                       i.......

c0d09882 <SW_BAD_KEY_HANDLE>:
c0d09882:	                                         j.

c0d09884 <U2F_VERSION>:
c0d09884:	5f463255 00903256                       U2F_V2..

c0d0988c <INFO>:
c0d0988c:	00900901                                ....

c0d09890 <SW_UNKNOWN_CLASS>:
c0d09890:	                                         n.

c0d09892 <SW_UNKNOWN_INSTRUCTION>:
c0d09892:	6552006d 73657571 6f742074 6e657320     m.Request to sen
c0d098a2:	6e6f2064 736e7520 6f707075 64657472     d on unsupported
c0d098b2:	64656d20 25206169 73000a64 752f6372      media %d..src/u
c0d098c2:	6c654869 73726570 333a632e 72730030     iHelpers.c:30.sr
c0d098d2:	69752f63 706c6548 2e737265 35333a63     c/uiHelpers.c:35
c0d098e2:	63727300 4869752f 65706c65 632e7372     .src/uiHelpers.c
c0d098f2:	0032353a 2f637273 65486975 7265706c     :52.src/uiHelper
c0d09902:	3a632e73 75003037 69645f69 616c7073     s.c:70.ui_displa
c0d09912:	6f725079 0074706d 63617473 6f70206b     yPrompt.stack po
c0d09922:	69746973 3d206e6f 00642520 3d3d3d3d     sition = %d.====
c0d09932:	3d3d3d3d 3d3d3d3d 3d3d3d3d 3d3d3d3d     ================
c0d09942:	7473203d 206b6361 7265766f 776f6c66     = stack overflow
c0d09952:	3d3d3d20 3d3d3d3d 3d3d3d3d 3d3d3d3d      ===============
c0d09962:	3d3d3d3d 73003d3d 752f6372 6c654869     ======.src/uiHel
c0d09972:	73726570 313a632e 73003734 752f6372     pers.c:147.src/u
c0d09982:	6c654869 73726570 313a632e 73003834     iHelpers.c:148.s
c0d09992:	752f6372 6c654869 73726570 313a632e     rc/uiHelpers.c:1
c0d099a2:	75003036 69645f69 616c7073 67615079     60.ui_displayPag
c0d099b2:	74616e69 65546465 73007478 752f6372     inatedText.src/u
c0d099c2:	6c654869 73726570 313a632e 73003538     iHelpers.c:185.s
c0d099d2:	752f6372 6c654869 73726570 313a632e     rc/uiHelpers.c:1
c0d099e2:	73003638 69747465 7420676e 6f656d69     86.setting timeo
c0d099f2:	73007475 752f6372 6c654869 73726570     ut.src/uiHelpers
c0d09a02:	323a632e 73003730 752f6372 6c654869     .c:207.src/uiHel
c0d09a12:	73726570 6e616e5f 632e736f 0035383a     pers_nanos.c:85.
c0d09a22:	2f637273 65486975 7265706c 616e5f73     src/uiHelpers_na
c0d09a32:	2e736f6e 36383a63 5f697500 69676170     nos.c:86.ui_pagi
c0d09a42:	6574616e 78655464 75625f74 6e6f7474     natedText_button
c0d09a52:	72724500 2520726f 73000a64 752f6372     .Error %d..src/u
c0d09a62:	6c654869 73726570 6e616e5f 632e736f     iHelpers_nanos.c
c0d09a72:	3431313a 63727300 4869752f 65706c65     :114.src/uiHelpe
c0d09a82:	6e5f7372 736f6e61 313a632e 75003531     rs_nanos.c:115.u
c0d09a92:	72705f69 74706d6f 7475625f 006e6f74     i_prompt_button.
c0d09aa2:	2f637273 65486975 7265706c 616e5f73     src/uiHelpers_na
c0d09ab2:	2e736f6e 37343a63 63727300 4869752f     nos.c:47.src/uiH
c0d09ac2:	65706c65 6e5f7372 736f6e61 343a632e     elpers_nanos.c:4
c0d09ad2:	2e2e0038                                 8.....

c0d09ad8 <ui_busy>:
c0d09ad8:	00000003 00800000 00000020 00000001     ........ .......
c0d09ae8:	00000000 00ffffff 00000000 00000000     ................
c0d09af8:	00000007 00800014 0000000c 00000000     ................
c0d09b08:	00ffffff 00000000 0000800a c0d09ad4     ................

c0d09b18 <ui_prompt>:
c0d09b18:	00000003 00800000 00000020 00000001     ........ .......
c0d09b28:	00000000 00ffffff 00000000 00000000     ................
c0d09b38:	00030405 0007000c 00000007 00000000     ................
c0d09b48:	00ffffff 00000000 00070000 00000000     ................
c0d09b58:	00750305 0008000d 00000006 00000000     ..u.............
c0d09b68:	00ffffff 00000000 00060000 00000000     ................
c0d09b78:	00000007 0080000c 0000000c 00000000     ................
c0d09b88:	00ffffff 00000000 0000800a 2000085e     ............^.. 
c0d09b98:	00000007 0080001a 0000000c 00000000     ................
c0d09ba8:	00ffffff 00000000 0000800a 2000087c     ............|.. 

c0d09bb8 <ui_paginatedText>:
c0d09bb8:	00000003 00800000 00000020 00000001     ........ .......
c0d09bc8:	00000000 00ffffff 00000000 00000000     ................
c0d09bd8:	00030105 0007000c 00000007 00000000     ................
c0d09be8:	00ffffff 00000000 00090000 00000000     ................
c0d09bf8:	00750205 0008000d 00000006 00000000     ..u.............
c0d09c08:	00ffffff 00000000 000a0000 00000000     ................
c0d09c18:	00000007 0080000c 0000000c 00000000     ................
c0d09c28:	00ffffff 00000000 0000800a 2000085e     ............^.. 
c0d09c38:	00000007 0080001a 0000000c 00000000     ................
c0d09c48:	00ffffff 00000000 0000800a 2000087c     ............|.. 
c0d09c58:	2f637273 63536975 6e656572 3a632e73     src/uiScreens.c:
c0d09c68:	73003331 752f6372 72635369 736e6565     13.src/uiScreens
c0d09c78:	313a632e 72730034 69752f63 65726353     .c:14.src/uiScre
c0d09c88:	2e736e65 34363a63 63727300 5369752f     ens.c:64.src/uiS
c0d09c98:	65657263 632e736e 0035363a 2f637273     creens.c:65.src/
c0d09ca8:	63536975 6e656572 3a632e73 73003636     uiScreens.c:66.s
c0d09cb8:	752f6372 72635369 736e6565 363a632e     rc/uiScreens.c:6
c0d09cc8:	72730037 69752f63 65726353 2e736e65     7.src/uiScreens.
c0d09cd8:	36373a63 63727300 5369752f 65657263     c:76.src/uiScree
c0d09ce8:	632e736e 0037373a                       ns.c:77.

c0d09cf0 <USBD_HID_Desc_fido>:
c0d09cf0:	01112109 22220121 00000000              .!..!.""....

c0d09cfc <USBD_HID_Desc>:
c0d09cfc:	01112109 22220100                        .!...."".

c0d09d05 <HID_ReportDesc_fido>:
c0d09d05:	09f1d006 0901a101 26001503 087500ff     ...........&..u.
c0d09d15:	08814095 00150409 7500ff26 91409508     .@......&..u..@.
c0d09d25:	                                         ..

c0d09d27 <HID_ReportDesc>:
c0d09d27:	09ffa006 0901a101 26001503 087500ff     ...........&..u.
c0d09d37:	08814095 00150409 7500ff26 91409508     .@......&..u..@.
c0d09d47:	                                         ..

c0d09d49 <C_usb_bos>:
c0d09d49:	00390f05 05101802 08b63800 a009a934     ..9......8..4...
c0d09d59:	a0fd8b47 b6158876 1e010065 05101c00     G...v...e.......
c0d09d69:	dd60df00 c74589d8 65d29c4c 8a649e9d     ..`...E.L..e..d.
c0d09d79:	0300009f 7700b206                        .......w...

c0d09d84 <HID_Desc>:
c0d09d84:	c0d07b19 c0d07b29 c0d07b39 c0d07b49     .{..){..9{..I{..
c0d09d94:	c0d07b59 c0d07b69 c0d07b79 c0d07b89     Y{..i{..y{...{..

c0d09da4 <C_winusb_string_descriptor>:
c0d09da4:	004d0312 00460053 00310054 00300030     ..M.S.F.T.1.0.0.
c0d09db4:	                                         w.

c0d09db6 <C_winusb_guid>:
c0d09db6:	00000092 00050100 00880001 00070000     ................
c0d09dc6:	002a0000 00650044 00690076 00650063     ..*.D.e.v.i.c.e.
c0d09dd6:	006e0049 00650074 00660072 00630061     I.n.t.e.r.f.a.c.
c0d09de6:	00470065 00490055 00730044 00500000     e.G.U.I.D.s...P.
c0d09df6:	007b0000 00330031 00360064 00340033     ..{.1.3.d.6.3.4.
c0d09e06:	00300030 0032002d 00390043 002d0037     0.0.-.2.C.9.7.-.
c0d09e16:	00300030 00340030 0030002d 00300030     0.0.0.4.-.0.0.0.
c0d09e26:	002d0030 00630034 00350036 00340036     0.-.4.c.6.5.6.4.
c0d09e36:	00370036 00350036 00320037 0000007d     6.7.6.5.7.2.}...
	...

c0d09e48 <C_winusb_request_descriptor>:
c0d09e48:	0000000a 06030000 000800b2 00000001     ................
c0d09e58:	000800a8 00020002 001400a0 49570003     ..............WI
c0d09e68:	4253554e 00000000 00000000 00840000     NUSB............
c0d09e78:	00070004 0044002a 00760065 00630069     ....*.D.e.v.i.c.
c0d09e88:	00490065 0074006e 00720065 00610066     e.I.n.t.e.r.f.a.
c0d09e98:	00650063 00550047 00440049 00000073     c.e.G.U.I.D.s...
c0d09ea8:	007b0050 00450043 00300038 00320039     P.{.C.E.8.0.9.2.
c0d09eb8:	00340036 0034002d 00320042 002d0034     6.4.-.4.B.2.4.-.
c0d09ec8:	00450034 00310038 0041002d 00420038     4.E.8.1.-.A.8.B.
c0d09ed8:	002d0032 00370035 00440045 00310030     2.-.5.7.E.D.0.1.
c0d09ee8:	00350044 00300038 00310045 0000007d     D.5.8.0.E.1.}...
c0d09ef8:	00000000                                ....

c0d09efc <USBD_HID>:
c0d09efc:	c0d078d5 c0d07907 c0d07841 00000000     .x...y..Ax......
c0d09f0c:	00000000 c0d07a1d c0d07a35 00000000     .....z..5z......
	...
c0d09f24:	c0d07cb1 c0d07cb1 c0d07cb1 c0d07cc1     .|...|...|...|..

c0d09f34 <USBD_U2F>:
c0d09f34:	c0d079a5 c0d07907 c0d07841 00000000     .y...y..Ax......
c0d09f44:	00000000 c0d079d9 c0d079f1 00000000     .....y...y......
	...
c0d09f5c:	c0d07cb1 c0d07cb1 c0d07cb1 c0d07cc1     .|...|...|...|..

c0d09f6c <USBD_WEBUSB>:
c0d09f6c:	c0d07a81 c0d07aad c0d07ab1 00000000     .z...z...z......
c0d09f7c:	00000000 c0d07ab5 c0d07acd 00000000     .....z...z......
	...
c0d09f94:	c0d07cb1 c0d07cb1 c0d07cb1 c0d07cc1     .|...|...|...|..

c0d09fa4 <USBD_DeviceDesc>:
c0d09fa4:	02100112 40000000 10152c97 02010201     .......@.,......
c0d09fb4:	                                         ..

c0d09fb6 <USBD_LangIDDesc>:
c0d09fb6:	04090304                                ....

c0d09fba <USBD_MANUFACTURER_STRING>:
c0d09fba:	004c030e 00640065 00650067               ..L.e.d.g.e.r.

c0d09fc8 <USBD_PRODUCT_FS_STRING>:
c0d09fc8:	004e030e 006e0061 0020006f               ..N.a.n.o. .S.

c0d09fd6 <USB_SERIAL_STRING>:
c0d09fd6:	0030030a 00300030                        ..0.0.0.1.

c0d09fe0 <C_winusb_wcid>:
c0d09fe0:	00000028 00040100 00000001 00000000     (...............
c0d09ff0:	49570102 4253554e 00000000 00000000     ..WINUSB........
	...

c0d0a008 <USBD_CfgDesc>:
c0d0a008:	00600209 c0020103 00040932 00030200     ..`.....2.......
c0d0a018:	21090200 01000111 07002222 40038205     ...!...."".....@
c0d0a028:	05070100 00400302 01040901 01030200     ......@.........
c0d0a038:	21090201 01210111 07002222 40038105     ...!..!."".....@
c0d0a048:	05070100 00400301 02040901 ffff0200     ......@.........
c0d0a058:	050702ff 00400383 03050701 01004003     ......@......@..

c0d0a068 <USBD_DeviceQualifierDesc>:
c0d0a068:	0200060a 40000000 00000001              .......@....

c0d0a074 <ux_menu_elements>:
c0d0a074:	00008003 00800000 00000020 00000001     ........ .......
c0d0a084:	00000000 00ffffff 00000000 00000000     ................
c0d0a094:	00038105 0007000e 00000004 00000000     ................
c0d0a0a4:	00ffffff 00000000 000b0000 00000000     ................
c0d0a0b4:	00768205 0007000e 00000004 00000000     ..v.............
c0d0a0c4:	00ffffff 00000000 000c0000 00000000     ................
c0d0a0d4:	000e4107 00640003 0000000c 00000000     .A....d.........
c0d0a0e4:	00ffffff 00000000 0000800a 00000000     ................
c0d0a0f4:	000e4207 00640023 0000000c 00000000     .B..#.d.........
c0d0a104:	00ffffff 00000000 0000800a 00000000     ................
c0d0a114:	000e1005 00000009 00000000 00000000     ................
c0d0a124:	00ffffff 00000000 00000000 00000000     ................
c0d0a134:	000e2007 00640013 0000000c 00000000     . ....d.........
c0d0a144:	00ffffff 00000000 00008008 00000000     ................
c0d0a154:	000e2107 0064000c 0000000c 00000000     .!....d.........
c0d0a164:	00ffffff 00000000 00008008 00000000     ................
c0d0a174:	000e2207 0064001a 0000000c 00000000     ."....d.........
c0d0a184:	00ffffff 00000000 00008008 00000000     ................

c0d0a194 <UX_MENU_END_ENTRY>:
	...

c0d0a1b0 <_etext>:
	...
