#include <bolos_target.h> // we need target definitions
#ifdef TARGET_NANOS

#include <os_io_seproxyhal.h>

#include "menu.h"
#include "getVersion.h"
#include "glyphs.h"
#include "utils.h"

// Here we define the main menu, using the Ledger-provided menu API. This menu
// turns out to be fairly unimportant for Nano S apps, since commands are sent
// by the computer instead of being initiated by the user. It typically just
// contains an idle screen and a version screen.

// This is a forward declaration, since menu_about needs to reference
// menu_main.
const ux_menu_entry_t menu_main[];

static const ux_menu_entry_t menu_about[] = {
	// I won't bother describing how menus work in detail, since it's fairly
	// self-evident and not very useful; but to save you some trouble, this
	// first element is defined with explicit fields, so you can see what they
	// all are.
	{
		.menu     = NULL,       // another menu entry, displayed when this item is "entered"
		.callback = NULL,       // a function that takes a userid, called when this item is entered
		.userid   = 0,          // a custom identifier, helpful for implementing custom menu behavior
		.icon     = NULL,       // the glyph displayed next to the item text
		.line1    = "Version",  // the first line of text
		.line2    = APPVERSION, // the second line of text; if NULL, line1 will be vertically centered
		.text_x   = 0,          // the x offset of the lines of text; only used if non-zero
		.icon_x   = 0,          // the x offset of the icon; only used if non-zero
	},
	// This element references a custom glyph, C_icon_back. This glyph is
	// defined in glyphs.c, which was generated by the Makefile from the
	// corresponding .gif file in the glyphs/ folder. If you drop your own
	// .gif files into this folder and run make, they will likewise become
	// available for use in your app. The SDK also defines a few built-in
	// icons, such as BAGL_GLYPH_ICON_CHECK, which you'll see in the screen
	// definitions later on.
	{menu_main, NULL, 0, &C_icon_back, "Back", NULL, 61, 40},
	UX_MENU_END,
};

void os_sched_exit_ui_callback(unsigned int userid MARK_UNUSED)
{
	os_sched_exit(BOLOS_UX_OK);
}

const ux_menu_entry_t menu_main[] = {
	#if defined(DEVEL) || defined(HEADLESS)
	{NULL, NULL, 0, NULL, "Warning:", "DEVEL version!", 0, 0},
	#else
	{NULL, NULL, 0, NULL, "Waiting for", "commands...", 0, 0},
	#endif
	{menu_about, NULL, 0, NULL, "About", NULL, 0, 0},
	{NULL, os_sched_exit_ui_callback, 0, &C_icon_dashboard, "Quit app", NULL, 50, 29},
	UX_MENU_END,
};

#endif
