from signalHelper import stringAllignment, stringToSignal

assert stringAllignment("ACAATG", "ACAATG") == ("ACAATG", "ACAATG")
assert stringAllignment("ACXAATG", "ACAATG") == ("ACXAATG", "AC-AATG")
assert stringAllignment("TTT", "CCC") == ("---TTT", "CCC---")

from signalHelper import countDashes

assert countDashes("AAAC---AC--", 3) == 1
assert countDashes("AAAC---AC--", 2) == 1
assert countDashes("AAAC----A----", 4) == 2


x = [(1000, 0), (20000, 0), (2000, 1), (3000, 3), (50000, 12)]

x.sort()

endd = 0
for begg in range(len(x)-1):
    while endd != len(x):
        if x[begg][0] + 2000 >= x[endd][0]:
            endd += 1
        else:
            break
    print(f"Beg:{begg} and end:{endd}")
    for j in range(begg, endd):
        print(f"{x[j][0]}", end = " ")
    print()


import nadavca
from nadavca.dtw import KmerModel
import matplotlib
import matplotlib.pyplot as plt
from random import seed
from random import gauss

ref = "AACTGCATATCTTACTATGTCCTCTGCCGGTCTACTGGTCTATCTAAACTG"
kmerModelFilePath = "../../data/kmer_model.hdf5"
mod = KmerModel.load_from_hdf5(kmerModelFilePath)

import h5py

kmerFile = h5py.File(kmerModelFilePath, "r")
table = list(kmerFile["model"])
table = [(i[0].decode("ascii"), i[1], i[2]) for i in table]
table = {i[0]:(i[1], i[2]) for i in table}

signal1 = stringToSignal(ref, mod, repeatSignal=1)
signal2 = []

for i in range(len(ref)-6+1):
    kmer = ref[i:i+6]
    mean, std = table[kmer]
    signal2.append(mean)
    #signal2.append(gauss(mean, std))

fig, axs = plt.subplots(2)
fig.suptitle('Vertically stacked subplots')
axs[0].plot(signal1)
axs[1].plot(signal2)

plt.show()


