/*
 * Decompiled with CFR 0.152.
 */
package com.libfsm.operations.binary;

import com.libfsm.automata.helpers.Pair;
import com.libfsm.automata.helpers.Sets;
import com.libfsm.automata.machines.DFA;
import com.libfsm.automata.machines.FSM;
import com.libfsm.operations.binary.BinaryOperation;
import java.util.Map;
import java.util.Set;

class Intersection
implements BinaryOperation {
    private Map<Integer, String> steps = Map.ofEntries(Map.entry(0, "0. No special init step\n"), Map.entry(1, "1. In this step we set result's alphabet as intersection of alphabets of input automata"), Map.entry(2, "2. In this step we add cartesian product states into result"), Map.entry(3, "3. In this step we add transitions to result automaton in following way:\ndelta([q_x, q_y], c) <- [delta_first(q_x, c), delta_second(q_y, c)]"), Map.entry(4, "4. In this step we set state [first_initial, second_initial] as initial state of result"), Map.entry(5, "5. In this step we set final states in following way:\nif q_x is final in first automaton and q_y is final in second automaton, then [q_x, q_y] is final in result"), Map.entry(6, "Completed"));

    Intersection() {
    }

    @Override
    public FSM apply(FSM first, FSM second) {
        DFA result = new DFA(first.getName().concat(" intersection ").concat(second.getName()));
        Set<Character> alphabet = Sets.intersection(first.getAlphabet(), second.getAlphabet());
        result.setAlphabet(alphabet);
        Set<Pair<String, String>> product = Sets.cartesianProduct(first.getStates(), second.getStates());
        product.forEach(pair -> result.addState(pair.toString()));
        product.forEach(pair -> {
            alphabet.forEach(c -> result.addTransition(pair.toString(), (Character)c, new Pair<String, String>(first.computeStep(Set.of((String)pair.getFirst()), (Character)c).iterator().next(), second.computeStep(Set.of((String)pair.getSecond()), (Character)c).iterator().next()).toString()));
            if (first.isFinalState((String)pair.getFirst()) && second.isFinalState((String)pair.getSecond())) {
                result.addStateFinal(pair.toString());
            }
        });
        result.setInitial(new Pair<String, String>(first.getInitial(), second.getInitial()).toString());
        return result;
    }

    @Override
    public Map<Integer, String> getSteps() {
        return this.steps;
    }
}

