/*
 * Decompiled with CFR 0.152.
 */
package com.libfsm.automata.machines;

import com.libfsm.automata.helpers.Pair;
import com.libfsm.automata.helpers.Triple;
import com.libfsm.automata.machines.FSM;
import com.libfsm.automata.machines.FSMType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DFA
extends FSM {
    private Map<Pair<String, Character>, String> transitions = new HashMap<Pair<String, Character>, String>();

    public DFA(String name) {
        super(name);
        this.fsmType = FSMType.DFA;
    }

    @Override
    public void addState(String state) {
        this.states.add(state);
    }

    @Override
    public void removeState(String state) {
        this.states.remove(state);
        HashSet toRemove = new HashSet();
        this.transitions.forEach((key, value) -> {
            if (((String)key.getFirst()).equals(state) || value.equals(state)) {
                toRemove.add(new Triple<String, Character, String>((String)key.getFirst(), (Character)key.getSecond(), (String)value));
            }
        });
        toRemove.forEach(t -> this.removeTransition((String)t.getFirst(), (Character)t.getSecond(), (String)t.getThird()));
    }

    @Override
    public void renameState(String oldName, String newName) {
        if (!this.states.contains(oldName) || this.states.contains(newName)) {
            return;
        }
        HashSet oldNameTransitions = new HashSet();
        this.transitions.forEach((key, value) -> {
            if (((String)key.getFirst()).equals(oldName) || value.equals(oldName)) {
                oldNameTransitions.add(new Triple<String, Character, String>((String)key.getFirst(), (Character)key.getSecond(), (String)value));
            }
        });
        boolean oldNameFinal = this.isFinalState(oldName);
        boolean oldNameInitial = this.initial.equals(oldName);
        if (oldNameInitial) {
            this.initial = newName;
        }
        this.removeState(oldName);
        this.addState(newName);
        if (oldNameFinal) {
            this.removeStateFinal(oldName);
            this.addStateFinal(newName);
        }
        oldNameTransitions.forEach(t -> {
            this.removeTransition((String)t.getFirst(), (Character)t.getSecond(), (String)t.getThird());
            if (((String)t.getFirst()).equals(oldName) && ((String)t.getThird()).equals(oldName)) {
                this.addTransition(newName, (Character)t.getSecond(), newName);
            } else if (((String)t.getFirst()).equals(oldName)) {
                this.addTransition(newName, (Character)t.getSecond(), (String)t.getThird());
            } else if (((String)t.getThird()).equals(oldName)) {
                this.addTransition((String)t.getFirst(), (Character)t.getSecond(), newName);
            }
        });
    }

    @Override
    public void addTransition(String source, Character symbol, String destination) {
        if (this.states.contains(source) && this.states.contains(destination) && this.alphabet.contains(symbol)) {
            this.transitions.put(new Pair<String, Character>(source, symbol), destination);
        }
    }

    @Override
    public void removeTransition(String source, Character symbol, String destination) {
        if (this.states.contains(source) && this.states.contains(destination) && this.alphabet.contains(symbol)) {
            this.transitions.remove(new Pair<String, Character>(source, symbol), destination);
        }
    }

    @Override
    public Set<Character> getAllTransitionsFromTo(String source, String destination) {
        HashSet<Character> result = new HashSet<Character>();
        this.transitions.forEach((k, v) -> {
            if (((String)k.getFirst()).equals(source) && v.equals(destination)) {
                result.add((Character)k.getSecond());
            }
        });
        return result;
    }

    @Override
    public Map<Pair<String, Character>, Set<String>> getTransitions() {
        HashMap<Pair<String, Character>, Set<String>> result = new HashMap<Pair<String, Character>, Set<String>>();
        this.transitions.forEach((k, v) -> result.put((Pair<String, Character>)k, Set.of(v)));
        return result;
    }

    @Override
    public Set<Pair<Character, String>> getAllTransitionsFrom(String source) {
        return null;
    }

    @Override
    public Map<Pair<String, Character>, Set<String>> getEpsilonTransitions() {
        return new HashMap<Pair<String, Character>, Set<String>>();
    }

    @Override
    public void setAlphabet(Set<Character> alphabet) {
        this.alphabet.addAll(alphabet);
        HashSet toRemove = new HashSet();
        this.transitions.forEach((key, value) -> {
            if (!alphabet.contains(key.getSecond())) {
                toRemove.add(new Pair<String, Character>((String)key.getFirst(), (Character)key.getSecond()));
            }
        });
        toRemove.forEach(t -> this.transitions.remove(t));
    }

    @Override
    public Triple<Set<String>, Boolean, Integer> compute(String word, boolean verbose) {
        Set<String> currentStates = Set.of(this.initial);
        if (word.equals(EPSILON.toString())) {
            return new Triple<Set<String>, Boolean, Integer>(currentStates, currentStates.stream().allMatch(this::isFinalState), word.length());
        }
        for (int i = 0; i < word.length(); ++i) {
            if (!(currentStates = this.computeStep(currentStates, Character.valueOf(word.charAt(i)))).isEmpty()) continue;
            return new Triple<Set<String>, Boolean, Integer>(new HashSet(), false, i + 1);
        }
        return new Triple<Set<String>, Boolean, Integer>(currentStates, currentStates.stream().allMatch(this::isFinalState), word.length());
    }

    @Override
    public Set<String> computeStep(Set<String> states, Character c) {
        if (states.isEmpty() || !this.alphabet.contains(c)) {
            return new HashSet<String>();
        }
        return Set.of(this.transitions.get(new Pair<String, Character>(states.iterator().next(), c)));
    }

    @Override
    public Set<String> epsilonClosure(Set<String> states) {
        if (states.isEmpty()) {
            return new HashSet<String>();
        }
        return Set.of(states.iterator().next());
    }

    @Override
    public boolean isCorrectlyDefined() {
        if (this.initial.isEmpty() || this.alphabet.isEmpty() || this.states.isEmpty()) {
            return false;
        }
        for (String q : this.states) {
            for (Character c : this.alphabet) {
                if (this.transitions.containsKey(new Pair<String, Character>(q, c))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String notCorrectlyDefinedText() {
        return "DFA is not defined correctly! Please check alphabet/initial state/transition function.";
    }

    @Override
    public void writeToFile(File file) {
        try (PrintWriter printWriter = new PrintWriter(file);){
            printWriter.print(this);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public FSM copy() {
        DFA result = new DFA(this.name);
        this.states.forEach(result::addState);
        this.finalStates.forEach(result::addStateFinal);
        result.setAlphabet(this.alphabet);
        result.setInitial(this.initial);
        this.transitions.forEach((k, v) -> result.addTransition((String)k.getFirst(), (Character)k.getSecond(), (String)v));
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append("\n");
        sb.append("\t");
        sb.append("\"type\" : \"DFA\",").append("\n");
        String alphFormat = String.join((CharSequence)"', '", this.alphabet.stream().map(Object::toString).collect(Collectors.toSet()));
        sb.append("\t");
        sb.append("\"alphabet\" : ['");
        sb.append(alphFormat).append("'],").append("\n");
        String statesFormat = String.join((CharSequence)"\", \"", this.states);
        sb.append("\t");
        sb.append("\"states\" : [\"");
        sb.append(statesFormat).append("\"],").append("\n");
        HashSet transitionsFormat = new HashSet();
        this.transitions.forEach((key, value) -> transitionsFormat.add("\t\t{\n\t\t\t\"source\" : \"" + (String)key.getFirst() + "\",\n\t\t\t\"symbol\" : '" + key.getSecond() + "',\n\t\t\t\"destination\" : \"" + value + "\"\n\t\t}"));
        String transitionsFormatAll = String.join((CharSequence)",\n", transitionsFormat);
        sb.append("\t");
        sb.append("\"transitions\" : [").append("\n");
        sb.append(transitionsFormatAll).append("\n\t],");
        sb.append("\n\t\"initial\" : \"");
        sb.append(this.initial);
        sb.append("\",\n");
        sb.append("\t\"final_states\" : [\"");
        String finalFormat = String.join((CharSequence)"\", \"", this.finalStates);
        sb.append(finalFormat).append("\"]\n");
        sb.append("}");
        return sb.toString();
    }
}

