
import matplotlib.pyplot as plt

class Plotter:
    def __init__(self, method, png, argument_values, label):
        self._method = method
        self._png = png
        self._values = argument_values
        self._label = label
        self._precisions = []
        self._recalls = []
        self.plot()

    def make_step(self, x):
        precision, recall = self._method(x)
        self._precisions.append(precision)
        self._recalls.append(recall)
        print('{} = {}'.format(self._label, x))

    def plot(self):
        for x in self._values:
            self.make_step(x)
        plt.plot(self._values, self._precisions, label='PPV')
        plt.plot(self._values, self._recalls, label='TPR')
        plt.ylim((0, 1.05))
        plt.xlabel(self._label)
        plt.legend()
        plt.savefig(self._png)
        plt.clf()
