from setup_test import *

covid_reference_file = pathlib.Path(references_directory, 'covid_reference.fasta')
covid_reference = ref(covid_reference_file)

covid_bams = [pathlib.Path(bam_directory, 'covid.bam')]
covid_reads = fetch_reads(covid_bams)

covid_png_directory = pathlib.Path(png_directory, 'covid')

coverage = count_coverage(covid_reads)


for relative, absolute in [(0.4, 100), (0.2, 20), (0.3, 20), (0.4, 20)]:
    padding = 1

    freebayes_relative(reference=covid_reference, padding=padding,
                       png=pathlib.Path(png_directory,
                                        'freebayes_relative_absolute{}_padding{}_deletions.png'.format(absolute, padding)),
                       reads=covid_reads, coverage=coverage,
                       vcffile=pathlib.Path(vcf_directory, 'answers', 'covid_all.vcf'),
                       absolute=absolute, nsteps=10)

    freebayes_absolute(reference=covid_reference,
                       png=pathlib.Path(png_directory,
                                        'freebayes_absolute_relative{}_padding{}.png'.format(relative, padding)),
                       reads=covid_reads, coverage=coverage,
                       vcffile=pathlib.Path(vcf_directory, 'answers', 'covid_all.vcf'),
                       relative=relative, step=20, maximum=400, padding=padding)
